import{s as Ls,n as Ds,o as Ks}from"../chunks/scheduler.2595283c.js";import{S as Ps,i as Os,e as J,s as t,c as p,h as sl,a as h,d as a,b as e,f as _s,j as r,g as i,k as Ss,l as ll,m as n,n as c,t as M,o,p as y}from"../chunks/index.33db6c3c.js";import{C as m}from"../chunks/CodeBlock.009af97b.js";import{H as j,E as al}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c337a215.js";function nl(Rs){let U,O,K,ss,T,Vs='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',ls,w,as,u,ns,d,$s="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ts,g,Ys='<li><a href="inference/README">@huggingface/inference</a>: Use all supported (serverless) Inference Providers or switch to Inference Endpoints (dedicated) to make calls to 100,000+ Machine Learning models</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li> <li><a href="mcp-client/README">@huggingface/mcp-client</a>: A Model Context Protocol (MCP) client, and a tiny Agent library, built on top of InferenceClient.</li> <li><a href="gguf/README">@huggingface/gguf</a>: A GGUF parser that works on remotely hosted files.</li> <li><a href="dduf/README">@huggingface/dduf</a>: Similar package for DDUF (DDUF Diffusers Unified Format)</li> <li><a href="tasks/README">@huggingface/tasks</a>: The definition files and source-of-truth for the Hub’s main primitives like pipeline tasks, model libraries, etc.</li> <li><a href="jinja/README">@huggingface/jinja</a>: A minimalistic JS implementation of the Jinja templating engine, to be used for ML chat templates.</li> <li><a href="space-header/README">@huggingface/space-header</a>: Use the Space <code>mini_header</code> outside Hugging Face</li> <li><a href="ollama-utils/README">@huggingface/ollama-utils</a>: Various utilities for maintaining Ollama compatibility with models on the Hugging Face Hub.</li> <li><a href="tiny-agents/README">@huggingface/tiny-agents</a>: A tiny, model-agnostic library for building AI agents that can use tools.</li>',es,b,vs="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",ps,I,Xs="The libraries are still very young, please help us by opening issues!",is,f,cs,B,Ms,C,As="To install via NPM, you can download the libraries as needed:",os,G,ys,Z,qs="Then import the libraries in your code:",Js,Q,hs,N,rs,k,xs='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',js,E,ms,W,Us,S,Ts,R,ws,V,Fs='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',us,$,ds,Y,gs,v,bs,X,Is,A,fs,q,Bs,x,Hs="There are more features of course, check each library’s README!",Cs,F,Gs,H,Zs,z,Qs,_,Ns,L,zs="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",ks,D,Es,P,Ws;return w=new m({props:{code:"JTJGJTJGJTIwUHJvZ3JhbW1hdGljYWxseSUyMGludGVyYWN0JTIwd2l0aCUyMHRoZSUyMEh1YiUwQSUwQWF3YWl0JTIwY3JlYXRlUmVwbyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCJTIwdHlwZSUzQSUyMCUyMm1vZGVsJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMjAlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwVXNlJTIwYWxsJTIwc3VwcG9ydGVkJTIwSW5mZXJlbmNlJTIwUHJvdmlkZXJzISUwQSUwQWF3YWl0JTIwaW5mZXJlbmNlLmNoYXRDb21wbGV0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIyc2FtYmFub3ZhJTIyJTJDJTIwJTJGJTJGJTIwb3IlMjB0b2dldGhlciUyQyUyMGZhbC1haSUyQyUyMHJlcGxpY2F0ZSUyQyUyMGNvaGVyZSUyMCVFMiU4MCVBNiUwQSUyMCUyMG1lc3NhZ2VzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBjb250ZW50JTNBJTIwJTIySGVsbG8lMkMlMjBuaWNlJTIwdG8lMjBtZWV0JTIweW91ISUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0ElMjA1MTIlMkMlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDAuNSUyQyUwQSU3RCklM0IlMEElMEFhd2FpdCUyMGluZmVyZW5jZS50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIycmVwbGljYXRlJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTIyYSUyMHBpY3R1cmUlMjBvZiUyMGElMjBncmVlbiUyMGJpcmQlMjIlMkMlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwYW5kJTIwbXVjaCUyMG1vcmUlRTIlODAlQTY=",highlighted:`<span class="hljs-comment">// Programmatically interact with the Hub</span>

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span> },
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...)
  }
});

<span class="hljs-comment">// Use all supported Inference Providers!</span>

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// or together, fal-ai, replicate, cohere …</span>
  <span class="hljs-attr">messages</span>: [
    {
      <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span>,
    },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.5</span>,
});

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
});

<span class="hljs-comment">// and much more…</span>`,wrap:!1}}),u=new j({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),f=new j({props:{title:"Installation",local:"installation",headingTag:"h2"}}),B=new j({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),G=new m({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGbWNwLWNsaWVudA==",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/mcp-client`,wrap:!1}}),Q=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBNY3BDbGllbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZtY3AtY2xpZW50JTIyJTNCJTBBaW1wb3J0JTIwdHlwZSUyMCU3QiUyMFJlcG9JZCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQg==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">McpClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/mcp-client&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),N=new j({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),E=new m({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEluZmVyZW5jZUNsaWVudCUyMCU3RCUyMGZyb20lMjAnaHR0cHMlM0ElMkYlMkZjZG4uanNkZWxpdnIubmV0JTJGbnBtJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlNDA0LjkuMCUyRiUyQmVzbSclM0IlMEElMjAlMjAlMjAlMjBpbXBvcnQlMjAlN0IlMjBjcmVhdGVSZXBvJTJDJTIwY29tbWl0JTJDJTIwZGVsZXRlUmVwbyUyQyUyMGxpc3RGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjJodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkYlNDBodWdnaW5nZmFjZSUyRmh1YiU0MDIuNi44JTJGJTJCZXNtJTIyJTNCJTBBJTNDJTJGc2NyaXB0JTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@4.9.0/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@2.6.8/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),W=new j({props:{title:"Deno",local:"deno",headingTag:"h3"}}),S=new m({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlMEElMEFpbXBvcnQlMjAlN0IlMjBjcmVhdGVSZXBvJTJDJTIwY29tbWl0JTJDJTIwZGVsZXRlUmVwbyUyQyUyMGxpc3RGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjJodHRwcyUzQSUyRiUyRmVzbS5zaCUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTBBJTJGJTJGJTIwb3IlMjBucG0lM0ElMEFpbXBvcnQlMjAlN0IlMjBJbmZlcmVuY2VDbGllbnQlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlMEElMEFpbXBvcnQlMjAlN0IlMjBjcmVhdGVSZXBvJTJDJTIwY29tbWl0JTJDJTIwZGVsZXRlUmVwbyUyQyUyMGxpc3RGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),R=new j({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),$=new j({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),Y=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-comment">// Chat completion API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);

<span class="hljs-comment">// Streaming chat completion API</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> client.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>);
}

<span class="hljs-comment">/// Using a third-party provider:</span>
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// or together, fal-ai, replicate, cohere …</span>
})

<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;fal-ai&quot;</span>,
})



<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;My name is Wolfgang and I live in Amsterdam&quot;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&quot;en&quot;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&quot;fr&quot;</span>,
  },
});

<span class="hljs-comment">// pass multimodal files or URLs as inputs</span>
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
})

<span class="hljs-comment">// Using your own dedicated inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2Client = client.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2Client.<span class="hljs-title function_">textGeneration</span>({ <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span> });

<span class="hljs-comment">// Chat Completion</span>
<span class="hljs-keyword">const</span> llamaEndpoint = client.<span class="hljs-title function_">endpoint</span>(
  <span class="hljs-string">&quot;https://router.huggingface.co/hf-inference/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> llamaEndpoint.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);`,wrap:!1}}),v=new j({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),X=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMjAlMkYlMkYlMjBvciUyMCU3QiUyMHR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbmxwLXRlc3QlMjIlMjAlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjBkZWxldGVGaWxlcyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCJTIwdHlwZSUzQSUyMCUyMnNwYWNlJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZteS1zcGFjZSUyMiUyMCU3RCUyQyUyMCUyRiUyRiUyMG9yJTIwJTIyc3BhY2VzJTJGbXktdXNlciUyRm15LXNwYWNlJTIyJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMHBhdGhzJTNBJTIwJTVCJTIyUkVBRE1FLm1kJTIyJTJDJTIwJTIyLmdpdGF0dHJpYnV0ZXMlMjIlNUQlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or { type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot; },</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...)
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span> }, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),A=new j({props:{title:"@huggingface/mcp-client example",local:"huggingfacemcp-client-example",headingTag:"h3"}}),q=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwQWdlbnQlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGbWNwLWNsaWVudCclM0IlMEElMEFjb25zdCUyMEhGX1RPS0VOJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTNCJTBBJTBBY29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEFnZW50KCU3QiUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwYXBpS2V5JTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjBzZXJ2ZXJzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwUGxheXdyaWdodCUyME1DUCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNvbW1hbmQlM0ElMjAlMjJucHglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNBJTIwJTVCJTIyJTQwcGxheXdyaWdodCUyRm1jcCU0MGxhdGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSU3RCklM0IlMEElMEFhd2FpdCUyMGFnZW50LmxvYWRUb29scygpJTNCJTBBJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwYWdlbnQucnVuKCUyMldoYXQlMjBhcmUlMjB0aGUlMjB0b3AlMjA1JTIwdHJlbmRpbmclMjBtb2RlbHMlMjBvbiUyMEh1Z2dpbmclMjBGYWNlJTNGJTIyKSklMjAlN0IlMEElMjAlMjAlMjAlMjBpZiUyMCglMjJjaG9pY2VzJTIyJTIwaW4lMjBjaHVuayklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25zdCUyMGRlbHRhJTIwJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQlM0YuZGVsdGElM0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMChkZWx0YS5jb250ZW50KSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnNvbGUubG9nKGRlbHRhLmNvbnRlbnQpJTNCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">Agent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/mcp-client&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Agent</span>({
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;auto&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
  <span class="hljs-attr">apiKey</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">servers</span>: [
    {
      <span class="hljs-comment">// Playwright MCP</span>
      <span class="hljs-attr">command</span>: <span class="hljs-string">&quot;npx&quot;</span>,
      <span class="hljs-attr">args</span>: [<span class="hljs-string">&quot;@playwright/mcp@latest&quot;</span>],
    },
  ],
});

<span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">loadTools</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;What are the top 5 trending models on Hugging Face?&quot;</span>)) {
    <span class="hljs-keyword">if</span> (<span class="hljs-string">&quot;choices&quot;</span> <span class="hljs-keyword">in</span> chunk) {
        <span class="hljs-keyword">const</span> delta = chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>]?.<span class="hljs-property">delta</span>;
        <span class="hljs-keyword">if</span> (delta.<span class="hljs-property">content</span>) {
            <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(delta.<span class="hljs-property">content</span>);
        }
    }
}`,wrap:!1}}),F=new j({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),H=new m({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),z=new j({props:{title:"Building",local:"building",headingTag:"h2"}}),_=new m({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),D=new al({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/index.md"}}),{c(){U=J("meta"),O=t(),K=J("p"),ss=t(),T=J("p"),T.innerHTML=Vs,ls=t(),p(w.$$.fragment),as=t(),p(u.$$.fragment),ns=t(),d=J("p"),d.textContent=$s,ts=t(),g=J("ul"),g.innerHTML=Ys,es=t(),b=J("p"),b.textContent=vs,ps=t(),I=J("p"),I.textContent=Xs,is=t(),p(f.$$.fragment),cs=t(),p(B.$$.fragment),Ms=t(),C=J("p"),C.textContent=As,os=t(),p(G.$$.fragment),ys=t(),Z=J("p"),Z.textContent=qs,Js=t(),p(Q.$$.fragment),hs=t(),p(N.$$.fragment),rs=t(),k=J("p"),k.innerHTML=xs,js=t(),p(E.$$.fragment),ms=t(),p(W.$$.fragment),Us=t(),p(S.$$.fragment),Ts=t(),p(R.$$.fragment),ws=t(),V=J("p"),V.innerHTML=Fs,us=t(),p($.$$.fragment),ds=t(),p(Y.$$.fragment),gs=t(),p(v.$$.fragment),bs=t(),p(X.$$.fragment),Is=t(),p(A.$$.fragment),fs=t(),p(q.$$.fragment),Bs=t(),x=J("p"),x.textContent=Hs,Cs=t(),p(F.$$.fragment),Gs=t(),p(H.$$.fragment),Zs=t(),p(z.$$.fragment),Qs=t(),p(_.$$.fragment),Ns=t(),L=J("p"),L.innerHTML=zs,ks=t(),p(D.$$.fragment),Es=t(),P=J("p"),this.h()},l(s){const l=sl("svelte-u9bgzb",document.head);U=h(l,"META",{name:!0,content:!0}),l.forEach(a),O=e(s),K=h(s,"P",{}),_s(K).forEach(a),ss=e(s),T=h(s,"P",{align:!0,"data-svelte-h":!0}),r(T)!=="svelte-9rngw"&&(T.innerHTML=Vs),ls=e(s),i(w.$$.fragment,s),as=e(s),i(u.$$.fragment,s),ns=e(s),d=h(s,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1eufct4"&&(d.textContent=$s),ts=e(s),g=h(s,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-52p5el"&&(g.innerHTML=Ys),es=e(s),b=h(s,"P",{"data-svelte-h":!0}),r(b)!=="svelte-5pb56g"&&(b.textContent=vs),ps=e(s),I=h(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1vx14v7"&&(I.textContent=Xs),is=e(s),i(f.$$.fragment,s),cs=e(s),i(B.$$.fragment,s),Ms=e(s),C=h(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-18mxf19"&&(C.textContent=As),os=e(s),i(G.$$.fragment,s),ys=e(s),Z=h(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1fdwpsr"&&(Z.textContent=qs),Js=e(s),i(Q.$$.fragment,s),hs=e(s),i(N.$$.fragment,s),rs=e(s),k=h(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1td2f08"&&(k.innerHTML=xs),js=e(s),i(E.$$.fragment,s),ms=e(s),i(W.$$.fragment,s),Us=e(s),i(S.$$.fragment,s),Ts=e(s),i(R.$$.fragment,s),ws=e(s),V=h(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-mx6w21"&&(V.innerHTML=Fs),us=e(s),i($.$$.fragment,s),ds=e(s),i(Y.$$.fragment,s),gs=e(s),i(v.$$.fragment,s),bs=e(s),i(X.$$.fragment,s),Is=e(s),i(A.$$.fragment,s),fs=e(s),i(q.$$.fragment,s),Bs=e(s),x=h(s,"P",{"data-svelte-h":!0}),r(x)!=="svelte-16qnxzd"&&(x.textContent=Hs),Cs=e(s),i(F.$$.fragment,s),Gs=e(s),i(H.$$.fragment,s),Zs=e(s),i(z.$$.fragment,s),Qs=e(s),i(_.$$.fragment,s),Ns=e(s),L=h(s,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ymfi8c"&&(L.innerHTML=zs),ks=e(s),i(D.$$.fragment,s),Es=e(s),P=h(s,"P",{}),_s(P).forEach(a),this.h()},h(){Ss(U,"name","hf:doc:metadata"),Ss(U,"content",tl),Ss(T,"align","center")},m(s,l){ll(document.head,U),n(s,O,l),n(s,K,l),n(s,ss,l),n(s,T,l),n(s,ls,l),c(w,s,l),n(s,as,l),c(u,s,l),n(s,ns,l),n(s,d,l),n(s,ts,l),n(s,g,l),n(s,es,l),n(s,b,l),n(s,ps,l),n(s,I,l),n(s,is,l),c(f,s,l),n(s,cs,l),c(B,s,l),n(s,Ms,l),n(s,C,l),n(s,os,l),c(G,s,l),n(s,ys,l),n(s,Z,l),n(s,Js,l),c(Q,s,l),n(s,hs,l),c(N,s,l),n(s,rs,l),n(s,k,l),n(s,js,l),c(E,s,l),n(s,ms,l),c(W,s,l),n(s,Us,l),c(S,s,l),n(s,Ts,l),c(R,s,l),n(s,ws,l),n(s,V,l),n(s,us,l),c($,s,l),n(s,ds,l),c(Y,s,l),n(s,gs,l),c(v,s,l),n(s,bs,l),c(X,s,l),n(s,Is,l),c(A,s,l),n(s,fs,l),c(q,s,l),n(s,Bs,l),n(s,x,l),n(s,Cs,l),c(F,s,l),n(s,Gs,l),c(H,s,l),n(s,Zs,l),c(z,s,l),n(s,Qs,l),c(_,s,l),n(s,Ns,l),n(s,L,l),n(s,ks,l),c(D,s,l),n(s,Es,l),n(s,P,l),Ws=!0},p:Ds,i(s){Ws||(M(w.$$.fragment,s),M(u.$$.fragment,s),M(f.$$.fragment,s),M(B.$$.fragment,s),M(G.$$.fragment,s),M(Q.$$.fragment,s),M(N.$$.fragment,s),M(E.$$.fragment,s),M(W.$$.fragment,s),M(S.$$.fragment,s),M(R.$$.fragment,s),M($.$$.fragment,s),M(Y.$$.fragment,s),M(v.$$.fragment,s),M(X.$$.fragment,s),M(A.$$.fragment,s),M(q.$$.fragment,s),M(F.$$.fragment,s),M(H.$$.fragment,s),M(z.$$.fragment,s),M(_.$$.fragment,s),M(D.$$.fragment,s),Ws=!0)},o(s){o(w.$$.fragment,s),o(u.$$.fragment,s),o(f.$$.fragment,s),o(B.$$.fragment,s),o(G.$$.fragment,s),o(Q.$$.fragment,s),o(N.$$.fragment,s),o(E.$$.fragment,s),o(W.$$.fragment,s),o(S.$$.fragment,s),o(R.$$.fragment,s),o($.$$.fragment,s),o(Y.$$.fragment,s),o(v.$$.fragment,s),o(X.$$.fragment,s),o(A.$$.fragment,s),o(q.$$.fragment,s),o(F.$$.fragment,s),o(H.$$.fragment,s),o(z.$$.fragment,s),o(_.$$.fragment,s),o(D.$$.fragment,s),Ws=!1},d(s){s&&(a(O),a(K),a(ss),a(T),a(ls),a(as),a(ns),a(d),a(ts),a(g),a(es),a(b),a(ps),a(I),a(is),a(cs),a(Ms),a(C),a(os),a(ys),a(Z),a(Js),a(hs),a(rs),a(k),a(js),a(ms),a(Us),a(Ts),a(ws),a(V),a(us),a(ds),a(gs),a(bs),a(Is),a(fs),a(Bs),a(x),a(Cs),a(Gs),a(Zs),a(Qs),a(Ns),a(L),a(ks),a(Es),a(P)),a(U),y(w,s),y(u,s),y(f,s),y(B,s),y(G,s),y(Q,s),y(N,s),y(E,s),y(W,s),y(S,s),y(R,s),y($,s),y(Y,s),y(v,s),y(X,s),y(A,s),y(q,s),y(F,s),y(H,s),y(z,s),y(_,s),y(D,s)}}}const tl='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3},{"title":"@huggingface/mcp-client example","local":"huggingfacemcp-client-example","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function el(Rs){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Ps{constructor(U){super(),Os(this,U,el,nl,Ls,{})}}export{ol as component};
