import{s as ao,f as Va,n as to,o as Uo}from"../chunks/scheduler.65852ee5.js";import{S as lo,i as oo,g as j,s as l,r as s,A as so,h as F,f as t,c as o,j as Ao,u as n,x as M,k as c,y as no,a as U,v as i,d as e,t as p,w as K}from"../chunks/index.aa74147d.js";import{D as io,C as r}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as R,E as eo}from"../chunks/EditOnGithub.4eda6a96.js";function po($U){let w,za,ka,Ca,u,Wa,b,Na,T,Al='<em>Authored by: <a href="https://github.com/sergiopaniego" rel="nofollow">Sergio Paniego</a></em>',Ia,f,al='In this notebook, we will fine-tune an <a href="https://huggingface.co/docs/transformers/tasks/object_detection" rel="nofollow">object detection</a> model—specifically, <a href="https://huggingface.co/docs/transformers/model_doc/detr" rel="nofollow">DETR</a>—using a custom dataset. We will leverage the <a href="https://huggingface.co/docs" rel="nofollow">Hugging Face ecosystem</a> to accomplish this task.',qa,B,tl='Our approach involves starting with a pretrained DETR model and fine-tuning it on a custom dataset of annotated fashion images, namely <a href="https://huggingface.co/datasets/detection-datasets/fashionpedia" rel="nofollow">Fashionpedia</a>. By doing so, we’ll adapt the model to better recognize and detect objects within the fashion domain.',Xa,P,Ul="After successfully fine-tuning the model, we will deploy it as a Gradio Space on Hugging Face. Additionally, we’ll explore how to interact with the deployed model using the Gradio API, enabling seamless communication with the hosted Space and unlocking new possibilities for real-world applications.",Qa,x,ll='<img src="https://github.com/facebookresearch/detr/raw/main/.github/DETR.png" alt="DETR architecture"/>',ha,V,Oa,d,ol="Let’s start by installing the necessary libraries for fine-tuning our object detection model.",Da,g,Za,G,va,y,sl,Ya,H,nl='📁 The dataset we will use is <a href="https://huggingface.co/datasets/detection-datasets/fashionpedia" rel="nofollow">Fashionpedia</a>, which comes from the paper <a href="https://arxiv.org/abs/2004.12276" rel="nofollow">Fashionpedia: Ontology, Segmentation, and an Attribute Localization Dataset</a>. The authors describe it as follows:',La,k,Ea,S,il="The dataset includes:",_a,z,el="<li><strong>46,781 images</strong> 🖼</li> <li><strong>342,182 bounding boxes</strong> 📦</li>",$a,C,pl='It is available on Hugging Face: <a href="https://huggingface.co/datasets/detection-datasets/fashionpedia" rel="nofollow">Fashionpedia Dataset</a>',At,W,at,N,tt,I,Kl="Review the internal structure of one of the examples",Ut,q,lt,X,ot,Q,jl="The dataset comes with two splits: <strong>train</strong> and <strong>test</strong>. We will use the training split to fine-tune the model and the test split for validation.",st,h,nt,O,Fl="<strong>Optional</strong>",it,D,Ml="In the next commented cell, we randomly sample 1% of the original dataset for both the training and test splits. This approach is used to speed up the training process, as the dataset contains a large number of examples.",et,Z,rl="For the best results, we recommend skipping these two cells and using the full dataset. However, you can uncomment them if needed.",pt,v,Kt,Y,jt,L,Rl="Now that we’ve loaded the dataset, let’s visualize an example along with its annotated objects.",Ft,E,Mt,_,cl="These variables contain the mappings between object IDs and their corresponding labels. <code>id2label</code> maps from IDs to labels, while <code>label2id</code> maps from labels to IDs.",rt,$,Rt,AA,ct,aA,wl="Now, let’s visualize one image from the dataset to better understand what it looks like.",wt,tA,yt,UA,yl=`&#123;'bbox_id': [158977, 158978, 158979, 158980, 158981, 158982, 158983], 'category': [1, 23, 23, 6, 31, 31, 33], 'bbox': [[210.0, 225.0, 536.0, 784.0], [290.0, 897.0, 350.0, 1015.0], [464.0, 950.0, 534.0, 1021.0], [313.0, 407.0, 524.0, 954.0], [268.0, 229.0, 333.0, 563.0], [489.0, 247.0, 528.0, 591.0], [387.0, 225.0, 450.0, 253.0]], 'area': [69960, 2449, 1788, 75418, 15149, 5998, 479]}
`,Jt,lA,mt,oA,Jl="Now, let’s take a look at a few more images from the dataset to get a broader view of the data.",ut,sA,bt,nA,ml=`&#123;'bbox_id': [150311, 150312, 150313, 150314], 'category': [23, 23, 33, 10], 'bbox': [[445.0, 910.0, 505.0, 983.0], [239.0, 940.0, 284.0, 994.0], [298.0, 282.0, 386.0, 352.0], [210.0, 282.0, 448.0, 665.0]], 'area': [1422, 843, 373, 56375]}
&#123;'bbox_id': [158953, 158954, 158955, 158956, 158957, 158958, 158959, 158960, 158961, 158962], 'category': [2, 33, 31, 31, 13, 7, 22, 22, 23, 23], 'bbox': [[182.0, 220.0, 472.0, 647.0], [294.0, 221.0, 407.0, 257.0], [405.0, 297.0, 472.0, 647.0], [182.0, 264.0, 266.0, 621.0], [284.0, 135.0, 372.0, 169.0], [238.0, 537.0, 414.0, 606.0], [351.0, 732.0, 417.0, 922.0], [202.0, 749.0, 270.0, 930.0], [200.0, 921.0, 256.0, 979.0], [373.0, 903.0, 455.0, 966.0]], 'area': [87267, 1220, 16895, 18541, 1468, 9360, 8629, 8270, 2717, 3121]}
&#123;'bbox_id': [169196, 169197, 169198, 169199, 169200, 169201, 169202, 169203, 169204, 169205, 169206, 169207, 169208, 169209, 169210], 'category': [13, 29, 28, 32, 32, 31, 31, 0, 31, 31, 18, 4, 6, 23, 23], 'bbox': [[441.0, 132.0, 499.0, 150.0], [412.0, 164.0, 494.0, 295.0], [427.0, 164.0, 476.0, 207.0], [406.0, 326.0, 448.0, 335.0], [484.0, 327.0, 508.0, 334.0], [366.0, 323.0, 395.0, 372.0], [496.0, 271.0, 523.0, 302.0], [366.0, 164.0, 523.0, 372.0], [360.0, 186.0, 406.0, 332.0], [502.0, 201.0, 534.0, 321.0], [496.0, 259.0, 515.0, 278.0], [360.0, 164.0, 534.0, 411.0], [403.0, 384.0, 510.0, 638.0], [393.0, 584.0, 430.0, 663.0], [449.0, 638.0, 518.0, 681.0]], 'area': [587, 2922, 931, 262, 111, 1171, 540, 3981, 4457, 1724, 188, 26621, 16954, 2167, 1773]}
&#123;'bbox_id': [167967, 167968, 167969, 167970, 167971, 167972, 167973, 167974, 167975, 167976, 167977, 167978, 167979, 167980, 167981, 167982, 167983, 167984, 167985, 167986, 167987, 167988, 167989, 167990, 167991, 167992, 167993, 167994, 167995, 167996, 167997, 167998, 167999, 168000, 168001, 168002, 168003, 168004, 168005, 168006, 168007, 168008, 168009, 168010, 168011, 168012, 168013, 168014, 168015, 168016, 168017, 168018, 168019, 168020, 168021, 168022, 168023, 168024, 168025, 168026, 168027, 168028, 168029, 168030, 168031, 168032, 168033, 168034, 168035, 168036, 168037, 168038, 168039, 168040], 'category': [6, 23, 23, 31, 31, 4, 1, 35, 32, 35, 35, 35, 35, 28, 35, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 33], 'bbox': [[300.0, 421.0, 460.0, 846.0], [383.0, 841.0, 432.0, 899.0], [304.0, 740.0, 347.0, 831.0], [246.0, 222.0, 295.0, 505.0], [456.0, 229.0, 492.0, 517.0], [246.0, 169.0, 492.0, 517.0], [355.0, 213.0, 450.0, 433.0], [289.0, 353.0, 303.0, 427.0], [442.0, 288.0, 460.0, 340.0], [451.0, 290.0, 458.0, 304.0], [407.0, 238.0, 473.0, 486.0], [487.0, 501.0, 491.0, 517.0], [246.0, 455.0, 252.0, 505.0], [340.0, 169.0, 442.0, 238.0], [348.0, 230.0, 372.0, 476.0], [411.0, 179.0, 414.0, 182.0], [414.0, 183.0, 418.0, 186.0], [418.0, 187.0, 421.0, 190.0], [421.0, 192.0, 425.0, 195.0], [424.0, 196.0, 428.0, 199.0], [426.0, 200.0, 430.0, 204.0], [429.0, 204.0, 433.0, 208.0], [431.0, 209.0, 435.0, 213.0], [433.0, 214.0, 437.0, 218.0], [434.0, 218.0, 438.0, 222.0], [436.0, 223.0, 440.0, 226.0], [437.0, 227.0, 441.0, 231.0], [438.0, 232.0, 442.0, 235.0], [433.0, 232.0, 437.0, 236.0], [429.0, 233.0, 432.0, 237.0], [423.0, 233.0, 426.0, 237.0], [417.0, 233.0, 421.0, 237.0], [353.0, 172.0, 355.0, 174.0], [353.0, 175.0, 354.0, 177.0], [351.0, 178.0, 353.0, 181.0], [350.0, 182.0, 351.0, 184.0], [347.0, 187.0, 350.0, 189.0], [346.0, 190.0, 349.0, 193.0], [345.0, 194.0, 348.0, 197.0], [344.0, 199.0, 347.0, 202.0], [342.0, 204.0, 346.0, 207.0], [342.0, 208.0, 345.0, 211.0], [342.0, 212.0, 344.0, 215.0], [342.0, 217.0, 345.0, 220.0], [344.0, 221.0, 346.0, 224.0], [348.0, 222.0, 350.0, 225.0], [353.0, 223.0, 356.0, 226.0], [359.0, 223.0, 361.0, 226.0], [364.0, 223.0, 366.0, 226.0], [247.0, 448.0, 253.0, 454.0], [251.0, 454.0, 254.0, 456.0], [252.0, 460.0, 255.0, 463.0], [252.0, 466.0, 255.0, 469.0], [253.0, 471.0, 255.0, 475.0], [253.0, 478.0, 255.0, 481.0], [253.0, 483.0, 256.0, 486.0], [254.0, 489.0, 256.0, 492.0], [254.0, 495.0, 256.0, 497.0], [247.0, 457.0, 249.0, 460.0], [247.0, 463.0, 249.0, 466.0], [248.0, 469.0, 249.0, 471.0], [248.0, 476.0, 250.0, 478.0], [248.0, 481.0, 250.0, 483.0], [249.0, 486.0, 250.0, 488.0], [487.0, 459.0, 490.0, 461.0], [487.0, 465.0, 490.0, 467.0], [487.0, 471.0, 490.0, 472.0], [487.0, 476.0, 489.0, 478.0], [486.0, 482.0, 489.0, 484.0], [486.0, 488.0, 489.0, 490.0], [486.0, 494.0, 488.0, 496.0], [486.0, 500.0, 488.0, 501.0], [485.0, 505.0, 487.0, 507.0], [365.0, 213.0, 409.0, 226.0]], 'area': [44062, 2140, 2633, 9206, 5905, 44791, 12948, 211, 335, 43, 691, 62, 104, 2169, 439, 9, 10, 9, 8, 9, 14, 10, 13, 13, 11, 11, 10, 10, 12, 10, 10, 14, 4, 2, 4, 2, 5, 6, 7, 7, 8, 7, 6, 7, 5, 5, 7, 6, 5, 12, 5, 7, 8, 6, 6, 6, 4, 4, 6, 5, 2, 4, 4, 2, 6, 6, 3, 4, 6, 6, 4, 2, 4, 94]}
&#123;'bbox_id': [168041, 168042, 168043, 168044, 168045, 168046, 168047], 'category': [10, 32, 35, 31, 4, 29, 33], 'bbox': [[238.0, 309.0, 471.0, 1022.0], [234.0, 572.0, 331.0, 602.0], [235.0, 580.0, 324.0, 599.0], [119.0, 318.0, 343.0, 856.0], [111.0, 262.0, 518.0, 1022.0], [166.0, 262.0, 393.0, 492.0], [238.0, 309.0, 278.0, 324.0]], 'area': [12132, 1548, 755, 43926, 178328, 9316, 136]}
&#123;'bbox_id': [160050, 160051, 160052, 160053, 160054, 160055], 'category': [10, 31, 31, 23, 23, 33], 'bbox': [[290.0, 364.0, 429.0, 665.0], [304.0, 369.0, 397.0, 508.0], [290.0, 468.0, 310.0, 522.0], [213.0, 842.0, 294.0, 905.0], [446.0, 840.0, 536.0, 896.0], [311.0, 364.0, 354.0, 379.0]], 'area': [26873, 5301, 747, 1438, 1677, 71]}
&#123;'bbox_id': [160056, 160057, 160058, 160059, 160060, 160061, 160062, 160063, 160064, 160065, 160066], 'category': [10, 36, 42, 42, 42, 42, 42, 42, 42, 23, 33], 'bbox': [[127.0, 198.0, 451.0, 949.0], [277.0, 336.0, 319.0, 402.0], [340.0, 343.0, 344.0, 347.0], [321.0, 338.0, 327.0, 343.0], [336.0, 361.0, 342.0, 365.0], [329.0, 321.0, 333.0, 326.0], [313.0, 294.0, 319.0, 300.0], [330.0, 299.0, 334.0, 304.0], [295.0, 330.0, 300.0, 334.0], [332.0, 926.0, 376.0, 946.0], [284.0, 198.0, 412.0, 270.0]], 'area': [137575, 1915, 14, 24, 18, 15, 25, 16, 16, 740, 586]}
&#123;'bbox_id': [158963, 158964, 158965, 158966, 158967, 158968, 158969, 158970, 158971], 'category': [1, 31, 31, 7, 22, 22, 23, 23, 33], 'bbox': [[262.0, 449.0, 435.0, 686.0], [399.0, 471.0, 435.0, 686.0], [262.0, 451.0, 294.0, 662.0], [276.0, 603.0, 423.0, 726.0], [291.0, 759.0, 343.0, 934.0], [341.0, 749.0, 401.0, 947.0], [302.0, 919.0, 337.0, 994.0], [323.0, 925.0, 374.0, 1005.0], [343.0, 456.0, 366.0, 467.0]], 'area': [22330, 4422, 4846, 14000, 6190, 6997, 1547, 2107, 49]}
&#123;'bbox_id': [158972, 158973, 158974, 158975, 158976], 'category': [23, 23, 28, 10, 5], 'bbox': [[412.0, 588.0, 451.0, 631.0], [333.0, 585.0, 357.0, 627.0], [361.0, 243.0, 396.0, 257.0], [303.0, 243.0, 447.0, 517.0], [330.0, 259.0, 425.0, 324.0]], 'area': [949, 737, 133, 17839, 2916]}
`,Tt,iA,ft,eA,ul="As the first step in preprocessing the dataset, we will filter out some invalid bounding boxes. After reviewing the dataset, we found that some bounding boxes did not have a valid structure. Therefore, we will discard these invalid entries.",Bt,pA,Pt,KA,bl=`Image with invalid bbox: 8396 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 139952 - category: 42
Image with invalid bbox: 19725 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 23298 - category: 42
Image with invalid bbox: 19725 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 23299 - category: 42
Image with invalid bbox: 21696 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 277148 - category: 42
Image with invalid bbox: 23055 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 287029 - category: 33
Image with invalid bbox: 23671 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 290142 - category: 42
Image with invalid bbox: 26549 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 311943 - category: 37
Image with invalid bbox: 26834 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 309141 - category: 37
Image with invalid bbox: 31748 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 262063 - category: 42
Image with invalid bbox: 34253 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 315750 - category: 19
`,xt,jA,Vt,FA,Tl=`Dataset(&#123;
    features: ['image_id', 'image', 'width', 'height', 'objects'],
    num_rows: 45623
})
Dataset(&#123;
    features: ['image_id', 'image', 'width', 'height', 'objects'],
    num_rows: 1158
})
`,dt,MA,gt,rA,fl="Let’s explore the dataset further by plotting the occurrences of each class. This will help us understand the distribution of classes and identify any potential biases.",Gt,RA,Ht,cA,kt,da,Bl,St,wA,Pl="We can observe that some classes, such as “shoe” or “sleeve,” are overrepresented in the dataset. This indicates that the dataset may have an imbalance, with certain classes appearing more frequently than others. Identifying these imbalances is crucial for addressing potential biases in model training.",zt,yA,Ct,JA,xl='Data augmentation 🪄 is crucial for enhancing performance in object detection tasks. In this section, we will leverage the capabilities of <a href="https://albumentations.ai/" rel="nofollow">Albumentations</a> to augment our dataset effectively.',Wt,mA,Vl="Albumentations provides a range of powerful augmentation techniques tailored for object detection. It allows for various transformations, all while ensuring that bounding boxes are accurately adjusted. These capabilities help in generating a more diverse dataset, improving the model’s robustness and generalization.",Nt,J,dl,It,uA,qt,bA,Xt,TA,gl='We will instantiate the image processor using a pretrained model checkpoint. In this case, we are using the <a href="https://huggingface.co/facebook/detr-resnet-50-dc5" rel="nofollow">facebook/detr-resnet-50-dc5</a> model.',Qt,fA,ht,BA,Ot,PA,Gl="We will now add methods to process the dataset. These methods will handle tasks such as transforming images and annotations to ensure they are compatible with the model.",Dt,xA,Zt,VA,vt,dA,Hl="We are nearing the model training phase! Before proceeding, let’s visualize some samples after augmentation. This will allow us to double-check that the augmentations are suitable and effective for the training process.",Yt,gA,Lt,ga,kl,Et,GA,_t,HA,Sl="We will initialize the model using the same checkpoint as the image processor. This involves loading a pretrained model that we will fine-tune for our specific dataset.",$t,kA,AU,SA,aU,zA,tU,CA,zl="We will connect to the Hugging Face Hub to upload our fine-tuned model. This allows us to share and deploy the model for others to use or for further evaluation.",UU,WA,lU,NA,oU,IA,Cl='Next, we will set up the training arguments, connect to <a href="https://wandb.ai/" rel="nofollow">Weights &amp; Biases (W&amp;B)</a>, and start the training process. W&amp;B will help us track experiments, visualize metrics, and manage our model training workflow.',sU,qA,nU,XA,iU,QA,eU,hA,pU,OA,Wl="Now it’s time to start training the model. Let’s run the training process and watch how our fine-tuned model learns from the data!",KU,DA,Nl="First, we declare the <code>compute_metrics</code> method for calculating the metrics on evaluation.",jU,ZA,FU,vA,MU,YA,rU,LA,RU,EA,cU,_A,wU,$A,Il="Now that the model is trained, we can evaluate its performance on a test image. Since the model is available as a Hugging Face model, making predictions is straightforward. In the following cell, we will demonstrate how to run inference on a new image and assess the model’s capabilities.",yU,Aa,JU,aa,mU,ta,ql="We’ll display the results of the model’s predictions on the test image. This will give us insight into how well the model performs and highlight its strengths and areas for improvement.",uU,Ua,bU,la,TU,Ga,Xl,fU,oa,BU,sa,Ql="After training and visualizing the results for a test image, we will evaluate the model on the entire test dataset. This step involves generating metrics to assess the overall performance and effectiveness of the model across the full range of test samples.",PU,na,xU,ia,VU,m,hl,dU,ea,Ol="Now that our model is available on Hugging Face, we can deploy it in a HF Space. Hugging Face provides free Spaces for small applications, allowing us to create an interactive web application where users can upload test images and evaluate the model’s capabilities.",gU,pa,Dl='I’ve created an example application here: <a href="https://huggingface.co/spaces/sergiopaniego/DETR_object_detection_fashionpedia-finetuned" rel="nofollow">DETR Object Detection Fashionpedia - Fine-Tuned</a>',GU,Ka,HU,ja,kU,Fa,Zl="You can create a new application by copying and pasting the following code into a file named <code>app.py</code>.",SU,Ma,zU,ra,CU,Ra,vl="Don’t forget to create a <code>requirements.txt</code> file to specify the dependencies for the application.",WU,ca,NU,wa,IU,ya,Yl="One of the great features of Hugging Face Spaces is that they provide an API that can be accessed from outside applications. This makes it easy to integrate the model into various applications, whether they’re built with JavaScript, Python, or another language. Imagine the possibilities for expanding and utilizing your model’s capabilities!",qU,Ja,Ll='You can find more information on how to use the API here: <a href="https://huggingface.co/learn/cookbook/enterprise_cookbook_gradio" rel="nofollow">Hugging Face Enterprise Cookbook: Gradio</a>',XU,ma,QU,ua,hU,ba,OU,Ta,DU,Ha,El,ZU,fa,vU,Ba,_l="In this cookbook, we successfully fine-tuned an object detection model on a custom dataset and deployed it as a Gradio Space. We also demonstrated how to call the Space using the Gradio API, showcasing the ease of integrating it into various applications.",YU,Pa,$l="I hope this guide helps you in fine-tuning and deploying your own models with confidence! 🚀",LU,xa,EU,Sa,_U;return u=new io({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/ko-advanced-rag/notebooks/en/fine_tuning_detr_custom_dataset.ipynb"}]}}),b=new R({props:{title:"Fine-Tuning Object Detection on a Custom Dataset 🖼, Deployment in Spaces, and Gradio API Integration",local:"fine-tuning-object-detection-on-a-custom-dataset--deployment-in-spaces-and-gradio-api-integration",headingTag:"h1"}}),V=new R({props:{title:"1. Install Dependencies",local:"1-install-dependencies",headingTag:"h2"}}),g=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtVSUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlNUJ0b3JjaCU1RCUyMHRpbW0lMjB3YW5kYiUyMHRvcmNobWV0cmljcyUwQSUyMyUyMFRlc3RlZCUyMHdpdGglMjBkYXRhc2V0cyUzRCUzRDIuMjEuMCUyQyUyMHRyYW5zZm9ybWVycyUzRCUzRDQuNDQuMiUyMHRpbW0lM0QlM0QxLjAuOSUyQyUyMHdhbmRiJTNEJTNEMC4xNy45JTIwdG9yY2htZXRyaWNzJTNEJTNEMS40LjE=",highlighted:`!pip install -U -q datasets transformers[torch] timm wandb torchmetrics
<span class="hljs-comment"># Tested with datasets==2.21.0, transformers==4.44.2 timm==1.0.9, wandb==0.17.9 torchmetrics==1.4.1</span>`,wrap:!1}}),G=new R({props:{title:"2. Load Dataset 📁",local:"2-load-dataset-",headingTag:"h2"}}),k=new r({props:{code:"RmFzaGlvbnBlZGlhJTIwaXMlMjBhJTIwZGF0YXNldCUyMHdoaWNoJTIwY29uc2lzdHMlMjBvZiUyMHR3byUyMHBhcnRzJTNBJTIwKDEpJTIwYW4lMjBvbnRvbG9neSUyMGJ1aWx0JTIwYnklMjBmYXNoaW9uJTIwZXhwZXJ0cyUyMGNvbnRhaW5pbmclMjAyNyUyMG1haW4lMjBhcHBhcmVsJTIwY2F0ZWdvcmllcyUyQyUyMDE5JTIwYXBwYXJlbCUyMHBhcnRzJTJDJTIwMjk0JTIwZmluZS1ncmFpbmVkJTIwYXR0cmlidXRlcyUyMGFuZCUyMHRoZWlyJTIwcmVsYXRpb25zaGlwcyUzQiUyMCgyKSUyMGElMjBkYXRhc2V0JTIwd2l0aCUyMDQ4ayUyMGV2ZXJ5ZGF5JTIwYW5kJTIwY2VsZWJyaXR5JTIwZXZlbnQlMjBmYXNoaW9uJTIwaW1hZ2VzJTIwYW5ub3RhdGVkJTIwd2l0aCUyMHNlZ21lbnRhdGlvbiUyMG1hc2tzJTIwYW5kJTIwdGhlaXIlMjBhc3NvY2lhdGVkJTIwcGVyLW1hc2slMjBmaW5lLWdyYWluZWQlMjBhdHRyaWJ1dGVzJTJDJTIwYnVpbHQlMjB1cG9uJTIwdGhlJTIwRmFzaGlvbnBlZGlhJTIwb250b2xvZ3ku",highlighted:'Fashionpedia is a dataset which consists of two parts: (<span class="hljs-number">1</span>) an ontology <span class="hljs-keyword">built </span><span class="hljs-keyword">by </span>fashion experts containing <span class="hljs-number">27</span> main apparel categories, <span class="hljs-number">19</span> apparel parts, <span class="hljs-number">294</span> fine-grained attributes <span class="hljs-keyword">and </span>their relationships<span class="hljs-comment">; (2) a dataset with 48k everyday and celebrity event fashion images annotated with segmentation masks and their associated per-mask fine-grained attributes, built upon the Fashionpedia ontology.</span>',wrap:!1}}),W=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZXRlY3Rpb24tZGF0YXNldHMlMkZmYXNoaW9ucGVkaWElMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;detection-datasets/fashionpedia&quot;</span>)`,wrap:!1}}),N=new r({props:{code:"ZGF0YXNldA==",highlighted:"dataset",wrap:!1}}),q=new r({props:{code:"ZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RA==",highlighted:'dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]',wrap:!1}}),X=new R({props:{title:"3. Get Splits of the Dataset for Training and Testing ➗",local:"3-get-splits-of-the-dataset-for-training-and-testing-",headingTag:"h2"}}),h=new r({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUwQXRlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ2YWwlMjIlNUQ=",highlighted:`train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>]
test_dataset = dataset[<span class="hljs-string">&quot;val&quot;</span>]`,wrap:!1}}),v=new r({props:{code:"JTIyJTIyJTIyJTBBZGVmJTIwY3JlYXRlX3NhbXBsZShkYXRhc2V0JTJDJTIwc2FtcGxlX2ZyYWN0aW9uJTNEMC4wMSUyQyUyMHNlZWQlM0Q0MiklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGVfc2l6ZSUyMCUzRCUyMGludChzYW1wbGVfZnJhY3Rpb24lMjAqJTIwbGVuKGRhdGFzZXQpKSUwQSUyMCUyMCUyMCUyMHNhbXBsZWRfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2h1ZmZsZShzZWVkJTNEc2VlZCkuc2VsZWN0KHJhbmdlKHNhbXBsZV9zaXplKSklMEElMjAlMjAlMjAlMjBwcmludChmJTIyT3JpZ2luYWwlMjBzaXplJTNBJTIwJTdCbGVuKGRhdGFzZXQpJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJTYW1wbGUlMjBzaXplJTNBJTIwJTdCbGVuKHNhbXBsZWRfZGF0YXNldCklN0QlMjIpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlZF9kYXRhc2V0JTBBJTBBJTIzJTIwQXBwbHklMjBmdW5jdGlvbiUyMHRvJTIwYm90aCUyMHNwbGl0cyUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBjcmVhdGVfc2FtcGxlKHRyYWluX2RhdGFzZXQpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwY3JlYXRlX3NhbXBsZSh0ZXN0X2RhdGFzZXQpJTBBJTIyJTIyJTIy",highlighted:`<span class="hljs-string">&quot;&quot;&quot;
def create_sample(dataset, sample_fraction=0.01, seed=42):
    sample_size = int(sample_fraction * len(dataset))
    sampled_dataset = dataset.shuffle(seed=seed).select(range(sample_size))
    print(f&quot;Original size: {len(dataset)}&quot;)
    print(f&quot;Sample size: {len(sampled_dataset)}&quot;)
    return sampled_dataset

# Apply function to both splits
train_dataset = create_sample(train_dataset)
test_dataset = create_sample(test_dataset)
&quot;&quot;&quot;</span>`,wrap:!1}}),Y=new R({props:{title:"4. Visualize One Example from the Dataset with Its Objects 👀",local:"4-visualize-one-example-from-the-dataset-with-its-objects-",headingTag:"h2"}}),E=new R({props:{title:"Generate id2label and label2id",local:"generate-id2label-and-label2id",headingTag:"h3"}}),$=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw


id2label = {
    <span class="hljs-number">0</span>: <span class="hljs-string">&quot;shirt, blouse&quot;</span>,
    <span class="hljs-number">1</span>: <span class="hljs-string">&quot;top, t-shirt, sweatshirt&quot;</span>,
    <span class="hljs-number">2</span>: <span class="hljs-string">&quot;sweater&quot;</span>,
    <span class="hljs-number">3</span>: <span class="hljs-string">&quot;cardigan&quot;</span>,
    <span class="hljs-number">4</span>: <span class="hljs-string">&quot;jacket&quot;</span>,
    <span class="hljs-number">5</span>: <span class="hljs-string">&quot;vest&quot;</span>,
    <span class="hljs-number">6</span>: <span class="hljs-string">&quot;pants&quot;</span>,
    <span class="hljs-number">7</span>: <span class="hljs-string">&quot;shorts&quot;</span>,
    <span class="hljs-number">8</span>: <span class="hljs-string">&quot;skirt&quot;</span>,
    <span class="hljs-number">9</span>: <span class="hljs-string">&quot;coat&quot;</span>,
    <span class="hljs-number">10</span>: <span class="hljs-string">&quot;dress&quot;</span>,
    <span class="hljs-number">11</span>: <span class="hljs-string">&quot;jumpsuit&quot;</span>,
    <span class="hljs-number">12</span>: <span class="hljs-string">&quot;cape&quot;</span>,
    <span class="hljs-number">13</span>: <span class="hljs-string">&quot;glasses&quot;</span>,
    <span class="hljs-number">14</span>: <span class="hljs-string">&quot;hat&quot;</span>,
    <span class="hljs-number">15</span>: <span class="hljs-string">&quot;headband, head covering, hair accessory&quot;</span>,
    <span class="hljs-number">16</span>: <span class="hljs-string">&quot;tie&quot;</span>,
    <span class="hljs-number">17</span>: <span class="hljs-string">&quot;glove&quot;</span>,
    <span class="hljs-number">18</span>: <span class="hljs-string">&quot;watch&quot;</span>,
    <span class="hljs-number">19</span>: <span class="hljs-string">&quot;belt&quot;</span>,
    <span class="hljs-number">20</span>: <span class="hljs-string">&quot;leg warmer&quot;</span>,
    <span class="hljs-number">21</span>: <span class="hljs-string">&quot;tights, stockings&quot;</span>,
    <span class="hljs-number">22</span>: <span class="hljs-string">&quot;sock&quot;</span>,
    <span class="hljs-number">23</span>: <span class="hljs-string">&quot;shoe&quot;</span>,
    <span class="hljs-number">24</span>: <span class="hljs-string">&quot;bag, wallet&quot;</span>,
    <span class="hljs-number">25</span>: <span class="hljs-string">&quot;scarf&quot;</span>,
    <span class="hljs-number">26</span>: <span class="hljs-string">&quot;umbrella&quot;</span>,
    <span class="hljs-number">27</span>: <span class="hljs-string">&quot;hood&quot;</span>,
    <span class="hljs-number">28</span>: <span class="hljs-string">&quot;collar&quot;</span>,
    <span class="hljs-number">29</span>: <span class="hljs-string">&quot;lapel&quot;</span>,
    <span class="hljs-number">30</span>: <span class="hljs-string">&quot;epaulette&quot;</span>,
    <span class="hljs-number">31</span>: <span class="hljs-string">&quot;sleeve&quot;</span>,
    <span class="hljs-number">32</span>: <span class="hljs-string">&quot;pocket&quot;</span>,
    <span class="hljs-number">33</span>: <span class="hljs-string">&quot;neckline&quot;</span>,
    <span class="hljs-number">34</span>: <span class="hljs-string">&quot;buckle&quot;</span>,
    <span class="hljs-number">35</span>: <span class="hljs-string">&quot;zipper&quot;</span>,
    <span class="hljs-number">36</span>: <span class="hljs-string">&quot;applique&quot;</span>,
    <span class="hljs-number">37</span>: <span class="hljs-string">&quot;bead&quot;</span>,
    <span class="hljs-number">38</span>: <span class="hljs-string">&quot;bow&quot;</span>,
    <span class="hljs-number">39</span>: <span class="hljs-string">&quot;flower&quot;</span>,
    <span class="hljs-number">40</span>: <span class="hljs-string">&quot;fringe&quot;</span>,
    <span class="hljs-number">41</span>: <span class="hljs-string">&quot;ribbon&quot;</span>,
    <span class="hljs-number">42</span>: <span class="hljs-string">&quot;rivet&quot;</span>,
    <span class="hljs-number">43</span>: <span class="hljs-string">&quot;ruffle&quot;</span>,
    <span class="hljs-number">44</span>: <span class="hljs-string">&quot;sequin&quot;</span>,
    <span class="hljs-number">45</span>: <span class="hljs-string">&quot;tassel&quot;</span>,
}


label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}`,wrap:!1}}),AA=new R({props:{title:"Let’s Draw One Image! 🎨",local:"lets-draw-one-image-",headingTag:"h3"}}),tA=new r({props:{code:"ZGVmJTIwZHJhd19pbWFnZV9mcm9tX2lkeChkYXRhc2V0JTJDJTIwaWR4KSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUJpZHglNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHNhbXBsZSU1QiUyMmltYWdlJTIyJTVEJTBBJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnMlMjAlM0QlMjBzYW1wbGUlNUIlMjJvYmplY3RzJTIyJTVEJTBBJTIwJTIwJTIwJTIwZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUyMCUyMCUyMCUyMHdpZHRoJTJDJTIwaGVpZ2h0JTIwJTNEJTIwc2FtcGxlJTVCJTIyd2lkdGglMjIlNUQlMkMlMjBzYW1wbGUlNUIlMjJoZWlnaHQlMjIlNUQlMEElMEElMjAlMjAlMjAlMjBwcmludChhbm5vdGF0aW9ucyklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oYW5ub3RhdGlvbnMlNUIlMjJiYm94X2lkJTIyJTVEKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBib3glMjAlM0QlMjBhbm5vdGF0aW9ucyU1QiUyMmJib3glMjIlNUQlNUJpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweDElMkMlMjB5MSUyQyUyMHgyJTJDJTIweTIlMjAlM0QlMjB0dXBsZShib3gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHgxJTJDJTIweTElMkMlMjB4MiUyQyUyMHkyKSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4MSUyQyUyMHkxKSUyQyUyMGlkMmxhYmVsJTVCYW5ub3RhdGlvbnMlNUIlMjJjYXRlZ29yeSUyMiU1RCU1QmklNUQlNUQlMkMlMjBmaWxsJTNEJTIyZ3JlZW4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEElMEFkcmF3X2ltYWdlX2Zyb21faWR4KGRhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTIwaWR4JTNEMTApJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwdGVzdCUyMGNoYW5naW5nJTIwdGhpcyUyMGlk",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_image_from_idx</span>(<span class="hljs-params">dataset, idx</span>):
<span class="hljs-meta">... </span>    sample = dataset[idx]
<span class="hljs-meta">... </span>    image = sample[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>    annotations = sample[<span class="hljs-string">&quot;objects&quot;</span>]
<span class="hljs-meta">... </span>    draw = ImageDraw.Draw(image)
<span class="hljs-meta">... </span>    width, height = sample[<span class="hljs-string">&quot;width&quot;</span>], sample[<span class="hljs-string">&quot;height&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(annotations)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;bbox_id&quot;</span>])):
<span class="hljs-meta">... </span>        box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i]
<span class="hljs-meta">... </span>        x1, y1, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>        draw.rectangle((x1, y1, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>        draw.text((x1, y1), id2label[annotations[<span class="hljs-string">&quot;category&quot;</span>][i]], fill=<span class="hljs-string">&quot;green&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>draw_image_from_idx(dataset=train_dataset, idx=<span class="hljs-number">10</span>)  <span class="hljs-comment"># You can test changing this id</span>`,wrap:!1}}),lA=new R({props:{title:"Let’s Visualize Some More Images 📸",local:"lets-visualize-some-more-images-",headingTag:"h3"}}),sA=new r({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQSUwQWRlZiUyMHBsb3RfaW1hZ2VzKGRhdGFzZXQlMkMlMjBpbmRpY2VzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFBsb3QlMjBpbWFnZXMlMjBhbmQlMjB0aGVpciUyMGFubm90YXRpb25zLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG51bV9jb2xzJTIwJTNEJTIwMyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTIwJTNEJTIwaW50KG5wLmNlaWwobGVuKGluZGljZXMpJTIwJTJGJTIwbnVtX2NvbHMpKSUwQSUyMCUyMCUyMCUyMGZpZyUyQyUyMGF4ZXMlMjAlM0QlMjBwbHQuc3VicGxvdHMobnVtX3Jvd3MlMkMlMjBudW1fY29scyUyQyUyMGZpZ3NpemUlM0QoMTUlMkMlMjAxMCkpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGlkeCUyMGluJTIwZW51bWVyYXRlKGluZGljZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93JTIwJTNEJTIwaSUyMCUyRiUyRiUyMG51bV9jb2xzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sJTIwJTNEJTIwaSUyMCUyNSUyMG51bV9jb2xzJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBkcmF3X2ltYWdlX2Zyb21faWR4KGRhdGFzZXQlMkMlMjBpZHgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXhlcyU1QnJvdyUyQyUyMGNvbCU1RC5pbXNob3coaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXhlcyU1QnJvdyUyQyUyMGNvbCU1RC5heGlzKCUyMm9mZiUyMiklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBqJTIwaW4lMjByYW5nZShpJTIwJTJCJTIwMSUyQyUyMG51bV9yb3dzJTIwKiUyMG51bV9jb2xzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpZy5kZWxheGVzKGF4ZXMuZmxhdHRlbigpJTVCaiU1RCklMEElMEElMjAlMjAlMjAlMjBwbHQudGlnaHRfbGF5b3V0KCklMEElMjAlMjAlMjAlMjBwbHQuc2hvdygpJTBBJTBBJTBBcGxvdF9pbWFnZXModHJhaW5fZGF0YXNldCUyQyUyMHJhbmdlKDkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_images</span>(<span class="hljs-params">dataset, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Plot images and their annotations.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    num_cols = <span class="hljs-number">3</span>
<span class="hljs-meta">... </span>    num_rows = <span class="hljs-built_in">int</span>(np.ceil(<span class="hljs-built_in">len</span>(indices) / num_cols))
<span class="hljs-meta">... </span>    fig, axes = plt.subplots(num_rows, num_cols, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(indices):
<span class="hljs-meta">... </span>        row = i // num_cols
<span class="hljs-meta">... </span>        col = i % num_cols

<span class="hljs-meta">... </span>        image = draw_image_from_idx(dataset, idx)

<span class="hljs-meta">... </span>        axes[row, col].imshow(image)
<span class="hljs-meta">... </span>        axes[row, col].axis(<span class="hljs-string">&quot;off&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(i + <span class="hljs-number">1</span>, num_rows * num_cols):
<span class="hljs-meta">... </span>        fig.delaxes(axes.flatten()[j])

<span class="hljs-meta">... </span>    plt.tight_layout()
<span class="hljs-meta">... </span>    plt.show()


<span class="hljs-meta">&gt;&gt;&gt; </span>plot_images(train_dataset, <span class="hljs-built_in">range</span>(<span class="hljs-number">9</span>))`,wrap:!1}}),iA=new R({props:{title:"5. Filter Invalid Bboxes ❌",local:"5-filter-invalid-bboxes-",headingTag:"h2"}}),pA=new r({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">filter_invalid_bboxes</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    valid_bboxes = []
<span class="hljs-meta">... </span>    valid_bbox_ids = []
<span class="hljs-meta">... </span>    valid_categories = []
<span class="hljs-meta">... </span>    valid_areas = []

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, bbox <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox&quot;</span>]):
<span class="hljs-meta">... </span>        x_min, y_min, x_max, y_max = bbox[:<span class="hljs-number">4</span>]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> x_min &lt; x_max <span class="hljs-keyword">and</span> y_min &lt; y_max:
<span class="hljs-meta">... </span>            valid_bboxes.append(bbox)
<span class="hljs-meta">... </span>            valid_bbox_ids.append(example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox_id&quot;</span>][i])
<span class="hljs-meta">... </span>            valid_categories.append(example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;category&quot;</span>][i])
<span class="hljs-meta">... </span>            valid_areas.append(example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;area&quot;</span>][i])
<span class="hljs-meta">... </span>        <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>                <span class="hljs-string">f&quot;Image with invalid bbox: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;image_id&#x27;</span>]}</span> Invalid bbox detected and discarded: <span class="hljs-subst">{bbox}</span> - bbox_id: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;bbox_id&#x27;</span>][i]}</span> - category: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;category&#x27;</span>][i]}</span>&quot;</span>
<span class="hljs-meta">... </span>            )

<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox&quot;</span>] = valid_bboxes
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox_id&quot;</span>] = valid_bbox_ids
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;category&quot;</span>] = valid_categories
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;area&quot;</span>] = valid_areas

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example


<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = train_dataset.<span class="hljs-built_in">map</span>(filter_invalid_bboxes)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset = test_dataset.<span class="hljs-built_in">map</span>(filter_invalid_bboxes)`,wrap:!1}}),jA=new r({props:{code:"cHJpbnQodHJhaW5fZGF0YXNldCklMEFwcmludCh0ZXN0X2RhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(test_dataset)`,wrap:!1}}),MA=new R({props:{title:"6. Visualize Class Occurrences 👀",local:"6-visualize-class-occurrences-",headingTag:"h2"}}),RA=new r({props:{code:"aWRfbGlzdCUyMCUzRCUyMCU1QiU1RCUwQWNhdGVnb3J5X2V4YW1wbGVzJTIwJTNEJTIwJTdCJTdEJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwdHJhaW5fZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMGlkX2xpc3QlMjAlMkIlM0QlMjBleGFtcGxlJTVCJTIyb2JqZWN0cyUyMiU1RCU1QiUyMmJib3hfaWQlMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBjYXRlZ29yeSUyMGluJTIwZXhhbXBsZSU1QiUyMm9iamVjdHMlMjIlNUQlNUIlMjJjYXRlZ29yeSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaWQybGFiZWwlNUJjYXRlZ29yeSU1RCUyMG5vdCUyMGluJTIwY2F0ZWdvcnlfZXhhbXBsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXRlZ29yeV9leGFtcGxlcyU1QmlkMmxhYmVsJTVCY2F0ZWdvcnklNUQlNUQlMjAlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhdGVnb3J5X2V4YW1wbGVzJTVCaWQybGFiZWwlNUJjYXRlZ29yeSU1RCU1RCUyMCUyQiUzRCUyMDElMEElMEFpZF9saXN0LnNvcnQoKQ==",highlighted:`id_list = []
category_examples = {}
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> train_dataset:
    id_list += example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox_id&quot;</span>]
    <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;category&quot;</span>]:
        <span class="hljs-keyword">if</span> id2label[category] <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> category_examples:
            category_examples[id2label[category]] = <span class="hljs-number">1</span>
        <span class="hljs-keyword">else</span>:
            category_examples[id2label[category]] += <span class="hljs-number">1</span>

id_list.sort()`,wrap:!1}}),cA=new r({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWNhdGVnb3JpZXMlMjAlM0QlMjBsaXN0KGNhdGVnb3J5X2V4YW1wbGVzLmtleXMoKSklMEF2YWx1ZXMlMjAlM0QlMjBsaXN0KGNhdGVnb3J5X2V4YW1wbGVzLnZhbHVlcygpKSUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKGZpZ3NpemUlM0QoMTIlMkMlMjA4KSklMEElMEFiYXJzJTIwJTNEJTIwYXguYmFyKGNhdGVnb3JpZXMlMkMlMjB2YWx1ZXMlMkMlMjBjb2xvciUzRCUyMnNreWJsdWUlMjIpJTBBJTBBYXguc2V0X3hsYWJlbCglMjJDYXRlZ29yaWVzJTIyJTJDJTIwZm9udHNpemUlM0QxNCklMEFheC5zZXRfeWxhYmVsKCUyMk51bWJlciUyMG9mJTIwT2NjdXJyZW5jZXMlMjIlMkMlMjBmb250c2l6ZSUzRDE0KSUwQWF4LnNldF90aXRsZSglMjJOdW1iZXIlMjBvZiUyME9jY3VycmVuY2VzJTIwYnklMjBDYXRlZ29yeSUyMiUyQyUyMGZvbnRzaXplJTNEMTYpJTBBJTBBYXguc2V0X3h0aWNrbGFiZWxzKGNhdGVnb3JpZXMlMkMlMjByb3RhdGlvbiUzRDkwJTJDJTIwaGElM0QlMjJyaWdodCUyMiklMEFheC5ncmlkKGF4aXMlM0QlMjJ5JTIyJTJDJTIwbGluZXN0eWxlJTNEJTIyLS0lMjIlMkMlMjBhbHBoYSUzRDAuNyklMEElMEFmb3IlMjBiYXIlMjBpbiUyMGJhcnMlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBiYXIuZ2V0X2hlaWdodCgpJTBBJTIwJTIwJTIwJTIwYXgudGV4dChiYXIuZ2V0X3goKSUyMCUyQiUyMGJhci5nZXRfd2lkdGgoKSUyMCUyRiUyMDIuMCUyQyUyMGhlaWdodCUyQyUyMGYlMjIlN0JoZWlnaHQlN0QlMjIlMkMlMjBoYSUzRCUyMmNlbnRlciUyMiUyQyUyMHZhJTNEJTIyYm90dG9tJTIyJTJDJTIwZm9udHNpemUlM0QxMCklMEElMEFwbHQudGlnaHRfbGF5b3V0KCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>categories = <span class="hljs-built_in">list</span>(category_examples.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span>values = <span class="hljs-built_in">list</span>(category_examples.values())

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">8</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>bars = ax.bar(categories, values, color=<span class="hljs-string">&quot;skyblue&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ax.set_xlabel(<span class="hljs-string">&quot;Categories&quot;</span>, fontsize=<span class="hljs-number">14</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax.set_ylabel(<span class="hljs-string">&quot;Number of Occurrences&quot;</span>, fontsize=<span class="hljs-number">14</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax.set_title(<span class="hljs-string">&quot;Number of Occurrences by Category&quot;</span>, fontsize=<span class="hljs-number">16</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ax.set_xticklabels(categories, rotation=<span class="hljs-number">90</span>, ha=<span class="hljs-string">&quot;right&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax.grid(axis=<span class="hljs-string">&quot;y&quot;</span>, linestyle=<span class="hljs-string">&quot;--&quot;</span>, alpha=<span class="hljs-number">0.7</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> bar <span class="hljs-keyword">in</span> bars:
<span class="hljs-meta">... </span>    height = bar.get_height()
<span class="hljs-meta">... </span>    ax.text(bar.get_x() + bar.get_width() / <span class="hljs-number">2.0</span>, height, <span class="hljs-string">f&quot;<span class="hljs-subst">{height}</span>&quot;</span>, ha=<span class="hljs-string">&quot;center&quot;</span>, va=<span class="hljs-string">&quot;bottom&quot;</span>, fontsize=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.tight_layout()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),yA=new R({props:{title:"7. Add Data Augmentation to the Dataset",local:"7-add-data-augmentation-to-the-dataset",headingTag:"h2"}}),uA=new r({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMjBhcyUyMEElMEElMEF0cmFpbl90cmFuc2Zvcm0lMjAlM0QlMjBBLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5Mb25nZXN0TWF4U2l6ZSg1MDApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5QYWRJZk5lZWRlZCg1MDAlMkMlMjA1MDAlMkMlMjBib3JkZXJfbW9kZSUzRDAlMkMlMjB2YWx1ZSUzRCgwJTJDJTIwMCUyQyUyMDApKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEEuSG9yaXpvbnRhbEZsaXAocCUzRDAuNSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBLlJhbmRvbUJyaWdodG5lc3NDb250cmFzdChwJTNEMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEEuSHVlU2F0dXJhdGlvblZhbHVlKHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5Sb3RhdGUobGltaXQlM0QxMCUyQyUyMHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5SYW5kb21TY2FsZShzY2FsZV9saW1pdCUzRDAuMiUyQyUyMHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5HYXVzc2lhbkJsdXIocCUzRDAuNSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBLkdhdXNzTm9pc2UocCUzRDAuNSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBiYm94X3BhcmFtcyUzREEuQmJveFBhcmFtcyhmb3JtYXQlM0QlMjJwYXNjYWxfdm9jJTIyJTJDJTIwbGFiZWxfZmllbGRzJTNEJTVCJTIyY2F0ZWdvcnklMjIlNUQpJTJDJTBBKSUwQSUwQXZhbF90cmFuc2Zvcm0lMjAlM0QlMjBBLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5Mb25nZXN0TWF4U2l6ZSg1MDApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5QYWRJZk5lZWRlZCg1MDAlMkMlMjA1MDAlMkMlMjBib3JkZXJfbW9kZSUzRDAlMkMlMjB2YWx1ZSUzRCgwJTJDJTIwMCUyQyUyMDApKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGJib3hfcGFyYW1zJTNEQS5CYm94UGFyYW1zKGZvcm1hdCUzRCUyMnBhc2NhbF92b2MlMjIlMkMlMjBsYWJlbF9maWVsZHMlM0QlNUIlMjJjYXRlZ29yeSUyMiU1RCklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> albumentations <span class="hljs-keyword">as</span> A

train_transform = A.Compose(
    [
        A.LongestMaxSize(<span class="hljs-number">500</span>),
        A.PadIfNeeded(<span class="hljs-number">500</span>, <span class="hljs-number">500</span>, border_mode=<span class="hljs-number">0</span>, value=(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>)),
        A.HorizontalFlip(p=<span class="hljs-number">0.5</span>),
        A.RandomBrightnessContrast(p=<span class="hljs-number">0.5</span>),
        A.HueSaturationValue(p=<span class="hljs-number">0.5</span>),
        A.Rotate(limit=<span class="hljs-number">10</span>, p=<span class="hljs-number">0.5</span>),
        A.RandomScale(scale_limit=<span class="hljs-number">0.2</span>, p=<span class="hljs-number">0.5</span>),
        A.GaussianBlur(p=<span class="hljs-number">0.5</span>),
        A.GaussNoise(p=<span class="hljs-number">0.5</span>),
    ],
    bbox_params=A.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;pascal_voc&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
)

val_transform = A.Compose(
    [
        A.LongestMaxSize(<span class="hljs-number">500</span>),
        A.PadIfNeeded(<span class="hljs-number">500</span>, <span class="hljs-number">500</span>, border_mode=<span class="hljs-number">0</span>, value=(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>)),
    ],
    bbox_params=A.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;pascal_voc&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
)`,wrap:!1}}),bA=new R({props:{title:"8. Initialize Image Processor from Model Checkpoint 🎆",local:"8-initialize-image-processor-from-model-checkpoint-",headingTag:"h2"}}),fA=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwLWRjNSUyMiUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

checkpoint = <span class="hljs-string">&quot;facebook/detr-resnet-50-dc5&quot;</span>
image_processor = AutoImageProcessor.from_pretrained(checkpoint)`,wrap:!1}}),BA=new R({props:{title:"Adding Methods to Process the Dataset",local:"adding-methods-to-process-the-dataset",headingTag:"h3"}}),xA=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatted_anns</span>(<span class="hljs-params">image_id, category, area, bbox</span>):
    annotations = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(category)):
        new_ann = {
            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
            <span class="hljs-string">&quot;category_id&quot;</span>: category[i],
            <span class="hljs-string">&quot;isCrowd&quot;</span>: <span class="hljs-number">0</span>,
            <span class="hljs-string">&quot;area&quot;</span>: area[i],
            <span class="hljs-string">&quot;bbox&quot;</span>: <span class="hljs-built_in">list</span>(bbox[i]),
        }
        annotations.append(new_ann)

    <span class="hljs-keyword">return</span> annotations


<span class="hljs-keyword">def</span> <span class="hljs-title function_">convert_voc_to_coco</span>(<span class="hljs-params">bbox</span>):
    xmin, ymin, xmax, ymax = bbox
    width = xmax - xmin
    height = ymax - ymin
    <span class="hljs-keyword">return</span> [xmin, ymin, width, height]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_aug_ann</span>(<span class="hljs-params">examples, transform</span>):
    image_ids = examples[<span class="hljs-string">&quot;image_id&quot;</span>]
    images, bboxes, area, categories = [], [], [], []
    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;objects&quot;</span>]):
        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]
        out = transform(image=image, bboxes=objects[<span class="hljs-string">&quot;bbox&quot;</span>], category=objects[<span class="hljs-string">&quot;category&quot;</span>])

        area.append(objects[<span class="hljs-string">&quot;area&quot;</span>])
        images.append(out[<span class="hljs-string">&quot;image&quot;</span>])

        <span class="hljs-comment"># Convert to COCO format</span>
        converted_bboxes = [convert_voc_to_coco(bbox) <span class="hljs-keyword">for</span> bbox <span class="hljs-keyword">in</span> out[<span class="hljs-string">&quot;bboxes&quot;</span>]]
        bboxes.append(converted_bboxes)

        categories.append(out[<span class="hljs-string">&quot;category&quot;</span>])

    targets = [
        {<span class="hljs-string">&quot;image_id&quot;</span>: id_, <span class="hljs-string">&quot;annotations&quot;</span>: formatted_anns(id_, cat_, ar_, box_)}
        <span class="hljs-keyword">for</span> id_, cat_, ar_, box_ <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_ids, categories, area, bboxes)
    ]

    <span class="hljs-keyword">return</span> image_processor(images=images, annotations=targets, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_train</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> transform_aug_ann(examples, transform=train_transform)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_val</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> transform_aug_ann(examples, transform=val_transform)


train_dataset_transformed = train_dataset.with_transform(transform_train)
test_dataset_transformed = test_dataset.with_transform(transform_val)`,wrap:!1}}),VA=new R({props:{title:"9. Plot Augmented Examples 🎆",local:"9-plot-augmented-examples-",headingTag:"h2"}}),gA=new r({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Updated draw function to accept an optional transform</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_augmented_image_from_idx</span>(<span class="hljs-params">dataset, idx, transform=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    sample = dataset[idx]
<span class="hljs-meta">... </span>    image = sample[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>    annotations = sample[<span class="hljs-string">&quot;objects&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Convert image to RGB and NumPy array</span>
<span class="hljs-meta">... </span>    image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> transform:
<span class="hljs-meta">... </span>        augmented = transform(image=image, bboxes=annotations[<span class="hljs-string">&quot;bbox&quot;</span>], category=annotations[<span class="hljs-string">&quot;category&quot;</span>])
<span class="hljs-meta">... </span>        image = augmented[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>        annotations[<span class="hljs-string">&quot;bbox&quot;</span>] = augmented[<span class="hljs-string">&quot;bboxes&quot;</span>]
<span class="hljs-meta">... </span>        annotations[<span class="hljs-string">&quot;category&quot;</span>] = augmented[<span class="hljs-string">&quot;category&quot;</span>]

<span class="hljs-meta">... </span>    image = Image.fromarray(image[:, :, ::-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Convert back to PIL Image</span>
<span class="hljs-meta">... </span>    draw = ImageDraw.Draw(image)
<span class="hljs-meta">... </span>    width, height = sample[<span class="hljs-string">&quot;width&quot;</span>], sample[<span class="hljs-string">&quot;height&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;bbox_id&quot;</span>])):
<span class="hljs-meta">... </span>        box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i]
<span class="hljs-meta">... </span>        x1, y1, x2, y2 = <span class="hljs-built_in">tuple</span>(box)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Normalize coordinates if necessary</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-built_in">max</span>(box) &lt;= <span class="hljs-number">1.0</span>:
<span class="hljs-meta">... </span>            x1, y1 = <span class="hljs-built_in">int</span>(x1 * width), <span class="hljs-built_in">int</span>(y1 * height)
<span class="hljs-meta">... </span>            x2, y2 = <span class="hljs-built_in">int</span>(x2 * width), <span class="hljs-built_in">int</span>(y2 * height)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>            x1, y1 = <span class="hljs-built_in">int</span>(x1), <span class="hljs-built_in">int</span>(y1)
<span class="hljs-meta">... </span>            x2, y2 = <span class="hljs-built_in">int</span>(x2), <span class="hljs-built_in">int</span>(y2)

<span class="hljs-meta">... </span>        draw.rectangle((x1, y1, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>        draw.text((x1, y1), id2label[annotations[<span class="hljs-string">&quot;category&quot;</span>][i]], fill=<span class="hljs-string">&quot;green&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Updated plot function to include augmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_augmented_images</span>(<span class="hljs-params">dataset, indices, transform=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Plot images and their annotations with optional augmentation.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    num_rows = <span class="hljs-built_in">len</span>(indices) // <span class="hljs-number">3</span>
<span class="hljs-meta">... </span>    num_cols = <span class="hljs-number">3</span>
<span class="hljs-meta">... </span>    fig, axes = plt.subplots(num_rows, num_cols, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(indices):
<span class="hljs-meta">... </span>        row = i // num_cols
<span class="hljs-meta">... </span>        col = i % num_cols

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Draw augmented image</span>
<span class="hljs-meta">... </span>        image = draw_augmented_image_from_idx(dataset, idx, transform=transform)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Display image on the corresponding subplot</span>
<span class="hljs-meta">... </span>        axes[row, col].imshow(image)
<span class="hljs-meta">... </span>        axes[row, col].axis(<span class="hljs-string">&quot;off&quot;</span>)

<span class="hljs-meta">... </span>    plt.tight_layout()
<span class="hljs-meta">... </span>    plt.show()


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now use the function to plot augmented images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plot_augmented_images(train_dataset, <span class="hljs-built_in">range</span>(<span class="hljs-number">9</span>), transform=train_transform)`,wrap:!1}}),GA=new R({props:{title:"10. Initialize Model from Checkpoint",local:"10-initialize-model-from-checkpoint",headingTag:"h2"}}),kA=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjaGVja3BvaW50JTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsMmlkJTNEbGFiZWwyaWQlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForObjectDetection

model = AutoModelForObjectDetection.from_pretrained(
    checkpoint,
    id2label=id2label,
    label2id=label2id,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),SA=new r({props:{code:"b3V0cHV0X2RpciUyMCUzRCUyMCUyMmRldHItcmVzbmV0LTUwLWRjNS1mYXNoaW9ucGVkaWEtZmluZXR1bmVkJTIyJTIwJTIwJTIzJTIwY2hhbmdlJTIwdGhpcw==",highlighted:'output_dir = <span class="hljs-string">&quot;detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>  <span class="hljs-comment"># change this</span>',wrap:!1}}),zA=new R({props:{title:"10. Connect to HF Hub to Upload Fine-Tuned Model 🔌",local:"10-connect-to-hf-hub-to-upload-fine-tuned-model-",headingTag:"h2"}}),WA=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),NA=new R({props:{title:"11. Set Training Arguments, Connect to W&B, and Train!",local:"11-set-training-arguments-connect-to-wb-and-train",headingTag:"h2"}}),qA=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwYXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RvdXRwdXRfZGlyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDEwMDAwJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMWUtNCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ3YW5kYiUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX2V2YWxfbWV0cmljcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># Define the training arguments</span>

training_args = TrainingArguments(
    output_dir=output_dir,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=<span class="hljs-number">4</span>,
    max_steps=<span class="hljs-number">10000</span>,
    fp16=<span class="hljs-literal">True</span>,
    save_steps=<span class="hljs-number">10</span>,
    logging_steps=<span class="hljs-number">1</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    weight_decay=<span class="hljs-number">1e-4</span>,
    save_total_limit=<span class="hljs-number">2</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    eval_steps=<span class="hljs-number">50</span>,
    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    batch_eval_metrics=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),XA=new R({props:{title:"Connect to W&B to Track Training",local:"connect-to-wb-to-track-training",headingTag:"h3"}}),QA=new r({props:{code:"aW1wb3J0JTIwd2FuZGIlMEElMEF3YW5kYi5pbml0KCUwQSUyMCUyMCUyMCUyMHByb2plY3QlM0QlMjJkZXRyLXJlc25ldC01MC1kYzUtZmFzaGlvbnBlZGlhLWZpbmV0dW5lZCUyMiUyQyUyMCUyMCUyMyUyMGNoYW5nZSUyMHRoaXMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyZGV0ci1yZXNuZXQtNTAtZGM1LWZhc2hpb25wZWRpYS1maW5ldHVuZWQlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0aGlzJTBBJTIwJTIwJTIwJTIwY29uZmlnJTNEdHJhaW5pbmdfYXJncyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> wandb

wandb.init(
    project=<span class="hljs-string">&quot;detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>,  <span class="hljs-comment"># change this</span>
    name=<span class="hljs-string">&quot;detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>,  <span class="hljs-comment"># change this</span>
    config=training_args,
)`,wrap:!1}}),hA=new R({props:{title:"Let’s Train the Model! 🚀",local:"lets-train-the-model-",headingTag:"h3"}}),ZA=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.detection.mean_ap <span class="hljs-keyword">import</span> MeanAveragePrecision
<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> softmax


<span class="hljs-keyword">def</span> <span class="hljs-title function_">denormalize_boxes</span>(<span class="hljs-params">boxes, width, height</span>):
    boxes = boxes.clone()
    boxes[:, <span class="hljs-number">0</span>] *= width  <span class="hljs-comment"># xmin</span>
    boxes[:, <span class="hljs-number">1</span>] *= height  <span class="hljs-comment"># ymin</span>
    boxes[:, <span class="hljs-number">2</span>] *= width  <span class="hljs-comment"># xmax</span>
    boxes[:, <span class="hljs-number">3</span>] *= height  <span class="hljs-comment"># ymax</span>
    <span class="hljs-keyword">return</span> boxes


batch_metrics = []


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred, compute_result</span>):
    <span class="hljs-keyword">global</span> batch_metrics

    (loss_dict, scores, pred_boxes, last_hidden_state, encoder_last_hidden_state), labels = eval_pred

    image_sizes = []
    target = []
    <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> labels:

        image_sizes.append(label[<span class="hljs-string">&quot;orig_size&quot;</span>])
        width, height = label[<span class="hljs-string">&quot;orig_size&quot;</span>]
        denormalized_boxes = denormalize_boxes(label[<span class="hljs-string">&quot;boxes&quot;</span>], width, height)
        target.append(
            {
                <span class="hljs-string">&quot;boxes&quot;</span>: denormalized_boxes,
                <span class="hljs-string">&quot;labels&quot;</span>: label[<span class="hljs-string">&quot;class_labels&quot;</span>],
            }
        )
    predictions = []
    <span class="hljs-keyword">for</span> score, box, target_sizes <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(scores, pred_boxes, image_sizes):
        <span class="hljs-comment"># Extract the bounding boxes, labels, and scores from the model&#x27;s output</span>
        pred_scores = score[:, :-<span class="hljs-number">1</span>]  <span class="hljs-comment"># Exclude the no-object class</span>
        pred_scores = softmax(pred_scores, dim=-<span class="hljs-number">1</span>)
        width, height = target_sizes
        pred_boxes = denormalize_boxes(box, width, height)
        pred_labels = torch.argmax(pred_scores, dim=-<span class="hljs-number">1</span>)

        <span class="hljs-comment"># Get the scores corresponding to the predicted labels</span>
        pred_scores_for_labels = torch.gather(pred_scores, <span class="hljs-number">1</span>, pred_labels.unsqueeze(-<span class="hljs-number">1</span>)).squeeze(-<span class="hljs-number">1</span>)
        predictions.append(
            {
                <span class="hljs-string">&quot;boxes&quot;</span>: pred_boxes,
                <span class="hljs-string">&quot;scores&quot;</span>: pred_scores_for_labels,
                <span class="hljs-string">&quot;labels&quot;</span>: pred_labels,
            }
        )

    metric = MeanAveragePrecision(box_format=<span class="hljs-string">&quot;xywh&quot;</span>, class_metrics=<span class="hljs-literal">True</span>)

    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> compute_result:
        <span class="hljs-comment"># Accumulate batch-level metrics</span>
        batch_metrics.append({<span class="hljs-string">&quot;preds&quot;</span>: predictions, <span class="hljs-string">&quot;target&quot;</span>: target})
        <span class="hljs-keyword">return</span> {}
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Compute final aggregated metrics</span>
        <span class="hljs-comment"># Aggregate batch-level metrics (this should be done based on your metric library&#x27;s needs)</span>
        all_preds = []
        all_targets = []
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> batch_metrics:
            all_preds.extend(batch[<span class="hljs-string">&quot;preds&quot;</span>])
            all_targets.extend(batch[<span class="hljs-string">&quot;target&quot;</span>])

        <span class="hljs-comment"># Update metric with all accumulated predictions and targets</span>
        metric.update(preds=all_preds, target=all_targets)
        metrics = metric.compute()

        <span class="hljs-comment"># Convert and format metrics as needed</span>
        classes = metrics.pop(<span class="hljs-string">&quot;classes&quot;</span>)
        map_per_class = metrics.pop(<span class="hljs-string">&quot;map_per_class&quot;</span>)
        mar_100_per_class = metrics.pop(<span class="hljs-string">&quot;mar_100_per_class&quot;</span>)

        <span class="hljs-keyword">for</span> class_id, class_map, class_mar <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(classes, map_per_class, mar_100_per_class):
            class_name = id2label[class_id.item()] <span class="hljs-keyword">if</span> id2label <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> class_id.item()
            metrics[<span class="hljs-string">f&quot;map_<span class="hljs-subst">{class_name}</span>&quot;</span>] = class_map
            metrics[<span class="hljs-string">f&quot;mar_100_<span class="hljs-subst">{class_name}</span>&quot;</span>] = class_mar

        <span class="hljs-comment"># Round metrics for cleaner output</span>
        metrics = {k: <span class="hljs-built_in">round</span>(v.item(), <span class="hljs-number">4</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> metrics.items()}

        <span class="hljs-comment"># Clear batch metrics for next evaluation</span>
        batch_metrics = []

        <span class="hljs-keyword">return</span> metrics`,wrap:!1}}),vA=new r({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlMjAlM0QlMjAlNUJpdGVtJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBlbmNvZGluZyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wYWQocGl4ZWxfdmFsdWVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUJpdGVtJTVCJTIybGFiZWxzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwZW5jb2RpbmclNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnBpeGVsX21hc2slMjIlNUQlMjAlM0QlMjBlbmNvZGluZyU1QiUyMnBpeGVsX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">batch</span>):
    pixel_values = [item[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
    encoding = image_processor.pad(pixel_values, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = [item[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]

    batch = {}
    batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>]
    batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_mask&quot;</span>]
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),YA=new r({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldF90cmFuc2Zvcm1lZCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRlc3RfZGF0YXNldF90cmFuc2Zvcm1lZCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSk=",highlighted:`trainer = Trainer(
    model=model,
    args=training_args,
    data_collator=collate_fn,
    train_dataset=train_dataset_transformed,
    eval_dataset=test_dataset_transformed,
    tokenizer=image_processor,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),LA=new r({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),EA=new r({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),_A=new R({props:{title:"12. Test How the Model Behaves on a Test Image 📝",local:"12-test-how-the-model-behaves-on-a-test-image-",headingTag:"h2"}}),Aa=new r({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMkMlMjBJbWFnZURyYXclMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmltYWdlcy5wZXhlbHMuY29tJTJGcGhvdG9zJTJGMjc5ODAxMzElMkZwZXhlbHMtcGhvdG8tMjc5ODAxMzElMkZmcmVlLXBob3RvLW9mLW1hci1tb2RhLWhvbWJyZS1wYXJlamEuanBlZyUzRmF1dG8lM0Rjb21wcmVzcyUyNmNzJTNEdGlueXNyZ2IlMjZ3JTNEMTI2MCUyNmglM0Q3NTAlMjZkcHIlM0QyJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBb2JqX2RldGVjdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyb2JqZWN0LWRldGVjdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc2VyZ2lvcGFuaWVnbyUyRmRldHItcmVzbmV0LTUwLWRjNS1mYXNoaW9ucGVkaWEtZmluZXR1bmVkJTIyJTIwJTIwJTIzJTIwQ2hhbmdlJTIwd2l0aCUyMHlvdXIlMjBtb2RlbCUyMG5hbWUlMEEpJTBBJTBBJTBBcmVzdWx0cyUyMCUzRCUyMG9ial9kZXRlY3RvcihpbWFnZSklMEFwcmludChyZXN1bHRzKQ==",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw

url = <span class="hljs-string">&quot;https://images.pexels.com/photos/27980131/pexels-photo-27980131/free-photo-of-mar-moda-hombre-pareja.jpeg?auto=compress&amp;cs=tinysrgb&amp;w=1260&amp;h=750&amp;dpr=2&quot;</span>

image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

obj_detector = pipeline(
    <span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;sergiopaniego/detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>  <span class="hljs-comment"># Change with your model name</span>
)


results = obj_detector(image)
<span class="hljs-built_in">print</span>(results)`,wrap:!1}}),aa=new R({props:{title:"Now, Let’s Show the Results",local:"now-lets-show-the-results",headingTag:"h3"}}),Ua=new r({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTJDJTIwSW1hZ2VEcmF3JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwcGxvdF9yZXN1bHRzKGltYWdlJTJDJTIwcmVzdWx0cyUyQyUyMHRocmVzaG9sZCUzRDAuNiklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShucC51aW50OChpbWFnZSkpJTBBJTIwJTIwJTIwJTIwZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUyMCUyMCUyMCUyMHdpZHRoJTJDJTIwaGVpZ2h0JTIwJTNEJTIwaW1hZ2Uuc2l6ZSUwQSUwQSUyMCUyMCUyMCUyMGZvciUyMHJlc3VsdCUyMGluJTIwcmVzdWx0cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcmVzdWx0JTVCJTIyc2NvcmUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHJlc3VsdCU1QiUyMmxhYmVsJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwbGlzdChyZXN1bHQlNUIlMjJib3glMjIlNUQudmFsdWVzKCkpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzY29yZSUyMCUzRSUyMHRocmVzaG9sZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHgxJTJDJTIweTElMkMlMjB4MiUyQyUyMHkyJTIwJTNEJTIwdHVwbGUoYm94KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4MSUyQyUyMHkxJTJDJTIweDIlMkMlMjB5MiklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeDElMjAlMkIlMjA1JTJDJTIweTElMjAtJTIwMTApJTJDJTIwbGFiZWwlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4MSUyMCUyQiUyMDUlMkMlMjB5MSUyMCUyQiUyMDEwKSUyQyUyMGYlMjIlN0JzY29yZSUzQS4yZiU3RCUyMiUyQyUyMGZpbGwlM0QlMjJncmVlbiUyMiUyMGlmJTIwc2NvcmUlMjAlM0UlMjAwLjclMjBlbHNlJTIwJTIycmVkJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltYWdl",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_results</span>(<span class="hljs-params">image, results, threshold=<span class="hljs-number">0.6</span></span>):
    image = Image.fromarray(np.uint8(image))
    draw = ImageDraw.Draw(image)
    width, height = image.size

    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> results:
        score = result[<span class="hljs-string">&quot;score&quot;</span>]
        label = result[<span class="hljs-string">&quot;label&quot;</span>]
        box = <span class="hljs-built_in">list</span>(result[<span class="hljs-string">&quot;box&quot;</span>].values())

        <span class="hljs-keyword">if</span> score &gt; threshold:
            x1, y1, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
            draw.rectangle((x1, y1, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">3</span>)
            draw.text((x1 + <span class="hljs-number">5</span>, y1 - <span class="hljs-number">10</span>), label, fill=<span class="hljs-string">&quot;white&quot;</span>)
            draw.text((x1 + <span class="hljs-number">5</span>, y1 + <span class="hljs-number">10</span>), <span class="hljs-string">f&quot;<span class="hljs-subst">{score:<span class="hljs-number">.2</span>f}</span>&quot;</span>, fill=<span class="hljs-string">&quot;green&quot;</span> <span class="hljs-keyword">if</span> score &gt; <span class="hljs-number">0.7</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;red&quot;</span>)

    <span class="hljs-keyword">return</span> image`,wrap:!1}}),la=new r({props:{code:"cGxvdF9yZXN1bHRzKGltYWdlJTJDJTIwcmVzdWx0cyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>plot_results(image, results)',wrap:!1}}),oa=new R({props:{title:"13. Evaluation of the Model on the Test Set 📝",local:"13-evaluation-of-the-model-on-the-test-set-",headingTag:"h2"}}),na=new r({props:{code:"bWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUodGVzdF9kYXRhc2V0X3RyYW5zZm9ybWVkKSUwQXByaW50KG1ldHJpY3Mp",highlighted:`metrics = trainer.evaluate(test_dataset_transformed)
<span class="hljs-built_in">print</span>(metrics)`,wrap:!1}}),ia=new R({props:{title:"14. Deploy the Model in a HF Space",local:"14-deploy-the-model-in-a-hf-space",headingTag:"h2"}}),Ka=new r({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMElGcmFtZSUwQSUwQUlGcmFtZShzcmMlM0QlMjJodHRwcyUzQSUyRiUyRnNlcmdpb3BhbmllZ28tZGV0ci1vYmplY3QtZGV0ZWN0aW9uLWZhc2hpb25wZWRpYS1mYTAwODFmLmhmLnNwYWNlJTIyJTJDJTIwd2lkdGglM0QxMDAwJTJDJTIwaGVpZ2h0JTNEODAwKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> IFrame

IFrame(src=<span class="hljs-string">&quot;https://sergiopaniego-detr-object-detection-fashionpedia-fa0081f.hf.space&quot;</span>, width=<span class="hljs-number">1000</span>, height=<span class="hljs-number">800</span>)`,wrap:!1}}),ja=new R({props:{title:"Create the Application with the Following Code",local:"create-the-application-with-the-following-code",headingTag:"h3"}}),Ma=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># app.py</span>

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> spaces
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> io

model_pipeline = pipeline(<span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;sergiopaniego/detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>)


COLORS = [
    [<span class="hljs-number">0.000</span>, <span class="hljs-number">0.447</span>, <span class="hljs-number">0.741</span>],
    [<span class="hljs-number">0.850</span>, <span class="hljs-number">0.325</span>, <span class="hljs-number">0.098</span>],
    [<span class="hljs-number">0.929</span>, <span class="hljs-number">0.694</span>, <span class="hljs-number">0.125</span>],
    [<span class="hljs-number">0.494</span>, <span class="hljs-number">0.184</span>, <span class="hljs-number">0.556</span>],
    [<span class="hljs-number">0.466</span>, <span class="hljs-number">0.674</span>, <span class="hljs-number">0.188</span>],
    [<span class="hljs-number">0.301</span>, <span class="hljs-number">0.745</span>, <span class="hljs-number">0.933</span>],
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_output_figure</span>(<span class="hljs-params">pil_img, results, threshold</span>):
    plt.figure(figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">10</span>))
    plt.imshow(pil_img)
    ax = plt.gca()
    colors = COLORS * <span class="hljs-number">100</span>

    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> results:
        score = result[<span class="hljs-string">&quot;score&quot;</span>]
        label = result[<span class="hljs-string">&quot;label&quot;</span>]
        box = <span class="hljs-built_in">list</span>(result[<span class="hljs-string">&quot;box&quot;</span>].values())
        <span class="hljs-keyword">if</span> score &gt; threshold:
            c = COLORS[<span class="hljs-built_in">hash</span>(label) % <span class="hljs-built_in">len</span>(COLORS)]
            ax.add_patch(
                plt.Rectangle((box[<span class="hljs-number">0</span>], box[<span class="hljs-number">1</span>]), box[<span class="hljs-number">2</span>] - box[<span class="hljs-number">0</span>], box[<span class="hljs-number">3</span>] - box[<span class="hljs-number">1</span>], fill=<span class="hljs-literal">False</span>, color=c, linewidth=<span class="hljs-number">3</span>)
            )
            text = <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{score:<span class="hljs-number">0.2</span>f}</span>&quot;</span>
            ax.text(box[<span class="hljs-number">0</span>], box[<span class="hljs-number">1</span>], text, fontsize=<span class="hljs-number">15</span>, bbox=<span class="hljs-built_in">dict</span>(facecolor=<span class="hljs-string">&quot;yellow&quot;</span>, alpha=<span class="hljs-number">0.5</span>))
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)

    <span class="hljs-keyword">return</span> plt.gcf()


<span class="hljs-meta">@spaces.GPU</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">detect</span>(<span class="hljs-params">image</span>):
    results = model_pipeline(image)
    <span class="hljs-built_in">print</span>(results)

    output_figure = get_output_figure(image, results, threshold=<span class="hljs-number">0.7</span>)

    buf = io.BytesIO()
    output_figure.savefig(buf, bbox_inches=<span class="hljs-string">&quot;tight&quot;</span>)
    buf.seek(<span class="hljs-number">0</span>)
    output_pil_img = Image.<span class="hljs-built_in">open</span>(buf)

    <span class="hljs-keyword">return</span> output_pil_img


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    gr.Markdown(<span class="hljs-string">&quot;# Object detection with DETR fine tuned on detection-datasets/fashionpedia&quot;</span>)
    gr.Markdown(
        <span class="hljs-string">&quot;&quot;&quot;
        This application uses a fine tuned DETR (DEtection TRansformers) to detect objects on images.
        This version was trained using detection-datasets/fashionpedia dataset.
        You can load an image and see the predictions for the objects detected.
        &quot;&quot;&quot;</span>
    )

    gr.Interface(
        fn=detect,
        inputs=gr.Image(label=<span class="hljs-string">&quot;Input image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>),
        outputs=[gr.Image(label=<span class="hljs-string">&quot;Output prediction&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>)],
    )

demo.launch(show_error=<span class="hljs-literal">True</span>)`,wrap:!1}}),ra=new R({props:{title:"Remember to Set Up requirements.txt",local:"remember-to-set-up-requirementstxt",headingTag:"h3"}}),ca=new r({props:{code:"JTIzJTIwcmVxdWlyZW1lbnRzLnR4dCUwQSUwQXRyYW5zZm9ybWVycyUwQXRpbW0lMEF0b3JjaA==",highlighted:`<span class="hljs-comment"># requirements.txt</span>

transformers
timm
torch`,wrap:!1}}),wa=new R({props:{title:"15. Access the Space as an API 🧑‍💻️",local:"15-access-the-space-as-an-api-",headingTag:"h2"}}),ma=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjBncmFkaW9fY2xpZW50",highlighted:"!pip install gradio_client",wrap:!1}}),ua=new r({props:{code:"ZnJvbSUyMGdyYWRpb19jbGllbnQlMjBpbXBvcnQlMjBDbGllbnQlMkMlMjBoYW5kbGVfZmlsZSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnBleGVscy5jb20lMkZwaG90b3MlMkYyNzk4MDEzMSUyRnBleGVscy1waG90by0yNzk4MDEzMSUyRmZyZWUtcGhvdG8tb2YtbWFyLW1vZGEtaG9tYnJlLXBhcmVqYS5qcGVnJTNGYXV0byUzRGNvbXByZXNzJTI2Y3MlM0R0aW55c3JnYiUyNnclM0QxMjYwJTI2aCUzRDc1MCUyNmRwciUzRDIlMjIlMEElMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFjbGllbnQlMjAlM0QlMjBDbGllbnQoJTIyc2VyZ2lvcGFuaWVnbyUyRkRFVFJfb2JqZWN0X2RldGVjdGlvbl9mYXNoaW9ucGVkaWEtZmluZXR1bmVkJTIyKSUyMCUyMCUyMyUyMGNoYW5nZSUyMHRoaXMlMjB3aXRoJTIweW91ciUyMFNwYWNlJTBBcmVzdWx0JTIwJTNEJTIwY2xpZW50LnByZWRpY3QoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RoYW5kbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmltYWdlcy5wZXhlbHMuY29tJTJGcGhvdG9zJTJGMjc5ODAxMzElMkZwZXhlbHMtcGhvdG8tMjc5ODAxMzElMkZmcmVlLXBob3RvLW9mLW1hci1tb2RhLWhvbWJyZS1wYXJlamEuanBlZyUzRmF1dG8lM0Rjb21wcmVzcyUyNmNzJTNEdGlueXNyZ2IlMjZ3JTNEMTI2MCUyNmglM0Q3NTAlMjZkcHIlM0QyJTIyJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9uYW1lJTNEJTIyJTJGcHJlZGljdCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> gradio_client <span class="hljs-keyword">import</span> Client, handle_file

url = <span class="hljs-string">&quot;https://images.pexels.com/photos/27980131/pexels-photo-27980131/free-photo-of-mar-moda-hombre-pareja.jpeg?auto=compress&amp;cs=tinysrgb&amp;w=1260&amp;h=750&amp;dpr=2&quot;</span>

image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

client = Client(<span class="hljs-string">&quot;sergiopaniego/DETR_object_detection_fashionpedia-finetuned&quot;</span>)  <span class="hljs-comment"># change this with your Space</span>
result = client.predict(
    image=handle_file(
        <span class="hljs-string">&quot;https://images.pexels.com/photos/27980131/pexels-photo-27980131/free-photo-of-mar-moda-hombre-pareja.jpeg?auto=compress&amp;cs=tinysrgb&amp;w=1260&amp;h=750&amp;dpr=2&quot;</span>
    ),
    api_name=<span class="hljs-string">&quot;/predict&quot;</span>,
)`,wrap:!1}}),ba=new r({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXN1bHQpLmNvbnZlcnQoJTIyUkdCJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

img = Image.<span class="hljs-built_in">open</span>(result).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),Ta=new r({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMGRpc3BsYXklMEElMEFkaXNwbGF5KGltZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> display

<span class="hljs-meta">&gt;&gt;&gt; </span>display(img)`,wrap:!1}}),fa=new R({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),xa=new eo({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_detr_custom_dataset.md"}}),{c(){w=j("meta"),za=l(),ka=j("p"),Ca=l(),s(u.$$.fragment),Wa=l(),s(b.$$.fragment),Na=l(),T=j("p"),T.innerHTML=Al,Ia=l(),f=j("p"),f.innerHTML=al,qa=l(),B=j("p"),B.innerHTML=tl,Xa=l(),P=j("p"),P.textContent=Ul,Qa=l(),x=j("p"),x.innerHTML=ll,ha=l(),s(V.$$.fragment),Oa=l(),d=j("p"),d.textContent=ol,Da=l(),s(g.$$.fragment),Za=l(),s(G.$$.fragment),va=l(),y=j("img"),Ya=l(),H=j("p"),H.innerHTML=nl,La=l(),s(k.$$.fragment),Ea=l(),S=j("p"),S.textContent=il,_a=l(),z=j("ul"),z.innerHTML=el,$a=l(),C=j("p"),C.innerHTML=pl,At=l(),s(W.$$.fragment),at=l(),s(N.$$.fragment),tt=l(),I=j("p"),I.textContent=Kl,Ut=l(),s(q.$$.fragment),lt=l(),s(X.$$.fragment),ot=l(),Q=j("p"),Q.innerHTML=jl,st=l(),s(h.$$.fragment),nt=l(),O=j("p"),O.innerHTML=Fl,it=l(),D=j("p"),D.textContent=Ml,et=l(),Z=j("p"),Z.textContent=rl,pt=l(),s(v.$$.fragment),Kt=l(),s(Y.$$.fragment),jt=l(),L=j("p"),L.textContent=Rl,Ft=l(),s(E.$$.fragment),Mt=l(),_=j("p"),_.innerHTML=cl,rt=l(),s($.$$.fragment),Rt=l(),s(AA.$$.fragment),ct=l(),aA=j("p"),aA.textContent=wl,wt=l(),s(tA.$$.fragment),yt=l(),UA=j("pre"),UA.textContent=yl,Jt=l(),s(lA.$$.fragment),mt=l(),oA=j("p"),oA.textContent=Jl,ut=l(),s(sA.$$.fragment),bt=l(),nA=j("pre"),nA.textContent=ml,Tt=l(),s(iA.$$.fragment),ft=l(),eA=j("p"),eA.textContent=ul,Bt=l(),s(pA.$$.fragment),Pt=l(),KA=j("pre"),KA.textContent=bl,xt=l(),s(jA.$$.fragment),Vt=l(),FA=j("pre"),FA.textContent=Tl,dt=l(),s(MA.$$.fragment),gt=l(),rA=j("p"),rA.textContent=fl,Gt=l(),s(RA.$$.fragment),Ht=l(),s(cA.$$.fragment),kt=l(),da=j("img"),St=l(),wA=j("p"),wA.textContent=Pl,zt=l(),s(yA.$$.fragment),Ct=l(),JA=j("p"),JA.innerHTML=xl,Wt=l(),mA=j("p"),mA.textContent=Vl,Nt=l(),J=j("img"),It=l(),s(uA.$$.fragment),qt=l(),s(bA.$$.fragment),Xt=l(),TA=j("p"),TA.innerHTML=gl,Qt=l(),s(fA.$$.fragment),ht=l(),s(BA.$$.fragment),Ot=l(),PA=j("p"),PA.textContent=Gl,Dt=l(),s(xA.$$.fragment),Zt=l(),s(VA.$$.fragment),vt=l(),dA=j("p"),dA.textContent=Hl,Yt=l(),s(gA.$$.fragment),Lt=l(),ga=j("img"),Et=l(),s(GA.$$.fragment),_t=l(),HA=j("p"),HA.textContent=Sl,$t=l(),s(kA.$$.fragment),AU=l(),s(SA.$$.fragment),aU=l(),s(zA.$$.fragment),tU=l(),CA=j("p"),CA.textContent=zl,UU=l(),s(WA.$$.fragment),lU=l(),s(NA.$$.fragment),oU=l(),IA=j("p"),IA.innerHTML=Cl,sU=l(),s(qA.$$.fragment),nU=l(),s(XA.$$.fragment),iU=l(),s(QA.$$.fragment),eU=l(),s(hA.$$.fragment),pU=l(),OA=j("p"),OA.textContent=Wl,KU=l(),DA=j("p"),DA.innerHTML=Nl,jU=l(),s(ZA.$$.fragment),FU=l(),s(vA.$$.fragment),MU=l(),s(YA.$$.fragment),rU=l(),s(LA.$$.fragment),RU=l(),s(EA.$$.fragment),cU=l(),s(_A.$$.fragment),wU=l(),$A=j("p"),$A.textContent=Il,yU=l(),s(Aa.$$.fragment),JU=l(),s(aa.$$.fragment),mU=l(),ta=j("p"),ta.textContent=ql,uU=l(),s(Ua.$$.fragment),bU=l(),s(la.$$.fragment),TU=l(),Ga=j("img"),fU=l(),s(oa.$$.fragment),BU=l(),sa=j("p"),sa.textContent=Ql,PU=l(),s(na.$$.fragment),xU=l(),s(ia.$$.fragment),VU=l(),m=j("img"),dU=l(),ea=j("p"),ea.textContent=Ol,gU=l(),pa=j("p"),pa.innerHTML=Dl,GU=l(),s(Ka.$$.fragment),HU=l(),s(ja.$$.fragment),kU=l(),Fa=j("p"),Fa.innerHTML=Zl,SU=l(),s(Ma.$$.fragment),zU=l(),s(ra.$$.fragment),CU=l(),Ra=j("p"),Ra.innerHTML=vl,WU=l(),s(ca.$$.fragment),NU=l(),s(wa.$$.fragment),IU=l(),ya=j("p"),ya.textContent=Yl,qU=l(),Ja=j("p"),Ja.innerHTML=Ll,XU=l(),s(ma.$$.fragment),QU=l(),s(ua.$$.fragment),hU=l(),s(ba.$$.fragment),OU=l(),s(Ta.$$.fragment),DU=l(),Ha=j("img"),ZU=l(),s(fa.$$.fragment),vU=l(),Ba=j("p"),Ba.textContent=_l,YU=l(),Pa=j("p"),Pa.textContent=$l,LU=l(),s(xa.$$.fragment),EU=l(),Sa=j("p"),this.h()},l(A){const a=so("svelte-u9bgzb",document.head);w=F(a,"META",{name:!0,content:!0}),a.forEach(t),za=o(A),ka=F(A,"P",{}),Ao(ka).forEach(t),Ca=o(A),n(u.$$.fragment,A),Wa=o(A),n(b.$$.fragment,A),Na=o(A),T=F(A,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1i2zwz9"&&(T.innerHTML=Al),Ia=o(A),f=F(A,"P",{"data-svelte-h":!0}),M(f)!=="svelte-e0ymej"&&(f.innerHTML=al),qa=o(A),B=F(A,"P",{"data-svelte-h":!0}),M(B)!=="svelte-bmmqde"&&(B.innerHTML=tl),Xa=o(A),P=F(A,"P",{"data-svelte-h":!0}),M(P)!=="svelte-mafiap"&&(P.textContent=Ul),Qa=o(A),x=F(A,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1plkt6l"&&(x.innerHTML=ll),ha=o(A),n(V.$$.fragment,A),Oa=o(A),d=F(A,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1n2zq"&&(d.textContent=ol),Da=o(A),n(g.$$.fragment,A),Za=o(A),n(G.$$.fragment,A),va=o(A),y=F(A,"IMG",{src:!0,alt:!0,width:!0}),Ya=o(A),H=F(A,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1rj699s"&&(H.innerHTML=nl),La=o(A),n(k.$$.fragment,A),Ea=o(A),S=F(A,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1xq2oju"&&(S.textContent=il),_a=o(A),z=F(A,"UL",{"data-svelte-h":!0}),M(z)!=="svelte-vmvn1h"&&(z.innerHTML=el),$a=o(A),C=F(A,"P",{"data-svelte-h":!0}),M(C)!=="svelte-kpjcts"&&(C.innerHTML=pl),At=o(A),n(W.$$.fragment,A),at=o(A),n(N.$$.fragment,A),tt=o(A),I=F(A,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1elgakt"&&(I.textContent=Kl),Ut=o(A),n(q.$$.fragment,A),lt=o(A),n(X.$$.fragment,A),ot=o(A),Q=F(A,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-18yaj0m"&&(Q.innerHTML=jl),st=o(A),n(h.$$.fragment,A),nt=o(A),O=F(A,"P",{"data-svelte-h":!0}),M(O)!=="svelte-3xczrd"&&(O.innerHTML=Fl),it=o(A),D=F(A,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1aro3n8"&&(D.textContent=Ml),et=o(A),Z=F(A,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-alc1jz"&&(Z.textContent=rl),pt=o(A),n(v.$$.fragment,A),Kt=o(A),n(Y.$$.fragment,A),jt=o(A),L=F(A,"P",{"data-svelte-h":!0}),M(L)!=="svelte-tq3xmi"&&(L.textContent=Rl),Ft=o(A),n(E.$$.fragment,A),Mt=o(A),_=F(A,"P",{"data-svelte-h":!0}),M(_)!=="svelte-xv4p87"&&(_.innerHTML=cl),rt=o(A),n($.$$.fragment,A),Rt=o(A),n(AA.$$.fragment,A),ct=o(A),aA=F(A,"P",{"data-svelte-h":!0}),M(aA)!=="svelte-23ym72"&&(aA.textContent=wl),wt=o(A),n(tA.$$.fragment,A),yt=o(A),UA=F(A,"PRE",{"data-svelte-h":!0}),M(UA)!=="svelte-iol3u7"&&(UA.textContent=yl),Jt=o(A),n(lA.$$.fragment,A),mt=o(A),oA=F(A,"P",{"data-svelte-h":!0}),M(oA)!=="svelte-ncu8hg"&&(oA.textContent=Jl),ut=o(A),n(sA.$$.fragment,A),bt=o(A),nA=F(A,"PRE",{"data-svelte-h":!0}),M(nA)!=="svelte-14awcgk"&&(nA.textContent=ml),Tt=o(A),n(iA.$$.fragment,A),ft=o(A),eA=F(A,"P",{"data-svelte-h":!0}),M(eA)!=="svelte-1pf0b6"&&(eA.textContent=ul),Bt=o(A),n(pA.$$.fragment,A),Pt=o(A),KA=F(A,"PRE",{"data-svelte-h":!0}),M(KA)!=="svelte-18bl0b9"&&(KA.textContent=bl),xt=o(A),n(jA.$$.fragment,A),Vt=o(A),FA=F(A,"PRE",{"data-svelte-h":!0}),M(FA)!=="svelte-1hw21wf"&&(FA.textContent=Tl),dt=o(A),n(MA.$$.fragment,A),gt=o(A),rA=F(A,"P",{"data-svelte-h":!0}),M(rA)!=="svelte-d8u7sl"&&(rA.textContent=fl),Gt=o(A),n(RA.$$.fragment,A),Ht=o(A),n(cA.$$.fragment,A),kt=o(A),da=F(A,"IMG",{src:!0}),St=o(A),wA=F(A,"P",{"data-svelte-h":!0}),M(wA)!=="svelte-m5j2f1"&&(wA.textContent=Pl),zt=o(A),n(yA.$$.fragment,A),Ct=o(A),JA=F(A,"P",{"data-svelte-h":!0}),M(JA)!=="svelte-1krarq"&&(JA.innerHTML=xl),Wt=o(A),mA=F(A,"P",{"data-svelte-h":!0}),M(mA)!=="svelte-7k6eol"&&(mA.textContent=Vl),Nt=o(A),J=F(A,"IMG",{src:!0,alt:!0,width:!0}),It=o(A),n(uA.$$.fragment,A),qt=o(A),n(bA.$$.fragment,A),Xt=o(A),TA=F(A,"P",{"data-svelte-h":!0}),M(TA)!=="svelte-1oh7fo2"&&(TA.innerHTML=gl),Qt=o(A),n(fA.$$.fragment,A),ht=o(A),n(BA.$$.fragment,A),Ot=o(A),PA=F(A,"P",{"data-svelte-h":!0}),M(PA)!=="svelte-otps2c"&&(PA.textContent=Gl),Dt=o(A),n(xA.$$.fragment,A),Zt=o(A),n(VA.$$.fragment,A),vt=o(A),dA=F(A,"P",{"data-svelte-h":!0}),M(dA)!=="svelte-lp0r6w"&&(dA.textContent=Hl),Yt=o(A),n(gA.$$.fragment,A),Lt=o(A),ga=F(A,"IMG",{src:!0}),Et=o(A),n(GA.$$.fragment,A),_t=o(A),HA=F(A,"P",{"data-svelte-h":!0}),M(HA)!=="svelte-1pyb1h2"&&(HA.textContent=Sl),$t=o(A),n(kA.$$.fragment,A),AU=o(A),n(SA.$$.fragment,A),aU=o(A),n(zA.$$.fragment,A),tU=o(A),CA=F(A,"P",{"data-svelte-h":!0}),M(CA)!=="svelte-jvjrvx"&&(CA.textContent=zl),UU=o(A),n(WA.$$.fragment,A),lU=o(A),n(NA.$$.fragment,A),oU=o(A),IA=F(A,"P",{"data-svelte-h":!0}),M(IA)!=="svelte-c3j8c"&&(IA.innerHTML=Cl),sU=o(A),n(qA.$$.fragment,A),nU=o(A),n(XA.$$.fragment,A),iU=o(A),n(QA.$$.fragment,A),eU=o(A),n(hA.$$.fragment,A),pU=o(A),OA=F(A,"P",{"data-svelte-h":!0}),M(OA)!=="svelte-1bboxwu"&&(OA.textContent=Wl),KU=o(A),DA=F(A,"P",{"data-svelte-h":!0}),M(DA)!=="svelte-17mbuh1"&&(DA.innerHTML=Nl),jU=o(A),n(ZA.$$.fragment,A),FU=o(A),n(vA.$$.fragment,A),MU=o(A),n(YA.$$.fragment,A),rU=o(A),n(LA.$$.fragment,A),RU=o(A),n(EA.$$.fragment,A),cU=o(A),n(_A.$$.fragment,A),wU=o(A),$A=F(A,"P",{"data-svelte-h":!0}),M($A)!=="svelte-zgrfcp"&&($A.textContent=Il),yU=o(A),n(Aa.$$.fragment,A),JU=o(A),n(aa.$$.fragment,A),mU=o(A),ta=F(A,"P",{"data-svelte-h":!0}),M(ta)!=="svelte-9hkxlq"&&(ta.textContent=ql),uU=o(A),n(Ua.$$.fragment,A),bU=o(A),n(la.$$.fragment,A),TU=o(A),Ga=F(A,"IMG",{src:!0}),fU=o(A),n(oa.$$.fragment,A),BU=o(A),sa=F(A,"P",{"data-svelte-h":!0}),M(sa)!=="svelte-1gvfkqw"&&(sa.textContent=Ql),PU=o(A),n(na.$$.fragment,A),xU=o(A),n(ia.$$.fragment,A),VU=o(A),m=F(A,"IMG",{src:!0,alt:!0,width:!0}),dU=o(A),ea=F(A,"P",{"data-svelte-h":!0}),M(ea)!=="svelte-16ut72j"&&(ea.textContent=Ol),gU=o(A),pa=F(A,"P",{"data-svelte-h":!0}),M(pa)!=="svelte-r7uhmi"&&(pa.innerHTML=Dl),GU=o(A),n(Ka.$$.fragment,A),HU=o(A),n(ja.$$.fragment,A),kU=o(A),Fa=F(A,"P",{"data-svelte-h":!0}),M(Fa)!=="svelte-w12l5"&&(Fa.innerHTML=Zl),SU=o(A),n(Ma.$$.fragment,A),zU=o(A),n(ra.$$.fragment,A),CU=o(A),Ra=F(A,"P",{"data-svelte-h":!0}),M(Ra)!=="svelte-1608qf6"&&(Ra.innerHTML=vl),WU=o(A),n(ca.$$.fragment,A),NU=o(A),n(wa.$$.fragment,A),IU=o(A),ya=F(A,"P",{"data-svelte-h":!0}),M(ya)!=="svelte-16tej72"&&(ya.textContent=Yl),qU=o(A),Ja=F(A,"P",{"data-svelte-h":!0}),M(Ja)!=="svelte-1145wyl"&&(Ja.innerHTML=Ll),XU=o(A),n(ma.$$.fragment,A),QU=o(A),n(ua.$$.fragment,A),hU=o(A),n(ba.$$.fragment,A),OU=o(A),n(Ta.$$.fragment,A),DU=o(A),Ha=F(A,"IMG",{src:!0}),ZU=o(A),n(fa.$$.fragment,A),vU=o(A),Ba=F(A,"P",{"data-svelte-h":!0}),M(Ba)!=="svelte-1flsyep"&&(Ba.textContent=_l),YU=o(A),Pa=F(A,"P",{"data-svelte-h":!0}),M(Pa)!=="svelte-sr5bk8"&&(Pa.textContent=$l),LU=o(A),n(xa.$$.fragment,A),EU=o(A),Sa=F(A,"P",{}),Ao(Sa).forEach(t),this.h()},h(){c(w,"name","hf:doc:metadata"),c(w,"content",Ko),Va(y.src,sl="https://fashionpedia.github.io/home/img/dataset/teaser.png")||c(y,"src",sl),c(y,"alt","Dataset sample"),c(y,"width","80%"),Va(da.src,Bl="data:image/jpeg;base64,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")||c(da,"src",Bl),Va(J.src,dl="https://albumentations.ai/docs/images/introduction/dedicated_library/pixel_and_spatial_level_augmentations_for_object_detection.jpg")||c(J,"src",dl),c(J,"alt","Albumentations image"),c(J,"width","90%"),Va(ga.src,kl="data:image/jpeg;base64,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")||c(ga,"src",kl),Va(Ga.src,Xl="data:image/jpeg;base64,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")||c(Ga,"src",Xl),Va(m.src,hl="https://huggingface.co/front/thumbnails/spaces.png")||c(m,"src",hl),c(m,"alt","HF Spaces logo"),c(m,"width","20%"),Va(Ha.src,El="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAMWAiADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3+iiuf1HUru3v5Yo5cIMYG0HsPamlcic1BXZ0FFcr/a9//wA9/wDxwf4Uf2vf/wDPf/xwf4U+Vmf1iJ1VFcr/AGvf/wDPf/xxf8KUatf/APPx/wCOL/hT5GH1iJ1NFct/a99/z3/8cX/Cl/ta+/57/wDjg/wo5GH1iJ1FFct/a99/z3/8cX/Cj+177/nv/wCOL/hRyMX1mJ1NFct/a99/z3/8cH+FH9r33/Pf/wAcH+FHIw+sxOporlv7Xvv+e/8A44P8KBq9+f8Alv8A+Oj/AAo5GH1mJ1NFcv8A2tff89//AB0f4Uf2tff89/8Axwf4UcjD6zE6iiuY/ta9/wCe3/jo/wAKP7Wve03/AI6P8KORh9ZidPRXMf2tff8APf8A8cH+FH9q3v8Az2/8dH+FHIw+sx7HT0VzH9rXv/Pb/wAdH+FH9rXv/Pb/AMdH+FHIw+sx7HT0VzH9rXv/AD2/8dH+FH9rX3/Pf/xwf4UcjD6zE6eiuY/tW+/57/8Ajgo/tW97z/8Ajo/wo5GH1mPY6aiua/tW9/57f+Oj/Cj+1b3/AJ7f+Oj/AAo5GH1mPY6aiuY/tW9/57f+Oj/Cj+1b3/nt/wCOj/CjkYfWY9jpqK5r+1b3/nt/46P8KP7Vvf8Ant/46P8ACj2bD6zHsdNRXMf2re/89v8Ax0f4Uf2re/8APb/x0f4UezYfWY9jp6K5j+1b7/nv/wCOCj+1b3vP/wCOj/Cn7Nh9Zj2Onorlzq18Ok3/AI6P8KP7Wvv+e3/joo9mw+sx7HUUVy/9rX3/AD2/8dFH9rX3/Pb/AMdFHs2H1mPY6iiuX/te+/57f+Oj/Cj+1r7/AJ7f+Oil7Nh9Zj2OoormP7Vvv+e3/joo/tW9/wCe3/jo/wAKPZsPrMex09Fcz/at7/z2/wDHR/hR/at7/wA9v/HR/hR7Nh9Zj2Omormf7Vvf+e3/AI6P8KT+1b3/AJ7f+Oj/AAo9mw+sx7HT0Vy/9q33ab/xwf4Uf2tff89//HBR7Nh9Zj2Ooorl/wC1b7/n4/8AHB/hR/at9/z3/wDHBR7Nh9Zj2Ooorl/7Xvv+e/8A46KP7Xvv+e//AI6KPZsPrMex1FFcv/a99/z3/wDHRSf2vff89/8Ax0UezYfWY9jqaK5X+17/AP57/wDji/4Uf2vff89//HF/wo5GH1mB1VFcr/a99/z3/wDHF/wo/te+/wCe/wD44v8AhS5GP6xE6qiuV/te+/57/wDji/4Uf2vff89//HF/wp8jD6xE6qiuU/te+/57/wDji/4Uf2vff89//HF/wpcjD6xE6uiuT/te/wD+e/8A44v+FH9r3/8Az3/8cX/CjkYe3idZRXMW2qXr3cKNPlWkUEbF5BP0rps0mmjSE1JaC1yurj/iaTf8B/kK6quX1Yf8TOU/T+Qpx3M8R8JRxS0Uma0OMWiiigQUlLSUAxaKKKYgooooAKUCkp4oEJijFOFBoGNxSYp+KMUANpaKKYrBijFFFADcUYp1FAhuKWiigYUUZpM0CEoopaBhmlzSZozTELmjNJmigAooooAQnFLRRSASiiimAUlLSUgHClpBS0DCikJxRmgBaQ0ZpQc0AJikxTqbQAUGig0AJSikooGLRSUtIAoopDQMMUYpKM0BcWiilFA7jaOtLRSGNxRiiigCaz/4/rf/AK6r/OuxrjrP/j+t/wDrqv8AOuxrOR1UNmLXMar/AMhKX8P5CunrmNV/5Ccw/wB3+QohuPEfCUSKTbT6MVocYzBpdtPxS4oAYFo20/FAFADNtJipcUmKCbEeKMU/FGKYDcUooxSYoEOzRmkxRigB4PFGabRQA7ApcCmZpc0ALijHvRmigBMUuKKXNADcUmKfmkoAj20bak20baYEeDRtPpUm2nbRQBDtNG2pcUbaAIehpalK03YaAsMxRin7TRigBuKTFP2mjaaBEdFSbcdaTbQMZSgU7FGKAG5pM0/FJtoAbS4pcUuKAG4oxTqKAEopcUYoAZQaXFBFADaKdRQMbS0lFJgOxTcU7NNzQAYoxS5ozQAmKBQTSUDHUlFFIoQ0lKaSgCaz/wCP63/66r/OuxrjrP8A4/rf/rqv867Ks5HVh9mFcxqv/ITmP0/kK6euX1Zv+JpMP93+QojuPEfCVcUlANKDWhxiiiinACgBM0Zp2KMUDG0UuKMUCEopcUYoExtJUmKbimIbRTsUYoAbRTsUYoEJRTqKAG4oxTqKAEpRRRQAlFFFABRRRQAuaXdTaKAH5ozSUUAOzSZpuaUGgBc0lKKU0DGUlOxSYoEITSE0pFIRTAM0ZpKKAHUU3NGaAFpc03NJQFx1HSm0UBcdRQKKADFGKXFLSGJs9qTbUlJQMixRinkUmKBDSKQin4pCKAGYoxS4oxQA3FGKdikIoGJSUtJQNC02nUUhktn/AMf1v/11X+ddjXH2f/H7b/8AXVf512FZyOrD7MK5TVzjVZh/u/8AoIrq65PWf+QtP/wH/wBBFOG4Yj4SqGpQ9RClBrQ47smDUoaod1KHoC5Y3U4MKr7qXdQFywCKWoA9OEgFILktFRB6UP60BcfgUYFJvpd1AXDaKNoo3UbhQMQr6UbadmnAZoERbaNtT7R6UbRQMg20YqfYKPLoEQYNGDU3l0bKB2IaXFSlKNtFxWIsUm2ptlJsouFiHFAFS7aNlArEdFP2+1G32pisMopxFGPagBuaXNLtpuKBi5puaWkxQFhuaTNP203bQIbuo3UuKMUwE3UbqXFGKAE3UZo20uDQAYpcUmDS4NACUtFJSAfRTc0maBj80ZpmaM0BckoNMzRmgY6jFApaAGYpMVJSEUDsQkUEU8ikIoAbim0+mmgQUGiikUS2f/H7b/8AXVf512NcdZ/8f1v/ANdV/nXY1nM6sPswrktZ/wCQtP8A8B/9BFdbXJaz/wAhaf8A4D/6CKcNwxPwFGiiitDiFooooEFLmjFJQA7NLupnSimBIGpQ1RA0oNICUNTw/rUGaAaAuT7xRvFQ7qN1AXJw1KHIqAPTtwoAnEpp6yg9arbqXNA7lzevrShx61TDGlDGlYdy6CDS1T80ipFm45oHzFgIDSiNagEvvThJ70ik0TeWtJ5a0zzfejzPegLoUoO1Jspd5o3jvQIaVxTPl9akLA96ZsU0xMTg9DRszShB2qQCkFiIoaQoanIxSYp3HYg8uk21OVpu2gViLaKbiptoo2CgLEGPakNTEAd6ZxQIZRTsCjbTCwwClzS0UhBig0lFA7CYpMU7NJQAhFNxUhNNpiG0UUUCDNLTadQMUU4UgpRSY0LQaM0hoGIaaacaaaAGmkJxSmkzmgQUHpRRQMks/wDj+t/+uq/zrsa5G0H+mwf9dF/nXXCs5HXh9mFchrX/ACF5/wDgP/oIrr65DWv+QvP/AMB/9BFOG4Yn4CmKKBRWhwi5ozRijFAC5ozSYoxQIWlxSUUAGKMUUUBcXFJS0UAJRS0UAGKM0UUDFzRmijFAh26lDVHiloC4/dS5qPNLmgCTf7UoeoqUGgCbdQGqPNGaB3LAkpS4qsGpd1IdyctQCe1RBhTt4oC5LvPrS+Yag3e9G73oHdFnzeMGlDZquGp3mcUWHcnDGkJqPeKN9AXH4pGcCmF80xvrQAMcmkpM0maCbjhTs4FR5pc0ABNJmgg+lITQA7NGaZmjNMB+aSm5pwINIBcU0ipMZpCuaYWIqSpNho2GgBmKWl20YoAM0ZpKM0ALmjNJmjNIdxaKSigYhpKWkNACUUE0UATWn/H7B/10X+ddfXH2Z/02D/rov867Cs5HXh9mFchrQ/4m8/8AwH/0EV19cnrI/wCJrMf93/0EU4bhifhKAopcUYrQ4QooooAWijFGKACiiigQUUtFACUZpaXFACUUuKQ8UAJS0UlADqKZmjNAEgopmaUGgB2KMUmaWgAoop2RQA2inUUAN5pcmlwKMUAANLmm4ooELmlzTcUmKBj80uajp1AXHhqcGqKigdyYmjNQ5pcmgLklGKj3Gjee1ICYKDUiqBVcOacJDQO5MaQqvpUe8mlDUDuKY1NMKAdKduFIWzQAzFJ0pxNJQIXOKUNTaaeKAuShgaXNQg0oNAybGaQrTA59acXoAaVxTSKVmzTc0AJRTc0ZpiH0mabmigBc0UmKMUhiUUUUDJ7P/j9t/wDrqv8AOuwrjrP/AI/YP+ui/wA67Gs5HXh9mFctq4zqkv8AwH+Qrqa5bV/+QpL/AMB/kKIbjxHwlLbRtopa0OIbijFOooENxRinUYoENxRinYoAzTAbijFPApcUgI6Kfto2+1ADKKk200imA3FJinEUYoEMxSYp+KMUAR4padijFAhM0uaMUmKBi5o3UUUALmjNJS0AO3UuaZSZoAkzRTc0A80APopM0uaAEooyKMigBMUYozRmgBaKKKACiiigAooozQAUZPrSbqUHNAXF3GjdSZozQMXdmlzTQaM0AOzRmmA0uaAFoozRmgA6UZptFIAJpM0opKYwooooAKKKKACkNJRQAtFJRSKRPZ/8ftv/ANdV/nXY1x1n/wAftv8A9dV/nXY1nI6sNswFcrq//IUl/wCA/wAhXVCuV1f/AJCk3/Af5CiG5WI+EqDpRTaK0OMWiiigQtKKKXFAhMUoFLRQOwUUUUCG5ozQRSAUCFNFJRQMKKKKBBijFFFACAUoWgU8CgBuyk21JikIoAi20YqXb7U0rQIZijFP2+1G2i4DcGjBp2KMUXAZSGn7aCtMBvNLml20m2gBKKKKAFzRmkzRmgBaKSigBaKKKAHU2nUUANooooAWiiigYUUUUAFFFFAC0U0nNJmgB+abmm5ozQAuaM0maM0AFFFFABRRRSYwFFAooAKKSigpFiz/AOP23/66r/OuxrjrP/j9t/8Arqv867Gs5HVhtmFcvq4/4mk3/Af5CuormdVGdSlP+7/IUQ3KxHwmfto21LgUoArQ5CIKaULVgLQFFK4iEClxUhWk20XAZiinFaTFAWG5paMUUCCkIpaKdxDMUYNPxRilcBmKMU7FFO4WG0YpaKBCYxThRSigaFJooooAKAKUUtACbabipcUmKQEWKMU/FGKYhmKXFLS4oAbijbTs0ZoAiKHtTSpqemkUAQ4oxUpFMIoAbS0YooAXFFLmlzQA3NJS55ozQISilpKLgJRRRTGLmjNNooAdmjNNzRmgApKKSgQUUUUAFFFFAxc0tNozQA6jNNpc0DFFFJRmkAUUUUDJ7P8A4/rf/rqv867KuNs/+P63/wCuq/zrsqzkdeG2YVzOqf8AIRl/D+Qrpq5nVP8AkIy/h/IUQ3KxHwlSnBabTgatnISilxTAacDUsYuKTbTs0tILEe2kKVLikIp3CxDt9qTFS4pMUE2I8UYp+KMVQiKinkUEUAMoxTsUh4oCw3FGKqapcTW1mHg2+Y0scYLjIG5gM479aT7HrP8A0ELT/wABm/8Ai65q2LpUWlUdi40pSV0XKKp/ZNZ/6CFp/wCAzf8AxdH2TWf+ghaf+Azf/F1j/aeG/mK+rzLtFU/ses/9BC0/8Bm/+Lo+x6z/ANBC0/8AAZv/AIuj+08N/N+AfV5l4dKWqH2PWf8AoIWn/gM3/wAXR9j1n/oIWn/gM3/xdH9p4b+b8B+wmaFGaz/sms/9BC0/8Bm/+Lo+yaz/ANBC0/8AAZv/AIuj+08N/N+AewmXieaM1R+yaz/0ELT/AMBm/wDi6Psms/8AQQtP/AZv/i6P7Tw3834C9hMvYpcVQ+x6z/0ELT/wGb/4uj7HrP8A0ELT/wABm/8Ai6P7Tw3f8A+rzLtFUvses/8AQQtP/AZv/i6Pses/9BC0/wDAZv8A4uj+08N3/APYTLtBql9j1n/oIWn/AIDN/wDF0hs9Z/6CFp/4DN/8XR/aeG7/AIB7CZdpCKp6ZcS3NoWnKmRJHjJUYB2sRnH4VdruTUkmjJpp2Ym0elNxT803NUIbijFOzRmkSMpRRTaYx1BpKKBCUUUUDFpMUtJQAlFFFMBKKKKAEooooASiloxmlcBKKcEPpTShouFgFLSYpaLjCiiigAooooAns/8Aj+t/+uq/zrs64yz/AOP63/66r/OuzrOR2YbZhXNap/yEZfw/kK6Wua1Qf8TGX8P5CiO5WI+Ep0tGKXFVc5AFOzTaWkA4Nmng1GKeKQ7j6KQUoNAxKQinE0maLiG4pCKfikxTuKwzFJin4pGO1Sx6Dmi4WG4pCKzoNVuLmBJ4dJu2jkUMrboxkH/gVP8A7QvD/wAwe7/77j/+KrB4ugnZyRapy7EetcWMX/XzD/6MWrOt63ZeH9Na/v3cRBgirGpZ3cnAVQOpNZeq3N7PaxqNIuhieJjlo+zg/wB6q/ihYtX0pbTUbG+tV85ZIZ0miRo5V5VlJbGRzXi5lWo1K0FzaHVQi1HVF7SPE41a9Nq2i6zYsULq97a7EYDHG4EjPPSsvwbqj/2X4hutSvnaG01a7XzZ5CRFEpGBz0A9Ko6LrPiWz1+Kxu5TrNjJEz+YUijmiI6ZKNtYH3wf64Vzpur3fgDxVptvp8wnu9VmnUh0xt81WIPOc4U1yqNGzjdJO3U1szr4viHpbmGWaw1a1sJ3Cxahc2hS3fP3TuzkA9iQBWprviax0B7eGZLm5u7kkQWlpEZJZMdSB6DuSRXBaha6trOiy2d54lvJLCaMK8ZtLNcr1xwQQeB05p2rWeuR+NLS/huLzTIv7MWzS4McEjMwfJB3naM8HOc0ezw0n8S+/wD4AWZ22leLLLVjewx2t7BfWkfmSWNzD5c5XsVBOCD6g+lXNJ16x1nw9Drdu7JZyRmQmQAFAM7gcE9MHP0rjtHtNQh8Vrq93qN3qt2lo0AjEVtGQhYHny26A881jXcWs2Gna/4WsrCWNNSuw9mSyfu4ZeZBwegwwH1qfZ4du0ZLp1+8Hc7oeM9LXwvba/OtxBb3RC28Lx5mlYkhQqqTknGRz064pdK8YWepammmzWOpabeyIXhi1C38ozAfe2HJBx3HWuT8V2Go/a/C76db3Wm2mll4/OKxSGPKKqHaxKnGCOemfWnrY6nea7pN1qGt3moNZz+dBAIbVCxwQRlGB5FHLhuW/Mtb9fuCzZ3kGsWNzq91pUU+6+tUR5otjDYGGV5xg8ehp2r6iukaLfai4ytrA8xXP3tqk4/Ss2DUkGqXJh0KVb4KomZViDlf4ctuyah8R/b9Y8N6lp0Wj3QlubaSKMs8eAxUgZ+b1rmi6POk3pp1Hys5aKw8QHwP/wAJd/wkWoDVzanUBb+YPsuzG/y/K6Y28eua9C0fUE1fRbHUo12rdQJMFznbuUHH61w8WtSj4aDSzp8320ad9hC+ZHnzQmzpuz156Vs6Le3Hh7w1pGnXelXQlihitsgphpNuMD5vUGumvUhKL1V09NthWZoaz4aTWLtLhtW1izKoE8uxvXhQ4JOSB356+wrmvAEVzNr3iG7XVNSu9LguPsVot5dvMCUx5j88HJxgjtmt3xBr2oWWg3s0GkXUdx5RWBneMAORhSfm9eab4FsV0nwtbaUYXiuLQbbgPjmVhvY5B5GWpQrfuGnK9ws0ccniTT/EEkmoaz4vudItpZ3jsLSyuvJPlqxXzHIGSWIPXgYr0rS4lh0u2jS+kvkVBtupHDNKOoYkcHjHNea+AB4d8NeH9a0nW5bG3vLe7lS8S5KhpY8DaQD95SOmPX3ro/hXDcxeALETh1RnkeBX+8Ii5K5/mPatsXFKL5dk1/SA2NG/49Jv+vmb/wBGNWhWfo3/AB6Tf9fM3/oxq0K+lo/w4+iPNqfEwpBS0lbECUUUUhWG0UtIaYCUUUUAFFFFDYBRRRQAlJS0lAAaaTTjTTQAtFFFACilFApaGykOFIxzTTRSACKbilNFMBKKXFGKAsJRS4oFAyez/wCP63/66r/OuyrjrP8A4/bf/rqv867Gs5HXh9mJXP6kub+Q/T+Qroawb8ZvpPw/kKlFV/hKJSk21Nt9qQr7VRy2ItvtS4p+32pdvtQFhmKdS4FLwehoCw2nUYpcUAJRS4oxQAUUUUABGaZKP3Lj/ZNPpkv+qf8A3TSYFTQiB4fsCWAAgTJPbiktNd0e+uPs1pq1hcXA6xQ3CO35A5rJutJn174dHSra4EEtzYqiyHOAcDg47HofYmsPTLmHQdV0iw13wbY6bPJKLez1Cz2SRmXaQB0DoTz1znP1r5L2MZ8z63eh6CNuz1251HxJr+mTRxCHTLm1SFkUhmDqGO7nHX0ArTutV0Z9S/s261Cw+0MQPs0kyFyfTaTmuMEs9vq/xNuLbcLiCOCWEjGQ625Zf1FcxpWg6lqPhW3to/B9ndfbLcSG8a/j813Zd3mFjGWByc4zx0zRPL41Zc7dkku3bfUfNbRnsotLDToHkCwW0QGXbCooHqTxUOm3OkX8cjaXd2dwgbMhtZEcBj3JXucd68y8R2/iAnwVoupQHUZpEla4tJblUSaWJBt3OQQcDnBBzWlY6B4hHi/TNSh8P22ixRh4rt7a8ifzY2XgFVRQcHBHWuT+zLQ5pVNde3T8dTTmid3a2uj6gv2y0+yXIJI86EI4yDg/MO9SJ/Z+oxTLFPDcxxOYpQrK4Rx1VvQj0NefR6g/gjVfFlpNculusR1e0HyjeX+V16cfvNoAHrWbrGmalonwt0iz8yaSbVL+L+0I/MEZcyku6s+PlycKSaFlcnL49G1b03f3CconpWm3OgTyvbaZfafLKvLxW0iEj6hT71eOn2zzrO0amVBhXKgsv0OK8p1HQ9eMmnNp/hG00u6s7hJI7i3vYiyqDhlIWNcgjPBNdTPoc934gi1ye6kjuYbc2yKpBBQnPPHXNZ18AoO8Z737PX5dwTT3OtKo/wAmQ6HgjrmuEs9c1vVIb7WPDGi6Oul20jxxLKrLPdhPvFCvAB6DOa6GNLplZFupFcnavA54x6eua5T4e6nbaV8MLB7m+eAwmZGhAXIYSMSMY9Dn8adHDOFJzaTd0vlrcSnd2R3OgalY69pFrrlnGqi7jDEkDdxwVJ74OR+dZ/ivxBeaVdaXpml21vNqOpyOkRuWKxRqi7mZscnAxwK818F6/qdl4StbaCYxQ7pGRdoyAZGP9ao+J9Tu9V1LTNOlmKTO7SpdBiHi2jOUIxyf85p08Co4txfwpv8AD/I0b0uejadq+oW3jG30jxDp+kvdXkDzW17p6NyV+8rBuRx3z/8AWsag3ja4nmktdN0AQQTMbeK7d5JJApIV8j5UJHI9M815VaXN5o3i22Zrua9ku4XVZrk75IgnzEA9Np+lbWp+Ndat3XTNLuWe+mXjPSFT/Gf6VtPDNVYunGLut3e3W7t0Emj0zwzrdr4w8O2+pNaCMlyJIJQG8qRTgj/A+9T6cP8AiY6t/wBfI/8ARaVx/gm9tNG0e20c3csAjyfN+Uq7k5YnI4yTW7aWd1JqWqlNTuIgLgDaqoc/u155WlhME6mImqW2tvS5FWSjG7Ne80bS9QmSe+02zupoxhJJoFdl+hIyKu9OB0rHNhej/mMXf/fEf/xNJ9ivf+gxd/8AfEf/AMTXqPKcQ1Ztfecvt4oTRf8Aj0m/6+Zv/RjVo1WsbRbK38pZHkJZnZ3xkliSTx7mrNfRU04wSZySacmwpDxQaKskSilooAaaKWkNArDaKWii4BTTTqKBDaKKKAsJRRRTuMSkzmnYpMUAFFLijFABRRRikxjhRtpQKXFA7DNtG2n4pcUAR4pMVLikxQMjxS4p1NoAns/+P23/AOuq/wA67CuPs/8Aj9t/+uq/zrsKiR1YfZhWHf8A/H9J+H8q3Kw7/wD4/pPw/lUl1vhK+BRiiiqOawm2lxRS0AVru1+0oFDlMdxUscQjQKCTjuakopAGKMUUUwEooooAQ8UUtGKQhpGabJ/qn/3TT8UyQFkYDqQRQwMCKzXUvCtnZvLNEkttFl4JCjjGCCGHTkCq1r4Fhi1G2vrrU9U1KW0ffbi+uvMWJv7wAA59zmpLXULnT7eyspdLujLHEiHDJg444+atU6rdf9Aa9/OP/wCKr4qGHxUqlSMb2v08z15VIwhH0ILLw3FY6pqmoRySNLqRjM6uwKjYu0YGPT1zWBH4Cs7a6MOn6trGnwFi32W0utkS55OBglfwNdMNVuv+gNe/nH/8VWcNbmOs7BpF7uz0zH6f71dNHL8Um3G+35bHPVxcVbbck1DwnZ6npNtp1wZSlrtNvMJiJYmUYDB+u73qHTfCDWF/HeS67rN80WfLS7vCyLkEZ2gAHgnrmrk3iCWHhtIvM+gaP/4qqM/isxrmXTbtf+BR/wDxVZLA4pRcNbM0+sJ9iPxL4N07xLd2NxqLzB7Q8CFwBKu5W2vkHIyorR1OytdY0+awv4TPbTLh0J/I+xB5zWDP42jVMjS71vZShP8A6FVA/ESxUlZLC9jP+0FH9ah5fibRWvu7eRSr210LkHhKCzlhZtV1+5iiYOtvJeZTg5AIGCRwOCannTTx4lh1mWK+SeGA26jYPKKk5JIGTn8aoJ46tZlzHaXTH0BT/wCKqjc+PYERm8i5XbyQ20f+zVc8FipO8r9hqsvI7m3u4bld0RyucZrzbxj4U08a3JJDJdW6Xa+bcQwzbY5HJIYke+OcVseGfF8eqWk09vYXUiidlLDZ1AX1NYXjnxdaWesQR3VrdRObcMAQp43N6Gs6WCxWGqxVO6uhwqxqxlfoyjd6VbXml/2ed8UGFA8ogEAEEAZB9Ks3+grq+xBbzM8R3RzQEh0PsapWPiSxkiab7NdM2/y0jVAWJxkkLnJrq/D/AIstmuXWHTb13fggoq4PpgmtvZYqLTSen6jirnNweHBp10bu4F5LcFdgluiWKj0HAAqkPDUS3dxdQajqEUk7bn2SKPw+70FehX3ji1tSEn0+aIE4JlZBn/x6uR1/xDp9tOs8dlcRRyjIxtKH6EGrj9c5tmEopIZa2xtLcRGeafBJ3zMCx/ICtLwf4yS18X3fh+/f5Lko1tKzdH2gbCffAx+XeuRl8a6bEcNFcj/gA/xrjNZ1SO8117+0Z1wVKk8EEY5/MV3ZdRqwrOdRWujCqlKFj6xNGKwfBuvL4j8LWeo5HnMuyYejjg/4/jW9X0CZ5UlZ2E6UdaXrR0ptiEopQM0EYouOwlFFch4w8eWfhtGtrdVu9S7QhsKnux/pSckkOMXJ2R12KoXGr6ZasRcajaREdQ8ygj9a8I1Pxh4g1cn7XqMiRn/ljD8iisM7CSSST6k81k6vY6Vhu7Po1fEOiOwC6vZEk4/1y1oRyRyoHikV1PRlIIr5hYRkdKtadq+o6RL5mn3s1ue4Vjg/h0pKt3G8KujPpaivLvDvxV5S312IDJC/aYh/6Ev+FenW9xDdwJPbyrLE4yrqcgitoyUloc0qcoPUkxTcUuKXFUQNxRinYoxQAmKNo9KfijFFx2GYoxT8UYpBYZtoxTqKBiUtFLRcLBRmijFFwsJRilxRilcLDcU3FOxSYouFia0/4/YP+ui/zrr65CzH+mwf9dF/nXX0pHVh9mFYd/8A8f0n4fyrcrDv/wDj+k/D+VSXV2K9LSUtM57BS0lLQAUlB6VXg858s/HNICxRRRTBoSiiigQUUUUAJRRRQBlXn/IUg+i/zrUFZd5/yFIPov8AOtQV5eB/jVvU7cV/Dp+g4Vzdwzpr0xj4cKdv12cV0ecVzzjd4if3yP8Axyvdw32vRnkYn7HqjGGoEEPM5LNyc1n6tr00S+VETEHGBMEDbT9DUEz7gD9RRAVfKSKGVuOa4zvUUjk7jxbrmiXoS+S3ngb7sgiHzD6ipZvFqXOZbrQ457XGRNbvll+orobzQLS9tXt8B4m/gP8ACfUeledX2h6p4c1WOODfJFK+2JkGdxJ4GPWkaJxOintbV5k+wR3UdywBW3MTBznpgfStC6+H94+j3era3drZw28LzNDEN0jYGcE9B0969X0q3nttJtIrtxJdJEqyuDnLY55rnvibO1v8OtYZOrRqn5sAf50+W5n7Rt2RwvwnOfDMv/X6x/8AHVrC+LMPn+LrIDljZKAo7/O9bnwm/wCRZl/6/G/9BWpPEdhLe/FDRyFzGtoNx9DukIrlxklHE0v8L/M3wSvCqv7wnhjwparELu+aR5CoCR5xsJGTgVqXra1YTyDSYbe2tQmFO0s7t6k9h7Vo3dhfFoYtPlijKcN5uefyq0NFQxql3dXss5/5aRttQH2HT86yu5M9BJJWM3RmbU40/tWD7Nej5WmQZVvpmuO+IeinSoUe3maS2MmSirjacdvauwSy1e1umSR4p7XcNsmfmb6joDWP4rtZri3U5zg5wfUUublYpRujyG6k3wFWyHznmqIq1fOXmfOOCRx9aqrXfHY4me2fAvUGew1XTnJxHIkyg/7QIP8A6CK9dzXifwKBOq6ucceQg/8AHjXtuK0T0OGqveEopcUYpmYlLRRQBynjzxS3hjRAbfBv7omOAf3fVz9Mj8TXg0juzvLK7SSyMWd2OSSa634j6mdS8Zzx7sxWaiFR2yOW/UmuOmfrXPOV2d9KFokM1wEFdH4a8E6l4gi+1yt9mtT0JGS30rP0/SY3lhmu5I40dv8AlocBVHJJ/AfnXrvhnWUvHihiaBrMLsiCRMhBHT71ZOXY6Ix7nGan8L7mO2eWwvpHlAzskAwx/CvOJZbi0uWtrqNkkQ7WyO9e8+I/EMumTMsXlJEgw5dCxP0ArzvxNHYaxt1GF4mkPyzKI2jYHtlTSjN9RuK6HJo+4dQa6zwd4zuvC10quzS6dIw86HP3f9pff+dce6G0n2HPlnp7VYQgj1Fap21RlKCejPqG0uoL60iuraRZIJVDo69CDU1eUfCbxE63s/h+5kyjKZrbPY/xKP5/ga9ZxXUppo4KkOV2Eop2KMUrmY2inYoAouA3FLingUUXGM2804ID1ooouOwoUelAUelKDQDQFhNo9KNtLmigYhFNxT6AKBWI8UbakoxQOw60X/TID6SL/MV1dcvaAfa4f+ui/wA66ikzoobBWHfn/TpPw/lW3WFqA/0+X8P5CkVV2IM0uabilxQc4uaXNNxRTAWiiikAtFJRQMKKKKBBRRSGmAtJRSUCMq9/5CkH/Af51qmsu9/5CkH0X+dahry8B/Grep24r+HT9Arn+viMj3/9lroKwh/yMv4n/wBAr3cN9r0Z5GK+x6o4y/t3s7qe2k4MbkVBC+OtdB4xtGj1BJwvyTR4z/tL/wDWIrmoDuSuM9BO6Nq0CMpYjAHJqPRtb0+bXJWvY0js4B/o88p4aT1Ax+Rrndd1CbzbPSbYmNrl8SsDyE7/AMv1rStbJLWJ764XcsKkxqf4V7AD1p3E1c9PjdJY1kjYMjDII71yvxMt2uPh1rKqpYrEJOPRWBP6VB4R1+VdIjXUxsaR3ZMD7o3HA/KrGqeI9PvYLrS54ZfIniaKRxg4DAjpTI5WpHA/CfH/AAjMvX/j8b/0Fa6HxHd2VjqNtPNIqXUoWGL15J/xrJ+G+nz6Zolza3ClXS9fGR94bUwR7GuY+K7P/wAJrpaK7AC3QjB6HzGGf0rix0OfE0f8LOvAS5Y1X/eO7m8Rx2KbmbcxGcAdKoD4gAtjyyAevvWVJpUnmsMliBkZrNazaJsMuK5HJo9JK52Q8Qw3wBt8qx6g96p39ybzy4Djk7cDvWHbwOnzL1rD8U3t1pkthdJIVkWTco7HHrVQTnKwStFXZmeLdDi021gu4sjzm9COufX0xXKrXQ+IPF0+vxeU9tHEnBxncQRnkH8awYYnmkWONSzuQqqOpJ6CvRpqUY2ZwTabuj3P4G2Bh0XVNQIIE86xIfUICf8A2b9K9VrF8I6GPDvhWw00qBJHHmUju55b9Tj8K3K2R583zSuFFLRTIsJRS0UmM+afELF/E2rk53fa5M5/3jWTHF51yoY4UHJrpvH1gdN8balFtIWZvPQ46huT+uR+FcwZfIt5GHDNhQa5p7npU9kd/wCEfDB8T3QvZGKWFkxSNP8Ano/r9BXoZh07SbiGW6lBcArCuAOnPA7461z3wyuMeCrdY25SSRX+u4n+oq1qWq2c8r26WSs8ecyXJCAnvgnGaxe51QjzaGlDHpWuDzo5kkOSyuhByehzWT4i8EWt3BJc+a4nEe0MD0A55punavAtyLdbA/Mf9fbAMoPvjt71vySSMh3kkY6ZpXHKCTPnnV4Xtr2a2lGJImwfeq0EuBitvxdEbzVrqa3GTE5Rx7dv61gRxSQkGRSAfUVtHY5pbnQ+HL02HijSbxW2lLlASP7pOD+hNfS9fK1sd11bY6+auPzFfVNb09jjxG6CiiitDnFxRijHvRigBaKKKAEooooGFFOoNABRSUtACUooozii4wpRSUUrgS2v/H3D/wBdF/mK6iuXtf8Aj7h/66L/ADFdRSOijsJWFqP/AB/Sfh/Kt7Fc/qR/4mEv4fyFA6mxBml3VFuo3UrmCRJS5qLfS76LhYkzRmo91LuouMfmjNMzRupiY/NLmo80bqBD80ZpmaM0DsSUUzNGaBMzb3/kKQfRf51p1l3p/wCJpB/wH+daRNeZgH++rep24r+HT9B1YX/My/j/AOyVuZrCB/4qX8T/AOgV7uG+36M8fFfY9UXdYsRqOnvCB+8HzRn3H+cfjXmsCNHcSRsMYbpXrFcJ4r082eqpeRjEVwCG9mH+NcbO6D6HFaLaza142vJzxFZgIGPZiD/n8q6+7025bgajIgByAkaj+eaZ4Qs/s+lyzsP3lxM8hPqM4H6AVqTkAkmnHa4Sbvoc5NokTbpLm5upiepMpX/0HFUEKNqUFtCDtVj3JJ+p710Nw25SAKztIt1/thMjkZJ/Cgd9DoIbdbZljTpwa4Lx94e1PUfGmkX0FlLLZRrHHLMgyEIkYnP4EV6G/Ey1oJGt7Y3lkpAlCbx7E8L+oNcuNdsXSX91lYCVqdV/3kcutqpkyWxniqV/p8KuACCzfjWn8k0IfPBGRg1jqJXnJlOey/SuNo9dMbFY4boK8++JrhdRsYAeVhLEfU//AFq9QjUoMsa8/wDH3h3VtSuxqVlZvcW0MYjkMXzMpyTkqOcc9a3w698yrStE82FerfB/wW+oaiPEF7H/AKLat/o6sP8AWSDv9F/nVPwL8Kr7XJY77WUe004HIRhiSX6DsPevf7S1gsbOK0tYkigiUKiIMACvQsebUqWVkSioLm+tbPb9puIod+du9gM46/zqxWc4DeJbPIBH2aXgjP8AElZV6nsqbnbYxhHmdh/9uaT/ANBG2/7+Cj+3NJ/6CVt/38FaQiiP/LNfyFVdUu7XSNJu9RuIi0NrC0zhFBYhRk4zgZ/GvJWcSk7KB0ewRX/tzSf+gjbf9/BR/bmk/wDQRtv+/gq3YS2+oafbXsUW2O4iSVAyjIDAEZ9+aseTH/cX8hSectOzgL2C7nlHxWtrLVdPt9UsbuCa6s/lkRHBLxn/AAP8zXkl2M6bGFBZncORg8CvrFoIiCDGhBGCCorzzVNPiXVTbxIipnAyOFB5rKpnHXl/E6aMLdTl/AOs2WnW8tjNMsaSkSoWOACVGR+ldvNdeHbiEG5urZ+MDLisfV1jtzGkIHyHlsdT7Vp6fKZoFLgMT3Nc/wDa1lfl/E6VEVdT8PwoBBewoB2DCql74h06GB2F3E2Bnhs1sGIYwVX8qzb8bYXYhcL7Uv7Xu7co3HQ8Yiu5Lq+1CdkDRTuS0ZHUVXu9Oijh8+2kLITzG33lr02S/tdNtZru4ZY4oxknH6Utn4is9TnWzayuLW6mUtGk8Ozzsf3evPtXTHMKsk5xhp6mbStqcD4OsUvfFWnJcMkdvFKJpXc4AC8/qQB+NfQv9u6T/wBBG2/7+Ck8P6JHp1oWkjQzSdcjO0dhWde+NdNttSubC00vU9TltTtuGsLQSLE390kkc+wzW9LNJzdow/E5KtLmZpf27pP/AEEbb/v4KP7d0n/oI23/AH8FTaNqum6/pkeoaewkgkyOU2spHBDAjgis278X6PaeLbXw2YpZL6cfejRSkZ2lgGJIwSBnGD1FUs1qNtez1W5n7BFw67pR6ahbf9/BWgOlVdeSMaBfny1z5Dc46cVYj/1Sf7orswWM+sxbtaxnUpcg+ikzS12mQUUZooGOopmaM0ALRRmjNACiikzRmgYtFNopAWLX/j7h/wCui/zFdRXK2v8Ax9w/9dF/mK6qg3o7CVz2qH/iYS/h/IV0Nc1qrY1KUfT+QpDq7FfNGaj8xaN4osYNklFM3A96XcKLBcfmjNM3CjcKAuS5ozUe4UbhQK4+im5FG6gY6im7hRuFAh+aTNMz70uR60BcoXR/4mMLf7v860c1hanPdDWra2tYY5HaMyEySFRgMPQH1q5u1r/nzs//AAKb/wCIrxsLXp0a1VVHa7O6unOnC3RGlurBu1uItWkuIoXbHT5Tjpirm7Wv+fOz/wDApv8A4ikLa1k/6HZ9P+fpv/iK9SjmeHptvmTuefWwsqiSvaxB/aOpf8+3/kNqp6kbrU7M29xanbkMCqHIIrU360B/x52f/gU3/wARQ760EP8AoVkeM83Lf/EVq82wfZGX1Ot/Ozn7NfsdjHbwjMSAAE8k/jTHkjYYaRfzqU2eslAn2ezwB/z8N/8AE1WfTtYLZ+z2f/f8/wDxNH9rYPsg+p1f52I1vEw++xz6EU2ys4be6eaF2eQjBXcCBUh0/WCoH2az/wC/5/8AiaWzsNXtWlYW9pl8dZ2HT/gNDzbCdkP6nV/nZYMn7xN+1SWAx0q1JN9i0/WL0dY7MMB9N5rOOn6zd3UZNvaERsHwLhuueP4a0JLXWG0y+iNpZETRiPm4bvkf3fevJxeYUamMhJNWUWj0MHhnSw8k3dto5LRpi2jWoZycRjJPerIhUvuU5q7FoOpwQLDHa2YA9Jz/APE1Yi0jVY1OLWz5/wCng/8AxNYPE0b/ABHo3MyYlYiSK6jwXYsunXF1NnM8uFH+yvH881lPoer3jJGbe0ABycTnp/3zWhYanrNpf/2b9kshb4AgXz2G32J285rooYqhGV3I5cS5ShyxOoa3U/d4NQkMhwwxUPna3/z4WP8A4FN/8RWNrN7rNnLJdm1tVjjh3Oq3DHIGf9mu367h27KR56pT7G9uqi3/ACM1p/17S/8AoSU63vkmC7htJHHNRMf+KktTnpay/wDoSUsd/u8h0viRznjq7vLbW9OW8vdVsfDhidp7nTVbeJuMB2UFlXGenekuG0+T4Y+IZdN1661i2eznIkuZ/NeM+X93OAffB55qW91rxc90JNHj02WEJ+8jnikyG5+YFSe3bHasWDQdcXTPEgnih+266jLIsUDpDGdhUbe/fk4ya8WnyqEbu1rfmej7KV7E2ueI5dK8NeD9KS/l01NRtlNxeQxGSSKNIlJCBQTuO4DOOKi0bxDb2PizSbXR9d1jVbK9ZorqHUY5WMZ2kq6u6LjkYIqzeaRrNxYaC1sq2+q6Kii3l8hmVvkCOrDurAfWrsOr+NY7qE6pFpVvbclhDFLvk47FiMDJB71V6ap9OvX/AIH6i9lJvQwJvFVlrWuat/a/ibV9LgtLt7W1tdMSVRtQ4MjOiNkk54PTFYUuqahqnh/Unt7+4mubC4Jt7so0TXEa4I3DjquQRiuvutJ1/SdTvh4evbN7XUJ2uZ7KfcPKkbG4hwOh6kUabpOqPJsvpLaS4Mh+W3UiKNcdOTk9zn3rCtiKSinBLp/wdLffqVGDW5yevaq2qxaRbWM7xtqLo4dGIZExuc5HekuNYiPiG40q+1e906zs40/48kcvK7DPLKpKgAjjjNaNh4CvvD+tzy3M8Mtrbho7JUJLJGzlucgc9BxmtX+wdSh1Nta0K4tknuECXMF2rGOTaflbK8gjpSVShCfs4vRJ2fm36PoVZvUr+EdXe51O/wBOjvrnULCKNZra5uY2WQZ4ZGLKC2Dgg46Va8nVLbRHi1W4jubssxMkYAG3PyjGB2rY0qLXd0z6zLYc4EcdmGwvXJLN1PTtVLTrTVF04x6zPDPdbmBkhHy7c/L2HQe1ceIalKTVun9bfeaa2scPrSLPc6LBKuYZdTgR/cZPFdL4u0+2tU0G5gjKzjWLdVIY5wScj/PpRd+Fzq0U1j5hhnXE1tOoyUkUgqcfp+NNubDXLzWdKfX72xt7e0Yzwm1ViHlAwC27gEdce9XGvC8GpW5L3Xe5nZo9Kkt7aC1e4lkmSKNN7HzWOABk96840qLV21XxDN4L+y3emyXbSPJqDyRgXJA3rGVOWHT7wHpnvXTTRa5/xMbibVbe70VtNkEcaoFkE2c7jgdNuR169u9c/a2HiHwiq2+iahpRsdYc3S/2grqbaQqC+GHBB4xn29844N8il76bdrJ3t3180TJDtB1TSvDvw4udR3XL36XUkU8U0mwm8ZsFTg4AzjnPSsuSHRtL1/wfu1q0urp7m5n1G5S6BBkaMZJOeBn5R7AV0Xh/R7PTUXSdRu9O16PUrl7m53xIwFw2Du28jBxj/wDXWbq/hbSdV8SWc9pB4e0uy0+eRJke3jDTjbjJTbhhn1x3rrhXo+0mm3rd3+Wi/wAieVnca3Z258O3zLJI6tbsQwmYgjFEWgWRiT57v7o6XUg/rWRquo3E3gTVGtmhEtkjIxhUeXIijt6DHp6UzxJ4huF0PQ4dEuPLvtZmhS2k2BikZAZ3wwIOF9u9c2B9uk1GVrvuKokbv/CP2Q/jvP8AwLk/+Kpf7Asv795/4Fyf/FVyuveKZpPFc+g23iDT9Bis4UkuLu68sySMwyqRhyFwFwSfcVa8HeJZr/V9S0S61Sz1ZrREmh1C12gTI3GGCkqGU8cetd7jiVDnc336mdl2N7+wLL+/ef8AgXJ/8VUV1pWl2VrLdXVzcQwRLukkkvZFVR6k7ql8PzazcaXv122t7a98xh5cByu0H5T9484x3rm/iV/pFt4f0x/+Pa/1m3huF/vpkkr+ePyqKVStOr7Nzf3hyrsWNH1Dwnr901rpuq3M04Xf5bXEyMy+qhsbh7itz+wLPtJef+BUn+Nc78QES1l8MalCipcW2sQQoyjB8twQ6D2IArtqKtaajGcJOz8x8q7HHatq/hHQ742WoazcxXAAZo1nmcqD/e252/jitX7Fo/8AZh1IX05shEZvPF45TZjO7IbpiuP8Ja1pHhy78UWviG7gs9RfUZZ5DcnaZ4WxsK5+8OuAPWrXwnnF94U1K0khYWsGpTwxQSrwkZAbYQfdjke9dFVVYRclJ6W1vvfsKy7GnoupeFfEV7NaaTqtzdTQpvdVnnAAzjIJwD+Brak0G0EbHzLzO04P2qTj9a53T0SD4vanHEioi6TFhUGAPn9K7OQkxvz/AAn+VYVqtSEkoydmk9w5V2M3RpXl0WyeRiztAhLMcknFXc1m6F/yArHn/liv8q0c19QvhRxvcntD/psH/XRf5iusrkbT/j+t/wDrov8AMV11UbUdhK4rXpGXWrgZ/u/+giu2xXD6+P8Aid3P/Af/AEEUIK3wlHzm9aPOf1puKMVRyD/Of1o8+T1pmKKQEv2iT1o+0SetR4pMUwuTfaJPWl+0v3NQ0UhXJ/tLf3qPtT+tQAUUwuywLpqX7U1VqKA5mWRdN6Cl+1n0qrRRoHMyIS+Z4otGPa1kH/jy1LrXiyz0S6t7Nra8vL24DNHa2cXmSFR1YjgAfU1Ui/5GW2/69pP/AEJaz/ElrpVzrNtcp4lTR9YggIilEkeHiJ6Mj8MMivkasYyx01Lb/hz1rN0427FvVvEj3/gbXby2tdR064t7WXaLmMwyIwQkMuD78EGrEPiW10bwfpN9qc0rvNbQKoUGSWeRkHAHVia5P/hI7rVvBvjCxvru1vfsNvJFFfWy7EuAYyemcZHfHHP41T18yJbeA78akNPtLeDZJdrGsogd4UCkq2RjIIyema6FQg7Qemr/ACuRyy7HeaT40sdU1NdNkstQ069kQvDDfw+WZVHUrgkHHcdai1bxvYWeoTabb2Wo6lcwgeetjB5ghz03HIAPt1rm4LO3vPEOkXF947g1Ga2laS3gWKBCxKnPKYOMA1i6T9rtNc1+xfxcmjTtqUs/kyQQkSo+CsgZxkgjjGeMVKw1Fyfkttf8r2HaXY7SXxjpaeHl1xfOksjKsMhVMNAxO07wSMYJAPXrVzWdYtdB0xr+7WWRfMSNI4gC7sxwAoJA/Xsa53SdC0+58P69ZDXYdUGpTO006qoCylRz8vH901g6Lq0vibUfDemXJbdoiNPfK3eaMmOMH343fjUewpNtraO/pbT/ACGoy7Hd6x4nstHu4rHyLu9vpV3i1s4vMkC9NxGcAZ45NO0PxDY63FcmESwT27hJ7a5Ty5YiRkbl9+xrhdRe5sviLqcjeIP7IS9ggNvKYY5FlVVwy7n4BB5wOufpWvoWmRf2zqN7H4kj1i6eFEn8tI12DJK52cZ60qlCkqXMt7J9f8rByvqdjoOqWOtaa1/p83mws7Jv2leQcEYIBrH8eareabodrBp8gjvNRvorOGQjPlls/N+ABrZ8OXGk3uhrJovk/ZNzL+6i8tdwPzcYHOa5z4kxvFpOkasqM8emarDdTbRnEY4Y4/KuCEI/X4Ra013OiH8NlK7gvfBuqaPcprGoX9je3aWd1FfS+bhnztdTj5cEcjpXelcVwfibUrHxFf8Ah3StLuobuaTUYrxzA4cJDGCWYkdOvFdxBqNjLr39jmcfbFg+1GHac+Xu25zjHXjrW2IpynGDa97W/pcE7X7Hm0N5pMninX7fX/F+qaW6Xvl20MWoSQoE2g9BwBk11sdhBDADBeyXUSjclzLN5jOOzFu/1rUvNf8ACK6fqH2q+0po1Z1uYmeMsXGQwZepPHpmvONC0jVtT+GLWOnOlutzO5hF0zL/AKKX+7kAnkZH0NddSKqQV7pKy12Oa+pYh8Saxq3jjw7ffb7mDSrm6e2gt0cqlxGinMjAH5tzdM9gPWu78VuzafqKqo2i3bLFvavM9fg8Uwa14XgmttCRo5nSzjgaUxqQmMPkZC49K7nW7tz4cvEl2NMtsRKUJ27tvOM84qsQkpU2rf0xAkwWNOe1KNSW11e2uJhIYhbyIWWMvgkr6fQ1g20jlFYnsKuC5cDAOT6V9DUpqrBwfU5kuWVy34b8S6a/2rY0742Z2wOcdfQV0K69ZucKl2x9rWTj/wAdrz7wE5W5vEHRlXP4Z/xr1bTYlji3Eku459hXJXyajGbXMzpxNSUarRUGuWcUefJvSe/+iSf4VzXi3xLpytZmQ3EeQ2N9u4z09RXcTuAhFeY/Ew5/sv8A7a/+yUqOT0XUSuysNUlKokbmo+JtKtFXT7RLjz5OoNtJkfhir+lX1hBbKwhvd5+9/oknX/vmn2WmLFrc+oTpuLKFDHnbXSjHpXNHJ6V7tsmpiGlZHK6xqNlcWhcRXisoIJNpJjH/AHzXP6b4i0+GWW0Z5y6ncF+zvnB9sV6QVBUqRwRg157f6d9i8UIcYDIVB9V6ipq5PSWqbKpV3LQu/wBu6eepuD/27Sf4VUk1mw54uf8AwHf/AAq8UBpnlAnIrP8Asqk+rNudmfZa3p41qJf9JyVJAFu+TyO2KffeJrUufKsJp4mGSpiYYP0K81YtYEHiy0yQP3Eh5PutX/D5RvtGWX+H+Ie9ediMuownJu7tYyqVpKSiupztvq9vHYamohmiN0pEcCRvtT5cemOeKsXOu2klrpjrDI09kgHlyQOVfK4YH5evA5rsTApDKsyqp4Kk5FTM8bQggopUYxkVzqlT/lf3/wDAE5SXU5C28X2ZuE/4kv2cA8v5RJHHbC1VXxBZ2NxceXppvIJpTKN0DBkJ6g5XkV2P2iP++n/fQo+0R/3k/wC+hR7Ckvsv7xc8u5ytz4otbnQb62/s54ZJ43RIo4nwcjHJ2jmsfwL4a1u21i1n1iFUsNItpIdMfzFYyCRydxwcjCYXkDtXX65PGbOMb0/1g/iHoau2dzH9ht/mT/VqPvD0rrppUKLVNfEZqbcrM5bWPDt7ZeKrrXrDRrPWYr2KNLi0ndUdHQbQ6MwIxt4I4rZ8OR3RnuJbjwzZ6KpUCMQyI8j+u7YAAOBxk1sfaY/76f8AfQo+0x5++n/fQqZVZSjytF3KegXOsXOliTXLOK0vfMYGOJtw2g/Kchj1HvVLxnoM/iDRY47KRItQtLmO7tHf7vmoeAcdiCRW19pixy6D/gQpBdQ/89E/76FTGcoz54oLnISWXiHxTq+ktq+jx6VY6bcC7dTdrM08yj5Au3ooJJ5610QuNXPil7Y2kI0X7JvF0W+cz7x8mM5xtyc4/GrxuYT/AMtU/wC+hSfaof8Anon/AH0KqVVy3joBzesXevm/eO38IWl75bD7Ley3cYVf9oqRuGD2HpVzw7ok/hnw1JESL7UHaS5nKHb587ckAngDOBk+lbP2mE/8tU/76FH2mE/8tU/76FJ1W48iVl+YzzuB/GUXjS78Qf8ACFSFLi0S1EP9pQZBVs5znn8q9Hf/AFb/AO6f5U37RCf+Wqf99CmS3EPlt+9T7p/iHpTq1HUafLa3qIzdFP8AxIrH/riv8qvbqy9FlUaHZDP/ACxX+VX/ADVr6+K91HDJ6suWh/063/66r/Ouvri7ORTf2wz/AMtV/mK7Smb0dhK4nX/+Q3cf8B/9BFdtXEa//wAhu4/4D/6CKaCv8Jn0U0UUzjH5ozTc4ozQA7NLUeadnNAh1FMzRmgY6ijNGaBC5ozTaKAFopM0ZoEV0/5GW1/69pP/AEJaYNE07V2f7daQXGzGPNiV8dfUGm3Udx9tiurWWJHSNoyJE3AgkH1HpWboepazcG42z2i42/8ALJj6/wC1Xx9fDVK2Nk6b6n0dK8MG59kjoRoGnraG0WBFtmUqYdi7CD1GMYxT/wCxLM2wtyn7oLtEeBt2+mMdKp/aNb/5+rL/AMB2/wDi6Tz9bP8Ay9WX/gO3/wAXWv8AZFd7/mcKx8l9oktfC2kWUnmWllBA/dookU/oKjutB03UWK3tpDdKn3fOiV8fmKpapq+safbq3nWkkjnairbt/wDFViy+JNXsL+O1meyVGTe0jQsBjufvdqbyrEc3N19TSOLk1ZM62DS7W1iEVugijHRIwFA/AVAulaZp0kt0sUFu8p3SyKiq0h9yByeT+dcPL8Q7+W6MFgbeYf8APUwsoP0G6sPWPFutR3C+cIJCemVPH4ZrL+y62vn5mixM3uz0m4h0/U4vLktkuIQc4nRWB/AitHw/p9naW8sFrawwRtyRFGFB/KuA03XtWexSQNbLuJGPKPb/AIFXXabcayJ9guLRd3cwE/8As1RSwGIu4R2XS5riZfuYTfW51FhZW1hp3k2dvDbxKS2yKMIMnknA7mkuFD2YyAQz4IPcYqlIutRCTF5ZH5SeLZv/AIus66uNZXT42NzaHM2MCBvTP96sq+X1/rC5t7GVGalTb8y/ZaXp2nOz2Vha2rP94wQqm764HNa1pYWouTqH2aEXbp5Xn+WN+zOdu7rjPOPWuSgu9aeVY1uLUFyAP3Df/FV0yQa0iFjf2QAGTm1b/wCLrqp5dipNyv8AiRWqxjoVNY0TQ5roSPo2nPck7mma1Qv+ZGadGuFA7DpXPTajrE10/wC+szzjPkN/8VVa91jVbONMTWjSOdqIIDz/AOPVrLLsVLf8zn9pF7G/qCW0ssRaCGS4hO+OR0DNFnglSehPtWPrRH9iX49bd/5VmtqOsQpuaa03N1zC3/xVZ0+p6rewSW0ktp5cilWxEc4PH96nDLcQpJsvnjYswzgRqG9BUqviGSTI3MMJn+dU2XbEB/ESFH1PFT3lkHj2rcEKg2queBX0cTDdlbwQ4TVX3fdK8/ka9VspCd5z3rxvw3MYdSTDEbnUfzr1/SzvhJ966MU/3rRrjF+9bLkx+Q15t8Sj82mD0Ev/ALLXo8/Brzf4knL6b9Jf/ZaWG/ioeD/io9QRflH0p6Ns+U9O3+FMhbMY+gp5UMMGsnuczepJWF4isQ8treqOY22t9CMD9f51tI2SVPUfrSXESzQtG3RhSmuZFQdnc5WQALwKaiE8mppEKSmNhgg4qVV9q5djrTuQw6dbaheRC5t45vLDN865xx/+quW+G2mWV3JqX2i1hl2iPbvQHH3q7rS4z9onkHRUwfx//VXIfC3Bk1TntF/7NXpYWEfq1Rtdjy8XJ/WaaXmdk+gaQOBp1tkn/nkKgj0LSVkk/wCJda8f9MxWwTk7vTiqQfDSn1rmcY9jfmZz99oGmwXJC2NuFYbgNgqr/Y+nf8+UH/fAroNU/wBVC3cZFZpqlGPYwm3c5LxdptlDpkLR2sSkzAEqoH8JrU0nSNPfR7N2soCxhTJKDngVV8Z/8gqD/ruP5GtfSCBotj/1xT+QrunCKw0XbqccJP6xLXoJ/Y+nf8+UH/fAo/sbTf8Anyg/74FXTS1x2j2OrmZR/sfTv+fGD/vgUf2Pp3/PjB/3wKu5xRupcsewczKX9j6b/wA+UH/fAo/sfTf+fKD/AL4FXc0Zo5Y9g5mUv7I03/nyg/74FH9kab/z5Qf98CrmaKOWPYfMyn/ZGnf8+MH/AHwKb/ZGm/8APlB/3wKvcUlLlj2C7ERVijWONQqqMAAYAHtS5J70UZqkFyzp+f7TtOf+Wyf+hCvQx0rzzTv+Qnaf9dk/9CFehjpSZ04fZiVw/iAf8Ty4+i/+giu4rhvEDf8AE9uRjpt/9BFJO25VZNx0M7NGaM0ZqjjClxSZpc0wCiiigAooooAKKSigBxoFIaBSAKKSimAj1g+GP+Xr/gH/ALNW8/asDwx/y9f8A/rXz2H/AN/l6v8AI+k/5ls/SP5nRUtIKqapeJY2LzscEDC/WvoHsfNK97IoXFx9u1gWif6q3XfKR/Eey59O/wCFcf4xllu7v7EDtiiAAUdz1Ofzrf8ADmoWhtJmlk8uaWQljJwCO3P+etZetwKNWuHGCGYMMe4FZN3OmCaepzGn2TQyq+OQaXxFApMcg6VsxBd2AuPrWfraZtlHo1Q1c6IvWxqWKbNLt8DqW/pXoscXlSK+MYrgYxt0+2Hsf6V6c8IwuPSufDr99U+R2Y52wtH5/mWrhQ9mXPUxn+VYGobzp0CocZnJP/fNbgJOnyqeqqf5Gsa8OLCE9vPI/Nf/AK1c2L/3yPozPC/wJeouh28j6pGZcEJ83Hr/AJNbHiG9+z2n2dG+eUfN7L/9eq+hMEeac8BE/wA/yrM1mfzJwZD87/Mfb0r0aGkDkr61DJmnjtLZ7iZwsaDLE1k2YkvJzfTjDNwi/wBxew+tZVxe/wBuawLWB86fbN8xHSRx/QV0EeI1wBiruRYivckcDNZsbL5uCcED61Nd6gguUhbKl++M4qMxAT7SBz1I9KLjJQc3sKngIpkP4cD+dR3VwXJVepFOjlV7u47gbU/qf6Uk5RVYotNbjW5z1jMYbuJ/SRT+te3aHzYI3rmvCsnYT3Fe6aB/yC7f3QH862xP8Zm+N/iMu3HQ15t8R/v6b9JP/Za9Jn+9Xm3xI/1un+mJMf8AjtPDfxkLBfxUemxNtA9MCrAINVFOFX6U8OQKxb1OZ7ssMOMjhh0NKrh0DD8faqxkNMMhifzP4G4cenvS5guZ+soI50mAwH6/WoYWEi5FaGrwm402XYMso3r+H/1q5+znJwo6nA/GueatI6qbvA6azTyrJ2PV2P8AhXC/C7g6r7iIf+h135AWLYB8qqAK87+GnMuo/SP/ANmr1cNphqnyPLxLviafzPRGfJwvQVUB5arBPBwox61WAy2K4WzoIdSGbVfY1k1uXybrN/bmsOtFsZT3Od8Zn/iVQf8AXcfyNa2kn/iT2X/XFP5Csnxn/wAgqD/ruP5GtXSv+QPZ/wDXFP5Cu+p/ukfU4YL/AGiXoXaWkpa4TrQlFFFAC5pM0E0lAxc0ZpKKAAmlBpM0gNADqTNJSUWGXNOP/EztP+uyf+hCvRB0rznTf+Qna/8AXZP/AEIV6MOlJnTh9mFcH4h3f29chR/d/wDQRXeVw3iCVE125BPPy/8AoIrOpsbS1RmqrEdKXYaiTU4Wn8kMN1Teei8k1Kq2Od0RpGKKjN2jvgU8GtYyTMZQcXqLRRmjNUSLRRmkzTAKKTNLmkAtFGaM0wCijNGaAGmsHwz966H+7/Wt41geGPv3P/Af6187h/8Af5er/I+k/wCZbP0j+Z0IrkfF955uy0RuBycV1c0ghiaQ/wAIzXCCGLV/EXlXO5k8pmwrFecj0+te3iKqpQcn0PBowuxDCh0aZCAR5eB9TSy2jWDrFFkqVAwe3FdJH4Z01rZVKTYLjI89/wDGnXfhnTXkGVnOPWd/8a8v+1qPZnX7NnLi1c4PGazdaixa9ehrtf8AhGtOHCicD0+0P/jVa88MaX9nJMUpPvM/P60v7Wo9mNU2mZGMWVt7rn+VepBcov0rjf8AhGtMNrB+7m+7/wA93/xrqk0CyManfd8/9Pcn/wAVWNHNKKqzdn0OrFpzw9KPa5Yb5YJv9w/yrGvV/wCJbCfS5/8AZa0W8PWWx/3l30/5+pP8aqy+GbSaxG03TsrggG6f0+tc2IzKlPFRlZ7MihFxpNeYtg5FsVX/AJaShfwHJ/nXD/EHWHjlk06zciaVdruvVE9Pqa7az0CxePBa6G054uZP8a5HUtC0aO9nu7pWWMP880tywA+pJruhmlPlSSZhOk3O5jaBYpa24AUAgDNbbHirNjouh3lsstnKZ4um+G7ZlP4hqsHw3puPuz/+BD/41TzSnF2aYvZNnE6kd87MOCp4NaNvNm2WR+u3n3qxe6b4ctbnyrq6ihkPISW7Kk/QE1PcaTo1rYM8xdIsffa5YD+dNZpT/leoeyZj6NcC6ju5gc5uGH5YH9Ks3bbLdzV3w/omg3Wmg2ciygMd/kXRYAkk84PFJ4g0azstNaWASiQSIAxlY4ywHQmrhmdNzUHFpgqTZx7N5dlcNgE4GM/jXumgjbpVoP8Apkv8hXhUx/0Cb3dF/Mmve9MUR2MSD+FFH6V7GJ/jMrG/xGiaf71ec/Ej/W6d9JP/AGWvRLj71ec/Ej/W6d9JP/ZaMN/GQYP+Kj0r+FfpQKF5UfQUHisHucr3DNNY8YPKnqKXNGQeDSYhtuwXfA5+Xqh9RWPZ2Bi154yuEhy59/StKUEMpBwynINTCUKn2lEJmkAQj3Hr9Klq5pGXKgupM5gT7xGWPoP/AK9cB8OTj+01/vCIf+h13+xYIWZ/mkblj615/wDDn7+o/SP/ANmr0cP/ALvU+RwV/wDeKfzO6SPjId1Ps1PhGZtrHJHf1pC2FqushXUEB4JWuA7FqX7hN1vIo7qR+lc3mup6iuXddkjr6MRWqMZo5zxif+JVD/12H8jWtpR/4k9n/wBcU/kKyfGX/IKh/wCu4/ka1dK/5A9n/wBcU/kK7qn+6R9Thh/vMvQu5ooxRXEdQlFLRQAZpKXFJigaQUGgUGmMQnFLRRQAlFFFMCzpv/ITtP8Arun/AKEK9HHSvONM/wCQnaf9dk/9CFejjpUM6cPswrgfESj+37skdQo/8dFd9Xn3iJ/+Kiu1J4GzH/fArKpsdBzMOlxpqb3WSC3btW0bdJV4YCq7CMj7wH1pVdScBgfxrEAFj5cmdwP41Mh7elSxplc0w434FVB2ZlUjzRFxSU7ZRsrqOIbRin7PWk2UAJgd6OO1OC0bAKAG0U7YKNooAbRmn7RRsFAEZNYHhk/Pc/8AAf610LgA4rnfDbJEl5I5wqhSf1r57D/79L1f5H0i/wCRdNeUfzLmuXJjh8pep61y+ikHxPgHP7h/5rVy/umundgeCaoeHvm8UH/rg381r0cfrQkeRRjZm9revanpet6Jpmm2sFxJqAlwspKhSoGGJHQDJJ4OQOKjt9b1aDxNFo+uwWglu42ktp7QtscryykNyCBzWX4m1SW38a+GLu0tZLhoI7kvCMBmQqAdue4GSB3xilW8m8ReMtO1Eafd2djpqSlTdR7HleRduAM9AB1rx40V7Nc0dLPXrfWx1uLvYvapqfiGzuZfKm0OGEMTFFdTOJJF+vAGaqar4sd/h8uv2cKh5AoMT/MAd4RhwRnnOKxbOKK0udRTVPC82p6rPdSPHcSQLJFIpPyfO3CADjHb9KiWyvB8Jl082U/2pZwTEIju/wBfnheuMc9OlafV6a5brqvmvvBRk+h0k+ua9pR0241K0sF025mWArEzGaAt0LE/KffAqxL/AMJM3xcmXTZdJEw0YCP7THIV8nzuh2sPn3Z5HGPeq/jHzLrRbSGCCaVkvYXIjQscBsk4FW7zW/7J+IcWunTr+7spNK+yH7LF5jq4l38gHpjvUUIx1nGKTaa9drGlSMuRRfQ19Q8Qa7N4iHh7Tk0pbuKxW4uJrwuFcngiJAckZB5J/wDr6cV/rWneG7m7vbCC61G3VmS2snbbNjoFJBIJ+h6VzfiLW/DuuSJFqvhHVb4mNWgnittzrkZ25Vg6EHtTPD2p6l4Z8LXzX1lfTuJZJrC0lfdMIOAiMeTu4PHOOK56tBS5ZJJPt39Hf7+xEItRasd9aOZtPgu3tzbvNCJGgPWMlQSp9x0ryrWIU1bx7pWl3irJaQ28l20TDKu+doLDvjrXe23iWKfTo5Htp4WljDGNgMoSORzjpXCa6Li08SaZ4gtbSW6SCN7e5hiGXKHkFR3we1GHg41HpZ2dvWwOErbE0UEGi/EaCCyiSC21KxYyRIAqmRG4bA744rpNUuzY6ZdXYAJgheTHrhSf6VzGnTT6v4vGtTWFzaWdrbG3t47hNsjux+ZtvYY4rSTUjrMWp2NzYT20Ss9uHcH96pGNy8Djn3q6tNuUW1eyVw5GcDo2oWiaINRu/D82orLukvb+REYsxOW2qxyVXpxgcGuyu7fS9W0q0lEEU9uqB7cMuVUEYBwfb1rmYJ9R0vw62gHRL2W7jjeCKWKPMMmScMW6AYPINWL8ap4e8I2FhY2s91ehRGzxRNIIj1ZsAdAelb4ilOcrw0d9NeglFroXLaytY/iPpsWjwpEba1kOpmFQF2kfIGx/Fnn16eldD4pGdJf/AK6x/wDoYrH8H3tjp9umnw6XqyXU7F7i8ubRlEr8kszHp6D8K1/EWW0eT/rpH/6GKyldYinF9LLXrqLZHBRW73TRQIMtJcRgD8TXvlqB5K4rxXw1GJNctFPQS7/yVj/SvarQYhX6V9biV+9ZljH+9YXPrXnHxG5l0/6Sf+y16Pc9K84+I3+t0/6Sf+y0sN/GQYP+Kj0qPoB7UN97FNThR9Kf1rB7nM9xuKYRUxFNxQIYcOuCKZGfJkPzDntVhUB61WNkouTJvJBOee1TJPoXGwsz7gx9RiuB+HHL6l9I/wD2au7ZeDXC/DcDfqXHaP8A9mr0MP8A7tU+Rw1v94p/M7ljxiq0vGoRH1XFWitVbj/j9h9xXns7I7muOgrnbldt1KP9o10C9BWFfjF5J74P6VqjOpscp4yH/Eqh/wCuw/ka1tJH/Ens/wDrin8hWV4yP/Eqg/67j/0Fq19JI/sezz/zxT+Qrvqf7pH1POh/vEvQt4oxRuHajdXEdgmKXFGaN1AgxRiikzQULtoxSbjSbqAHYpMUbqTNArhijFJRmi4y3po/4mlr/wBdk/8AQhXotec6a3/E0tB/02T/ANCFejUmdOH2YV5Z4uW4bxXd7XxGNmB/wBa9TrzrxYu3XLiQYz8vXv8AKKyqbHQYOdyAMSMUQhUfg5qx5kJj+Zce9UxDI8haEcVgxXNNb1Rhc80B/OmwrYIqtFaOPmbG6pUgMdwGLgZ4poT1RorjGM5p2KiEJiOd2QaXJ9a6YSujinHlY8ijFNDU4GrICikzRmgQUUUUAGKOaKM0ARv96uMtJzHBPGDjeVz+Gf8AGuzc/NXBR3EUDhJHVWf7oJ6/SvnaH+/S9X+R9PD/AJF8vSP5k8m2K0J4yeaq+FiW8R7vWF/5rU982LZhjkiqWlWwlmWTfIjjjdG5U4/CvWxFP2sHBPc8eDs7nVW+jWt7q9tqc5cy2SusaDGxt4wdwI56DGMVr+TF/wA8k/KuA8PrLcG4827ujtCkYnYevvWkIHJx9qu//Ah/8a87EZTWU+Vz2OqvU5ZtHW+VH/zzT/vkVHJCg+YIv5VzH2ST/n6u/wDwIf8AxprWzEFWubvBH/Pw/wDjWP8AZNX+Yz+sHTKimNSVXJ68V0AtLN4xttoR/wAAFeOWk1z9uvLKS6u8wMDu+0Nzuz7+1W7Dxv4buQpbVr61mA5EssoB/ImsKeWVHUkubax2Vm1Qpy73PXvJsUTd9lhVx90iMZBpUtIJ4y00McjZxllBrz211vQL2WKGPWA8kjBUVL98kkgAYLVJqGq6Vod8kV3qUsZZA/lSXjqWGTyPm+tYzy6axMYuWtmZRnJ0W0dzPYWiRsRbRAgHogrn0iTIyi/lTrKTR9b06S503ULidVB3bL1yQf8AvquJXz92Ee7I/vNdOB/Ou7+yav8AOc8a72O3MUf/ADzX8qa0UYH3B+Fcb5b4BF5d/T7Q/wDjTSsn/P1df9/3/wAaX9k1f5ivbnT6hGVtt8WVKHJx3FVLISXNwX+YrGv3S3BPbNcxdJKyugu7oblIz5zH+tUPBsd00Fyl/eXW/wAxlUiZh0OD0PtQspq/zDVY9BiIB5putRg6IzbePNj/APQxXI6BaPqP2gT3l5+72kbZ2HXPv7Vu3NnbwW6jzp5MHIDzuwyOnBNdH9kVKWITlJaWKxFS03Gxg+El36/GB/DG7/pj+tezWn+qA9hXkXguPdqlxLj7luw/Mj/CvXbUYjH0r38T/EZhjNaz+QlzXl3xAn8zUbdO0asP5V6jcdCa8m8cn/icovomf8/lWeHf79f10Lwa/enra/dH0p69cU1OY1PtThxzWT3OV7jjxTaUsCMUgFBIoprcCnjimSNwaAIG/wBUT7Vwnw2+/qX0j/8AZq7of6o/SuE+G/39S+kf/s1d+H/3ap8jkrf7xT+Z3zDGKo3XF1b+5I/lVzO6qd4QLu0z3Yj9K86R2R3NRPuisfVFxdg+qithPuiszVx88TeoIrWOxEzivGQ/4lUH/Xcf+gtWtpI/4lFn/wBcU/kKyfGR/wCJVB/13H/oLVraSf8AiT2f/XFP5Cu+p/ukfVnnQ/3mXoXNtG00uaM1xHWJijFLmjNAhKSnUtADMUnSn4pNoNAxtNqXaKTaKAI6TNTbFpNi0AS6Yf8AibWf/XZP/QhXpNed6ag/tO1/67J/6EK9EFI6sPswrzHxY+fEt4uemz/0Ba9OrzDxRHu8VX5/65/+gLWVXY6ChHKjxBGQVaybdRsTII7VQt3RWxkGtAXKFNtYkspXWovESwQ4AyaqWGqDUZS3QKeK0Z2glUxSD73ArPOmR6Z88K4QntQNI0Jb1hKvOR0xV9WDKGHesZdsse8emauabOZoTwRg960pS1Ma0Va5eBpS1MNJmug5B2aXJpuaXNAC5NGaTNGaADNBNIaUUANPQmuW0rT7XVLW7tryFZYm2cHqDzyD2NdUwrn/AA1x9q/4B/WvnsPrjper/I+k1WWza7R/M5rVvCOt6dGzaPfG6t8k+RMRvHsCev6VlaT4lazneC/s3jkUlWVRhlPupr1msfXfDVhrkRM8e24UfJOvDKf6j2r3nT10PDp1ekjlfCxG+7GRnapxn61vQp++Fed3TvCqypvXa2PMXgKfc9q0tM8Tajbkeay3EeMHzOoH1FaYudqzTO7Ew5qjsdwVBY4qGRfmzWbp/iSznVvODwtjuMj8xWik0M4/dSxvwD8rCsVJPY5WmmZN3bLHqMk6gDzY0B9yC3+NeGn7zfWvcJtTtby/mtbeRZGtgvmMpyAWzx+leHlfnb61y0P41T5Hq1/90pfP8zX8Kf8AI26N/wBfsP8A6GK7H4wQu/iC2kCjalmoJyOPnftXIeFB/wAVdo//AF+w/wDoYrrvjCz/APCSWi7iFNmpI9971nU/3yHo/wBDGH8CXqcV4f1/UfD+pLdafO0bkhXX+Fx6Ed69lXb5XPGa8Er3iBke2hc85RSPyr0Gcch3QcU01IQDTW4FIgq3H+rLelQ6Z9ourKeSy8likrK4/iBp12/+jv8ASsDwPqn2bxHf2jk7JgXA7ZFJbjRtaHMY3nIYqMDJ/Ota7vozZSNEQzAdKzNB04agl0u4rt2dD1zmpLnRryyuPMtI2ZP4lz1HeunE/wAVm+Ja9szS8CgNJfEjsg/9C/wr1O3/ANWv0ry/wFzLej18v/2avUYhiNfpRif4jM8V/Hl8vyEn+5XjviuRrjVJJyePNeJfou3/ABr2Kb/Vn2rx/wATx7VhYjBe5uG+vzCs8Ov9oXz/ACNMH/EPYkyY16DjtSkerE01PuD6UprJ7nK9wyO1LUY+9TwaBEgqvK4ORUxbgiqDJcR3OCqlD6d6UnYaVyUcRkVwnw3+9qf0j/8AZq7r+A1w3w45fUvpH/7NXfh3/s1T5HFW/wB4p/M7pSKo35H26xycDc38hVj7hIqlq7lYraQdpQPzrzmdsVqbifdFUdXUG2Rscq1XEPFQaipexkx2wfyrWL0JmtDz/wAY/wDIKh/67D+RrV0j/kD2f/XFP5Csjxh/yCov+uw/ka1tJ/5BFl/1xT+Qr0Kn+6R9WeZD/eZehezRmkzS5riOoKM0UYoAM0ZNGKMUDE3Ub6KMUAG+jdRRQIN9Jv8AalppFA0WtNf/AImloMdZk/8AQhXo9ecaaP8AiaWZ/wCm6f8AoQr0fFI6sPsxa8r8ZM6eJL4x/ewn/oC16pXBeIYLZ9cvGkA3kpnI/wBgVlV2Og8zWDV7OXz2/exOeQp6V0VvnaGPXHNaDwR7eCpX0qEQq78EisRMg81HmVCDnPert5G0lvtzTRZAnIPPripJPMUYPpQFyjbBYgQ3TvV+0kjfd5f/AOusuSKYnpTLKWWOcx44zSTadxSipKx0ByOopop2cxCowa64yujilBofTqjzRupkDqSk3UbqYDsUuDTc0u6kAEVgeGh/x8/8A/rW8WzVOy06HTy5iZzvxncR2/8A1181GsqONlKSdr9j6SFp4F001dpfgy9jimsPlP0o3e9IeQfmNems2or7L+48tZfU7r7zjPBkUcy6jHKiujBAVYZB+9VXX/CK6ej3elxsbY8ywA5MY9V9vbtXS6Lp+mWBnNhd+fv27/3ittxnHTp1NbAnjUEB159xTxOa0Jzb5X9x11sJVdZzi0eWstva2jzSMNiKWY15nf3z32oTXBJG88DPQDpXueteHPDk0Lpe6h9iinOQouEjX3C7u2a50eBvAn/Qd/O+i/wrCnmNJLZ/cweEm+xzfw/wE1D6x/8As1cOy4dsete4aToXg7RhN9l1yI+bjdvvIj0zj+dZLeB/ATHJ8Q9f+n+H/CppY6Cqzk07O3RnVWpuVCnTTV1c868Kl/8AhLtHwf8Al9h/9DFdb8Ycf8JLZ/8AXkv/AKG9b+n+EvA+m6hbX0HiBTLbyrKga+hIJU5GePauY+K1/Z6h4jtXsrqC5jW0VS8MgcA734yPrVRrKvi4yinZJ7qxzuHs6DUnq2efV7VpcxfR7B1PDW6H/wAdFeKnivYvCvm3PhvTWiRCRHtbe2AMEj09q9ZnFLY21yUyetNkIEZPepdrIPnZGJ/uVDOcRGpZmjLuZIxgSglWPQHFY/hezE2sarMFRGUKqkDoOTxVrV5PLgMmcbef1qx4QSM/2lJkHfMACPoKS3K2Nbwk203j+gT/ANmrYvtQm8hhAq7xXOeH5GU3Eag5fb0/GtiZRHGXY8Ac11Yl/vX8jbEr98xvgHie8P8A1zH/AKFXqkf3F+leW+Av9defWP8A9mr1SP7g+lGJ/iszxWlaXy/IY/IxivJ/GQCw6fx1aY/qtesN1ry74gALNZqvADS/zWpw/wDHT9S8H/EPUI/9Wp9qe1JF/ql+lBrB7nM9xtOFJiloEFTRkng9KhqSM4akBR/gb2rhvhv9/UvpH/7NXb/89Pqa4n4b/f1L6R/+zV3UP92qfI463+8U/mdwy7h7iqGqReZZqPSaM/8AjwrRYcVVvv8Ajzc+jL/6EK4Hsdq3L0bfKPpUjoJImQ/xCq8LbkU+1Wh0qosTVzzXxgMaZEP+mw/k1aulf8gez/64p/IVm+OU8m12Dgfacj8ia0NJ/wCQPZ8/8sU/kK9Gf+6R9TzI6YmXoXs0bqZRXGdQ/dRmkooAN1G6ikNAxN9G40EUUALuo3UlFAC7qaTS00mgC5pp/wCJrZj1nT/0IV6SK800z/kLWX/XdP8A0IV6XUnVQWgV5t4qEz+I7tIh12c/8AWvSa8/8Ru0fiC6dVJ+70/3RWdTY2ZhW1vKmVlY8mraQYfiqKaoHuSjjA9TUNxqLG48uJhgHnmsrhY3kTaMDk07ZI3WP9KpW99tRWI3VoJqCsuTx7UEjorVDyVGaHsoCc7Bmmf2nEJAgPJqO4v0ZsLwfagLgYRv2BgB70r2rqMgg/Ssqe3uLi5BFyyJ1wDzWjHL5fyLJuIpptCcU9xhUg4IoKletRvqBEhVkxjvQt4kz7Qwq1UfUydJdB+KMVM0sMYAJBNRS3MezPQCq9oiPYsBycUrQuvJFUY9UjTJznBxioLrWysZYcn+7SdRDVFmoFPoaXFZ1jr6XNsqMCJe61dS5iIy1NTQOk+g88UhxsbPHFQPfxoxAXNRxXazMQcAY9aOdXHCk76nI+FHZINQ2H5iEx/49W1Z3DSPsm+U+pPWsPws0ax3u44PyY5/3q6KKyW8O9nwPanjF+9Z6GIdqjOD+LsRFjps0RBRJHVsepAx/wCgmvLUZguGr1/4k6P5PhtbhXdlSdcgnPUEV5GyVnDaxje4fjTTRkDjNBaqENzSHpTs0HmmgICOa9U8DuJvDEKk8xyOv65/rXljHmvRPh5cY0y7i5+WYPx7j/61UxS2O2RMdyfrVe8YhQBVnzh5ZOCKzbmXdnNQzNGHqzhYnD8qRg1oeArcjQnkRSymd24HpgAVjaystyY7eBC8srBEUdya9V0Hw+dL0G3s49o8tPm926k/nmnHcpnHeH7g2zzN5RdTtBYfw9at6jLMJFDsBDN8uR2zTfDEYdb3cm5cJnI470urW7pbBYeQDnaT0H410Yr+K/kb4j+My74CYCa6XuzRY/8AHq9Xj+4PpXlHgBQ15c57GP8A9mr1eP7i/SjE/wAVmeMX75kUnWvM/iMNt1Z47+Yf/Qa9NcZNea/EsbbuwHqrn/0Glhv4yKwf8VHpcX+rUe1LSRf6tT7UtYPc5XuFBpaDQA2lBxSUE4FICk//AC0+priPhx9/UvpH/wCzV27j7xriPhx9/UvpH/7NXdh/92qfI46/+8U/md2CR1qvfc2M3spP5VZqGcBoXU9CpFcEtjtW4+yYPEpHTFXM1kaC/m2IfOTnB/CtanDYJaM4T4jRlbWFgMBpF/kwqbSWP9j2fH/LFP5CnfEfnR7Vv+nj/wBlNV7HVEj0uwgMJLGFBkD2r0KkrYSPqzzoQcsVJeRpZozThA7R7wKjKkda5E0zp5WhSwpQwpgFKRTESAg96MVHnFLvoAfijFM8w0eYe9ADsCjbSbxil8xcUAGKMUm8UuQaALWmj/ia2f8A13T/ANCFej15xpv/ACFLP/run/oQr0epOqhsFea+LtUkttbvIo0VuFHP+4K9KNeP+PbqKHxReKW+fCHH/AFrKq7I3MWV5miZgB5rVSh06dczyTtuPJAqIatEG+diB71p7Ibm1Mkc4PfGa57jNiwltpLdVSYEjrzU7xxMyBpsDPY4zXEQThbx1YuijqR3raigivthW5xj0arWomjYkuLKCfy967vU1eRbdot5I6ZrmZvDEc7FvtEgY9w1KuiXtvB5a37Mvv1pk2LV/r9vZsY2yaqf8JTb2p3nOCO9Qf8ACOpdOpklYletS3vg9DB8kvTsec0wEs9fOsNIlvGcg9e1WxaXVq32l2AA+8tJp2nPY2bLbIm/GcYxVG71e9BMFwhVe5HSkBvW1/HPIu2Nip6GtN0gnXYynH0rI0q8t/sy4ZRjrxV6TU7aIAsw60CJF0GFhlM06DQoY5SzYx9K0bS5SWLKHgjNEwMiEZIPtTsK7Kh0W0E3mpgNUB0dvPMqnIPakbzouu6rFrLNjO7j3oC5RuLYRZDLVQWsZLOj4OK0r6dSCjOC3YZqK1sGMLOw5PNNbjR59oiyMLgIpI+XJHbrW5baqImMP8S+9HgGNZG1AMMjEf8A7NXSzaFbSyb9mG9cV0Yz+KzoxL/es4Tx3evfeEZkVCAkiO303Y/rXj7LxXufj61Sz8HXm0cnYmfqwrw6RgorBGKITGM0bcUGYDtUbSkjFXYB+KaTURYnvSVVhgxya7T4eTEXl7b/AN6NXH4HH9a4uuh8FT+T4mhXtIjJ+mR+oFD2E9j09pGX5TVS45HB59KuSdScZqlOSqMw64rJshHOyazcaTrCTW6xmU/IrOM7M9x7/wCNdYuq63a3kVuusyMDlijxKQ2OvbP61xka+Z4ks3KI4WQMUddynHPI/Cuglu/tXji0ZYIbcKhVlUHHTnAzx+FYzk7qx1UIq15I1/DGrWumPcpdLJsmCgOqkhcZ646da19RtobiDz7ORZFYHG3vXFRXos2IJI3+nt/+utXw7a3p1CW9t5VXTWbDRn+JhzlR2rqxVR/WHH0NcTRXNzXNv4dru1C6+if1r1YdBXjHhaa+hhvm0+RI5yEG9gDgfN0zxVSfXvEq3MsF3q92sgyDh9gPuMVWMq8lV6Gdei6lV2Z7gRmvNficmLvTj1BR/wD2WuU1S51l0tGh1e9wX/eL9pYEjIHrUmsG5W1tYrm6luDG8oUyOWx93oT2pYOrz1o6dx0MO6dRNs9uT7gp+M1DA+Yl+lTGpe558txtKaT1ozmgQmKRh8ppSDSMDtNSwKbfdauJ+HHD6l9I/wD2au3cfK1cP8ODh9S+kf8A7NXfh/8AdqvyOOv/ALxT+Z3gqG44jP0qbcDyKr3DDymz6V58nodsdyj4XYfY507rO/8APNbjAsOKxfDiBNPZx/y0lZv6f0rdBIFOD0HPc474jnGgWox/y9D/ANAaqui7Dp9qXAOIl6/SrXxI/wCQBbf9fQ/9Aas3SmKadbHP/LNf5V3V3/skPVnHQ/3ufodTFcRsmM0kqwOOWArk9V1OK3hLCcK3sa5+w1G/1OZv9IxFn1rzeZ9D0XBM7rzoHkZIWyV604VR0yKKNQQfm7mtN48DIIIraM+jOadOz0IyM0mKM0ma1MhKKKU0ANxQBThSnHagBmKAaWgigC1ph/4m1l/13T/0IV6VXmelj/ib2f8A13T/ANCFem4qTpobAa+f/iM7j4g6pjkDyv8A0UlfQBrw74gop8baiQPm/d8/9s1rCv8ACdCOS8iK5gzIMMKtJFBFCCkhU47GqgSXeMcg02VhyneuVMZalkK4yNynvUcd3JBIGjYgCqyecRhs4rQRIWtmwPnFUpMR0dneyXlooBAY9TmtKGwzH802T9a4S21C5thhMgZ6VYTxLexOFcmrUhWOyJjt22bxn61ZMAuIiol259K87n1hppTIXIarFp4mki+QljjuKakhNHW2GlXFnPKz3G+NjwDUk2lR3IcyYbJrAg8TvJMFlLBfetlNSidNyy1V0xNMpz6UGQRREoVPai50fzLMD7QyuvfrV/7XEy7xy3TipZbJtQsyVO2iwinYDUbaJVDhgorR/th4VAliYH1xXMXF7eWU6wqzcHmt2zvo7kBZQCfWncDSj1KKZCWYYA6Gud1bxWlszQW4yx4Fat1ZwYDxPtPpVN9Hs5GWRoxvHegQmjrmMXF05eR+cHtXSG5xASuAMVgCyjjcGN8Ads1qo4EIBGafUZyngVmRr8qeyf8As1dgLtguTXF+CiRNd444T/2auruJo41LNx610Yv+KzfEr96znfibOD4IlK9WniB+mc/0rwWb79ezePr+K68L3EEfVXR+vof/AK9eMScsawiZERA700he1ONNNaIBlFFFUMKt6Xc/Y9VtbntFKrH6Z5ovbCSxFqZDn7RAs68dASf8KqUAe4ucjpwapXfERqPRLz7dolpPuyTGFP1HB/UU+8OVxWUtCEYmn339l6yLw2onKqyqpOOTxmtbT86dqMus3yxpOwzBG+G2n1/Lise7gJOe4qTTbX7RqEEc481C4BV+eK55Jt3R00qijo0SfYX1C4igjUlzkewHGSa72zMenadFZRjARcZ9T3NYXhyRYhdFjgfLz+dX5buKSZUjJZzwAK6sWrV2/Q0xMm52MqLStQt1Yw3Kx567HYZ/SnDRtSuEy90jc9Hdj/Suqh0pmjBdhn6VdNukFsY9oIIOat4uo97EfWZI4SXQ7/zI42Kup+6wYlQf6VoQ+ENYvkU+fCVHQSSNx+lb626YBAwfUdq0Yp7q3jHkuv8AusvFCxdRa2Q3ipnWW6ERqDVkiuZXXru2QeZbRycfwtj/ABqRPFabcyWUo/3WBrH2i6nC4M6DFMYYrG/4SzT+jpcIfdP8DUq+JNKkOBdAf7ykf0p88X1E4S7GmDSt9w1Si1WwmfbHdwM3Zd4z+VW96vGdrA/ShtCsyttyj/SuE+HJAfUs+kf/ALNXeAZUr6iuH/4Vs3/QVX/vx/8AZV3YWdL2U6dSVr2OPFQqe0hOEb2uduGU96ydVndbdxHjJFc43w4ZRn+1FP8A2w/+yqvL4DaLrqIx6mH/AOypPD4a38X8GONbEJ39n+Jz2pSeJxLDKmotbWsfyxxJgIPqByT71p6HLr0A82bV71lPIV5c5Prz0qG98Nm1A8q5MzZ6eVtH55qxD4SZ0DSXqx+3l5/rWTwuFf8Ay+/BnQ8ZXtb2P4k3ia+1C60qFLqUyIJgRuA4O01fsWB0m1XAH7len0qmngfzVymogn0MP/2VbdvYzWdnFDIdwiQJuxjOKvEypKhGnTlzWZjQjVdeVScbXRwHi/TSLdp4C27PzDPGKb4cRo7eIK3Wuw1S3jkt3UrkMOa49LSfTrgqnMZOQa89I9E6qeaaGNVhBy3pUtjNdpMqzSkg9qhsnkkgV5OuKkjjKT+YT3qhPU3Rk9BTGODispvEUFncGOdgD2561et9Sg1BsxYxWsJ9Gc86fVE4Jozmg8UgOa1MR2aM0maM0gFpabmlzRcC1pn/ACFrP/run/oQr0qvNdM/5C1l/wBd0/8AQhXpdI6KGwGvE/H8THxhqL9j5eP+/a17ZXg3xI1T7J421GLGeYh+HlLWGI+E3MaB4upYEKcGpDZ2zFpeOec1y327NzIYQQjc9asR6myIUkk69BXIUdPFDBcRkKwyOKpyRmC52n7tYR1C5EgECMw9egrb03URd/urpDGeilu9UmBNJPEqkbRmqUsMEy5ckE+lXH0mRWOH3ZPemCydQY2X5qBGO2muSSso29qg+zy27ncuR7VvjSpsff8AwqUWpA8vA3UDMVEcrnYRVqJp0T5d2K1o9OlRdw2n2p0Ckq3yj71CAy4dTlUgMx4961V8TXEUAjjGcelI2lxSncQB7AVA+n+UTswapNhYu213JfHdJCSx71u6dBbW8RMnDk965m2u7iwYN5eVrftNSttQG0rhgORVqSJaLctxaSDCSrntWVe3s0C8IWHYiq+o6Hif7RbykY7U62vzHEFmTJquYmwllqyCTMwYexFakWtq8vEJKeuKzb6SyvrZoxhZQMj1rEW/u7SMxqu8DvQpq5SRpeDHjje8aQ44TH/j1buoxRXkLItztJrhNPvZbXzFjXIkxn8M/wCNWJZ5m+Ysy/Q1vjJWrNG2JX7xh4j8Lz23hu/uzdh1jj3bcdea8jc5avX9Z1aWXwnfWvLb4SD7V4+2N3FZQs1oYbDDSUppprVAI1IoLMAOpOBQTVzSIvO1myj9Z0/mKYzq/iDpxs7fRn24223kkf7uP8a4fNeo/EYNd6NHOOVhlB/Pj/CvLqUXoB3ngLUA8E+nu3zIfMjHt3/X+ddVOu415Jpt/Lpl/Fdwn54znHYjuD+FemW+v6Ze2qzi6jiZh80cjAFT6c1MkIbLHkmp9Ijxq9tx/wAtAfyrHuvE+lQEgTGRh2jXP69Kj8M6/Lq3imKAII4PLkIHU5CkjmoUXcaOt0Gy+2Wt+m/bhVOfzrQ8NQwrPIZSrMhwD61Q8LyD7XLCzELIADjv1rrW0yxgUsgwTzkGt8Yr1mzXEv8AeMvFtw3DpULs0gC4quxxDiKXn3NRWbXBnAkIKk9q57GG5ZEZC4PY1aQZSkKkMQalUfLSQmySSIPbKcc4qobfjpWinNrUOKbSEmZU1qD2qo1tjtW5JGCKqtFz0qHFFqbOSuomHiPTx/e3j/x0mt3ZN2nkH0Yiql5bk+INNx6uf/HTW55IpKJTkZywzt0uJf8Avs1PDFdqebuf/v4f8a0IoRjNSiMVSiQ5EFvHcs+GupyP981a+zgdSWPqTmpol2AGpMVaRm3qUGCrMV2g/WiUxyx7GAGO9U57kx6nPGegIx+QqX5sbiKTKSvqSxPHbEHeMe5pbjUY5ISFOecVQu7VJodwmKH2NRWNuGj2bt7g80mMkvYtsPzfxCsbCmMxvXXNYi4Qb+wxWTe6HKz7oiMe9A7mXYgRAs8g256VnaxrAFwlvakls5yO1WJ/C14+4tO6qey0WXhGWCQuT5h/2qLjRj32mvdMssh+bHatmzzpdn5oYnAqS9srmGIkxMSOwFUZGe6sjDtIIHINSUdLp+opeQK5PX1q6cZ4NcJpc8qyfZhklT0FdfaRzyxLvQqcVpGTRjKCZd2mjFSWwO7ZJ2p0wRW+WtFNdTF02Q4oPFO2Mw+XmkKsv3gRV3RLiyzph/4m1l/13T/0IV6ZXmemf8hay/67p/6EK9MoN6OwV84/FGY/8J/rSY4Bhx/35Svo6vmT4sQTP8TNXeOQgHyePT9ylYYhe6bHHSXaw/IOX74p1mJL26jVgVyafb2TgNJKoyD+Jre0iO2jCSsu59+BXI2hiavYGziAtnIOOOelZNvfs1zHHK5bBx15BrW8TmSRJSj52Dsa5CxVlIlbls5pqzVxnr9g63FsGBzgU5ot2WJ5ArkNA1aRWaNmyuOlbY1KRc/LnJ9aTkMsK0xlC7cD3qSazlt3EzEEYzgVHDeeY24rnFaM0n2m1PPUcUuYRk3Fw08JW3kCt3zT7CGaNMyNnI55rJmsZridRbyMDnLY9K0fsN8Gx5mFHvSTYEV5c3NuWVMMB3qSxklmjBl6jpVmGFDEwuQTjvSpbgEKDtU9qd2DHyybYsYB+tRxXqxElsIcYFNubKVs7HPHQVl3Ol3U6juQc4ouwHrqd1FJIWkMiluAPSrX25tm4oPoKqRaROpDNkDvVm4sXSLevOB0o5mFhsOpRSt80ADA4OaewRWLlgo96x7iUFAw7cUw3UkttumAUKePpVJ6gi7pLbGlOAenX8a05VgmTaWANZekANcMGOE4ya0bu3hZsRgkeorrx1/bv5fkb4j+IytqMcMOh3/yhj9nkwffaa8bOc165qnmf2PdoxJCwOP/AB015ITzUUXdHM2NprU6mmtxDK1fDiF9ftAOofd+QJrKNdL4HgaXXyyqW2QscD3wP60S+FjO08QKbrwzeIRyE3flz/SvJq9nfRNSuYpk2L5ciEYb3BrxllKuVPUHBqKTdtQEp1JRWgAK674cWpuvF0cYYKRDIefpXIiun8CXctn4mSSEEuYnXA+n/wBagOp6b4RsjdtdlcZTZz6Z3f4V1i6ekWBJJwOvNcLoetnR2mAH+t2/pn/Guog1QajCQxAz1q8V/FZpiv4rNGTToJY9yScD0NNs1VZERH3YPNZU+oCys5ERxjHeptAvIWEZyC8rYArmMLHQTjbg+9AHFTTJlGzUScqKCCzb8xEU0rin23UildcGgLkDD5arsuatsKiYUhpmPJGDrdsx/hhc/wDoNaipVJx/xNlHpEf5j/CtSNe9A2xu3C9KVFy1Kx+apI0PWmiWyRVwBTsUUdsVSJZ554su5tO16WWI/LJtO09M4FV4PFVzLhZFCik8e3iJf3Cbf3kYTH/fIrzyDWHmul3sVC9h3qHubx2PV7C7GpXIiBIA5OK6a2igtkAQc+tcV4VLrE120bAN936V1Nu0shyVIHvSEzS+2BHwelWFmRhnNUJrfcgK9RWTPJNCTknFAjozcRg8jNMLknK8VyF1rFzEyBVz2q3Z6s0i4Jw3egZp318Lf767sniktbeJ1MroAW7VSkuI75TESAw71US7mtJdjvuTPGDQM2LfS7SK7MyRgOe9aZMca8kVzl5qnlRBlPJNNh1HzmAdjQKxrPOqzZFK9xGV5rGup2k+WOs24vZLdArk8nFA+U6OPU0jnCqQT6GrM98rqCU59q5ixuY03O3LHpmrkmoMSiKgJahNoHBHS6LdJJqNqNpB89B/48K9KFeS6K0q6tYcdbmPP03CvWq1g2wSS2Cvnf4lWs0nxF1VgAVPk4/79JX0RXi/jt1HjG/ymT+75/7ZrWOLdoDPNINNuTciUxkgdBWglq0EzEp8uM4HatoSxbNzDaO1MDb0JVGx9K8/mYznJ1llkcygqhGPrVOTSg2zygcdyK7B1QKAFDZHcU5E3yKvlqBjHAxTUh3OYt4HglHlx5J4JrZmspLi3KxSFGPetD7Hb7mUnaR0FN2+TwpJ9zT5kFx2maabW2PnOWZuSc0kt8EwkfTdirIvN6kMvJHaoXEGNmBzyRRdBcs2skCR7wB8/cVOsvncA8VmLFEqFVIznIwanDmJMqckdqpOwXLWAzFKmWEZBPYVjS3Mu8SqOc8DNSx3Vw98o8wqv8XvVpoVzTefY4UAGniIsQ4/Ksy+ufsxZ1y+eBgd6jgvp5VUocMPvZ7020xl+5kSNsniqqT+exRuFxgVcbyZrQidQHPcVkshguEQcqTwahxd9AQz+wFkRg7jrkYqM6VaLbESksB0571d1CWWKIvECQvXHcVELdrq0DNkEjNaR3BGPZK/lTlCBjHX8ag/tG5UZQ/dzmr2lxNKJwOmBn9ami8OrJI5eXardjXXjv47+X5G+Ia9ozmW1Ge9trxQDzG27Ppg1wRPzGvVtYktNI0i8WCNRJsMe4jPJ4z+teUVnQWhzC1G1PNRHrXSIDXofwsixPqNwOSFRMfXJ/pXnhrvvh7PJbWl64GUaQA8eg/+vU1JWi2M9RguZ3f58BR1xXz5rEXk61fRf3J3H/jxr3WC9ha28xpQGHVT1rxPxMgTxNqIDZBnZs49Tn+tRSknoJGUKWkFLWowFdT8PpBH4wtSQOVdef8AcNcuBmul8CFF8Y2G/wC78/8A6AaTBHdabpy6hBcA53Jt2kds5rUsfC2oIpcXIQHoKf4OmjiN75mOQmM/jW3qFw7LiCXbV4yzqs2xH8RnM3Xh+9d/LMhIz1Fa+iwQ2V5bQOD5gcbc+tLb38sbjzTu961Lb7Ld30Em0eYjgg1zXMHsdEVzn3qqnyuVq6RVWQbZsnvQZMlg4epXGWqKI4epyKYiBxUTCp3FQsKBmY3/ACGR/wBcR/M1rJ92sZm/4qCNe3kf+zVtAcYoGxijc2asoOBTUUCpVHFMliUGnHimmmI5HxDp9td386yRglgOfwrlbPwpYW2qKzQhvbFd/qEUct8+Rzxz+FUZ7KQyBouoqWaxdkW4lggjVEQADsBT3mEcZYEVjypex8k9eKkJZIcSHiiwyzHq48zaR096fczxXUGAOTWZDbCW5DL901rm3VIsECgRg39o6wjyfmb3rHWSe0kO5Dk10BfyLoq/QmrklnbXEGWVRnvUjRh2gJPmngmr0yLNDhvvdjVJibUFd2QOnFVp70mElZACPegpE17ILdIzMfkHH1qvJciOdGT7p75qndzHUNOZJHyy8jFTaD4dn1CES3c7fL90A0rjHvrUVvcqrZZm7Cmahp2panOklvEwTrzW3Y6PZWU7PLF5j54LDpXQR3SKo2xgD0oFexy40y5tbVWliye+KqLfhrlQoJKda7ZriOZfLkUc1z9/oQafzbRgrE800K7ZsaBfxzalYrj5/tEY5/3hXrIryHRdMMOq6axfLrcxlvpuFevitYAFeK+PQy+Mb5scHy//AEWte1GvLvGNlNceJLoIq7WCEMx/2BWWKjzQKRxMkKbAei9hSEgrtUkCtJrEI4R3znsBxU8umooCvJgYzkdq4ORjMdnG0KiksOOKizPISVQ7cYzW5BaQxvuVvMHuKhlilRm8tCoPrTUFuIzhaoAGMjM46g0kmW6DJqzKkoXaZEAbrUYhCJu3gt7VMl2ArwyorsssXPTBps8KCIFZgX7j0pzwM75wT9KBbbCRt681LTAjtWIjbzGAwOCacrxb/wB7MBwcYpWO5/L8slgOy0l2LZokXyfmjGMKOTTV0hDBPGzDBzj0qYTA5KjpUUccMBDR7skfxVM8iGMbCGfv8tGoCpdLIMNGcg4qaF7ZW4PWqcyPbzq4RsEZNPMzSTBdg5HXFJSktxFxpFuIy0ZyAcComi8x1Pp0quszpKyDGBVqGREjMjuNx4Vav2jHcc8LNuy3ygZp8cpES7AGFRHJ/eBxyMYPSnQrv/dx/K+O3IqoVG5JAnqZvh8hVuyT2X+tWZJ59wES5B7mqmgECSUEgZK9fxrVvLqNJnjVW3IQc9q9DHNe3fy/I2xP8RnFeOJBHaWsLKEklYyOPXA/xNedV1Hi67+0a1cLuJSECNcn865eilG0TEa1MpzU2tQA16P8P0jGg3rueWmwBj2rzg16V4DGfDki+tw38lrOt8AGw0yKrDa25DzxwfpXmvijB8Q3TAY3bT/46K9bjRpYXgkAUg5Bx1FeUeLVCeJrxRjAI6fQVjQ3Aw6KKK6gHrXReCjjxbYk+r/+gNXPKOK2/Ckgj8TWTHpub/0E0mNbnpmgOEW5J/2f61eurlVgZs/NnisGxMmXCA7cAtV+6hZkXByMc1GOnas16G+I/iMIr0bsMfm9K2dGvUfU7dVGSXAribm5ZrtI7dADGfny1a/hrUXHiK0twqgGXnBzXJGTuc7Wh63UMw71P2pkgyldRiRJ94VaxmqiD5hVsnpQIikWoSKuEBhxVaSMrz2oAwGcHxGPVYQD+Z/wreQ5xXLQziXxJeY/5Z7V/TP9a6aI/IKSLkiymCeakLYqBSB3pS2TimQSdaKTBUYNJ3piOP1u5mi1u4ELjjBx+AqrHr0sYAk4YVzPirWn0/xvqG5srlVUZ/2FqazvUm+aU8fXNckqjjI6Yx0OkbVRdLlmxipknjnj2bwawrm3aSI+WcfSqcIv7b5sfKPSmq1wcTfYXdrcB4MMvpWnJdzyxIMBW6mudttTuB/rPwom1uTBVBmrVRCsXNYsp2VZ0k5UZxUNteXXkYm4K9KgXUJ5o8MeKzry5uNjCM8UnUQ7Gy7rcQlWYAkfeNU9PtNN85lvLrJJI27q5W5vbwuVViBjFRqjKA6kk4yc0vaBY9FVNEt22oVx9aZLrFrE+y2dVA9K86a4uc9x+NPW5KEFyTS9ox2PRIdThkf5mGfU1rRPAyq7SqAeleWLetK3y/dqZ76eOMKsh/Oj2jFynp7JG8haOTJxkc1AtpdzS7jJha85TWr6KRfLkb3rWg8SX8UXzlSKpVULlPSdIhMep2eTk+fH1/3hXpgrwzwtr0l1r2nRyMMtcxj/AMeFe6V005JrQLWCvO/E87/8JFcxjAAC53d/lFeiVwHiS5RNduo3MeBt5PUfKKmv8IGN9nabmMovsDTbq2jt7cy3QLMTgKG4FWYn+UshBBOPqKWeKJzho+nXviuRlGWkci27SiKKFQMjb1NRSu0sYxGUyPmLVprYeYjjqvUbzwKkS0McWY1XnvmpaEYIs40Uyvj+YNTjTopliZYtoHXDferSe0hmZW/ix0Q4FWBBIndhx1zTUUMxZrWViyRxbNg5yKyhDdncjQMMHIYnr9K7KTcUChGZsckdTWZdWTXDg73KjtuxihxAqLpk4gBGCxGSV6j61CulvI3zEBx1OMZq/Cgt5CFBUkc4fr9c1C93PcTFRFlicZJ4pWEU5LGP7K2Nu5T3NQyWcVvEHXbwMkZ61ZkjuwxxEhQccmsW9ivXlVCojX1PpSa0BjGubqWbckJaPsQ1WHS5dAqxLkHPuaWzgezXCP5oz/qzjitJTO8ayTRiPsFbH9KhQXULGOtoi/P5jMT94VZDWMELOMyMMZB6D8asTxgzZMqYAzt4yKfc3scVsyPGgjIB3Fe9JxSAr2dhealKQlqFjHVjIAAPaoZY59OmZJDjsGVqij1391sDNtxgbabLqK3MTRKGPfnrSjyN6bi6lDR5I4pZHk2kDHyt361rTSpMxaRQAeuKyNIjtWeWa73eXHggL680rzwi3uThtpiYjceOAa7MwusS16fkbYn+Kzy/U5/tFxcS/wB+VmH0JrNzirNw2QKr7c11R0RiNNJSt1xSVQAa9C8CzY0llDAFbgsc9xgV59XoPgS2LaLcuse53l25z0AA/wAayru0AOpXVUiceYRy2B715b4qOfE18f8AbH8hXqkFjHEokdFZyRgEZxXl/jE58WX5xjLj/wBBFYYV3bAwqUCgClrsAeOlbHhYj/hJrIlQwDMcHv8AKaxhWp4dk8vxBaPnGC3/AKCaQLc9Dtdxhn2MVbAxjv1pGuDCkaSS4k3cqPSp9LjSQThiA2BtJ/Gqmr2rvOrLGzED7yisMf8A7w/l+R0Yj+IzGJkkv5ZVQlS2QRWz4dktodas5AhWY3CAjPYkUWFqTah3SRVZyCSp6+1XbCxa21O1meJSqyqefqMVzR3MHsevH7uaa3K4p55jzTTXYc7K4GGxU5PAqJlO+pO1AxQ2DmobqU+WwpzEetV5wWBUdxSEkctZw7NduZO0hH54rqYjjisZYtt1IVHKsP5VsRHKCkjSWpaEJYZFTxQ7Rk9aiglHQ1YLCqIZHIecUwcmhzlqE+9TEeXeKbLTb/xRfW9wHEu4FSO3yjmsy10dNPZpg7yYHCk8VueIZ4R4kvVePa3mcPjknAqu8nmriQhW7qe9cFW7bSOiL0Q1NQEQQyKfn4wo6VagvoZZDGAc9xWXsKwtKk4YDrgDiqsd9GyvKpUHoWJrG0irnSNDDI3QH6VUuLGMOMAjntWVb6mYmWUTAeoYVqWupi4V2dMhRnOK2je2omy2tupjA6VA0ULgx8GnNdx+QMnBJxiqpikMqmJsKRnkVVwuZ1xp6RMztkrnAIqlMpjOEHFdPJau0BJFZ76Y+1iWU5oHcxxDuRWPQmpH0hGG85OR0q/FYsmA7DA5Aq6ImLBccVFwMuLSEEQIUgkVTltJdrkkHBxxXW7AsIUDoKyJbZvnXcBk5ockK5z8KTCXGKdPcFQQTxV82U0YJBPNOXTVZFL8nrTTTQyx4QlkPizRQudpvoM5/wB8V9PV81+GpGHi7Ro1UYF9D/6GtfStdWG2ZLCuD8RBRrV4/kRswKclBn7g713lee+JykmuXCOr/KVIO7A+6K0r/CIzzIqCPbF8xPZwMVOrqZGixnP8WRVBY4HLeU+7JwVOeKnS3VDlwSpP97FchQ6WJhNuNwg/vKST+lSzn7oVsqFycUYES4iQbM5wTzVaaRz8oZTz2FADre4SJyypk9go5qxLfJJPjYMjrvB/SqcErJMB5SkfX/69TNeMGLbFQg9uh+tMC3lVYZlXzCPuY6VRaFp96SOVwe3ekkud8odwWIOeaE1VYpCWwCw4GBjNK4hi2rwzOVURsOhK5zTvOVYWjwNoPJI5Bp5vnnysjcHkYPSoJ7gKu2KEOR94k0DuNa182YMNyrn5QG4FVdQt5blsrDHIMYBz0pvnzIxymFPXNSC+DAbFUEcZHWkwMcWN433LZmPoo6fWmTs9um5kx6gDitGSS7l3iKbaByVHFZTuVl+a4RsDoTis3oBEt6Z0C/ZxGAfvY5NWFdZo2DgFemGFMBiuAV887h0CEcVTmtri2kZZy4Zex70XA01Nn5XkMiZb2qIWdvE7OmxQozzVWGRcBQc+561cd7eRNjxhgORmnHViRgacJGMigKYzjeD+OKXXI5ItIupYVIiELMQSOODmp9FjjkE+8vwV+76c5o8VT28Xha7URqX2YDkncMkV2Y5XxT+X5GuI/iM8gmPao6dL941Ga2RiNf71IKU9aQ1QC16h4AdYtBC/MC8rnI79B/SvL69a8FWUC+GrWSXducMRz6sawxPwAbxaOKN5A2/B9a8k8YfN4munxjdtOP8AgIr1aTTAzPFBcEREFvmf9K8y8a2v2XWlO7dviVvp1GK58NdVAOZpwpMU8Cu4BK0vDsfn69ax8csev0JrNbpWx4RG7xNZr6lv/QTSewLc7uIFoJUUNuYqAR261r2c22AIUbepAI/rVTSFYtLtxuwMZ/GteCJ/OlBZUQnOP4s1zZg/9ol8vyN8Q/3jIkAtrcKMsc5BJNU7PV0upG85BGVlAQEYzg1p3CxxKC0gbnkZ5FYl3ZPdhTAAuxiW965k9TBnsI/1IpB0psRzaofVRThXeYsikHOad2occYpB0oFchYbW+tBC4yadL1BqF3AU5pXGZtoRJqVyh4DH+VaaxlPlPasmGNlvHkB/izXQxkOoJHOKEVIgVanzkAVKI1x0qGVglNkvURuKWM/NUZfcKfGcNQhHlPiu6X/hK9RRE3NHIFznp8oOK5y5j1WTUIiB5DEfKD3roPEr2q+Lr4+YEczDII+8cAf0FTKbW3EmoXlwHZgflYjI+lcr+Jm62RjxWM8G9buQImOGVutRtpKpueMecCc+vFSXmsRyMVTZLHI2BjjFJBe20Bxliz5Gwdsf41HLqMYjW8ADNFIAWwqla0GliFuC8xRScBBjGfes19at7ZmCtvcclSMnNVvtNnduD5jqpG4rnvVWEbg8+TEcrjZjerL3qwNTgt22Nl2UfLz3rBGtCOExB2LxAhVx2NRT6kjxR3UUR3LwcjHShoDoI9dljYybGkC9cdvrWjBewXcRmMiKSeVrhhrSlQIowrE/Pg5Jq29yqxGSEneR82e1JX2YzsBbIx8wPkdqGJU421z2n6nceUkjMipjAFarXovQnkupBHzfWlJaAWd/mcB+fY1nXK3HnkAjHrT4bWeOdpV+bjAx2pxDlsvmsZK4yCKSZgVIzt70rCaVcYwKtRHDcAAdxVoMMcinDQYnhe3SPxRpTE/N9shx/wB9ivoivBdAjhbxLpbbRuF5CR/32K96ruwr0ZLFrgPEcMbeILhmA3/Ltyf9kciu/rgPE1zHHrNwvmRbvlDAuQVGwY6VpX+ERmAPCzbvlYDO3rmq92J7mMlrW5MYP3h3/Wr4CSQgrkqBnIHBqRABGwhZn3HOHOFWuVjOcklgt5FWS3mBJx8w6fWriS2+6OTeMK3I5/KtMLbNOC5D7Rk7QMD605xG8RWEFipJUKORSGVBHFKXuGfBI4A4CiqkssKKfKYbSc8NkZpW1C2E8sU8ZjI5DFuB9as2kkc1t5kYtZQ3R1IGPrQBWVZZzHIWVoxxwAP5cmoZISZSXZBg8Aqa0Vt3c7oVWNd21l37sn1FSSaaoky22QqeWJ6GnYDNRivWPPpSthoyTHjPTFaUqqIznDEDrGM/jVeS6QoqGFdoH3sYoAphBOuwlV9GPODTY9NBn2ZUM3UgVoRRhMSAKVB6DtUygb5CkayEjguuMcUWAoDTYxumhYhU69K53U10mJmK2jyuefl6Z966eUt5JQusfbb0yfQ1hz2V6QzqY9+ckAfpSktAM6G7gEHy6e6jHPyYJP1qNo9QuFAh0+RlP8RYCrQs71/M84RRnjG49a1WlhtLDC2c8pC/60E7QazsBkrZTRSAyW6Pjqu/BFH2WdiuRhCcMV5IpJdSht41adwXf5mXHT8apnxUkEZjEnlls4X/AAojZMSKmiq7yS7XCAAEk/jVXxpIieHpRkszuq59ec/0pbGcQeZk43Y/rWX4zuJDosAZCvmTDbnvgH/GuzF64t/L8jbEfxGeey/eNRU+T7xqM1ujAQ9aBQaBTAWvZ/DySW+i2kSRjaIQCWHPI5x+deO2sXn3cMX99wv5mvZ55LqNmigjLJgMhB549vSuXFPRCY5mklQRoV3rywY471xPxDtfKubKc9XVlb6jH+NdebpLmNYzEGlPGwLyfeuf8d28raLbySBsxS8AjgAjtXNQl+8A87pRSA0E4r0gBq1vCchj8TWTgHIc9Poaxyc1seE0L+JbQDrlv/QTQ9mNHomnXS2zOzZBOAP1rRTfLAG80FjyV71k2MayTYYFj2Ud637LSlnma7WQJ5a/NHjLH8K5MxT+sS+X5G2I/iMpsLRHQu8jSHnIGKmaFScqcEGnrHZXdmZSpBGSVPX8ahhkjuJNkeQe+TjFcd7O5hc9Os3EumwSDo0an9KlFUvD8om0C1YHOEAz9OKvYr0lqjJsa3NMFSMOKYKYiKUZXNQeWW6jirmM8Ukq7LeRh1ApJAnqZaLl2PbtWjE2EFVVjwgb1qzH9wUFPUlMjCony7AmnE0g60xBgY6VJGo3dKaQQOalhXpQhHg/iu+z4l1QqjGQTvg49CRWCAJbfzJ5mO4Y4OSK7qaxK+Lr+5uUjeB1dlXbndgEnj8a5Z7JLrc8cDRRgEInI9cfyNcr0Z0JGVaOYhujBwpxk85Pr7VPOVuAkkNvJ5q/eYdDVyDTHkkS3YSIpkGXUZAX1Namq6ZY6ctxHZtcTXACngjAyOvT1p3Qmcwn2ia7AWMC4Y447CrZFzp0KzOqFXYhe+71/KtSy08ypb3DFkFxkCTbjBx/jUU9gl1comZGih2qgP8AEOSSfcn+dJySGU9Rht21CYLIEuAMEkdTgVUmKWEUcUzsWJ3NirN3bMdWe6fhXf8Adrn77Z4FSarY+aUjbIYhWdj70uZXV9hGFbeaLiWWHMm08FumT/8AqrXa9ltbAs6gOzHeRz+FPl0p/JSO3AWILvfB6ms+S2m8kxxzbzu+YEcCr5oyYEsV8tvCzRSMHzuGelbVtdq9qsiv5cjckgZB9vasVrKe3RB5fmMOpx0qxZ25aAk8AMd2DnbUuz2GdnpWoC2iDysGyP4f4q34TZ31oksfWTOK8708MGmkL7rWEge+49AK6CyvJFgiCoQN5KjGCAOtZyGjoJdIGcxSflUZ0+RFckksB8uOKSy1ExyMPlGTznoK01vkOI2C7jyx9KSSe4yHw/buniDSmZD/AMfcX/oQr3avHdKls/7f0zy3GRdxgDPOSw617FmuzDJJMlhXGazHEut3UhO12KfMQP7oH1NdnXm/ieXWZPFFxDbWcL2w2AO8oH8IySPrmrr/AAiHzRERfK+PdExUEqtEh/euC3aRcA1FJpU9yAbm8kjcEiRYpDgemDxSKsFjaOsk8siIeshLEfSuUZkXrXluFJv7eNX4C7OTnsMZzVi01qG0Xyi811IVwS0eAP06VHc67Db4aGNd4zg7SCR0602LxDJLbyTzCMqgy23ln9gMcmpuMtR6XpVy/ntaRpI2W5U8+/JpradHArpCoIIyEjJ4/KksLqO4VyzSo7JvRJOCR7D8amt7Xem5pFSUncF3DNMB0Ntbw7VSIxyupDM5JI+mTTrWyjt93/EwkmGOVxz+QFWzGoHmLGkjcDK//rpJIY9zzlo9pA2hTtJx+lMCxHBBPC3yOu3klF6VUY+bJ5cbK0ePvs23n0AqeJ7eMt5sqJGTncT81MfcwKQRRNHjMbuxUk/lQIrwiVfla4G0dVKjJ989ac0hKoyyEc4O1csce1KXYN5btGGwMhPmx+VEsEEybVTdIFAVvun6jnrQMSWWByCYwSehJ4NVZbbDM4dw5+ZVDcE/Sra2u3y8wglSSwZ+oqJ0juQokPlxqf8AVqcflmgTMaW71YzlI7e2bIHzu39KVZdSZFjnmQoD0Q8fT3FXrgJv2xwrIB0aQlcD8O/1p8Wxoi7q4ZuiiM0uURkXelRyncxi/eHgsMCuavfCX268CR3qBRzlYzkGu6ltmV/K8zMRGRuGDnvTYbYSSswkDf3Snt1xzTUVe40cZ4e0Aa60y/vC0W3CpxnOc8/hXPfEyzk0q50/T5doby2mKKc4yQB/I11/g64W3a9Mn3GCAnOMferzf4gaj9v8XzsGLLCixAknsM9/cmu/EwX1lv8ArY2xH8Ro5J+tNxTm6mmUGAhoFKaBQBpeH4fP1+xj9ZlP5c/0r2R7OOW1w8ZMvC78kbec4xXknhQH+34ZAATGrMM+uP8A69eh2t5fT3IkeNio+9uwu33zXFiX7yA2bmx0r7KHWaRLtATgKNp9BXJ+KY8+Gpyr5QMrD8xXQScyNKjZIOc4HI71m6zbXGtaZc2NmIY1kMZYsenJOBx/s1zKUYyUpOyA8pzTCc12f/CtNbPeP8m/wpf+FZa16x/k3+FdX9oYX+dFckuxxRrX8MeYNdgaLO9QxGPoa3j8Mta9Y/yb/Ctvwt8P9R0/V/tF3EssSoRtVmXk+4U1M8ww3K7TQckuxbsL42UxPkpKrdQ3H5HtXQx+RfmSSF/IuDHgwuchsD9OlVLTw3q6LIJLaFwcYDbj6/7NaFnpWr2UyzxWkO9Du4d8fT7tY4zH4addyU1bT8jaunKo2kUYYI2spfMjaHeP4mGOehrOttPNsySrcIzI2AcfeNajaJq8zyGSBS0vDtuY5Gc45WrVvouoW8qMdOhlVckK7tjPqflrjeMw38yMfZy7HXeGLhbnRgR1Rip4x79PxrXrmtIm1qFroSWcBEr7wA7jHGOye1an2nVR0sYv++5P/iK7YZhhuVXmjJ05X2L5FMPGPc1RN1q3/PjF/wB9yf8AxFMa41ZhgWEP/fcn/wARVf2hhf50L2cuxsJBtG49TVPW2MWj3TjqImNQLe6vgA2MP/fcn/xFVNUl1e6sZ4BZRAtGwB3yHHH+5TeY4W2k0JU5X2NGFfMtVI6EZBoXgYrK07Vbq0jtrXUbQhmhJ3wq7524ByNvvWyirNCk8Db4pFDqcYyD0relUhVjzQdxSTi7Mj61JEgyCaekB71OLdscVrysm5BN2qSP5UJ9BTZo2VlB6miclLViP7poeiBnnksVoZZ5CozJkEk4zz0+lVJ9OgNsjnJkiVRgDoe1ULmaaWePbwFyWJbA+pqTTtU8iRhkNuPfmvP59TpJFtZBH5cQUb1Ckt7EnNKLOKYyx3EcbttBBY9Cp4NNuL1kZQfkkLFsKRhfaqN5q1v5hllfIiGGAHDE8hffvRzdhmnOkU1sqAqhK7VKjO3IzwD0Heq9pCipdK8BLRxZLt0IzWSNchmkRY4trHBA3dB6Yq0usLbBxJ8pkAGFO44pN3AnW1iZnlny6hQYougTvkUk8EU7kyjBYfMBg7sdD+lTQalDfs4yN3G3J+8BUsU9ou8ZwxwCB1B7Y9qhpiMxtClcb0zFGZFYIWByg9f1rOvLCEXS+SpZVw5yRyeua6q0w6+ZOOCTtU+mcDPp0NJ9nVZQySISxxk84yf/ANVF2hnAalZ3VvLbFpHPmHc4J6f5zV210K4TT7iNd8ryTK/ynA2jPXPfmutaJFnVWhRyBsU4zx60QXsU9ysUT7IiWV16fStVV0sJmHbaPI0y2SXChWkLFyOAT0PvxWksEv2KEQclRtLHjqcn6VdaOKRjcWsiMN2cd1A4z7jpVS0imV0jy3lhWY858w+v0rObbY0QQC4W8WEKjKrbmb1q9PJjziSwA4IHBJ9abaQQzyPcNKyuAV2hsFT/AA/1qDzPsU5WSZsOATC4B/HPT/8AVVJXQzd8MNE2taZnqbyEjI5/1i173XgGhDZ4o0pWBz9rgOPTLrjNfQGK7cM9GJhXA65d+d4jvLXaymHYC4IxyinkdTXfV57r8kr+Ib1IoVKjYpeT5QDsB4OOvNXX+ESRkGIQx4jaSRdxPkox+Yn1znikhs2jj3SQMsmCTGrAk+4xUkcxjD7srgnLA7sEewx1+lYkt9cm5n829aPA+VFTBB/HpXE2UkTLBp7s6SwSRyIc7JFIz7c1fj01YI9iwLEpO4nufb3qlaQanc24kTVcocHY0Q5Psc/rW4cyhJWZSigHzCMH+f8AShICL7HvYkyrkDoQGYUjEQkSJGXc4GFUD8e1Ry6ptDCF0kkIxyrqT9Bjn8Ka6XrQo0yQxDkmBF3M3fJyR/KnYRegnPlM32gDdkHH8PtmoY7CYyp5bSOgHQsMH8amhLm1226iF2H3RGMr9QaolNTjnIjkDMg+8/c9vb8qdwNEebHI5ZFEgIDM3O0d+/Wqi2qS+dI2+ff13PhR+A6VC8V1hDPfRiM8NwCcfn0ptzd2sCLGqvLGwwZISMfz4pgXYsbRhYY8j51jYHj0GRTFuobW4XfOu5+EZlGR7L09KZPPFZW6ynenmdVfqKrNrOnRzfKpGRzlc/06UmwNRDJLM+Tu5+ViD8pqJEkkdhJM7kkqpVQMH696ppqqLqCRxXcKmVANnUZzxzxWxcrIGz5nHRiuPmFMTRWfTjCGmcHIOGIXiq06TRhHYAxj5wxO7j2wavPvEYkZiFkORu5P5VRkZVgdg6bFXGN2MH1xTCxUjury4VJrbTJ/JZdyMSg3A9MjdTJf7WlDqdNuAdpGxfLxg9ec1t6HzoWnnC/6hOp9qcuvaSb42n9p2Auc7fKFwu/PptznOa8T+0K/M1FXsaqCOB8M6ZfQm5M2nXB5QgKye/XLV5z4h8N6ze69e3S2oxLO7ANIucZwO/oK9c0nXfs/im9sLqS2hsoLNLgzO20hixXkk4xWPNJFPLJLDLHNEXbbJE4dW57EcGuuvmeJVTmcV0LqqMptnk58Ia3n/j1X/v4tN/4Q/Wz/AMuq/wDfxf8AGvS3vrRbgQNdQCYnHlmQbvy61O21ELuwVFGSzHAFQ81xC3ivxM+SJ5afB2t/8+y/9/F/xoHg7W/+fZf+/i/416db3FvdBjb3EM23r5bhsflU1DzaunZxQciOa+H3hvU9O1m4ubjTVnUQFAAUbGSPU+1dxeadqUtuwh0ZoQOm10XI/wC+qhsblbK2u7uTIhijLyMB0UAkmqa+KvEn9kp4gl0+2Okg+Y0Ks/niLP3s/d6c49KiONxFe7SX/B7ByIWTwzrUkQMumSrtH3vNj5P/AH1TdK0LUIZ75ZrUo0YikYFg3HzehrurW9F5Es6BjBKgZMHqDyDWa927eJdQtLTYz/ZUeWR84CgsOAOprgq4yrOnKLS/plKKWqGaprml6HLHb6hepFO6bljVWdseuFBIHvWd4g1l18JDV9Hu0aN540WUAHgyBWGGH1FWtW0LWl1/UNR0O9tFu54I4p4ZlJBCj5SrDlTgjg/4VxutahY634FlLacbS6F4lvIA7OrOsihsN0PHNc+FwtKbpzjrqr/Py/4ctyex2Fh4o0jUdYfTIL2I3AYrHgnbLgc7Wxg/gTW1ca9pPhuNTqd0kLzMdi7S7Nj0VQTj3xXIeKrSCT7PLsCpFqtokcS8BQeD09uKhspI9P8AHXiQSPm4t7VI7He2SsW7DbSfQkUfUqNSKqRva23XS3X59hczTsd/pWsWGs2n2rTrlLiHO0sueD6EHkH61mzeNvDUN4bV9XhEivsZgrGNW9C+No/OuHmtPJ1rxdJpU0nmQWMbGWNjzcFTn8SM/jUOnx6/qPhew0y0TR5tOayDGOGGTJyMEyfMPmDdfftWn9l0HecpaaeVrq+uj/QcqjZ6vPeWtpHE9xcwxCVgiF3ChmPRQT1J9KlDuD2P1FcLo+l2kOmaTaauN0EIjKvPJsja4X7hT5uSR2712ltbyRNMXneXzHLgN/APQV4+Jo06WkXff0foWnc5m61rVb7xNqGnaZqSaXZ6XCj3N0LdZneRhlUAbgcfrV7wp40v7iW50zXbYC6s5khkuUAUMJBujYp/DuHocZrl8/YvFfi+1n+VrlrW4jB/jjxgkfQkCtDcl3rPj7U4SGtmms7aOQcgyRKA+PoSK9h0abouHLooxafm+Xr839xnc7Lxr4hk8M+F7jUbeFZbncsUCN0LucDPt3/CuM1DxB4r8H38cup6hBqtmHiS6j8hYfLMnQoQM4B9c8ema7TX7DSfGPhieyOoRm3nAMdxBIGCupyGBzg4I/nXmXjnw9rk1jBBqmv2lzdXlxBBbw2sRRp2BxvfJ4CjJOOMkVOXRoyXsp2vd3utbabdra9hS01PUNV19tE0GXUby22XAISG2STeZZGOEUHHUn8utch4L8SeJNUt9XXUgmotbXXlCSMpGqfKDhQByPc89Koa1ceJLvXZpH0r+1bTS4ZIoZEuI4R5rAgylSckheAAPXvWR4EuNaeTXjHay20QmaSVxcRlEZUBCMn3mJAHI45qoYSCwk/hb0e+2u3fYObU9N83drNoCpBFrN1+qVe0FQ2g2B/6YJ/IVgDUEa+sbmTK+bZykjGcE7aTQvGOkW+kWkEszqyxKp/dMeg+lenkElCm1J/1dmGITb0OxEY9qVykSFm4AFYP/CbaD/z9v/35f/CqF3410eeUIlw+0f8ATJv8K+h9rDujm5X2NoO1xP5h+6OgqK/ci3mweBEx/Ss1PFuiRoc3L9P+eLf4VQvPFekvY3O2dyzxMFHlMMnB74rOVWFnqPlfY8+u2mEaqjy7JQTKmc4PYfSoF0+a2sPtkW5ZFOF3DIY57VGmqb2XdBJzgcoTUzajGIZIt1wIiAAiqcH1+navNujosE99KtskU6fvGIbK9s1nCzWW+WRYxJbgbWBPKn1NXVa2Z3Zt8pddhWVGxg/hVq3/ALOSEYDwlX3ELGW3/nTUorqNI5XU9NksrtFt3DMMEEHd16dO9MtvtUrgKJGdjnb3Y+grq5/sr4mhl/fKRgCFgW9j1GMcVZtluWCPPHIsUikMPsrY246AgdDx3qnWjawONjB/tCOxZYpxDK4k2nyT8sYx6j7xyR+VV7eaWe+k8ksUbkBhgAiukTRrDmSO3uxlxk+Q/wAv04qzJp9orySrBd7ivRoHGT+VQ6sO4rFLTfOlkltyrRzBQImcH5+pI/nU95eTRac3mQhZkKhlbqD9PypXIW3MH9mXrxsMF40cMB6A44rNiVVgiaOKSRJGPlhiWAzyA2MZpJp7AXI9Ska282ZFRJFwpONx/wDrVmS3Pn3EUkbhUJ2ZDemccYrTt9PW3ZGG+UMu4xvwpP07f/Wpt/bRSRs5Xa5IDN0A9uOnTqaaBsq2rzy290sC5A3SOwOPlzwP51Pbau6tBDdKQFOFIGPwqNrb7FFIJijsxwVXIyOnH0pI2gs1jjG5iXDjzTyvp29Kd1cC+dQttxMTOZg/QnAz9Pwp13DFcgTSoZJWTeo7MT0z+VRSSWkzht6xmXJ5GVwPQgEnvUJ1VjcGFo3CqN3K4DMB/wDqqlILmxoFwT4l0jyxy2oQbi4wcFxxX0TXzh4bvoH8X6LExjaWS8hcDbnB3g5z9P6V9H13YbZgwrzTxRfzx+Jry3W3kkQbCCBx9xTmvS68y8XaYbvxFdSLPMG+Tam87c7B0H4VWI+EcSqgLxMuRktuJIJzn60PBAizExoZDgYKg5PpzVEJNbPtW/kEanLKUBYfjmpLq0vLmHdHJIZmbBJbb8v9PrXGMbcPcxmMi2ZNik/OwXI6VOZ5Xt4wsSrvUcrJuIPYYYVnPpursYomZJIB83MpcE/UjJrZgs7K1Ks9svC5DNu5/XpQAyCJnUebeOGGRgOg24z0Iqy9nugCeZ5rDjK9WPHUk1TOnRTwB0kkSPcWKxBWx9OKr2uiMl7HP9uk2KSRwfm7469vp3qhGtcy3LW0cdnJbQ5xvBXcQep9KpiNFZfOnYtMxOcZOff06dBVoXFnaQhXlbb0IK8g1GmsWDOoEssn91Qmdv19KLANlhg5QP5w77WH6g/41Tn0u6tCq2VlHIBgb2GN2e/yj3rWRgzeb5aE45Kjb+frTpJisKpKzZxjLZyfyoaApx2001j5OoxWvHKhWYp+op6aTpoBaSGEqPvBV3A/nxUWoWD3SxNaTSxLjIIyeffJyB14qppttdR3efOmlKn5lkUDPof/AK9AGwkdv5arCoWMNztwD+hxTXhSMl1UsN2NuTz7jFVbm1vJJH8m7FvIBkl8HBqxbS+UsVrcXEc0+AWcMPm+oH9aYEqyWqK0s1u7DoBtG41kXeqxIWNrZSzRbcM23aFPpnH61rMjFSfNgGP4Cx2g/j9KSeKZ4WwF2+Vnggg+xxQwRW0ky3PhGK3VHhlktQivnlSUxkc9RXHWiL4Q0u0tvEHhSwezt3SNtVtNjkOWAWRlYBwc45rpmQP4c063y0fmWu1zGxUkFQOo/Gs6X4fu6xm+1bUr22jZXW3urwvHkcjI25P4mvFo8kE+d6Ng6nvOKWxiR22nN8Rby51G2FylvpqPHE6hkLmTAJB49fzrGGoPa6r4nhsreGCCSGOdYI0AVJAh5Uds9665rG2g1GfVndzLLEtu0fBUqCWBxj1Hc1Vht9Ng1W61HZKZLlER0KrtAXgYFbSqw5mnLSyVvuLqyak1Y42x0uwn8ICSWKNnkt2lecgF9+CSd3XINU57i7vbHw5C8H2kTqzvE77BKVX5dx/M+9dM3hvQ2kdFk1CO0dizWkcwER74x1A9ga0/EOkWVxaW9uYFjRMmMxDayEAYII6YrT2tOLc782t/S+hmptyUbbnKx2l6NZs7mPSYLBY8rM0M6tvQjoQAOnWteOwig1C5vUZ/NuAgcE/KNowMCq9tpC29wkz319cFOVWabKg4x0AGfxq5Y6SjazNcRtIZLraHUtwoUYyK469WMm7S6ffrtqblzU5gvgzVYEH7x4HPA5xj/wDXUj6xEvwwKoEWJtK8o9skxYx9c10QEIi8qC1RwBtIYkg/nWTa/D/Sw0YupLsaeX8wWBnPkZznGMZx3xnFYUK0FFRm7Wd/XyE0yTw5dSW3h7TEmQuY7SJSDzt+UDBH4Uguft/iy8jQNA0VtHll4OCWO36c1tXPhzTtaktNqSJ9kuFuIzEw2sw7PxyPYfnUOs+HZ5J5b7T9kF0sQXZtPzY3HGQcc5rCTjPmlfWV/lqMn1LwXour3dy97bM148at9qWR1bAwMEAgEY45qvD4OsLjRoLOeQCxicSR2sUflqGB4JIOT+lOh1HW4TsFsWkkwCWhDEnt/wAtKe666mAIZgp/hESAf+jK4YRxjjyxqaLbXb/I1fKkm1uaMei2F+skl8gmR547hIwSnlvHwpyDz64rPv8Aw3oWqyTjVbdbljM0kbDcjx54wGHPanGbxGqAR2K4UY/1S/8Ax2uMl8a6lHrbWU1v5UhZiC1twdpIOPnweeK0oYLHSl+7lt57E88Ox2emeFbawsBYW0wTT9+9oUiAZz/tN1PaquofDzw7fSyXAtRb3MjZZ4iyq31QEA1m2XjDVLi2eRLcYBP/AC7j2/6aVMuvayMO0Gwe8S//AByt3hMxjUlaVn1/4INwvaxvDwrb3MFrb3xW5t7R0ktoUTyljZPuEBTk49Cce1aVtZ3EEk/mO0oeQuoIxsB/hFcefFurkRmNEfzPugIh49SPM4p48Xa8zALbFuMnbbjj/wAiVnPL8bNWkHPE6HWvCul+IVj/ALT09ZXjBVJAzI6g9tykHHt0p2n+E4LKyg08TA6dAdyWyRBAT6sRy3X8a5U+Pr9SySIQRnpbbv5SVoaf4o1m9tmkt7YEJ1xAB/7Uqo4HHqHInouhLnE6G38Jaemk2mlxKU0iON0ey3Myyhjnkls8E5qlZfD+x0jU5L7R5VtZWG1Wli89ox3Cs7Eiqw17xK+hG7s7MyMId6qtsCT9B5mSfwrK0fxpPqmorZ2t5L/aGCTa3MHlOxHXCvIMnr0rKOFx9pNS06/8EfNE7rS7K2tIri1jLyvvzNJLz5jMOayLbwXDYfbYrG8kgtb2TzLiMLuZjjBAYngY44FYljrPiDUtZ1e1iR1ezkRZQkKg5K5Gf3np6etVpPHmsWOkazdTJuTSpzbyObcEhsqBn95/tds1nHAY1NqD1dr/AKBzROwlt44NXsoo1wiWUyqPQDZR4fmspdIsoVmt3lEK5QMpI49K4/VL7V7bRzrt0bnEFsSwVFCFW25BG88YHYVhX2vwwX+g6LfvJolt9iW5ku7CLfPLnhFVlUsmeckZrfDYCpUhyp+rXld/qEpHqMOoQi9v4rk20MVvIqIzYXORnkk1pRJBJGHTY6t0ZcEH8a8o8Gahaz+P7rT7W5u9X0+eAuk2oI7SROMfxOozkZ6jPAroLH+1NP0fxOrzqYY71zapGMeVGxHHQdAanEYR05cvN0X46AjqrrVNJtIp5Z7q2RYEZ5PnXKgDJOOvFc5B480W7ECTWWoWMF3lbW7vLYRwznqArZ4yOmQM1kfE/T7a1+GcvkQIBuhBkUckFxk575/rVH4qMy+HTGEAW3tYZolDYEb+aoyB3ODjHoa2wuFpVIx5rtybXpa3+YrnbxC2uFLQmN16ZXBrF1HxPp+mak+nw2V5f3aKGkisrcOY1PQsSQBn061d0+wuhqXnvZpaxGLaypIDk8YIAHWuS2ahb+PNbbwuLad3WM6gt9lY45MHYEZeScE5GMD19OXCYeEqklJ3SV9XZbpaspto6ay8R6VeaRc6nExVbQlJ4Z08uSJx1Vgeh5+lYVp8RoTJFcXmmTRaTPII1vvs5WJcnAO49Rn2FYqQS33hPxTbSAprk1x/pyHAQEj5AnJ+THrzUOs+JbaT4ZNopsLuLUIrSOGSB4GCx7MZcsRtxhcjn0r0aeApczjGLleSW+ya3/yI531PWpI4xbOzbclf4a8vh1LWdTuzpekizxYQRGWW63Y3OuQqhcHp7123hwy3Pg7S3dsyNYxM5budgNec6TZN4g126aC6n077FDFBLJaPtlmJXPzZyMDGBx+NY5fTUHVVT7PV6rewSWxv6Drj+TqX9oxfZrnTXZbkxuWQhRncPw7VUn8SeIJtFXXpdOsv7LbEhtwz+eIj/Hn7vTnHpWXbwyJ4a8V6R8ss1mHzcAfNPuXdluTlsA5/Cti4vkHwy3DCwtpW3Of+meMfXJxXe6VOM7qN7yS+TV9PUhO5siF2shPbzsbaSPcuD1B5GK5e1Vk06y4ARRuJPYccj1+ldLobSWvhjS0dW3iyj3cf7A/z+FclFrqtY28csYkRF4OwjJHbA9waWCbjOcVsmKRfmdrtGDyApuzG+SjD0B9uTx70n2ZDbp9rEmMlcnkBsZJ+tFpc298nmSj5Gyyqe3PQipmne6j2tGocH5S3Oc9+2D1r0PadzMx74+bNDujdU5GXIwo+vpxVecLMolXy933R3L+n/wCuts6WJYZWE7YUqfmzkH8fpSPpxDCdIlZGx/vAgflj8apSTBmfJ9hRR9sQR3O3BQHgH19setZS3uoRyZjjlubZ3+Z9pz9ASOOtSXEFzcX3mmYsHY4V48DPoD0/yKtTWl9GTGJ/JlYnDBeH454+nFXsBf8AD6yN420V4pkeM3dvwSDgbxxx3r6Wr5r8KafcxeJdCSQKii7hfHHzYdecDv0/OvpQV3YR3TADXBeIhK2u3WyAcbdrFvvDaufp1rvTXA+I5I01y5wQjjbuLd/lGOv1rWv8I0UUOYfkwqs2MMw7e9Z199ujVj9pto4ePkPOO3U1CmrwW8rqZSVyQZCmQP8AGnQX0epJLMsjyrGOA64XHYY61x3TKKQ1E20kTTajHMjcmNIuDj0P1rSh8QaXNJseRhkYHmDaM+gxUoKSs26CNEKkbNuAST24rNm0DTJ5ld45VwcnbICp/nSs+gG1avZWzr9nWMmQ5VOnPXGc1I83lbmWNNpByocAA/WsqFLe3YpZR7FkPOOcYHTBp95BOXAlmVEPVQBlhwOxp3Afe3tnZoJpmidsDbv+YnHoM4NZo8V2YIZIj5ijG4oOB36c/rVz+x7CYBpN7vH82NxXB/DH8qr3OjW7WrRwW8UR7EHp9R/k0n5CSLVv4ntZYtszMpLgkyDaCM1bmurK+hLpLbyHdlSQW6emOlZK6FF5Mb7SxACkgn5j68k/rU1rYQ2Y8lY1cqwLeZwc9R0ouymRm+1SYMf7QtooEIVQImJH5rURGp+ekcF/DcuQGKNBt+X2YZwfbIq7cadcXDxzNezbxyFiOAB2B/GrxhmEDCylnMm3bmZzwe/pj/PSmIkWGY2+ZIgLhgFYoPlH4ZFVpoLhbVo4hEsyklJPILEfUA1B9l8QRRGW3vLaRlHzIy4H0yP8aemoXPlldRltQSmd8b7157YODn6UxNDUm8xQkuzzEG1iy7Cx7cFuD/jVz7JG9mwRnizGS5DA4b/9dV4rxblUgiD9eQse3I9iRgD3zUd7db8xXFmqIufL+boRzkge4NAzAvtTvtHs7K3lt4pwqFFcT5ztx/s+/vW8muagilPssEvoxuDz/wCOVzHitsizAUBQHwd2c9K7bTtNh1FGdYkjhX7xHU47e1bVssw7oUpKOrv+Zx0qz+sVE9lY5bQNeudSnkgTSYJWOMB5iRnn/Z6V1tzBqk8KrNpVhIq/wrPn8hsxXJ/Du9srN9R+2XkNtvEe3zXC7vvZxk12s2t6MXVhrFmSM4IlXI/M1pWynDqbtE7cTKoqjUVoef8Aiu2v9EsX1GHTEeBD+9RJixQf3sbelc14i8avarbmTTwd27G2XPp7V6bq2uaU9pMovreYFDlBKGLcdOPWvINV0T+3J7WP7VHbxxli7N1wcdPyq6WU4f2U2466HDKdb21NW0dyn/wsBf8AoHn/AL+f/Wr0XwnLf3eljUF0yLdMnmIskpDbB3Hy49+tZukeGvCWlBSJYJn3Z82crIwx7dBn6ZrrodXsIlczanbtbgALCJMn9OmfpXBUy6k9FD8zv5ZksOo6tE4RYLL5iSALo9P++aa2v35naCTTrczqM7RdYJ/Ic1kveafPMmdRhjtS+Xt2G4E9snPQUkuoWMN0TBLFsPBMLQoH47hu31rJ5XS6Q/Mdps3I9Z1GRhbpZW4/ur9qK5/8cqvceIr6Ccxy29srZ2qkl0Sc+2V61gy+Ko47aGIo4csqoF2sBz1bHQUCeC5uozLPDMynK5cNtOc8e+e9TLLKfK3yfmKSna5qpr99/aMCDT4cuyqP359f92ulW/1a4YqllZsUbacXR6jt936VxNw3l3sMm4KVw249sHrXWaNrejwwKs2pWnmHdI5MqjLMSTjNZZdgKM0/dNsUp+wpSj1RdN7q5P8Ax42v4XJ/+IrFufDrX2hSpeIizLK8uICCQGJOMkeldENc0H/oMWv4XI/xobXtDRCV1ezb5e9ypx+Zr2aOBhS+CNjz/wB7fVHmOif8gmb/AHm/9BFXLvT5NMgMt7JM8BXbhfUjqcdR9ap6GSdImPH3m7f7IrVh1qzaQxJJIihPLI2hlbPJyMHP/wCuuOp/vNReZ11Nb+rMK11XTbe3kLy3AkXhV2KN47ECql3qOoXXlm1Zolxnd90cAZ5PJ/OrdxoVrMqpaW8cb7f9ZKmzafUjPSqKeFNal1CG0OqWyggsB5nAH4VDi2zIgH9uRzq8ARkP3dsgJB+ldX4f1a5F6ZrholinQxyIMAq3Y4FPn0xtIco0iTP5YwxG3n8DnnjtUMbNaWtwVWEyshl3GNvnGByRgc+2auMLagdXBNfjwtZppcsMV0baMo8qFkzx1AOeRmsqfT/EmtavpN3rbaVFDpk4uYxZI5d3A4BLdF9QKfoOs6eNFsUkvrZXESKwEgGOB2JroYdY0FCT/aFqx9pR/jXzinXjOaiuvYpWM3RrPUNP1/X9Qk8lk1KaOSMJuyAqbeen9aoReFrmey8S2V8Fa31i6eZfKUkoCABnPcEZ7iuo/wCEg0YL/wAfNqcf9NlpB4i0BhxdQA+pcUf7TdtPe3Tt/wAMGhxx8M+K9a8PQaHql/p66WyoJZ4Uf7RLGuCFwflUnAycmtO+8EXR1Gy1rRtQUajZJ5CJf5eJ4uoU7eRg8gjNacfijS4rOOMTxNtQKSsyf40+38W2AQmOaIjcckyp/wDFVwKvjXUtGNkr6JaO+9/U2cUkrsboWmeJLfVrq71ibTFhuACYrLzGJYYAO5gOMZ4x3qTR9K1C2m1n+1ZoZ4by7eSBEz8sJ6K3A5x9frUv/CXad/FLH/39Qf8As1IfF2lkfNKg+sqf41FSliJ83uWvbp2Gpx7lTVvB1lrGjT6XPd3v2WRMJGZcrGf4SB3weetcrdeFvEGtpZ2Wu3li9jZuGeW2VxNcbegbdwueCa7E+KtLP3Z4z/22T/Gs9vGWjKebmH8JE/8AiqVCpjaTcVG/a629C3yWuQGy1a31+xuYNQdrBUkF0k7FmYkfJt+XAwRzyKyDoWt6Vr+o6loNxZPFqJWS4t78MAsgz8ylR7nit9fGWhsBm7gIPVfNUH+dIfEukOyiO4hbPI/fJ/jVQli4fY0tZ6b631JfKyn4d8M3NrFqVxqE8VxqOovvnZEKxqApCqB1wMmsifwT4l1dEsdUv7FNNDDzFtmkZivoN3C+nU4roG8WaTbyMkjqCBkYlU5/WlXxppaqSs6AehkX/GqhVxsZufLq/La21gtAuGxjtvLkZXQW0bLEE+7grjGPpXBweGLfUfKv47q9srtolWWS1k8vzFAGN2QRXZnxlpboymZckHH7xfT61hab4kRdNtYDp14f3SgnC4PH+9W+Bp4qKk4p30/UUuVkmi6BbaPbywWzsVmYtLJMd7Sue5z1NZh8GaRBtja4vHsw/mCxM37gNnP3euM84zitoa7FhcWE5DnA2tGD+e7is+71CJmLpaXPzcgO6c/+PV1ezxqk2r3YvcNaXU1SJtyqVA4GOnFeewavanTQGtwWiCsp28hvX8yK3p7vGMWVwc9NrJz09DXLx6VcxR4McayYyF3E5/ECt8DhqlNS5la5nMuvqDQQxTQKgLN88bHhj7HtVm31aEPHJccwHPmA84IOOPzqhHAsk6I9q8QCnzN3MYPODmpLi6+zE2puFmcr8m4AbgfevQ9npqZm3LcRXeoMkNwqRABQ23cGGMn+tOuiI7Urb3isjDaGBzn3P+fWuct7uOOcoo2tyGAU9PwqS4neSFEjZi552en4Cs3Hl2An+3TWjzRuUhSRd6kKSWIPQD8PwqK6upbi3Cqj7sHaoX7gOOh9T6VTOoFYvs/nK3l5ypGAOnIpv9rkyF0CkE5zjmhuQG74UmMfibRnmbcz3kUeSc5+dcH69K+kq+cvC14tzrekK+W/4mMLbB0Hzrhq+jRXpYF3iwYGvLfFuj3Vz4nv7n7dJBAxTaAeBiNQcj616ka828Uah5Gv38cwZoiEGOAMbB61vX+EEYVno0NquXuEvVkblnUAqeT1yMce1aIslgYEmVTID+7Y7hgd+mP1rn7rXkVsLaK5Zc7t+4Mf/wBVaujXi3KLMkTGQAZi8vpnjIz+HWuRIsviJ3JM7wqoG0fLyPypHjijUpExMucJnue3Uf1qKW5236xGOaNuvzITj0yQDg1JJcMAHEUznHDBCw9+PzqhGNdpryGXEKqQw4Kg+4BP9amtzrDLGJRFGzYUgLuyOM4x3/Grtnd28u9cSRbwSTIc55/TtTLqZ7cNb2CPPuGd4cFc/wBMc+1SA+H7SjFGaL5zj95H86/rVefSLyefEd27rwSJG2cfgDWqtzJbWvlvJ5jbcHavyr7/AEoPl3Bj80mTaAVaNeF/Pg0WAxv7EMTEm5nY527FYlc+xNTGO1sLdHFo5ZiFkO0uW64xx9KvLPFADidwu4FgY+W56U2O7ImEKSKd4+XeKLAV7lv3WUjD8bgCQo+lUwNaculv5EQGMGN2wSfx+laRtYYIjLOw2kY3nnn6E8D8KmUCzIAieQ4PKLlcemQeKAMZbbWnVkvZ42iJyygknPoa2vIiNt5LrsRlAOxSCT14x/WovtojRmMUwOPuINxA96y7u91K0MiW1nNcAZJkLbjk8nGB/nigDXuFtryGJ23kIuGjYtkkeuOlVni3R4KhZVBC5/iB454GQPpWIfEV0JI9+kMGIAU4Y/XJ/wAa1LG4E1uZGtjBLnbt3Arj29DRcDm/Fdy9y1oW3fKrgZGPT/P4V6ZpMtvbacqbpDvG7lemfxrzjxekY+xsjBt+8n2+7WiPFkMUaot9JgDA/df/AFq9eftPqlF04uW+yv1PLhKCxVVSkltv6F5vAPh9Rn7ZqHH94p/8TVSXwToQB2Xt4T6bl/8Aiag/4S3cpBviTsGA0X8X5VXm8Ut5h2zR9T/yzNYLE4zrTl9x6H1tL/l6vvIdT8M6bY2zSrPc5B6uygfyrlC0KOFm3ncDtVByTVrX9Svdakjt5ButUJcsuBuPuD6c1JYadcXtwrWyBmiOckA4z/8AqrthUrrDVJ1E09LXRzSxs3iKcYTutb2K8doZ5R5ZYRtnGRlgfQ4/wq7DpkU8xTbMqjPLYBP+FdVpekMqCa4txG2OFYqQD3PpUF9pK6ozny4lfGJBINvI7ZBH/wBbNeX9crdz0vbT7nNrpUCENcXcawlsD58cdzkjH/6qd9m0ZZAr6gQQP4WBUn2bGPfFWj4XntZxGTZhcZCAnIPvx0960W8PXkLKZrm3V5FONsfI/wA+1H1yt3D20+5Sh0GxulUQSyMzf9NlwP05qS30GGKVZVlbfG4YBiMMB6HH0qtJ4c1bzxN9oAQEgbz93sDwRWla6RqdqV8+9hkjbLMqR5zj3/LvUVMZWcWrilVm09SO+iE1ysbbtrLtIUZJyccVas/B+mXVuJlurnaSVwSqkY7EEUTWguDv+bnjinYMUSRGd1Rc7QSP8K83CYyrhk+W+prLFRlRpwTs0tR7eD9CQANqFwzHgKrK38lqnJ4c0ZQCpv2BBPLIOn4U43kCA/8AEwRc/wDTRBVRl02VgDqIdsf8/X/163nm2LltoTHEQtrJluOzgsbOWK3MhQ5bMjAnp7AelcPbaDqolw2wRljhhuP6126xwwWrJHJlWBwWk3fzqs+20gcGdmdCTtI568HIJ9uDWeHlOcpTnuzBSUk2u5DpSanbr5k08VzCi7RHLMDnnHGeh+tW/sNxLc8bYl4aQxy7iwB+7g4HHPt9a5y8k1q5gCraSCNG3tIq7c8Z5I6+tZ8OrT/aGjeRo1ZcbslgG9c10MR1l54osLMtaPBcuzDBa4I4IJ6Dp7VQfxld3O6JTbsmPlTy84rFnefuVnUHhmHyg8f1q4l7FZ/v1t4Euid6Erzz2Uen+NK7HY3tOv0bT7m+ngVPJZmkGzBO1Rn8a6PTNQsJIbG5ESSW8gLgMuMggbWx+FYOn3qappjk20YXBjaMfdJxk/TOa6CznsJdOhtLm38lYo1RRjIXAxgYz6d6nD1YQnLmZzPVu7Ooa7iuEhNksUvJDIwx/nvUjCVEO6ziH0YVx8Msdo7Pb3M6HOMDncPasm7vdTuLp5fKlOT/AM9FH9a6/rdHuiOVdzpZ4omivJfLVWkLMy46HGP6Z/GpfD8kdvYXTLGjOpJCke1ZVpdH+z5FnlJmkBOCM7eMYz+FVodOnuJBcW900LgbX4yrDr/WvHw1SMcXOb2udVd+0UIw1sjt0lPlq81tawhunmMBUU00Ajf7QbZ42X5DGoIDe1cLrV9qQlCfZby5KDG+O3bH4VX0jULkK0F3pWoxxuxYN9nc4J617H1ql3RCw03rY3tNETXN2dmJMqWGcrjnBH61z1z4d0+/ke4uY1jxhtxblvXNdLYXE1xdXJMMsdvhDF5qFTkg7hgj6fnWC1tqE95HF9tm8lSfkYb1I7YxjPf1/CvKw9pYmq15HdVuqUL+ZRk8L2Vzam300RJMXx5ybn3YHI/XtWSvhjVrS9g2Xe12GFJzyP5frXoH9jX2xwJEePHQReWfw5PX1rCuFuWuPsd2eh+WRTkR8469hjr713NHNcZd6HcR6eyTSxTSgAEs/wC8Q8HjP/6qrwaerIplj+cDac5Un9K1oI1Nl9puJpbjChDJs5I7DO3msy6120tbUI88icZDq3GR2ORyf6UrDLttp6eYvmSFFPUuwP8ALv2qeNbfc1vcxyMmM/LICWOD0z0rLk8QaVPBGWGxj8zbE4z78mpb3UfD7ySCxW6RpF+aQttAP0/yaNegrlua1tZgoshPG28vtkZSB3wOhP8AKqnnJbymILKZd+SGB54PI45xWhphVb2KQ24aLHzbpWwB2+U/jV24lg1O6Z0jt7cqMHHzbm7cdB3ptDOemt50gW5aN0ifOGA47gfnUEX2c7kCRuDzwxBGOn+elb1vZxySp9rkQxA5UlSwH4U+/tbBrh4rdE3DAbYuAw64Pb06VEoNu6YGE81ikEamJFd2wwOWXHrn2+lINL0+9k3IIQ4/iZeB/wDW4rRtobfTr6W4FlC8cybCjpuANVrvSI724WSy320SEN5XJw3sT0HtU8suoWIBoun2yK4hfz+jsjkZB9BWedMS0BeOd+pILqQQPT3roLa1nhmDyvvbGM4x/Tiq+qTReUY5bYvxkFTnH6e1OUU0KxzSyWSFBIIQ2N3yryT9KZI1oHjEDAcchwc/Wr0+i28ik2txOspBwzAfl2rNOhfZ5C0l477mJ4GNp64NY+z0vcVjU8MzXMHi/TI9pEf9oxISAOP3gFfS1fOXh62+y+JNFXzAT9vgySeW+cV9G124G1pCaA15x4vmtoNWuDIy5dlVlYdBsHX2r0evNfF72UfiCbz42aVtuwCJnGdo5OB/Wuiv8IR3MW38m+kUmzUFcbcDlfp2PHPFXgIokT5VhkU4jZjjk9sdMVPFYiSBZkbbIW4AOB+FZq3g+1m0Fo0rq3zOCTtJ7k5xXKUzQNyLp3jVBI2CMO4XI9u9Qb57Mk20oghHzFQvXpjkn0zTI7PT7NpGlZi8gIkEZ/U1eDWk1kq2RVhjCqjYUHv+NMRW+0JHFLJdSQpGSQSMhzx6Efh1qDR9KW0t3+z3LNDJ94ysCxXt+PrUcrQl4l87z2/iYDHl/h61rRRqieUtygTGdzn5v1pDIGjWHcqKocqRvR93y+lV7WxNnN9oZpnbGBFK5wc4PbipG+fa6y/LyCzMM7vxp8kSefCXEuVI2Mz8ZP8AM0wJfMMLlWtVGQfm80kL747VUKLKWZrgCVRtIJw/1xUE8MR1GXzsyowCKRkDJPIyDVS4lupiVIHlIxDBgeg4HfnHrSuM0I7q1I+xGWGSRjh1jbLAeuc1YlmlSBorV2TyxyYtvPHfOPWub03T5LXUWmntbXZt4aNju9x75reLW0SEtHKF/uby3HpzxmkMT+0FgZBO6M/TEnams+5j5JSTceVDEJn046fhTFhymRY2qxAEmQ8MP0BzTZ4UurfaFMS85KcZ/POKLiJzclYTbBDtXnh+M5zULrPJArSTOBGMrhiBgdMD/EVDBYC2JaKR8HGWL5P68Ut3pt1e4EF2YiowV25J+lABcWGkywxyXwe4EYPzecScntgEelNj8MaW6K/2X7xygMrrx75NX7TTTZwtDKrSLnO9kI/E04QywyqcAHbkEtyD2+v/ANet4YmtBcsZNL1MZ4elN3lFX9DIbwfYqd2ZsBhlQ4If2U9atHwjpYmQvE+0j7hdhn8eMVrvNIBskj8xhjOw4Xnr3pJrmNFChnzjDbRkH14q/ruI/nf3kfVKP8i+4yY/CelqJTNbONpO396en4Gn2um22nTymxWSJWXJYhiMduvX8KuyOI7aMrbEoWABI5QnJJPXNROPtvlGBV8tcNIy9v8APvUTxVaa5ZSbXqXDDUoPmjFJ+gB5D83mxbWO5g6k4+nWojqcFlcspMYhYZYon3m+n4EUXFvanehOcjBEkgxj/Z4GeT1qjD4f0tmZmePLHJRnIHPvnrWDNmXftMGo3juqzOFTyygBGM9zx1/GmSI0LtuZ5g0uVMj7yOOeT0FSwLLp4S3s44vIdiWDybio9iAfSpIt00phYKkK5wU6D/J9qYiCK2uFLOhR7foQV3Y/L8e1NS1Ky7BGSGONwjIGPTofatWddiS4t9yrgnLbd596i837TGEd3C7QreXIAV+oxSuBkz6fbwSoXneKUkOygMU/zgHj3rO1K+huJHt/tUMcqYCs+evv2FaF9p9yzEQyTNE44DDdz+H86YnhCNV81rSGZgA6ueM/Uf8A1s0BcxYtG1XU5liGoWxdcFlKZyPoRW7pegWyWLrdbPPLfP8AZl8sNx0ABNTmNYIxlggA4Yrkf09Ksi3nht/NaZSsvIZExj6UWAryaZbG6IijuJDjDRuePbP+e1WksILeMuVQDGNu0OM+3p+NL5c0NqXYK7seHkb5iO3Gcf57VXaXUQ58xo0iJGRIvT6cc0xkaW7PGwgnZ8nq0WMew7f41TutK+1SQo6IHgPmAJHnLepzWpbsLLzP3XOCXB9fXA6AU2S4iuZ4nmtd4I+YxluD7j0pAylc2gu4DHLb2qM4yfkUJj1JP17Yqktjp7xlXtImSIb5GPzBiOwwOB9OK1pbqG5uQssRa0YDaUJGB646fpTZfsP2koHkVcDnHJPpgHj8KQWuJZ6bp81qy2UBtpCdx5bYTkDqR1xVbXrO7toYhYRAy8lyrZX6c1q2keybZGZhwC0jkDI60TWaPcurpKpl+basjMp+hHQmk6UJatEOEXujlY9I8STIkzXUUGcAx+WHK/lk1kT6tcW8zRDUAzgkAbAOPxUV20v2yfUPNtr4qFDLKjRn5Tjsp696zjpOnWwlj1CwjE0inayIxODjPzc9eDzUSoQ6IFCHY56PXbqMcpb3BzktJkED/gJFdDFqGswW/wC50pGDYYbH3cEdcbqqWvh+yaCU+X5oTcwBJBx7j8Kb/ZcqRK1hM0asm195Bxj2H+etZfVacviRpBuGsdBIfF1zcSPEZrKOVeArxOMnv/HxWzb3WpuFM7WrkgHMVu5Bz/wI8e9YX9inZtmjSUt8zNEoU5Hoe30qxYWN9BMFEsckA6MX2DnvxmhYKh/Ka/WKvc2JtSu4dzgQuo/hwQfzyRUEuo2s8EMMkkdq0Z3Qu/Ueyj/9dXYppIidjKy555+9+JFV7i0jnkDCRkI3HanQ+x68VrSo06V+RWuZzqSqfEyPT9QtLyGeNC8l0hILC4KjHbHI4NV7jymmjWAtJPOdhWR849Bjj8806DSRHE83lxzlWGS8ZZgoPbn+lSXM0cs8UDpZo/ZS2HHPbHbitibE8K6i8LQyIJI1JGYmLIpHb06Y61UltVZlNzpjMvO1sqQQe5xW/p9m5smls1jCqCvlnGJB9B0696rxzXEFyIIAgdlIkAUDbn2FAXMqXw7pU7NA8awyKMgKR07evGafDodr5TwrZByv/LQvkY5z+P1qxfNDBAxkvgiHG5UA49Rk/wCNZNvf2sVs1v57yRuchgoBC9uOfek0IsmCCw2wJDImAMDkfr/jUbNA02ZxcLtwdqNndj16VaubhoLZJY4pnj4jQvyWHYDv1PejyEmC+WXk7BolPB/LpTSASfUo71laUSLt+4QFUYPfp04oim2PEbdi8yZ+duCevTjnis7ZcT3bm2ww5VkLE4P0x79qux3senLFBNagso+60efm926ihjJZriR1SGMxrIzb2IDbiPQdsVBCbuC4kkeFVikHzHcWxTJddMs0kAijhAIGS24Z9ic/oaatz5iMjws67jyWxz3/AApDLFxhgB5wLqPujhTnpu61A21bUt5wDlcPld23Hpz70020NzC0zNLDK2MkH/DGayb3w/cl2eG5zDIcYkyrIPpUO4myOVb5t0kLw3CE4VF4J/PrUVrbX8+R/ZrQuvVuBk+lSWmk6np5VluQ8P8ACpbqfXGa0LmO/eEyWjHz4hkpv5J+lTy9wItJ0K/Hi/SJtvypfQuQXztAdc9q+hhXhGgXWsHxPpImt8g3MayjsvzDkfma94rswiSTsTIK4PxKVbWp16Bdpcr1HyjGa7w15z4nOoHxJci3aPyvk5PBX5Rn61pX+ESK3nedI0hkPmnAROcLjuMetV1hX7UWRpUt5Gy24beT1wTnipTFcDCTKrr/AAvF1H1qEyTMZUSNsqfvAD/GuZDIbzTYJI5IAxnidlJTBJAHbII4NU004WNulvF51q0bblK8jH0FW/ttzBZ+aQs0a5+ZmCsCP8+1S2Wo6jcWTf6Gn2pjnZvHCn3oAorY2aajtn1B5ZZR/HHsUccn3Nacdhp5z5EqE5wBuzu+vPWkN9H9hQ6hbTSyxMQSgyq845Ipi2emQ2hvrRP3iAthFAZvXPHNAFqBFeNkhnmKJ127QFPpjFMMHmKSGXrku0m36dBUVvqzyp9nhhmYAcvtwfz6frSyiNlPnyTLGuCx9OMehHpQBNNbSmLMcUQfb8zL84P071CqXDRbXESH0xk/zpYilnLHJFKZN3CRsfu5HfH9BUs63E6ALGAuDuxJj9aTQ0ZxEqHMg2x7gOmB7e9M8ib7RIxnMuCdhDnj2xxjrVtLKMuCpkLA/MjSZ3Ht7VLcadPA7zeZEbcAHap5U+5qbFXKEc0jmX99IcfeAIJb/wCtxUoCPGMljKMBZAuAR7/Smf2fPMTuUmPB5Hce3eqd5pc1rumVZIYm4+TkgetAaGg0bEqomXk8jIGfWn/vLdVYquN4CnHX3zXOQRNDcjzJHMhJdd0gIA78f1rctblpJAgjOJBgHqG+hNCBmndeWS8bkwqwyTv3ZJ7fSqc1uLiDYk1zHDnLyIvLn2J/pUYhQvPPczhTGR92PeWHoagHmXYDeZL5BJUblCk4HQDH9KoTZajhgt0aA3TSqzEBZCCWxyR2PvUjS+Xt226sqDICEDaTxzn2pILxzG0McUIkBwGTOR+ftTQxPyO3CHLeZt5Pvkc0gGTarp848qDUFjdjtKMu7B6f57UmnWk9rcFpbhZHfO5xGBt+mD3psWm2jSrlTG+dwdAvT39aJRvuJke73p1+VSnPbB70AK8Id3aZo441cr/qskZPX2qRLbbMfmjGwY34/wA4qeBl25it5FcABxMNw+o9ae1pI0e5l2qpGXbHOfzp2EVYoPJcmeYRptxkHBP1wac06Qh8TTtCR8qqMhR9DVqWC3WNWeSPY2PmbjH+eaJY3d0RUhdHzlwp4x0570Ac7L4olsY3t4LF2Td8vmISP/rGs921Z2m22txGJW3FFxxnv1rq2OPuAvISRnpj8+nNWfMe4jETCP5PmZ16jnsAaTiBy1n/AG7BMJEnZYl+8ZiDsHuK1ZTdXUwG9pZHwcphU2+3fuPyrQnFtGNquzyHqr8DHrjGTVFZY5VCGKOMdmUlRn6DpRYEItpDFKyFIZz5mWVkCk9x09/5VMXniRmSMBUHzu4OUP178UhWzVQRILa44wwAbdkHp+RzSWMiGOXzklZ0wDI7goSfbt9KBjrS6SJSfL3sAW8xs/KD6ZFVgtxNDJBJczBQ291VMD8h1H1q+JXdGxH5W3ksQvH0H1pstpcKokeVWQHGEBLHOegHtigCu8EbWywwtHK0hG5WQnHr/wDqp6WF8kgTa0cagjCkqMHH59O9SQoWlYRZfYu4IpwSf6flQmoy+U0922Yl3GRVIP4AHGaYyKK2ZfNkn2blYbQoHGT15piWt1HPJPMVuYiPmLEk5/L1qu6BJ/lk84MDJH5ZOCPQ/QVYkuEFs8W07SQBIFII/p+NAMJpX8lRDZ7JCpOQSc+xxj+dUobtHVnuZhEQCwYtgA/4dasx3U6KoUu/GAGznI9Oaf8AvbtiXhAZQEYPFuBXGSff8eaBD5LVLq0S5tTLJIDuB42474PTP50yM3M0zLtkjO3BLYKn3yB/nFILya3gWGO2lQHLZjPyj8P6ViXEt0t+P3aFpEywG5M+4APOKTYHRB5IGld7SWUqAYmtjsLY9Rn1qEyXV1Yo91axxx4KhZwQzEe69O/YVVt726CNBMXjlH8TDhx9fyrUS9uLnS0uZI8f3l8kgH1PGc9KaQFZrCaOM+UEZAN2xyXPvzjn1ptnGlwrGa1dlXJbYo+Xnoe2cVCgmtV2rLJCoY7ZFXJbufw9qnh1WG31FHnu4vK8osI4D156ngdqAEWzkEQnxP6g7duB2PIquUaTdmZ4zI3BDnAPr7/SpG1aSS/Rlim2zL8reacD0BHrTZLuPUpljihdDExO3bg46c5/nQCQ0+bbM0aSpKu3BYKd3PcVQ+aVg7QuFVfkM0Z2tznnjPpWm9j5l2Xjg2uAF2NJtz04yf6UBpbhHVAcLkFN2D+AzzSYXKML6lFHMyPO+RnEg2g+pG04x9cVZV1ieCS8kSQnhmQAE/73r0ovEeCMSCIB3G3BbGFz1x3zirNpZRz2SrEIIyuflU/M3TGWyeaLgyvq8Vnd2tv5V7GilyXwvQfTj1HWuf1PT7xY41svJMiZDOeQwzwffiuu/s/KySeYRHjaQ6Bsf7OccfXNZ8mnqHjBlJIGBvySo9M96YjmiNTkgRzJE7DojvtP0AraTU9RF2sXmnywAxUL8pPXnoc8VKumLC5kmucArk7gRzn15qW+tfO+zAXly3OEzM2GoGhQtrcWo8y1tlnRg3yboxx7itq+tLLUIPtMQV5GxkgkMDjHHYn274rn2jvNOkSFZBMzlsBTkgY6E1oWGo3NzbtCxhVB/CGbp74/pRcGRLoUduoM87hHGdoBAOPUYpsljLHCZojFKM55AJH5dqc93NKGmWdU+XABkIP6014nDm4G9JinBU8H+tAJmYt8LeMgqAy/eJJC/kKWHxFeG3kMNoJP9sIGwfUZFaBjVLd1hsEmlmOJSvIK+mSc0QaXp0SkuzRSgAmJO/19e/pRa4M5j+386jDbvBIwkj+6ykgH+8OKmj8RQ5J+ZJCSM7PlPrnHerkWqrBfXMyhzHbMQkyoSeeP1rat7TSby3NxLp6TTg73VFJbJ6ZpOFupKYeHNRtbnWrADCS+fHjdKPm+YdB3Fey15Lo88b6vpkqWcduFuEjCmHbjLAHrXrVdWH2EwNec+KZ1j8Q3KqEaT5OHIAA2CvRq8l15bt/iVesoC26iMZk5Ukxr0FOv8IRIw017Mi7DGikhmX7p9s1GIjBeSlrqdgpwmFBwT71sInmtIoQ4B7DA+orPktjE0sSQSYbDMckjn3PNcw2X7C3S5iWa4HzqcZHRvXPtWkbePI3McZyBnAFZVjO1mrJIubbPykckf1qOdysu5rqOVC2QGfBAPbFMVjXktoZFZQxUMMHFcdNqWsx3xivLOR7WNjErQjYp56n8KvT6kkch2CZ2zjakgKg+uO4qhFqEsbSmS2uWkLcMPmXPuM0mxo0v7TkgtPNtLIJKxAZXQquOh+brnFRWN7eXM00k6Q/McCM/MoHbp1plpdPdSsyqRIoztAwrf99VE26OMiG1eK5LcA8gD8aVx2NA2Ye0drS6QsT91lPye2M561lRXevC6kjazEsIOwlW2ZPr9OtavlzRvHI7jzJCOmEx78+gpheaO8lmjfzo87SSuCc+lG4EumvZ26OL23Rb6Rih2gkFR0Ofp71Pa/ZwrxRgA9txIyo9SetUFVvtnnbzyMbTyB/9epJG81TyqkHAyc8e4ouOxNci5iYSWk0AUffVyeF9vem3kaXYEkpVztCnkhSe361EHdJQZljWNBjBX1wO4+tQ6jqsVrbN+8aFhyiqeD+HcUCGXeiR3RScyJbyBSJCSTx6HNWlsbVbWZIS9wBgqqNs2/Q9+ayrPWra2TdexSTTHJBfOPYY6Vfg8Q2EiRl7gKHJXZ/D9OOlJBuO083EkTQXAMYBA4OcCpbqC2e43iBZtjA4ZyuOPT0o0+cXPmvJAEbqEVyVPv0qWW4RVGyELk5JVt3HuMU7gKbu0tVVbqdEy+wg8frUcmr6WZzAzhv9oE8D2qa5s7G5TZJaxGcjcFkAJJ9MHpXIt4QkW6aY3rIvmH5FU5QVLcugI6OfU7GLEcd0vljlDjjsR1P+cVOXjlCuzRmRjuQqQd3v7VzEvhmOa72QX7yQcNynzLzz+OK6G0tYNLtVg8+aZHwyse3/ANakm+oy5G0SbShPnMeBjlf8KBbIVLzyuZuu0MH3DsTRthLGIgMc5YZ5B+tNZgjn58ufvEA59s1QNEbQ/aIpY7gfKGz97aAtaEEtlAqRxMgGM8VReRvIZQMIX3FtgyRSDyYZ/NjRHL+x+XPrTEaM32ZgCWGX4BXPP5VWEbrKSJNgcEHec/TkVVEkb3w84p5B/g3bgPpU+o3GYhbWy7FbOXk4HHp6mi4IY2+IxxzGNwV2rJ1APp1qCWzChc7i+eSrDB9Kjln3xBTJEVxkhV6n1B61Ys7qFvJjBjY5yc/LmkUZzxLAmEByOdpP9aezTfZsm3Ug4Y4YlvyHX8q1WlsQ7AJHI+7hVUDH1zVN50WaSRY0Ix93OB+GOtAFVXvJFjL+WwP3i2R8tOku4IY2dpnRBJgeUNrfX1//AFVZSPaiyvG6RsOMnHXvVWNIvPkiWLzGV+SOeMd/TrTAW+1ax03TQ9lBJNJdNskdkJbJ6k09msEt4ZpbVfMdh0bg98lf/rU1pEtIfm+ZcHaA2OfTH+NMga4u5TOS4jUBNrY+U9scUAWRqmnTs0KCZsuD5koCAnPAx3qVNRSfe8oiULhMRngZ7571QuQtvCGa3VpFO8lVwwz3zTAxwwB2M6/Lgcf8C+tAi9JdiFwIfMzj5cjf9c//AFqjkvbsMIlMoV/m3qQqDj061BBOViAaQFe5TPJpzx/ZfLUo37w7st1/l/KlcBkd4UZYLneQSfLZuSOc4Htj1qVrUq6SGR42GcbpSu4ewpPMHlQ+cj+TI2FZF5Y+mf8A61TrdRxs20F4jkfvEJxQBONNgmVnaZZMpgEttP0zTZWIjjT7HCwX7rCYnnv3AzTbC4js7ZUjgBX3OP0xU8l/I8ZMUIWQ5XAOB9TVXFYoNdOm+ARsxdg3+sJCj2znH0FStBHMMi0bMYA4OR/KkklmWQSny12qBu6k06C/MaebIkkgJwQuFbPr1qRhFaXEvmI+zBBbAcH9KoadA1vcTboJvNcfKRJnt7VqzzTzSIUtXjGeXfg+2eKikaZobgXflRyD7u0g9fT/AOtTApPqAUEyBwG/hcZz+ParoUXLHy1feoGfLVV6+/emSNIQpMFvvwPmKFPyNZ0puRAGdmWUncWzlT9SKGBPdTPFKBHDJu6Bt2dvvjtmphYGa1d5ZIUQ437SDu9uDTbeV5bZ2iCOWxlypz+vams16I/LWKZt5JLxKMEfSkA+CSazYx21ywDLyrLuTPYYP+NUJFvo5GvVtIXCN91JOh74U9elWYXSFsGLfMhDDjJyOgOankmilJkdPJkLdCOcnuD1/WqEV727adbeWJIriUpl4Q6oUOM47Zqe1kEyHdiHA3LHI/3T6cioltI0uBNKQSHBwOh+ua1pri1KkRQysw7xqBkeh9qAOfutNmkkKtMud+4OSDj247UtvZ6pYSpHLcQyI/JReK0fssd4xeFZIVY4xt4/PNZtzp9yyFYZQkigAF5OeD1//VSBM1YFhNzmWFogvOWBYH1zVOe1aS/VjajyGOVMPQe/Of1qhNDrIhKC5tmBGME4P5nvRo0d/EVaeJY13cjf8x9x60AbKaZawNJFHckK4GyQAn8+ePwpb2Se3Qm1uCW7l2Hpj8alhV5b2W2UBFHKlzgn1qnJYyTpcs8jKFOxUByM+pANMLlSDV5BAJkSNYVOS2cc0yTUPNlXy5NgbJPBKsMdeK5O48PaxJKI0clACV28bqt6Ssumb0u1VkwNjdXDfgaz5mtxHf6HdyPqVmsiKpSeNe3ILDp3r1OvGtA18T6zp9sZA0j3ERAOP7wzXstdmHaaEwNefeJjEmvzkxgudp57/KtegmvOfE8tsfEVytxKq7CmQRn+BTTr/CCMj/hIbJZWtY3VXUYxzg49KvW16XHmKq84OSc5FUrqWwt1DwTQ7/7uASadZagI2bCoyjHGQMVyjLEiQXhwFcswO2ReoNU76GdIQrEmTG1SRjIp2oancRTrNZiNITw7uMgGpBqUcz4mlV2AyVRT8vuaYamK63VmVVMIrDJAxj8jmmeffy+bbJJIm/kFcHn8a2N32ifzUeGSEAEFQCT+NTMBvDpGcYzuQUhmEn9rxQoqw+aVPPIyAe3Na0FzPchEOmtHcQtjzJGBGKleTaVkZCpbHzKuQPrUd9aJPLHLmRXB52Pjd659aQ7lgyO+EYjCHIwD/Smoh+1GaSU78f6oL0/xp4It41WJSoxhmOWpcx73w5PGcr0A9c+tMQj/AL3KQbhJnhmIGP8A69NCSWtqJhCZ3ztbLcAn/wDVVlbZrr5jENh+624j86lAVYkB2iME5U/0oFcoXDtBGCQqkcgdcVVOm2dzJFc3sYb5sohb7x9cVqw3lu7BDBmAg5kBBHXkGjzbdbrzGkUQj7nyd/Y+lAFDxBYDUIF24hSE9ccn/wCtWJp/hhZ7tLxoCFUYG1hhvr61012jT7Gkbfalh5uD0Hr+FIbMTzNbQ3LeS6gN83AHsexosCdiv5BXZHtK842jjn1B9OtQXDRxpKSLg7efu7mP0rXazW2gAjY74xw69PeoY5opdwLnarZVnGN30oBMhgxAHknJRMcMcMxzzz6URJBeSLIJ2UDIXk/N/wDWpuZROrJOVIJ5JAyvpilmvU+zrO0caAEh2UEY9TQMsSgRyN5rqoLcFVwKYjEL5cr7lVspxnj06fWla4tbiBC5LDHBHIPvUVxqEaxeXDE8jgY2xkAigaQ5mdIjIkMUuMlRnBPtmqz3dwZYVaynMbL8xyBtPoc1PbuqjzJreWLoMsR83pnFUrm3kknWWSZijE4jTOPYdaQE/mAzb9p2JtKozHjnoc8flU6yi4JJZQw5GCOaqFHjwiKoZj8oJPA9eKkhtVdfnIMw7noaAJdyyQq2ApU9M5zimtGs6hmYuCSQrc805Ld2cM21Np54xuFPV4xy2S44wB1oYFC0jFrFPHNaw7QcoQxzz69hVTMchK4C7v8Aazj6CtVVWWQjcB0J3CiW2EQWREMgbI+WgZTg2xRtHHK7gLwxXn86mFyrqGt7fDH7zMf84oezilyAzZJxwcUv2NIogQScnFMCIz+ZOZAHeQnARHHH6dK0Wu4pt8LwCJ2UHeo+bOP1qP7HGoUhwzADORjP1q5HHBHOMRAMwzncMYoEZs1wrZH2cLJGc+ay/wAxTYpGaTczBZGIYqudpH0q68QbzZmZYmAyoAIBqoFd2HmRsFI4YdKQDJ2yW2RqST35qu6tsPzghx1BztFWZBECCQWA44HWke3ZVbYGOf4QvIHagCrbwMIgkZbceScjHB/SnRid7jdJPIVjGYkdc/lVpLeQRl41YAfxY6Go43lE2/b53GChYjP5UDI28m48lHD742DqznI/BefzrTnv4HtVigtV5+XO04zjoMVnsqyt55tkVlGAyjkUqSykQo7pFHk8suc+3XinYVxUhfyiXZvMU4MaLkrUUUyRuPnaRB1D/KW+uO1TGxMDPOI1aOX5WUMQcf59apxQkZ+fceiYH3frQMmEyXMhEzvDg4wR/L2q7FawT4U3KDB+U7eSPf8AzmorXSjM+4zKSy5G4E5x/LtWhHptqkoikDF3BYSDIxSBsZKJUBgjI5I245yPWqTxHLg7XAX7rZIU+uKn1K2a1ZQt6zHPOV4UVBJdWCwMZpEnfPygSY/GgRVlvJppI1aUqkZK4K84/OprXUrd1mtnzMuNq7kABP1HNPuIdyGWO4RxtOd2MhfrVOzuJpH+zQHfEOcBMjP1oC5YFrHc26/Z4xG6sVw7Yz/Xt3zUZh1KwljDxx+XnGQ3JHpnP+FTzyghRPbRpIuCC4wce1U72+aY+bbouUwTk/KQO2KANO2uLdp7kSeYqdNjjeD7g9qSPZPdnzVLqCNsbcHp2xya51r8u6SfZGh5+crkqBnFaUV7+/LCFHUj5FQbSp96ALtwl1bTfuo/JDnPK7ug69c5oDSxYe1csc72LRAHPpkGs3+09akujDZaUDCOjCUDI/E9au4vFIjxHAS2WDHg1QmTS6jeW1uU3+YGGSDgBfbpVaS7jZVcsGfI3cY/l1rQurRWg82U20rBc5UlWqgIFkj2CLEg985/Ck2BZ84XCGVZFdyOgQED6CqphleEIRIVzkgdKbajyreVpYijKMKDgcVFHqAjhzdPHHvPyKGyx+ooGiSXz5AphcgrwST0FNiubuK6MdusYXI3FifmHpVo6fcb1nJ8rA+U5HP+FVbzzFnETRYBBJkVgVOKVxEt00ZKxDyFOMqMncDXK6nYXtzODAQxAy+OOc10r2LwRLOxQAjgtzn2NV4YpWnMyspVTzxg0mrjRzeg6Lqlr4x0aV0dEF/BluxHmLmvpSvKtHmzrVnuQMxnjGTjA+YdBXqtdeHVkTIDXl/jKyiuvEN0Mssp2HjuNi/4V6ga868SNP8A8JLcmHJ2bMg9DlVp1/hEji5fDgvIT5UkigcZxgg/SpotBuUZSl2qADAbGc/UV0El4gBViEYfpVWLU4YnZzco3H3SOTXKx3uMWG/hQpci1kgk42qOKsQ6R5Mkk0OIJGALMv8AFiqlxfxzpmG7CP8A3N+K0INYMFoiytGXxzzz9aaDXoRWcIsLgBrMiNxuYj7uasXGqNFII4IlVMcyN0B9KX7RPNbgIEKueOxxRc22638jzCk2D8xXOPpQBR86e5WN53Gdu3ci55qE/wBrecq26wmNRuJZiP0NRR6dq9hJuVlmhJwSONuO9aBWWVgxk2OBgk9//r0hixX+opGjTWgdHbb5Y6inhJp3Z2xBD0ACA/gT6VHdQTZVXkZ1fozHG005LEFm8t9y46HOM/nQBca3uGIkBJI42k8Y+lJPFILQhgkjk/Oq9f8A61UQdVUnB8yEHA28ED2qtql1cw2qvLbMQ4wxVvyyKYrF6GLE+z7OpiHQK2cVNMuGHkLLxwzFuntiuWj8ZW9mq20lm0UYHVeT9ea6Oy1CPUbCF7dwyleuct+PvSAlt5EZXS8zExBA2OefqKbLFFEm63U8csSDnH1qDU4/Mj81C3mqOAP61csWeG3hWZCzSDO7HT2piKck0jjyoX2IBnPTcPem4lmERuNglXOCD05q9ch403CONYwCCG6+2KqlY7iDejDGcdKTKRB512txJE8sbRkfK7Rjd9atoitlJGLbugwKEtLqK1JeUTSE/KSmOO1IMqisJDlRyAMfypDZYe2jZkyypEoB+bt9Kf8A2ftQSW0cZiYZ3hgSaq3ot7izKXMzqr4Gfu/hTPOe0tDaRAMqqFBC9KEKzLMOw5bzCMjo3FVyDIgkXaQT0DYwPWktxcQxJvVfKx8uM5P1qt9ojjZpbox28hkIjCnlgOh5pgTSu6x8hR6knPH5VCtrLMI5WZwAeNoOatbo5RnCttwSD15p/wAgj3tuyeyDcBSGZ979oO2K3nGwH5mlO05+tMjmCELdgvk4LA5walNu1wC0y+WpORvIGRUi2yBW3qSG6kHrSGDwqF3Jh19VPamwXZRSCMrn1qJbZI1fCDaDweelNa2idowXdUB+YKetMCa3uIhKSGznjg9KuxytCS6jjvvGapRIkLBIz8mckkdqt+eElQqke3Pzbj94f40A2TSLJdK0x4C/MFGcGoE2+b/qm29Bj7w96ttq0CDb5LjtjFUluWLloV8sknvkjmmIttJE52OrttH3j/WqwniDv50EsgB4wMgg1G0kkk/yMyOfvnI/IZFIJXhnaIkux6ZHA96AFd0j+5GYweM7eh9KorprS3Es9xeThW+5sPStgkRwyNcW/l8fKxOd3GeTVa2vB5YwFAJydozikBgXjS26lbbU5iynJE4OAPx61f0u4uJCsr3CSnacFBjPOOverd1bW9wyjCs2eSTyaZeEQ28SJHswOVXBApDuLcIwlmkLPnbkheST64qWOGJIFLzeYHOdvT9eagit1mg+R2UEcsDjJq2JkiIGYSqD/lo2DVXYrGfJEYZZkVnXcCQu7oPX0pdNlk2SiUIxHQgdR2qR7aG7LSKpWU85Tp9Kv2dvbRLjyCzsCQzNgUBsVFd3Uh3JYdMcbaVNV2/u9pYKCSzPk1KkNu0BUN++z93OM1BIiE72ih/2jvG78PWkBi6xrFzExbypI2IwPkwNvp71yk9zmaUzzFZHIGAuRzzXUz3fh5L5vMjkYqcMC3JP51a1DQ7bY11pcLK8gGVIyFHc89aW4M4m31bymkTzSoHDZG4H8K2rHVRGJHgdz8pJYDC1s2XhbTgjPdHfKRkoy4Un86bPoo0+FhG4S0bhom52+4ppE2MiLU7lJcGVJMjBJkz+Vb3mLLCrQFQyjDHsapReH9OtrcjyCVYbkd8/e+o/lWja6DCcsWWOcfeVOARTsUmOt3CxyNMThj3PGB0qcxTPi7igAOPvOmVOfQVG1jE7PFK5KAZwOM1Ltit4EjAl+UcLnNADHZ/vFVXLZ2pkAVFc2UtziNDJgg9j19aqC6knuRClvJkElhkgVpWks8SFgqRuuVKyE/lmjQVzm7jRdVVRFHeMrd89f51pWUWp6eFWZyyr325zXURxNLCJm8rcR95H6/pUQuIieH8vnDEgce4OKEguZ9pLKYpJLqBnVm6ue309KrN5ER86KGJixyi9dtat5cQwqyW7s0p4Y4/WslEkmugjMqA/ekcUDuW4tYkUPHMEU4O1tvAqE2lpdRO7TzPJtJBHT9adc6Q1tKZLhvO3jgqcAmqs8FzAikr5aH2pWYDYlhClZjdSEHgZ+UVMgVw/kIEU4weSf51FZhkkZAADJgHPJNWpJWtywKhG9Ac5oAXSBNHrmnBlyDcx5IPT5hXsQryjSElk1LT5mTA+0x/eGCfmFer11YfYmQGvPfE+nGbXbqZHbJK7gP8AcWvQq8o8Ua9HbeN76xeUpny+nqY1/wAaqv8ACJEFpZWr3EkkxZyegc4pt1pCXkgCxJ5QHUDkfjVItqYmaMCO4Q8qcYYCrD3V/DAkTxCPB49SK5CrFb/hEYc5E0gyMfMe/rWlbaTDbwRsI3klXglmqzaiS4Tcr84zh+KVpJp8QAD5ujKcUWEUb+8NpKscscoRujKKjhYXDFlvLkHGeTnFWdQe6gxA1mrI3G8NkZ/pVpcPAqvCijHJXrn60xoVLqQoY2uScjAOwcGs+I3k1wVmlUITgFV61aHkwuc7g3qOar3Vy8Me5wxG7OQelIDSWzF3B5cc8ijocgVatI0tIvIkBV16ZP3hWbCXSZGt5/MSQZIAq9LIrY8w5YdMmncRfyFIGRyKa6ArgqGB9azYxcZzuVo8/eIwwpZHbdgMR+NAFS+8MWN3N5rQnJyeueao6fpaWVyxUpbyZ2rgfrjFdFGPujz2VQOlU9SsTOhCymORfmSQf19qAI5dNvS+5p/OjblgAAajAJAjeeNZEOeTggVnMuuyW7pHqkKEHG7bu/rUEekv5qvfzSTsTyxOOfbFJ6Dsbo86dWWMo46F2OQDUMUTR7ArBlJxtAqsqXdmjLbXgMZBBTZ39Qe9RW0epSIqSviL+9jafyouBsXReKDzRJvGOD/SqNtdNcMDG/CH51xUTyzxOVDE8Ac4xjPWq5dRdyN8u1hyR3oGkWLmNriRA8i+VnIA7H29Koajpt5cSQyW+o+XGDllU8n61fF1YS2oR3QyHordfyqaGNZFaNlVMH7o70kAkN+kvloGOU6sQam8iAP9pdY3Kr/EcmmTadKsWIpdmf4euahjt5HZkmZJAOu0Z5pgZVkdZn1qR5h5dmDxkgk10g3j/VDcf5Vj3t9axT+VDFIZG4IHA/lWjZ3y+Sqx/fHqvQ/1pAyT5mLJIiAjl8t0HtUZmEk6qigpjBB4z9KcD59xKjKhz1YDr/SkMTWpTDMynIwDimIRXkhd/wBwxQHg1KiJOdzLIR6KtOWJW3f6S0btjKE8VWu53KYLbEDc+WcFvwoAWCwfa08kaCM5H71iCPwqVnsBbj7RIj7Tx6CoIJYZEMnm3AVuisOB+dMOno0bSsu7b1U96QywZXluFKYkTGdpp8EEAdhIDGTy2P6VVjJERAiVT/d3c1cQxqvyl1J7ZwKAID5bTu7KxRTkyP2+hqFrq3ScsoXB6ll61Zbaf4N69xyQahvwJYjstgmfQUwKT3kj6uskJdYFXAAXIc+/pVy5neNoZJbOQF+CV+6frimCDywivIGZRn5eMZp3lTlflRmVTnJGQPpSAbHOIZyFljjjfhi4BFOD297JhSgRPvED74prB22s6K4U524yD9aqXV9LNKYzalRjCrGMYNPYDUbVdPggKrasiocdAMCqcV4t2nmwswiTn51z+FUZYtRnwhVAp7sw6fQVfheJYikmWCj5fLUD/wDXQDJA7yKGWIlO+OB+VW1vBFBsi2ZHTC1BDK6k+XchFJ6t2p0aqHZpJMsx52L96gVzPvEkvICixpHIAcHoBmuftdH1GW/Z7q7iIj4VMdR9K6hpRubapXnHDCpgm2Hz7eMPkdd3SkVcxoNAsIpmuWtYppMchl4B9a0oLl7ZEVCRETgAJuI/CtaCOI2yn91kDBHXmqOpSBWCxW6s6HI25wfY0CAeSVJlhcb+BgnH1pjQW/2UtHNI0nrkMM1CdUlnjMTWwLYyQWAQD69/ypYdNuCit9qG5wWIB+VR7Yp6iZIIY/JIuLhFLfdCDODWegkspXkedW3HA7Fh6cVo+RbSSeTIZN5OcKuQT69ab/ZM6gly4wep4FA0iGD/AEvLSzmJPTuPfmpvtNhb3ZBnLyKo25PT3qtLatJu+0ZdR02t0NRpYx7QE2ordMGgZpWRS8nlbChWP3uNx96VrJAJGEAnCggZxmmW2nC4mMcQYEdXZsVZn00Rx7ZJXJHAwf0oJbKMK3bKFdkgt/4EQ80+3mWx37djL1PFOS1WJCskjF8Y2nt+NOcx20B3FWGOoSgEVbvUItzTZWNgOAoPNRR3X2s5UuxPVmHFRuYpVAKqAfmJxwKmVSsYETAoOoI6mmgHkmQBemzrvep47k6gGt5h+7ToRz+tZ11aC7YFmYHuEOAadDF5KHaw2dDSGRyMYcuRnafvA9KrkM26USuS/XjmrYjDk+bFlT2bvUFzamRCULRhTnCAk0h6EuiSSjxDpyidpV+1x7iw/wBod69qFeM+H9Oj/t3T55JpNwuIyqngZ3CvZhXVh9mRKwV82/FKO4HxL1RlVgreThux/dJ/9evpKuR1zwFaa7qs99PckGXb8vl524UDg59qurFyjZEnk+gT6vbQJuLSQjo3dfpXUpPJd23zyjA5wy10MPw3a1Ro7fV9sR/ga33D/wBCph+GeANmsyIe+IOv/j1YexkO5ys088DZJG0dB3xViB3j/f72yBlVAyDXWN4AZo1U6rnAxk2+f/ZqntfBclshT+0wynt9n/8AsqfspBc46K7nmSQMoRH/AL7VXOpPaxOhQuOmRXYX/wAPRdj91qfkH1Fvn/2aoLX4byxbvtOtCfPTFrtx/wCPmj2Uh3OHF7Ju3W025j96PJyPY5resrqGePbllnAyY3XP4iujHw9i8pkN/wAsMbhDg5/76otvAH2YLs1PLAfeMHP/AKFS9lIfMjn5BJOBtPlBTywPBFKtrdSSCRAHjAwCD1roD4CbJP8AazDJz/qf/sqnj8FGOIRjUmx7RY/9mpexkF0YR82aExviJhxnPWmG3uC2RcR49NtdIvg4iPab8Ejoxh/+yqNPBRjGE1Igf9cf/sqfspCujlwZY9TSGWYmIjPHep9SjiNm/k3LIMY9c+1dBJ4JaWZZDqXQcfuf/sqk/wCELTYyteZLd/K7/nR7OXYLo8uksbqNg8cjqD/c70tvdH7aq+dKijoHORn6dq9GPgJ9x/4mpweg+zjj/wAepi/DyMMXN+rSHqzW+f8A2ak6Mh3MJrxI0DOpMYOC3p+FZmraksFqZYLhpueRnHFdVN8OJJZvMGslR2UW3T/x+px8P/3LIdRjJYYJ+y//AGdHsZBdHn8mtRtZxyQBl2YycZ496fZalYalNtyVlXuOhrun+He+Dyf7SjC9DttcZ/8AHqlsfh1Y6ed0M6hz1byv/r0exkHN2OSbw0kswuokKgAkBWwSafbWN0pLSNGzjpu6iu4PhSZWBi1Mpg8/uc5/8eqveeB1vDubUXR/VY8f1p+xkLmuc6vnSRHdgkDAIOcVVtZBbxsQg8sHn5icmulPw+VnBOqyhMfMiR7Q31G6pR4DhQKI74qB28vOf/HqPZSHdHMAW93JtaLaCcqxHOaHg+zuAoBLLjPpXYJ4OjUYa6VvT9z0/wDHqYfBzE5GokH/AK4//ZUeyl2Fc5NVgVgJJCqg5OO9XUjD4YSKF6qc5raHgg7yx1EHIxzB/wDZVKvgwLjF/wD+Qf8A7Kl7KQaHOGG0lc+axLpzuzj8qhgmKz4kGxMfKxxiunPgoFmP2/BPpD/9lSx+DPLUL/aBZR2MX/2VP2MhXOauLaX5nCowPVD0IqvLMR5aACIY+7ya7N/CsrIUGoKo/wCuHT/x6mN4QLJtN8v18j/7Kj2MguchbjzJtn8Z7VM1vKMEdM11p8KKUA+1IGAxuEP/ANeoz4Sl7akAP+uH/wBlR7GRXMcw016vyRIMdmbt+FPaKWRB5pJI59K6Z/CZaDYL/bJ2kEPI/WkHhOVempn8Yf8A7Kj2MhXOWliU/PMQp6E+tIqRwKJDI+1jxhsV1Eng8ygCS+U4/wCmH/2VSDwngY+2Jj2g/wDsqPYyC5ycl3ACVEZdj3znNOWPzOXiAA/vGunk8GxvgJdKgBz/AKnJ/wDQqsDw0f8An9H/AH6/+vR7KQrnGNYK+WkZGH8O0GprfSkEfmEbjj6V0p8IyGZ3OpAhhwPJxj/x6pYPDEsHH9oll7Boun/j1HspBdnITRRxsyswwvYDmhRNDGZVCso7V1Evg3zpmka/69vJ6f8Aj1IfBrlSo1EjPpD/APZUeykCZw01lps12011GfOY53xSEfpVpbm3im2rG7xAYGc11Q8CIDuN9lvXyf8A7KpF8F7FGL5SQepgz/7NS9jIbZxupaksEBRIjCG7Dv7VHbTF1VyBk88V3b+EBNHtmu1Zv7wgxj9aiXwTEhyl5j2MWf60exkNSObb7Its2YwrEZXLAGs/fGr7WYxo2MYO7Arr7nwKLkYOo7fpB/8AZVFb/D8QMGOpB2HRjb8/+hU/ZS7BdGJbyWMLB43keQD+6RTLq/tzztd8/wANdVH4MSMs32z52PLeV/8AXqKbwMJHyuolQeoMOc/+PUeykF0clDeTNHIbeBCo6c9BSww3NwokCozf3m6V2o8IhIxEl2ix4xt8j/7KoB4KKMTDqAjU/wAKw9P/AB6l7KfYfMjkbmW+sF3R4Unncx4H4is938Q3jiR7qFbZWyQAQWH413E/ga4mQoNbcITkgwZP57qli8FSRja2qb19DB/9lR7KfYV4nIR7jF8zbXJyM4/lUTSZfEsm7b0xXXr4BUSb21AHjgCDH/s1KPAYD7v7Q/8AIH/2VHsZ9gujk0t4pur7f50wWKtL8k5B9zjNdh/wgzKTt1IDPYwZ/wDZqsR+DgiAfbAT3Pk//ZUeymK5xzKgURyRvwMZU9agVYhKF2sueF3Gu3k8HFhhL4J6/uP/ALKoLrwM13tLaoVZehEH/wBlR7KY7o5U6fM5VkY8HNRymeEmOZyAx6ADmutbwVeeSI01vZg9Ra//AGVLH4GdZPMfVPMb1aD/AOyp+xkF0cjpkKf8JHp5TcFFxHjP+8K9frk7bwWbe/gujqAbypVk2iDGcHOPvV1lb0oOO5LYUUUVqIKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooA//2Q==")||c(Ha,"src",El)},m(A,a){no(document.head,w),U(A,za,a),U(A,ka,a),U(A,Ca,a),i(u,A,a),U(A,Wa,a),i(b,A,a),U(A,Na,a),U(A,T,a),U(A,Ia,a),U(A,f,a),U(A,qa,a),U(A,B,a),U(A,Xa,a),U(A,P,a),U(A,Qa,a),U(A,x,a),U(A,ha,a),i(V,A,a),U(A,Oa,a),U(A,d,a),U(A,Da,a),i(g,A,a),U(A,Za,a),i(G,A,a),U(A,va,a),U(A,y,a),U(A,Ya,a),U(A,H,a),U(A,La,a),i(k,A,a),U(A,Ea,a),U(A,S,a),U(A,_a,a),U(A,z,a),U(A,$a,a),U(A,C,a),U(A,At,a),i(W,A,a),U(A,at,a),i(N,A,a),U(A,tt,a),U(A,I,a),U(A,Ut,a),i(q,A,a),U(A,lt,a),i(X,A,a),U(A,ot,a),U(A,Q,a),U(A,st,a),i(h,A,a),U(A,nt,a),U(A,O,a),U(A,it,a),U(A,D,a),U(A,et,a),U(A,Z,a),U(A,pt,a),i(v,A,a),U(A,Kt,a),i(Y,A,a),U(A,jt,a),U(A,L,a),U(A,Ft,a),i(E,A,a),U(A,Mt,a),U(A,_,a),U(A,rt,a),i($,A,a),U(A,Rt,a),i(AA,A,a),U(A,ct,a),U(A,aA,a),U(A,wt,a),i(tA,A,a),U(A,yt,a),U(A,UA,a),U(A,Jt,a),i(lA,A,a),U(A,mt,a),U(A,oA,a),U(A,ut,a),i(sA,A,a),U(A,bt,a),U(A,nA,a),U(A,Tt,a),i(iA,A,a),U(A,ft,a),U(A,eA,a),U(A,Bt,a),i(pA,A,a),U(A,Pt,a),U(A,KA,a),U(A,xt,a),i(jA,A,a),U(A,Vt,a),U(A,FA,a),U(A,dt,a),i(MA,A,a),U(A,gt,a),U(A,rA,a),U(A,Gt,a),i(RA,A,a),U(A,Ht,a),i(cA,A,a),U(A,kt,a),U(A,da,a),U(A,St,a),U(A,wA,a),U(A,zt,a),i(yA,A,a),U(A,Ct,a),U(A,JA,a),U(A,Wt,a),U(A,mA,a),U(A,Nt,a),U(A,J,a),U(A,It,a),i(uA,A,a),U(A,qt,a),i(bA,A,a),U(A,Xt,a),U(A,TA,a),U(A,Qt,a),i(fA,A,a),U(A,ht,a),i(BA,A,a),U(A,Ot,a),U(A,PA,a),U(A,Dt,a),i(xA,A,a),U(A,Zt,a),i(VA,A,a),U(A,vt,a),U(A,dA,a),U(A,Yt,a),i(gA,A,a),U(A,Lt,a),U(A,ga,a),U(A,Et,a),i(GA,A,a),U(A,_t,a),U(A,HA,a),U(A,$t,a),i(kA,A,a),U(A,AU,a),i(SA,A,a),U(A,aU,a),i(zA,A,a),U(A,tU,a),U(A,CA,a),U(A,UU,a),i(WA,A,a),U(A,lU,a),i(NA,A,a),U(A,oU,a),U(A,IA,a),U(A,sU,a),i(qA,A,a),U(A,nU,a),i(XA,A,a),U(A,iU,a),i(QA,A,a),U(A,eU,a),i(hA,A,a),U(A,pU,a),U(A,OA,a),U(A,KU,a),U(A,DA,a),U(A,jU,a),i(ZA,A,a),U(A,FU,a),i(vA,A,a),U(A,MU,a),i(YA,A,a),U(A,rU,a),i(LA,A,a),U(A,RU,a),i(EA,A,a),U(A,cU,a),i(_A,A,a),U(A,wU,a),U(A,$A,a),U(A,yU,a),i(Aa,A,a),U(A,JU,a),i(aa,A,a),U(A,mU,a),U(A,ta,a),U(A,uU,a),i(Ua,A,a),U(A,bU,a),i(la,A,a),U(A,TU,a),U(A,Ga,a),U(A,fU,a),i(oa,A,a),U(A,BU,a),U(A,sa,a),U(A,PU,a),i(na,A,a),U(A,xU,a),i(ia,A,a),U(A,VU,a),U(A,m,a),U(A,dU,a),U(A,ea,a),U(A,gU,a),U(A,pa,a),U(A,GU,a),i(Ka,A,a),U(A,HU,a),i(ja,A,a),U(A,kU,a),U(A,Fa,a),U(A,SU,a),i(Ma,A,a),U(A,zU,a),i(ra,A,a),U(A,CU,a),U(A,Ra,a),U(A,WU,a),i(ca,A,a),U(A,NU,a),i(wa,A,a),U(A,IU,a),U(A,ya,a),U(A,qU,a),U(A,Ja,a),U(A,XU,a),i(ma,A,a),U(A,QU,a),i(ua,A,a),U(A,hU,a),i(ba,A,a),U(A,OU,a),i(Ta,A,a),U(A,DU,a),U(A,Ha,a),U(A,ZU,a),i(fa,A,a),U(A,vU,a),U(A,Ba,a),U(A,YU,a),U(A,Pa,a),U(A,LU,a),i(xa,A,a),U(A,EU,a),U(A,Sa,a),_U=!0},p:to,i(A){_U||(e(u.$$.fragment,A),e(b.$$.fragment,A),e(V.$$.fragment,A),e(g.$$.fragment,A),e(G.$$.fragment,A),e(k.$$.fragment,A),e(W.$$.fragment,A),e(N.$$.fragment,A),e(q.$$.fragment,A),e(X.$$.fragment,A),e(h.$$.fragment,A),e(v.$$.fragment,A),e(Y.$$.fragment,A),e(E.$$.fragment,A),e($.$$.fragment,A),e(AA.$$.fragment,A),e(tA.$$.fragment,A),e(lA.$$.fragment,A),e(sA.$$.fragment,A),e(iA.$$.fragment,A),e(pA.$$.fragment,A),e(jA.$$.fragment,A),e(MA.$$.fragment,A),e(RA.$$.fragment,A),e(cA.$$.fragment,A),e(yA.$$.fragment,A),e(uA.$$.fragment,A),e(bA.$$.fragment,A),e(fA.$$.fragment,A),e(BA.$$.fragment,A),e(xA.$$.fragment,A),e(VA.$$.fragment,A),e(gA.$$.fragment,A),e(GA.$$.fragment,A),e(kA.$$.fragment,A),e(SA.$$.fragment,A),e(zA.$$.fragment,A),e(WA.$$.fragment,A),e(NA.$$.fragment,A),e(qA.$$.fragment,A),e(XA.$$.fragment,A),e(QA.$$.fragment,A),e(hA.$$.fragment,A),e(ZA.$$.fragment,A),e(vA.$$.fragment,A),e(YA.$$.fragment,A),e(LA.$$.fragment,A),e(EA.$$.fragment,A),e(_A.$$.fragment,A),e(Aa.$$.fragment,A),e(aa.$$.fragment,A),e(Ua.$$.fragment,A),e(la.$$.fragment,A),e(oa.$$.fragment,A),e(na.$$.fragment,A),e(ia.$$.fragment,A),e(Ka.$$.fragment,A),e(ja.$$.fragment,A),e(Ma.$$.fragment,A),e(ra.$$.fragment,A),e(ca.$$.fragment,A),e(wa.$$.fragment,A),e(ma.$$.fragment,A),e(ua.$$.fragment,A),e(ba.$$.fragment,A),e(Ta.$$.fragment,A),e(fa.$$.fragment,A),e(xa.$$.fragment,A),_U=!0)},o(A){p(u.$$.fragment,A),p(b.$$.fragment,A),p(V.$$.fragment,A),p(g.$$.fragment,A),p(G.$$.fragment,A),p(k.$$.fragment,A),p(W.$$.fragment,A),p(N.$$.fragment,A),p(q.$$.fragment,A),p(X.$$.fragment,A),p(h.$$.fragment,A),p(v.$$.fragment,A),p(Y.$$.fragment,A),p(E.$$.fragment,A),p($.$$.fragment,A),p(AA.$$.fragment,A),p(tA.$$.fragment,A),p(lA.$$.fragment,A),p(sA.$$.fragment,A),p(iA.$$.fragment,A),p(pA.$$.fragment,A),p(jA.$$.fragment,A),p(MA.$$.fragment,A),p(RA.$$.fragment,A),p(cA.$$.fragment,A),p(yA.$$.fragment,A),p(uA.$$.fragment,A),p(bA.$$.fragment,A),p(fA.$$.fragment,A),p(BA.$$.fragment,A),p(xA.$$.fragment,A),p(VA.$$.fragment,A),p(gA.$$.fragment,A),p(GA.$$.fragment,A),p(kA.$$.fragment,A),p(SA.$$.fragment,A),p(zA.$$.fragment,A),p(WA.$$.fragment,A),p(NA.$$.fragment,A),p(qA.$$.fragment,A),p(XA.$$.fragment,A),p(QA.$$.fragment,A),p(hA.$$.fragment,A),p(ZA.$$.fragment,A),p(vA.$$.fragment,A),p(YA.$$.fragment,A),p(LA.$$.fragment,A),p(EA.$$.fragment,A),p(_A.$$.fragment,A),p(Aa.$$.fragment,A),p(aa.$$.fragment,A),p(Ua.$$.fragment,A),p(la.$$.fragment,A),p(oa.$$.fragment,A),p(na.$$.fragment,A),p(ia.$$.fragment,A),p(Ka.$$.fragment,A),p(ja.$$.fragment,A),p(Ma.$$.fragment,A),p(ra.$$.fragment,A),p(ca.$$.fragment,A),p(wa.$$.fragment,A),p(ma.$$.fragment,A),p(ua.$$.fragment,A),p(ba.$$.fragment,A),p(Ta.$$.fragment,A),p(fa.$$.fragment,A),p(xa.$$.fragment,A),_U=!1},d(A){A&&(t(za),t(ka),t(Ca),t(Wa),t(Na),t(T),t(Ia),t(f),t(qa),t(B),t(Xa),t(P),t(Qa),t(x),t(ha),t(Oa),t(d),t(Da),t(Za),t(va),t(y),t(Ya),t(H),t(La),t(Ea),t(S),t(_a),t(z),t($a),t(C),t(At),t(at),t(tt),t(I),t(Ut),t(lt),t(ot),t(Q),t(st),t(nt),t(O),t(it),t(D),t(et),t(Z),t(pt),t(Kt),t(jt),t(L),t(Ft),t(Mt),t(_),t(rt),t(Rt),t(ct),t(aA),t(wt),t(yt),t(UA),t(Jt),t(mt),t(oA),t(ut),t(bt),t(nA),t(Tt),t(ft),t(eA),t(Bt),t(Pt),t(KA),t(xt),t(Vt),t(FA),t(dt),t(gt),t(rA),t(Gt),t(Ht),t(kt),t(da),t(St),t(wA),t(zt),t(Ct),t(JA),t(Wt),t(mA),t(Nt),t(J),t(It),t(qt),t(Xt),t(TA),t(Qt),t(ht),t(Ot),t(PA),t(Dt),t(Zt),t(vt),t(dA),t(Yt),t(Lt),t(ga),t(Et),t(_t),t(HA),t($t),t(AU),t(aU),t(tU),t(CA),t(UU),t(lU),t(oU),t(IA),t(sU),t(nU),t(iU),t(eU),t(pU),t(OA),t(KU),t(DA),t(jU),t(FU),t(MU),t(rU),t(RU),t(cU),t(wU),t($A),t(yU),t(JU),t(mU),t(ta),t(uU),t(bU),t(TU),t(Ga),t(fU),t(BU),t(sa),t(PU),t(xU),t(VU),t(m),t(dU),t(ea),t(gU),t(pa),t(GU),t(HU),t(kU),t(Fa),t(SU),t(zU),t(CU),t(Ra),t(WU),t(NU),t(IU),t(ya),t(qU),t(Ja),t(XU),t(QU),t(hU),t(OU),t(DU),t(Ha),t(ZU),t(vU),t(Ba),t(YU),t(Pa),t(LU),t(EU),t(Sa)),t(w),K(u,A),K(b,A),K(V,A),K(g,A),K(G,A),K(k,A),K(W,A),K(N,A),K(q,A),K(X,A),K(h,A),K(v,A),K(Y,A),K(E,A),K($,A),K(AA,A),K(tA,A),K(lA,A),K(sA,A),K(iA,A),K(pA,A),K(jA,A),K(MA,A),K(RA,A),K(cA,A),K(yA,A),K(uA,A),K(bA,A),K(fA,A),K(BA,A),K(xA,A),K(VA,A),K(gA,A),K(GA,A),K(kA,A),K(SA,A),K(zA,A),K(WA,A),K(NA,A),K(qA,A),K(XA,A),K(QA,A),K(hA,A),K(ZA,A),K(vA,A),K(YA,A),K(LA,A),K(EA,A),K(_A,A),K(Aa,A),K(aa,A),K(Ua,A),K(la,A),K(oa,A),K(na,A),K(ia,A),K(Ka,A),K(ja,A),K(Ma,A),K(ra,A),K(ca,A),K(wa,A),K(ma,A),K(ua,A),K(ba,A),K(Ta,A),K(fa,A),K(xa,A)}}}const Ko='{"title":"Fine-Tuning Object Detection on a Custom Dataset 🖼, Deployment in Spaces, and Gradio API Integration","local":"fine-tuning-object-detection-on-a-custom-dataset--deployment-in-spaces-and-gradio-api-integration","sections":[{"title":"1. Install Dependencies","local":"1-install-dependencies","sections":[],"depth":2},{"title":"2. Load Dataset 📁","local":"2-load-dataset-","sections":[],"depth":2},{"title":"3. Get Splits of the Dataset for Training and Testing ➗","local":"3-get-splits-of-the-dataset-for-training-and-testing-","sections":[],"depth":2},{"title":"4. Visualize One Example from the Dataset with Its Objects 👀","local":"4-visualize-one-example-from-the-dataset-with-its-objects-","sections":[{"title":"Generate id2label and label2id","local":"generate-id2label-and-label2id","sections":[],"depth":3},{"title":"Let’s Draw One Image! 🎨","local":"lets-draw-one-image-","sections":[],"depth":3},{"title":"Let’s Visualize Some More Images 📸","local":"lets-visualize-some-more-images-","sections":[],"depth":3}],"depth":2},{"title":"5. Filter Invalid Bboxes ❌","local":"5-filter-invalid-bboxes-","sections":[],"depth":2},{"title":"6. Visualize Class Occurrences 👀","local":"6-visualize-class-occurrences-","sections":[],"depth":2},{"title":"7. Add Data Augmentation to the Dataset","local":"7-add-data-augmentation-to-the-dataset","sections":[],"depth":2},{"title":"8. Initialize Image Processor from Model Checkpoint 🎆","local":"8-initialize-image-processor-from-model-checkpoint-","sections":[{"title":"Adding Methods to Process the Dataset","local":"adding-methods-to-process-the-dataset","sections":[],"depth":3}],"depth":2},{"title":"9. Plot Augmented Examples 🎆","local":"9-plot-augmented-examples-","sections":[],"depth":2},{"title":"10. Initialize Model from Checkpoint","local":"10-initialize-model-from-checkpoint","sections":[],"depth":2},{"title":"10. Connect to HF Hub to Upload Fine-Tuned Model 🔌","local":"10-connect-to-hf-hub-to-upload-fine-tuned-model-","sections":[],"depth":2},{"title":"11. Set Training Arguments, Connect to W&B, and Train!","local":"11-set-training-arguments-connect-to-wb-and-train","sections":[{"title":"Connect to W&B to Track Training","local":"connect-to-wb-to-track-training","sections":[],"depth":3},{"title":"Let’s Train the Model! 🚀","local":"lets-train-the-model-","sections":[],"depth":3}],"depth":2},{"title":"12. Test How the Model Behaves on a Test Image 📝","local":"12-test-how-the-model-behaves-on-a-test-image-","sections":[{"title":"Now, Let’s Show the Results","local":"now-lets-show-the-results","sections":[],"depth":3}],"depth":2},{"title":"13. Evaluation of the Model on the Test Set 📝","local":"13-evaluation-of-the-model-on-the-test-set-","sections":[],"depth":2},{"title":"14. Deploy the Model in a HF Space","local":"14-deploy-the-model-in-a-hf-space","sections":[{"title":"Create the Application with the Following Code","local":"create-the-application-with-the-following-code","sections":[],"depth":3},{"title":"Remember to Set Up requirements.txt","local":"remember-to-set-up-requirementstxt","sections":[],"depth":3}],"depth":2},{"title":"15. Access the Space as an API 🧑‍💻️","local":"15-access-the-space-as-an-api-","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function jo($U){return Uo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class co extends lo{constructor(w){super(),oo(this,w,jo,po,ao,{})}}export{co as component};
