import{s as Qt,o as Ot,n as St}from"../chunks/scheduler.25b97de1.js";import{S as Kt,i as eo,g as a,s as r,r as p,A as to,h as i,f as s,c as n,j as x,u as f,x as d,k,y as t,a as l,v as u,d as g,t as h,w as _}from"../chunks/index.d9030fc9.js";import{T as oo}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.ffac8efa.js";import{C as Xt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ro}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as le,E as no}from"../chunks/EditOnGithub.91d95064.js";function so(de){let c,J="Example:",w,P,C;return P=new Xt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuY29scGFsaSUyMGltcG9ydCUyMENvbFBhbGlDb25maWclMkMlMjBDb2xQYWxpRm9yUmV0cmlldmFsJTBBJTBBY29uZmlnJTIwJTNEJTIwQ29sUGFsaUNvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBDb2xQYWxpRm9yUmV0cmlldmFsKGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers.models.colpali <span class="hljs-keyword">import</span> ColPaliConfig, ColPaliForRetrieval

config = ColPaliConfig()
model = ColPaliForRetrieval(config)`,wrap:!1}}),{c(){c=a("p"),c.textContent=J,w=r(),p(P.$$.fragment)},l(b){c=i(b,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=J),w=n(b),f(P.$$.fragment,b)},m(b,$){l(b,c,$),l(b,w,$),u(P,b,$),C=!0},p:St,i(b){C||(g(P.$$.fragment,b),C=!0)},o(b){h(P.$$.fragment,b),C=!1},d(b){b&&(s(c),s(w)),_(P,b)}}}function ao(de){let c,J=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=a("p"),c.innerHTML=J},l(w){c=i(w,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=J)},m(w,P){l(w,c,P)},p:St,d(w){w&&s(c)}}}function io(de){let c,J,w,P,C,b,$,Le,G,Ct='The <em>ColPali</em> model was proposed in <a href="https://doi.org/10.48550/arXiv.2407.01449" rel="nofollow">ColPali: Efficient Document Retrieval with Vision Language Models</a> by <strong>Manuel Faysse*</strong>, <strong>Hugues Sibille*</strong>, <strong>Tony Wu*</strong>, Bilel Omrani, Gautier Viaud, Céline Hudelot, Pierre Colombo (* denotes equal contribution). Work lead by ILLUIN Technology.',ze,Z,$t="In our proposed <em>ColPali</em> approach, we leverage VLMs to construct efficient multi-vector embeddings directly from document images (“screenshots”) for document retrieval. We train the model to maximize the similarity between these document embeddings and the corresponding query embeddings, using the late interaction method introduced in ColBERT.",Re,q,xt="Using <em>ColPali</em> removes the need for potentially complex and brittle layout recognition and OCR pipelines with a single model that can take into account both the textual and visual content (layout, charts, etc.) of a document.",We,H,Ue,N,kt='<li>The <em>ColPali</em> arXiv paper can be found <a href="https://doi.org/10.48550/arXiv.2407.01449" rel="nofollow">here</a>. 📄</li> <li>The official blog post detailing ColPali can be found <a href="https://huggingface.co/blog/manu/colpali" rel="nofollow">here</a>. 📝</li> <li>The original model implementation code for the ColPali model and for the <code>colpali-engine</code> package can be found <a href="https://github.com/illuin-tech/colpali" rel="nofollow">here</a>. 🌎</li> <li>Cookbooks for learning to use the transformers-native version of <em>ColPali</em>, fine-tuning, and similarity maps generation can be found <a href="https://github.com/tonywu71/colpali-cookbooks" rel="nofollow">here</a>. 📚</li>',Be,V,Jt='This model was contributed by <a href="https://huggingface.co/tonywu71" rel="nofollow">@tonywu71</a> and <a href="https://huggingface.co/yonigozlan" rel="nofollow">@yonigozlan</a>.',Ee,A,Ge,Y,It="This example demonstrates how to use <em>ColPali</em> to embed both queries and images, calculate their similarity scores, and identify the most relevant matches. For a specific query, you can retrieve the top-k most similar images by selecting the ones with the highest similarity scores.",Ze,D,qe,S,He,v,X,Ke,ce,jt=`Configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/model_doc/colpali#transformers.ColPaliForRetrieval">ColPaliForRetrieval</a>. It is used to instantiate an instance
of <code>ColPaliForRetrieval</code> according to the specified arguments, defining the model architecture following the methodology
from the “ColPali: Efficient Document Retrieval with Vision Language Models” paper.`,et,me,Ft=`Creating a configuration with the default settings will result in a configuration where the VLM backbone is set to the
default PaliGemma configuration, i.e the one from <a href="https://huggingface.co/vidore/colpali-v1.2" rel="nofollow">vidore/colpali-v1.2</a>.`,tt,pe,Lt="The ColPali config is very similar to <code>PaligemmaConfig</code>, but with an extra attribute defining the embedding dimension.",ot,fe,zt=`Note that contrarily to what the class name suggests (actually the name refers to the ColPali <strong>methodology</strong>), you can
use a different VLM backbone model than PaliGemma by passing the corresponding VLM configuration to the class constructor.`,rt,ue,Rt=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,nt,R,Ne,Q,Ve,m,O,st,ge,Wt=`Constructs a ColPali processor which wraps a PaliGemmaProcessor and special methods to process images and queries, as
well as to compute the late-interaction retrieval score.`,at,he,Ut=`<a href="/docs/transformers/pr_30530/en/model_doc/colpali#transformers.ColPaliProcessor">ColPaliProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30530/en/model_doc/paligemma#transformers.PaliGemmaProcessor">PaliGemmaProcessor</a>. See the <code>__call__()</code>
for more information.`,it,W,K,lt,_e,Bt=`This method forwards all its arguments to GemmaTokenizerFast’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,dt,U,ee,ct,be,Et=`This method forwards all its arguments to GemmaTokenizerFast’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,mt,I,te,pt,ve,Gt=`Prepare for the model one or several image(s). This method is a wrapper around the <code>__call__</code> method of the ColPaliProcessor’s
<code>ColPaliProcessor.__call__()</code>.`,ft,Te,Zt='This method forwards the <code>images</code> and <code>kwargs</code> arguments to SiglipImageProcessor’s <a href="/docs/transformers/pr_30530/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__"><strong>call</strong>()</a>.',ut,j,oe,gt,ye,qt=`Prepare for the model one or several texts. This method is a wrapper around the <code>__call__</code> method of the ColPaliProcessor’s
<code>ColPaliProcessor.__call__()</code>.`,ht,we,Ht='This method forwards the <code>text</code> and <code>kwargs</code> arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a>.',_t,F,re,bt,Pe,Nt=`Compute the late-interaction/MaxSim score (ColBERT-like) for the given multi-vector
query embeddings (<code>qs</code>) and passage embeddings (<code>ps</code>). For ColPali, a passage is the
image of a document page.`,vt,Me,Vt=`Because the embedding tensors are multi-vector and can thus have different shapes, they
should be fed as:
(1) a list of tensors, where the i-th tensor is of shape (sequence_length_i, embedding_dim)
(2) a single tensor of shape (n_passages, max_sequence_length, embedding_dim) -> usually
obtained by padding the list of tensors.`,Ae,ne,Ye,M,se,Tt,Ce,At=`In our proposed ColPali approach, we leverage VLMs to construct efficient multi-vector embeddings directly
from document images (“screenshots”) for document retrieval. We train the model to maximize the similarity
between these document embeddings and the corresponding query embeddings, using the late interaction method
introduced in ColBERT.`,yt,$e,Yt=`Using ColPali removes the need for potentially complex and brittle layout recognition and OCR pipelines with a
single model that can take into account both the textual and visual content (layout, charts, etc.) of a document.`,wt,L,ae,Pt,xe,Dt='The <a href="/docs/transformers/pr_30530/en/model_doc/colpali#transformers.ColPaliForRetrieval">ColPaliForRetrieval</a> forward method, overrides the <code>__call__</code> special method.',Mt,B,De,ie,Se,Fe,Xe;return C=new le({props:{title:"ColPali",local:"colpali",headingTag:"h1"}}),$=new le({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new le({props:{title:"Resources",local:"resources",headingTag:"h2"}}),A=new le({props:{title:"Usage",local:"usage",headingTag:"h2"}}),D=new Xt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ29sUGFsaUZvclJldHJpZXZhbCUyQyUyMENvbFBhbGlQcm9jZXNzb3IlMEElMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIydmlkb3JlJTJGY29scGFsaS12MS4yLWhmJTIyJTBBJTBBbW9kZWwlMjAlM0QlMjBDb2xQYWxpRm9yUmV0cmlldmFsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTNBMCUyMiUyQyUyMCUyMCUyMyUyMG9yJTIwJTIybXBzJTIyJTIwaWYlMjBvbiUyMEFwcGxlJTIwU2lsaWNvbiUwQSkuZXZhbCgpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ29sUGFsaVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEElMEElMjMlMjBZb3VyJTIwaW5wdXRzJTIwKHJlcGxhY2UlMjBkdW1teSUyMGltYWdlcyUyMHdpdGglMjBzY3JlZW5zaG90cyUyMG9mJTIweW91ciUyMGRvY3VtZW50cyklMEFpbWFnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBJbWFnZS5uZXcoJTIyUkdCJTIyJTJDJTIwKDMyJTJDJTIwMzIpJTJDJTIwY29sb3IlM0QlMjJ3aGl0ZSUyMiklMkMlMEElMjAlMjAlMjAlMjBJbWFnZS5uZXcoJTIyUkdCJTIyJTJDJTIwKDE2JTJDJTIwMTYpJTJDJTIwY29sb3IlM0QlMjJibGFjayUyMiklMkMlMEElNUQlMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwb3JnYW5pemF0aW9uYWwlMjBzdHJ1Y3R1cmUlMjBmb3IlMjBvdXIlMjBSJTI2RCUyMGRlcGFydG1lbnQlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDYW4lMjB5b3UlMjBwcm92aWRlJTIwYSUyMGJyZWFrZG93biUyMG9mJTIwbGFzdCUyMHllYXIlRTIlODAlOTlzJTIwZmluYW5jaWFsJTIwcGVyZm9ybWFuY2UlM0YlMjIlMkMlMEElNUQlMEElMEElMjMlMjBQcm9jZXNzJTIwdGhlJTIwaW5wdXRzJTBBYmF0Y2hfaW1hZ2VzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlcykudG8obW9kZWwuZGV2aWNlKSUwQWJhdGNoX3F1ZXJpZXMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHF1ZXJpZXMpLnRvKG1vZGVsLmRldmljZSklMEElMEElMjMlMjBGb3J3YXJkJTIwcGFzcyUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZGRpbmdzJTIwJTNEJTIwbW9kZWwoKipiYXRjaF9pbWFnZXMpLmVtYmVkZGluZ3MlMEElMjAlMjAlMjAlMjBxdWVyeV9lbWJlZGRpbmdzJTIwJTNEJTIwbW9kZWwoKipiYXRjaF9xdWVyaWVzKS5lbWJlZGRpbmdzJTBBJTBBJTIzJTIwU2NvcmUlMjB0aGUlMjBxdWVyaWVzJTIwYWdhaW5zdCUyMHRoZSUyMGltYWdlcyUwQXNjb3JlcyUyMCUzRCUyMHByb2Nlc3Nvci5zY29yZV9yZXRyaWV2YWwocXVlcnlfZW1iZWRkaW5ncyUyQyUyMGltYWdlX2VtYmVkZGluZ3Mp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ColPaliForRetrieval, ColPaliProcessor

model_name = <span class="hljs-string">&quot;vidore/colpali-v1.2-hf&quot;</span>

model = ColPaliForRetrieval.from_pretrained(
    model_name,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>,  <span class="hljs-comment"># or &quot;mps&quot; if on Apple Silicon</span>
).<span class="hljs-built_in">eval</span>()

processor = ColPaliProcessor.from_pretrained(model_name)

<span class="hljs-comment"># Your inputs (replace dummy images with screenshots of your documents)</span>
images = [
    Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, (<span class="hljs-number">32</span>, <span class="hljs-number">32</span>), color=<span class="hljs-string">&quot;white&quot;</span>),
    Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, (<span class="hljs-number">16</span>, <span class="hljs-number">16</span>), color=<span class="hljs-string">&quot;black&quot;</span>),
]
queries = [
    <span class="hljs-string">&quot;What is the organizational structure for our R&amp;D department?&quot;</span>,
    <span class="hljs-string">&quot;Can you provide a breakdown of last year’s financial performance?&quot;</span>,
]

<span class="hljs-comment"># Process the inputs</span>
batch_images = processor(images=images).to(model.device)
batch_queries = processor(text=queries).to(model.device)

<span class="hljs-comment"># Forward pass</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    image_embeddings = model(**batch_images).embeddings
    query_embeddings = model(**batch_queries).embeddings

<span class="hljs-comment"># Score the queries against the images</span>
scores = processor.score_retrieval(query_embeddings, image_embeddings)`,wrap:!1}}),S=new le({props:{title:"ColPaliConfig",local:"transformers.ColPaliConfig",headingTag:"h2"}}),X=new z({props:{name:"class transformers.ColPaliConfig",anchor:"transformers.ColPaliConfig",parameters:[{name:"vlm_config",val:" = None"},{name:"text_config",val:" = None"},{name:"embedding_dim",val:": int = 128"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColPaliConfig.vlm_config",description:`<strong>vlm_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
Configuration of the VLM backbone model.`,name:"vlm_config"},{anchor:"transformers.ColPaliConfig.text_config",description:`<strong>text_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
Configuration of the text backbone model. Overrides the <code>text_config</code> attribute of the <code>vlm_config</code> if provided.`,name:"text_config"},{anchor:"transformers.ColPaliConfig.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimension of the multi-vector embeddings produced by the model.`,name:"embedding_dim"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/configuration_colpali.py#L27"}}),R=new ro({props:{anchor:"transformers.ColPaliConfig.example",$$slots:{default:[so]},$$scope:{ctx:de}}}),Q=new le({props:{title:"ColPaliProcessor",local:"transformers.ColPaliProcessor",headingTag:"h2"}}),O=new z({props:{name:"class transformers.ColPaliProcessor",anchor:"transformers.ColPaliProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.ColPaliProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.ColPaliProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/processing_colpali.py#L98"}}),K=new z({props:{name:"batch_decode",anchor:"transformers.ColPaliProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/processing_colpali.py#L280"}}),ee=new z({props:{name:"decode",anchor:"transformers.ColPaliProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/processing_colpali.py#L287"}}),te=new z({props:{name:"process_images",anchor:"transformers.ColPaliProcessor.process_images",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.colpali.processing_colpali.ColPaliProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.process_images.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. In case of a NumPy array/PyTorch tensor, each image should be of shape (C, H, W), where C is a
number of channels, H and W are image height and width.`,name:"images"},{anchor:"transformers.ColPaliProcessor.process_images.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_30530/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/processing_colpali.py#L309",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model. Returned when <code>images</code> is not <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),oe=new z({props:{name:"process_queries",anchor:"transformers.ColPaliProcessor.process_queries",parameters:[{name:"text",val:": typing.Union[str, typing.List[str]]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.colpali.processing_colpali.ColPaliProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.process_queries.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.ColPaliProcessor.process_queries.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_30530/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/processing_colpali.py#L344",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),re=new z({props:{name:"score_retrieval",anchor:"transformers.ColPaliProcessor.score_retrieval",parameters:[{name:"query_embeddings",val:": typing.Union[ForwardRef('torch.Tensor'), typing.List[ForwardRef('torch.Tensor')]]"},{name:"passage_embeddings",val:": typing.Union[ForwardRef('torch.Tensor'), typing.List[ForwardRef('torch.Tensor')]]"},{name:"batch_size",val:": int = 128"},{name:"output_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"output_device",val:": typing.Union[ForwardRef('torch.device'), str] = 'cpu'"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.score_retrieval.query_embeddings",description:"<strong>query_embeddings</strong> (<code>Union[torch.Tensor, List[torch.Tensor]</code>) &#x2014; Query embeddings.",name:"query_embeddings"},{anchor:"transformers.ColPaliProcessor.score_retrieval.passage_embeddings",description:"<strong>passage_embeddings</strong> (<code>Union[torch.Tensor, List[torch.Tensor]</code>) &#x2014; Passage embeddings.",name:"passage_embeddings"},{anchor:"transformers.ColPaliProcessor.score_retrieval.batch_size",description:"<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014; Batch size for computing scores.",name:"batch_size"},{anchor:"transformers.ColPaliProcessor.score_retrieval.output_dtype",description:`<strong>output_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014; The dtype of the output tensor.
If <code>None</code>, the dtype of the input embeddings is used.`,name:"output_dtype"},{anchor:"transformers.ColPaliProcessor.score_retrieval.output_device",description:"<strong>output_device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cpu&#x201D;) &#x2014; The device of the output tensor.",name:"output_device"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/processing_colpali.py#L378",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape <code>(n_queries, n_passages)</code> containing the scores. The score
tensor is saved on the “cpu” device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),ne=new le({props:{title:"ColPaliForRetrieval",local:"transformers.ColPaliForRetrieval",headingTag:"h2"}}),se=new z({props:{name:"class transformers.ColPaliForRetrieval",anchor:"transformers.ColPaliForRetrieval",parameters:[{name:"config",val:": ColPaliConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/modeling_colpali.py#L160"}}),ae=new z({props:{name:"forward",anchor:"transformers.ColPaliForRetrieval.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColPaliForRetrieval.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.
Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.
<a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ColPaliForRetrieval.forward.pixel_values",description:'<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoImageProcessor). See [SiglipImageProcessor.__call__()](/docs/transformers/pr_30530/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__) for details ([]</code>PaliGemmaProcessor`] uses\n<a href="/docs/transformers/pr_30530/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> for processing images). If none, ColPali will only process text (query embeddings).',name:"pixel_values"},{anchor:"transformers.ColPaliForRetrieval.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a>
Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.
If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).
If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</li>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ColPaliForRetrieval.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ColPaliForRetrieval.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ColPaliForRetrieval.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ColPaliForRetrieval.forward.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the vlm backbone model.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/colpali/modeling_colpali.py#L190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.colpali.modeling_colpali.ColPaliForRetrievalOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30530/en/model_doc/colpali#transformers.ColPaliConfig"
>ColPaliConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — The embeddings of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder after projecting last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.colpali.modeling_colpali.ColPaliForRetrievalOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new oo({props:{$$slots:{default:[ao]},$$scope:{ctx:de}}}),ie=new no({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/colpali.md"}}),{c(){c=a("meta"),J=r(),w=a("p"),P=r(),p(C.$$.fragment),b=r(),p($.$$.fragment),Le=r(),G=a("p"),G.innerHTML=Ct,ze=r(),Z=a("p"),Z.innerHTML=$t,Re=r(),q=a("p"),q.innerHTML=xt,We=r(),p(H.$$.fragment),Ue=r(),N=a("ul"),N.innerHTML=kt,Be=r(),V=a("p"),V.innerHTML=Jt,Ee=r(),p(A.$$.fragment),Ge=r(),Y=a("p"),Y.innerHTML=It,Ze=r(),p(D.$$.fragment),qe=r(),p(S.$$.fragment),He=r(),v=a("div"),p(X.$$.fragment),Ke=r(),ce=a("p"),ce.innerHTML=jt,et=r(),me=a("p"),me.innerHTML=Ft,tt=r(),pe=a("p"),pe.innerHTML=Lt,ot=r(),fe=a("p"),fe.innerHTML=zt,rt=r(),ue=a("p"),ue.innerHTML=Rt,nt=r(),p(R.$$.fragment),Ne=r(),p(Q.$$.fragment),Ve=r(),m=a("div"),p(O.$$.fragment),st=r(),ge=a("p"),ge.textContent=Wt,at=r(),he=a("p"),he.innerHTML=Ut,it=r(),W=a("div"),p(K.$$.fragment),lt=r(),_e=a("p"),_e.innerHTML=Bt,dt=r(),U=a("div"),p(ee.$$.fragment),ct=r(),be=a("p"),be.innerHTML=Et,mt=r(),I=a("div"),p(te.$$.fragment),pt=r(),ve=a("p"),ve.innerHTML=Gt,ft=r(),Te=a("p"),Te.innerHTML=Zt,ut=r(),j=a("div"),p(oe.$$.fragment),gt=r(),ye=a("p"),ye.innerHTML=qt,ht=r(),we=a("p"),we.innerHTML=Ht,_t=r(),F=a("div"),p(re.$$.fragment),bt=r(),Pe=a("p"),Pe.innerHTML=Nt,vt=r(),Me=a("p"),Me.textContent=Vt,Ae=r(),p(ne.$$.fragment),Ye=r(),M=a("div"),p(se.$$.fragment),Tt=r(),Ce=a("p"),Ce.textContent=At,yt=r(),$e=a("p"),$e.textContent=Yt,wt=r(),L=a("div"),p(ae.$$.fragment),Pt=r(),xe=a("p"),xe.innerHTML=Dt,Mt=r(),p(B.$$.fragment),De=r(),p(ie.$$.fragment),Se=r(),Fe=a("p"),this.h()},l(e){const o=to("svelte-u9bgzb",document.head);c=i(o,"META",{name:!0,content:!0}),o.forEach(s),J=n(e),w=i(e,"P",{}),x(w).forEach(s),P=n(e),f(C.$$.fragment,e),b=n(e),f($.$$.fragment,e),Le=n(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-322ndy"&&(G.innerHTML=Ct),ze=n(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-w9g99y"&&(Z.innerHTML=$t),Re=n(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1m0xava"&&(q.innerHTML=xt),We=n(e),f(H.$$.fragment,e),Ue=n(e),N=i(e,"UL",{"data-svelte-h":!0}),d(N)!=="svelte-f6xokh"&&(N.innerHTML=kt),Be=n(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-h46vhr"&&(V.innerHTML=Jt),Ee=n(e),f(A.$$.fragment,e),Ge=n(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-8fdv6w"&&(Y.innerHTML=It),Ze=n(e),f(D.$$.fragment,e),qe=n(e),f(S.$$.fragment,e),He=n(e),v=i(e,"DIV",{class:!0});var y=x(v);f(X.$$.fragment,y),Ke=n(y),ce=i(y,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1b8ozfp"&&(ce.innerHTML=jt),et=n(y),me=i(y,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1fyeyvm"&&(me.innerHTML=Ft),tt=n(y),pe=i(y,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-a9ftw5"&&(pe.innerHTML=Lt),ot=n(y),fe=i(y,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-bnl7k3"&&(fe.innerHTML=zt),rt=n(y),ue=i(y,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-l1blo3"&&(ue.innerHTML=Rt),nt=n(y),f(R.$$.fragment,y),y.forEach(s),Ne=n(e),f(Q.$$.fragment,e),Ve=n(e),m=i(e,"DIV",{class:!0});var T=x(m);f(O.$$.fragment,T),st=n(T),ge=i(T,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1xjue1y"&&(ge.textContent=Wt),at=n(T),he=i(T,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1r0jfog"&&(he.innerHTML=Ut),it=n(T),W=i(T,"DIV",{class:!0});var Qe=x(W);f(K.$$.fragment,Qe),lt=n(Qe),_e=i(Qe,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1q9npgb"&&(_e.innerHTML=Bt),Qe.forEach(s),dt=n(T),U=i(T,"DIV",{class:!0});var Oe=x(U);f(ee.$$.fragment,Oe),ct=n(Oe),be=i(Oe,"P",{"data-svelte-h":!0}),d(be)!=="svelte-x1h7ed"&&(be.innerHTML=Et),Oe.forEach(s),mt=n(T),I=i(T,"DIV",{class:!0});var ke=x(I);f(te.$$.fragment,ke),pt=n(ke),ve=i(ke,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1gls1hp"&&(ve.innerHTML=Gt),ft=n(ke),Te=i(ke,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-6m637q"&&(Te.innerHTML=Zt),ke.forEach(s),ut=n(T),j=i(T,"DIV",{class:!0});var Je=x(j);f(oe.$$.fragment,Je),gt=n(Je),ye=i(Je,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-d7fz8o"&&(ye.innerHTML=qt),ht=n(Je),we=i(Je,"P",{"data-svelte-h":!0}),d(we)!=="svelte-fuj0z8"&&(we.innerHTML=Ht),Je.forEach(s),_t=n(T),F=i(T,"DIV",{class:!0});var Ie=x(F);f(re.$$.fragment,Ie),bt=n(Ie),Pe=i(Ie,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1728slr"&&(Pe.innerHTML=Nt),vt=n(Ie),Me=i(Ie,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-3nd4tx"&&(Me.textContent=Vt),Ie.forEach(s),T.forEach(s),Ae=n(e),f(ne.$$.fragment,e),Ye=n(e),M=i(e,"DIV",{class:!0});var E=x(M);f(se.$$.fragment,E),Tt=n(E),Ce=i(E,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-kuaus5"&&(Ce.textContent=At),yt=n(E),$e=i(E,"P",{"data-svelte-h":!0}),d($e)!=="svelte-rxcp7f"&&($e.textContent=Yt),wt=n(E),L=i(E,"DIV",{class:!0});var je=x(L);f(ae.$$.fragment,je),Pt=n(je),xe=i(je,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-jgjczu"&&(xe.innerHTML=Dt),Mt=n(je),f(B.$$.fragment,je),je.forEach(s),E.forEach(s),De=n(e),f(ie.$$.fragment,e),Se=n(e),Fe=i(e,"P",{}),x(Fe).forEach(s),this.h()},h(){k(c,"name","hf:doc:metadata"),k(c,"content",lo),k(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){t(document.head,c),l(e,J,o),l(e,w,o),l(e,P,o),u(C,e,o),l(e,b,o),u($,e,o),l(e,Le,o),l(e,G,o),l(e,ze,o),l(e,Z,o),l(e,Re,o),l(e,q,o),l(e,We,o),u(H,e,o),l(e,Ue,o),l(e,N,o),l(e,Be,o),l(e,V,o),l(e,Ee,o),u(A,e,o),l(e,Ge,o),l(e,Y,o),l(e,Ze,o),u(D,e,o),l(e,qe,o),u(S,e,o),l(e,He,o),l(e,v,o),u(X,v,null),t(v,Ke),t(v,ce),t(v,et),t(v,me),t(v,tt),t(v,pe),t(v,ot),t(v,fe),t(v,rt),t(v,ue),t(v,nt),u(R,v,null),l(e,Ne,o),u(Q,e,o),l(e,Ve,o),l(e,m,o),u(O,m,null),t(m,st),t(m,ge),t(m,at),t(m,he),t(m,it),t(m,W),u(K,W,null),t(W,lt),t(W,_e),t(m,dt),t(m,U),u(ee,U,null),t(U,ct),t(U,be),t(m,mt),t(m,I),u(te,I,null),t(I,pt),t(I,ve),t(I,ft),t(I,Te),t(m,ut),t(m,j),u(oe,j,null),t(j,gt),t(j,ye),t(j,ht),t(j,we),t(m,_t),t(m,F),u(re,F,null),t(F,bt),t(F,Pe),t(F,vt),t(F,Me),l(e,Ae,o),u(ne,e,o),l(e,Ye,o),l(e,M,o),u(se,M,null),t(M,Tt),t(M,Ce),t(M,yt),t(M,$e),t(M,wt),t(M,L),u(ae,L,null),t(L,Pt),t(L,xe),t(L,Mt),u(B,L,null),l(e,De,o),u(ie,e,o),l(e,Se,o),l(e,Fe,o),Xe=!0},p(e,[o]){const y={};o&2&&(y.$$scope={dirty:o,ctx:e}),R.$set(y);const T={};o&2&&(T.$$scope={dirty:o,ctx:e}),B.$set(T)},i(e){Xe||(g(C.$$.fragment,e),g($.$$.fragment,e),g(H.$$.fragment,e),g(A.$$.fragment,e),g(D.$$.fragment,e),g(S.$$.fragment,e),g(X.$$.fragment,e),g(R.$$.fragment,e),g(Q.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(B.$$.fragment,e),g(ie.$$.fragment,e),Xe=!0)},o(e){h(C.$$.fragment,e),h($.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(S.$$.fragment,e),h(X.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(B.$$.fragment,e),h(ie.$$.fragment,e),Xe=!1},d(e){e&&(s(J),s(w),s(P),s(b),s(Le),s(G),s(ze),s(Z),s(Re),s(q),s(We),s(Ue),s(N),s(Be),s(V),s(Ee),s(Ge),s(Y),s(Ze),s(qe),s(He),s(v),s(Ne),s(Ve),s(m),s(Ae),s(Ye),s(M),s(De),s(Se),s(Fe)),s(c),_(C,e),_($,e),_(H,e),_(A,e),_(D,e),_(S,e),_(X),_(R),_(Q,e),_(O),_(K),_(ee),_(te),_(oe),_(re),_(ne,e),_(se),_(ae),_(B),_(ie,e)}}}const lo='{"title":"ColPali","local":"colpali","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"ColPaliConfig","local":"transformers.ColPaliConfig","sections":[],"depth":2},{"title":"ColPaliProcessor","local":"transformers.ColPaliProcessor","sections":[],"depth":2},{"title":"ColPaliForRetrieval","local":"transformers.ColPaliForRetrieval","sections":[],"depth":2}],"depth":1}';function co(de){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bo extends Kt{constructor(c){super(),eo(this,c,co,io,Qt,{})}}export{bo as component};
