import{s as gl,f as ll,n as Bl,o as Zl}from"../chunks/scheduler.37c15a92.js";import{S as Al,i as kl,g as r,s as a,r as o,A as Rl,h as i,f as t,c as n,j as pe,u as y,x as M,k as p,y as $l,a as s,v as m,d as w,t as c,w as d}from"../chunks/index.2bf4358c.js";import{C as re}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as j,E as vl}from"../chunks/EditOnGithub.8916dc7c.js";function xl(tl){let u,oe,ie,ye,h,me,f,sl="In this page, we’ll learn how to implement Group Relative Policy Optimization (GRPO) using the Transformer Reinforcement Learning (TRL) library. We’ll focus on practical implementation with minimal code.",we,C,al="We’ll explore the core concepts of GRPO as they are embodied in TRL’s GRPOTrainer, using snippets from the official TRL documentation to guide us.",ce,I,nl="First, let’s remind ourselves of some of the important concepts of GRPO algorithm:",de,b,rl="<li>Group Formation: The model generates multiple completions for each prompt.</li> <li>Preference Learning: The model learns from a reward function that compares groups of completions.</li> <li>Training Configuration: The model uses a configuration to control the training process.</li>",Ue,G,il="What do we need to do to implement GRPO?",Je,g,Ml="<li>Define a dataset of prompts.</li> <li>Define a reward function that takes a list of completions and returns a list of rewards.</li> <li>Configure the training process with a GRPOConfig.</li> <li>Train the model using the GRPOTrainer.</li>",Te,B,pl="Here’s a minimal example to get started with GRPO training:",je,Z,ue,A,he,k,fe,R,ol="Your dataset should contain prompts that the model will respond to. The GRPO trainer will generate multiple completions for each prompt and use the reward function to compare them.",Ce,$,Ie,v,yl="The reward function is crucial - it determines how the model learns. Here are two practical examples:",be,x,Ge,_,ge,X,ml="Key parameters to consider in <code>GRPOConfig</code>:",Be,E,Ze,W,wl="The <code>num_generation</code> parameter is particularly important for GRPO as it defines the group size - how many different completions the model will generate for each prompt. This is a key differentiator from other RL methods:",Ae,F,cl="<li>Too small (e.g., 2-3): May not provide enough diversity for meaningful comparisons</li> <li>Recommended (4-16): Provides good balance between diversity and computational efficiency</li> <li>Larger values: May improve learning but significantly increases computational cost</li>",ke,Y,dl="The group size should be chosen based on your computational resources and the complexity of your task. For simple tasks, smaller groups (4-8) may be sufficient, while more complex reasoning tasks might benefit from larger groups (8-16).",Re,S,$e,V,Ul="<li><strong>Memory Management</strong>: Adjust <code>per_device_train_batch_size</code> and <code>gradient_accumulation_steps</code> based on your GPU memory.</li> <li><strong>Speed</strong>: Enable <code>use_vllm=True</code> for faster generation if your model is supported.</li> <li><strong>Monitoring</strong>: Watch the logged metrics during training:<ul><li><code>reward</code>: Average reward across completions</li> <li><code>reward_std</code>: Standard deviation within reward groups</li> <li><code>kl</code>: KL divergence from reference model</li></ul></li>",ve,Q,xe,z,Jl="The DeepSeek R1 paper demonstrates several effective approaches to reward function design that you can adapt for your own GRPO implementation:",_e,N,Xe,H,Tl="One of the easiest rewards to implement is a length-based reward. You can reward longer completions:",Ee,P,We,q,jl="This reward function penalizes completions that are too short or too long, encouraging the model to generate completions that are close to the ideal length of 20 tokens.",Fe,U,ul,Ye,L,Se,D,hl="For tasks with objectively correct answers (like mathematics or coding), you can implement rule-based reward functions:",Ve,K,Qe,J,fl,ze,O,Ne,ee,Cl="You can also reward proper formatting, which was important in the DeepSeek R1 training:",He,le,Pe,T,Il,qe,te,bl="These examples demonstrate how you can implement reward functions inspired by the DeepSeek R1 training process, focusing on correctness, formatting, and combined signals.",Le,se,De,ae,Gl="In the next section, you will follow an exercise to implement GRPO in TRL.",Ke,ne,Oe,Me,el;return h=new j({props:{title:"Implementing GRPO in TRL",local:"implementing-grpo-in-trl",headingTag:"h1"}}),Z=new re({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEdSUE9UcmFpbmVyJTJDJTIwR1JQT0NvbmZpZyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMDEuJTIwTG9hZCUyMHlvdXIlMjBkYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5b3VyX2RhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUwQSUyMyUyMDIuJTIwRGVmaW5lJTIwYSUyMHNpbXBsZSUyMHJld2FyZCUyMGZ1bmN0aW9uJTBBZGVmJTIwcmV3YXJkX2Z1bmMoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJFeGFtcGxlJTNBJTIwUmV3YXJkJTIwbG9uZ2VyJTIwY29tcGxldGlvbnMlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJmbG9hdChsZW4oY29tcGxldGlvbikpJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlNUQlMEElMEElMEElMjMlMjAzLiUyMENvbmZpZ3VyZSUyMHRyYWluaW5nJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMEdSUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEEpJTBBJTBBJTIzJTIwNC4lMjBJbml0aWFsaXplJTIwYW5kJTIwdHJhaW4lMEF0cmFpbmVyJTIwJTNEJTIwR1JQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ5b3VyX21vZGVsJTIyJTJDJTIwJTIwJTIzJTIwZS5nLiUyMCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHJld2FyZF9mdW5jcyUzRHJld2FyZF9mdW5jJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOTrainer, GRPOConfig
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># 1. Load your dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;your_dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-comment"># 2. Define a simple reward function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_func</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Example: Reward longer completions&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">float</span>(<span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]


<span class="hljs-comment"># 3. Configure training</span>
training_args = GRPOConfig(
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    logging_steps=<span class="hljs-number">10</span>,
)

<span class="hljs-comment"># 4. Initialize and train</span>
trainer = GRPOTrainer(
    model=<span class="hljs-string">&quot;your_model&quot;</span>,  <span class="hljs-comment"># e.g. &quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>
    args=training_args,
    train_dataset=dataset,
    reward_funcs=reward_func,
)
trainer.train()`,wrap:!1}}),A=new j({props:{title:"Key Components",local:"key-components",headingTag:"h2"}}),k=new j({props:{title:"1. Dataset Format",local:"1-dataset-format",headingTag:"h3"}}),$=new j({props:{title:"2. Reward Function",local:"2-reward-function",headingTag:"h3"}}),x=new re({props:{code:"JTIzJTIwRXhhbXBsZSUyMDElM0ElMjBSZXdhcmQlMjBiYXNlZCUyMG9uJTIwY29tcGxldGlvbiUyMGxlbmd0aCUwQWRlZiUyMHJld2FyZF9sZW5ndGgoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJmbG9hdChsZW4oY29tcGxldGlvbikpJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlNUQlMEElMEElMEElMjMlMjBFeGFtcGxlJTIwMiUzQSUyMFJld2FyZCUyMGJhc2VkJTIwb24lMjBtYXRjaGluZyUyMGElMjBwYXR0ZXJuJTBBaW1wb3J0JTIwcmUlMEElMEElMEFkZWYlMjByZXdhcmRfZm9ybWF0KGNvbXBsZXRpb25zJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwcGF0dGVybiUyMCUzRCUyMHIlMjIlNUUlM0N0aGluayUzRS4qJTNGJTNDJTJGdGhpbmslM0UlM0NhbnN3ZXIlM0UuKiUzRiUzQyUyRmFuc3dlciUzRSUyNCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QjEuMCUyMGlmJTIwcmUubWF0Y2gocGF0dGVybiUyQyUyMGMpJTIwZWxzZSUyMDAuMCUyMGZvciUyMGMlMjBpbiUyMGNvbXBsZXRpb25zJTVE",highlighted:`<span class="hljs-comment"># Example 1: Reward based on completion length</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_length</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">float</span>(<span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]


<span class="hljs-comment"># Example 2: Reward based on matching a pattern</span>
<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_format</span>(<span class="hljs-params">completions, **kwargs</span>):
    pattern = <span class="hljs-string">r&quot;^&lt;think&gt;.*?&lt;/think&gt;&lt;answer&gt;.*?&lt;/answer&gt;$&quot;</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">1.0</span> <span class="hljs-keyword">if</span> re.<span class="hljs-keyword">match</span>(pattern, c) <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),_=new j({props:{title:"3. Training Configuration",local:"3-training-configuration",headingTag:"h3"}}),E=new re({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEdSUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXNzZW50aWFsJTIwcGFyYW1ldGVycyUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJvdXRwdXQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMyUyQyUwQSUyMCUyMCUyMCUyMG51bV9nZW5lcmF0aW9uJTNENCUyQyUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwY29tcGxldGlvbnMlMjB0byUyMGdlbmVyYXRlJTIwZm9yJTIwZWFjaCUyMHByb21wdCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjAlMjAlMjMlMjBXZSUyMHdhbnQlMjB0byUyMGdldCUyMGFsbCUyMGdlbmVyYXRpb25zJTIwaW4lMjBvbmUlMjBkZXZpY2UlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMyUyME9wdGlvbmFsJTIwYnV0JTIwdXNlZnVsJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwR1JQTyUyMHNwZWNpZmljJTIwKG9wdGlvbmFsKSUwQSUyMCUyMCUyMCUyMHVzZV92bGxtJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMFNwZWVkJTIwdXAlMjBnZW5lcmF0aW9uJTBBKQ==",highlighted:`training_args = GRPOConfig(
    <span class="hljs-comment"># Essential parameters</span>
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    num_generation=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Number of completions to generate for each prompt</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,  <span class="hljs-comment"># We want to get all generations in one device batch</span>
    <span class="hljs-comment"># Optional but useful</span>
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    <span class="hljs-comment"># GRPO specific (optional)</span>
    use_vllm=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Speed up generation</span>
)`,wrap:!1}}),S=new j({props:{title:"Tips for Success",local:"tips-for-success",headingTag:"h2"}}),Q=new j({props:{title:"Reward Function Design",local:"reward-function-design",headingTag:"h2"}}),N=new j({props:{title:"1. Length-Based Rewards",local:"1-length-based-rewards",headingTag:"h3"}}),P=new re({props:{code:"ZGVmJTIwcmV3YXJkX2xlbihjb21wbGV0aW9ucyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMGlkZWFsX2xlbmd0aCUyMCUzRCUyMDIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCLWFicyhpZGVhbF9sZW5ndGglMjAtJTIwbGVuKGNvbXBsZXRpb24pKSUyMGZvciUyMGNvbXBsZXRpb24lMjBpbiUyMGNvbXBsZXRpb25zJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_len</span>(<span class="hljs-params">completions, **kwargs</span>):
    ideal_length = <span class="hljs-number">20</span>
    <span class="hljs-keyword">return</span> [-<span class="hljs-built_in">abs</span>(ideal_length - <span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),L=new j({props:{title:"2. Rule-Based Rewards for Verifiable Tasks",local:"2-rule-based-rewards-for-verifiable-tasks",headingTag:"h2"}}),K=new re({props:{code:"ZGVmJTIwcHJvYmxlbV9yZXdhcmQoY29tcGxldGlvbnMlMkMlMjBhbnN3ZXJzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUmV3YXJkJTIwZnVuY3Rpb24lMjBmb3IlMjBtYXRoJTIwcHJvYmxlbXMlMjB3aXRoJTIwdmVyaWZpYWJsZSUyMGFuc3dlcnMlMEElMjAlMjAlMjAlMjBjb21wbGV0aW9ucyUzQSUyMGxpc3QlMjBvZiUyMGNvbXBsZXRpb25zJTIwdG8lMjBldmFsdWF0ZSUwQSUyMCUyMCUyMCUyMGFuc3dlcnMlM0ElMjBsaXN0JTIwb2YlMjBhbnN3ZXJzJTIwdG8lMjB0aGUlMjBwcm9ibGVtcyUyMGZyb20lMjB0aGUlMjBkYXRhc2V0JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwcmV3YXJkcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGNvbXBsZXRpb24lMkMlMjBjb3JyZWN0X2Fuc3dlciUyMGluJTIwemlwKGNvbXBsZXRpb25zJTJDJTIwYW5zd2VycyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWN0JTIwdGhlJTIwYW5zd2VyJTIwZnJvbSUyMHRoZSUyMGNvbXBsZXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUaGlzJTIwaXMlMjBhJTIwc2ltcGxpZmllZCUyMGV4YW1wbGUlMjAtJTIweW91J2QlMjBuZWVkJTIwcHJvcGVyJTIwcGFyc2luZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuc3dlciUyMCUzRCUyMGV4dHJhY3RfZmluYWxfYW5zd2VyKGNvbXBsZXRpb24pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQmluYXJ5JTIwcmV3YXJkJTNBJTIwMSUyMGZvciUyMGNvcnJlY3QlMkMlMjAwJTIwZm9yJTIwaW5jb3JyZWN0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkJTIwJTNEJTIwMS4wJTIwaWYlMjBhbnN3ZXIlMjAlM0QlM0QlMjBjb3JyZWN0X2Fuc3dlciUyMGVsc2UlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXdhcmRzLmFwcGVuZChyZXdhcmQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwSWYlMjB3ZSUyMGNhbid0JTIwcGFyc2UlMjBhbiUyMGFuc3dlciUyQyUyMGdpdmUlMjBhJTIwbG93JTIwcmV3YXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkcy5hcHBlbmQoMC4wKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJld2FyZHM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">problem_reward</span>(<span class="hljs-params">completions, answers, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Reward function for math problems with verifiable answers
    completions: list of completions to evaluate
    answers: list of answers to the problems from the dataset
    &quot;&quot;&quot;</span>

    rewards = []
    <span class="hljs-keyword">for</span> completion, correct_answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(completions, answers):
        <span class="hljs-comment"># Extract the answer from the completion</span>
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># This is a simplified example - you&#x27;d need proper parsing</span>
            answer = extract_final_answer(completion)
            <span class="hljs-comment"># Binary reward: 1 for correct, 0 for incorrect</span>
            reward = <span class="hljs-number">1.0</span> <span class="hljs-keyword">if</span> answer == correct_answer <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span>
            rewards.append(reward)
        <span class="hljs-keyword">except</span>:
            <span class="hljs-comment"># If we can&#x27;t parse an answer, give a low reward</span>
            rewards.append(<span class="hljs-number">0.0</span>)

    <span class="hljs-keyword">return</span> rewards`,wrap:!1}}),O=new j({props:{title:"3. Format-Based Rewards",local:"3-format-based-rewards",headingTag:"h2"}}),le=new re({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_reward</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Reward completions that follow the desired format&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example: Check if the completion follows a think-then-answer format</span>
    pattern = <span class="hljs-string">r&quot;&lt;think&gt;(.*?)&lt;/think&gt;\\s*&lt;answer&gt;(.*?)&lt;/answer&gt;&quot;</span>

    rewards = []
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions:
        <span class="hljs-keyword">match</span> = re.search(pattern, completion, re.DOTALL)
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span>:
            <span class="hljs-comment"># Check if there&#x27;s substantial content in both sections</span>
            think_content = <span class="hljs-keyword">match</span>.group(<span class="hljs-number">1</span>).strip()
            answer_content = <span class="hljs-keyword">match</span>.group(<span class="hljs-number">2</span>).strip()

            <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(think_content) &gt; <span class="hljs-number">20</span> <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(answer_content) &gt; <span class="hljs-number">0</span>:
                rewards.append(<span class="hljs-number">1.0</span>)
            <span class="hljs-keyword">else</span>:
                rewards.append(
                    <span class="hljs-number">0.5</span>
                )  <span class="hljs-comment"># Partial reward for correct format but limited content</span>
        <span class="hljs-keyword">else</span>:
            rewards.append(<span class="hljs-number">0.0</span>)  <span class="hljs-comment"># No reward for incorrect format</span>

    <span class="hljs-keyword">return</span> rewards`,wrap:!1}}),se=new j({props:{title:"That’s it!",local:"thats-it",headingTag:"h2"}}),ne=new vl({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter13/4.mdx"}}),{c(){u=r("meta"),oe=a(),ie=r("p"),ye=a(),o(h.$$.fragment),me=a(),f=r("p"),f.textContent=sl,we=a(),C=r("p"),C.textContent=al,ce=a(),I=r("p"),I.textContent=nl,de=a(),b=r("ul"),b.innerHTML=rl,Ue=a(),G=r("p"),G.textContent=il,Je=a(),g=r("ul"),g.innerHTML=Ml,Te=a(),B=r("p"),B.textContent=pl,je=a(),o(Z.$$.fragment),ue=a(),o(A.$$.fragment),he=a(),o(k.$$.fragment),fe=a(),R=r("p"),R.textContent=ol,Ce=a(),o($.$$.fragment),Ie=a(),v=r("p"),v.textContent=yl,be=a(),o(x.$$.fragment),Ge=a(),o(_.$$.fragment),ge=a(),X=r("p"),X.innerHTML=ml,Be=a(),o(E.$$.fragment),Ze=a(),W=r("p"),W.innerHTML=wl,Ae=a(),F=r("ul"),F.innerHTML=cl,ke=a(),Y=r("p"),Y.textContent=dl,Re=a(),o(S.$$.fragment),$e=a(),V=r("ol"),V.innerHTML=Ul,ve=a(),o(Q.$$.fragment),xe=a(),z=r("p"),z.textContent=Jl,_e=a(),o(N.$$.fragment),Xe=a(),H=r("p"),H.textContent=Tl,Ee=a(),o(P.$$.fragment),We=a(),q=r("p"),q.textContent=jl,Fe=a(),U=r("iframe"),Ye=a(),o(L.$$.fragment),Se=a(),D=r("p"),D.textContent=hl,Ve=a(),o(K.$$.fragment),Qe=a(),J=r("iframe"),ze=a(),o(O.$$.fragment),Ne=a(),ee=r("p"),ee.textContent=Cl,He=a(),o(le.$$.fragment),Pe=a(),T=r("iframe"),qe=a(),te=r("p"),te.textContent=bl,Le=a(),o(se.$$.fragment),De=a(),ae=r("p"),ae.textContent=Gl,Ke=a(),o(ne.$$.fragment),Oe=a(),Me=r("p"),this.h()},l(e){const l=Rl("svelte-u9bgzb",document.head);u=i(l,"META",{name:!0,content:!0}),l.forEach(t),oe=n(e),ie=i(e,"P",{}),pe(ie).forEach(t),ye=n(e),y(h.$$.fragment,e),me=n(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-v9iq5e"&&(f.textContent=sl),we=n(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-iqdzey"&&(C.textContent=al),ce=n(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-14hk95q"&&(I.textContent=nl),de=n(e),b=i(e,"UL",{"data-svelte-h":!0}),M(b)!=="svelte-1vd6wz6"&&(b.innerHTML=rl),Ue=n(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-pzoe2y"&&(G.textContent=il),Je=n(e),g=i(e,"UL",{"data-svelte-h":!0}),M(g)!=="svelte-1hif2as"&&(g.innerHTML=Ml),Te=n(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-ac9u4w"&&(B.textContent=pl),je=n(e),y(Z.$$.fragment,e),ue=n(e),y(A.$$.fragment,e),he=n(e),y(k.$$.fragment,e),fe=n(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1pnmwnq"&&(R.textContent=ol),Ce=n(e),y($.$$.fragment,e),Ie=n(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-ths948"&&(v.textContent=yl),be=n(e),y(x.$$.fragment,e),Ge=n(e),y(_.$$.fragment,e),ge=n(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1uukcnx"&&(X.innerHTML=ml),Be=n(e),y(E.$$.fragment,e),Ze=n(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1tdjaxe"&&(W.innerHTML=wl),Ae=n(e),F=i(e,"UL",{"data-svelte-h":!0}),M(F)!=="svelte-1b1t69f"&&(F.innerHTML=cl),ke=n(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-7howml"&&(Y.textContent=dl),Re=n(e),y(S.$$.fragment,e),$e=n(e),V=i(e,"OL",{"data-svelte-h":!0}),M(V)!=="svelte-4ukx5l"&&(V.innerHTML=Ul),ve=n(e),y(Q.$$.fragment,e),xe=n(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-5lvuy8"&&(z.textContent=Jl),_e=n(e),y(N.$$.fragment,e),Xe=n(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-jhf03w"&&(H.textContent=Tl),Ee=n(e),y(P.$$.fragment,e),We=n(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-jlmna3"&&(q.textContent=jl),Fe=n(e),U=i(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),pe(U).forEach(t),Ye=n(e),y(L.$$.fragment,e),Se=n(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-mrpax"&&(D.textContent=hl),Ve=n(e),y(K.$$.fragment,e),Qe=n(e),J=i(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),pe(J).forEach(t),ze=n(e),y(O.$$.fragment,e),Ne=n(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-18k4wdv"&&(ee.textContent=Cl),He=n(e),y(le.$$.fragment,e),Pe=n(e),T=i(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),pe(T).forEach(t),qe=n(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-fzl1fe"&&(te.textContent=bl),Le=n(e),y(se.$$.fragment,e),De=n(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-chd5s6"&&(ae.textContent=Gl),Ke=n(e),y(ne.$$.fragment,e),Oe=n(e),Me=i(e,"P",{}),pe(Me).forEach(t),this.h()},h(){p(u,"name","hf:doc:metadata"),p(u,"content",_l),ll(U.src,ul="marimo.app/gh/burtenshaw/notebooks/add-marimo-examples-for-grpo-chapter/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_length.py&embed=true&show-chrome=false")||p(U,"src",ul),p(U,"title","Marimo Notebook"),p(U,"width","100%"),p(U,"height","500px"),p(U,"frameborder","0"),p(U,"allow","clipboard-write"),ll(J.src,fl="marimo.app/gh/burtenshaw/notebooks/add-marimo-examples-for-grpo-chapter/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_math.py&embed=true&show-chrome=false")||p(J,"src",fl),p(J,"title","Marimo Notebook"),p(J,"width","100%"),p(J,"height","500px"),p(J,"frameborder","0"),p(J,"allow","clipboard-write"),ll(T.src,Il="marimo.app/gh/burtenshaw/notebooks/add-marimo-examples-for-grpo-chapter/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_format.py&embed=true&show-chrome=false")||p(T,"src",Il),p(T,"title","Marimo Notebook"),p(T,"width","100%"),p(T,"height","500px"),p(T,"frameborder","0"),p(T,"allow","clipboard-write")},m(e,l){$l(document.head,u),s(e,oe,l),s(e,ie,l),s(e,ye,l),m(h,e,l),s(e,me,l),s(e,f,l),s(e,we,l),s(e,C,l),s(e,ce,l),s(e,I,l),s(e,de,l),s(e,b,l),s(e,Ue,l),s(e,G,l),s(e,Je,l),s(e,g,l),s(e,Te,l),s(e,B,l),s(e,je,l),m(Z,e,l),s(e,ue,l),m(A,e,l),s(e,he,l),m(k,e,l),s(e,fe,l),s(e,R,l),s(e,Ce,l),m($,e,l),s(e,Ie,l),s(e,v,l),s(e,be,l),m(x,e,l),s(e,Ge,l),m(_,e,l),s(e,ge,l),s(e,X,l),s(e,Be,l),m(E,e,l),s(e,Ze,l),s(e,W,l),s(e,Ae,l),s(e,F,l),s(e,ke,l),s(e,Y,l),s(e,Re,l),m(S,e,l),s(e,$e,l),s(e,V,l),s(e,ve,l),m(Q,e,l),s(e,xe,l),s(e,z,l),s(e,_e,l),m(N,e,l),s(e,Xe,l),s(e,H,l),s(e,Ee,l),m(P,e,l),s(e,We,l),s(e,q,l),s(e,Fe,l),s(e,U,l),s(e,Ye,l),m(L,e,l),s(e,Se,l),s(e,D,l),s(e,Ve,l),m(K,e,l),s(e,Qe,l),s(e,J,l),s(e,ze,l),m(O,e,l),s(e,Ne,l),s(e,ee,l),s(e,He,l),m(le,e,l),s(e,Pe,l),s(e,T,l),s(e,qe,l),s(e,te,l),s(e,Le,l),m(se,e,l),s(e,De,l),s(e,ae,l),s(e,Ke,l),m(ne,e,l),s(e,Oe,l),s(e,Me,l),el=!0},p:Bl,i(e){el||(w(h.$$.fragment,e),w(Z.$$.fragment,e),w(A.$$.fragment,e),w(k.$$.fragment,e),w($.$$.fragment,e),w(x.$$.fragment,e),w(_.$$.fragment,e),w(E.$$.fragment,e),w(S.$$.fragment,e),w(Q.$$.fragment,e),w(N.$$.fragment,e),w(P.$$.fragment,e),w(L.$$.fragment,e),w(K.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(se.$$.fragment,e),w(ne.$$.fragment,e),el=!0)},o(e){c(h.$$.fragment,e),c(Z.$$.fragment,e),c(A.$$.fragment,e),c(k.$$.fragment,e),c($.$$.fragment,e),c(x.$$.fragment,e),c(_.$$.fragment,e),c(E.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(P.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),el=!1},d(e){e&&(t(oe),t(ie),t(ye),t(me),t(f),t(we),t(C),t(ce),t(I),t(de),t(b),t(Ue),t(G),t(Je),t(g),t(Te),t(B),t(je),t(ue),t(he),t(fe),t(R),t(Ce),t(Ie),t(v),t(be),t(Ge),t(ge),t(X),t(Be),t(Ze),t(W),t(Ae),t(F),t(ke),t(Y),t(Re),t($e),t(V),t(ve),t(xe),t(z),t(_e),t(Xe),t(H),t(Ee),t(We),t(q),t(Fe),t(U),t(Ye),t(Se),t(D),t(Ve),t(Qe),t(J),t(ze),t(Ne),t(ee),t(He),t(Pe),t(T),t(qe),t(te),t(Le),t(De),t(ae),t(Ke),t(Oe),t(Me)),t(u),d(h,e),d(Z,e),d(A,e),d(k,e),d($,e),d(x,e),d(_,e),d(E,e),d(S,e),d(Q,e),d(N,e),d(P,e),d(L,e),d(K,e),d(O,e),d(le,e),d(se,e),d(ne,e)}}}const _l='{"title":"Implementing GRPO in TRL","local":"implementing-grpo-in-trl","sections":[{"title":"Key Components","local":"key-components","sections":[{"title":"1. Dataset Format","local":"1-dataset-format","sections":[],"depth":3},{"title":"2. Reward Function","local":"2-reward-function","sections":[],"depth":3},{"title":"3. Training Configuration","local":"3-training-configuration","sections":[],"depth":3}],"depth":2},{"title":"Tips for Success","local":"tips-for-success","sections":[],"depth":2},{"title":"Reward Function Design","local":"reward-function-design","sections":[{"title":"1. Length-Based Rewards","local":"1-length-based-rewards","sections":[],"depth":3}],"depth":2},{"title":"2. Rule-Based Rewards for Verifiable Tasks","local":"2-rule-based-rewards-for-verifiable-tasks","sections":[],"depth":2},{"title":"3. Format-Based Rewards","local":"3-format-based-rewards","sections":[],"depth":2},{"title":"That’s it!","local":"thats-it","sections":[],"depth":2}],"depth":1}';function Xl(tl){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends Al{constructor(u){super(),kl(this,u,Xl,xl,gl,{})}}export{Sl as component};
