# Getting Started with LeRobot

Throughout this course, we'll use LeRobot, Hugging Face's comprehensive open-source robotics library that democratizes access to state-of-the-art robot learning techniques. LeRobot addresses one of the biggest barriers in robotics education and research: the complexity of working with real robotic systems and data.

The library provides intuitive dataset handling that makes working with complex robotics data as straightforward as working with text or images in traditional machine learning. You'll have access to pre-trained models that serve as strong starting points for your own projects, allowing you to build upon proven algorithms rather than starting from scratch. LeRobot also supports deployment on real robotic hardware, bridging the gap between simulation and real-world applications. Perhaps most importantly, it connects you to a growing community of robot learning practitioners, from researchers at leading institutions to hobbyists building amazing projects at home.

> [!TIP]
> **Installation Preview:** We'll walk through installing LeRobot in Unit 2, but if you're eager to get started:
>
> ```bash
> pip install lerobot
> ```
>
> Check out the [LeRobot GitHub repository](https://github.com/huggingface/lerobot) for more details!

Ready to start your robot learning journey? Let's begin with understanding why classical robotics approaches have limitations and how learning can help overcome them.

<EditOnGithub source="https://github.com/huggingface/robotics-course/blob/main/units/en/unit0/2.mdx" />