import{s as Pt,n as Kt,o as Ot}from"../chunks/scheduler.3a17fb72.js";import{S as le,i as te,e as T,s as a,c as i,h as ee,a as y,d as e,b as n,f as Dt,g as M,j as u,k as bt,l as se,m as s,n as o,t as p,o as r,p as m}from"../chunks/index.093f8863.js";import{C as ae,H as J,E as ne}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d36bd103.js";import{C as U}from"../chunks/CodeBlock.1e57c426.js";function ie(Ct){let w,gl,hl,Il,j,fl,g,dl,I,$t="Lighteval supports multilingual evaluations through a comprehensive system of translation literals and language-adapted templates.",bl,f,Cl,d,$l,b,Gt="We define 19 <code>literals</code>, basic keywords or punctuation signs used when creating evaluation prompts in an automatic manner, such as <code>yes</code>, <code>no</code>, <code>because</code>, etc.",Gl,C,vt="These literals are essential for:",vl,$,kt="<li><strong>Consistent prompt formatting</strong> across languages</li> <li><strong>Automatic prompt generation</strong> for multilingual tasks</li> <li><strong>Proper localization</strong> of evaluation templates</li>",kl,G,Zl,v,Zt="We welcome translations in your language! To contribute:",Al,k,At='<li><p><strong>Open the translation literals file</strong>: <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/utils/translation_literals.py" rel="nofollow">translation_literals.py</a></p></li> <li><p><strong>Edit the file</strong> to add or expand the literal for your language of interest</p></li> <li><p><strong>Open a PR</strong> with your modifications</p></li>',Bl,Z,Wl,A,Fl,B,Xl,W,Yl,F,Bt="Before creating a new multilingual task, you should:",Sl,X,Wt='<li><strong>Read the custom task guide</strong>: <a href="adding-a-custom-task">Adding a Custom Task</a></li> <li><strong>Understand multilingual task structure</strong>: Review the <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/multilingual/tasks.py" rel="nofollow">multilingual tasks</a> file</li> <li><strong>Browse available templates</strong>: Check the <a href="https://github.com/huggingface/lighteval/tree/main/src/lighteval/tasks/templates" rel="nofollow">templates directory</a></li>',Ql,Y,xl,S,Rl,Q,Ft="For multilingual evaluations, the <code>prompt_function</code> should be implemented using language-adapted templates. These templates handle:",Hl,x,Xt="<li><strong>Correct formatting</strong> for each language</li> <li><strong>Consistent usage</strong> of language-adjusted prompt anchors (e.g., Question/Answer)</li> <li><strong>Proper punctuation</strong> and spacing conventions</li>",ql,R,Nl,H,Yt="Available template types include:",El,q,St='<li><strong>XNLI</strong>: Natural language inference tasks - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/nli.py#L162" rel="nofollow"><code>get_nli_prompt_function</code></a></li> <li><strong>COPA</strong>: Causal reasoning tasks - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/copa.py#L76" rel="nofollow"><code>get_copa_prompt_function</code></a></li> <li><strong>Multiple Choice</strong>: Standard multiple choice questions - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/multichoice.py#L81" rel="nofollow"><code>get_mcq_prompt_function</code></a></li> <li><strong>Question Answering</strong>: Open-ended question answering - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/qa.py#L46" rel="nofollow"><code>get_qa_prompt_function</code></a></li> <li><strong>Custom</strong>: Specialized task templates</li>',_l,N,Vl,E,zl,_,Qt="Used for standard multiple choice questions where the model selects from lettered options:",Ll,V,Dl,z,xt="<strong>Example output:</strong>",Pl,L,Kl,D,Ol,P,Rt="Used for classification tasks where the model generates the answer directly:",lt,K,tt,O,Ht="<strong>Example output:</strong>",et,ll,st,tl,at,el,qt="Used for tasks that present choices but expect the full answer text:",nt,sl,it,al,Nt="<strong>Example output:</strong>",Mt,nl,ot,il,pt,Ml,rt,ol,Et="Create a Python file following the custom task guide structure.",mt,pl,Tt,rl,yt,ml,ut,Tl,Jt,yl,wt,ul,_t="Follow the custom task guide to test if your task is correctly implemented.",Ut,c,Vt='<p>All <a href="/docs/lighteval/pr_1065/en/package_reference/tasks#lighteval.tasks.lighteval_task.LightevalTaskConfig">LightevalTaskConfig</a> parameters are strongly typed, including the inputs to the template function. Make sure to take advantage of your IDE’s functionality to make it easier to correctly fill these parameters.</p>',ct,Jl,ht,h,zt='<li class="task-list-item"><input type="checkbox" disabled=""/> Translation literals are accurate and complete</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Task works correctly across all target languages</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Metrics are appropriate for the task type</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Documentation is clear and comprehensive</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Code follows project conventions</li>',jt,wl,gt,Ul,Lt="<li><strong>GitHub Issues</strong>: Report bugs or ask questions</li> <li><strong>Discussions</strong>: Join community discussions</li> <li><strong>Documentation</strong>: Review existing guides and examples</li>",It,cl,ft,jl,dt;return j=new ae({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new J({props:{title:"Contributing to Multilingual Evaluations",local:"contributing-to-multilingual-evaluations",headingTag:"h1"}}),f=new J({props:{title:"Contributing Translation Literals",local:"contributing-translation-literals",headingTag:"h2"}}),d=new J({props:{title:"What Are Translation Literals?",local:"what-are-translation-literals",headingTag:"h3"}}),G=new J({props:{title:"How to Contribute Translations",local:"how-to-contribute-translations",headingTag:"h3"}}),Z=new J({props:{title:"Translation Literals Structure",local:"translation-literals-structure",headingTag:"h3"}}),A=new U({props:{code:"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",highlighted:`Language.ENGLISH: TranslationLiterals(
    language=Language.ENGLISH,
    question_word=<span class="hljs-string">&quot;question&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Question: How are you?&quot;</span>
    answer=<span class="hljs-string">&quot;answer&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Answer: I am fine&quot;</span>
    confirmation_word=<span class="hljs-string">&quot;right&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, right?&quot;</span>
    yes=<span class="hljs-string">&quot;yes&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Yes, he is&quot;</span>
    no=<span class="hljs-string">&quot;no&quot;</span>,  <span class="hljs-comment"># Usage: &quot;No, he is not&quot;</span>
    also=<span class="hljs-string">&quot;also&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Also, she is smart.&quot;</span>
    cause_word=<span class="hljs-string">&quot;because&quot;</span>,  <span class="hljs-comment"># Usage: &quot;She is smart, because she is tall&quot;</span>
    effect_word=<span class="hljs-string">&quot;therefore&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is tall therefore he is smart&quot;</span>
    or_word=<span class="hljs-string">&quot;or&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is tall or small&quot;</span>
    true=<span class="hljs-string">&quot;true&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    false=<span class="hljs-string">&quot;false&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    neither=<span class="hljs-string">&quot;neither&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    <span class="hljs-comment"># Punctuation and spacing: only adjust if your language uses something different than in English</span>
    full_stop=<span class="hljs-string">&quot;.&quot;</span>,
    comma=<span class="hljs-string">&quot;,&quot;</span>,
    question_mark=<span class="hljs-string">&quot;?&quot;</span>,
    exclamation_mark=<span class="hljs-string">&quot;!&quot;</span>,
    word_space=<span class="hljs-string">&quot; &quot;</span>,
    sentence_space=<span class="hljs-string">&quot; &quot;</span>,
    colon=<span class="hljs-string">&quot;:&quot;</span>,
    <span class="hljs-comment"># The first characters of your alphabet used in enumerations, if different from English</span>
    indices=[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>, ...]
)`,wrap:!1}}),B=new J({props:{title:"Contributing New Multilingual Tasks",local:"contributing-new-multilingual-tasks",headingTag:"h2"}}),W=new J({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h3"}}),Y=new J({props:{title:"Key Concepts",local:"key-concepts",headingTag:"h3"}}),S=new J({props:{title:"Language-Adapted Templates",local:"language-adapted-templates",headingTag:"h4"}}),R=new J({props:{title:"Template Types",local:"template-types",headingTag:"h4"}}),N=new J({props:{title:"Formulation Types",local:"formulation-types",headingTag:"h4"}}),E=new J({props:{title:"Multiple Choice Formulation (MCF)",local:"multiple-choice-formulation-mcf",headingTag:"h5"}}),V=new U({props:{code:"TUNGRm9ybXVsYXRpb24oKQ==",highlighted:"MCFFormulation()",wrap:!1}}),L=new U({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBLiUyMExvbmRvbiUwQUIuJTIwUGFyaXMlMEFDLiUyMEJlcmxpbiUwQUQuJTIwUm9tZSUwQUFuc3dlciUzQSUyMCU3QyUyMEElMkZCJTJGQyUyRkQ=",highlighted:`<span class="hljs-variable">Question</span><span class="hljs-operator">:</span> <span class="hljs-variable">What</span> <span class="hljs-variable">is</span> <span class="hljs-variable">the</span> <span class="hljs-variable">capital</span> <span class="hljs-variable">of</span> <span class="hljs-variable">France</span><span class="hljs-operator">?</span>
<span class="hljs-variable">A</span><span class="hljs-operator">.</span> <span class="hljs-variable">London</span>
<span class="hljs-variable">B</span><span class="hljs-operator">.</span> <span class="hljs-variable">Paris</span>
<span class="hljs-built_in">C</span><span class="hljs-operator">.</span> <span class="hljs-variable">Berlin</span>
<span class="hljs-built_in">D</span><span class="hljs-operator">.</span> <span class="hljs-variable">Rome</span>
<span class="hljs-variable">Answer</span><span class="hljs-operator">:</span> <span class="hljs-operator">|</span> <span class="hljs-variable">A</span><span class="hljs-operator">/</span><span class="hljs-variable">B</span><span class="hljs-operator">/</span><span class="hljs-built_in">C</span><span class="hljs-operator">/</span><span class="hljs-built_in">D</span>`,wrap:!1}}),D=new J({props:{title:"Classification Formulation (CF)",local:"classification-formulation-cf",headingTag:"h5"}}),K=new U({props:{code:"Q0ZGb3JtdWxhdGlvbigp",highlighted:"CFFormulation()",wrap:!1}}),ll=new U({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBbnN3ZXIlM0ElMjAlN0MlMjBQYXJpcw==",highlighted:`<span class="hljs-symbol">Question:</span> What <span class="hljs-built_in">is</span> the capital <span class="hljs-keyword">of</span> France?
<span class="hljs-symbol">Answer:</span> | Paris`,wrap:!1}}),tl=new J({props:{title:"Hybrid Formulation",local:"hybrid-formulation",headingTag:"h5"}}),sl=new U({props:{code:"SHlicmlkRm9ybXVsYXRpb24oKQ==",highlighted:"HybridFormulation()",wrap:!1}}),nl=new U({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBLiUyMExvbmRvbiUwQUIuJTIwUGFyaXMlMEFDLiUyMEJlcmxpbiUwQUQuJTIwUm9tZSUwQUFuc3dlciUzQSUyMCU3QyUyMFBhcmlz",highlighted:`<span class="hljs-symbol">Question:</span> What <span class="hljs-built_in">is</span> the capital <span class="hljs-keyword">of</span> France?
A. London
B. Paris
C. Berlin
D. Rome
<span class="hljs-symbol">Answer:</span> | Paris`,wrap:!1}}),il=new J({props:{title:"Creating Your Multilingual Task",local:"creating-your-multilingual-task",headingTag:"h3"}}),Ml=new J({props:{title:"Step 1: Create the Task File",local:"step-1-create-the-task-file",headingTag:"h4"}}),pl=new J({props:{title:"Step 2: Import Required Components",local:"step-2-import-required-components",headingTag:"h4"}}),rl=new U({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5saWdodGV2YWxfdGFzayUyMGltcG9ydCUyMExpZ2h0ZXZhbFRhc2tDb25maWclMEFmcm9tJTIwbGlnaHRldmFsLnRhc2tzLm11bHRpbGluZ3VhbC5sYW5ndWFnZSUyMGltcG9ydCUyMExhbmd1YWdlJTBBZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5tdWx0aWxpbmd1YWwuZm9ybXVsYXRpb25zJTIwaW1wb3J0JTIwTUNGRm9ybXVsYXRpb24lMkMlMjBDRkZvcm11bGF0aW9uJTJDJTIwSHlicmlkRm9ybXVsYXRpb24lMEFmcm9tJTIwbGlnaHRldmFsLnRhc2tzLm11bHRpbGluZ3VhbC50ZW1wbGF0ZXMlMjBpbXBvcnQlMjBnZXRfdGVtcGxhdGVfcHJvbXB0X2Z1bmN0aW9uJTBBZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5tdWx0aWxpbmd1YWwubWV0cmljcyUyMGltcG9ydCUyMGdldF9tZXRyaWNzX2Zvcl9mb3JtdWxhdGlvbiUyQyUyMGxvZ2xpa2VsaWhvb2RfYWNjX21ldHJpYyUwQWZyb20lMjBsaWdodGV2YWwudGFza3MubXVsdGlsaW5ndWFsLm5vcm1hbGl6YXRpb24lMjBpbXBvcnQlMjBMb2dQcm9iVG9rZW5Ob3JtJTJDJTIwTG9nUHJvYkNoYXJOb3Jt",highlighted:`<span class="hljs-keyword">from</span> lighteval.tasks.lighteval_task <span class="hljs-keyword">import</span> LightevalTaskConfig
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.language <span class="hljs-keyword">import</span> Language
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.formulations <span class="hljs-keyword">import</span> MCFFormulation, CFFormulation, HybridFormulation
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.templates <span class="hljs-keyword">import</span> get_template_prompt_function
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.metrics <span class="hljs-keyword">import</span> get_metrics_for_formulation, loglikelihood_acc_metric
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.normalization <span class="hljs-keyword">import</span> LogProbTokenNorm, LogProbCharNorm`,wrap:!1}}),ml=new J({props:{title:"Step 3: Define Your Tasks",local:"step-3-define-your-tasks",headingTag:"h4"}}),Tl=new U({props:{code:"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",highlighted:`your_tasks = [
    LightevalTaskConfig(
        <span class="hljs-comment"># Name of your evaluation</span>
        name=<span class="hljs-string">f&quot;evalname_<span class="hljs-subst">{language.value}</span>_<span class="hljs-subst">{formulation.name.lower()}</span>&quot;</span>,
        <span class="hljs-comment"># This will automatically get the correct metrics for your chosen formulation</span>
        metric=get_metrics_for_formulation(
            formulation,
            [
                LogLikelihoodAccMetric(normalization=<span class="hljs-literal">None</span>),
                LogLikelihoodAccMetric(normalization=LogProbTokenNorm()),
                LogLikelihoodAccMetric(normalization=LogProbCharNorm()),
            ],
        ),
        <span class="hljs-comment"># In this function, you choose which template to follow and for which language and formulation</span>
        prompt_function=get_template_prompt_function(
            language=language,
            <span class="hljs-comment"># Use the adapter to define the mapping between the</span>
            <span class="hljs-comment"># keys of the template (left), and the keys of your dataset</span>
            <span class="hljs-comment"># (right)</span>
            <span class="hljs-comment"># To know which template keys are required and available,</span>
            <span class="hljs-comment"># consult the appropriate adapter type and doc-string.</span>
            adapter=<span class="hljs-keyword">lambda</span> line: {
                <span class="hljs-string">&quot;key&quot;</span>: line[<span class="hljs-string">&quot;relevant_key&quot;</span>],
                <span class="hljs-comment"># Add more mappings as needed</span>
            },
            formulation=formulation,
        ),
        <span class="hljs-comment"># You can also add specific filters to remove irrelevant samples</span>
        hf_filter=<span class="hljs-keyword">lambda</span> line: line[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">in</span> &lt;condition&gt;,
        <span class="hljs-comment"># You then select your huggingface dataset as well as</span>
        <span class="hljs-comment"># the splits available for evaluation</span>
        hf_repo=&lt;dataset&gt;,
        hf_subset=&lt;subset&gt;,
        evaluation_splits=[<span class="hljs-string">&quot;train&quot;</span>],
        hf_avail_splits=[<span class="hljs-string">&quot;train&quot;</span>],
    )
    <span class="hljs-keyword">for</span> language <span class="hljs-keyword">in</span> [
        Language.YOUR_LANGUAGE,  <span class="hljs-comment"># Add your target languages</span>
        <span class="hljs-comment"># Language.SPANISH,</span>
        <span class="hljs-comment"># Language.FRENCH,</span>
        <span class="hljs-comment"># etc.</span>
    ]
    <span class="hljs-keyword">for</span> formulation <span class="hljs-keyword">in</span> [MCFFormulation(), CFFormulation(), HybridFormulation()]
]`,wrap:!1}}),yl=new J({props:{title:"Step 4: Test Your Implementation",local:"step-4-test-your-implementation",headingTag:"h4"}}),Jl=new J({props:{title:"Validation Checklist",local:"validation-checklist",headingTag:"h3"}}),wl=new J({props:{title:"Getting Help",local:"getting-help",headingTag:"h3"}}),cl=new ne({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/contributing-to-multilingual-evaluations.mdx"}}),{c(){w=T("meta"),gl=a(),hl=T("p"),Il=a(),i(j.$$.fragment),fl=a(),i(g.$$.fragment),dl=a(),I=T("p"),I.textContent=$t,bl=a(),i(f.$$.fragment),Cl=a(),i(d.$$.fragment),$l=a(),b=T("p"),b.innerHTML=Gt,Gl=a(),C=T("p"),C.textContent=vt,vl=a(),$=T("ul"),$.innerHTML=kt,kl=a(),i(G.$$.fragment),Zl=a(),v=T("p"),v.textContent=Zt,Al=a(),k=T("ol"),k.innerHTML=At,Bl=a(),i(Z.$$.fragment),Wl=a(),i(A.$$.fragment),Fl=a(),i(B.$$.fragment),Xl=a(),i(W.$$.fragment),Yl=a(),F=T("p"),F.textContent=Bt,Sl=a(),X=T("ol"),X.innerHTML=Wt,Ql=a(),i(Y.$$.fragment),xl=a(),i(S.$$.fragment),Rl=a(),Q=T("p"),Q.innerHTML=Ft,Hl=a(),x=T("ul"),x.innerHTML=Xt,ql=a(),i(R.$$.fragment),Nl=a(),H=T("p"),H.textContent=Yt,El=a(),q=T("ul"),q.innerHTML=St,_l=a(),i(N.$$.fragment),Vl=a(),i(E.$$.fragment),zl=a(),_=T("p"),_.textContent=Qt,Ll=a(),i(V.$$.fragment),Dl=a(),z=T("p"),z.innerHTML=xt,Pl=a(),i(L.$$.fragment),Kl=a(),i(D.$$.fragment),Ol=a(),P=T("p"),P.textContent=Rt,lt=a(),i(K.$$.fragment),tt=a(),O=T("p"),O.innerHTML=Ht,et=a(),i(ll.$$.fragment),st=a(),i(tl.$$.fragment),at=a(),el=T("p"),el.textContent=qt,nt=a(),i(sl.$$.fragment),it=a(),al=T("p"),al.innerHTML=Nt,Mt=a(),i(nl.$$.fragment),ot=a(),i(il.$$.fragment),pt=a(),i(Ml.$$.fragment),rt=a(),ol=T("p"),ol.textContent=Et,mt=a(),i(pl.$$.fragment),Tt=a(),i(rl.$$.fragment),yt=a(),i(ml.$$.fragment),ut=a(),i(Tl.$$.fragment),Jt=a(),i(yl.$$.fragment),wt=a(),ul=T("p"),ul.textContent=_t,Ut=a(),c=T("blockquote"),c.innerHTML=Vt,ct=a(),i(Jl.$$.fragment),ht=a(),h=T("ul"),h.innerHTML=zt,jt=a(),i(wl.$$.fragment),gt=a(),Ul=T("ul"),Ul.innerHTML=Lt,It=a(),i(cl.$$.fragment),ft=a(),jl=T("p"),this.h()},l(l){const t=ee("svelte-u9bgzb",document.head);w=y(t,"META",{name:!0,content:!0}),t.forEach(e),gl=n(l),hl=y(l,"P",{}),Dt(hl).forEach(e),Il=n(l),M(j.$$.fragment,l),fl=n(l),M(g.$$.fragment,l),dl=n(l),I=y(l,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1re6ahv"&&(I.textContent=$t),bl=n(l),M(f.$$.fragment,l),Cl=n(l),M(d.$$.fragment,l),$l=n(l),b=y(l,"P",{"data-svelte-h":!0}),u(b)!=="svelte-119kr4u"&&(b.innerHTML=Gt),Gl=n(l),C=y(l,"P",{"data-svelte-h":!0}),u(C)!=="svelte-3mks6q"&&(C.textContent=vt),vl=n(l),$=y(l,"UL",{"data-svelte-h":!0}),u($)!=="svelte-1dsw83j"&&($.innerHTML=kt),kl=n(l),M(G.$$.fragment,l),Zl=n(l),v=y(l,"P",{"data-svelte-h":!0}),u(v)!=="svelte-awnkj1"&&(v.textContent=Zt),Al=n(l),k=y(l,"OL",{"data-svelte-h":!0}),u(k)!=="svelte-1s61htl"&&(k.innerHTML=At),Bl=n(l),M(Z.$$.fragment,l),Wl=n(l),M(A.$$.fragment,l),Fl=n(l),M(B.$$.fragment,l),Xl=n(l),M(W.$$.fragment,l),Yl=n(l),F=y(l,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1k1ke89"&&(F.textContent=Bt),Sl=n(l),X=y(l,"OL",{"data-svelte-h":!0}),u(X)!=="svelte-1v6bdr0"&&(X.innerHTML=Wt),Ql=n(l),M(Y.$$.fragment,l),xl=n(l),M(S.$$.fragment,l),Rl=n(l),Q=y(l,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-10zen67"&&(Q.innerHTML=Ft),Hl=n(l),x=y(l,"UL",{"data-svelte-h":!0}),u(x)!=="svelte-1pehqym"&&(x.innerHTML=Xt),ql=n(l),M(R.$$.fragment,l),Nl=n(l),H=y(l,"P",{"data-svelte-h":!0}),u(H)!=="svelte-fj6wl8"&&(H.textContent=Yt),El=n(l),q=y(l,"UL",{"data-svelte-h":!0}),u(q)!=="svelte-ewvrtu"&&(q.innerHTML=St),_l=n(l),M(N.$$.fragment,l),Vl=n(l),M(E.$$.fragment,l),zl=n(l),_=y(l,"P",{"data-svelte-h":!0}),u(_)!=="svelte-vecr4s"&&(_.textContent=Qt),Ll=n(l),M(V.$$.fragment,l),Dl=n(l),z=y(l,"P",{"data-svelte-h":!0}),u(z)!=="svelte-5gri02"&&(z.innerHTML=xt),Pl=n(l),M(L.$$.fragment,l),Kl=n(l),M(D.$$.fragment,l),Ol=n(l),P=y(l,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1616vrk"&&(P.textContent=Rt),lt=n(l),M(K.$$.fragment,l),tt=n(l),O=y(l,"P",{"data-svelte-h":!0}),u(O)!=="svelte-5gri02"&&(O.innerHTML=Ht),et=n(l),M(ll.$$.fragment,l),st=n(l),M(tl.$$.fragment,l),at=n(l),el=y(l,"P",{"data-svelte-h":!0}),u(el)!=="svelte-qvptvt"&&(el.textContent=qt),nt=n(l),M(sl.$$.fragment,l),it=n(l),al=y(l,"P",{"data-svelte-h":!0}),u(al)!=="svelte-5gri02"&&(al.innerHTML=Nt),Mt=n(l),M(nl.$$.fragment,l),ot=n(l),M(il.$$.fragment,l),pt=n(l),M(Ml.$$.fragment,l),rt=n(l),ol=y(l,"P",{"data-svelte-h":!0}),u(ol)!=="svelte-10cbov8"&&(ol.textContent=Et),mt=n(l),M(pl.$$.fragment,l),Tt=n(l),M(rl.$$.fragment,l),yt=n(l),M(ml.$$.fragment,l),ut=n(l),M(Tl.$$.fragment,l),Jt=n(l),M(yl.$$.fragment,l),wt=n(l),ul=y(l,"P",{"data-svelte-h":!0}),u(ul)!=="svelte-xvg35t"&&(ul.textContent=_t),Ut=n(l),c=y(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(c)!=="svelte-dyjpjk"&&(c.innerHTML=Vt),ct=n(l),M(Jl.$$.fragment,l),ht=n(l),h=y(l,"UL",{class:!0,"data-svelte-h":!0}),u(h)!=="svelte-18pkgkh"&&(h.innerHTML=zt),jt=n(l),M(wl.$$.fragment,l),gt=n(l),Ul=y(l,"UL",{"data-svelte-h":!0}),u(Ul)!=="svelte-47kvog"&&(Ul.innerHTML=Lt),It=n(l),M(cl.$$.fragment,l),ft=n(l),jl=y(l,"P",{}),Dt(jl).forEach(e),this.h()},h(){bt(w,"name","hf:doc:metadata"),bt(w,"content",Me),bt(c,"class","tip"),bt(h,"class","contains-task-list")},m(l,t){se(document.head,w),s(l,gl,t),s(l,hl,t),s(l,Il,t),o(j,l,t),s(l,fl,t),o(g,l,t),s(l,dl,t),s(l,I,t),s(l,bl,t),o(f,l,t),s(l,Cl,t),o(d,l,t),s(l,$l,t),s(l,b,t),s(l,Gl,t),s(l,C,t),s(l,vl,t),s(l,$,t),s(l,kl,t),o(G,l,t),s(l,Zl,t),s(l,v,t),s(l,Al,t),s(l,k,t),s(l,Bl,t),o(Z,l,t),s(l,Wl,t),o(A,l,t),s(l,Fl,t),o(B,l,t),s(l,Xl,t),o(W,l,t),s(l,Yl,t),s(l,F,t),s(l,Sl,t),s(l,X,t),s(l,Ql,t),o(Y,l,t),s(l,xl,t),o(S,l,t),s(l,Rl,t),s(l,Q,t),s(l,Hl,t),s(l,x,t),s(l,ql,t),o(R,l,t),s(l,Nl,t),s(l,H,t),s(l,El,t),s(l,q,t),s(l,_l,t),o(N,l,t),s(l,Vl,t),o(E,l,t),s(l,zl,t),s(l,_,t),s(l,Ll,t),o(V,l,t),s(l,Dl,t),s(l,z,t),s(l,Pl,t),o(L,l,t),s(l,Kl,t),o(D,l,t),s(l,Ol,t),s(l,P,t),s(l,lt,t),o(K,l,t),s(l,tt,t),s(l,O,t),s(l,et,t),o(ll,l,t),s(l,st,t),o(tl,l,t),s(l,at,t),s(l,el,t),s(l,nt,t),o(sl,l,t),s(l,it,t),s(l,al,t),s(l,Mt,t),o(nl,l,t),s(l,ot,t),o(il,l,t),s(l,pt,t),o(Ml,l,t),s(l,rt,t),s(l,ol,t),s(l,mt,t),o(pl,l,t),s(l,Tt,t),o(rl,l,t),s(l,yt,t),o(ml,l,t),s(l,ut,t),o(Tl,l,t),s(l,Jt,t),o(yl,l,t),s(l,wt,t),s(l,ul,t),s(l,Ut,t),s(l,c,t),s(l,ct,t),o(Jl,l,t),s(l,ht,t),s(l,h,t),s(l,jt,t),o(wl,l,t),s(l,gt,t),s(l,Ul,t),s(l,It,t),o(cl,l,t),s(l,ft,t),s(l,jl,t),dt=!0},p:Kt,i(l){dt||(p(j.$$.fragment,l),p(g.$$.fragment,l),p(f.$$.fragment,l),p(d.$$.fragment,l),p(G.$$.fragment,l),p(Z.$$.fragment,l),p(A.$$.fragment,l),p(B.$$.fragment,l),p(W.$$.fragment,l),p(Y.$$.fragment,l),p(S.$$.fragment,l),p(R.$$.fragment,l),p(N.$$.fragment,l),p(E.$$.fragment,l),p(V.$$.fragment,l),p(L.$$.fragment,l),p(D.$$.fragment,l),p(K.$$.fragment,l),p(ll.$$.fragment,l),p(tl.$$.fragment,l),p(sl.$$.fragment,l),p(nl.$$.fragment,l),p(il.$$.fragment,l),p(Ml.$$.fragment,l),p(pl.$$.fragment,l),p(rl.$$.fragment,l),p(ml.$$.fragment,l),p(Tl.$$.fragment,l),p(yl.$$.fragment,l),p(Jl.$$.fragment,l),p(wl.$$.fragment,l),p(cl.$$.fragment,l),dt=!0)},o(l){r(j.$$.fragment,l),r(g.$$.fragment,l),r(f.$$.fragment,l),r(d.$$.fragment,l),r(G.$$.fragment,l),r(Z.$$.fragment,l),r(A.$$.fragment,l),r(B.$$.fragment,l),r(W.$$.fragment,l),r(Y.$$.fragment,l),r(S.$$.fragment,l),r(R.$$.fragment,l),r(N.$$.fragment,l),r(E.$$.fragment,l),r(V.$$.fragment,l),r(L.$$.fragment,l),r(D.$$.fragment,l),r(K.$$.fragment,l),r(ll.$$.fragment,l),r(tl.$$.fragment,l),r(sl.$$.fragment,l),r(nl.$$.fragment,l),r(il.$$.fragment,l),r(Ml.$$.fragment,l),r(pl.$$.fragment,l),r(rl.$$.fragment,l),r(ml.$$.fragment,l),r(Tl.$$.fragment,l),r(yl.$$.fragment,l),r(Jl.$$.fragment,l),r(wl.$$.fragment,l),r(cl.$$.fragment,l),dt=!1},d(l){l&&(e(gl),e(hl),e(Il),e(fl),e(dl),e(I),e(bl),e(Cl),e($l),e(b),e(Gl),e(C),e(vl),e($),e(kl),e(Zl),e(v),e(Al),e(k),e(Bl),e(Wl),e(Fl),e(Xl),e(Yl),e(F),e(Sl),e(X),e(Ql),e(xl),e(Rl),e(Q),e(Hl),e(x),e(ql),e(Nl),e(H),e(El),e(q),e(_l),e(Vl),e(zl),e(_),e(Ll),e(Dl),e(z),e(Pl),e(Kl),e(Ol),e(P),e(lt),e(tt),e(O),e(et),e(st),e(at),e(el),e(nt),e(it),e(al),e(Mt),e(ot),e(pt),e(rt),e(ol),e(mt),e(Tt),e(yt),e(ut),e(Jt),e(wt),e(ul),e(Ut),e(c),e(ct),e(ht),e(h),e(jt),e(gt),e(Ul),e(It),e(ft),e(jl)),e(w),m(j,l),m(g,l),m(f,l),m(d,l),m(G,l),m(Z,l),m(A,l),m(B,l),m(W,l),m(Y,l),m(S,l),m(R,l),m(N,l),m(E,l),m(V,l),m(L,l),m(D,l),m(K,l),m(ll,l),m(tl,l),m(sl,l),m(nl,l),m(il,l),m(Ml,l),m(pl,l),m(rl,l),m(ml,l),m(Tl,l),m(yl,l),m(Jl,l),m(wl,l),m(cl,l)}}}const Me='{"title":"Contributing to Multilingual Evaluations","local":"contributing-to-multilingual-evaluations","sections":[{"title":"Contributing Translation Literals","local":"contributing-translation-literals","sections":[{"title":"What Are Translation Literals?","local":"what-are-translation-literals","sections":[],"depth":3},{"title":"How to Contribute Translations","local":"how-to-contribute-translations","sections":[],"depth":3},{"title":"Translation Literals Structure","local":"translation-literals-structure","sections":[],"depth":3}],"depth":2},{"title":"Contributing New Multilingual Tasks","local":"contributing-new-multilingual-tasks","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":3},{"title":"Key Concepts","local":"key-concepts","sections":[{"title":"Language-Adapted Templates","local":"language-adapted-templates","sections":[],"depth":4},{"title":"Template Types","local":"template-types","sections":[],"depth":4},{"title":"Formulation Types","local":"formulation-types","sections":[{"title":"Multiple Choice Formulation (MCF)","local":"multiple-choice-formulation-mcf","sections":[],"depth":5},{"title":"Classification Formulation (CF)","local":"classification-formulation-cf","sections":[],"depth":5},{"title":"Hybrid Formulation","local":"hybrid-formulation","sections":[],"depth":5}],"depth":4}],"depth":3},{"title":"Creating Your Multilingual Task","local":"creating-your-multilingual-task","sections":[{"title":"Step 1: Create the Task File","local":"step-1-create-the-task-file","sections":[],"depth":4},{"title":"Step 2: Import Required Components","local":"step-2-import-required-components","sections":[],"depth":4},{"title":"Step 3: Define Your Tasks","local":"step-3-define-your-tasks","sections":[],"depth":4},{"title":"Step 4: Test Your Implementation","local":"step-4-test-your-implementation","sections":[],"depth":4}],"depth":3},{"title":"Validation Checklist","local":"validation-checklist","sections":[],"depth":3},{"title":"Getting Help","local":"getting-help","sections":[],"depth":3}],"depth":2}],"depth":1}';function oe(Ct){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends le{constructor(w){super(),te(this,w,oe,ie,Pt,{})}}export{ye as component};
