# Security & Compliance

Inference Endpoints are built with security and secure inference at their core. Below you can find an overview of the security measures
we have in place.

## Data Security & Privacy

Hugging Face does not store any customer data in terms of payloads or tokens that are passed to the Inference Endpoint.
We are storing logs for 30 days. Every Inference Endpoints uses TLS/SSL to encrypt the data in transit.

We also recommend using AWS Private Link for organizations. This allows you to access your Inference Endpoint through a
private connection, without exposing it to the internet.

Hugging Face also offers GDPR data processing agreement through an Enterprise Hub subscription. For more information or to
subscribe to Enterprise Hub, please visit https://huggingface.co/enterprise.

## Model Security & Privacy

You can set a model repository as private if you do not want to publicly expose it. Hugging Face does not own any model or
data you upload to the Hugging Face Hub. Hugging Face also provides malware and pickle scans over the contents of the model
repository as with all items in the Hub.

## Inference Endpoints and Hub Security

The Hugging Face Hub and Inference Endpoints are SOC2 Type 2 certified. The Hugging Face Hub also offers Role Based Access Control. 

You can read more about security at Hugging Face in general in the following links:
- information on Hugging Face Hub security: https://huggingface.co/docs/hub/security. 
- information on the Enterprise Hub subscription and its premium security features: https://huggingface.co/docs/hub/enterprise-hub

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-soc-1.jpg" alt="soc-1" class="max-w-[300px] w-full" />
</div>

## Inference Endpoint Security Level

We currently offer many different ways of securing your Inference Endpoints through the configuration. Please read more about it in the Inference Endpoints
configuration [section under security](https://huggingface.co/docs/inference-endpoints/main/en/guides/configuration#security-level).

## Further Information

You can read the Hugging Face Privacy Policy at: https://huggingface.co/privacy


<EditOnGithub source="https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/guides/security.md" />