import{s as gn,o as hn,n as vn}from"../chunks/scheduler.7da89386.js";import{S as fn,i as bn,g as i,s as t,r as d,m as un,A as Tn,h as l,f as n,c as o,j as b,u as c,x as f,n as _n,k as T,y as a,a as s,v as u,d as _,t as g,w as h}from"../chunks/index.20910acc.js";import{T as cn}from"../chunks/Tip.53e22153.js";import{D as y}from"../chunks/Docstring.e298063a.js";import{C as yn}from"../chunks/CodeBlock.cde23137.js";import{H as Le,E as wn}from"../chunks/EditOnGithub.ba36cbd0.js";function $n(he){let v,w='The <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a> class is optimized for 🤗 Transformers models running on Habana Gaudi.';return{c(){v=i("p"),v.innerHTML=w},l($){v=l($,"P",{"data-svelte-h":!0}),f(v)!=="svelte-e68t6e"&&(v.innerHTML=w)},m($,ve){s($,v,ve)},p:vn,d($){$&&n(v)}}}function xn(he){let v;return{c(){v=un(`If your predictions or labels have different sequence lengths (for instance because you're doing dynamic
padding in a token classification task) the predictions will be padded (on the right) to allow for
concatenation into one array. The padding index is -100.`)},l(w){v=_n(w,`If your predictions or labels have different sequence lengths (for instance because you're doing dynamic
padding in a token classification task) the predictions will be padded (on the right) to allow for
concatenation into one array. The padding index is -100.`)},m(w,$){s(w,v,$)},d(w){w&&n(v)}}}function On(he){let v,w,$,ve,D,De,z,Ea='The <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a> class provides an extended API for the feature-complete <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Transformers Trainer</a>. It is used in all the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">example scripts</a>.',ze,P,Wa='Before instantiating your <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a>, create a <a href="/docs/optimum.habana/pr_1074/en/package_reference/trainer#optimum.habana.GaudiTrainingArguments">GaudiTrainingArguments</a> object to access all the points of customization during training.',Pe,F,Ee,E,Va='Here is an example of how to customize <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a> to use a weighted loss (useful when you have an unbalanced training set):',We,W,Ve,V,Ba='Another way to customize the training loop behavior for the PyTorch <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a> is to use <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">callbacks</a> that can inspect the training loop state (for progress reporting, logging on TensorBoard or other ML platforms…) and take decisions (like early stopping).',Be,B,Re,m,R,ua,fe,Ra=`GaudiTrainer is built on top of the tranformers’ Trainer to enable
deployment on Habana’s Gaudi.`,_a,U,Z,ga,be,Za=`A helper wrapper that creates an appropriate context manager for <code>autocast</code> while feeding it the desired
arguments, depending on the situation. Modified by Habana to enable using <code>autocast</code> on Gaudi devices.`,ha,N,X,va,Te,Xa='From <a href="https://github.com/huggingface/transformers/blob/v4.38.2/src/transformers/trainer.py#L3162" rel="nofollow">https://github.com/huggingface/transformers/blob/v4.38.2/src/transformers/trainer.py#L3162</a> with the following modification',fa,ye,Ya="<li>comment out TPU related</li> <li>use throughput_warmup_steps in evaluation throughput calculation</li>",ba,q,Y,Ta,we,Qa=`Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.
Works both with or without labels.`,ya,I,Q,wa,$e,Ka=`Log <code>logs</code> on the various objects watching training.
Subclass and override this method to inject custom behavior.`,$a,S,K,xa,xe,en=`Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.
Works both with or without labels.`,Oa,J,ee,ka,Oe,an=`Perform an evaluation step on <code>model</code> using <code>inputs</code>.
Subclass and override to inject custom behavior.`,Na,A,ae,Ma,ke,nn=`Will save the model, so you can reload it using <code>from_pretrained()</code>.
Will only save from the main process.`,Ga,H,ne,Fa,Ne,tn="Main training entry point.",Ua,M,te,qa,Me,on="Perform a training step on a batch of inputs.",Ia,Ge,rn="Subclass and override to inject custom behavior.",Ze,oe,Xe,x,re,Sa,C,ie,Ja,Fe,ln=`Run evaluation and returns metrics.
The calling script will be responsible for providing a method to compute metrics, as they are task-dependent
(pass it to the init <code>compute_metrics</code> argument).
You can also subclass and override this method to inject custom behavior.`,Aa,O,le,Ha,Ue,sn=`Run prediction and returns predictions and potential metrics.
Depending on the dataset and your use case, your test dataset may contain labels. In that case, this method
will also return metrics, like in <code>evaluate()</code>.`,Ca,j,ja,Ye,se,Qe,G,me,La,qe,mn=`GaudiTrainingArguments is built on top of the Tranformers’ <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>
to enable deployment on Habana’s Gaudi.`,Ke,pe,ea,k,de,Da,Ie,pn=`GaudiSeq2SeqTrainingArguments is built on top of the Tranformers’ <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">Seq2SeqTrainingArguments</a>
to enable deployment on Habana’s Gaudi.`,za,L,ce,Pa,Se,dn=`Serializes this instance while replace <code>Enum</code> by their values and <code>GaudiGenerationConfig</code> by dictionaries (for JSON
serialization support). It obfuscates the token values by removing their value.`,aa,ue,na,je,ta;return D=new Le({props:{title:"GaudiTrainer",local:"gauditrainer",headingTag:"h1"}}),F=new cn({props:{warning:!0,$$slots:{default:[$n]},$$scope:{ctx:he}}}),W=new yn({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEFmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMEElMEElMEFjbGFzcyUyMEN1c3RvbUdhdWRpVHJhaW5lcihHYXVkaVRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9sb3NzKHNlbGYlMkMlMjBtb2RlbCUyQyUyMGlucHV0cyUyQyUyMHJldHVybl9vdXRwdXRzJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwaW5wdXRzLmdldCglMjJsYWJlbHMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5nZXQoJTIybG9naXRzJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBjdXN0b20lMjBsb3NzJTIwKHN1cHBvc2UlMjBvbmUlMjBoYXMlMjAzJTIwbGFiZWxzJTIwd2l0aCUyMGRpZmZlcmVudCUyMHdlaWdodHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zc19mY3QlMjAlM0QlMjBubi5Dcm9zc0VudHJvcHlMb3NzKHdlaWdodCUzRHRvcmNoLnRlbnNvciglNUIxLjAlMkMlMjAyLjAlMkMlMjAzLjAlNUQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2ZjdChsb2dpdHMudmlldygtMSUyQyUyMHNlbGYubW9kZWwuY29uZmlnLm51bV9sYWJlbHMpJTJDJTIwbGFiZWxzLnZpZXcoLTEpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMChsb3NzJTJDJTIwb3V0cHV0cyklMjBpZiUyMHJldHVybl9vdXRwdXRzJTIwZWxzZSUyMGxvc3M=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> optimum.habana <span class="hljs-keyword">import</span> GaudiTrainer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomGaudiTrainer</span>(<span class="hljs-title class_ inherited__">GaudiTrainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        labels = inputs.get(<span class="hljs-string">&quot;labels&quot;</span>)
        <span class="hljs-comment"># forward pass</span>
        outputs = model(**inputs)
        logits = outputs.get(<span class="hljs-string">&quot;logits&quot;</span>)
        <span class="hljs-comment"># compute custom loss (suppose one has 3 labels with different weights)</span>
        loss_fct = nn.CrossEntropyLoss(weight=torch.tensor([<span class="hljs-number">1.0</span>, <span class="hljs-number">2.0</span>, <span class="hljs-number">3.0</span>]))
        loss = loss_fct(logits.view(-<span class="hljs-number">1</span>, self.model.config.num_labels), labels.view(-<span class="hljs-number">1</span>))
        <span class="hljs-keyword">return</span> (loss, outputs) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),B=new Le({props:{title:"GaudiTrainer",local:"optimum.habana.GaudiTrainer",headingTag:"h2"}}),R=new y({props:{name:"class optimum.habana.GaudiTrainer",anchor:"optimum.habana.GaudiTrainer",parameters:[{name:"model",val:": Union = None"},{name:"gaudi_config",val:": GaudiConfig = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Union = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L175"}}),Z=new y({props:{name:"autocast_smart_context_manager",anchor:"optimum.habana.GaudiTrainer.autocast_smart_context_manager",parameters:[{name:"cache_enabled",val:": Optional = True"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L1513"}}),X=new y({props:{name:"evaluate",anchor:"optimum.habana.GaudiTrainer.evaluate",parameters:[{name:"eval_dataset",val:": Union = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L1668"}}),Y=new y({props:{name:"evaluation_loop",anchor:"optimum.habana.GaudiTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L1735"}}),Q=new y({props:{name:"log",anchor:"optimum.habana.GaudiTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L1471"}}),K=new y({props:{name:"prediction_loop",anchor:"optimum.habana.GaudiTrainer.prediction_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L2101"}}),ee=new y({props:{name:"prediction_step",anchor:"optimum.habana.GaudiTrainer.prediction_step",parameters:[{name:"model",val:": Module"},{name:"inputs",val:": Dict"},{name:"prediction_loss_only",val:": bool"},{name:"ignore_keys",val:": Optional = None"}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainer.prediction_step.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to evaluate.`,name:"model"},{anchor:"optimum.habana.GaudiTrainer.prediction_step.inputs",description:`<strong>inputs</strong> (<code>Dict[str, Union[torch.Tensor, Any]]</code>) &#x2014;
The inputs and targets of the model.
The dictionary will be unpacked before being fed to the model. Most models expect the targets under the
argument <code>labels</code>. Check your model&#x2019;s documentation for all accepted arguments.`,name:"inputs"},{anchor:"optimum.habana.GaudiTrainer.prediction_step.prediction_loss_only",description:`<strong>prediction_loss_only</strong> (<code>bool</code>) &#x2014;
Whether or not to return the loss only.`,name:"prediction_loss_only"},{anchor:"optimum.habana.GaudiTrainer.prediction_step.ignore_keys",description:`<strong>ignore_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys in the output of your model (if it is a dictionary) that should be ignored when
gathering predictions.`,name:"ignore_keys"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L1952",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple with the loss,
logits and labels (each being optional).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Tuple[Optional[torch.Tensor], Optional[torch.Tensor], Optional[torch.Tensor]]</p>
`}}),ae=new y({props:{name:"save_model",anchor:"optimum.habana.GaudiTrainer.save_model",parameters:[{name:"output_dir",val:": Optional = None"},{name:"_internal_call",val:": bool = False"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L1585"}}),ne=new y({props:{name:"train",anchor:"optimum.habana.GaudiTrainer.train",parameters:[{name:"resume_from_checkpoint",val:": Union = None"},{name:"trial",val:": Union = None"},{name:"ignore_keys_for_eval",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainer.train.resume_from_checkpoint",description:`<strong>resume_from_checkpoint</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
If a <code>str</code>, local path to a saved checkpoint as saved by a previous instance of <code>Trainer</code>. If a
<code>bool</code> and equals <code>True</code>, load the last checkpoint in <em>args.output_dir</em> as saved by a previous instance
of <code>Trainer</code>. If present, training will resume from the model/optimizer/scheduler states loaded here.`,name:"resume_from_checkpoint"},{anchor:"optimum.habana.GaudiTrainer.train.trial",description:`<strong>trial</strong> (<code>optuna.Trial</code> or <code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The trial run or the hyperparameter dictionary for hyperparameter search.`,name:"trial"},{anchor:"optimum.habana.GaudiTrainer.train.ignore_keys_for_eval",description:`<strong>ignore_keys_for_eval</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys in the output of your model (if it is a dictionary) that should be ignored when
gathering predictions for evaluation during the training.`,name:"ignore_keys_for_eval"},{anchor:"optimum.habana.GaudiTrainer.train.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments used to hide deprecated arguments`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L439"}}),te=new y({props:{name:"training_step",anchor:"optimum.habana.GaudiTrainer.training_step",parameters:[{name:"model",val:": Module"},{name:"inputs",val:": Dict"}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainer.training_step.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to train.`,name:"model"},{anchor:"optimum.habana.GaudiTrainer.training_step.inputs",description:`<strong>inputs</strong> (<code>Dict[str, Union[torch.Tensor, Any]]</code>) &#x2014;
The inputs and targets of the model.</p>
<p>The dictionary will be unpacked before being fed to the model. Most models expect the targets under the
argument <code>labels</code>. Check your model&#x2019;s documentation for all accepted arguments.`,name:"inputs"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer.py#L1532",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor with training loss on this batch.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),oe=new Le({props:{title:"GaudiSeq2SeqTrainer",local:"optimum.habana.GaudiSeq2SeqTrainer",headingTag:"h2"}}),re=new y({props:{name:"class optimum.habana.GaudiSeq2SeqTrainer",anchor:"optimum.habana.GaudiSeq2SeqTrainer",parameters:[{name:"model",val:": Union = None"},{name:"gaudi_config",val:": GaudiConfig = None"},{name:"args",val:": GaudiTrainingArguments = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer_seq2seq.py#L45"}}),ie=new y({props:{name:"evaluate",anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate",parameters:[{name:"eval_dataset",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"},{name:"**gen_kwargs",val:""}],parametersDescription:[{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.eval_dataset",description:`<strong>eval_dataset</strong> (<code>Dataset</code>, <em>optional</em>) &#x2014;
Pass a dataset if you wish to override <code>self.eval_dataset</code>. If it is an <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns
not accepted by the <code>model.forward()</code> method are automatically removed. It must implement the <code>__len__</code>
method.`,name:"eval_dataset"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.ignore_keys",description:`<strong>ignore_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys in the output of your model (if it is a dictionary) that should be ignored when
gathering predictions.`,name:"ignore_keys"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.metric_key_prefix",description:`<strong>metric_key_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;eval&quot;</code>) &#x2014;
An optional prefix to be used as the metrics key prefix. For example the metrics &#x201C;bleu&#x201D; will be named
&#x201C;eval_bleu&#x201D; if the prefix is <code>&quot;eval&quot;</code> (default)`,name:"metric_key_prefix"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum target length to use when predicting with the generate method.`,name:"max_length"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams for beam search that will be used when predicting with the generate method. 1 means no
beam search.
gen_kwargs &#x2014;
Additional <code>generate</code> specific kwargs.`,name:"num_beams"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer_seq2seq.py#L131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the evaluation loss and the potential metrics computed from the predictions. The
dictionary also contains the epoch number which comes from the training state.</p>
`}}),le=new y({props:{name:"predict",anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict",parameters:[{name:"test_dataset",val:": Dataset"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'test'"},{name:"**gen_kwargs",val:""}],parametersDescription:[{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.test_dataset",description:`<strong>test_dataset</strong> (<code>Dataset</code>) &#x2014;
Dataset to run the predictions on. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted by the
<code>model.forward()</code> method are automatically removed. Has to implement the method <code>__len__</code>`,name:"test_dataset"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.ignore_keys",description:`<strong>ignore_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys in the output of your model (if it is a dictionary) that should be ignored when
gathering predictions.`,name:"ignore_keys"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.metric_key_prefix",description:`<strong>metric_key_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;eval&quot;</code>) &#x2014;
An optional prefix to be used as the metrics key prefix. For example the metrics &#x201C;bleu&#x201D; will be named
&#x201C;eval_bleu&#x201D; if the prefix is <code>&quot;eval&quot;</code> (default)`,name:"metric_key_prefix"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum target length to use when predicting with the generate method.`,name:"max_length"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams for beam search that will be used when predicting with the generate method. 1 means no
beam search.
gen_kwargs &#x2014;
Additional <code>generate</code> specific kwargs.`,name:"num_beams"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/trainer_seq2seq.py#L183"}}),j=new cn({props:{$$slots:{default:[xn]},$$scope:{ctx:he}}}),se=new Le({props:{title:"GaudiTrainingArguments",local:"optimum.habana.GaudiTrainingArguments",headingTag:"h2"}}),me=new y({props:{name:"class optimum.habana.GaudiTrainingArguments",anchor:"optimum.habana.GaudiTrainingArguments",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": Optional = 1e-06"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": Optional = False"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'hpu_amp'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = 'hccl'"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = False"},{name:"ddp_bucket_cap_mb",val:": Optional = 230"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"use_habana",val:": Optional = False"},{name:"gaudi_config_name",val:": Optional = None"},{name:"use_lazy_mode",val:": Optional = True"},{name:"use_hpu_graphs",val:": Optional = False"},{name:"use_hpu_graphs_for_inference",val:": Optional = False"},{name:"use_hpu_graphs_for_training",val:": Optional = False"},{name:"disable_tensor_cache_hpu_graphs",val:": Optional = False"},{name:"max_hpu_graphs",val:": Optional = None"},{name:"distribution_strategy",val:": Optional = 'ddp'"},{name:"throughput_warmup_steps",val:": Optional = 0"},{name:"adjust_throughput",val:": bool = False"},{name:"pipelining_fwd_bwd",val:": Optional = False"},{name:"ignore_eos",val:": Optional = True"},{name:"non_blocking_data_copy",val:": Optional = False"},{name:"profiling_warmup_steps",val:": Optional = 0"},{name:"profiling_steps",val:": Optional = 0"},{name:"profiling_record_shapes",val:": Optional = True"},{name:"fp8",val:": Optional = False"}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainingArguments.use_habana",description:`<strong>use_habana</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Habana&#x2019;s HPU for running the model.`,name:"use_habana"},{anchor:"optimum.habana.GaudiTrainingArguments.gaudi_config_name",description:`<strong>gaudi_config_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pretrained Gaudi config name or path.`,name:"gaudi_config_name"},{anchor:"optimum.habana.GaudiTrainingArguments.use_lazy_mode",description:`<strong>use_lazy_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use lazy mode for running the model.`,name:"use_lazy_mode"},{anchor:"optimum.habana.GaudiTrainingArguments.use_hpu_graphs",description:`<strong>use_hpu_graphs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Deprecated, use <code>use_hpu_graphs_for_inference</code> instead. Whether to use HPU graphs for performing inference.`,name:"use_hpu_graphs"},{anchor:"optimum.habana.GaudiTrainingArguments.use_hpu_graphs_for_inference",description:`<strong>use_hpu_graphs_for_inference</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use HPU graphs for performing inference. It will speed up latency but may not be compatible with some operations.`,name:"use_hpu_graphs_for_inference"},{anchor:"optimum.habana.GaudiTrainingArguments.use_hpu_graphs_for_training",description:`<strong>use_hpu_graphs_for_training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use HPU graphs for performing inference. It will speed up training but may not be compatible with some operations.`,name:"use_hpu_graphs_for_training"},{anchor:"optimum.habana.GaudiTrainingArguments.disable_tensor_cache_hpu_graphs",description:`<strong>disable_tensor_cache_hpu_graphs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to disable tensor cache when using hpu graphs. If True, tensors won&#x2019;t be cached in hpu graph and memory can be saved.`,name:"disable_tensor_cache_hpu_graphs"},{anchor:"optimum.habana.GaudiTrainingArguments.max_hpu_graphs",description:`<strong>max_hpu_graphs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of hpu graphs to be cached. Reduce to save device memory.`,name:"max_hpu_graphs"},{anchor:"optimum.habana.GaudiTrainingArguments.distribution_strategy",description:`<strong>distribution_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>ddp</code>) &#x2014;
Determines how data parallel distributed training is achieved. May be: <code>ddp</code> or <code>fast_ddp</code>.`,name:"distribution_strategy"},{anchor:"optimum.habana.GaudiTrainingArguments.throughput_warmup_steps",description:`<strong>throughput_warmup_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of steps to ignore for throughput calculation. For example, with <code>throughput_warmup_steps=N</code>,
the first N steps will not be considered in the calculation of the throughput. This is especially
useful in lazy mode where the first two or three iterations typically take longer.`,name:"throughput_warmup_steps"},{anchor:"optimum.habana.GaudiTrainingArguments.adjust_throughput",description:`<strong>adjust_throughput</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to remove the time taken for logging, evaluating and saving from throughput calculation.`,name:"adjust_throughput"},{anchor:"optimum.habana.GaudiTrainingArguments.pipelining_fwd_bwd",description:`<strong>pipelining_fwd_bwd</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an additional <code>mark_step</code> between forward and backward for pipelining
host backward building and HPU forward computing.`,name:"pipelining_fwd_bwd"},{anchor:"optimum.habana.GaudiTrainingArguments.non_blocking_data_copy",description:`<strong>non_blocking_data_copy</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to enable async data copy when preparing inputs.`,name:"non_blocking_data_copy"},{anchor:"optimum.habana.GaudiTrainingArguments.profiling_warmup_steps",description:`<strong>profiling_warmup_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of steps to ignore for profling.`,name:"profiling_warmup_steps"},{anchor:"optimum.habana.GaudiTrainingArguments.profiling_steps",description:`<strong>profiling_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of steps to be captured when enabling profiling.`,name:"profiling_steps"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/training_args.py#L81"}}),pe=new Le({props:{title:"GaudiSeq2SeqTrainingArguments",local:"optimum.habana.GaudiSeq2SeqTrainingArguments",headingTag:"h2"}}),de=new y({props:{name:"class optimum.habana.GaudiSeq2SeqTrainingArguments",anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": Optional = 1e-06"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": Optional = False"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'hpu_amp'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = 'hccl'"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = False"},{name:"ddp_bucket_cap_mb",val:": Optional = 230"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"use_habana",val:": Optional = False"},{name:"gaudi_config_name",val:": Optional = None"},{name:"use_lazy_mode",val:": Optional = True"},{name:"use_hpu_graphs",val:": Optional = False"},{name:"use_hpu_graphs_for_inference",val:": Optional = False"},{name:"use_hpu_graphs_for_training",val:": Optional = False"},{name:"disable_tensor_cache_hpu_graphs",val:": Optional = False"},{name:"max_hpu_graphs",val:": Optional = None"},{name:"distribution_strategy",val:": Optional = 'ddp'"},{name:"throughput_warmup_steps",val:": Optional = 0"},{name:"adjust_throughput",val:": bool = False"},{name:"pipelining_fwd_bwd",val:": Optional = False"},{name:"ignore_eos",val:": Optional = True"},{name:"non_blocking_data_copy",val:": Optional = False"},{name:"profiling_warmup_steps",val:": Optional = 0"},{name:"profiling_steps",val:": Optional = 0"},{name:"profiling_record_shapes",val:": Optional = True"},{name:"fp8",val:": Optional = False"},{name:"sortish_sampler",val:": bool = False"},{name:"predict_with_generate",val:": bool = False"},{name:"generation_max_length",val:": Optional = None"},{name:"generation_num_beams",val:": Optional = None"},{name:"generation_config",val:": Union = None"}],parametersDescription:[{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.sortish_sampler",description:`<strong>sortish_sampler</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a <em>sortish sampler</em> or not. Only possible if the underlying datasets are <em>Seq2SeqDataset</em>
for now but will become generally available in the near future.
It sorts the inputs according to lengths in order to minimize the padding size, with a bit of randomness
for the training set.`,name:"sortish_sampler"},{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.predict_with_generate",description:`<strong>predict_with_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use generate to calculate generative metrics (ROUGE, BLEU).`,name:"predict_with_generate"},{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.generation_max_length",description:`<strong>generation_max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The <code>max_length</code> to use on each evaluation loop when <code>predict_with_generate=True</code>. Will default to the
<code>max_length</code> value of the model configuration.`,name:"generation_max_length"},{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.generation_num_beams",description:`<strong>generation_num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The <code>num_beams</code> to use on each evaluation loop when <code>predict_with_generate=True</code>. Will default to the
<code>num_beams</code> value of the model configuration.`,name:"generation_num_beams"},{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.generation_config",description:`<strong>generation_config</strong> (<code>str</code> or <code>Path</code> or <code>transformers.generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
Allows to load a <code>transformers.generation.GenerationConfig</code> from the <code>from_pretrained</code> method. This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained" rel="nofollow">transformers.GenerationConfig.save_pretrained</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a <code>transformers.generation.GenerationConfig</code> object.</li>
</ul>`,name:"generation_config"}],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/training_args_seq2seq.py#L29"}}),ce=new y({props:{name:"to_dict",anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.to_dict",parameters:[],source:"https://github.com/huggingface/optimum-habana/blob/vr_1074/optimum/habana/transformers/training_args_seq2seq.py#L88"}}),ue=new wn({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/package_reference/trainer.mdx"}}),{c(){v=i("meta"),w=t(),$=i("p"),ve=t(),d(D.$$.fragment),De=t(),z=i("p"),z.innerHTML=Ea,ze=t(),P=i("p"),P.innerHTML=Wa,Pe=t(),d(F.$$.fragment),Ee=t(),E=i("p"),E.innerHTML=Va,We=t(),d(W.$$.fragment),Ve=t(),V=i("p"),V.innerHTML=Ba,Be=t(),d(B.$$.fragment),Re=t(),m=i("div"),d(R.$$.fragment),ua=t(),fe=i("p"),fe.textContent=Ra,_a=t(),U=i("div"),d(Z.$$.fragment),ga=t(),be=i("p"),be.innerHTML=Za,ha=t(),N=i("div"),d(X.$$.fragment),va=t(),Te=i("p"),Te.innerHTML=Xa,fa=t(),ye=i("ol"),ye.innerHTML=Ya,ba=t(),q=i("div"),d(Y.$$.fragment),Ta=t(),we=i("p"),we.innerHTML=Qa,ya=t(),I=i("div"),d(Q.$$.fragment),wa=t(),$e=i("p"),$e.innerHTML=Ka,$a=t(),S=i("div"),d(K.$$.fragment),xa=t(),xe=i("p"),xe.innerHTML=en,Oa=t(),J=i("div"),d(ee.$$.fragment),ka=t(),Oe=i("p"),Oe.innerHTML=an,Na=t(),A=i("div"),d(ae.$$.fragment),Ma=t(),ke=i("p"),ke.innerHTML=nn,Ga=t(),H=i("div"),d(ne.$$.fragment),Fa=t(),Ne=i("p"),Ne.textContent=tn,Ua=t(),M=i("div"),d(te.$$.fragment),qa=t(),Me=i("p"),Me.textContent=on,Ia=t(),Ge=i("p"),Ge.textContent=rn,Ze=t(),d(oe.$$.fragment),Xe=t(),x=i("div"),d(re.$$.fragment),Sa=t(),C=i("div"),d(ie.$$.fragment),Ja=t(),Fe=i("p"),Fe.innerHTML=ln,Aa=t(),O=i("div"),d(le.$$.fragment),Ha=t(),Ue=i("p"),Ue.innerHTML=sn,Ca=t(),d(j.$$.fragment),ja=un("\nReturns: *NamedTuple* A namedtuple with the following keys:\n- predictions (`np.ndarray`): The predictions on `test_dataset`.\n- label_ids (`np.ndarray`, *optional*): The labels (if the dataset contained some).\n- metrics (`Dict[str, float]`, *optional*): The potential dictionary of metrics (if the dataset contained\n  labels)."),Ye=t(),d(se.$$.fragment),Qe=t(),G=i("div"),d(me.$$.fragment),La=t(),qe=i("p"),qe.innerHTML=mn,Ke=t(),d(pe.$$.fragment),ea=t(),k=i("div"),d(de.$$.fragment),Da=t(),Ie=i("p"),Ie.innerHTML=pn,za=t(),L=i("div"),d(ce.$$.fragment),Pa=t(),Se=i("p"),Se.innerHTML=dn,aa=t(),d(ue.$$.fragment),na=t(),je=i("p"),this.h()},l(e){const r=Tn("svelte-u9bgzb",document.head);v=l(r,"META",{name:!0,content:!0}),r.forEach(n),w=o(e),$=l(e,"P",{}),b($).forEach(n),ve=o(e),c(D.$$.fragment,e),De=o(e),z=l(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1vnhui8"&&(z.innerHTML=Ea),ze=o(e),P=l(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-150ujvh"&&(P.innerHTML=Wa),Pe=o(e),c(F.$$.fragment,e),Ee=o(e),E=l(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1jtax1u"&&(E.innerHTML=Va),We=o(e),c(W.$$.fragment,e),Ve=o(e),V=l(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-lfoibw"&&(V.innerHTML=Ba),Be=o(e),c(B.$$.fragment,e),Re=o(e),m=l(e,"DIV",{class:!0});var p=b(m);c(R.$$.fragment,p),ua=o(p),fe=l(p,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1j23w6z"&&(fe.textContent=Ra),_a=o(p),U=l(p,"DIV",{class:!0});var _e=b(U);c(Z.$$.fragment,_e),ga=o(_e),be=l(_e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-15ifl0d"&&(be.innerHTML=Za),_e.forEach(n),ha=o(p),N=l(p,"DIV",{class:!0});var Je=b(N);c(X.$$.fragment,Je),va=o(Je),Te=l(Je,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-vxpl2h"&&(Te.innerHTML=Xa),fa=o(Je),ye=l(Je,"OL",{"data-svelte-h":!0}),f(ye)!=="svelte-vzrmm3"&&(ye.innerHTML=Ya),Je.forEach(n),ba=o(p),q=l(p,"DIV",{class:!0});var oa=b(q);c(Y.$$.fragment,oa),Ta=o(oa),we=l(oa,"P",{"data-svelte-h":!0}),f(we)!=="svelte-1379lme"&&(we.innerHTML=Qa),oa.forEach(n),ya=o(p),I=l(p,"DIV",{class:!0});var ra=b(I);c(Q.$$.fragment,ra),wa=o(ra),$e=l(ra,"P",{"data-svelte-h":!0}),f($e)!=="svelte-1uoczj7"&&($e.innerHTML=Ka),ra.forEach(n),$a=o(p),S=l(p,"DIV",{class:!0});var ia=b(S);c(K.$$.fragment,ia),xa=o(ia),xe=l(ia,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1379lme"&&(xe.innerHTML=en),ia.forEach(n),Oa=o(p),J=l(p,"DIV",{class:!0});var la=b(J);c(ee.$$.fragment,la),ka=o(la),Oe=l(la,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-qt0zbt"&&(Oe.innerHTML=an),la.forEach(n),Na=o(p),A=l(p,"DIV",{class:!0});var sa=b(A);c(ae.$$.fragment,sa),Ma=o(sa),ke=l(sa,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-45fu3d"&&(ke.innerHTML=nn),sa.forEach(n),Ga=o(p),H=l(p,"DIV",{class:!0});var ma=b(H);c(ne.$$.fragment,ma),Fa=o(ma),Ne=l(ma,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-1cilnet"&&(Ne.textContent=tn),ma.forEach(n),Ua=o(p),M=l(p,"DIV",{class:!0});var Ae=b(M);c(te.$$.fragment,Ae),qa=o(Ae),Me=l(Ae,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-4qplkw"&&(Me.textContent=on),Ia=o(Ae),Ge=l(Ae,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-qjfexy"&&(Ge.textContent=rn),Ae.forEach(n),p.forEach(n),Ze=o(e),c(oe.$$.fragment,e),Xe=o(e),x=l(e,"DIV",{class:!0});var He=b(x);c(re.$$.fragment,He),Sa=o(He),C=l(He,"DIV",{class:!0});var pa=b(C);c(ie.$$.fragment,pa),Ja=o(pa),Fe=l(pa,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-1pw2jj7"&&(Fe.innerHTML=ln),pa.forEach(n),Aa=o(He),O=l(He,"DIV",{class:!0});var ge=b(O);c(le.$$.fragment,ge),Ha=o(ge),Ue=l(ge,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-12trqag"&&(Ue.innerHTML=sn),Ca=o(ge),c(j.$$.fragment,ge),ja=_n(ge,"\nReturns: *NamedTuple* A namedtuple with the following keys:\n- predictions (`np.ndarray`): The predictions on `test_dataset`.\n- label_ids (`np.ndarray`, *optional*): The labels (if the dataset contained some).\n- metrics (`Dict[str, float]`, *optional*): The potential dictionary of metrics (if the dataset contained\n  labels)."),ge.forEach(n),He.forEach(n),Ye=o(e),c(se.$$.fragment,e),Qe=o(e),G=l(e,"DIV",{class:!0});var da=b(G);c(me.$$.fragment,da),La=o(da),qe=l(da,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-1pjgb0w"&&(qe.innerHTML=mn),da.forEach(n),Ke=o(e),c(pe.$$.fragment,e),ea=o(e),k=l(e,"DIV",{class:!0});var Ce=b(k);c(de.$$.fragment,Ce),Da=o(Ce),Ie=l(Ce,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1bpl5s2"&&(Ie.innerHTML=pn),za=o(Ce),L=l(Ce,"DIV",{class:!0});var ca=b(L);c(ce.$$.fragment,ca),Pa=o(ca),Se=l(ca,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-1cdlr91"&&(Se.innerHTML=dn),ca.forEach(n),Ce.forEach(n),aa=o(e),c(ue.$$.fragment,e),na=o(e),je=l(e,"P",{}),b(je).forEach(n),this.h()},h(){T(v,"name","hf:doc:metadata"),T(v,"content",kn),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){a(document.head,v),s(e,w,r),s(e,$,r),s(e,ve,r),u(D,e,r),s(e,De,r),s(e,z,r),s(e,ze,r),s(e,P,r),s(e,Pe,r),u(F,e,r),s(e,Ee,r),s(e,E,r),s(e,We,r),u(W,e,r),s(e,Ve,r),s(e,V,r),s(e,Be,r),u(B,e,r),s(e,Re,r),s(e,m,r),u(R,m,null),a(m,ua),a(m,fe),a(m,_a),a(m,U),u(Z,U,null),a(U,ga),a(U,be),a(m,ha),a(m,N),u(X,N,null),a(N,va),a(N,Te),a(N,fa),a(N,ye),a(m,ba),a(m,q),u(Y,q,null),a(q,Ta),a(q,we),a(m,ya),a(m,I),u(Q,I,null),a(I,wa),a(I,$e),a(m,$a),a(m,S),u(K,S,null),a(S,xa),a(S,xe),a(m,Oa),a(m,J),u(ee,J,null),a(J,ka),a(J,Oe),a(m,Na),a(m,A),u(ae,A,null),a(A,Ma),a(A,ke),a(m,Ga),a(m,H),u(ne,H,null),a(H,Fa),a(H,Ne),a(m,Ua),a(m,M),u(te,M,null),a(M,qa),a(M,Me),a(M,Ia),a(M,Ge),s(e,Ze,r),u(oe,e,r),s(e,Xe,r),s(e,x,r),u(re,x,null),a(x,Sa),a(x,C),u(ie,C,null),a(C,Ja),a(C,Fe),a(x,Aa),a(x,O),u(le,O,null),a(O,Ha),a(O,Ue),a(O,Ca),u(j,O,null),a(O,ja),s(e,Ye,r),u(se,e,r),s(e,Qe,r),s(e,G,r),u(me,G,null),a(G,La),a(G,qe),s(e,Ke,r),u(pe,e,r),s(e,ea,r),s(e,k,r),u(de,k,null),a(k,Da),a(k,Ie),a(k,za),a(k,L),u(ce,L,null),a(L,Pa),a(L,Se),s(e,aa,r),u(ue,e,r),s(e,na,r),s(e,je,r),ta=!0},p(e,[r]){const p={};r&2&&(p.$$scope={dirty:r,ctx:e}),F.$set(p);const _e={};r&2&&(_e.$$scope={dirty:r,ctx:e}),j.$set(_e)},i(e){ta||(_(D.$$.fragment,e),_(F.$$.fragment,e),_(W.$$.fragment,e),_(B.$$.fragment,e),_(R.$$.fragment,e),_(Z.$$.fragment,e),_(X.$$.fragment,e),_(Y.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(ae.$$.fragment,e),_(ne.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(j.$$.fragment,e),_(se.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(ue.$$.fragment,e),ta=!0)},o(e){g(D.$$.fragment,e),g(F.$$.fragment,e),g(W.$$.fragment,e),g(B.$$.fragment,e),g(R.$$.fragment,e),g(Z.$$.fragment,e),g(X.$$.fragment,e),g(Y.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(j.$$.fragment,e),g(se.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(ue.$$.fragment,e),ta=!1},d(e){e&&(n(w),n($),n(ve),n(De),n(z),n(ze),n(P),n(Pe),n(Ee),n(E),n(We),n(Ve),n(V),n(Be),n(Re),n(m),n(Ze),n(Xe),n(x),n(Ye),n(Qe),n(G),n(Ke),n(ea),n(k),n(aa),n(na),n(je)),n(v),h(D,e),h(F,e),h(W,e),h(B,e),h(R),h(Z),h(X),h(Y),h(Q),h(K),h(ee),h(ae),h(ne),h(te),h(oe,e),h(re),h(ie),h(le),h(j),h(se,e),h(me),h(pe,e),h(de),h(ce),h(ue,e)}}}const kn='{"title":"GaudiTrainer","local":"gauditrainer","sections":[{"title":"GaudiTrainer","local":"optimum.habana.GaudiTrainer","sections":[],"depth":2},{"title":"GaudiSeq2SeqTrainer","local":"optimum.habana.GaudiSeq2SeqTrainer","sections":[],"depth":2},{"title":"GaudiTrainingArguments","local":"optimum.habana.GaudiTrainingArguments","sections":[],"depth":2},{"title":"GaudiSeq2SeqTrainingArguments","local":"optimum.habana.GaudiSeq2SeqTrainingArguments","sections":[],"depth":2}],"depth":1}';function Nn(he){return hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sn extends fn{constructor(v){super(),bn(this,v,Nn,On,gn,{})}}export{Sn as component};
