import{s as re,n as me,o as ue}from"../chunks/scheduler.7da89386.js";import{S as pe,i as he,g as s,s as i,r as j,A as fe,h as o,f as t,c as n,j as ne,u as Z,x as m,k as se,y as ce,a as l,v as W,d as B,t as I,w as x}from"../chunks/index.20910acc.js";import{C as oe}from"../chunks/CodeBlock.cde23137.js";import{H as L,E as de}from"../chunks/EditOnGithub.ba36cbd0.js";function ge(P){let r,_,G,C,u,R,p,q=`🤗 Optimum Habana was designed with one goal in mind: <strong>making training and evaluation straightforward for any 🤗 Transformers user while leveraging the complete power of Gaudi processors</strong>.
There are two main classes one needs to know:`,H,h,K='<li><a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer" rel="nofollow"><code>GaudiTrainer</code></a>: the trainer class that takes care of compiling (lazy or eager mode) and distributing the model to run on HPUs, and of performing training and evaluation.</li> <li><a href="https://huggingface.co/docs/optimum/habana/package_reference/gaudi_config" rel="nofollow"><code>GaudiConfig</code></a>: the class that enables to configure Habana Mixed Precision and to decide whether optimized operators and optimizers should be used or not.</li>',k,f,O=`The <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer" rel="nofollow"><code>GaudiTrainer</code></a> is very similar to the <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">🤗 Transformers Trainer</a>, and adapting a script using the Trainer to make it work with Gaudi will mostly consist in simply swapping the <code>Trainer</code> class for the <code>GaudiTrainer</code> one.
That is how most of the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">example scripts</a> were adapted from their <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch" rel="nofollow">original counterparts</a>.`,E,c,$,d,ee='where <code>gaudi_config_name</code> is the name of a model from the <a href="https://huggingface.co/Habana" rel="nofollow">Hub</a> (Gaudi configurations are stored in model repositories) or a path to a local Gaudi configuration file (you can see <a href="./package_reference/gaudi_config">here</a> how to write your own).',S,g,X,M,ae=`🤗 Optimum Habana also features HPU-optimized support for the 🤗 Diffusers library.
Thus, you can easily deploy Stable Diffusion on Gaudi for performing text-to-image generation.`,v,b,te="Here is how to use it and the differences with the 🤗 Diffusers library:",Q,y,z,w,Y,T,le="Here are examples for various modalities and tasks that can be used out of the box:",A,J,ie='<li>Text<ul><li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/text-classification" rel="nofollow">text classification</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/question-answering" rel="nofollow">question answering</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/language-modeling" rel="nofollow">language modeling</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/text-generation" rel="nofollow">text generation</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/summarization" rel="nofollow">summarization</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/translation" rel="nofollow">translation</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/protein-folding" rel="nofollow">protein folding</a></li></ul></li> <li>Images<ul><li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/image-classification" rel="nofollow">image classification</a></li></ul></li> <li>Audio<ul><li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/audio-classification" rel="nofollow">audio classification</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/speech-recognition" rel="nofollow">speech recognition</a></li></ul></li> <li>Text and images<ul><li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/stable-diffusion" rel="nofollow">text-to-image generation</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/contrastive-image-text" rel="nofollow">contrastive image-text training</a>.</li></ul></li>',D,U,N,V,F;return u=new L({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),c=new oe({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMkMlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIzJTIwRGVmaW5lJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMlMEEtJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyQiUyMHRyYWluaW5nX2FyZ3MlMjAlM0QlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzKCUwQSUyQiUyMCUyMCUyMHVzZV9oYWJhbmElM0RUcnVlJTJDJTBBJTJCJTIwJTIwJTIwdXNlX2xhenlfbW9kZSUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjBnYXVkaV9jb25maWdfbmFtZSUzRGdhdWRpX2NvbmZpZ19uYW1lJTJDJTBBJTIwJTIwLi4uJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBvdXIlMjBUcmFpbmVyJTBBLSUyMHRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyQiUyMHRyYWluZXIlMjAlM0QlMjBHYXVkaVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMEElMjAlMjAlMjAlMjAuLi4lMjAlMjMlMjBvdGhlciUyMGFyZ3VtZW50cyUwQSk=",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.habana import GaudiTrainer, GaudiTrainingArguments</span>

# Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = GaudiTrainingArguments(</span>
<span class="hljs-addition">+   use_habana=True,</span>
<span class="hljs-addition">+   use_lazy_mode=True,</span>
<span class="hljs-addition">+   gaudi_config_name=gaudi_config_name,</span>
  ...
)

# Initialize our Trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = GaudiTrainer(</span>
    model=model,
    args=training_args,
    train_dataset=train_dataset
    ... # other arguments
)`,wrap:!1}}),g=new L({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),y=new oe({props:{code:"LSUyMGZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBERElNU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmEuZGlmZnVzZXJzJTIwaW1wb3J0JTIwR2F1ZGlERElNU2NoZWR1bGVyJTJDJTIwR2F1ZGlTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTBBJTBBLSUyMHNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBJTJCJTIwc2NoZWR1bGVyJTIwJTNEJTIwR2F1ZGlERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQSUwQS0lMjBwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMkIlMjBwaXBlbGluZSUyMCUzRCUyMEdhdWRpU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMEElMkIlMjAlMjAlMjB1c2VfaGFiYW5hJTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMHVzZV9ocHVfZ3JhcGhzJTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMGdhdWRpX2NvbmZpZyUzRCUyMkhhYmFuYSUyRnN0YWJsZS1kaWZmdXNpb24lMjIlMkMlMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCU1QiUyMkFuJTIwaW1hZ2UlMjBvZiUyMGElMjBzcXVpcnJlbCUyMGluJTIwUGljYXNzbyUyMHN0eWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMTYlMkMlMEElMkIlMjAlMjAlMjBiYXRjaF9zaXplJTNENCUyQyUwQSk=",highlighted:`<span class="hljs-deletion">- from diffusers import DDIMScheduler, StableDiffusionPipeline</span>
<span class="hljs-addition">+ from optimum.habana.diffusers import GaudiDDIMScheduler, GaudiStableDiffusionPipeline</span>


model_name = &quot;CompVis/stable-diffusion-v1-4&quot;

<span class="hljs-deletion">- scheduler = DDIMScheduler.from_pretrained(model_name, subfolder=&quot;scheduler&quot;)</span>
<span class="hljs-addition">+ scheduler = GaudiDDIMScheduler.from_pretrained(model_name, subfolder=&quot;scheduler&quot;)</span>

<span class="hljs-deletion">- pipeline = StableDiffusionPipeline.from_pretrained(</span>
<span class="hljs-addition">+ pipeline = GaudiStableDiffusionPipeline.from_pretrained(</span>
    model_name,
    scheduler=scheduler,
<span class="hljs-addition">+   use_habana=True,</span>
<span class="hljs-addition">+   use_hpu_graphs=True,</span>
<span class="hljs-addition">+   gaudi_config=&quot;Habana/stable-diffusion&quot;,</span>
)

outputs = pipeline(
    [&quot;An image of a squirrel in Picasso style&quot;],
    num_images_per_prompt=16,
<span class="hljs-addition">+   batch_size=4,</span>
)`,wrap:!1}}),w=new L({props:{title:"Ready-to-Use Examples",local:"ready-to-use-examples",headingTag:"h2"}}),U=new de({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/quickstart.mdx"}}),{c(){r=s("meta"),_=i(),G=s("p"),C=i(),j(u.$$.fragment),R=i(),p=s("p"),p.innerHTML=q,H=i(),h=s("ul"),h.innerHTML=K,k=i(),f=s("p"),f.innerHTML=O,E=i(),j(c.$$.fragment),$=i(),d=s("p"),d.innerHTML=ee,S=i(),j(g.$$.fragment),X=i(),M=s("p"),M.textContent=ae,v=i(),b=s("p"),b.textContent=te,Q=i(),j(y.$$.fragment),z=i(),j(w.$$.fragment),Y=i(),T=s("p"),T.textContent=le,A=i(),J=s("ul"),J.innerHTML=ie,D=i(),j(U.$$.fragment),N=i(),V=s("p"),this.h()},l(e){const a=fe("svelte-u9bgzb",document.head);r=o(a,"META",{name:!0,content:!0}),a.forEach(t),_=n(e),G=o(e,"P",{}),ne(G).forEach(t),C=n(e),Z(u.$$.fragment,e),R=n(e),p=o(e,"P",{"data-svelte-h":!0}),m(p)!=="svelte-e8hfpw"&&(p.innerHTML=q),H=n(e),h=o(e,"UL",{"data-svelte-h":!0}),m(h)!=="svelte-1w7hiz"&&(h.innerHTML=K),k=n(e),f=o(e,"P",{"data-svelte-h":!0}),m(f)!=="svelte-11lkuqj"&&(f.innerHTML=O),E=n(e),Z(c.$$.fragment,e),$=n(e),d=o(e,"P",{"data-svelte-h":!0}),m(d)!=="svelte-jrct53"&&(d.innerHTML=ee),S=n(e),Z(g.$$.fragment,e),X=n(e),M=o(e,"P",{"data-svelte-h":!0}),m(M)!=="svelte-1ae8t87"&&(M.textContent=ae),v=n(e),b=o(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-2jvm77"&&(b.textContent=te),Q=n(e),Z(y.$$.fragment,e),z=n(e),Z(w.$$.fragment,e),Y=n(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-iafmur"&&(T.textContent=le),A=n(e),J=o(e,"UL",{"data-svelte-h":!0}),m(J)!=="svelte-bx3b0y"&&(J.innerHTML=ie),D=n(e),Z(U.$$.fragment,e),N=n(e),V=o(e,"P",{}),ne(V).forEach(t),this.h()},h(){se(r,"name","hf:doc:metadata"),se(r,"content",Me)},m(e,a){ce(document.head,r),l(e,_,a),l(e,G,a),l(e,C,a),W(u,e,a),l(e,R,a),l(e,p,a),l(e,H,a),l(e,h,a),l(e,k,a),l(e,f,a),l(e,E,a),W(c,e,a),l(e,$,a),l(e,d,a),l(e,S,a),W(g,e,a),l(e,X,a),l(e,M,a),l(e,v,a),l(e,b,a),l(e,Q,a),W(y,e,a),l(e,z,a),W(w,e,a),l(e,Y,a),l(e,T,a),l(e,A,a),l(e,J,a),l(e,D,a),W(U,e,a),l(e,N,a),l(e,V,a),F=!0},p:me,i(e){F||(B(u.$$.fragment,e),B(c.$$.fragment,e),B(g.$$.fragment,e),B(y.$$.fragment,e),B(w.$$.fragment,e),B(U.$$.fragment,e),F=!0)},o(e){I(u.$$.fragment,e),I(c.$$.fragment,e),I(g.$$.fragment,e),I(y.$$.fragment,e),I(w.$$.fragment,e),I(U.$$.fragment,e),F=!1},d(e){e&&(t(_),t(G),t(C),t(R),t(p),t(H),t(h),t(k),t(f),t(E),t($),t(d),t(S),t(X),t(M),t(v),t(b),t(Q),t(z),t(Y),t(T),t(A),t(J),t(D),t(N),t(V)),t(r),x(u,e),x(c,e),x(g,e),x(y,e),x(w,e),x(U,e)}}}const Me='{"title":"Quickstart","local":"quickstart","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[],"depth":2},{"title":"Ready-to-Use Examples","local":"ready-to-use-examples","sections":[],"depth":2}],"depth":1}';function be(P){return ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends pe{constructor(r){super(),he(this,r,be,ge,re,{})}}export{Ue as component};
