import{s as gs,n as Js,o as bs}from"../chunks/scheduler.6efaaf90.js";import{S as vs,i as js,e as a,s,c as r,h as $s,a as o,d as l,b as i,f as hn,g as p,j as u,k as Mt,l as yn,m as n,n as c,t as d,o as M,p as m}from"../chunks/index.eb3e1f0f.js";import{C as Is,H as y,E as As}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.bc356b46.js";import{C as h}from"../chunks/CodeBlock.1ecb727a.js";function Vs(Tn){let T,yt,mt,Tt,g,ft,J,Ut,b,fn='Deploying Text Embeddings Inference (TEI) on Google Cloud Platform (GCP) allows to benefit from the underlying <a href="https://kubernetes.io/" rel="nofollow">Kubernetes</a> technology which ensures that TEI can scale automatically up or down based on demand.',Ct,v,Un="On Google Cloud, there are 3 main options for deploying TEI (or any other Docker container):",wt,j,Cn="<li>Cloud Run</li> <li>Vertex AI endpoints</li> <li>GKE (Google Kubernetes Engine).</li>",gt,$,wn="This guide explains how to deploy TEI on Cloud Run, a fully managed service by Google. Cloud Run is a so-called serverless offering. This means that the server infrastructure is handled by Google, you only need to provide a Docker container. The benefit of this is that you only pay for compute when there is demand for your application. Cloud Run will automatically spin up servers when there’s demand, and scale down to zero when there is no demand.",Jt,I,gn="We will showcase how to deploy any text embedding model with or without a GPU.",bt,U,Jn='<p>At the time of writing, GPU support on Cloud Run is generally available in 4 regions. If you’re interested in using it, <a href="https://cloud.google.com/run/quotas#increase" rel="nofollow">request a quota increase</a> for <code>Total Nvidia L4 GPU allocation, per project per region</code>. So far, NVIDIA L4 GPUs (24GiB VRAM) are the only available GPUs on Cloud Run; enabling automatic scaling up to 7 instances by default (more available via quota), as well as scaling down to zero instances when there are no requests.</p>',vt,A,jt,V,bn='This guide already assumes you have set up a Google Cloud project and have enabled billing. This can be done at <a href="https://console.cloud.google.com/" rel="nofollow">https://console.cloud.google.com/</a>.',$t,E,vn='First, you need to install the <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">gcloud CLI</a> on your local machine. This allows to programmatically interact with your Google Cloud project.',It,R,jn="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",At,N,Vt,Z,$n="Some clarifications:",Et,x,In='<li>We provide the latest official Docker image URI based on the <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/containers/tei/README.md" rel="nofollow">README</a>.</li> <li>We choose to deploy the <a href="https://huggingface.co/ibm-granite/granite-embedding-278m-multilingual" rel="nofollow">IBM granite</a> embedding model given its strong multilingual capabilities. One can of course choose any other embedding model from the hub. It’s recommended to look for models tagged with either <code>feature-extraction</code>, <code>sentence-similarity</code> or <code>text-ranking</code>.</li>',Rt,S,An="Then you need to login into your Google Cloud account and set the project ID you want to use to deploy Cloud Run.",Nt,L,Zt,k,Vn="Once you are logged in, you need to enable the Cloud Run API, which is required for the Hugging Face DLC for TEI deployment on Cloud Run.",xt,G,St,W,Lt,_,En="Once you are all set, you can call the <code>gcloud run deploy</code> command to deploy the Docker image.",kt,Q,Rn="The command needs you to specify the following parameters:",Gt,B,Nn=`<li><code>--image</code>: The container image URI to deploy.</li> <li><code>--args</code>: The arguments to pass to the container entrypoint, being <code>text-embeddings-inference</code> for the Hugging Face DLC for TEI. Read more about the supported arguments <a href="https://huggingface.co/docs/text-embeddings-inference/cli_arguments" rel="nofollow">here</a>.
<ul><li><code>--model-id</code>: The model ID to use, in this case, <a href="https://huggingface.co/ibm-granite/granite-embedding-278m-multilingual" rel="nofollow"><code>ibm-granite/granite-embedding-278m-multilingual</code></a>.</li> <li><code>--quantize</code>: The quantization method to use. If not specified, it will be retrieved from the <code>quantization_config-&gt;quant_method</code> in the <code>config.json</code> file.</li> <li><code>--max-concurrent-requests</code>: The maximum amount of concurrent requests for this particular deployment. Having a low limit will refuse clients requests instead of having them wait for too long and is usually good to handle back pressure correctly. Set to 64, but default is 128.</li></ul></li> <li><code>--port</code>: The port the container listens to.</li> <li><code>--cpu</code> and <code>--memory</code>: The number of CPUs and amount of memory to allocate to the container. Needs to be set to 4 and 16Gi (16 GiB), respectively; as that’s the minimum requirement for using the GPU.</li> <li><code>--no-cpu-throttling</code>: Disables CPU throttling, which is required for using the GPU.</li> <li><code>--gpu</code> and <code>--gpu-type</code>: The number of GPUs and the GPU type to use. Needs to be set to 1 and <code>nvidia-l4</code>, respectively; as at the time of writing this tutorial, those are the only available options as Cloud Run on GPUs.</li> <li><code>--max-instances</code>: The maximum number of instances to run, set to 3, but default maximum value is 7. Alternatively, one could set it to 1 too, but that could eventually lead to downtime during infrastructure migrations, so anything above 1 is recommended.</li> <li><code>--concurrency</code>: the maximum number of concurrent requests per instance, set to 64. Note that this value is also aligned with the <a href="https://huggingface.co/docs/text-embeddings-inference/cli_arguments" rel="nofollow"><code>--max-concurrent-requests</code></a> argument in TEI.</li> <li><code>--region</code>: The region to deploy the Cloud Run service.</li> <li><code>--no-allow-unauthenticated</code>: Disables unauthenticated access to the service, which is a good practice as adds an authentication layer managed by Google Cloud IAM.</li>`,Wt,f,dt,Zn='Optionally, you can include the arguments <code>--vpc-egress=all-traffic</code> and <code>--subnet=default</code>, as there is external traffic being sent to the public internet, so in order to speed the network, you need to route all traffic through the VPC network by setting those flags. Note that besides setting the flags, you need to set up Google Cloud NAT to reach the public internet, which is a paid product. Find more information in <a href="https://cloud.google.com/run/docs/configuring/networking-best-practices" rel="nofollow">Cloud Run Documentation - Networking best practices</a>.',mn,X,_t,F,xn="Finally, you can run the <code>gcloud run deploy</code> command to deploy TEI on Cloud Run as:",Qt,q,Bt,H,Sn="If you want to deploy with a GPU, run the following command:",Xt,P,Ft,O,Ln="Or as it follows if you created the Cloud NAT:",qt,Y,Ht,C,kn="<p>The first time you deploy a new container on Cloud Run it will take around 5 minutes to deploy as it needs to import it from the Google Cloud Artifact Registry, but on the follow up deployments it will take less time as the image has been already imported before.</p>",Pt,D,Ot,z,Gn='Once deployed, you can send requests to the service via any of the supported TEI endpoints, check TEI’s <a href="https://huggingface.github.io/text-embeddings-inference/" rel="nofollow">OpenAPI Specification</a> to see all the available endpoints and their respective parameters.',Yt,K,Wn="All Cloud Run services are deployed privately by default, which means that they can’t be accessed without providing authentication credentials in the request headers. These services are secured by IAM and are only callable by Project Owners, Project Editors, and Cloud Run Admins and Cloud Run Invokers.",Dt,ee,_n="In this case, a couple of alternatives to enable developer access will be showcased; while the other use cases are out of the scope of this example, as those are either not secure due to the authentication being disabled (for public access scenarios), or require additional setup for production-ready scenarios (service-to-service authentication, end-user access).",zt,w,Qn='<p>The alternatives mentioned below are for development scenarios, and should not be used in production-ready scenarios as is. The approach below is following the guide defined in <a href="https://cloud.google.com/run/docs/authenticating/developers" rel="nofollow">Cloud Run Documentation - Authenticate Developers</a>; but you can find every other guide as mentioned above in <a href="https://cloud.google.com/run/docs/authenticating/overview" rel="nofollow">Cloud Run Documentation - Authentication overview</a>.</p>',Kt,te,el,le,Bn="Cloud Run Proxy runs a server on localhost that proxies requests to the specified Cloud Run Service with credentials attached; which is useful for testing and experimentation.",tl,ne,ll,se,Xn="Then you can send requests to the deployed service on Cloud Run, using the http://localhost:8080 URL, with no authentication, exposed by the proxy as shown in the examples below. You can check the API docs at http://localhost:8080/docs in your browser.",nl,ie,sl,ae,Fn="To send a POST request to the TEI service using cURL, you can run the following command:",il,oe,al,ue,qn="Alternatively, one can also send requests to the OpenAI-compatible endpoint:",ol,re,ul,pe,rl,ce,Hn='To run inference using Python, you can either use the <a href="https://huggingface.co/docs/huggingface_hub/en/index" rel="nofollow">huggingface_hub</a> Python SDK (recommended) or the openai Python SDK.',pl,de,cl,Me,Pn="You can install it via pip as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",dl,me,Ml,he,ml,ye,On="You can install it via pip as <code>pip install --upgrade openai</code>, and then run:",hl,Te,yl,fe,Tl,Ue,Yn="Cloud Run Service has an unique URL assigned that can be used to send requests from anywhere, using the Google Cloud Credentials with Cloud Run Invoke access to the service; which is the recommended approach as it’s more secure and consistent than using the Cloud Run Proxy.",fl,Ce,Dn="The URL of the Cloud Run service can be obtained via the following command (assigned to the SERVICE_URL variable for convenience):",Ul,we,Cl,ge,zn="Then you can send requests to the deployed service on Cloud Run, using the <code>SERVICE_URL</code> and any Google Cloud Credentials with Cloud Run Invoke access. For setting up the credentials there are multiple approaches, some of those are listed below:",wl,Je,Kn="Using the default identity token from the Google Cloud SDK:",gl,be,es="<li>Via gcloud as:</li>",Jl,ve,bl,je,ts="<li>Via Python as:</li>",vl,$e,jl,Ie,ls="<li>Using a Service Account with Cloud Run Invoke access, which can either be done with any of the following approaches:</li>",$l,Ae,ns="<strong>Create a Service Account before the Cloud Run Service was created, and then set the service-account flag to the Service Account email when creating the Cloud Run Service. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</strong> Create a Service Account after the Cloud Run Service was created, and then update the Cloud Run Service to use the Service Account. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.",Il,Ve,ss="The recommended approach is to use a Service Account (SA), as the access can be controlled better and the permissions are more granular; as the Cloud Run Service was not created using a SA, which is another nice option, you need to now create the SA, gran it the necessary permissions, update the Cloud Run Service to use the SA, and then generate an access token to set as the authentication token within the requests, that can be revoked later once you are done using it.",Al,Ee,is="<li>Set the SERVICE_ACCOUNT_NAME environment variable for convenience:</li>",Vl,Re,El,Ne,as="<li>Create the Service Account:</li>",Rl,Ze,Nl,xe,os="<li>Grant the Service Account the Cloud Run Invoker role:</li>",Zl,Se,xl,Le,us="Generate the Access Token for the Service Account:",Sl,ke,Ll,Ge,rs="<p>The access token is short-lived and will expire, by default after 1 hour. If you want to extend the token lifetime beyond the default, you must create and organization policy and use the —lifetime argument when creating the token. Refer to Access token lifetime to learn more. Otherwise, you can also generate a new token by running the same command again.</p>",kl,We,ps="Now you can already dive into the different alternatives for sending the requests to the deployed Cloud Run Service using the <code>SERVICE_URL</code> AND <code>ACCESS_TOKEN</code> as described above.",Gl,_e,Wl,Qe,cs="To send a POST request to the TEI service using cURL, you can run the following command:",_l,Be,Ql,Xe,Bl,Fe,ds='To run inference using Python, you can either use the <a href="https://huggingface.co/docs/huggingface_hub/en/index" rel="nofollow">huggingface_hub</a> Python SDK (recommended) or the openai Python SDK.',Xl,qe,Fl,He,Ms="You can install it via pip as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",ql,Pe,Hl,Oe,Pl,Ye,ms="You can install it via pip as <code>pip install --upgrade openai</code>, and then run:",Ol,De,Yl,ze,Dl,Ke,hs="Finally, once you are done using TEI on the Cloud Run Service, you can safely delete it to avoid incurring in unnecessary costs e.g. if the Cloud Run services are inadvertently invoked more times than your monthly Cloud Run invoke allocation in the free tier.",zl,et,ys='To delete the Cloud Run Service you can either go to the Google Cloud Console at <a href="https://console.cloud.google.com/run" rel="nofollow">https://console.cloud.google.com/run</a> and delete it manually; or use the Google Cloud SDK via gcloud as follows:',Kl,tt,en,lt,Ts="Additionally, if you followed the steps in via Cloud Run Service URL and generated a Service Account and an access token, you can either remove the Service Account, or just revoke the access token if it is still valid.",tn,nt,fs="<li>(recommended) Revoke the Access Token as:</li>",ln,st,nn,it,Us="<li>(optional) Delete the Service Account as:</li>",sn,at,an,ot,Cs="Finally, if you decided to enable the VPC network via Cloud NAT, you can also remove the Cloud NAT (which is a paid product) as:",on,ut,un,rt,rn,pt,ws='<li><a href="https://cloud.google.com/run/docs" rel="nofollow">Cloud Run documentation - Overview</a></li> <li><a href="https://cloud.google.com/run/docs/configuring/services/gpu" rel="nofollow">Cloud Run documentation - GPU services</a></li> <li><a href="https://cloud.google.com/blog/products/application-development/run-your-ai-inference-applications-on-cloud-run-with-nvidia-gpus" rel="nofollow">Google Cloud blog - Run your AI inference applications on Cloud Run with NVIDIA GPUs</a></li>',pn,ct,cn,ht,dn;return g=new Is({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new y({props:{title:"Deploying TEI on Google Cloud Run",local:"deploying-tei-on-google-cloud-run",headingTag:"h1"}}),A=new y({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),N=new h({props:{code:"ZXhwb3J0JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQWV4cG9ydCUyMExPQ0FUSU9OJTNEZXVyb3BlLXdlc3QxJTIwJTIwJTIzJTIwb3IlMjBhbnklMjBsb2NhdGlvbiUyMHlvdSUyMHByZWZlciUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQuZ29vZ2xlLmNvbSUyRnJ1biUyRmRvY3MlMkZsb2NhdGlvbnMlMEFleHBvcnQlMjBDT05UQUlORVJfVVJJJTNEJTIyZ2NyLmlvJTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZodWdnaW5nZmFjZS10ZXh0LWVtYmVkZGluZ3MtaW5mZXJlbmNlLWNwdS4xLTYlMjIlMEFleHBvcnQlMjBTRVJWSUNFX05BTUUlM0QlMjJ0ZXh0LWVtYmVkZGluZy1zZXJ2ZXIlMjIlMjAlMjMlMjBjaG9vc2UlMjBhJTIwbmFtZSUyMGZvciUyMHlvdXIlMjBzZXJ2aWNlJTBBZXhwb3J0JTIwTU9ERUxfSUQlM0QlMjJpYm0tZ3Jhbml0ZSUyRmdyYW5pdGUtZW1iZWRkaW5nLTI3OG0tbXVsdGlsaW5ndWFsJTIyJTIwJTIzJTIwY2hvb3NlJTIwYW55JTIwZW1iZWRkaW5nJTIwbW9kZWw=",highlighted:`<span class="hljs-built_in">export</span> PROJECT_ID=your-project-id
<span class="hljs-built_in">export</span> LOCATION=europe-west1  <span class="hljs-comment"># or any location you prefer: https://cloud.google.com/run/docs/locations</span>
<span class="hljs-built_in">export</span> CONTAINER_URI=<span class="hljs-string">&quot;gcr.io/deeplearning-platform-release/huggingface-text-embeddings-inference-cpu.1-6&quot;</span>
<span class="hljs-built_in">export</span> SERVICE_NAME=<span class="hljs-string">&quot;text-embedding-server&quot;</span> <span class="hljs-comment"># choose a name for your service</span>
<span class="hljs-built_in">export</span> MODEL_ID=<span class="hljs-string">&quot;ibm-granite/granite-embedding-278m-multilingual&quot;</span> <span class="hljs-comment"># choose any embedding model</span>`,wrap:!1}}),L=new h({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMGxvZ2luJTBBZ2Nsb3VkJTIwYXV0aCUyMGFwcGxpY2F0aW9uLWRlZmF1bHQlMjBsb2dpbiUyMCUyMCUyMyUyMEZvciUyMGxvY2FsJTIwZGV2ZWxvcG1lbnQlMEFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`gcloud auth login
gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
gcloud config <span class="hljs-built_in">set</span> project <span class="hljs-variable">$PROJECT_ID</span>`,wrap:!1}}),G=new h({props:{code:"Z2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBydW4uZ29vZ2xlYXBpcy5jb20=",highlighted:'gcloud services <span class="hljs-built_in">enable</span> run.googleapis.com',wrap:!1}}),W=new y({props:{title:"Deploy TEI on Cloud Run",local:"deploy-tei-on-cloud-run",headingTag:"h2"}}),X=new h({props:{code:"Z2Nsb3VkJTIwY29tcHV0ZSUyMHJvdXRlcnMlMjBjcmVhdGUlMjBuYXQtcm91dGVyJTIwLS1uZXR3b3JrJTNEZGVmYXVsdCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMEFnY2xvdWQlMjBjb21wdXRlJTIwcm91dGVycyUyMG5hdHMlMjBjcmVhdGUlMjB2bS1uYXQlMjAtLXJvdXRlciUzRG5hdC1yb3V0ZXIlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9OJTIwLS1hdXRvLWFsbG9jYXRlLW5hdC1leHRlcm5hbC1pcHMlMjAtLW5hdC1hbGwtc3VibmV0LWlwLXJhbmdlcw==",highlighted:`gcloud compute routers create nat-router --network=default --region=<span class="hljs-variable">$LOCATION</span>
gcloud compute routers nats create vm-nat --router=nat-router --region=<span class="hljs-variable">$LOCATION</span> --auto-allocate-nat-external-ips --nat-all-subnet-ip-ranges`,wrap:!1}}),q=new h({props:{code:"Z2Nsb3VkJTIwcnVuJTIwZGVwbG95JTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1pbWFnZSUzRCUyNENPTlRBSU5FUl9VUkklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWFyZ3MlM0QlMjItLW1vZGVsLWlkJTNEJTI0TU9ERUxfSUQlMkMtLW1heC1jb25jdXJyZW50LXJlcXVlc3RzJTNENjQlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNldC1lbnYtdmFycyUzREhGX0hVQl9FTkFCTEVfSEZfVFJBTlNGRVIlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNEOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMzJHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),P=new h({props:{code:"Z2Nsb3VkJTIwcnVuJTIwZGVwbG95JTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1pbWFnZSUzRCUyNENPTlRBSU5FUl9VUkklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWFyZ3MlM0QlMjItLW1vZGVsLWlkJTNEJTI0TU9ERUxfSUQlMkMtLW1heC1jb25jdXJyZW50LXJlcXVlc3RzJTNENjQlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNldC1lbnYtdmFycyUzREhGX0hVQl9FTkFCTEVfSEZfVFJBTlNGRVIlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNEOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMzJHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbm8tY3B1LXRocm90dGxpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdSUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdS10eXBlJTNEbnZpZGlhLWw0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXgtaW5zdGFuY2VzJTNEMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY29uY3VycmVuY3klM0Q2NCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),Y=new h({props:{code:"Z2Nsb3VkJTIwYmV0YSUyMHJ1biUyMGRlcGxveSUyMCUyNFNFUlZJQ0VfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taW1hZ2UlM0QlMjRDT05UQUlORVJfVVJJJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1hcmdzJTNEJTIyLS1tb2RlbC1pZCUzRCUyNE1PREVMX0lEJTJDLS1tYXgtY29uY3VycmVudC1yZXF1ZXN0cyUzRDY0JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZXQtZW52LXZhcnMlM0RIRl9IVUJfRU5BQkxFX0hGX1RSQU5TRkVSJTNEMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcG9ydCUzRDgwODAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNwdSUzRDglMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1lbW9yeSUzRDMyR2klMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWNwdS10aHJvdHRsaW5nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncHUlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncHUtdHlwZSUzRG52aWRpYS1sNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4LWluc3RhbmNlcyUzRDMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNvbmN1cnJlbmN5JTNENjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9OJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1uby1hbGxvdy11bmF1dGhlbnRpY2F0ZWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXZwYy1lZ3Jlc3MlM0RhbGwtdHJhZmZpYyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc3VibmV0JTNEZGVmYXVsdA==",highlighted:`gcloud beta run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated \\
    --vpc-egress=all-traffic \\
    --subnet=default`,wrap:!1}}),D=new y({props:{title:"Inference",local:"inference",headingTag:"h2"}}),te=new y({props:{title:"Via Cloud Run Proxy",local:"via-cloud-run-proxy",headingTag:"h3"}}),ne=new h({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBwcm94eSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04=",highlighted:'gcloud run services proxy <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),ie=new y({props:{title:"cURL",local:"curl",headingTag:"h4"}}),oe=new h({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGZW1iZWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0ZWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTdEJw==",highlighted:`curl http://localhost:8080/embed \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),re=new h({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZlbWJlZGRpbmdzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLVglMjBQT1NUJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGVpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCc=",highlighted:`curl http://localhost:8080/v1/embeddings \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),pe=new y({props:{title:"Python",local:"python",headingTag:"h4"}}),de=new y({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),me=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBZW1iZWRkaW5nJTIwJTNEJTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGZW1iZWQlMjIpJTBBcHJpbnQobGVuKGVtYmVkZGluZyU1QjAlNUQpKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient()
embedding = client.feature_extraction(<span class="hljs-string">&quot;What is deep learning?&quot;</span>,
                                      model=<span class="hljs-string">&quot;http://localhost:8080/embed&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(embedding[<span class="hljs-number">0</span>]))`,wrap:!1}}),he=new y({props:{title:"OpenAI",local:"openai",headingTag:"h4"}}),Te=new h({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSShiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZlbWJlZGRpbmdzJTIyJTJDJTIwYXBpX2tleSUzRCUyMiUyMiklMEElMEFyZXNwb25zZSUyMCUzRCUyMGNsaWVudC5lbWJlZGRpbmdzLmNyZWF0ZSglMEElMjAlMjBtb2RlbCUzRCUyMnRlaSUyMiUyQyUwQSUyMCUyMGlucHV0JTNEJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBKSUwQSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(base_url=<span class="hljs-string">&quot;http://localhost:8080/v1/embeddings&quot;</span>, api_key=<span class="hljs-string">&quot;&quot;</span>)

response = client.embeddings.create(
  model=<span class="hljs-string">&quot;tei&quot;</span>,
  <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is deep learning?&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),fe=new y({props:{title:"(recommended) Via Cloud Run Service URL",local:"recommended-via-cloud-run-service-url",headingTag:"h3"}}),we=new h({props:{code:"U0VSVklDRV9VUkwlM0QlMjQoZ2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZXNjcmliZSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04lMjAtLWZvcm1hdCUyMCd2YWx1ZShzdGF0dXMudXJsKScp",highlighted:'SERVICE_URL=$(gcloud run services describe <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span> --format <span class="hljs-string">&#x27;value(status.url)&#x27;</span>)',wrap:!1}}),ve=new h({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHByaW50LWlkZW50aXR5LXRva2Vu",highlighted:"gcloud auth print-identity-token",wrap:!1}}),$e=new h({props:{code:"aW1wb3J0JTIwZ29vZ2xlLmF1dGglMEFmcm9tJTIwZ29vZ2xlLmF1dGgudHJhbnNwb3J0LnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUyMGFzJTIwR29vZ2xlQXV0aFJlcXVlc3QlMEElMEFhdXRoX3JlcSUyMCUzRCUyMEdvb2dsZUF1dGhSZXF1ZXN0KCklMEFjcmVkcyUyQyUyMF8lMjAlM0QlMjBnb29nbGUuYXV0aC5kZWZhdWx0KCklMEFjcmVkcy5yZWZyZXNoKGF1dGhfcmVxKSUwQSUwQWlkX3Rva2VuJTIwJTNEJTIwY3JlZHMuaWRfdG9rZW4=",highlighted:`import google.auth
from google.auth.transport.requests import Request as GoogleAuthRequest

auth_req = GoogleAuthRequest()
creds, _ = google.auth.default()
creds.refresh(auth_req)

id_token = creds.id_token`,wrap:!1}}),Re=new h({props:{code:"ZXhwb3J0JTIwU0VSVklDRV9BQ0NPVU5UX05BTUUlM0R0ZWktaW52b2tlcg==",highlighted:'<span class="hljs-built_in">export</span> SERVICE_ACCOUNT_NAME=tei-invoker',wrap:!1}}),Ze=new h({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGNyZWF0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1F",highlighted:'gcloud iam service-accounts create <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>',wrap:!1}}),Se=new h({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBhZGQtaWFtLXBvbGljeS1iaW5kaW5nJTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tZW1iZXIlM0QlMjJzZXJ2aWNlQWNjb3VudCUzQSUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9sZSUzRCUyMnJvbGVzJTJGcnVuLmludm9rZXIlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9O",highlighted:`gcloud run services add-iam-policy-binding <span class="hljs-variable">$SERVICE_NAME</span> \\
    --member=<span class="hljs-string">&quot;serviceAccount:<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com&quot;</span> \\
    --role=<span class="hljs-string">&quot;roles/run.invoker&quot;</span> \\
    --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),ke=new h({props:{code:"ZXhwb3J0JTIwQUNDRVNTX1RPS0VOJTNEJTI0KGdjbG91ZCUyMGF1dGglMjBwcmludC1hY2Nlc3MtdG9rZW4lMjAtLWltcGVyc29uYXRlLXNlcnZpY2UtYWNjb3VudCUzRCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSk=",highlighted:'<span class="hljs-built_in">export</span> ACCESS_TOKEN=$(gcloud auth print-access-token --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com)',wrap:!1}}),_e=new y({props:{title:"cURL",local:"curl",headingTag:"h4"}}),Be=new h({props:{code:"Y3VybCUyMCUyNFNFUlZJQ0VfVVJMJTJGdjElMkZlbWJlZGRpZ3MlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMkF1dGhvcml6YXRpb24lM0ElMjBCZWFyZXIlMjAlMjRBQ0NFU1NfVE9LRU4lMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0ZWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTdEJw==",highlighted:`curl <span class="hljs-variable">$SERVICE_URL</span>/v1/embeddigs \\
    -X POST \\
    -H <span class="hljs-string">&quot;Authorization: Bearer <span class="hljs-variable">$ACCESS_TOKEN</span>&quot;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),Xe=new y({props:{title:"Python",local:"python",headingTag:"h4"}}),qe=new y({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),Pe=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFlbWJlZGRpbmclMjAlM0QlMjBjbGllbnQuZmVhdHVyZV9leHRyYWN0aW9uKCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTgwODAlMkZlbWJlZCUyMiklMEFwcmludChsZW4oZW1iZWRkaW5nJTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

embedding = client.feature_extraction(<span class="hljs-string">&quot;What is deep learning?&quot;</span>,
                                      model=<span class="hljs-string">&quot;http://localhost:8080/embed&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(embedding[<span class="hljs-number">0</span>]))`,wrap:!1}}),Oe=new y({props:{title:"OpenAI",local:"openai",headingTag:"h4"}}),De=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFyZXNwb25zZSUyMCUzRCUyMGNsaWVudC5lbWJlZGRpbmdzLmNyZWF0ZSglMEElMjAlMjBtb2RlbCUzRCUyMnRlaSUyMiUyQyUwQSUyMCUyMGlucHV0JTNEJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBKSUwQSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

response = client.embeddings.create(
  model=<span class="hljs-string">&quot;tei&quot;</span>,
  <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is deep learning?&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),ze=new y({props:{title:"Resource clean up",local:"resource-clean-up",headingTag:"h2"}}),tt=new h({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZWxldGUlMjAlMjRTRVJWSUNFX05BTUUlMjAtLXJlZ2lvbiUyMCUyNExPQ0FUSU9O",highlighted:'gcloud run services delete <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),st=new h({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHJldm9rZSUyMC0taW1wZXJzb25hdGUtc2VydmljZS1hY2NvdW50JTNEJTI0U0VSVklDRV9BQ0NPVU5UX05BTUUlNDAlMjRQUk9KRUNUX0lELmlhbS5nc2VydmljZWFjY291bnQuY29t",highlighted:'gcloud auth revoke --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),at=new h({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGRlbGV0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbQ==",highlighted:'gcloud iam service-accounts delete <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),ut=new h({props:{code:"Z2Nsb3VkJTIwY29tcHV0ZSUyMHJvdXRlcnMlMjBuYXRzJTIwZGVsZXRlJTIwdm0tbmF0JTIwLS1yb3V0ZXIlM0RuYXQtcm91dGVyJTIwLS1yZWdpb24lM0QlMjRMT0NBVElPTiUwQWdjbG91ZCUyMGNvbXB1dGUlMjByb3V0ZXJzJTIwZGVsZXRlJTIwbmF0LXJvdXRlciUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04=",highlighted:`gcloud compute routers nats delete vm-nat --router=nat-router --region=<span class="hljs-variable">$LOCATION</span>
gcloud compute routers delete nat-router --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),rt=new y({props:{title:"References",local:"references",headingTag:"h2"}}),ct=new As({props:{source:"https://github.com/huggingface/text-embeddings-inference/blob/main/docs/source/en/tei_cloud_run.md"}}),{c(){T=a("meta"),yt=s(),mt=a("p"),Tt=s(),r(g.$$.fragment),ft=s(),r(J.$$.fragment),Ut=s(),b=a("p"),b.innerHTML=fn,Ct=s(),v=a("p"),v.textContent=Un,wt=s(),j=a("ul"),j.innerHTML=Cn,gt=s(),$=a("p"),$.textContent=wn,Jt=s(),I=a("p"),I.textContent=gn,bt=s(),U=a("blockquote"),U.innerHTML=Jn,vt=s(),r(A.$$.fragment),jt=s(),V=a("p"),V.innerHTML=bn,$t=s(),E=a("p"),E.innerHTML=vn,It=s(),R=a("p"),R.textContent=jn,At=s(),r(N.$$.fragment),Vt=s(),Z=a("p"),Z.textContent=$n,Et=s(),x=a("ul"),x.innerHTML=In,Rt=s(),S=a("p"),S.textContent=An,Nt=s(),r(L.$$.fragment),Zt=s(),k=a("p"),k.textContent=Vn,xt=s(),r(G.$$.fragment),St=s(),r(W.$$.fragment),Lt=s(),_=a("p"),_.innerHTML=En,kt=s(),Q=a("p"),Q.textContent=Rn,Gt=s(),B=a("ul"),B.innerHTML=Nn,Wt=s(),f=a("blockquote"),dt=a("p"),dt.innerHTML=Zn,mn=s(),r(X.$$.fragment),_t=s(),F=a("p"),F.innerHTML=xn,Qt=s(),r(q.$$.fragment),Bt=s(),H=a("p"),H.textContent=Sn,Xt=s(),r(P.$$.fragment),Ft=s(),O=a("p"),O.textContent=Ln,qt=s(),r(Y.$$.fragment),Ht=s(),C=a("blockquote"),C.innerHTML=kn,Pt=s(),r(D.$$.fragment),Ot=s(),z=a("p"),z.innerHTML=Gn,Yt=s(),K=a("p"),K.textContent=Wn,Dt=s(),ee=a("p"),ee.textContent=_n,zt=s(),w=a("blockquote"),w.innerHTML=Qn,Kt=s(),r(te.$$.fragment),el=s(),le=a("p"),le.textContent=Bn,tl=s(),r(ne.$$.fragment),ll=s(),se=a("p"),se.textContent=Xn,nl=s(),r(ie.$$.fragment),sl=s(),ae=a("p"),ae.textContent=Fn,il=s(),r(oe.$$.fragment),al=s(),ue=a("p"),ue.textContent=qn,ol=s(),r(re.$$.fragment),ul=s(),r(pe.$$.fragment),rl=s(),ce=a("p"),ce.innerHTML=Hn,pl=s(),r(de.$$.fragment),cl=s(),Me=a("p"),Me.innerHTML=Pn,dl=s(),r(me.$$.fragment),Ml=s(),r(he.$$.fragment),ml=s(),ye=a("p"),ye.innerHTML=On,hl=s(),r(Te.$$.fragment),yl=s(),r(fe.$$.fragment),Tl=s(),Ue=a("p"),Ue.textContent=Yn,fl=s(),Ce=a("p"),Ce.textContent=Dn,Ul=s(),r(we.$$.fragment),Cl=s(),ge=a("p"),ge.innerHTML=zn,wl=s(),Je=a("p"),Je.textContent=Kn,gl=s(),be=a("ul"),be.innerHTML=es,Jl=s(),r(ve.$$.fragment),bl=s(),je=a("ul"),je.innerHTML=ts,vl=s(),r($e.$$.fragment),jl=s(),Ie=a("ul"),Ie.innerHTML=ls,$l=s(),Ae=a("p"),Ae.innerHTML=ns,Il=s(),Ve=a("p"),Ve.textContent=ss,Al=s(),Ee=a("ul"),Ee.innerHTML=is,Vl=s(),r(Re.$$.fragment),El=s(),Ne=a("ul"),Ne.innerHTML=as,Rl=s(),r(Ze.$$.fragment),Nl=s(),xe=a("ul"),xe.innerHTML=os,Zl=s(),r(Se.$$.fragment),xl=s(),Le=a("p"),Le.textContent=us,Sl=s(),r(ke.$$.fragment),Ll=s(),Ge=a("blockquote"),Ge.innerHTML=rs,kl=s(),We=a("p"),We.innerHTML=ps,Gl=s(),r(_e.$$.fragment),Wl=s(),Qe=a("p"),Qe.textContent=cs,_l=s(),r(Be.$$.fragment),Ql=s(),r(Xe.$$.fragment),Bl=s(),Fe=a("p"),Fe.innerHTML=ds,Xl=s(),r(qe.$$.fragment),Fl=s(),He=a("p"),He.innerHTML=Ms,ql=s(),r(Pe.$$.fragment),Hl=s(),r(Oe.$$.fragment),Pl=s(),Ye=a("p"),Ye.innerHTML=ms,Ol=s(),r(De.$$.fragment),Yl=s(),r(ze.$$.fragment),Dl=s(),Ke=a("p"),Ke.textContent=hs,zl=s(),et=a("p"),et.innerHTML=ys,Kl=s(),r(tt.$$.fragment),en=s(),lt=a("p"),lt.textContent=Ts,tn=s(),nt=a("ul"),nt.innerHTML=fs,ln=s(),r(st.$$.fragment),nn=s(),it=a("ul"),it.innerHTML=Us,sn=s(),r(at.$$.fragment),an=s(),ot=a("p"),ot.textContent=Cs,on=s(),r(ut.$$.fragment),un=s(),r(rt.$$.fragment),rn=s(),pt=a("ul"),pt.innerHTML=ws,pn=s(),r(ct.$$.fragment),cn=s(),ht=a("p"),this.h()},l(e){const t=$s("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),yt=i(e),mt=o(e,"P",{}),hn(mt).forEach(l),Tt=i(e),p(g.$$.fragment,e),ft=i(e),p(J.$$.fragment,e),Ut=i(e),b=o(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1jywelx"&&(b.innerHTML=fn),Ct=i(e),v=o(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-kstn30"&&(v.textContent=Un),wt=i(e),j=o(e,"UL",{"data-svelte-h":!0}),u(j)!=="svelte-1ri0d6u"&&(j.innerHTML=Cn),gt=i(e),$=o(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-jq2f1f"&&($.textContent=wn),Jt=i(e),I=o(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1kwnf1q"&&(I.textContent=gn),bt=i(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(U)!=="svelte-1j7knwx"&&(U.innerHTML=Jn),vt=i(e),p(A.$$.fragment,e),jt=i(e),V=o(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-9iv4wv"&&(V.innerHTML=bn),$t=i(e),E=o(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-p3n1a9"&&(E.innerHTML=vn),It=i(e),R=o(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1i8n6rq"&&(R.textContent=jn),At=i(e),p(N.$$.fragment,e),Vt=i(e),Z=o(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-12btpyf"&&(Z.textContent=$n),Et=i(e),x=o(e,"UL",{"data-svelte-h":!0}),u(x)!=="svelte-1pcxftj"&&(x.innerHTML=In),Rt=i(e),S=o(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-pfbeqd"&&(S.textContent=An),Nt=i(e),p(L.$$.fragment,e),Zt=i(e),k=o(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-13jr0pj"&&(k.textContent=Vn),xt=i(e),p(G.$$.fragment,e),St=i(e),p(W.$$.fragment,e),Lt=i(e),_=o(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1aiwb7r"&&(_.innerHTML=En),kt=i(e),Q=o(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1f5ji1s"&&(Q.textContent=Rn),Gt=i(e),B=o(e,"UL",{"data-svelte-h":!0}),u(B)!=="svelte-1lbi8el"&&(B.innerHTML=Nn),Wt=i(e),f=o(e,"BLOCKQUOTE",{class:!0});var Mn=hn(f);dt=o(Mn,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-1o1t3au"&&(dt.innerHTML=Zn),mn=i(Mn),p(X.$$.fragment,Mn),Mn.forEach(l),_t=i(e),F=o(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-wzi9ad"&&(F.innerHTML=xn),Qt=i(e),p(q.$$.fragment,e),Bt=i(e),H=o(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-cltr6v"&&(H.textContent=Sn),Xt=i(e),p(P.$$.fragment,e),Ft=i(e),O=o(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-vtd23h"&&(O.textContent=Ln),qt=i(e),p(Y.$$.fragment,e),Ht=i(e),C=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(C)!=="svelte-zk4klx"&&(C.innerHTML=kn),Pt=i(e),p(D.$$.fragment,e),Ot=i(e),z=o(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-12bs2xr"&&(z.innerHTML=Gn),Yt=i(e),K=o(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1gzo66i"&&(K.textContent=Wn),Dt=i(e),ee=o(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-8buc6k"&&(ee.textContent=_n),zt=i(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(w)!=="svelte-yzbjnr"&&(w.innerHTML=Qn),Kt=i(e),p(te.$$.fragment,e),el=i(e),le=o(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-1n42sxg"&&(le.textContent=Bn),tl=i(e),p(ne.$$.fragment,e),ll=i(e),se=o(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1wqv6zg"&&(se.textContent=Xn),nl=i(e),p(ie.$$.fragment,e),sl=i(e),ae=o(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1je3wgp"&&(ae.textContent=Fn),il=i(e),p(oe.$$.fragment,e),al=i(e),ue=o(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-7nrnml"&&(ue.textContent=qn),ol=i(e),p(re.$$.fragment,e),ul=i(e),p(pe.$$.fragment,e),rl=i(e),ce=o(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-h8hgtx"&&(ce.innerHTML=Hn),pl=i(e),p(de.$$.fragment,e),cl=i(e),Me=o(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1pmfr0a"&&(Me.innerHTML=Pn),dl=i(e),p(me.$$.fragment,e),Ml=i(e),p(he.$$.fragment,e),ml=i(e),ye=o(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-17lqblq"&&(ye.innerHTML=On),hl=i(e),p(Te.$$.fragment,e),yl=i(e),p(fe.$$.fragment,e),Tl=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1o5h253"&&(Ue.textContent=Yn),fl=i(e),Ce=o(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-govem3"&&(Ce.textContent=Dn),Ul=i(e),p(we.$$.fragment,e),Cl=i(e),ge=o(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-niuemd"&&(ge.innerHTML=zn),wl=i(e),Je=o(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-4rg0sg"&&(Je.textContent=Kn),gl=i(e),be=o(e,"UL",{"data-svelte-h":!0}),u(be)!=="svelte-h09l2v"&&(be.innerHTML=es),Jl=i(e),p(ve.$$.fragment,e),bl=i(e),je=o(e,"UL",{"data-svelte-h":!0}),u(je)!=="svelte-b6nbfv"&&(je.innerHTML=ts),vl=i(e),p($e.$$.fragment,e),jl=i(e),Ie=o(e,"UL",{"data-svelte-h":!0}),u(Ie)!=="svelte-93kat8"&&(Ie.innerHTML=ls),$l=i(e),Ae=o(e,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-1hrh7sd"&&(Ae.innerHTML=ns),Il=i(e),Ve=o(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-18iwnqm"&&(Ve.textContent=ss),Al=i(e),Ee=o(e,"UL",{"data-svelte-h":!0}),u(Ee)!=="svelte-1v8yusc"&&(Ee.innerHTML=is),Vl=i(e),p(Re.$$.fragment,e),El=i(e),Ne=o(e,"UL",{"data-svelte-h":!0}),u(Ne)!=="svelte-1e2np3q"&&(Ne.innerHTML=as),Rl=i(e),p(Ze.$$.fragment,e),Nl=i(e),xe=o(e,"UL",{"data-svelte-h":!0}),u(xe)!=="svelte-m7ycff"&&(xe.innerHTML=os),Zl=i(e),p(Se.$$.fragment,e),xl=i(e),Le=o(e,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-v6tnr5"&&(Le.textContent=us),Sl=i(e),p(ke.$$.fragment,e),Ll=i(e),Ge=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(Ge)!=="svelte-dmerw2"&&(Ge.innerHTML=rs),kl=i(e),We=o(e,"P",{"data-svelte-h":!0}),u(We)!=="svelte-ur1pan"&&(We.innerHTML=ps),Gl=i(e),p(_e.$$.fragment,e),Wl=i(e),Qe=o(e,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-1je3wgp"&&(Qe.textContent=cs),_l=i(e),p(Be.$$.fragment,e),Ql=i(e),p(Xe.$$.fragment,e),Bl=i(e),Fe=o(e,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-h8hgtx"&&(Fe.innerHTML=ds),Xl=i(e),p(qe.$$.fragment,e),Fl=i(e),He=o(e,"P",{"data-svelte-h":!0}),u(He)!=="svelte-1pmfr0a"&&(He.innerHTML=Ms),ql=i(e),p(Pe.$$.fragment,e),Hl=i(e),p(Oe.$$.fragment,e),Pl=i(e),Ye=o(e,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-17lqblq"&&(Ye.innerHTML=ms),Ol=i(e),p(De.$$.fragment,e),Yl=i(e),p(ze.$$.fragment,e),Dl=i(e),Ke=o(e,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-8fqmhw"&&(Ke.textContent=hs),zl=i(e),et=o(e,"P",{"data-svelte-h":!0}),u(et)!=="svelte-1stcxhv"&&(et.innerHTML=ys),Kl=i(e),p(tt.$$.fragment,e),en=i(e),lt=o(e,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-1umuozh"&&(lt.textContent=Ts),tn=i(e),nt=o(e,"UL",{"data-svelte-h":!0}),u(nt)!=="svelte-uuoqil"&&(nt.innerHTML=fs),ln=i(e),p(st.$$.fragment,e),nn=i(e),it=o(e,"UL",{"data-svelte-h":!0}),u(it)!=="svelte-1toh59e"&&(it.innerHTML=Us),sn=i(e),p(at.$$.fragment,e),an=i(e),ot=o(e,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-1xv6mwy"&&(ot.textContent=Cs),on=i(e),p(ut.$$.fragment,e),un=i(e),p(rt.$$.fragment,e),rn=i(e),pt=o(e,"UL",{"data-svelte-h":!0}),u(pt)!=="svelte-1i59rl0"&&(pt.innerHTML=ws),pn=i(e),p(ct.$$.fragment,e),cn=i(e),ht=o(e,"P",{}),hn(ht).forEach(l),this.h()},h(){Mt(T,"name","hf:doc:metadata"),Mt(T,"content",Es),Mt(U,"class","note"),Mt(f,"class","note"),Mt(C,"class","note"),Mt(w,"class","note")},m(e,t){yn(document.head,T),n(e,yt,t),n(e,mt,t),n(e,Tt,t),c(g,e,t),n(e,ft,t),c(J,e,t),n(e,Ut,t),n(e,b,t),n(e,Ct,t),n(e,v,t),n(e,wt,t),n(e,j,t),n(e,gt,t),n(e,$,t),n(e,Jt,t),n(e,I,t),n(e,bt,t),n(e,U,t),n(e,vt,t),c(A,e,t),n(e,jt,t),n(e,V,t),n(e,$t,t),n(e,E,t),n(e,It,t),n(e,R,t),n(e,At,t),c(N,e,t),n(e,Vt,t),n(e,Z,t),n(e,Et,t),n(e,x,t),n(e,Rt,t),n(e,S,t),n(e,Nt,t),c(L,e,t),n(e,Zt,t),n(e,k,t),n(e,xt,t),c(G,e,t),n(e,St,t),c(W,e,t),n(e,Lt,t),n(e,_,t),n(e,kt,t),n(e,Q,t),n(e,Gt,t),n(e,B,t),n(e,Wt,t),n(e,f,t),yn(f,dt),yn(f,mn),c(X,f,null),n(e,_t,t),n(e,F,t),n(e,Qt,t),c(q,e,t),n(e,Bt,t),n(e,H,t),n(e,Xt,t),c(P,e,t),n(e,Ft,t),n(e,O,t),n(e,qt,t),c(Y,e,t),n(e,Ht,t),n(e,C,t),n(e,Pt,t),c(D,e,t),n(e,Ot,t),n(e,z,t),n(e,Yt,t),n(e,K,t),n(e,Dt,t),n(e,ee,t),n(e,zt,t),n(e,w,t),n(e,Kt,t),c(te,e,t),n(e,el,t),n(e,le,t),n(e,tl,t),c(ne,e,t),n(e,ll,t),n(e,se,t),n(e,nl,t),c(ie,e,t),n(e,sl,t),n(e,ae,t),n(e,il,t),c(oe,e,t),n(e,al,t),n(e,ue,t),n(e,ol,t),c(re,e,t),n(e,ul,t),c(pe,e,t),n(e,rl,t),n(e,ce,t),n(e,pl,t),c(de,e,t),n(e,cl,t),n(e,Me,t),n(e,dl,t),c(me,e,t),n(e,Ml,t),c(he,e,t),n(e,ml,t),n(e,ye,t),n(e,hl,t),c(Te,e,t),n(e,yl,t),c(fe,e,t),n(e,Tl,t),n(e,Ue,t),n(e,fl,t),n(e,Ce,t),n(e,Ul,t),c(we,e,t),n(e,Cl,t),n(e,ge,t),n(e,wl,t),n(e,Je,t),n(e,gl,t),n(e,be,t),n(e,Jl,t),c(ve,e,t),n(e,bl,t),n(e,je,t),n(e,vl,t),c($e,e,t),n(e,jl,t),n(e,Ie,t),n(e,$l,t),n(e,Ae,t),n(e,Il,t),n(e,Ve,t),n(e,Al,t),n(e,Ee,t),n(e,Vl,t),c(Re,e,t),n(e,El,t),n(e,Ne,t),n(e,Rl,t),c(Ze,e,t),n(e,Nl,t),n(e,xe,t),n(e,Zl,t),c(Se,e,t),n(e,xl,t),n(e,Le,t),n(e,Sl,t),c(ke,e,t),n(e,Ll,t),n(e,Ge,t),n(e,kl,t),n(e,We,t),n(e,Gl,t),c(_e,e,t),n(e,Wl,t),n(e,Qe,t),n(e,_l,t),c(Be,e,t),n(e,Ql,t),c(Xe,e,t),n(e,Bl,t),n(e,Fe,t),n(e,Xl,t),c(qe,e,t),n(e,Fl,t),n(e,He,t),n(e,ql,t),c(Pe,e,t),n(e,Hl,t),c(Oe,e,t),n(e,Pl,t),n(e,Ye,t),n(e,Ol,t),c(De,e,t),n(e,Yl,t),c(ze,e,t),n(e,Dl,t),n(e,Ke,t),n(e,zl,t),n(e,et,t),n(e,Kl,t),c(tt,e,t),n(e,en,t),n(e,lt,t),n(e,tn,t),n(e,nt,t),n(e,ln,t),c(st,e,t),n(e,nn,t),n(e,it,t),n(e,sn,t),c(at,e,t),n(e,an,t),n(e,ot,t),n(e,on,t),c(ut,e,t),n(e,un,t),c(rt,e,t),n(e,rn,t),n(e,pt,t),n(e,pn,t),c(ct,e,t),n(e,cn,t),n(e,ht,t),dn=!0},p:Js,i(e){dn||(d(g.$$.fragment,e),d(J.$$.fragment,e),d(A.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(X.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(Y.$$.fragment,e),d(D.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(we.$$.fragment,e),d(ve.$$.fragment,e),d($e.$$.fragment,e),d(Re.$$.fragment,e),d(Ze.$$.fragment,e),d(Se.$$.fragment,e),d(ke.$$.fragment,e),d(_e.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(qe.$$.fragment,e),d(Pe.$$.fragment,e),d(Oe.$$.fragment,e),d(De.$$.fragment,e),d(ze.$$.fragment,e),d(tt.$$.fragment,e),d(st.$$.fragment,e),d(at.$$.fragment,e),d(ut.$$.fragment,e),d(rt.$$.fragment,e),d(ct.$$.fragment,e),dn=!0)},o(e){M(g.$$.fragment,e),M(J.$$.fragment,e),M(A.$$.fragment,e),M(N.$$.fragment,e),M(L.$$.fragment,e),M(G.$$.fragment,e),M(W.$$.fragment,e),M(X.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),M(Y.$$.fragment,e),M(D.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(pe.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(he.$$.fragment,e),M(Te.$$.fragment,e),M(fe.$$.fragment,e),M(we.$$.fragment,e),M(ve.$$.fragment,e),M($e.$$.fragment,e),M(Re.$$.fragment,e),M(Ze.$$.fragment,e),M(Se.$$.fragment,e),M(ke.$$.fragment,e),M(_e.$$.fragment,e),M(Be.$$.fragment,e),M(Xe.$$.fragment,e),M(qe.$$.fragment,e),M(Pe.$$.fragment,e),M(Oe.$$.fragment,e),M(De.$$.fragment,e),M(ze.$$.fragment,e),M(tt.$$.fragment,e),M(st.$$.fragment,e),M(at.$$.fragment,e),M(ut.$$.fragment,e),M(rt.$$.fragment,e),M(ct.$$.fragment,e),dn=!1},d(e){e&&(l(yt),l(mt),l(Tt),l(ft),l(Ut),l(b),l(Ct),l(v),l(wt),l(j),l(gt),l($),l(Jt),l(I),l(bt),l(U),l(vt),l(jt),l(V),l($t),l(E),l(It),l(R),l(At),l(Vt),l(Z),l(Et),l(x),l(Rt),l(S),l(Nt),l(Zt),l(k),l(xt),l(St),l(Lt),l(_),l(kt),l(Q),l(Gt),l(B),l(Wt),l(f),l(_t),l(F),l(Qt),l(Bt),l(H),l(Xt),l(Ft),l(O),l(qt),l(Ht),l(C),l(Pt),l(Ot),l(z),l(Yt),l(K),l(Dt),l(ee),l(zt),l(w),l(Kt),l(el),l(le),l(tl),l(ll),l(se),l(nl),l(sl),l(ae),l(il),l(al),l(ue),l(ol),l(ul),l(rl),l(ce),l(pl),l(cl),l(Me),l(dl),l(Ml),l(ml),l(ye),l(hl),l(yl),l(Tl),l(Ue),l(fl),l(Ce),l(Ul),l(Cl),l(ge),l(wl),l(Je),l(gl),l(be),l(Jl),l(bl),l(je),l(vl),l(jl),l(Ie),l($l),l(Ae),l(Il),l(Ve),l(Al),l(Ee),l(Vl),l(El),l(Ne),l(Rl),l(Nl),l(xe),l(Zl),l(xl),l(Le),l(Sl),l(Ll),l(Ge),l(kl),l(We),l(Gl),l(Wl),l(Qe),l(_l),l(Ql),l(Bl),l(Fe),l(Xl),l(Fl),l(He),l(ql),l(Hl),l(Pl),l(Ye),l(Ol),l(Yl),l(Dl),l(Ke),l(zl),l(et),l(Kl),l(en),l(lt),l(tn),l(nt),l(ln),l(nn),l(it),l(sn),l(an),l(ot),l(on),l(un),l(rn),l(pt),l(pn),l(cn),l(ht)),l(T),m(g,e),m(J,e),m(A,e),m(N,e),m(L,e),m(G,e),m(W,e),m(X),m(q,e),m(P,e),m(Y,e),m(D,e),m(te,e),m(ne,e),m(ie,e),m(oe,e),m(re,e),m(pe,e),m(de,e),m(me,e),m(he,e),m(Te,e),m(fe,e),m(we,e),m(ve,e),m($e,e),m(Re,e),m(Ze,e),m(Se,e),m(ke,e),m(_e,e),m(Be,e),m(Xe,e),m(qe,e),m(Pe,e),m(Oe,e),m(De,e),m(ze,e),m(tt,e),m(st,e),m(at,e),m(ut,e),m(rt,e),m(ct,e)}}}const Es='{"title":"Deploying TEI on Google Cloud Run","local":"deploying-tei-on-google-cloud-run","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Deploy TEI on Cloud Run","local":"deploy-tei-on-cloud-run","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"Via Cloud Run Proxy","local":"via-cloud-run-proxy","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5}],"depth":4},{"title":"OpenAI","local":"openai","sections":[],"depth":4}],"depth":3},{"title":"(recommended) Via Cloud Run Service URL","local":"recommended-via-cloud-run-service-url","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5}],"depth":4},{"title":"OpenAI","local":"openai","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Resource clean up","local":"resource-clean-up","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Rs(Tn){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ls extends vs{constructor(T){super(),js(this,T,Rs,Vs,gs,{})}}export{Ls as component};
