import{s as Pn,o as On,n as Yl}from"../chunks/scheduler.6efaaf90.js";import{S as Kn,i as es,e as o,s,c as r,h as ts,a as i,d as l,b as a,f as zn,g as c,j as p,k as Dn,l as ls,m as n,n as M,t as d,o as m,p as u}from"../chunks/index.eb3e1f0f.js";import{T as Ll}from"../chunks/Tip.292c2c3d.js";import{C as ns,H as J,E as ss}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f2701ddd.js";import{C as T}from"../chunks/CodeBlock.dd9f2904.js";function as(f){let h,g='Starting from TGI 2.3 DLC i.e. <code>us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124.2-3.ubuntu2204.py311</code>, and onwards, you can set the environment variable value <code>MESSAGES_API_ENABLED=&quot;true&quot;</code> to deploy the <a href="https://huggingface.co/docs/text-generation-inference/main/en/messages_api" rel="nofollow">Messages API</a> on Vertex AI, otherwise, the <a href="https://huggingface.co/docs/text-generation-inference/main/en/quicktour#consuming-tgi" rel="nofollow">Generate API</a> will be deployed instead.';return{c(){h=o("p"),h.innerHTML=g},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1jcnsbw"&&(h.innerHTML=g)},m(y,w){n(y,h,w)},p:Yl,d(y){y&&l(h)}}}function os(f){let h,g="You will need to either retrieve the resource name i.e. the <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code> URL yourself via the Google Cloud Console, or just replace the <code>ENDPOINT_ID</code> below that can either be found via the previously instantiated <code>endpoint</code> as <code>endpoint.id</code> or via the Google Cloud Console under the Online predictions where the endpoint is listed.";return{c(){h=o("p"),h.innerHTML=g},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-10r1du6"&&(h.innerHTML=g)},m(y,w){n(y,h,w)},p:Yl,d(y){y&&l(h)}}}function is(f){let h,g="When deleting the model from Vertex AI, as it’s stored within a GCS Bucket, neither the bucket nor its contents will be removed when removing the model from Vertex AI.";return{c(){h=o("p"),h.textContent=g},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-uo7qbi"&&(h.textContent=g)},m(y,w){n(y,h,w)},p:Yl,d(y){y&&l(h)}}}function ps(f){let h,g='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Google-Cloud-Containers/tree/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai" rel="nofollow">here</a>!';return{c(){h=o("p"),h.innerHTML=g},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-gcq6cl"&&(h.innerHTML=g)},m(y,w){n(y,h,w)},p:Yl,d(y){y&&l(h)}}}function rs(f){let h,g,y,w,C,it,v,pt,Z,ql="Gemma is a family of lightweight, state-of-the-art open models built from the same research and technology used to create the Gemini models, developed by Google DeepMind and other teams across Google. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. And, Google Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.",rt,G,zl='This example showcases how to deploy any supported text-generation model, in this case <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a>, downloaded from the Hugging Face Hub and uploaded to a Google Cloud Storage (GCS) Bucket, on Vertex AI using the Hugging Face DLC for TGI available in Google Cloud Platform (GCP).',ct,$,Dl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;google/gemma-7b-it&#39; in the Hugging Face Hub"/>',Mt,A,dt,V,Pl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',mt,B,Ol="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",ut,x,ht,k,Kl="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",yt,R,Tt,_,en="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",gt,W,Jt,N,tn="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",wt,E,ft,X,Ut,S,ln="Unless you already have a GCS Bucket with the artifact that you want to serve, please follow the instructions below in order to create a new bucket and download and upload the model weights into it.",jt,F,nn="To create the bucket on Google Cloud Storage (GCS), you first need to ensure that the name is unique for the new bucket or if a bucket with the same name already exists. To do so, both the <code>gsutil</code> SDK and the <code>crcmod</code> Python package need to be installed in advance as follows:",bt,Q,It,H,sn="Then you can check whether the bucket exists in GCS, and create it if it doesn’t, with the following bash script:",Ct,L,vt,Y,an='If either the bucket was created or if the bucket existed in advance, you can already upload <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> from either the Hugging Face Hub, or local storage.',Zt,q,Gt,z,on="If the model is available locally, e.g. under the Hugging Face cache path at <code>~/.cache/huggingface/hub/models--google--gemma-7b-it/snapshots/8adab6a35fdbcdae0ae41ab1f711b1bc8d05727e</code>, you should run the following script to upload it to the GCS Bucket.",$t,D,At,P,Vt,O,pn='Alternatively, you can also upload the model to the GCS Bucket from the Hugging Face Hub. As <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just overall read-access to your account.',Bt,K,rn='More information on how to generate a read-only access token for the Hugging Face Hub in the instructions at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',xt,ee,kt,te,Rt,le,cn="After <code>huggingface_hub</code> installation and login are completed, you can run the following bash script to download the model locally within a temporary directory, and then upload those to the GCS Bucket.",_t,ne,Wt,se,Mn='To see the end to end script, please check <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/scripts/upload_model_to_gcs.sh" rel="nofollow"><code>./scripts/upload_model_to_gcs.sh</code></a> within the root directory of this repository.',Nt,ae,dn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/gcs-model-artifact.png" alt="GCS Bucket with model artifact"/>',Et,oe,Xt,ie,mn="Once everything is set up, you can already initialize the Vertex AI session via the <code>google-cloud-aiplatform</code> Python SDK as follows:",St,pe,Ft,re,un="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the GCS Bucket URI on startup, so what is uploaded is only the configuration, not the model weights.",Qt,ce,hn="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",Ht,Me,yn='<li><p><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</p></li> <li><p><strong><code>artifact_uri</code></strong> is the path to the directory with the artifact within the GCS Bucket.</p></li> <li><p><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TGI that will be used for serving the model.</p></li> <li><p><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by <code>text-generation-inference</code>, which are analog to the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow"><code>text-generation-launcher</code> arguments</a>. Additionally, the Hugging Face DLCs for TGI also capture the <code>AIP_</code> environment variables from Vertex AI as in <a href="https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements" rel="nofollow">Vertex AI Documentation - Custom container requirements for prediction</a>.</p> <ul><li><code>NUM_SHARD</code> is the number of shards to use if you don’t want to use all GPUs on a given machine e.g. if you have two GPUs but you just want to use one for TGI then <code>NUM_SHARD=1</code>, otherwise it matches the <code>CUDA_VISIBLE_DEVICES</code>.</li> <li><code>MAX_INPUT_TOKENS</code> is the maximum allowed input length (expressed in number of tokens), the larger it is, the larger the prompt can be, but also more memory will be consumed.</li> <li><code>MAX_TOTAL_TOKENS</code> is the most important value to set as it defines the “memory budget” of running clients requests, the larger this value, the larger amount each request will be in your RAM and the less effective batching can be.</li> <li><code>MAX_BATCH_PREFILL_TOKENS</code> limits the number of tokens for the prefill operation, as it takes the most memory and is compute bound, it is interesting to limit the number of requests that can be sent.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model.</li></ul></li> <li><p>(optional) <strong><code>serving_container_ports</code></strong> is the port where the Vertex AI endpoint will be exposed, by default 8080.</p></li>',Lt,de,Tn='For more information on the supported <code>aiplatform.Model.upload</code> arguments, check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload</a>.',Yt,U,qt,me,zt,ue,gn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-model.png" alt="Model on Vertex AI Model Registry"/>',Dt,he,Jn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-model-path.png" alt="Model on Vertex AI Model Registry with path to GCS"/>',Pt,ye,Ot,Te,wn="After the model is registered on Vertex AI, you need to define the endpoint that you want to deploy the model to, and then link the model deployment to that endpoint resource.",Kt,ge,fn="To do so, you need to call the method <code>aiplatform.Endpoint.create</code> to create a new Vertex AI endpoint resource (which is not linked to a model or anything usable yet).",el,Je,tl,we,Un='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Vertex AI Endpoint created"/>',ll,fe,jn="Now you can deploy the registered model in an endpoint on Vertex AI.",nl,Ue,bn="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",sl,je,In="Before going into the code, let’s quicklyl review the arguments provided to the <code>deploy</code> method:",al,be,Cn='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',ol,Ie,vn='For more information on the supported <code>aiplatform.Model.deploy</code> arguments, you can check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy</a>.',il,Ce,pl,ve,Zn="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",rl,Ze,Gn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint-run.png" alt="Vertex AI Endpoint running the model"/>',cl,Ge,$n='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint-logs.png" alt="Vertex AI Endpoint logs in Cloud Logging"/>',Ml,$e,dl,Ae,An="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",ml,Ve,Vn='As you are serving a <code>text-generation</code> model, you will need to make sure that the chat template, if any, is applied correctly to the input conversation; meaning that <code>transformers</code> need to be installed so as to instantiate the <code>tokenizer</code> for <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> and run the <code>apply_chat_template</code> method over the input conversation before sending the input within the payload to the Vertex AI endpoint.',ul,Be,hl,xe,Bn="After the installation is complete, the following snippet will apply the chat template to the conversation:",yl,ke,Tl,Re,xn='Which is what you will be sending within the payload to the deployed Vertex AI Endpoint, as well as the generation parameters as in <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation</a>.',gl,_e,Jl,We,wl,Ne,kn="If you are willing to run the online prediction within the current session, you can send requests programmatically via the <code>aiplatform.Endpoint</code> (returned by the <code>aiplatform.Model.deploy</code> method) as in the following snippet:",fl,Ee,Ul,Xe,Rn="Producing the following <code>output</code>:",jl,Se,bl,Fe,Il,Qe,_n="If the Vertex AI Endpoint was deployed in a different session and you want to use it but don’t have access to the <code>deployed_model</code> variable returned by the <code>aiplatform.Model.deploy</code> method as in the previous section; you can also run the following snippet to instantiate the deployed <code>aiplatform.Endpoint</code> via its resource name as <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code>.",Cl,j,vl,He,Zl,Le,Gl,Ye,Wn="Alternatively, for testing purposes you can also use the Vertex AI Online Prediction UI, that provides a field that expects the JSON payload formatted according to the Vertex AI specification (as in the examples above) being:",$l,qe,Al,ze,Nn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-online-prediction.png" alt="Vertex AI Endpoint online inference"/>',Vl,De,Bl,Pe,En="Finally, you can already release the resources that you’ve created as follows, to avoid unnecessary costs:",xl,Oe,Xn="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",kl,b,Rl,Ke,_l,et,Sn="Alternatively, you can also remove those from the Google Cloud Console following the steps:",Wl,tt,Fn="<li>Go to Vertex AI in Google Cloud</li> <li>Go to Deploy and use -&gt; Online prediction</li> <li>Click on the endpoint and then on the deployed model/s to “Undeploy model from endpoint”</li> <li>Then go back to the endpoint list and remove the endpoint</li> <li>Finally, go to Deploy and use -&gt; Model Registry, and remove the model</li>",Nl,lt,Qn="Additionally, you may also want to remove the GCS Bucket, to do so, you can use the following <code>gcloud</code> command:",El,nt,Xl,st,Sl,I,Fl,at,Ql,ot,Hl;return C=new ns({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new J({props:{title:"Deploy Gemma 7B with TGI DLC from GCS on Vertex AI",local:"deploy-gemma-7b-with-tgi-dlc-from-gcs-on-vertex-ai",headingTag:"h1"}}),A=new J({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),x=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),R=new T({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMEJVQ0tFVF9VUkklM0RncyUzQSUyRiUyRnlvdXItYnVja2V0JTBBJTI1ZW52JTIwQVJUSUZBQ1RfTkFNRSUzRGdvb2dsZS0tZ2VtbWEtN2ItaXQlMEElMjVlbnYlMjBDT05UQUlORVJfVVJJJTNEdXMtZG9ja2VyLnBrZy5kZXYlMkZkZWVwbGVhcm5pbmctcGxhdGZvcm0tcmVsZWFzZSUyRmdjci5pbyUyRmh1Z2dpbmdmYWNlLXRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UtY3UxMjQuMi0zLnVidW50dTIyMDQucHkzMTE=",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env BUCKET_URI=gs://your-bucket
%env ARTIFACT_NAME=google--gemma-7b-it
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>ubuntu2204.py311`,wrap:!1}}),W=new T({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),E=new T({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),X=new J({props:{title:"Optional: Create bucket and upload model from Hub in GCS",local:"optional-create-bucket-and-upload-model-from-hub-in-gcs",headingTag:"h2"}}),Q=new T({props:{code:"IWdjbG91ZCUyMGNvbXBvbmVudHMlMjBpbnN0YWxsJTIwZ3N1dGlsJTBBIXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwY3JjbW9k",highlighted:`!gcloud components install gsutil
!pip install --upgrade --quiet crcmod`,wrap:!1}}),L=new T({props:{code:"JTI1JTI1YmFzaCUwQSUwQSUyMyUyMFBhcnNlJTIwdGhlJTIwYnVja2V0JTIwZnJvbSUyMHRoZSUyMHByb3ZpZGVkJTIwJTI0QlVDS0VUX1VSSSUyMHBhdGglMjBpLmUuJTIwZ2l2ZW4lMjBncyUzQSUyRiUyRmJ1Y2tldC1uYW1lJTJGZGlyJTJDJTIwZXh0cmFjdCUyMGJ1Y2tldC1uYW1lJTBBQlVDS0VUX05BTUUlM0QlMjQoZWNobyUyMCUyNEJVQ0tFVF9VUkklMjAlN0MlMjBjdXQlMjAtZCclMkYnJTIwLWYzKSUwQSUyMyUyMENoZWNrJTIwaWYlMjB0aGUlMjBidWNrZXQlMjBleGlzdHMlMkMlMjBpZiUyMG5vdCUyMGNyZWF0ZSUyMGl0JTBBaWYlMjAlNUIlMjAteiUyMCUyMiUyNChnc3V0aWwlMjBscyUyMCU3QyUyMGdyZXAlMjBncyUzQSUyRiUyRiUyNEJVQ0tFVF9OQU1FKSUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBnY2xvdWQlMjBzdG9yYWdlJTIwYnVja2V0cyUyMGNyZWF0ZSUyMGdzJTNBJTJGJTJGJTI0QlVDS0VUX05BTUUlMjAtLXByb2plY3QlM0QlMjRQUk9KRUNUX0lEJTIwLS1sb2NhdGlvbiUzRCUyNExPQ0FUSU9OJTIwLS1kZWZhdWx0LXN0b3JhZ2UtY2xhc3MlM0RTVEFOREFSRCUyMC0tdW5pZm9ybS1idWNrZXQtbGV2ZWwtYWNjZXNzJTBBZmk=",highlighted:`%%bash

<span class="hljs-comment"># Parse the bucket from the provided $BUCKET_URI path i.e. given gs://bucket-name/dir, extract bucket-name</span>
BUCKET_NAME=$(echo $BUCKET_URI | cut -d<span class="hljs-string">&#x27;/&#x27;</span> -f3)
<span class="hljs-comment"># Check if the bucket exists, if not create it</span>
<span class="hljs-keyword">if</span> [ -z <span class="hljs-string">&quot;$(gsutil ls | grep gs://$BUCKET_NAME)&quot;</span> ]; then
    gcloud storage buckets create gs://$BUCKET_NAME --project=$PROJECT_ID --location=$LOCATION --default-storage-<span class="hljs-keyword">class</span>=STANDARD --uniform-bucket-level-access
fi`,wrap:!1}}),q=new J({props:{title:"Artifact from disk / local storage",local:"artifact-from-disk--local-storage",headingTag:"h3"}}),D=new T({props:{code:"JTI1JTI1YmFzaCUwQSUyMyUyMFVwbG9hZCUyMHRoZSUyMG1vZGVsJTIwdG8lMjBHb29nbGUlMjBDbG91ZCUyMFN0b3JhZ2UlMEFMT0NBTF9ESVIlM0R+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLWdvb2dsZS0tZ2VtbWEtN2ItaXQlMkZzbmFwc2hvdHMlMkY4YWRhYjZhMzVmZGJjZGFlMGFlNDFhYjFmNzExYjFiYzhkMDU3MjdlJTBBaWYlMjAlNUIlMjAtZCUyMCUyMiUyNExPQ0FMX0RJUiUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBnc3V0aWwlMjAtbyUyMEdTVXRpbCUzQXBhcmFsbGVsX2NvbXBvc2l0ZV91cGxvYWRfdGhyZXNob2xkJTNEMTUwTSUyMC1tJTIwY3AlMjAtciUyMCUyNExPQ0FMX0RJUiUyRiolMjAlMjRCVUNLRVRfVVJJJTJGJTI0QVJUSUZBQ1RfTkFNRSUwQWZp",highlighted:`%%bash
<span class="hljs-comment"># Upload the model to Google Cloud Storage</span>
LOCAL_DIR=~/.cache/huggingface/hub/models--google--gemma-7b-it/snapshots/8adab6a35fdbcdae0ae41ab1f711b1bc8d05727e
<span class="hljs-keyword">if</span> [ -d <span class="hljs-string">&quot;$LOCAL_DIR&quot;</span> ]; then
    gsutil -o GSUtil:parallel_composite_upload_threshold=150M -m cp -r $LOCAL_DIR/* $BUCKET_URI/$ARTIFACT_NAME
fi`,wrap:!1}}),P=new J({props:{title:"Artifact from Hugging Face Hub",local:"artifact-from-hugging-face-hub",headingTag:"h3"}}),ee=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJoZl90cmFuc2ZlciU1RCUyMiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:'!pip install <span class="hljs-string">&quot;huggingface_hub[hf_transfer]&quot;</span> --upgrade --quiet',wrap:!1}}),te=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),ne=new T({props:{code:"JTI1JTI1YmFzaCUwQSUyMyUyMEVuc3VyZSUyMHRoZSUyMG5lY2Vzc2FyeSUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwYXJlJTIwc2V0JTBBZXhwb3J0JTIwSEZfSFVCX0VOQUJMRV9IRl9UUkFOU0ZFUiUzRDElMEElMEElMjMlMjAlMjMlMjBDcmVhdGUlMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnklMjB0byUyMHN0b3JlJTIwdGhlJTIwZG93bmxvYWRlZCUyMG1vZGVscyUwQUxPQ0FMX0RJUiUzRCUyMnRtcCUyRmdvb2dsZS0tZ2VtbWEtN2ItaXQlMjIlMEFta2RpciUyMC1wJTIwJTI0TE9DQUxfRElSJTBBJTBBJTIzJTIwJTIzJTIwRG93bmxvYWQlMjBtb2RlbHMlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMkMlMjBleGNsdWRpbmclMjBjZXJ0YWluJTIwZmlsZSUyMHR5cGVzJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBnb29nbGUlMkZnZW1tYS03Yi1pdCUyMC0tZXhjbHVkZSUyMCUyMiouYmluJTIyJTIwJTIyKi5wdGglMjIlMjAlMjIqLmdndWYlMjIlMjAlMjIuZ2l0YXR0cmlidXRlcyUyMiUyMC0tbG9jYWwtZGlyJTIwJTI0TE9DQUxfRElSJTBBJTBBJTIzJTIwVXBsb2FkJTIwdGhlJTIwZG93bmxvYWRlZCUyMG1vZGVscyUyMHRvJTIwR29vZ2xlJTIwQ2xvdWQlMjBTdG9yYWdlJTBBZ3N1dGlsJTIwLW8lMjBHU1V0aWwlM0FwYXJhbGxlbF9jb21wb3NpdGVfdXBsb2FkX3RocmVzaG9sZCUzRDE1ME0lMjAtbSUyMGNwJTIwLWUlMjAtciUyMCUyNExPQ0FMX0RJUiUyRiolMjAlMjRCVUNLRVRfVVJJJTJGJTI0QVJUSUZBQ1RfTkFNRSUwQSUwQSUyMyUyMFJlbW92ZSUyMGFsbCUyMGZpbGVzJTIwYW5kJTIwaGlkZGVuJTIwZmlsZXMlMjBpbiUyMHRoZSUyMHRhcmdldCUyMGRpcmVjdG9yeSUwQXJtJTIwLXJmJTIwdG1wJTJG",highlighted:`%%bash
<span class="hljs-comment"># Ensure the necessary environment variables are set</span>
export HF_HUB_ENABLE_HF_TRANSFER=<span class="hljs-number">1</span>

<span class="hljs-comment"># # Create a local directory to store the downloaded models</span>
LOCAL_DIR=<span class="hljs-string">&quot;tmp/google--gemma-7b-it&quot;</span>
mkdir -p $LOCAL_DIR

<span class="hljs-comment"># # Download models from HuggingFace, excluding certain file types</span>
huggingface-cli download google/gemma-7b-it --exclude <span class="hljs-string">&quot;*.bin&quot;</span> <span class="hljs-string">&quot;*.pth&quot;</span> <span class="hljs-string">&quot;*.gguf&quot;</span> <span class="hljs-string">&quot;.gitattributes&quot;</span> --local-<span class="hljs-built_in">dir</span> $LOCAL_DIR

<span class="hljs-comment"># Upload the downloaded models to Google Cloud Storage</span>
gsutil -o GSUtil:parallel_composite_upload_threshold=150M -m cp -e -r $LOCAL_DIR/* $BUCKET_URI/$ARTIFACT_NAME

<span class="hljs-comment"># Remove all files and hidden files in the target directory</span>
rm -rf tmp/`,wrap:!1}}),oe=new J({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),pe=new T({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBJTIwJTIwJTIwJTIwc3RhZ2luZ19idWNrZXQlM0Rvcy5nZXRlbnYoJTIyQlVDS0VUX1VSSSUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
    staging_bucket=os.getenv(<span class="hljs-string">&quot;BUCKET_URI&quot;</span>),
)`,wrap:!1}}),U=new Ll({props:{$$slots:{default:[as]},$$scope:{ctx:f}}}),me=new T({props:{code:"bW9kZWwlMjAlM0QlMjBhaXBsYXRmb3JtLk1vZGVsLnVwbG9hZCglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJ0aWZhY3RfdXJpJTNEZiUyMiU3Qm9zLmdldGVudignQlVDS0VUX1VSSScpJTdEJTJGJTdCb3MuZ2V0ZW52KCdBUlRJRkFDVF9OQU1FJyklN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9pbWFnZV91cmklM0Rvcy5nZXRlbnYoJTIyQ09OVEFJTkVSX1VSSSUyMiklMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9lbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOVU1fU0hBUkQlMjIlM0ElMjAlMjIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX1RPS0VOUyUyMiUzQSUyMCUyMjUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9UT1RBTF9UT0tFTlMlMjIlM0ElMjAlMjIxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0JBVENIX1BSRUZJTExfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX3BvcnRzJTNEJTVCODA4MCU1RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;google--gemma-7b-it&quot;</span>,
    artifact_uri=<span class="hljs-string">f&quot;<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>)}</span>/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ARTIFACT_NAME&#x27;</span>)}</span>&quot;</span>,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;NUM_SHARD&quot;</span>: <span class="hljs-string">&quot;1&quot;</span>,
        <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
        <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
        <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()`,wrap:!1}}),ye=new J({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),Je=new T({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0LWVuZHBvaW50JTIyKQ==",highlighted:'endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>)',wrap:!1}}),Ce=new T({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),$e=new J({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),Be=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwdHJhbnNmb3JtZXJz",highlighted:"!pip install --upgrade --quiet transformers",wrap:!1}}),ke=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtN2ItaXQlMjIlMkMlMjB0b2tlbiUzRGdldF90b2tlbigpKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSklMEElMjMlMjAlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-7b-it&quot;</span>, token=get_token())

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s Deep Learning?&quot;</span>},
]

inputs = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># &lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n</span>`,wrap:!1}}),_e=new J({props:{title:"Via Python",local:"via-python",headingTag:"h3"}}),We=new J({props:{title:"Within the same session",local:"within-the-same-session",headingTag:"h4"}}),Ee=new T({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbnN0YW5jZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjAlMjIlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjU2JTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMC45NSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXByaW50KG91dHB1dC5wcmVkaWN0aW9ucyU1QjAlNUQp",highlighted:`output = deployed_model.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>,
            },
        },
    ]
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),Se=new T({props:{code:"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",highlighted:'<span class="hljs-constructor">Prediction(<span class="hljs-params">predictions</span>=[&#x27;\\<span class="hljs-params">n</span>\\<span class="hljs-params">nDeep</span> <span class="hljs-params">learning</span> <span class="hljs-params">is</span> <span class="hljs-params">a</span> <span class="hljs-params">type</span> <span class="hljs-params">of</span> <span class="hljs-params">machine</span> <span class="hljs-params">learning</span> <span class="hljs-params">that</span> <span class="hljs-params">uses</span> <span class="hljs-params">artificial</span> <span class="hljs-params">neural</span> <span class="hljs-params">networks</span> <span class="hljs-params">to</span> <span class="hljs-params">learn</span> <span class="hljs-params">from</span> <span class="hljs-params">large</span> <span class="hljs-params">amounts</span> <span class="hljs-params">of</span> <span class="hljs-params">data</span>, <span class="hljs-params">making</span> <span class="hljs-params">it</span> <span class="hljs-params">a</span> <span class="hljs-params">powerful</span> <span class="hljs-params">tool</span> <span class="hljs-params">for</span> <span class="hljs-params">various</span> <span class="hljs-params">tasks</span>, <span class="hljs-params">including</span> <span class="hljs-params">image</span> <span class="hljs-params">recognition</span>, <span class="hljs-params">natural</span> <span class="hljs-params">language</span> <span class="hljs-params">processing</span>, <span class="hljs-params">and</span> <span class="hljs-params">speech</span> <span class="hljs-params">recognition</span>.\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">**</span>Key Concepts:<span class="hljs-operator">**</span>\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">*</span> <span class="hljs-operator">**</span>Artificial Neural Networks (ANNs)</span>:** Structures that mimic the interconnected neurons <span class="hljs-keyword">in</span> the brain.\\n* **Deep Learning Architectures:** Multi-layered ANNs that learn hierarchical features from data.\\n* **Transfer Learning:** Reusing learned features from one task <span class="hljs-keyword">to</span> improve performance on another.\\n\\n**Types <span class="hljs-keyword">of</span> Deep Learning:**\\n\\n* **Supervised Learning:** Models are trained on labeled data, where inputs are paired <span class="hljs-keyword">with</span> corresponding outputs.\\n* **Unsupervised Learning:** Models learn patterns from unlabeled data, such <span class="hljs-keyword">as</span> clustering <span class="hljs-keyword">or</span> dimensionality reduction.\\n* **Reinforcement Learning:** Models learn through trial-<span class="hljs-keyword">and</span>-error by interacting <span class="hljs-keyword">with</span> an environment <span class="hljs-keyword">to</span> optimize a task.\\n\\n**Benefits:**\\n\\n* **High Accuracy:** Deep learning models can achieve high accuracy on complex tasks.\\n* **Adaptability:** Deep learning models can adapt <span class="hljs-keyword">to</span> <span class="hljs-keyword">new</span> data <span class="hljs-keyword">and</span> tasks.\\n* **Scalability:** Deep learning models can handle large amounts <span class="hljs-keyword">of</span> data.\\n\\n**Applications:**\\n\\n* Image recognition\\n* Natural language processing (NLP)\\n&#x27;], deployed_model_id=&#x27;***&#x27;, metadata=None, model_version_id=<span class="hljs-character">&#x27;1&#x27;</span>, model_resource_name=&#x27;projects<span class="hljs-comment">/***/</span>locations/us-central1/models<span class="hljs-comment">/***&#x27;, explanations=None)</span>',wrap:!1}}),Fe=new J({props:{title:"From a different session",local:"from-a-different-session",headingTag:"h4"}}),j=new Ll({props:{$$slots:{default:[os]},$$scope:{ctx:f}}}),He=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>), location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>))

endpoint_display_name = <span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>  <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> change to your endpoint display name</span>

<span class="hljs-comment"># Iterates over all the Vertex AI Endpoints within the current project and keeps the first match (if any), otherwise set to None</span>
ENDPOINT_ID = <span class="hljs-built_in">next</span>(
    (endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> aiplatform.Endpoint.<span class="hljs-built_in">list</span>() 
     <span class="hljs-keyword">if</span> endpoint.display_name == endpoint_display_name), 
    <span class="hljs-literal">None</span>
)
<span class="hljs-keyword">assert</span> ENDPOINT_ID, (
    <span class="hljs-string">&quot;\`ENDPOINT_ID\` is not set, please make sure that the \`endpoint_display_name\` is correct at &quot;</span>\\
    <span class="hljs-string">f&quot;https://console.cloud.google.com/vertex-ai/online-prediction/endpoints?project=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>&quot;</span>
)

endpoint = aiplatform.Endpoint(<span class="hljs-string">f&quot;projects/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>/locations/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_ID}</span>&quot;</span>)
output = endpoint.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
            },
        },
    ],
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),Le=new J({props:{title:"Via the Vertex AI Online Prediction UI",local:"via-the-vertex-ai-online-prediction-ui",headingTag:"h3"}}),qe=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdGFuY2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTNDYm9zJTNFJTNDc3RhcnRfb2ZfdHVybiUzRXVzZXIlNUNuV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTNDZW5kX29mX3R1cm4lM0UlNUNuJTNDc3RhcnRfb2ZfdHVybiUzRW1vZGVsJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;instances&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;max_new_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;do_sample&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;top_p&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.95</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;temperature&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),De=new J({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),b=new Ll({props:{$$slots:{default:[is]},$$scope:{ctx:f}}}),Ke=new T({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),nt=new T({props:{code:"IWdjbG91ZCUyMHN0b3JhZ2UlMjBybSUyMC1yJTIwJTI0QlVDS0VUX1VSSQ==",highlighted:"!gcloud storage rm -r $BUCKET_URI",wrap:!1}}),st=new J({props:{title:"Or, alternatively, just remove the bucket and/or its contents from the Google Cloud Console.",local:"or-alternatively-just-remove-the-bucket-andor-its-contents-from-the-google-cloud-console",headingTag:"h2"}}),I=new Ll({props:{$$slots:{default:[ps]},$$scope:{ctx:f}}}),at=new ss({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-gemma-from-gcs-on-vertex-ai.mdx"}}),{c(){h=o("meta"),g=s(),y=o("p"),w=s(),r(C.$$.fragment),it=s(),r(v.$$.fragment),pt=s(),Z=o("p"),Z.textContent=ql,rt=s(),G=o("p"),G.innerHTML=zl,ct=s(),$=o("p"),$.innerHTML=Dl,Mt=s(),r(A.$$.fragment),dt=s(),V=o("p"),V.innerHTML=Pl,mt=s(),B=o("p"),B.innerHTML=Ol,ut=s(),r(x.$$.fragment),ht=s(),k=o("p"),k.textContent=Kl,yt=s(),r(R.$$.fragment),Tt=s(),_=o("p"),_.textContent=en,gt=s(),r(W.$$.fragment),Jt=s(),N=o("p"),N.textContent=tn,wt=s(),r(E.$$.fragment),ft=s(),r(X.$$.fragment),Ut=s(),S=o("p"),S.textContent=ln,jt=s(),F=o("p"),F.innerHTML=nn,bt=s(),r(Q.$$.fragment),It=s(),H=o("p"),H.textContent=sn,Ct=s(),r(L.$$.fragment),vt=s(),Y=o("p"),Y.innerHTML=an,Zt=s(),r(q.$$.fragment),Gt=s(),z=o("p"),z.innerHTML=on,$t=s(),r(D.$$.fragment),At=s(),r(P.$$.fragment),Vt=s(),O=o("p"),O.innerHTML=pn,Bt=s(),K=o("p"),K.innerHTML=rn,xt=s(),r(ee.$$.fragment),kt=s(),r(te.$$.fragment),Rt=s(),le=o("p"),le.innerHTML=cn,_t=s(),r(ne.$$.fragment),Wt=s(),se=o("p"),se.innerHTML=Mn,Nt=s(),ae=o("p"),ae.innerHTML=dn,Et=s(),r(oe.$$.fragment),Xt=s(),ie=o("p"),ie.innerHTML=mn,St=s(),r(pe.$$.fragment),Ft=s(),re=o("p"),re.textContent=un,Qt=s(),ce=o("p"),ce.innerHTML=hn,Ht=s(),Me=o("ul"),Me.innerHTML=yn,Lt=s(),de=o("p"),de.innerHTML=Tn,Yt=s(),r(U.$$.fragment),qt=s(),r(me.$$.fragment),zt=s(),ue=o("p"),ue.innerHTML=gn,Dt=s(),he=o("p"),he.innerHTML=Jn,Pt=s(),r(ye.$$.fragment),Ot=s(),Te=o("p"),Te.textContent=wn,Kt=s(),ge=o("p"),ge.innerHTML=fn,el=s(),r(Je.$$.fragment),tl=s(),we=o("p"),we.innerHTML=Un,ll=s(),fe=o("p"),fe.textContent=jn,nl=s(),Ue=o("p"),Ue.innerHTML=bn,sl=s(),je=o("p"),je.innerHTML=In,al=s(),be=o("ul"),be.innerHTML=Cn,ol=s(),Ie=o("p"),Ie.innerHTML=vn,il=s(),r(Ce.$$.fragment),pl=s(),ve=o("p"),ve.innerHTML=Zn,rl=s(),Ze=o("p"),Ze.innerHTML=Gn,cl=s(),Ge=o("p"),Ge.innerHTML=$n,Ml=s(),r($e.$$.fragment),dl=s(),Ae=o("p"),Ae.innerHTML=An,ml=s(),Ve=o("p"),Ve.innerHTML=Vn,ul=s(),r(Be.$$.fragment),hl=s(),xe=o("p"),xe.textContent=Bn,yl=s(),r(ke.$$.fragment),Tl=s(),Re=o("p"),Re.innerHTML=xn,gl=s(),r(_e.$$.fragment),Jl=s(),r(We.$$.fragment),wl=s(),Ne=o("p"),Ne.innerHTML=kn,fl=s(),r(Ee.$$.fragment),Ul=s(),Xe=o("p"),Xe.innerHTML=Rn,jl=s(),r(Se.$$.fragment),bl=s(),r(Fe.$$.fragment),Il=s(),Qe=o("p"),Qe.innerHTML=_n,Cl=s(),r(j.$$.fragment),vl=s(),r(He.$$.fragment),Zl=s(),r(Le.$$.fragment),Gl=s(),Ye=o("p"),Ye.textContent=Wn,$l=s(),r(qe.$$.fragment),Al=s(),ze=o("p"),ze.innerHTML=Nn,Vl=s(),r(De.$$.fragment),Bl=s(),Pe=o("p"),Pe.textContent=En,xl=s(),Oe=o("ul"),Oe.innerHTML=Xn,kl=s(),r(b.$$.fragment),Rl=s(),r(Ke.$$.fragment),_l=s(),et=o("p"),et.textContent=Sn,Wl=s(),tt=o("ul"),tt.innerHTML=Fn,Nl=s(),lt=o("p"),lt.innerHTML=Qn,El=s(),r(nt.$$.fragment),Xl=s(),r(st.$$.fragment),Sl=s(),r(I.$$.fragment),Fl=s(),r(at.$$.fragment),Ql=s(),ot=o("p"),this.h()},l(e){const t=ts("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),g=a(e),y=i(e,"P",{}),zn(y).forEach(l),w=a(e),c(C.$$.fragment,e),it=a(e),c(v.$$.fragment,e),pt=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-9afh3f"&&(Z.textContent=ql),rt=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-ghxzxz"&&(G.innerHTML=zl),ct=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1tfb3hf"&&($.innerHTML=Dl),Mt=a(e),c(A.$$.fragment,e),dt=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1o67gfb"&&(V.innerHTML=Pl),mt=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1ebrquh"&&(B.innerHTML=Ol),ut=a(e),c(x.$$.fragment,e),ht=a(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1i8n6rq"&&(k.textContent=Kl),yt=a(e),c(R.$$.fragment,e),Tt=a(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-15nvzfz"&&(_.textContent=en),gt=a(e),c(W.$$.fragment,e),Jt=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1nm8o2l"&&(N.textContent=tn),wt=a(e),c(E.$$.fragment,e),ft=a(e),c(X.$$.fragment,e),Ut=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ytajks"&&(S.textContent=ln),jt=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-e12o6k"&&(F.innerHTML=nn),bt=a(e),c(Q.$$.fragment,e),It=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-cxcyab"&&(H.textContent=sn),Ct=a(e),c(L.$$.fragment,e),vt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-d11vo2"&&(Y.innerHTML=an),Zt=a(e),c(q.$$.fragment,e),Gt=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-sdydm2"&&(z.innerHTML=on),$t=a(e),c(D.$$.fragment,e),At=a(e),c(P.$$.fragment,e),Vt=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-p7l1hu"&&(O.innerHTML=pn),Bt=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1c2zn5r"&&(K.innerHTML=rn),xt=a(e),c(ee.$$.fragment,e),kt=a(e),c(te.$$.fragment,e),Rt=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1mqzlv7"&&(le.innerHTML=cn),_t=a(e),c(ne.$$.fragment,e),Wt=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1nja5im"&&(se.innerHTML=Mn),Nt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1kl2jg3"&&(ae.innerHTML=dn),Et=a(e),c(oe.$$.fragment,e),Xt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-14aynbe"&&(ie.innerHTML=mn),St=a(e),c(pe.$$.fragment,e),Ft=a(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-nto2bx"&&(re.textContent=un),Qt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-zklutt"&&(ce.innerHTML=hn),Ht=a(e),Me=i(e,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-1fb4x93"&&(Me.innerHTML=yn),Lt=a(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1flszm1"&&(de.innerHTML=Tn),Yt=a(e),c(U.$$.fragment,e),qt=a(e),c(me.$$.fragment,e),zt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-wh1hoy"&&(ue.innerHTML=gn),Dt=a(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1qp0mlv"&&(he.innerHTML=Jn),Pt=a(e),c(ye.$$.fragment,e),Ot=a(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-2nwexf"&&(Te.textContent=wn),Kt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1lovlvw"&&(ge.innerHTML=fn),el=a(e),c(Je.$$.fragment,e),tl=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1oxifpd"&&(we.innerHTML=Un),ll=a(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-it668a"&&(fe.textContent=jn),nl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-njbdvc"&&(Ue.innerHTML=bn),sl=a(e),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-v5hhrl"&&(je.innerHTML=In),al=a(e),be=i(e,"UL",{"data-svelte-h":!0}),p(be)!=="svelte-1mv29i5"&&(be.innerHTML=Cn),ol=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-9p37qa"&&(Ie.innerHTML=vn),il=a(e),c(Ce.$$.fragment,e),pl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-mraq68"&&(ve.innerHTML=Zn),rl=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-10wybi0"&&(Ze.innerHTML=Gn),cl=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-ffexfv"&&(Ge.innerHTML=$n),Ml=a(e),c($e.$$.fragment,e),dl=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-166ya0u"&&(Ae.innerHTML=An),ml=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-17alodq"&&(Ve.innerHTML=Vn),ul=a(e),c(Be.$$.fragment,e),hl=a(e),xe=i(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-rj4r5t"&&(xe.textContent=Bn),yl=a(e),c(ke.$$.fragment,e),Tl=a(e),Re=i(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-nq4b4r"&&(Re.innerHTML=xn),gl=a(e),c(_e.$$.fragment,e),Jl=a(e),c(We.$$.fragment,e),wl=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-hnmp6i"&&(Ne.innerHTML=kn),fl=a(e),c(Ee.$$.fragment,e),Ul=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-d9pmg3"&&(Xe.innerHTML=Rn),jl=a(e),c(Se.$$.fragment,e),bl=a(e),c(Fe.$$.fragment,e),Il=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-gm5hxo"&&(Qe.innerHTML=_n),Cl=a(e),c(j.$$.fragment,e),vl=a(e),c(He.$$.fragment,e),Zl=a(e),c(Le.$$.fragment,e),Gl=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1ajbcx5"&&(Ye.textContent=Wn),$l=a(e),c(qe.$$.fragment,e),Al=a(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-13ph86t"&&(ze.innerHTML=Nn),Vl=a(e),c(De.$$.fragment,e),Bl=a(e),Pe=i(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-l6tvv1"&&(Pe.textContent=En),xl=a(e),Oe=i(e,"UL",{"data-svelte-h":!0}),p(Oe)!=="svelte-16ibgml"&&(Oe.innerHTML=Xn),kl=a(e),c(b.$$.fragment,e),Rl=a(e),c(Ke.$$.fragment,e),_l=a(e),et=i(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-sgegyq"&&(et.textContent=Sn),Wl=a(e),tt=i(e,"UL",{"data-svelte-h":!0}),p(tt)!=="svelte-1p833nz"&&(tt.innerHTML=Fn),Nl=a(e),lt=i(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1akxsu0"&&(lt.innerHTML=Qn),El=a(e),c(nt.$$.fragment,e),Xl=a(e),c(st.$$.fragment,e),Sl=a(e),c(I.$$.fragment,e),Fl=a(e),c(at.$$.fragment,e),Ql=a(e),ot=i(e,"P",{}),zn(ot).forEach(l),this.h()},h(){Dn(h,"name","hf:doc:metadata"),Dn(h,"content",cs)},m(e,t){ls(document.head,h),n(e,g,t),n(e,y,t),n(e,w,t),M(C,e,t),n(e,it,t),M(v,e,t),n(e,pt,t),n(e,Z,t),n(e,rt,t),n(e,G,t),n(e,ct,t),n(e,$,t),n(e,Mt,t),M(A,e,t),n(e,dt,t),n(e,V,t),n(e,mt,t),n(e,B,t),n(e,ut,t),M(x,e,t),n(e,ht,t),n(e,k,t),n(e,yt,t),M(R,e,t),n(e,Tt,t),n(e,_,t),n(e,gt,t),M(W,e,t),n(e,Jt,t),n(e,N,t),n(e,wt,t),M(E,e,t),n(e,ft,t),M(X,e,t),n(e,Ut,t),n(e,S,t),n(e,jt,t),n(e,F,t),n(e,bt,t),M(Q,e,t),n(e,It,t),n(e,H,t),n(e,Ct,t),M(L,e,t),n(e,vt,t),n(e,Y,t),n(e,Zt,t),M(q,e,t),n(e,Gt,t),n(e,z,t),n(e,$t,t),M(D,e,t),n(e,At,t),M(P,e,t),n(e,Vt,t),n(e,O,t),n(e,Bt,t),n(e,K,t),n(e,xt,t),M(ee,e,t),n(e,kt,t),M(te,e,t),n(e,Rt,t),n(e,le,t),n(e,_t,t),M(ne,e,t),n(e,Wt,t),n(e,se,t),n(e,Nt,t),n(e,ae,t),n(e,Et,t),M(oe,e,t),n(e,Xt,t),n(e,ie,t),n(e,St,t),M(pe,e,t),n(e,Ft,t),n(e,re,t),n(e,Qt,t),n(e,ce,t),n(e,Ht,t),n(e,Me,t),n(e,Lt,t),n(e,de,t),n(e,Yt,t),M(U,e,t),n(e,qt,t),M(me,e,t),n(e,zt,t),n(e,ue,t),n(e,Dt,t),n(e,he,t),n(e,Pt,t),M(ye,e,t),n(e,Ot,t),n(e,Te,t),n(e,Kt,t),n(e,ge,t),n(e,el,t),M(Je,e,t),n(e,tl,t),n(e,we,t),n(e,ll,t),n(e,fe,t),n(e,nl,t),n(e,Ue,t),n(e,sl,t),n(e,je,t),n(e,al,t),n(e,be,t),n(e,ol,t),n(e,Ie,t),n(e,il,t),M(Ce,e,t),n(e,pl,t),n(e,ve,t),n(e,rl,t),n(e,Ze,t),n(e,cl,t),n(e,Ge,t),n(e,Ml,t),M($e,e,t),n(e,dl,t),n(e,Ae,t),n(e,ml,t),n(e,Ve,t),n(e,ul,t),M(Be,e,t),n(e,hl,t),n(e,xe,t),n(e,yl,t),M(ke,e,t),n(e,Tl,t),n(e,Re,t),n(e,gl,t),M(_e,e,t),n(e,Jl,t),M(We,e,t),n(e,wl,t),n(e,Ne,t),n(e,fl,t),M(Ee,e,t),n(e,Ul,t),n(e,Xe,t),n(e,jl,t),M(Se,e,t),n(e,bl,t),M(Fe,e,t),n(e,Il,t),n(e,Qe,t),n(e,Cl,t),M(j,e,t),n(e,vl,t),M(He,e,t),n(e,Zl,t),M(Le,e,t),n(e,Gl,t),n(e,Ye,t),n(e,$l,t),M(qe,e,t),n(e,Al,t),n(e,ze,t),n(e,Vl,t),M(De,e,t),n(e,Bl,t),n(e,Pe,t),n(e,xl,t),n(e,Oe,t),n(e,kl,t),M(b,e,t),n(e,Rl,t),M(Ke,e,t),n(e,_l,t),n(e,et,t),n(e,Wl,t),n(e,tt,t),n(e,Nl,t),n(e,lt,t),n(e,El,t),M(nt,e,t),n(e,Xl,t),M(st,e,t),n(e,Sl,t),M(I,e,t),n(e,Fl,t),M(at,e,t),n(e,Ql,t),n(e,ot,t),Hl=!0},p(e,[t]){const Hn={};t&2&&(Hn.$$scope={dirty:t,ctx:e}),U.$set(Hn);const Ln={};t&2&&(Ln.$$scope={dirty:t,ctx:e}),j.$set(Ln);const Yn={};t&2&&(Yn.$$scope={dirty:t,ctx:e}),b.$set(Yn);const qn={};t&2&&(qn.$$scope={dirty:t,ctx:e}),I.$set(qn)},i(e){Hl||(d(C.$$.fragment,e),d(v.$$.fragment,e),d(A.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(W.$$.fragment,e),d(E.$$.fragment,e),d(X.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(U.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(Je.$$.fragment,e),d(Ce.$$.fragment,e),d($e.$$.fragment,e),d(Be.$$.fragment,e),d(ke.$$.fragment,e),d(_e.$$.fragment,e),d(We.$$.fragment,e),d(Ee.$$.fragment,e),d(Se.$$.fragment,e),d(Fe.$$.fragment,e),d(j.$$.fragment,e),d(He.$$.fragment,e),d(Le.$$.fragment,e),d(qe.$$.fragment,e),d(De.$$.fragment,e),d(b.$$.fragment,e),d(Ke.$$.fragment,e),d(nt.$$.fragment,e),d(st.$$.fragment,e),d(I.$$.fragment,e),d(at.$$.fragment,e),Hl=!0)},o(e){m(C.$$.fragment,e),m(v.$$.fragment,e),m(A.$$.fragment,e),m(x.$$.fragment,e),m(R.$$.fragment,e),m(W.$$.fragment,e),m(E.$$.fragment,e),m(X.$$.fragment,e),m(Q.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(U.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(Je.$$.fragment,e),m(Ce.$$.fragment,e),m($e.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(_e.$$.fragment,e),m(We.$$.fragment,e),m(Ee.$$.fragment,e),m(Se.$$.fragment,e),m(Fe.$$.fragment,e),m(j.$$.fragment,e),m(He.$$.fragment,e),m(Le.$$.fragment,e),m(qe.$$.fragment,e),m(De.$$.fragment,e),m(b.$$.fragment,e),m(Ke.$$.fragment,e),m(nt.$$.fragment,e),m(st.$$.fragment,e),m(I.$$.fragment,e),m(at.$$.fragment,e),Hl=!1},d(e){e&&(l(g),l(y),l(w),l(it),l(pt),l(Z),l(rt),l(G),l(ct),l($),l(Mt),l(dt),l(V),l(mt),l(B),l(ut),l(ht),l(k),l(yt),l(Tt),l(_),l(gt),l(Jt),l(N),l(wt),l(ft),l(Ut),l(S),l(jt),l(F),l(bt),l(It),l(H),l(Ct),l(vt),l(Y),l(Zt),l(Gt),l(z),l($t),l(At),l(Vt),l(O),l(Bt),l(K),l(xt),l(kt),l(Rt),l(le),l(_t),l(Wt),l(se),l(Nt),l(ae),l(Et),l(Xt),l(ie),l(St),l(Ft),l(re),l(Qt),l(ce),l(Ht),l(Me),l(Lt),l(de),l(Yt),l(qt),l(zt),l(ue),l(Dt),l(he),l(Pt),l(Ot),l(Te),l(Kt),l(ge),l(el),l(tl),l(we),l(ll),l(fe),l(nl),l(Ue),l(sl),l(je),l(al),l(be),l(ol),l(Ie),l(il),l(pl),l(ve),l(rl),l(Ze),l(cl),l(Ge),l(Ml),l(dl),l(Ae),l(ml),l(Ve),l(ul),l(hl),l(xe),l(yl),l(Tl),l(Re),l(gl),l(Jl),l(wl),l(Ne),l(fl),l(Ul),l(Xe),l(jl),l(bl),l(Il),l(Qe),l(Cl),l(vl),l(Zl),l(Gl),l(Ye),l($l),l(Al),l(ze),l(Vl),l(Bl),l(Pe),l(xl),l(Oe),l(kl),l(Rl),l(_l),l(et),l(Wl),l(tt),l(Nl),l(lt),l(El),l(Xl),l(Sl),l(Fl),l(Ql),l(ot)),l(h),u(C,e),u(v,e),u(A,e),u(x,e),u(R,e),u(W,e),u(E,e),u(X,e),u(Q,e),u(L,e),u(q,e),u(D,e),u(P,e),u(ee,e),u(te,e),u(ne,e),u(oe,e),u(pe,e),u(U,e),u(me,e),u(ye,e),u(Je,e),u(Ce,e),u($e,e),u(Be,e),u(ke,e),u(_e,e),u(We,e),u(Ee,e),u(Se,e),u(Fe,e),u(j,e),u(He,e),u(Le,e),u(qe,e),u(De,e),u(b,e),u(Ke,e),u(nt,e),u(st,e),u(I,e),u(at,e)}}}const cs='{"title":"Deploy Gemma 7B with TGI DLC from GCS on Vertex AI","local":"deploy-gemma-7b-with-tgi-dlc-from-gcs-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Optional: Create bucket and upload model from Hub in GCS","local":"optional-create-bucket-and-upload-model-from-hub-in-gcs","sections":[{"title":"Artifact from disk / local storage","local":"artifact-from-disk--local-storage","sections":[],"depth":3},{"title":"Artifact from Hugging Face Hub","local":"artifact-from-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[{"title":"Via Python","local":"via-python","sections":[{"title":"Within the same session","local":"within-the-same-session","sections":[],"depth":4},{"title":"From a different session","local":"from-a-different-session","sections":[],"depth":4}],"depth":3},{"title":"Via the Vertex AI Online Prediction UI","local":"via-the-vertex-ai-online-prediction-ui","sections":[],"depth":3}],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2},{"title":"Or, alternatively, just remove the bucket and/or its contents from the Google Cloud Console.","local":"or-alternatively-just-remove-the-bucket-andor-its-contents-from-the-google-cloud-console","sections":[],"depth":2}],"depth":1}';function Ms(f){return On(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends Kn{constructor(h){super(),es(this,h,Ms,rs,Pn,{})}}export{Ts as component};
