import{s as Pt,f as fe,o as Kt}from"../chunks/scheduler.37c15a92.js";import{S as Dt,i as Ot,g as i,s as a,r as c,m as qt,A as el,h as p,f as l,c as o,j as x,u,x as r,n as Ft,k as n,y as J,a as s,v as d,d as h,t as m,w as y}from"../chunks/index.7cb9c9b8.js";import{T as tl}from"../chunks/Tip.d10b3fc9.js";import{C as be}from"../chunks/CodeBlock.abae2786.js";import{C as ll}from"../chunks/CourseFloatingBanner.df82c153.js";import{H as de,E as sl}from"../chunks/index.c99deea2.js";function al(Te){let M;return{c(){M=qt("🙋If you're not familiar with the `with` statement in Python, we recommend checking out the excellent [tutorial](https://realpython.com/python-with-statement/) from Real Python. Come back here after reading that 🤗")},l(j){M=Ft(j,"🙋If you're not familiar with the `with` statement in Python, we recommend checking out the excellent [tutorial](https://realpython.com/python-with-statement/) from Real Python. Come back here after reading that 🤗")},m(j,k){s(j,M,k)},d(j){j&&l(M)}}}function ol(Te){let M,j,k,ge,B,Ce,G,Je,R,wt="In the previous sections we have explored and created demos using the <code>Interface</code> class. In this section we will introduce our <strong>newly developed</strong> low-level API called <code>gradio.Blocks</code>.",je,$,Ut="Now, what’s the difference between <code>Interface</code> and <code>Blocks</code>?",xe,E,ft="<li><p>⚡ <code>Interface</code>: a high-level API that allows you to create a full machine learning demo simply by providing a list of inputs and outputs.</p></li> <li><p>🧱 <code>Blocks</code>: a low-level API that allows you to have full control over the data flows and layout of your application. You can build very complex, multi-step applications using <code>Blocks</code> (as in “building blocks”).</p></li>",Ie,Z,ve,_,bt="As we saw in the previous sections, the <code>Interface</code> class allows you to easily create full-fledged machine learning demos with just a few lines of code. The <code>Interface</code> API is extremely easy to use but lacks the flexibility that the <code>Blocks</code> API provides. For example, you might want to:",ke,H,Tt="<li>Group together related demos as multiple tabs in one web application</li> <li>Change the layout of your demo, e.g. to specify where the inputs and outputs are located</li> <li>Have multi-step interfaces, in which the output of one model becomes the input to the next model, or have more flexible data flows in general</li> <li>Change a component’s properties (for example, the choices in a dropdown) or its visibility based on user input</li>",Be,S,gt="We will explore all of these concepts below.",Ge,Q,Re,A,Ct="After you have installed Gradio, run the code below as a Python script, a Jupyter notebook, or a Colab notebook.",$e,W,Ee,w,Jt,Ze,X,jt="This simple example above introduces 4 concepts that underlie Blocks:",_e,g,I,he,xt="Blocks allow you to build web applications that combine markdown, HTML, buttons, and interactive components simply by instantiating objects in Python inside of a <code>with gradio.Blocks</code> context.",dt,v,ht,mt,me,It="<p>You can define regular Python functions anywhere in your code and run them with user input using <code>Blocks</code>. In our example, we have a simple function that “flips” the input text, but you can write any Python function, from a simple calculation to processing the predictions from a machine learning model.</p>",yt,ye,vt='<p>You can assign events to any <code>Blocks</code> component. This will run your function when the component is clicked, changed, etc. When you assign an event, you pass in three parameters: <code>fn</code>: the function that should be called, <code>inputs</code>: the (list) of input component(s), and <code>outputs</code>: the (list) of output components that should be called.</p> <p>In the example above, we run the <code>flip_text()</code> function when the value in the <code>Textbox</code> named input <code>input</code> changes. The event reads the value in <code>input</code>, passes it as the name parameter to <code>flip_text()</code>, which then returns a value that gets assigned to our second <code>Textbox</code> named <code>output</code>.</p> <p>To see a list of events that each component supports, see the Gradio <a href="https://www.gradio.app/docs/" rel="nofollow">documentation</a>.</p>',Mt,Me,kt="<p>Blocks automatically figures out whether a component should be interactive (accept user input) or not, based on the event triggers you define. In our example, the first textbox is interactive, since its value is used by the <code>flip_text()</code> function. The second textbox is not interactive, since its value is never used as an input. In some cases, you might want to override this, which you can do by passing a boolean to the <code>interactive</code> parameter of the component (e.g. <code>gr.Textbox(placeholder=&quot;Flip this text&quot;, interactive=True)</code>).</p>",He,V,Se,z,Bt="How can we use <code>Blocks</code> to customize the layout of our demo? By default, <code>Blocks</code> renders the components that you create vertically in one column. You can change that by creating additional columns <code>with gradio.Column():</code> or rows <code>with gradio.Row():</code> and creating components within those contexts.",Qe,L,Gt='Here’s what you should keep in mind: any components created under a <code>Column</code> (this is also the default) will be laid out vertically. Any component created under a <code>Row</code> will be laid out horizontally, similar to the <a href="https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Flexible_Box_Layout/Basic_Concepts_of_Flexbox" rel="nofollow">flexbox model in web development</a>.',Ae,Y,Rt="Finally, you can also create tabs for your demo by using the <code>with gradio.Tabs()</code> context manager. Within this context, you can create multiple tabs by specifying <code>with gradio.TabItem(name_of_tab):</code> children. Any component created inside of a <code>with gradio.TabItem(name_of_tab):</code> context appears in that tab.",We,N,$t="Now let’s add a <code>flip_image()</code> function to our demo and add a new tab that flips images. Below is an example with 2 tabs and also uses a Row:",Xe,q,Ve,U,Et,ze,F,Zt="You’ll notice that in this example, we’ve also created a <code>Button</code> component in each tab, and we’ve assigned a click event to each button, which is what actually runs the function.",Le,P,Ye,K,_t="Just as you can control the layout, <code>Blocks</code> gives you fine-grained control over what events trigger function calls. Each component and many layouts have specific events that they support.",Ne,D,Ht="For example, the <code>Textbox</code> component has 2 events: <code>change()</code> (when the value inside of the textbox changes), and <code>submit()</code> (when a user presses the enter key while focused on the textbox). More complex components can have even more events: for example, the <code>Audio</code> component also has separate events for when the audio file is played, cleared, paused, etc. See the documentation for the events each component supports.",qe,O,St="You can attach event trigger to none, one, or more of these events. You create an event trigger by calling the name of the event on the component instance as a function — e.g. <code>textbox.change(...)</code> or <code>btn.click(...)</code>. The function takes in three parameters, as discussed above:",Fe,ee,Qt="<li><code>fn</code>: the function to run</li> <li><code>inputs</code>: a (list of) component(s) whose values should supplied as the input parameters to the function. Each component’s value gets mapped to the corresponding function parameter, in order. This parameter can be None if the function does not take any parameters.</li> <li><code>outputs</code>: a (list of) component(s) whose values should be updated based on the values returned by the function. Each return value sets the corresponding component’s value, in order. This parameter can be None if the function does not return anything.</li>",Pe,te,At="You can even make the input and output component be the same component, as we do in this example that uses a GPT model to do text completion:",Ke,le,De,f,Wt,Oe,se,et,ae,Xt="In some cases, you might want a <em>multi-step demo</em>, in which you reuse the output of one function as the input to the next. This is really easy to do with <code>Blocks</code>, as you can use a component for the input of one event trigger but the output of another. Take a look at the text component in the example below, its value is the result of a speech-to-text model, but also gets passed into a sentiment analysis model:",tt,oe,lt,b,Vt,st,ne,at,ie,zt="So far, we have seen how to create events to update the value of another component. But what happens if you want to change other properties of a component, like the visibility of a textbox or the choices in a radio button group? You can do this by returning a component class’s <code>update()</code> method instead of a regular return value from your function.",ot,pe,Lt="This is most easily illustrated with an example:",nt,re,it,T,Yt,pt,ce,Nt='We just explored all the core concepts of <code>Blocks</code>! Just like with <code>Interfaces</code>, you can create cool demos that can be shared by using <code>share=True</code> in the <code>launch()</code> method or deployed on <a href="https://huggingface.co/spaces" rel="nofollow">Hugging Face Spaces</a>.',rt,ue,ct,we,ut;return B=new de({props:{title:"Introduction to Gradio Blocks",local:"introduction-to-gradio-blocks",headingTag:"h1"}}),G=new ll({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section7.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section7.ipynb"}]}}),Z=new de({props:{title:"Why Blocks 🧱?",local:"why-blocks-",headingTag:"h3"}}),Q=new de({props:{title:"Creating a simple demo using Blocks",local:"creating-a-simple-demo-using-blocks",headingTag:"h3"}}),W=new be({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGZsaXBfdGV4dCh4KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHglNUIlM0ElM0EtMSU1RCUwQSUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQXdpdGglMjBkZW1vJTNBJTBBJTIwJTIwJTIwJTIwZ3IuTWFya2Rvd24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwRmxpcCUyMFRleHQhJTBBJTIwJTIwJTIwJTIwU3RhcnQlMjB0eXBpbmclMjBiZWxvdyUyMHRvJTIwc2VlJTIwdGhlJTIwb3V0cHV0LiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpbnB1dCUyMCUzRCUyMGdyLlRleHRib3gocGxhY2Vob2xkZXIlM0QlMjJGbGlwJTIwdGhpcyUyMHRleHQlMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuVGV4dGJveCgpJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXQuY2hhbmdlKGZuJTNEZmxpcF90ZXh0JTJDJTIwaW5wdXRzJTNEaW5wdXQlMkMlMjBvdXRwdXRzJTNEb3V0cHV0KSUwQSUwQWRlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">flip_text</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">return</span> x[::-<span class="hljs-number">1</span>]


demo = gr.Blocks()

<span class="hljs-keyword">with</span> demo:
    gr.Markdown(
        <span class="hljs-string">&quot;&quot;&quot;
    # Flip Text!
    Start typing below to see the output.
    &quot;&quot;&quot;</span>
    )
    <span class="hljs-built_in">input</span> = gr.Textbox(placeholder=<span class="hljs-string">&quot;Flip this text&quot;</span>)
    output = gr.Textbox()

    <span class="hljs-built_in">input</span>.change(fn=flip_text, inputs=<span class="hljs-built_in">input</span>, outputs=output)

demo.launch()`,wrap:!1}}),v=new tl({props:{$$slots:{default:[al]},$$scope:{ctx:Te}}}),V=new de({props:{title:"Customizing the layout of your demo",local:"customizing-the-layout-of-your-demo",headingTag:"h3"}}),q=new be({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQSUwQWRlZiUyMGZsaXBfdGV4dCh4KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHglNUIlM0ElM0EtMSU1RCUwQSUwQSUwQWRlZiUyMGZsaXBfaW1hZ2UoeCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBucC5mbGlwbHIoeCklMEElMEElMEF3aXRoJTIwZGVtbyUzQSUwQSUyMCUyMCUyMCUyMGdyLk1hcmtkb3duKCUyMkZsaXAlMjB0ZXh0JTIwb3IlMjBpbWFnZSUyMGZpbGVzJTIwdXNpbmclMjB0aGlzJTIwZGVtby4lMjIpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGdyLlRhYnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnci5UYWJJdGVtKCUyMkZsaXAlMjBUZXh0JTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnci5Sb3coKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHRfaW5wdXQlMjAlM0QlMjBnci5UZXh0Ym94KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0X291dHB1dCUyMCUzRCUyMGdyLlRleHRib3goKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHRfYnV0dG9uJTIwJTNEJTIwZ3IuQnV0dG9uKCUyMkZsaXAlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGdyLlRhYkl0ZW0oJTIyRmxpcCUyMEltYWdlJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnci5Sb3coKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlX2lucHV0JTIwJTNEJTIwZ3IuSW1hZ2UoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlX291dHB1dCUyMCUzRCUyMGdyLkltYWdlKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZV9idXR0b24lMjAlM0QlMjBnci5CdXR0b24oJTIyRmxpcCUyMiklMEElMEElMjAlMjAlMjAlMjB0ZXh0X2J1dHRvbi5jbGljayhmbGlwX3RleHQlMkMlMjBpbnB1dHMlM0R0ZXh0X2lucHV0JTJDJTIwb3V0cHV0cyUzRHRleHRfb3V0cHV0KSUwQSUyMCUyMCUyMCUyMGltYWdlX2J1dHRvbi5jbGljayhmbGlwX2ltYWdlJTJDJTIwaW5wdXRzJTNEaW1hZ2VfaW5wdXQlMkMlMjBvdXRwdXRzJTNEaW1hZ2Vfb3V0cHV0KSUwQSUwQWRlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">flip_text</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">return</span> x[::-<span class="hljs-number">1</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">flip_image</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">return</span> np.fliplr(x)


<span class="hljs-keyword">with</span> demo:
    gr.Markdown(<span class="hljs-string">&quot;Flip text or image files using this demo.&quot;</span>)
    <span class="hljs-keyword">with</span> gr.Tabs():
        <span class="hljs-keyword">with</span> gr.TabItem(<span class="hljs-string">&quot;Flip Text&quot;</span>):
            <span class="hljs-keyword">with</span> gr.Row():
                text_input = gr.Textbox()
                text_output = gr.Textbox()
            text_button = gr.Button(<span class="hljs-string">&quot;Flip&quot;</span>)
        <span class="hljs-keyword">with</span> gr.TabItem(<span class="hljs-string">&quot;Flip Image&quot;</span>):
            <span class="hljs-keyword">with</span> gr.Row():
                image_input = gr.Image()
                image_output = gr.Image()
            image_button = gr.Button(<span class="hljs-string">&quot;Flip&quot;</span>)

    text_button.click(flip_text, inputs=text_input, outputs=text_output)
    image_button.click(flip_image, inputs=image_input, outputs=image_output)

demo.launch()`,wrap:!1}}),P=new de({props:{title:"Exploring events and state",local:"exploring-events-and-state",headingTag:"h3"}}),le=new be({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWFwaSUyMCUzRCUyMGdyLkludGVyZmFjZS5sb2FkKCUyMmh1Z2dpbmdmYWNlJTJGRWxldXRoZXJBSSUyRmdwdC1qLTZCJTIyKSUwQSUwQSUwQWRlZiUyMGNvbXBsZXRlX3dpdGhfZ3B0KHRleHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlJTIwdGhlJTIwbGFzdCUyMDUwJTIwY2hhcmFjdGVycyUyMG9mJTIwdGhlJTIwdGV4dCUyMGFzJTIwY29udGV4dCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlNUIlM0EtNTAlNUQlMjAlMkIlMjBhcGkodGV4dCU1Qi01MCUzQSU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB0ZXh0Ym94JTIwJTNEJTIwZ3IuVGV4dGJveChwbGFjZWhvbGRlciUzRCUyMlR5cGUlMjBoZXJlJTIwYW5kJTIwcHJlc3MlMjBlbnRlci4uLiUyMiUyQyUyMGxpbmVzJTNENCklMEElMjAlMjAlMjAlMjBidG4lMjAlM0QlMjBnci5CdXR0b24oJTIyR2VuZXJhdGUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwYnRuLmNsaWNrKGNvbXBsZXRlX3dpdGhfZ3B0JTJDJTIwdGV4dGJveCUyQyUyMHRleHRib3gpJTBBJTBBZGVtby5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

api = gr.Interface.load(<span class="hljs-string">&quot;huggingface/EleutherAI/gpt-j-6B&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">complete_with_gpt</span>(<span class="hljs-params">text</span>):
    <span class="hljs-comment"># Use the last 50 characters of the text as context</span>
    <span class="hljs-keyword">return</span> text[:-<span class="hljs-number">50</span>] + api(text[-<span class="hljs-number">50</span>:])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    textbox = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type here and press enter...&quot;</span>, lines=<span class="hljs-number">4</span>)
    btn = gr.Button(<span class="hljs-string">&quot;Generate&quot;</span>)

    btn.click(complete_with_gpt, textbox, textbox)

demo.launch()`,wrap:!1}}),se=new de({props:{title:"Creating multi-step demos",local:"creating-multi-step-demos",headingTag:"h3"}}),oe=new be({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWFzciUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjAlMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMiklMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiklMEElMEElMEFkZWYlMjBzcGVlY2hfdG9fdGV4dChzcGVlY2gpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGFzcihzcGVlY2gpJTVCJTIydGV4dCUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEElMEFkZWYlMjB0ZXh0X3RvX3NlbnRpbWVudCh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNsYXNzaWZpZXIodGV4dCklNUIwJTVEJTVCJTIybGFiZWwlMjIlNUQlMEElMEElMEFkZW1vJTIwJTNEJTIwZ3IuQmxvY2tzKCklMEElMEF3aXRoJTIwZGVtbyUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvX2ZpbGUlMjAlM0QlMjBnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGdyLlRleHRib3goKSUwQSUyMCUyMCUyMCUyMGxhYmVsJTIwJTNEJTIwZ3IuTGFiZWwoKSUwQSUwQSUyMCUyMCUyMCUyMGIxJTIwJTNEJTIwZ3IuQnV0dG9uKCUyMlJlY29nbml6ZSUyMFNwZWVjaCUyMiklMEElMjAlMjAlMjAlMjBiMiUyMCUzRCUyMGdyLkJ1dHRvbiglMjJDbGFzc2lmeSUyMFNlbnRpbWVudCUyMiklMEElMEElMjAlMjAlMjAlMjBiMS5jbGljayhzcGVlY2hfdG9fdGV4dCUyQyUyMGlucHV0cyUzRGF1ZGlvX2ZpbGUlMkMlMjBvdXRwdXRzJTNEdGV4dCklMEElMjAlMjAlMjAlMjBiMi5jbGljayh0ZXh0X3RvX3NlbnRpbWVudCUyQyUyMGlucHV0cyUzRHRleHQlMkMlMjBvdXRwdXRzJTNEbGFiZWwpJTBBJTBBZGVtby5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

asr = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, <span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">speech_to_text</span>(<span class="hljs-params">speech</span>):
    text = asr(speech)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> text


<span class="hljs-keyword">def</span> <span class="hljs-title function_">text_to_sentiment</span>(<span class="hljs-params">text</span>):
    <span class="hljs-keyword">return</span> classifier(text)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]


demo = gr.Blocks()

<span class="hljs-keyword">with</span> demo:
    audio_file = gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>)
    text = gr.Textbox()
    label = gr.Label()

    b1 = gr.Button(<span class="hljs-string">&quot;Recognize Speech&quot;</span>)
    b2 = gr.Button(<span class="hljs-string">&quot;Classify Sentiment&quot;</span>)

    b1.click(speech_to_text, inputs=audio_file, outputs=text)
    b2.click(text_to_sentiment, inputs=text, outputs=label)

demo.launch()`,wrap:!1}}),ne=new de({props:{title:"Updating Component Properties",local:"updating-component-properties",headingTag:"h3"}}),re=new be({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGNoYW5nZV90ZXh0Ym94KGNob2ljZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMGNob2ljZSUyMCUzRCUzRCUyMCUyMnNob3J0JTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3IuVGV4dGJveC51cGRhdGUobGluZXMlM0QyJTJDJTIwdmlzaWJsZSUzRFRydWUpJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGNob2ljZSUyMCUzRCUzRCUyMCUyMmxvbmclMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBnci5UZXh0Ym94LnVwZGF0ZShsaW5lcyUzRDglMkMlMjB2aXNpYmxlJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3IuVGV4dGJveC51cGRhdGUodmlzaWJsZSUzREZhbHNlKSUwQSUwQSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwYmxvY2slM0ElMEElMjAlMjAlMjAlMjByYWRpbyUyMCUzRCUyMGdyLlJhZGlvKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMnNob3J0JTIyJTJDJTIwJTIybG9uZyUyMiUyQyUyMCUyMm5vbmUlMjIlNUQlMkMlMjBsYWJlbCUzRCUyMldoYXQlMjBraW5kJTIwb2YlMjBlc3NheSUyMHdvdWxkJTIweW91JTIwbGlrZSUyMHRvJTIwd3JpdGUlM0YlMjIlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGdyLlRleHRib3gobGluZXMlM0QyJTJDJTIwaW50ZXJhY3RpdmUlM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMHJhZGlvLmNoYW5nZShmbiUzRGNoYW5nZV90ZXh0Ym94JTJDJTIwaW5wdXRzJTNEcmFkaW8lMkMlMjBvdXRwdXRzJTNEdGV4dCklMEElMjAlMjAlMjAlMjBibG9jay5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">change_textbox</span>(<span class="hljs-params">choice</span>):
    <span class="hljs-keyword">if</span> choice == <span class="hljs-string">&quot;short&quot;</span>:
        <span class="hljs-keyword">return</span> gr.Textbox.update(lines=<span class="hljs-number">2</span>, visible=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">elif</span> choice == <span class="hljs-string">&quot;long&quot;</span>:
        <span class="hljs-keyword">return</span> gr.Textbox.update(lines=<span class="hljs-number">8</span>, visible=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> gr.Textbox.update(visible=<span class="hljs-literal">False</span>)


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> block:
    radio = gr.Radio(
        [<span class="hljs-string">&quot;short&quot;</span>, <span class="hljs-string">&quot;long&quot;</span>, <span class="hljs-string">&quot;none&quot;</span>], label=<span class="hljs-string">&quot;What kind of essay would you like to write?&quot;</span>
    )
    text = gr.Textbox(lines=<span class="hljs-number">2</span>, interactive=<span class="hljs-literal">True</span>)

    radio.change(fn=change_textbox, inputs=radio, outputs=text)
    block.launch()`,wrap:!1}}),ue=new sl({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter9/7.mdx"}}),{c(){M=i("meta"),j=a(),k=i("p"),ge=a(),c(B.$$.fragment),Ce=a(),c(G.$$.fragment),Je=a(),R=i("p"),R.innerHTML=wt,je=a(),$=i("p"),$.innerHTML=Ut,xe=a(),E=i("ul"),E.innerHTML=ft,Ie=a(),c(Z.$$.fragment),ve=a(),_=i("p"),_.innerHTML=bt,ke=a(),H=i("ul"),H.innerHTML=Tt,Be=a(),S=i("p"),S.textContent=gt,Ge=a(),c(Q.$$.fragment),Re=a(),A=i("p"),A.textContent=Ct,$e=a(),c(W.$$.fragment),Ee=a(),w=i("iframe"),Ze=a(),X=i("p"),X.textContent=jt,_e=a(),g=i("ol"),I=i("li"),he=i("p"),he.innerHTML=xt,dt=a(),c(v.$$.fragment),ht=qt(`
The order in which you instantiate components matters as each element gets rendered into the web app in the order it was created. (More complex layouts are discussed below)`),mt=a(),me=i("li"),me.innerHTML=It,yt=a(),ye=i("li"),ye.innerHTML=vt,Mt=a(),Me=i("li"),Me.innerHTML=kt,He=a(),c(V.$$.fragment),Se=a(),z=i("p"),z.innerHTML=Bt,Qe=a(),L=i("p"),L.innerHTML=Gt,Ae=a(),Y=i("p"),Y.innerHTML=Rt,We=a(),N=i("p"),N.innerHTML=$t,Xe=a(),c(q.$$.fragment),Ve=a(),U=i("iframe"),ze=a(),F=i("p"),F.innerHTML=Zt,Le=a(),c(P.$$.fragment),Ye=a(),K=i("p"),K.innerHTML=_t,Ne=a(),D=i("p"),D.innerHTML=Ht,qe=a(),O=i("p"),O.innerHTML=St,Fe=a(),ee=i("ul"),ee.innerHTML=Qt,Pe=a(),te=i("p"),te.textContent=At,Ke=a(),c(le.$$.fragment),De=a(),f=i("iframe"),Oe=a(),c(se.$$.fragment),et=a(),ae=i("p"),ae.innerHTML=Xt,tt=a(),c(oe.$$.fragment),lt=a(),b=i("iframe"),st=a(),c(ne.$$.fragment),at=a(),ie=i("p"),ie.innerHTML=zt,ot=a(),pe=i("p"),pe.textContent=Lt,nt=a(),c(re.$$.fragment),it=a(),T=i("iframe"),pt=a(),ce=i("p"),ce.innerHTML=Nt,rt=a(),c(ue.$$.fragment),ct=a(),we=i("p"),this.h()},l(e){const t=el("svelte-u9bgzb",document.head);M=p(t,"META",{name:!0,content:!0}),t.forEach(l),j=o(e),k=p(e,"P",{}),x(k).forEach(l),ge=o(e),u(B.$$.fragment,e),Ce=o(e),u(G.$$.fragment,e),Je=o(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-fnf7hg"&&(R.innerHTML=wt),je=o(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-y0a3jr"&&($.innerHTML=Ut),xe=o(e),E=p(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-gs87hb"&&(E.innerHTML=ft),Ie=o(e),u(Z.$$.fragment,e),ve=o(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1z0nnvi"&&(_.innerHTML=bt),ke=o(e),H=p(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-1aq803m"&&(H.innerHTML=Tt),Be=o(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-12sq5c4"&&(S.textContent=gt),Ge=o(e),u(Q.$$.fragment,e),Re=o(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-lya5ne"&&(A.textContent=Ct),$e=o(e),u(W.$$.fragment,e),Ee=o(e),w=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(w).forEach(l),Ze=o(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-wvzmkp"&&(X.textContent=jt),_e=o(e),g=p(e,"OL",{});var C=x(g);I=p(C,"LI",{});var Ue=x(I);he=p(Ue,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1andatl"&&(he.innerHTML=xt),dt=o(Ue),u(v.$$.fragment,Ue),ht=Ft(Ue,`
The order in which you instantiate components matters as each element gets rendered into the web app in the order it was created. (More complex layouts are discussed below)`),Ue.forEach(l),mt=o(C),me=p(C,"LI",{"data-svelte-h":!0}),r(me)!=="svelte-12zx6x9"&&(me.innerHTML=It),yt=o(C),ye=p(C,"LI",{"data-svelte-h":!0}),r(ye)!=="svelte-bkbklq"&&(ye.innerHTML=vt),Mt=o(C),Me=p(C,"LI",{"data-svelte-h":!0}),r(Me)!=="svelte-adpuz1"&&(Me.innerHTML=kt),C.forEach(l),He=o(e),u(V.$$.fragment,e),Se=o(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-xbwbxn"&&(z.innerHTML=Bt),Qe=o(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1b3722y"&&(L.innerHTML=Gt),Ae=o(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1vziw5t"&&(Y.innerHTML=Rt),We=o(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1blpsqu"&&(N.innerHTML=$t),Xe=o(e),u(q.$$.fragment,e),Ve=o(e),U=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(U).forEach(l),ze=o(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-dh4xss"&&(F.innerHTML=Zt),Le=o(e),u(P.$$.fragment,e),Ye=o(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-umhva7"&&(K.innerHTML=_t),Ne=o(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-7a3cem"&&(D.innerHTML=Ht),qe=o(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1yxg48f"&&(O.innerHTML=St),Fe=o(e),ee=p(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-1hhjtd0"&&(ee.innerHTML=Qt),Pe=o(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-y8si09"&&(te.textContent=At),Ke=o(e),u(le.$$.fragment,e),De=o(e),f=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(f).forEach(l),Oe=o(e),u(se.$$.fragment,e),et=o(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1176ewn"&&(ae.innerHTML=Xt),tt=o(e),u(oe.$$.fragment,e),lt=o(e),b=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(b).forEach(l),st=o(e),u(ne.$$.fragment,e),at=o(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-14gx35y"&&(ie.innerHTML=zt),ot=o(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1ot4ibu"&&(pe.textContent=Lt),nt=o(e),u(re.$$.fragment,e),it=o(e),T=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(T).forEach(l),pt=o(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-t9y78i"&&(ce.innerHTML=Nt),rt=o(e),u(ue.$$.fragment,e),ct=o(e),we=p(e,"P",{}),x(we).forEach(l),this.h()},h(){n(M,"name","hf:doc:metadata"),n(M,"content",nl),fe(w.src,Jt="https://course-demos-flip-text.hf.space")||n(w,"src",Jt),n(w,"frameborder","0"),n(w,"height","400"),n(w,"title","Gradio app"),n(w,"class","container p-0 flex-grow space-iframe"),n(w,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(w,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),fe(U.src,Et="https://course-demos-flip-text-image.hf.space")||n(U,"src",Et),n(U,"frameborder","0"),n(U,"height","450"),n(U,"title","Gradio app"),n(U,"class","container p-0 flex-grow space-iframe"),n(U,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(U,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),fe(f.src,Wt="https://course-demos-blocks-gpt.hf.space")||n(f,"src",Wt),n(f,"frameborder","0"),n(f,"height","300"),n(f,"title","Gradio app"),n(f,"class","container p-0 flex-grow space-iframe"),n(f,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(f,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),fe(b.src,Vt="https://course-demos-blocks-multi-step.hf.space")||n(b,"src",Vt),n(b,"frameborder","0"),n(b,"height","600"),n(b,"title","Gradio app"),n(b,"class","container p-0 flex-grow space-iframe"),n(b,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(b,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),fe(T.src,Yt="https://course-demos-blocks-update-component-properties.hf.space")||n(T,"src",Yt),n(T,"frameborder","0"),n(T,"height","300"),n(T,"title","Gradio app"),n(T,"class","container p-0 flex-grow space-iframe"),n(T,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(T,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){J(document.head,M),s(e,j,t),s(e,k,t),s(e,ge,t),d(B,e,t),s(e,Ce,t),d(G,e,t),s(e,Je,t),s(e,R,t),s(e,je,t),s(e,$,t),s(e,xe,t),s(e,E,t),s(e,Ie,t),d(Z,e,t),s(e,ve,t),s(e,_,t),s(e,ke,t),s(e,H,t),s(e,Be,t),s(e,S,t),s(e,Ge,t),d(Q,e,t),s(e,Re,t),s(e,A,t),s(e,$e,t),d(W,e,t),s(e,Ee,t),s(e,w,t),s(e,Ze,t),s(e,X,t),s(e,_e,t),s(e,g,t),J(g,I),J(I,he),J(I,dt),d(v,I,null),J(I,ht),J(g,mt),J(g,me),J(g,yt),J(g,ye),J(g,Mt),J(g,Me),s(e,He,t),d(V,e,t),s(e,Se,t),s(e,z,t),s(e,Qe,t),s(e,L,t),s(e,Ae,t),s(e,Y,t),s(e,We,t),s(e,N,t),s(e,Xe,t),d(q,e,t),s(e,Ve,t),s(e,U,t),s(e,ze,t),s(e,F,t),s(e,Le,t),d(P,e,t),s(e,Ye,t),s(e,K,t),s(e,Ne,t),s(e,D,t),s(e,qe,t),s(e,O,t),s(e,Fe,t),s(e,ee,t),s(e,Pe,t),s(e,te,t),s(e,Ke,t),d(le,e,t),s(e,De,t),s(e,f,t),s(e,Oe,t),d(se,e,t),s(e,et,t),s(e,ae,t),s(e,tt,t),d(oe,e,t),s(e,lt,t),s(e,b,t),s(e,st,t),d(ne,e,t),s(e,at,t),s(e,ie,t),s(e,ot,t),s(e,pe,t),s(e,nt,t),d(re,e,t),s(e,it,t),s(e,T,t),s(e,pt,t),s(e,ce,t),s(e,rt,t),d(ue,e,t),s(e,ct,t),s(e,we,t),ut=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),v.$set(C)},i(e){ut||(h(B.$$.fragment,e),h(G.$$.fragment,e),h(Z.$$.fragment,e),h(Q.$$.fragment,e),h(W.$$.fragment,e),h(v.$$.fragment,e),h(V.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ue.$$.fragment,e),ut=!0)},o(e){m(B.$$.fragment,e),m(G.$$.fragment,e),m(Z.$$.fragment,e),m(Q.$$.fragment,e),m(W.$$.fragment,e),m(v.$$.fragment,e),m(V.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(ne.$$.fragment,e),m(re.$$.fragment,e),m(ue.$$.fragment,e),ut=!1},d(e){e&&(l(j),l(k),l(ge),l(Ce),l(Je),l(R),l(je),l($),l(xe),l(E),l(Ie),l(ve),l(_),l(ke),l(H),l(Be),l(S),l(Ge),l(Re),l(A),l($e),l(Ee),l(w),l(Ze),l(X),l(_e),l(g),l(He),l(Se),l(z),l(Qe),l(L),l(Ae),l(Y),l(We),l(N),l(Xe),l(Ve),l(U),l(ze),l(F),l(Le),l(Ye),l(K),l(Ne),l(D),l(qe),l(O),l(Fe),l(ee),l(Pe),l(te),l(Ke),l(De),l(f),l(Oe),l(et),l(ae),l(tt),l(lt),l(b),l(st),l(at),l(ie),l(ot),l(pe),l(nt),l(it),l(T),l(pt),l(ce),l(rt),l(ct),l(we)),l(M),y(B,e),y(G,e),y(Z,e),y(Q,e),y(W,e),y(v),y(V,e),y(q,e),y(P,e),y(le,e),y(se,e),y(oe,e),y(ne,e),y(re,e),y(ue,e)}}}const nl='{"title":"Introduction to Gradio Blocks","local":"introduction-to-gradio-blocks","sections":[{"title":"Why Blocks 🧱?","local":"why-blocks-","sections":[],"depth":3},{"title":"Creating a simple demo using Blocks","local":"creating-a-simple-demo-using-blocks","sections":[],"depth":3},{"title":"Customizing the layout of your demo","local":"customizing-the-layout-of-your-demo","sections":[],"depth":3},{"title":"Exploring events and state","local":"exploring-events-and-state","sections":[],"depth":3},{"title":"Creating multi-step demos","local":"creating-multi-step-demos","sections":[],"depth":3},{"title":"Updating Component Properties","local":"updating-component-properties","sections":[],"depth":3}],"depth":1}';function il(Te){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends Dt{constructor(M){super(),Ot(this,M,il,ol,Pt,{})}}export{ml as component};
