import{s as sl,o as tl,n as al}from"../chunks/scheduler.389d799c.js";import{S as nl,i as il,g as i,s as a,r,A as ol,h as o,f as s,c as n,j as el,u as c,x as M,k as ll,y as Ml,a as t,v as h,d as m,t as y,w as u}from"../chunks/index.8f81d18f.js";import{T as pl}from"../chunks/Tip.ad26ce4a.js";import{C as S}from"../chunks/CodeBlock.c0898180.js";import{H as He,E as rl}from"../chunks/getInferenceSnippets.855f78b6.js";function cl(K){let p,w='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/evaluate-llm-lighteval/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){p=i("p"),p.innerHTML=w},l(d){p=o(d,"P",{"data-svelte-h":!0}),M(p)!=="svelte-l9qsnl"&&(p.innerHTML=w)},m(d,D){t(d,p,D)},p:al,d(d){d&&s(p)}}}function hl(K){let p,w,d,D,j,O,T,Ne='In this sagemaker example, we are going to learn how to evaluate LLMs using Hugging Face <a href="https://github.com/huggingface/lighteval/tree/main" rel="nofollow">lighteval</a>.  LightEval is a lightweight LLM evaluation suite that powers <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Hugging Face Open LLM Leaderboard</a>.',ee,U,Xe="Evaluating LLMs is crucial for understanding their capabilities and limitations, yet it poses significant challenges due to their complex and opaque nature. LightEval facilitates this evaluation process by enabling LLMs to be assessed on acamedic benchmarks like MMLU or IFEval, providing a structured approach to gauge their performance across diverse tasks.",le,b,ze="In Detail you will learn how to:",se,I,Re="<li>Setup Development Environment</li> <li>Prepare the evaluation configuraiton</li> <li>Evaluate Zephyr 7B on TruthfulQA on Amazon SageMaker</li>",te,g,ae,f,_e='If you are going to use Sagemaker in a local environment. You need access to an IAM Role with the required permissions for Sagemaker. You can find <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">here</a> more about it.',ne,Z,ie,B,oe,v,Ee='<a href="https://github.com/huggingface/lighteval/tree/main" rel="nofollow">LightEval</a> includes script to evaluate LLMs on common benchmarks like MMLU, Truthfulqa, IFEval, and more. It is used to evaluate models on the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Hugging Face Open LLM Leaderboard</a>. lighteval isy built on top of the great <a href="https://github.com/EleutherAI/lm-evaluation-harness" rel="nofollow">Eleuther AI Harness</a> with some additional features and improvements.',Me,C,xe='You can find all available benchmarks <a href="https://github.com/huggingface/lighteval/blob/main/examples/tasks/all_tasks.txt" rel="nofollow">here</a>.',pe,k,qe='We are going to use Amazon SageMaker Managed Training to evaluate the model. Therefore we will leverage the script available in <a href="https://github.com/huggingface/lighteval/blob/main/run_evals_accelerate.py" rel="nofollow">lighteval</a>. The Hugging Face DLC is not having lighteval installed. This means need to provide a <code>requirements.txt</code> file to install the required dependencies.',re,W,Qe="First lets load the <code>run_evals_accelerate.py</code> script and create a <code>requirements.txt</code> file with the required dependencies.",ce,G,he,H,Ye="In lighteval, the evaluation is done by running the <code>run_evals_accelerate.py</code> script. The script takes a <code>task</code> argument which is defined as <code>suite|task|num_few_shot|{0 or 1 to automatically reduce num_few_shot if prompt is too long}</code>. Alternatively, you can also provide a path to a txt file with the tasks you want to evaluate the model on, which we are going to do. This makes it easier for you to extend the evaluation to other benchmarks.",me,N,Ve='We are going to evaluate the model on the Truthfulqa benchmark with 0 few-shot examples. <a href="https://paperswithcode.com/dataset/truthfulqa" rel="nofollow">TruthfulQA</a> is a benchmark designed to measure whether a language model generates truthful answers to questions, encompassing 817 questions across 38 categories including health, law, finance, and politics​​.',ye,X,ue,z,Fe='To evaluate a model on all the benchmarks of the Open LLM Leaderboard you can copy this <a href="https://github.com/huggingface/lighteval/blob/v0.2.0/tasks_examples/open_llm_leaderboard_tasks.txt" rel="nofollow">file</a>',de,R,Je,_,Ae='In this example we are going to evaluate the <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow">HuggingFaceH4/zephyr-7b-beta</a> on the MMLU benchmark, which is part of the Open LLM Leaderboard.',we,E,$e="In addition to the <code>task</code> argument we need to define:",je,x,Le="<li><code>model_args</code>: Hugging Face Model ID or path, defined as <code>pretrained=HuggingFaceH4/zephyr-7b-beta</code></li> <li><code>model_dtype</code>: The model data type, defined as <code>bfloat16</code>, <code>float16</code> or <code>float32</code></li> <li><code>output_dir</code>: The directory where the evaluation results will be saved, e.g. <code>/opt/ml/model</code></li>",Te,q,Se='Lightevals can also evaluat peft models or use <code>chat_templates</code> you find more about it <a href="https://github.com/huggingface/lighteval/blob/v0.2.0/run_evals_accelerate.py" rel="nofollow">here</a>.',Ue,Q,be,Y,De="We can now start our evaluation job, with the <code>.fit()</code>.",Ie,V,ge,F,Pe="After the evaluation job is finished, we can download the evaluation results from the S3 bucket. Lighteval will save the results and generations in the <code>output_dir</code>. The results are savedas json and include detailed information about each task and the model’s performance. The results are available in the <code>results</code> key.",fe,A,Ze,$,Ke=`In our test we achieved a <code>mc1</code> score of 40.6% and an <code>mc2</code> score of 57.47%. The <code>mc2</code> is the score used in the Open LLM Leaderboard. Zephyr 7B achieved a <code>mc2</code> score of 57.47% on the TruthfulQA benchmark, which is identical to the score on the Open LLM Leaderboard.
The evaluation on Truthfulqa took <code>999 seconds</code>. The ml.g5.4xlarge instance we used costs <code>$2.03 per hour</code> for on-demand usage. As a result, the total cost for evaluating Zephyr 7B on Truthfulqa was <code>$0.56</code>.`,Be,ve,Ce,J,ke,L,We,P,Ge;return j=new He({props:{title:"Evaluate LLMs with Hugging Face Lighteval on Amazon SageMaker",local:"evaluate-llms-with-hugging-face-lighteval-on-amazon-sagemaker",headingTag:"h1"}}),g=new S({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzYWdlbWFrZXIlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"!pip install sagemaker --upgrade --quiet",wrap:!1}}),Z=new S({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyME5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCUyMmlhbSUyMiklMEElMjAlMjAlMjAlMjByb2xlJTIwJTNEJTIwaWFtLmdldF9yb2xlKFJvbGVOYW1lJTNEJTIyc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJTIyKSU1QiUyMlJvbGUlMjIlNUQlNUIlMjJBcm4lMjIlNUQlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oZGVmYXVsdF9idWNrZXQlM0RzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQpJTBBJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHJvbGUlMjBhcm4lM0ElMjAlN0Jyb2xlJTdEJTIyKSUwQXByaW50KGYlMjJzYWdlbWFrZXIlMjBidWNrZXQlM0ElMjAlN0JzZXNzLmRlZmF1bHRfYnVja2V0KCklN0QlMjIpJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHNlc3Npb24lMjByZWdpb24lM0ElMjAlN0JzZXNzLmJvdG9fcmVnaW9uX25hbWUlN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&quot;iam&quot;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&quot;sagemaker_execution_role&quot;</span>)[<span class="hljs-string">&quot;Role&quot;</span>][<span class="hljs-string">&quot;Arn&quot;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker bucket: <span class="hljs-subst">{sess.default_bucket()}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),B=new He({props:{title:"2. Prepare the evaluation configuraiton",local:"2-prepare-the-evaluation-configuraiton",headingTag:"h2"}}),G=new S({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjByZXF1ZXN0cyUyMGFzJTIwciUwQSUwQWxpZ2h0ZXZhbF92ZXJzaW9uJTIwJTNEJTIwJTIyMC4yLjAlMjIlMEElMEElMjMlMjBjcmVhdGUlMjBzY3JpcHRzJTIwZGlyZWN0b3J5JTIwaWYlMjBub3QlMjBleGlzdHMlMEFvcy5tYWtlZGlycyglMjJzY3JpcHRzJTIyJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMyUyMGxvYWQlMjBjdXN0b20lMjBzY3JpcHRzJTIwZnJvbSUyMGdpdCUwQXJhd19naXRodWJfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMGYlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRmxpZ2h0ZXZhbCUyRnYlN0JsaWdodGV2YWxfdmVyc2lvbiU3RCUyRnJ1bl9ldmFsc19hY2NlbGVyYXRlLnB5JTIyJTBBKSUwQXJlcyUyMCUzRCUyMHIuZ2V0KHJhd19naXRodWJfdXJsKSUwQXdpdGglMjBvcGVuKCUyMnNjcmlwdHMlMkZydW5fZXZhbHNfYWNjZWxlcmF0ZS5weSUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZShyZXMudGV4dCklMEElMEElMjMlMjB3cml0ZSUyMHJlcXVpcmVtZW50cy50eHQlMEF3aXRoJTIwb3BlbiglMjJzY3JpcHRzJTJGcmVxdWlyZW1lbnRzLnR4dCUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZShmJTIybGlnaHRldmFsJTNEJTNEJTdCbGlnaHRldmFsX3ZlcnNpb24lN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> requests <span class="hljs-keyword">as</span> r

lighteval_version = <span class="hljs-string">&quot;0.2.0&quot;</span>

<span class="hljs-comment"># create scripts directory if not exists</span>
os.makedirs(<span class="hljs-string">&quot;scripts&quot;</span>, exist_ok=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># load custom scripts from git</span>
raw_github_url = (
    <span class="hljs-string">f&quot;https://raw.githubusercontent.com/huggingface/lighteval/v<span class="hljs-subst">{lighteval_version}</span>/run_evals_accelerate.py&quot;</span>
)
res = r.get(raw_github_url)
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;scripts/run_evals_accelerate.py&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
    f.write(res.text)

<span class="hljs-comment"># write requirements.txt</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;scripts/requirements.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
    f.write(<span class="hljs-string">f&quot;lighteval==<span class="hljs-subst">{lighteval_version}</span>&quot;</span>)`,wrap:!1}}),X=new S({props:{code:"d2l0aCUyMG9wZW4oJTIyc2NyaXB0cyUyRnRhc2tzLnR4dCUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZShmJTIybGlnaHRldmFsJTdDdHJ1dGhmdWxxYSUzQW1jJTdDMCU3QzAlMjIp",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;scripts/tasks.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
    f.write(<span class="hljs-string">f&quot;lighteval|truthfulqa:mc|0|0&quot;</span>)`,wrap:!1}}),R=new He({props:{title:"3. Evaluate Zephyr 7B on TruthfulQA on Amazon SageMaker",local:"3-evaluate-zephyr-7b-on-truthfulqa-on-amazon-sagemaker",headingTag:"h2"}}),Q=new S({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment"># hyperparameters, which are passed into the training job</span>
hyperparameters = {
    <span class="hljs-string">&quot;model_args&quot;</span>: <span class="hljs-string">&quot;pretrained=HuggingFaceH4/zephyr-7b-beta&quot;</span>,  <span class="hljs-comment"># Hugging Face Model ID</span>
    <span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;tasks.txt&quot;</span>,  <span class="hljs-comment"># &#x27;lighteval|truthfulqa:mc|0|0&#x27;,</span>
    <span class="hljs-string">&quot;model_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>,  <span class="hljs-comment"># Torch dtype to load model weights</span>
    <span class="hljs-string">&quot;output_dir&quot;</span>: <span class="hljs-string">&quot;/opt/ml/model&quot;</span>,  <span class="hljs-comment"># Directory, which sagemaker uploads to s3 after training</span>
}

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
    entry_point=<span class="hljs-string">&quot;run_evals_accelerate.py&quot;</span>,  <span class="hljs-comment"># train script</span>
    source_dir=<span class="hljs-string">&quot;scripts&quot;</span>,  <span class="hljs-comment"># directory which includes all the files needed for training</span>
    instance_type=<span class="hljs-string">&quot;ml.g5.4xlarge&quot;</span>,  <span class="hljs-comment"># instances type used for the training job</span>
    instance_count=<span class="hljs-number">1</span>,  <span class="hljs-comment"># the number of instances used for training</span>
    base_job_name=<span class="hljs-string">&quot;lighteval&quot;</span>,  <span class="hljs-comment"># the name of the training job</span>
    role=role,  <span class="hljs-comment"># Iam role used in training job to access AWS ressources, e.g. S3</span>
    volume_size=<span class="hljs-number">300</span>,  <span class="hljs-comment"># the size of the EBS volume in GB</span>
    transformers_version=<span class="hljs-string">&quot;4.36&quot;</span>,  <span class="hljs-comment"># the transformers version used in the training job</span>
    pytorch_version=<span class="hljs-string">&quot;2.1&quot;</span>,  <span class="hljs-comment"># the pytorch_version version used in the training job</span>
    py_version=<span class="hljs-string">&quot;py310&quot;</span>,  <span class="hljs-comment"># the python version used in the training job</span>
    hyperparameters=hyperparameters,
    environment={
        <span class="hljs-string">&quot;HUGGINGFACE_HUB_CACHE&quot;</span>: <span class="hljs-string">&quot;/tmp/.cache&quot;</span>,
        <span class="hljs-comment"># &quot;HF_TOKEN&quot;: &quot;REPALCE_WITH_YOUR_TOKEN&quot; # needed for private models</span>
    },  <span class="hljs-comment"># set env variable to cache models in /tmp</span>
)`,wrap:!1}}),V=new S({props:{code:"JTIzJTIwc3RhcnRpbmclMjB0aGUlMjB0cmFpbiUyMGpvYiUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMGRhdGFzZXRzJTIwYXMlMjBpbnB1dCUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvci5maXQoKQ==",highlighted:`<span class="hljs-comment"># starting the train job with our uploaded datasets as input</span>
huggingface_estimator.fit()`,wrap:!1}}),A=new S({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> tarfile
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> io
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> sagemaker.s3 <span class="hljs-keyword">import</span> S3Downloader


<span class="hljs-comment"># download results from s3</span>
results_tar = S3Downloader.read_bytes(huggingface_estimator.model_data)
model_id = hyperparameters[<span class="hljs-string">&quot;model_args&quot;</span>].split(<span class="hljs-string">&quot;=&quot;</span>)[<span class="hljs-number">1</span>]
result = {}

<span class="hljs-comment"># Use tarfile to open the tar content directly from bytes</span>
<span class="hljs-keyword">with</span> tarfile.<span class="hljs-built_in">open</span>(fileobj=io.BytesIO(results_tar), mode=<span class="hljs-string">&quot;r:gz&quot;</span>) <span class="hljs-keyword">as</span> tar:
    <span class="hljs-comment"># Iterate over items in tar archive to find your json file by its path</span>
    <span class="hljs-keyword">for</span> member <span class="hljs-keyword">in</span> tar.getmembers():
        <span class="hljs-comment"># get path of results based on model id used to evaluate</span>
        <span class="hljs-keyword">if</span> os.path.join(<span class="hljs-string">&quot;details&quot;</span>, model_id) <span class="hljs-keyword">in</span> member.name <span class="hljs-keyword">and</span> member.name.endswith(<span class="hljs-string">&quot;.json&quot;</span>):
            <span class="hljs-comment"># Extract the file content</span>
            f = tar.extractfile(member)
            <span class="hljs-keyword">if</span> f <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                content = f.read()
                result = json.loads(content)
                <span class="hljs-keyword">break</span>

<span class="hljs-comment"># print results</span>
<span class="hljs-built_in">print</span>(result[<span class="hljs-string">&quot;results&quot;</span>])
<span class="hljs-comment"># {&#x27;lighteval|truthfulqa:mc|0&#x27;: {&#x27;truthfulqa_mc1&#x27;: 0.40636474908200737, &#x27;truthfulqa_mc1_stderr&#x27;: 0.017193835812093897, &#x27;truthfulqa_mc2&#x27;: 0.5747003398184238, &#x27;truthfulqa_mc2_stderr&#x27;: 0.015742356478301463}}</span>`,wrap:!1}}),J=new pl({props:{$$slots:{default:[cl]},$$scope:{ctx:K}}}),L=new rl({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-evaluate-llm-lighteval.mdx"}}),{c(){p=i("meta"),w=a(),d=i("p"),D=a(),r(j.$$.fragment),O=a(),T=i("p"),T.innerHTML=Ne,ee=a(),U=i("p"),U.textContent=Xe,le=a(),b=i("p"),b.textContent=ze,se=a(),I=i("ol"),I.innerHTML=Re,te=a(),r(g.$$.fragment),ae=a(),f=i("p"),f.innerHTML=_e,ne=a(),r(Z.$$.fragment),ie=a(),r(B.$$.fragment),oe=a(),v=i("p"),v.innerHTML=Ee,Me=a(),C=i("p"),C.innerHTML=xe,pe=a(),k=i("p"),k.innerHTML=qe,re=a(),W=i("p"),W.innerHTML=Qe,ce=a(),r(G.$$.fragment),he=a(),H=i("p"),H.innerHTML=Ye,me=a(),N=i("p"),N.innerHTML=Ve,ye=a(),r(X.$$.fragment),ue=a(),z=i("p"),z.innerHTML=Fe,de=a(),r(R.$$.fragment),Je=a(),_=i("p"),_.innerHTML=Ae,we=a(),E=i("p"),E.innerHTML=$e,je=a(),x=i("ul"),x.innerHTML=Le,Te=a(),q=i("p"),q.innerHTML=Se,Ue=a(),r(Q.$$.fragment),be=a(),Y=i("p"),Y.innerHTML=De,Ie=a(),r(V.$$.fragment),ge=a(),F=i("p"),F.innerHTML=Pe,fe=a(),r(A.$$.fragment),Ze=a(),$=i("p"),$.innerHTML=Ke,Be=a(),ve=i("hr"),Ce=a(),r(J.$$.fragment),ke=a(),r(L.$$.fragment),We=a(),P=i("p"),this.h()},l(e){const l=ol("svelte-u9bgzb",document.head);p=o(l,"META",{name:!0,content:!0}),l.forEach(s),w=n(e),d=o(e,"P",{}),el(d).forEach(s),D=n(e),c(j.$$.fragment,e),O=n(e),T=o(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1dytuw0"&&(T.innerHTML=Ne),ee=n(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1tkejc9"&&(U.textContent=Xe),le=n(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1xbim1c"&&(b.textContent=ze),se=n(e),I=o(e,"OL",{"data-svelte-h":!0}),M(I)!=="svelte-iu956w"&&(I.innerHTML=Re),te=n(e),c(g.$$.fragment,e),ae=n(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-s0u97w"&&(f.innerHTML=_e),ne=n(e),c(Z.$$.fragment,e),ie=n(e),c(B.$$.fragment,e),oe=n(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-14s330d"&&(v.innerHTML=Ee),Me=n(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1yoz672"&&(C.innerHTML=xe),pe=n(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-k8g2se"&&(k.innerHTML=qe),re=n(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-i6nszn"&&(W.innerHTML=Qe),ce=n(e),c(G.$$.fragment,e),he=n(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1709a7"&&(H.innerHTML=Ye),me=n(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-8hjwst"&&(N.innerHTML=Ve),ye=n(e),c(X.$$.fragment,e),ue=n(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1kdp07x"&&(z.innerHTML=Fe),de=n(e),c(R.$$.fragment,e),Je=n(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1nagj1d"&&(_.innerHTML=Ae),we=n(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1ftyhj8"&&(E.innerHTML=$e),je=n(e),x=o(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-njlmgk"&&(x.innerHTML=Le),Te=n(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1h2b2yh"&&(q.innerHTML=Se),Ue=n(e),c(Q.$$.fragment,e),be=n(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1alpixz"&&(Y.innerHTML=De),Ie=n(e),c(V.$$.fragment,e),ge=n(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1yn6w5d"&&(F.innerHTML=Pe),fe=n(e),c(A.$$.fragment,e),Ze=n(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1d75i5s"&&($.innerHTML=Ke),Be=n(e),ve=o(e,"HR",{}),Ce=n(e),c(J.$$.fragment,e),ke=n(e),c(L.$$.fragment,e),We=n(e),P=o(e,"P",{}),el(P).forEach(s),this.h()},h(){ll(p,"name","hf:doc:metadata"),ll(p,"content",ml)},m(e,l){Ml(document.head,p),t(e,w,l),t(e,d,l),t(e,D,l),h(j,e,l),t(e,O,l),t(e,T,l),t(e,ee,l),t(e,U,l),t(e,le,l),t(e,b,l),t(e,se,l),t(e,I,l),t(e,te,l),h(g,e,l),t(e,ae,l),t(e,f,l),t(e,ne,l),h(Z,e,l),t(e,ie,l),h(B,e,l),t(e,oe,l),t(e,v,l),t(e,Me,l),t(e,C,l),t(e,pe,l),t(e,k,l),t(e,re,l),t(e,W,l),t(e,ce,l),h(G,e,l),t(e,he,l),t(e,H,l),t(e,me,l),t(e,N,l),t(e,ye,l),h(X,e,l),t(e,ue,l),t(e,z,l),t(e,de,l),h(R,e,l),t(e,Je,l),t(e,_,l),t(e,we,l),t(e,E,l),t(e,je,l),t(e,x,l),t(e,Te,l),t(e,q,l),t(e,Ue,l),h(Q,e,l),t(e,be,l),t(e,Y,l),t(e,Ie,l),h(V,e,l),t(e,ge,l),t(e,F,l),t(e,fe,l),h(A,e,l),t(e,Ze,l),t(e,$,l),t(e,Be,l),t(e,ve,l),t(e,Ce,l),h(J,e,l),t(e,ke,l),h(L,e,l),t(e,We,l),t(e,P,l),Ge=!0},p(e,[l]){const Oe={};l&2&&(Oe.$$scope={dirty:l,ctx:e}),J.$set(Oe)},i(e){Ge||(m(j.$$.fragment,e),m(g.$$.fragment,e),m(Z.$$.fragment,e),m(B.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(R.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(A.$$.fragment,e),m(J.$$.fragment,e),m(L.$$.fragment,e),Ge=!0)},o(e){y(j.$$.fragment,e),y(g.$$.fragment,e),y(Z.$$.fragment,e),y(B.$$.fragment,e),y(G.$$.fragment,e),y(X.$$.fragment,e),y(R.$$.fragment,e),y(Q.$$.fragment,e),y(V.$$.fragment,e),y(A.$$.fragment,e),y(J.$$.fragment,e),y(L.$$.fragment,e),Ge=!1},d(e){e&&(s(w),s(d),s(D),s(O),s(T),s(ee),s(U),s(le),s(b),s(se),s(I),s(te),s(ae),s(f),s(ne),s(ie),s(oe),s(v),s(Me),s(C),s(pe),s(k),s(re),s(W),s(ce),s(he),s(H),s(me),s(N),s(ye),s(ue),s(z),s(de),s(Je),s(_),s(we),s(E),s(je),s(x),s(Te),s(q),s(Ue),s(be),s(Y),s(Ie),s(ge),s(F),s(fe),s(Ze),s($),s(Be),s(ve),s(Ce),s(ke),s(We),s(P)),s(p),u(j,e),u(g,e),u(Z,e),u(B,e),u(G,e),u(X,e),u(R,e),u(Q,e),u(V,e),u(A,e),u(J,e),u(L,e)}}}const ml='{"title":"Evaluate LLMs with Hugging Face Lighteval on Amazon SageMaker","local":"evaluate-llms-with-hugging-face-lighteval-on-amazon-sagemaker","sections":[{"title":"2. Prepare the evaluation configuraiton","local":"2-prepare-the-evaluation-configuraiton","sections":[],"depth":2},{"title":"3. Evaluate Zephyr 7B on TruthfulQA on Amazon SageMaker","local":"3-evaluate-zephyr-7b-on-truthfulqa-on-amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function yl(K){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends nl{constructor(p){super(),il(this,p,yl,hl,sl,{})}}export{Tl as component};
