import{s as de,n as ce,o as ye}from"../chunks/scheduler.d6170356.js";import{S as ge,i as we,g as i,s as l,r as p,A as Me,h as o,f as a,c as n,j as ue,u as r,x as f,k as me,y as be,a as s,v as h,d as u,t as m,w as d}from"../chunks/index.fcd4cc08.js";import{C as K}from"../chunks/CodeBlock.7b16bdef.js";import{H as tt,E as Te}from"../chunks/EditOnGithub.da2b595c.js";function Ue(Yt){let c,st,et,lt,y,nt,g,Pt=`FiftyOne is the leading open-source toolkit for curating, visualizing, and
managing unstructured visual data. The library streamlines data-centric
workflows, from finding low-confidence predictions to identifying poor-quality
samples and uncovering hidden patterns in your data. The library supports all
sorts of visual data, from images and videos to PDFs, point clouds, and meshes.`,it,w,St=`Whereas tabular data formats like a pandas DataFrame or a Parquet file consist
of rows and columns, FiftyOne datasets are considerably more flexible,
accomodating object detections, keypoints, polylines, etc. and custom schemas.`,ot,M,Rt=`FiftyOne is integrated with the Hugging Face Hub, so you can load and share
FiftyOne datasets directly from the Hub.`,ft,b,Vt='🚀 Try the FiftyOne 🤝 Hugging Face Integration in <a href="https://colab.research.google.com/drive/1l0kzfbJ2wtUw1EGS1tq1PJYoWenMlihp?usp=sharing" rel="nofollow">Colab</a>!',pt,T,rt,U,At='First <a href="../huggingface_hub/quick-start#login">login with your Hugging Face account</a>:',ht,J,ut,$,Ot="Make sure you have <code>fiftyone&gt;=0.24.0</code> installed:",mt,v,dt,j,ct,C,Nt="With <code>load_from_hub()</code> from FiftyOne’s Hugging Face utils, you can load:",yt,I,Dt="<li>Any FiftyOne dataset uploaded to the hub</li> <li>Most image-based datasets stored in Parquet files (which is the standard for datasets uploaded to the hub via the <code>datasets</code> library)</li>",gt,_,wt,k,Et=`Any dataset pushed to the hub in one of FiftyOne’s <a href="https://docs.voxel51.com/user_guide/dataset_creation/datasets.html#supported-import-formats" rel="nofollow">supported common formats</a>
should have all of the necessary configuration info in its dataset repo on the
hub, so you can load the dataset by specifying its <code>repo_id</code>. As an example, to
load the <a href="https://huggingface.co/datasets/Voxel51/VisDrone2019-DET" rel="nofollow">VisDrone detection dataset</a>,
all you need is:`,Mt,x,bt,F,Kt='<img src="https://cdn-uploads.huggingface.co/production/uploads/63127e2495407887cb79c5ea/0eKxe_GSsBjt8wMjT9qaI.jpeg" alt="FiftyOne VisDrone dataset"/>',Tt,Z,te=`You can <a href="https://docs.voxel51.com/integrations/huggingface.html#configuring-the-download-process" rel="nofollow">customize the download process</a>, including the number of samples to
download, the name of the created dataset object, whether or not it is persisted
to disk, and more!`,Ut,H,ee="You can list all the available FiftyOne datasets on the Hub using:",Jt,B,$t,q,vt,G,ae=`You can also use the <code>load_from_hub()</code> function to load datasets from Parquet
files. Type conversions are handled for you and images are downloaded from URLs
if necessary.`,jt,W,se='With this functionality, <a href="https://docs.voxel51.com/integrations/huggingface.html#basic-examples" rel="nofollow">you can load</a> any of the following:',Ct,Q,le='<li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-image-classification-datasets-665dfd51020d8b66a56c9b6f" rel="nofollow">FiftyOne-Compatible Image Classification Datasets</a>, like <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food101</a> and <a href="https://huggingface.co/datasets/imagenet_sketch" rel="nofollow">ImageNet-Sketch</a></li> <li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-object-detection-datasets-665e0279c94ae552c7159a2b" rel="nofollow">FiftyOne-Compatible Object Detection Datasets</a> like <a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5</a> and <a href="https://huggingface.co/datasets/wider_face" rel="nofollow">WIDER FACE</a></li> <li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-image-segmentation-datasets-665e15b6ddb96a4d7226a380" rel="nofollow">FiftyOne-Compatible Segmentation Datasets</a> like <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">SceneParse150</a> and <a href="https://huggingface.co/datasets/segments/sidewalk-semantic" rel="nofollow">Sidewalk Semantic</a></li> <li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-image-captioning-datasets-665e16e29350244c06084505" rel="nofollow">FiftyOne-Compatible Image Captioning Datasets</a> like <a href="https://huggingface.co/datasets/kakaobrain/coyo-700m" rel="nofollow">COYO-700M</a> and <a href="https://huggingface.co/datasets/jmhessel/newyorker_caption_contest" rel="nofollow">New Yorker Caption Contest</a></li> <li><a href="https://huggingface.co/collections/Voxel51/fiftyone-compatible-vqa-datasets-665e16424ecc8a718156248a" rel="nofollow">FiftyOne-Compatible Visual Question-Answering Datasets</a> like <a href="https://huggingface.co/datasets/textvqa" rel="nofollow">TextVQA</a> and <a href="https://huggingface.co/datasets/derek-thomas/ScienceQA" rel="nofollow">ScienceQA</a></li>',It,X,ne="And many more!",_t,z,ie=`As a simple example, we can load the first 1,000 samples from the
<a href="https://huggingface.co/datasets/huggan/wikiart" rel="nofollow">WikiArt dataset</a> into FiftyOne with:`,kt,L,xt,Y,oe='<img src="https://cdn-uploads.huggingface.co/production/uploads/63127e2495407887cb79c5ea/PCqCvTlNTG5SLtcK5fwuQ.jpeg" alt="WikiArt Dataset"/>',Ft,P,Zt,S,fe="Pushing a dataset to the hub is as simple as:",Ht,R,Bt,V,pe=`When you call <code>push_to_hub()</code>, the dataset will be uploaded to the repo
with the specified repo name under your username, and the repo will be created
if necessary. A <a href="./datasets-cards">Dataset Card</a> will automatically be generated and populated with instructions for loading the dataset from the hub. You can even upload a thumbnail image/gif to appear on the Dataset Card with the <code>preview_path</code> argument.`,qt,A,re='Here’s an example using many of these arguments, which would upload the first three samples of FiftyOne’s <a href="https://docs.voxel51.com/user_guide/dataset_zoo/datasets.html#quickstart-video" rel="nofollow">Quickstart Video</a> dataset to the private repo <code>username/my-quickstart-video-dataset</code> with tags, an MIT license, a description, and a preview image:',Gt,O,Wt,N,Qt,D,he='<li><a href="https://colab.research.google.com/drive/1l0kzfbJ2wtUw1EGS1tq1PJYoWenMlihp?usp=sharing" rel="nofollow">🚀 Code-Along Colab Notebook</a></li> <li><a href="https://docs.voxel51.com/user_guide/using_datasets.html#" rel="nofollow">🗺️ User Guide for FiftyOne Datasets</a></li> <li><a href="https://docs.voxel51.com/integrations/huggingface.html#huggingface-hub" rel="nofollow">🤗 FiftyOne 🤝 Hub Integration Docs</a></li> <li><a href="https://docs.voxel51.com/integrations/huggingface.html#transformers-library" rel="nofollow">🤗 FiftyOne 🤝 Transformers Integration Docs</a></li> <li><a href="https://github.com/voxel51/fiftyone-huggingface-plugins" rel="nofollow">🧩 FiftyOne Hugging Face Hub Plugin</a></li>',Xt,E,zt,at,Lt;return y=new tt({props:{title:"FiftyOne",local:"fiftyone",headingTag:"h1"}}),T=new tt({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),J=new K({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),v=new K({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmlmdHlvbmU=",highlighted:"pip install -U fiftyone",wrap:!1}}),j=new tt({props:{title:"Loading Visual Datasets from the Hub",local:"loading-visual-datasets-from-the-hub",headingTag:"h2"}}),_=new tt({props:{title:"Loading FiftyOne datasets from the Hub",local:"loading-fiftyone-datasets-from-the-hub",headingTag:"h3"}}),x=new K({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTBBZnJvbSUyMGZpZnR5b25lLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2h1YiUwQSUwQSUyMyUyMyUyMGxvYWQlMjBmcm9tJTIwdGhlJTIwaHViJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZnJvbV9odWIoJTIyVm94ZWw1MSUyRlZpc0Ryb25lMjAxOS1ERVQlMjIpJTBBJTBBJTIzJTIzJTIwdmlzdWFsaXplJTIwaW4lMjBhcHAlMEFzZXNzaW9uJTIwJTNEJTIwZm8ubGF1bmNoX2FwcChkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo
<span class="hljs-keyword">from</span> fiftyone.utils <span class="hljs-keyword">import</span> load_from_hub

<span class="hljs-comment">## load from the hub</span>
dataset = load_from_hub(<span class="hljs-string">&quot;Voxel51/VisDrone2019-DET&quot;</span>)

<span class="hljs-comment">## visualize in app</span>
session = fo.launch_app(dataset)`,wrap:!1}}),B=new K({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X2RhdGFzZXRzKHRhZ3MlM0QlMjJmaWZ0eW9uZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi()
api.list_datasets(tags=<span class="hljs-string">&quot;fiftyone&quot;</span>)`,wrap:!1}}),q=new tt({props:{title:"Loading Parquet Datasets from the Hub with FiftyOne",local:"loading-parquet-datasets-from-the-hub-with-fiftyone",headingTag:"h3"}}),L=new K({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTBBZnJvbSUyMGZpZnR5b25lLnV0aWxzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2h1YiUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2Zyb21faHViKCUwQSUyMCUyMCUyMCUyMCUyMmh1Z2dhbiUyRndpa2lhcnQlMjIlMkMlMjAlMjAlMjMlMjMlMjByZXBvX2lkJTBBJTIwJTIwJTIwJTIwZm9ybWF0JTNEJTIycGFycXVldCUyMiUyQyUyMCUyMCUyMyUyMyUyMGZvciUyMFBhcnF1ZXQlMjBmb3JtYXQlMEElMjAlMjAlMjAlMjBjbGFzc2lmaWNhdGlvbl9maWVsZHMlM0QlNUIlMjJhcnRpc3QlMjIlMkMlMjAlMjJzdHlsZSUyMiUyQyUyMCUyMmdlbnJlJTIyJTVEJTJDJTIwJTIzJTIzJTIwY29sdW1ucyUyMHRvJTIwdHJlYXQlMjBhcyUyMGNsYXNzaWZpY2F0aW9uJTIwbGFiZWxzJTBBJTIwJTIwJTIwJTIwbWF4X3NhbXBsZXMlM0QxMDAwJTJDJTIwJTIwJTIzJTIwbnVtYmVyJTIwb2YlMjBzYW1wbGVzJTIwdG8lMjBsb2FkJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndpa2lhcnQlMjIlMkMlMjAlMjAlMjMlMjBuYW1lJTIwb2YlMjB0aGUlMjBkYXRhc2V0JTIwaW4lMjBGaWZ0eU9uZSUwQSk=",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo
<span class="hljs-keyword">from</span> fiftyone.utils.huggingface <span class="hljs-keyword">import</span> load_from_hub

dataset = load_from_hub(
    <span class="hljs-string">&quot;huggan/wikiart&quot;</span>,  <span class="hljs-comment">## repo_id</span>
    <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;parquet&quot;</span>,  <span class="hljs-comment">## for Parquet format</span>
    classification_fields=[<span class="hljs-string">&quot;artist&quot;</span>, <span class="hljs-string">&quot;style&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>], <span class="hljs-comment">## columns to treat as classification labels</span>
    max_samples=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># number of samples to load</span>
    name=<span class="hljs-string">&quot;wikiart&quot;</span>,  <span class="hljs-comment"># name of the dataset in FiftyOne</span>
)`,wrap:!1}}),P=new tt({props:{title:"Pushing FiftyOne Datasets to the Hub",local:"pushing-fiftyone-datasets-to-the-hub",headingTag:"h2"}}),R=new K({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTBBaW1wb3J0JTIwZmlmdHlvbmUuem9vJTIwYXMlMjBmb3olMEFmcm9tJTIwZmlmdHlvbmUudXRpbHMuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBwdXNoX3RvX2h1YiUwQSUwQSUyMyUyMyUyMGxvYWQlMjBleGFtcGxlJTIwZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBmb3oubG9hZF96b29fZGF0YXNldCglMjJxdWlja3N0YXJ0JTIyKSUwQSUwQSUyMyUyMyUyMHB1c2glMjB0byUyMGh1YiUwQXB1c2hfdG9faHViKGRhdGFzZXQlMkMlMjAlMjJteS1oZi1kYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo
<span class="hljs-keyword">import</span> fiftyone.zoo <span class="hljs-keyword">as</span> foz
<span class="hljs-keyword">from</span> fiftyone.utils.huggingface <span class="hljs-keyword">import</span> push_to_hub

<span class="hljs-comment">## load example dataset</span>
dataset = foz.load_zoo_dataset(<span class="hljs-string">&quot;quickstart&quot;</span>)

<span class="hljs-comment">## push to hub</span>
push_to_hub(dataset, <span class="hljs-string">&quot;my-hf-dataset&quot;</span>)`,wrap:!1}}),O=new K({props:{code:"ZGF0YXNldCUyMCUzRCUyMGZvei5sb2FkX2Zyb21fem9vKCUyMnF1aWNrc3RhcnQtdmlkZW8lMjIlMkMlMjBtYXhfc2FtcGxlcyUzRDMpJTBBJTBBcHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMCUyMm15LXF1aWNrc3RhcnQtdmlkZW8tZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhZ3MlM0QlNUIlMjJ2aWRlbyUyMiUyQyUyMCUyMnRyYWNraW5nJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGljZW5zZSUzRCUyMm1pdCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyQSUyMGRhdGFzZXQlMjBvZiUyMHZpZGVvJTIwc2FtcGxlcyUyMGZvciUyMHRyYWNraW5nJTIwdGFza3MlMjIlMkMlMEElMjAlMjAlMjAlMjBwcml2YXRlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByZXZpZXdfcGF0aCUzRCUyMiUzQ3BhdGglMkZ0byUyRnByZXZpZXcucG5nJTNFJTIyJTBBKQ==",highlighted:`dataset = foz.load_from_zoo(<span class="hljs-string">&quot;quickstart-video&quot;</span>, max_samples=<span class="hljs-number">3</span>)

push_to_hub(
    dataset,
    <span class="hljs-string">&quot;my-quickstart-video-dataset&quot;</span>,
    tags=[<span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;tracking&quot;</span>],
    license=<span class="hljs-string">&quot;mit&quot;</span>,
    description=<span class="hljs-string">&quot;A dataset of video samples for tracking tasks&quot;</span>,
    private=<span class="hljs-literal">True</span>,
    preview_path=<span class="hljs-string">&quot;&lt;path/to/preview.png&gt;&quot;</span>
)`,wrap:!1}}),N=new tt({props:{title:"📚 Resources",local:"-resources",headingTag:"h2"}}),E=new Te({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-fiftyone.md"}}),{c(){c=i("meta"),st=l(),et=i("p"),lt=l(),p(y.$$.fragment),nt=l(),g=i("p"),g.textContent=Pt,it=l(),w=i("p"),w.textContent=St,ot=l(),M=i("p"),M.textContent=Rt,ft=l(),b=i("p"),b.innerHTML=Vt,pt=l(),p(T.$$.fragment),rt=l(),U=i("p"),U.innerHTML=At,ht=l(),p(J.$$.fragment),ut=l(),$=i("p"),$.innerHTML=Ot,mt=l(),p(v.$$.fragment),dt=l(),p(j.$$.fragment),ct=l(),C=i("p"),C.innerHTML=Nt,yt=l(),I=i("ul"),I.innerHTML=Dt,gt=l(),p(_.$$.fragment),wt=l(),k=i("p"),k.innerHTML=Et,Mt=l(),p(x.$$.fragment),bt=l(),F=i("p"),F.innerHTML=Kt,Tt=l(),Z=i("p"),Z.innerHTML=te,Ut=l(),H=i("p"),H.textContent=ee,Jt=l(),p(B.$$.fragment),$t=l(),p(q.$$.fragment),vt=l(),G=i("p"),G.innerHTML=ae,jt=l(),W=i("p"),W.innerHTML=se,Ct=l(),Q=i("ul"),Q.innerHTML=le,It=l(),X=i("p"),X.textContent=ne,_t=l(),z=i("p"),z.innerHTML=ie,kt=l(),p(L.$$.fragment),xt=l(),Y=i("p"),Y.innerHTML=oe,Ft=l(),p(P.$$.fragment),Zt=l(),S=i("p"),S.textContent=fe,Ht=l(),p(R.$$.fragment),Bt=l(),V=i("p"),V.innerHTML=pe,qt=l(),A=i("p"),A.innerHTML=re,Gt=l(),p(O.$$.fragment),Wt=l(),p(N.$$.fragment),Qt=l(),D=i("ul"),D.innerHTML=he,Xt=l(),p(E.$$.fragment),zt=l(),at=i("p"),this.h()},l(t){const e=Me("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(a),st=n(t),et=o(t,"P",{}),ue(et).forEach(a),lt=n(t),r(y.$$.fragment,t),nt=n(t),g=o(t,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1lvrxl"&&(g.textContent=Pt),it=n(t),w=o(t,"P",{"data-svelte-h":!0}),f(w)!=="svelte-fcujh6"&&(w.textContent=St),ot=n(t),M=o(t,"P",{"data-svelte-h":!0}),f(M)!=="svelte-xljn1h"&&(M.textContent=Rt),ft=n(t),b=o(t,"P",{"data-svelte-h":!0}),f(b)!=="svelte-18tv8ix"&&(b.innerHTML=Vt),pt=n(t),r(T.$$.fragment,t),rt=n(t),U=o(t,"P",{"data-svelte-h":!0}),f(U)!=="svelte-1s77x2o"&&(U.innerHTML=At),ht=n(t),r(J.$$.fragment,t),ut=n(t),$=o(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-qry4me"&&($.innerHTML=Ot),mt=n(t),r(v.$$.fragment,t),dt=n(t),r(j.$$.fragment,t),ct=n(t),C=o(t,"P",{"data-svelte-h":!0}),f(C)!=="svelte-11kuu8j"&&(C.innerHTML=Nt),yt=n(t),I=o(t,"UL",{"data-svelte-h":!0}),f(I)!=="svelte-1sagvnm"&&(I.innerHTML=Dt),gt=n(t),r(_.$$.fragment,t),wt=n(t),k=o(t,"P",{"data-svelte-h":!0}),f(k)!=="svelte-r6pmyk"&&(k.innerHTML=Et),Mt=n(t),r(x.$$.fragment,t),bt=n(t),F=o(t,"P",{"data-svelte-h":!0}),f(F)!=="svelte-1gciz6k"&&(F.innerHTML=Kt),Tt=n(t),Z=o(t,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-q16xii"&&(Z.innerHTML=te),Ut=n(t),H=o(t,"P",{"data-svelte-h":!0}),f(H)!=="svelte-161ahsi"&&(H.textContent=ee),Jt=n(t),r(B.$$.fragment,t),$t=n(t),r(q.$$.fragment,t),vt=n(t),G=o(t,"P",{"data-svelte-h":!0}),f(G)!=="svelte-1550pgp"&&(G.innerHTML=ae),jt=n(t),W=o(t,"P",{"data-svelte-h":!0}),f(W)!=="svelte-1oaxjb2"&&(W.innerHTML=se),Ct=n(t),Q=o(t,"UL",{"data-svelte-h":!0}),f(Q)!=="svelte-1nyb7sq"&&(Q.innerHTML=le),It=n(t),X=o(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-ln8ru0"&&(X.textContent=ne),_t=n(t),z=o(t,"P",{"data-svelte-h":!0}),f(z)!=="svelte-zksv0b"&&(z.innerHTML=ie),kt=n(t),r(L.$$.fragment,t),xt=n(t),Y=o(t,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-66fdrc"&&(Y.innerHTML=oe),Ft=n(t),r(P.$$.fragment,t),Zt=n(t),S=o(t,"P",{"data-svelte-h":!0}),f(S)!=="svelte-17e9zqg"&&(S.textContent=fe),Ht=n(t),r(R.$$.fragment,t),Bt=n(t),V=o(t,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1ochab2"&&(V.innerHTML=pe),qt=n(t),A=o(t,"P",{"data-svelte-h":!0}),f(A)!=="svelte-1hnqaln"&&(A.innerHTML=re),Gt=n(t),r(O.$$.fragment,t),Wt=n(t),r(N.$$.fragment,t),Qt=n(t),D=o(t,"UL",{"data-svelte-h":!0}),f(D)!=="svelte-16wm5ae"&&(D.innerHTML=he),Xt=n(t),r(E.$$.fragment,t),zt=n(t),at=o(t,"P",{}),ue(at).forEach(a),this.h()},h(){me(c,"name","hf:doc:metadata"),me(c,"content",Je)},m(t,e){be(document.head,c),s(t,st,e),s(t,et,e),s(t,lt,e),h(y,t,e),s(t,nt,e),s(t,g,e),s(t,it,e),s(t,w,e),s(t,ot,e),s(t,M,e),s(t,ft,e),s(t,b,e),s(t,pt,e),h(T,t,e),s(t,rt,e),s(t,U,e),s(t,ht,e),h(J,t,e),s(t,ut,e),s(t,$,e),s(t,mt,e),h(v,t,e),s(t,dt,e),h(j,t,e),s(t,ct,e),s(t,C,e),s(t,yt,e),s(t,I,e),s(t,gt,e),h(_,t,e),s(t,wt,e),s(t,k,e),s(t,Mt,e),h(x,t,e),s(t,bt,e),s(t,F,e),s(t,Tt,e),s(t,Z,e),s(t,Ut,e),s(t,H,e),s(t,Jt,e),h(B,t,e),s(t,$t,e),h(q,t,e),s(t,vt,e),s(t,G,e),s(t,jt,e),s(t,W,e),s(t,Ct,e),s(t,Q,e),s(t,It,e),s(t,X,e),s(t,_t,e),s(t,z,e),s(t,kt,e),h(L,t,e),s(t,xt,e),s(t,Y,e),s(t,Ft,e),h(P,t,e),s(t,Zt,e),s(t,S,e),s(t,Ht,e),h(R,t,e),s(t,Bt,e),s(t,V,e),s(t,qt,e),s(t,A,e),s(t,Gt,e),h(O,t,e),s(t,Wt,e),h(N,t,e),s(t,Qt,e),s(t,D,e),s(t,Xt,e),h(E,t,e),s(t,zt,e),s(t,at,e),Lt=!0},p:ce,i(t){Lt||(u(y.$$.fragment,t),u(T.$$.fragment,t),u(J.$$.fragment,t),u(v.$$.fragment,t),u(j.$$.fragment,t),u(_.$$.fragment,t),u(x.$$.fragment,t),u(B.$$.fragment,t),u(q.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),u(R.$$.fragment,t),u(O.$$.fragment,t),u(N.$$.fragment,t),u(E.$$.fragment,t),Lt=!0)},o(t){m(y.$$.fragment,t),m(T.$$.fragment,t),m(J.$$.fragment,t),m(v.$$.fragment,t),m(j.$$.fragment,t),m(_.$$.fragment,t),m(x.$$.fragment,t),m(B.$$.fragment,t),m(q.$$.fragment,t),m(L.$$.fragment,t),m(P.$$.fragment,t),m(R.$$.fragment,t),m(O.$$.fragment,t),m(N.$$.fragment,t),m(E.$$.fragment,t),Lt=!1},d(t){t&&(a(st),a(et),a(lt),a(nt),a(g),a(it),a(w),a(ot),a(M),a(ft),a(b),a(pt),a(rt),a(U),a(ht),a(ut),a($),a(mt),a(dt),a(ct),a(C),a(yt),a(I),a(gt),a(wt),a(k),a(Mt),a(bt),a(F),a(Tt),a(Z),a(Ut),a(H),a(Jt),a($t),a(vt),a(G),a(jt),a(W),a(Ct),a(Q),a(It),a(X),a(_t),a(z),a(kt),a(xt),a(Y),a(Ft),a(Zt),a(S),a(Ht),a(Bt),a(V),a(qt),a(A),a(Gt),a(Wt),a(Qt),a(D),a(Xt),a(zt),a(at)),a(c),d(y,t),d(T,t),d(J,t),d(v,t),d(j,t),d(_,t),d(x,t),d(B,t),d(q,t),d(L,t),d(P,t),d(R,t),d(O,t),d(N,t),d(E,t)}}}const Je='{"title":"FiftyOne","local":"fiftyone","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Loading Visual Datasets from the Hub","local":"loading-visual-datasets-from-the-hub","sections":[{"title":"Loading FiftyOne datasets from the Hub","local":"loading-fiftyone-datasets-from-the-hub","sections":[],"depth":3},{"title":"Loading Parquet Datasets from the Hub with FiftyOne","local":"loading-parquet-datasets-from-the-hub-with-fiftyone","sections":[],"depth":3}],"depth":2},{"title":"Pushing FiftyOne Datasets to the Hub","local":"pushing-fiftyone-datasets-to-the-hub","sections":[],"depth":2},{"title":"📚 Resources","local":"-resources","sections":[],"depth":2}],"depth":1}';function $e(Yt){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends ge{constructor(c){super(),we(this,c,$e,Ue,de,{})}}export{_e as component};
