import{s as Qm,n as Xm,o as Ym}from"../chunks/scheduler.85c25b89.js";import{S as ep,i as tp,g as o,s as a,r as i,A as ap,h as r,f as l,c as n,j as _,u as d,x as s,k as h,y as t,a as v,v as c,d as m,t as p,w as g}from"../chunks/index.c9bcf812.js";import{D as u}from"../chunks/Docstring.46c9d080.js";import{H as F,E as np}from"../chunks/EditOnGithub.ec73e7c7.js";function op(Xd){let ee,cr,ir,mr,nt,pr,ot,Yd=`At TRL we support PPO (Proximal Policy Optimisation) with an implementation that largely follows  the structure introduced in the paper “Fine-Tuning Language Models from Human Preferences” by D. Ziegler et al. [<a href="https://arxiv.org/pdf/1909.08593.pdf" rel="nofollow">paper</a>, <a href="https://github.com/openai/lm-human-preferences" rel="nofollow">code</a>].
The Trainer and model classes are largely inspired from <code>transformers.Trainer</code> and <code>transformers.AutoModel</code> classes and adapted for RL.
We also support a <code>RewardTrainer</code> that can be used to train a reward model.`,gr,rt,_r,R,lt,Wl,Ba,ec='CPOConfig collects all training arguments related to the <a href="/docs/trl/pr_1769/en/trainer#trl.CPOTrainer">CPOTrainer</a> class.',Bl,Ga,tc=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,hr,st,ur,$,it,Gl,Za,ac="Initialize CPOTrainer.",Zl,re,dt,Jl,Ja,nc=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Ql,S,ct,Xl,Qa,oc="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Yl,Xa,rc="We do this to avoid doing two forward passes, because it’s faster for FSDP.",es,le,mt,ts,Ya,lc="Concatenate the chosen and rejected inputs into a single tensor.",as,se,pt,ns,en,sc="Compute the CPO loss for a batch of policy and reference model log probabilities.",os,K,gt,rs,tn,ic=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,ls,an,dc="Works both with or without labels.",ss,ie,_t,is,nn,cc="Compute the log probabilities of the given labels under the given logits.",ds,de,ht,cs,on,mc="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",ms,ce,ut,ps,rn,pc="Generate samples from the model and reference model for the given batch of inputs.",gs,me,ft,_s,ln,gc="Log <code>logs</code> on the various objects watching training, including stored metrics.",hs,z,vt,us,sn,_c="Tokenize a single row from a CPO specific dataset.",fs,dn,hc=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,vs,cn,uc=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,fr,bt,vr,te,Tt,bs,mn,fc="Configuration class for DDPOTrainer",br,Ot,Tr,D,xt,Ts,pn,vc=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,Os,pe,$t,xs,gn,bc="Calculate the loss for a batch of an unpacked sample",$s,ge,Pt,Ps,_n,Tc="Creates and saves a model card for a TRL model.",ws,I,wt,ys,hn,Oc="Perform a single step of training.",Cs,un,xc="Side Effects:",ks,fn,$c="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",Ns,_e,yt,Ds,vn,Pc="Train the model for a given number of epochs",Or,Ct,xr,b,kt,Fs,bn,wc="Initialize DPOTrainer.",Ls,he,Nt,zs,Tn,yc=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Is,ue,Dt,Ms,On,Cc="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",qs,A,Ft,Es,xn,kc="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Rs,$n,Nc="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Us,fe,Lt,Hs,Pn,Dc="Concatenate the chosen and rejected inputs into a single tensor.",Vs,ve,zt,js,wn,Fc="Compute the DPO loss for a batch of policy and reference model log probabilities.",Ss,W,It,Ks,yn,Lc=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,As,Cn,zc="Works both with or without labels.",Ws,be,Mt,Bs,kn,Ic="Compute the log probabilities of the given labels under the given logits.",Gs,Te,qt,Zs,Nn,Mc="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Js,Oe,Et,Qs,Dn,qc="Generate samples from the model and reference model for the given batch of inputs.",Xs,B,Rt,Ys,Fn,Ec="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",ei,Ln,Rc="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",ti,G,Ut,ai,zn,Uc="Returns the training <code>~torch.utils.data.DataLoader</code>.",ni,In,Hc="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",oi,xe,Ht,ri,Mn,Vc="Log <code>logs</code> on the various objects watching training, including stored metrics.",li,$e,Vt,si,qn,jc="Context manager for handling null reference model (that is, peft adapter manipulation).",ii,M,jt,di,En,Sc="Tokenize a single row from a DPO specific dataset.",ci,Rn,Kc=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,mi,Un,Ac=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,$r,St,Pr,U,Kt,pi,Hn,Wc="The IterativeSFTTrainer can be used to finetune models with methods that requires some steps between optimization.",gi,Pe,At,_i,Vn,Bc="Run an optimisation step given a list of input_ids, attention_mask, and labels or a list of text and text_labels.",wr,Wt,yr,H,Bt,hi,jn,Gc='KTOConfig collects all training arguments related to the <a href="/docs/trl/pr_1769/en/trainer#trl.KTOTrainer">KTOTrainer</a> class.',ui,Sn,Zc=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Cr,Gt,kr,O,Zt,fi,Kn,Jc="Initialize KTOTrainer.",vi,we,Jt,bi,An,Qc="Compute the BCO loss for a batch of policy and reference model log probabilities.",Ti,ye,Qt,Oi,Wn,Xc="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",xi,Z,Xt,$i,Bn,Yc=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Pi,Gn,em="Works both with or without labels.",wi,Ce,Yt,yi,Zn,tm="Compute the log probabilities of the given labels under the given logits.",Ci,ke,ea,ki,Jn,am="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",Ni,Ne,ta,Di,Qn,nm="Generate samples from the model and reference model for the given batch of inputs.",Fi,J,aa,Li,Xn,om="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",zi,Yn,rm="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Ii,Q,na,Mi,eo,lm="Returns the training <code>~torch.utils.data.DataLoader</code>.",qi,to,sm="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Ei,De,oa,Ri,ao,im="Compute the KTO loss for a batch of policy and reference model log probabilities.",Ui,Fe,ra,Hi,no,dm="Log <code>logs</code> on the various objects watching training, including stored metrics.",Vi,Le,la,ji,oo,cm="Context manager for handling null reference model (that is, peft adapter manipulation).",Nr,sa,Dr,V,ia,Si,ro,mm='ORPOConfig collects all training arguments related to the <a href="/docs/trl/pr_1769/en/orpo_trainer#trl.ORPOTrainer">ORPOTrainer</a> class.',Ki,lo,pm=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Fr,da,Lr,P,ca,Ai,so,gm="Initialize ORPOTrainer.",Wi,ze,ma,Bi,io,_m=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Gi,X,pa,Zi,co,hm="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Ji,mo,um="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Qi,Ie,ga,Xi,po,fm="Concatenate the chosen and rejected inputs into a single tensor.",Yi,Y,_a,ed,go,vm=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,td,_o,bm="Works both with or without labels.",ad,Me,ha,nd,ho,Tm="Compute the log probabilities of the given labels under the given logits.",od,qe,ua,rd,uo,Om="Compute the ORPO loss and other metrics for the given batch of inputs for train or test.",ld,Ee,fa,sd,fo,xm="Generate samples from the model and reference model for the given batch of inputs.",id,Re,va,dd,vo,$m="Log <code>logs</code> on the various objects watching training, including stored metrics.",cd,Ue,ba,md,bo,Pm="Compute ORPO’s odds ratio (OR) loss for a batch of policy and reference model log probabilities.",pd,q,Ta,gd,To,wm="Tokenize a single row from a ORPO specific dataset.",_d,Oo,ym=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,hd,xo,Cm=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,zr,Oa,Ir,ae,xa,ud,$o,km="Configuration class for PPOTrainer",Mr,$a,qr,x,Pa,fd,Po,Nm=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,vd,He,wa,bd,wo,Dm="Calculate model outputs in multiple batches.",Td,Ve,ya,Od,yo,Fm="Compute per token rewards from scores and KL-penalty.",xd,je,Ca,$d,Co,Lm="Creates and saves a model card for a TRL model.",Pd,Se,ka,wd,ko,zm="Gather stats from all processes. Useful in the context of distributed training.",yd,Ke,Na,Cd,No,Im=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,kd,Ae,Da,Nd,Do,Mm="A function that logs all the training stats. Call it at the end of each epoch.",Dd,We,Fa,Fd,Fo,qm="Calculate policy and value losses.",Ld,Be,La,zd,Lo,Em="Prepare the dataloader for training.",Id,Ge,za,Md,zo,Rm="Record training step statistics.",qd,Ze,Ia,Ed,Io,Um="Run a PPO optimisation step given a list of queries, model responses, and rewards.",Rd,Je,Ma,Ud,Mo,Hm="Train one PPO minibatch",Er,qa,Rr,j,Ea,Hd,qo,Vm='RewardConfig collects all training arguments related to the <a href="/docs/trl/pr_1769/en/trainer#trl.RewardTrainer">RewardTrainer</a> class.',Vd,Eo,jm=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Ur,Ra,Hr,N,Ua,jd,Ro,Sm=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,Sd,Uo,Km=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,Kd,Ho,Am="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Ad,Vo,Wm=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,Wd,Qe,Ha,Bd,jo,Bm="Concatenate the chosen and rejected inputs into a single tensor.",Gd,Xe,Va,Zd,So,Gm="Visualize the reward model logits prediction",Vr,ja,jr,ne,Sa,Jd,Ko,Zm=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Sr,Ka,Kr,oe,Aa,Qd,Ao,Jm="Helper function for reproducible behavior to set the seed in <code>random</code>, <code>numpy</code>, and <code>torch</code>.",Ar,Wa,Wr,dr,Br;return nt=new F({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),rt=new F({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),lt=new u({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"cpo_alpha",val:": float = 1.0"},{name:"simpo_gamma",val:": float = 0.5"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in CPO loss.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>sigmoid</code>) &#x2014;
The type of loss to use. This argument is required if you want to use the default data collator.`,name:"loss_type"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.cpo_alpha",description:`<strong>cpo_alpha</strong> (<code>float</code>, defaults to <code>1.0</code>) &#x2014;
A hyperparameter that controls the strength of the BC regularizer in CPO training.`,name:"cpo_alpha"},{anchor:"trl.CPOConfig.simpo_gamma",description:`<strong>simpo_gamma</strong> (<code>float</code>, defaults to <code>0.5</code>) &#x2014;
A target reward margin for the SimPO loss, used only when the &#x201C;simpo&#x201D; option is enabled.`,name:"simpo_gamma"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_config.py#L20"}}),st=new F({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),it=new u({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L55"}}),dt=new u({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L318"}}),ct=new u({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L670"}}),mt=new u({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L519",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),pt=new u({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L581",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),gt=new u({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L878"}}),_t=new u({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ht=new u({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L745"}}),ut=new u({props:{name:"get_batch_samples",anchor:"trl.CPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L813"}}),ft=new u({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L926"}}),vt=new u({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/cpo_trainer.py#L368"}}),bt=new F({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),Tt=new u({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": Optional = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": Optional = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": Optional = ''"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ddpo_config.py#L11"}}),Ot=new F({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),xt=new u({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": Callable"},{name:"prompt_function",val:": Callable"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ddpo_trainer.py#L55"}}),$t=new u({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ddpo_trainer.py#L340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),Pt=new u({props:{name:"create_model_card",anchor:"trl.DDPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL DDPO Model'"}],parametersDescription:[{anchor:"trl.DDPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.DDPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL DDPO Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ddpo_trainer.py#L606"}}),wt=new u({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ddpo_trainer.py#L234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),yt=new u({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ddpo_trainer.py#L596"}}),Ct=new F({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),kt=new u({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L69"}}),Nt=new u({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L685"}}),Dt=new u({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L898"}}),Ft=new u({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L1171"}}),Lt=new u({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L924",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),zt=new u({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L986",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),It=new u({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L1437"}}),Mt=new u({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L1138",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A Tuple of two tensor of shape ((batch_size,), (batch_size,)) containing the sum of log probabilities of the given labels under the given logits in the first tensor and the number of non-masked tokens in the second tensor.</p>
`}}),qt=new u({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L1245"}}),Et=new u({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L1347"}}),Rt=new u({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L633"}}),Ut=new u({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L590"}}),Ht=new u({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L1487"}}),Vt=new u({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L886"}}),jt=new u({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/dpo_trainer.py#L735"}}),St=new F({props:{title:"IterativeSFTTrainer",local:"trl.IterativeSFTTrainer",headingTag:"h2"}}),Kt=new u({props:{name:"class trl.IterativeSFTTrainer",anchor:"trl.IterativeSFTTrainer",parameters:[{name:"model",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"data_collator",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"truncation_mode",val:": Optional = 'keep_end'"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModel</code>) &#x2014; Model to be optimized, either an &#x2018;AutoModelForCausalLM&#x2019; or an &#x2018;AutoModelForSeq2SeqLM&#x2019;. &#x2014;
Check the documentation of <code>PreTrainedModel</code> for more details.`,name:"*model**"},{anchor:"trl.IterativeSFTTrainer.*args**",description:"*<strong>*args**</strong> (<code>transformers.TrainingArguments</code>) &#x2014; &#x2014; The arguments to use for training.",name:"*args**"},{anchor:"trl.IterativeSFTTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.IterativeSFTTrainer.*optimizers**",description:"*<strong>*optimizers**</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014; &#x2014; The optimizer and scheduler to use for training.",name:"*optimizers**"},{anchor:"trl.IterativeSFTTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (Union[DataCollatorForLanguageModeling, DataCollatorForSeq2Seq], <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader.`,name:"*data_collator**"},{anchor:"trl.IterativeSFTTrainer.*eval_dataset**",description:"*<strong>*eval_dataset**</strong> (<code>datasets.Dataset</code>) &#x2014; The dataset to use for evaluation.",name:"*eval_dataset**"},{anchor:"trl.IterativeSFTTrainer.*max_length**",description:"*<strong>*max_length**</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014; &#x2014; The maximum length of the input.",name:"*max_length**"},{anchor:"trl.IterativeSFTTrainer.*truncation_mode**",description:"*<strong>*truncation_mode**</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014; &#x2014; The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>.",name:"*truncation_mode**"},{anchor:"trl.IterativeSFTTrainer.*preprocess_logits_for_metrics**",description:"*<strong>*preprocess_logits_for_metrics**</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014; &#x2014; The function to use to preprocess the logits before computing the metrics.",name:"*preprocess_logits_for_metrics**"},{anchor:"trl.IterativeSFTTrainer.*compute_metrics**",description:"*<strong>*compute_metrics**</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014; &#x2014; The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return a dictionary string to metric values.",name:"*compute_metrics**"},{anchor:"trl.IterativeSFTTrainer.*optimize_device_cache",description:"*<strong>*optimize_device_cache</strong> *<em> (<code>bool</code>, </em>optional*, defaults to <code>False</code>) &#x2014; Optimize CUDA cache for slightly more memory-efficient training. &#x2014;",name:"*optimize_device_cache"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/iterative_sft_trainer.py#L39"}}),At=new u({props:{name:"step",anchor:"trl.IterativeSFTTrainer.step",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"texts",val:": Optional = None"},{name:"texts_labels",val:": Optional = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.step.input_ids",description:`<strong>input_ids</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the input_ids (if not provided, text will be used)`,name:"input_ids"},{anchor:"trl.IterativeSFTTrainer.step.attention_mask",description:`<strong>attention_mask</strong> (List<code>torch.LongTensor</code>, , <em>optional</em>) &#x2014;
List of tensors containing the attention_mask`,name:"attention_mask"},{anchor:"trl.IterativeSFTTrainer.step.labels",description:`<strong>labels</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of tensors containing the labels (if set to None, will default to input_ids)`,name:"labels"},{anchor:"trl.IterativeSFTTrainer.step.texts",description:`<strong>texts</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text input (if not provided, input_ids will directly be used)`,name:"texts"},{anchor:"trl.IterativeSFTTrainer.step.texts_labels",description:`<strong>texts_labels</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text labels (if set to None, will default to text)`,name:"texts_labels"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/iterative_sft_trainer.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Wt=new F({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),Bt=new u({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"loss_type",val:": Literal = 'kto'"},{name:"prompt_sample_size",val:": int = 1024"},{name:"min_density_ratio",val:": float = 0.5"},{name:"max_density_ratio",val:": float = 10.0"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.
loss_type &#x2014; (<code>Literal[&quot;kto&quot;, &quot;bco&quot;]</code>, <em>optional</em>):
The type of loss to use. Either <code>&quot;kto&quot;</code> the default KTO loss, <code>&quot;bco&quot;</code> loss from <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> paper.
prompt_sample_size &#x2014; (<code>int</code>, defaults to 1024):
Number of prompts that are fed to density ratio classifier.
min_density_ratio &#x2014; (<code>float</code>, defaults to 0.5):
The minimum value of the density ratio. The estimated density ratio is clamped to this value.
max_density_ratio &#x2014; (<code>float</code>, defaults to 10.0):
The maximum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_config.py#L22"}}),Gt=new F({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),Zt=new u({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"embedding_func",val:": Optional = None"},{name:"embedding_tokenizer",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.KTOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.KTOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L269"}}),Jt=new u({props:{name:"bco_loss",anchor:"trl.KTOTrainer.bco_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"chosen_embeddings",val:": Optional"},{name:"rejected_embeddings",val:": Optional"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L1225",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The delta value contains the moving average of all implicit rewards.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),Qt=new u({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L976"}}),Xt=new u({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L1489"}}),Yt=new u({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L1048",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ea=new u({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L1275"}}),ta=new u({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L1403"}}),aa=new u({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L923"}}),na=new u({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L882"}}),oa=new u({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L1163",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),ra=new u({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L1545"}}),la=new u({props:{name:"null_ref_context",anchor:"trl.KTOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/kto_trainer.py#L870"}}),sa=new F({props:{title:"ORPOConfig",local:"trl.ORPOConfig",headingTag:"h2"}}),ia=new u({props:{name:"class trl.ORPOConfig",anchor:"trl.ORPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"disable_dropout",val:": bool = True"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.ORPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.ORPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the completions. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.ORPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in ORPO loss (lambda/alpha in paper/code) that is the weight of the relative loss ratio in the SFT loss.`,name:"beta"},{anchor:"trl.ORPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.ORPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.ORPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.ORPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.ORPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.ORPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.ORPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.ORPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_config.py#L20"}}),da=new F({props:{title:"ORPOTrainer",local:"trl.ORPOTrainer",headingTag:"h2"}}),ca=new u({props:{name:"class trl.ORPOTrainer",anchor:"trl.ORPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.ORPOTrainer.args",description:`<strong>args</strong> (<code>ORPOConfig</code>) &#x2014;
The ORPO config arguments to use for training.`,name:"args"},{anchor:"trl.ORPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.ORPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.ORPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.ORPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.ORPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.ORPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.ORPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.ORPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.ORPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.ORPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L62"}}),ma=new u({props:{name:"build_tokenized_answer",anchor:"trl.ORPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L335"}}),pa=new u({props:{name:"concatenated_forward",anchor:"trl.ORPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L668"}}),ga=new u({props:{name:"concatenated_inputs",anchor:"trl.ORPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L536",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),_a=new u({props:{name:"evaluation_loop",anchor:"trl.ORPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L880"}}),ha=new u({props:{name:"get_batch_logps",anchor:"trl.ORPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L630",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ua=new u({props:{name:"get_batch_loss_metrics",anchor:"trl.ORPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L745"}}),fa=new u({props:{name:"get_batch_samples",anchor:"trl.ORPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L815"}}),va=new u({props:{name:"log",anchor:"trl.ORPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.ORPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L928"}}),ba=new u({props:{name:"odds_ratio_loss",anchor:"trl.ORPOTrainer.odds_ratio_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L598",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the ORPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The log odds ratio of the chosen responses over the rejected responses ratio for logging purposes.
The <code>log(sigmoid(log_odds_chosen))</code> for logging purposes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ta=new u({props:{name:"tokenize_row",anchor:"trl.ORPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/orpo_trainer.py#L385"}}),Oa=new F({props:{title:"PPOConfig",local:"trl.PPOConfig",headingTag:"h2"}}),xa=new u({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": Optional = 'gpt2'"},{name:"query_dataset",val:": Optional = 'imdb'"},{name:"reward_model",val:": Optional = 'sentiment-analysis:lvwerra/distilbert-imdb'"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1.41e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": Optional = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": Optional = 6"},{name:"horizon",val:": Optional = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 128"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 128"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Annotated = None"},{name:"global_batch_size",val:": Annotated = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_config.py#L34"}}),$a=new F({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),Pa=new u({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"},{name:"training_data_collator",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L114"}}),wa=new u({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L970",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),ya=new u({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L1103",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Ca=new u({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L1411"}}),ka=new u({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L926",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Na=new u({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Optional = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L455",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),Da=new u({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": Iterable = ('query', 'response')"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L1338"}}),Fa=new u({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L1185"}}),La=new u({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L400",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),za=new u({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L1274",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),Ia=new u({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L646",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Ma=new u({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/ppo_trainer.py#L1057",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),qa=new F({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),Ea=new u({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"concatenate_forward_flag",val:": Optional = False"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/reward_config.py#L21"}}),Ra=new F({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),Ua=new u({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/reward_trainer.py#L39"}}),Ha=new u({props:{name:"concatenated_inputs",anchor:"trl.RewardTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/reward_trainer.py#L219",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Va=new u({props:{name:"visualize_samples",anchor:"trl.RewardTrainer.visualize_samples",parameters:[{name:"num_print_samples",val:": int"}],parametersDescription:[{anchor:"trl.RewardTrainer.visualize_samples.num_print_samples",description:`<strong>num_print_samples</strong> (<code>int</code>, defaults to <code>4</code>) &#x2014;
The number of samples to print. Set to <code>-1</code> to print all samples.`,name:"num_print_samples"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/reward_trainer.py#L350"}}),ja=new F({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),Sa=new u({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="/docs/trl/pr_1769/en/sft_trainer#trl.SFTConfig">SFTConfig</a>) &#x2014;
The arguments to tweak for training. Will default to a basic instance of <a href="/docs/trl/pr_1769/en/sft_trainer#trl.SFTConfig">SFTConfig</a> with the <code>output_dir</code>
set to a directory named <em>tmp_trainer</em> in the current directory if not provided.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/sft_trainer.py#L58"}}),Ka=new F({props:{title:"set_seed",local:"trl.set_seed",headingTag:"h2"}}),Aa=new u({props:{name:"trl.set_seed",anchor:"trl.set_seed",parameters:[{name:"seed",val:": int"}],parametersDescription:[{anchor:"trl.set_seed.seed",description:"<strong>seed</strong> (<code>int</code>) &#x2014; The seed to set.",name:"seed"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/core.py#L245"}}),Wa=new np({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/trainer.mdx"}}),{c(){ee=o("meta"),cr=a(),ir=o("p"),mr=a(),i(nt.$$.fragment),pr=a(),ot=o("p"),ot.innerHTML=Yd,gr=a(),i(rt.$$.fragment),_r=a(),R=o("div"),i(lt.$$.fragment),Wl=a(),Ba=o("p"),Ba.innerHTML=ec,Bl=a(),Ga=o("p"),Ga.innerHTML=tc,hr=a(),i(st.$$.fragment),ur=a(),$=o("div"),i(it.$$.fragment),Gl=a(),Za=o("p"),Za.textContent=ac,Zl=a(),re=o("div"),i(dt.$$.fragment),Jl=a(),Ja=o("p"),Ja.innerHTML=nc,Ql=a(),S=o("div"),i(ct.$$.fragment),Xl=a(),Qa=o("p"),Qa.textContent=oc,Yl=a(),Xa=o("p"),Xa.textContent=rc,es=a(),le=o("div"),i(mt.$$.fragment),ts=a(),Ya=o("p"),Ya.textContent=lc,as=a(),se=o("div"),i(pt.$$.fragment),ns=a(),en=o("p"),en.textContent=sc,os=a(),K=o("div"),i(gt.$$.fragment),rs=a(),tn=o("p"),tn.innerHTML=ic,ls=a(),an=o("p"),an.textContent=dc,ss=a(),ie=o("div"),i(_t.$$.fragment),is=a(),nn=o("p"),nn.textContent=cc,ds=a(),de=o("div"),i(ht.$$.fragment),cs=a(),on=o("p"),on.textContent=mc,ms=a(),ce=o("div"),i(ut.$$.fragment),ps=a(),rn=o("p"),rn.textContent=pc,gs=a(),me=o("div"),i(ft.$$.fragment),_s=a(),ln=o("p"),ln.innerHTML=gc,hs=a(),z=o("div"),i(vt.$$.fragment),us=a(),sn=o("p"),sn.textContent=_c,fs=a(),dn=o("p"),dn.textContent=hc,vs=a(),cn=o("p"),cn.textContent=uc,fr=a(),i(bt.$$.fragment),vr=a(),te=o("div"),i(Tt.$$.fragment),bs=a(),mn=o("p"),mn.textContent=fc,br=a(),i(Ot.$$.fragment),Tr=a(),D=o("div"),i(xt.$$.fragment),Ts=a(),pn=o("p"),pn.innerHTML=vc,Os=a(),pe=o("div"),i($t.$$.fragment),xs=a(),gn=o("p"),gn.textContent=bc,$s=a(),ge=o("div"),i(Pt.$$.fragment),Ps=a(),_n=o("p"),_n.textContent=Tc,ws=a(),I=o("div"),i(wt.$$.fragment),ys=a(),hn=o("p"),hn.textContent=Oc,Cs=a(),un=o("p"),un.textContent=xc,ks=a(),fn=o("ul"),fn.innerHTML=$c,Ns=a(),_e=o("div"),i(yt.$$.fragment),Ds=a(),vn=o("p"),vn.textContent=Pc,Or=a(),i(Ct.$$.fragment),xr=a(),b=o("div"),i(kt.$$.fragment),Fs=a(),bn=o("p"),bn.textContent=wc,Ls=a(),he=o("div"),i(Nt.$$.fragment),zs=a(),Tn=o("p"),Tn.innerHTML=yc,Is=a(),ue=o("div"),i(Dt.$$.fragment),Ms=a(),On=o("p"),On.textContent=Cc,qs=a(),A=o("div"),i(Ft.$$.fragment),Es=a(),xn=o("p"),xn.textContent=kc,Rs=a(),$n=o("p"),$n.textContent=Nc,Us=a(),fe=o("div"),i(Lt.$$.fragment),Hs=a(),Pn=o("p"),Pn.textContent=Dc,Vs=a(),ve=o("div"),i(zt.$$.fragment),js=a(),wn=o("p"),wn.textContent=Fc,Ss=a(),W=o("div"),i(It.$$.fragment),Ks=a(),yn=o("p"),yn.innerHTML=Lc,As=a(),Cn=o("p"),Cn.textContent=zc,Ws=a(),be=o("div"),i(Mt.$$.fragment),Bs=a(),kn=o("p"),kn.textContent=Ic,Gs=a(),Te=o("div"),i(qt.$$.fragment),Zs=a(),Nn=o("p"),Nn.textContent=Mc,Js=a(),Oe=o("div"),i(Et.$$.fragment),Qs=a(),Dn=o("p"),Dn.textContent=qc,Xs=a(),B=o("div"),i(Rt.$$.fragment),Ys=a(),Fn=o("p"),Fn.innerHTML=Ec,ei=a(),Ln=o("p"),Ln.innerHTML=Rc,ti=a(),G=o("div"),i(Ut.$$.fragment),ai=a(),zn=o("p"),zn.innerHTML=Uc,ni=a(),In=o("p"),In.innerHTML=Hc,oi=a(),xe=o("div"),i(Ht.$$.fragment),ri=a(),Mn=o("p"),Mn.innerHTML=Vc,li=a(),$e=o("div"),i(Vt.$$.fragment),si=a(),qn=o("p"),qn.textContent=jc,ii=a(),M=o("div"),i(jt.$$.fragment),di=a(),En=o("p"),En.textContent=Sc,ci=a(),Rn=o("p"),Rn.textContent=Kc,mi=a(),Un=o("p"),Un.textContent=Ac,$r=a(),i(St.$$.fragment),Pr=a(),U=o("div"),i(Kt.$$.fragment),pi=a(),Hn=o("p"),Hn.textContent=Wc,gi=a(),Pe=o("div"),i(At.$$.fragment),_i=a(),Vn=o("p"),Vn.textContent=Bc,wr=a(),i(Wt.$$.fragment),yr=a(),H=o("div"),i(Bt.$$.fragment),hi=a(),jn=o("p"),jn.innerHTML=Gc,ui=a(),Sn=o("p"),Sn.innerHTML=Zc,Cr=a(),i(Gt.$$.fragment),kr=a(),O=o("div"),i(Zt.$$.fragment),fi=a(),Kn=o("p"),Kn.textContent=Jc,vi=a(),we=o("div"),i(Jt.$$.fragment),bi=a(),An=o("p"),An.textContent=Qc,Ti=a(),ye=o("div"),i(Qt.$$.fragment),Oi=a(),Wn=o("p"),Wn.textContent=Xc,xi=a(),Z=o("div"),i(Xt.$$.fragment),$i=a(),Bn=o("p"),Bn.innerHTML=Yc,Pi=a(),Gn=o("p"),Gn.textContent=em,wi=a(),Ce=o("div"),i(Yt.$$.fragment),yi=a(),Zn=o("p"),Zn.textContent=tm,Ci=a(),ke=o("div"),i(ea.$$.fragment),ki=a(),Jn=o("p"),Jn.textContent=am,Ni=a(),Ne=o("div"),i(ta.$$.fragment),Di=a(),Qn=o("p"),Qn.textContent=nm,Fi=a(),J=o("div"),i(aa.$$.fragment),Li=a(),Xn=o("p"),Xn.innerHTML=om,zi=a(),Yn=o("p"),Yn.innerHTML=rm,Ii=a(),Q=o("div"),i(na.$$.fragment),Mi=a(),eo=o("p"),eo.innerHTML=lm,qi=a(),to=o("p"),to.innerHTML=sm,Ei=a(),De=o("div"),i(oa.$$.fragment),Ri=a(),ao=o("p"),ao.textContent=im,Ui=a(),Fe=o("div"),i(ra.$$.fragment),Hi=a(),no=o("p"),no.innerHTML=dm,Vi=a(),Le=o("div"),i(la.$$.fragment),ji=a(),oo=o("p"),oo.textContent=cm,Nr=a(),i(sa.$$.fragment),Dr=a(),V=o("div"),i(ia.$$.fragment),Si=a(),ro=o("p"),ro.innerHTML=mm,Ki=a(),lo=o("p"),lo.innerHTML=pm,Fr=a(),i(da.$$.fragment),Lr=a(),P=o("div"),i(ca.$$.fragment),Ai=a(),so=o("p"),so.textContent=gm,Wi=a(),ze=o("div"),i(ma.$$.fragment),Bi=a(),io=o("p"),io.innerHTML=_m,Gi=a(),X=o("div"),i(pa.$$.fragment),Zi=a(),co=o("p"),co.textContent=hm,Ji=a(),mo=o("p"),mo.textContent=um,Qi=a(),Ie=o("div"),i(ga.$$.fragment),Xi=a(),po=o("p"),po.textContent=fm,Yi=a(),Y=o("div"),i(_a.$$.fragment),ed=a(),go=o("p"),go.innerHTML=vm,td=a(),_o=o("p"),_o.textContent=bm,ad=a(),Me=o("div"),i(ha.$$.fragment),nd=a(),ho=o("p"),ho.textContent=Tm,od=a(),qe=o("div"),i(ua.$$.fragment),rd=a(),uo=o("p"),uo.textContent=Om,ld=a(),Ee=o("div"),i(fa.$$.fragment),sd=a(),fo=o("p"),fo.textContent=xm,id=a(),Re=o("div"),i(va.$$.fragment),dd=a(),vo=o("p"),vo.innerHTML=$m,cd=a(),Ue=o("div"),i(ba.$$.fragment),md=a(),bo=o("p"),bo.textContent=Pm,pd=a(),q=o("div"),i(Ta.$$.fragment),gd=a(),To=o("p"),To.textContent=wm,_d=a(),Oo=o("p"),Oo.textContent=ym,hd=a(),xo=o("p"),xo.textContent=Cm,zr=a(),i(Oa.$$.fragment),Ir=a(),ae=o("div"),i(xa.$$.fragment),ud=a(),$o=o("p"),$o.textContent=km,Mr=a(),i($a.$$.fragment),qr=a(),x=o("div"),i(Pa.$$.fragment),fd=a(),Po=o("p"),Po.innerHTML=Nm,vd=a(),He=o("div"),i(wa.$$.fragment),bd=a(),wo=o("p"),wo.textContent=Dm,Td=a(),Ve=o("div"),i(ya.$$.fragment),Od=a(),yo=o("p"),yo.textContent=Fm,xd=a(),je=o("div"),i(Ca.$$.fragment),$d=a(),Co=o("p"),Co.textContent=Lm,Pd=a(),Se=o("div"),i(ka.$$.fragment),wd=a(),ko=o("p"),ko.textContent=zm,yd=a(),Ke=o("div"),i(Na.$$.fragment),Cd=a(),No=o("p"),No.innerHTML=Im,kd=a(),Ae=o("div"),i(Da.$$.fragment),Nd=a(),Do=o("p"),Do.textContent=Mm,Dd=a(),We=o("div"),i(Fa.$$.fragment),Fd=a(),Fo=o("p"),Fo.textContent=qm,Ld=a(),Be=o("div"),i(La.$$.fragment),zd=a(),Lo=o("p"),Lo.textContent=Em,Id=a(),Ge=o("div"),i(za.$$.fragment),Md=a(),zo=o("p"),zo.textContent=Rm,qd=a(),Ze=o("div"),i(Ia.$$.fragment),Ed=a(),Io=o("p"),Io.textContent=Um,Rd=a(),Je=o("div"),i(Ma.$$.fragment),Ud=a(),Mo=o("p"),Mo.textContent=Hm,Er=a(),i(qa.$$.fragment),Rr=a(),j=o("div"),i(Ea.$$.fragment),Hd=a(),qo=o("p"),qo.innerHTML=Vm,Vd=a(),Eo=o("p"),Eo.innerHTML=jm,Ur=a(),i(Ra.$$.fragment),Hr=a(),N=o("div"),i(Ua.$$.fragment),jd=a(),Ro=o("p"),Ro.innerHTML=Sm,Sd=a(),Uo=o("p"),Uo.innerHTML=Km,Kd=a(),Ho=o("ul"),Ho.innerHTML=Am,Ad=a(),Vo=o("p"),Vo.innerHTML=Wm,Wd=a(),Qe=o("div"),i(Ha.$$.fragment),Bd=a(),jo=o("p"),jo.textContent=Bm,Gd=a(),Xe=o("div"),i(Va.$$.fragment),Zd=a(),So=o("p"),So.textContent=Gm,Vr=a(),i(ja.$$.fragment),jr=a(),ne=o("div"),i(Sa.$$.fragment),Jd=a(),Ko=o("p"),Ko.innerHTML=Zm,Sr=a(),i(Ka.$$.fragment),Kr=a(),oe=o("div"),i(Aa.$$.fragment),Qd=a(),Ao=o("p"),Ao.innerHTML=Jm,Ar=a(),i(Wa.$$.fragment),Wr=a(),dr=o("p"),this.h()},l(e){const f=ap("svelte-u9bgzb",document.head);ee=r(f,"META",{name:!0,content:!0}),f.forEach(l),cr=n(e),ir=r(e,"P",{}),_(ir).forEach(l),mr=n(e),d(nt.$$.fragment,e),pr=n(e),ot=r(e,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-dxrcnp"&&(ot.innerHTML=Yd),gr=n(e),d(rt.$$.fragment,e),_r=n(e),R=r(e,"DIV",{class:!0});var Wo=_(R);d(lt.$$.fragment,Wo),Wl=n(Wo),Ba=r(Wo,"P",{"data-svelte-h":!0}),s(Ba)!=="svelte-1mop215"&&(Ba.innerHTML=ec),Bl=n(Wo),Ga=r(Wo,"P",{"data-svelte-h":!0}),s(Ga)!=="svelte-1xl7jqc"&&(Ga.innerHTML=tc),Wo.forEach(l),hr=n(e),d(st.$$.fragment,e),ur=n(e),$=r(e,"DIV",{class:!0});var C=_($);d(it.$$.fragment,C),Gl=n(C),Za=r(C,"P",{"data-svelte-h":!0}),s(Za)!=="svelte-1qqtmoh"&&(Za.textContent=ac),Zl=n(C),re=r(C,"DIV",{class:!0});var Gr=_(re);d(dt.$$.fragment,Gr),Jl=n(Gr),Ja=r(Gr,"P",{"data-svelte-h":!0}),s(Ja)!=="svelte-mcz8nm"&&(Ja.innerHTML=nc),Gr.forEach(l),Ql=n(C),S=r(C,"DIV",{class:!0});var Bo=_(S);d(ct.$$.fragment,Bo),Xl=n(Bo),Qa=r(Bo,"P",{"data-svelte-h":!0}),s(Qa)!=="svelte-16i1nac"&&(Qa.textContent=oc),Yl=n(Bo),Xa=r(Bo,"P",{"data-svelte-h":!0}),s(Xa)!=="svelte-tgti68"&&(Xa.textContent=rc),Bo.forEach(l),es=n(C),le=r(C,"DIV",{class:!0});var Zr=_(le);d(mt.$$.fragment,Zr),ts=n(Zr),Ya=r(Zr,"P",{"data-svelte-h":!0}),s(Ya)!=="svelte-1cvsgkk"&&(Ya.textContent=lc),Zr.forEach(l),as=n(C),se=r(C,"DIV",{class:!0});var Jr=_(se);d(pt.$$.fragment,Jr),ns=n(Jr),en=r(Jr,"P",{"data-svelte-h":!0}),s(en)!=="svelte-1l2rxe2"&&(en.textContent=sc),Jr.forEach(l),os=n(C),K=r(C,"DIV",{class:!0});var Go=_(K);d(gt.$$.fragment,Go),rs=n(Go),tn=r(Go,"P",{"data-svelte-h":!0}),s(tn)!=="svelte-8qlty5"&&(tn.innerHTML=ic),ls=n(Go),an=r(Go,"P",{"data-svelte-h":!0}),s(an)!=="svelte-1tyo99t"&&(an.textContent=dc),Go.forEach(l),ss=n(C),ie=r(C,"DIV",{class:!0});var Qr=_(ie);d(_t.$$.fragment,Qr),is=n(Qr),nn=r(Qr,"P",{"data-svelte-h":!0}),s(nn)!=="svelte-4nmimv"&&(nn.textContent=cc),Qr.forEach(l),ds=n(C),de=r(C,"DIV",{class:!0});var Xr=_(de);d(ht.$$.fragment,Xr),cs=n(Xr),on=r(Xr,"P",{"data-svelte-h":!0}),s(on)!=="svelte-4kzfyw"&&(on.textContent=mc),Xr.forEach(l),ms=n(C),ce=r(C,"DIV",{class:!0});var Yr=_(ce);d(ut.$$.fragment,Yr),ps=n(Yr),rn=r(Yr,"P",{"data-svelte-h":!0}),s(rn)!=="svelte-18uwvbi"&&(rn.textContent=pc),Yr.forEach(l),gs=n(C),me=r(C,"DIV",{class:!0});var el=_(me);d(ft.$$.fragment,el),_s=n(el),ln=r(el,"P",{"data-svelte-h":!0}),s(ln)!=="svelte-nqksfz"&&(ln.innerHTML=gc),el.forEach(l),hs=n(C),z=r(C,"DIV",{class:!0});var Ye=_(z);d(vt.$$.fragment,Ye),us=n(Ye),sn=r(Ye,"P",{"data-svelte-h":!0}),s(sn)!=="svelte-1a53vwp"&&(sn.textContent=_c),fs=n(Ye),dn=r(Ye,"P",{"data-svelte-h":!0}),s(dn)!=="svelte-1mn1gnw"&&(dn.textContent=hc),vs=n(Ye),cn=r(Ye,"P",{"data-svelte-h":!0}),s(cn)!=="svelte-1xvpyih"&&(cn.textContent=uc),Ye.forEach(l),C.forEach(l),fr=n(e),d(bt.$$.fragment,e),vr=n(e),te=r(e,"DIV",{class:!0});var tl=_(te);d(Tt.$$.fragment,tl),bs=n(tl),mn=r(tl,"P",{"data-svelte-h":!0}),s(mn)!=="svelte-2zpx1f"&&(mn.textContent=fc),tl.forEach(l),br=n(e),d(Ot.$$.fragment,e),Tr=n(e),D=r(e,"DIV",{class:!0});var E=_(D);d(xt.$$.fragment,E),Ts=n(E),pn=r(E,"P",{"data-svelte-h":!0}),s(pn)!=="svelte-8q861t"&&(pn.innerHTML=vc),Os=n(E),pe=r(E,"DIV",{class:!0});var al=_(pe);d($t.$$.fragment,al),xs=n(al),gn=r(al,"P",{"data-svelte-h":!0}),s(gn)!=="svelte-1ag17u3"&&(gn.textContent=bc),al.forEach(l),$s=n(E),ge=r(E,"DIV",{class:!0});var nl=_(ge);d(Pt.$$.fragment,nl),Ps=n(nl),_n=r(nl,"P",{"data-svelte-h":!0}),s(_n)!=="svelte-3jfrz9"&&(_n.textContent=Tc),nl.forEach(l),ws=n(E),I=r(E,"DIV",{class:!0});var et=_(I);d(wt.$$.fragment,et),ys=n(et),hn=r(et,"P",{"data-svelte-h":!0}),s(hn)!=="svelte-r6y15n"&&(hn.textContent=Oc),Cs=n(et),un=r(et,"P",{"data-svelte-h":!0}),s(un)!=="svelte-imqqfp"&&(un.textContent=xc),ks=n(et),fn=r(et,"UL",{"data-svelte-h":!0}),s(fn)!=="svelte-105j238"&&(fn.innerHTML=$c),et.forEach(l),Ns=n(E),_e=r(E,"DIV",{class:!0});var ol=_(_e);d(yt.$$.fragment,ol),Ds=n(ol),vn=r(ol,"P",{"data-svelte-h":!0}),s(vn)!=="svelte-1an944l"&&(vn.textContent=Pc),ol.forEach(l),E.forEach(l),Or=n(e),d(Ct.$$.fragment,e),xr=n(e),b=r(e,"DIV",{class:!0});var T=_(b);d(kt.$$.fragment,T),Fs=n(T),bn=r(T,"P",{"data-svelte-h":!0}),s(bn)!=="svelte-n6cc8y"&&(bn.textContent=wc),Ls=n(T),he=r(T,"DIV",{class:!0});var rl=_(he);d(Nt.$$.fragment,rl),zs=n(rl),Tn=r(rl,"P",{"data-svelte-h":!0}),s(Tn)!=="svelte-mcz8nm"&&(Tn.innerHTML=yc),rl.forEach(l),Is=n(T),ue=r(T,"DIV",{class:!0});var ll=_(ue);d(Dt.$$.fragment,ll),Ms=n(ll),On=r(ll,"P",{"data-svelte-h":!0}),s(On)!=="svelte-10t1062"&&(On.textContent=Cc),ll.forEach(l),qs=n(T),A=r(T,"DIV",{class:!0});var Zo=_(A);d(Ft.$$.fragment,Zo),Es=n(Zo),xn=r(Zo,"P",{"data-svelte-h":!0}),s(xn)!=="svelte-16i1nac"&&(xn.textContent=kc),Rs=n(Zo),$n=r(Zo,"P",{"data-svelte-h":!0}),s($n)!=="svelte-tgti68"&&($n.textContent=Nc),Zo.forEach(l),Us=n(T),fe=r(T,"DIV",{class:!0});var sl=_(fe);d(Lt.$$.fragment,sl),Hs=n(sl),Pn=r(sl,"P",{"data-svelte-h":!0}),s(Pn)!=="svelte-1cvsgkk"&&(Pn.textContent=Dc),sl.forEach(l),Vs=n(T),ve=r(T,"DIV",{class:!0});var il=_(ve);d(zt.$$.fragment,il),js=n(il),wn=r(il,"P",{"data-svelte-h":!0}),s(wn)!=="svelte-ymgxq7"&&(wn.textContent=Fc),il.forEach(l),Ss=n(T),W=r(T,"DIV",{class:!0});var Jo=_(W);d(It.$$.fragment,Jo),Ks=n(Jo),yn=r(Jo,"P",{"data-svelte-h":!0}),s(yn)!=="svelte-8qlty5"&&(yn.innerHTML=Lc),As=n(Jo),Cn=r(Jo,"P",{"data-svelte-h":!0}),s(Cn)!=="svelte-1tyo99t"&&(Cn.textContent=zc),Jo.forEach(l),Ws=n(T),be=r(T,"DIV",{class:!0});var dl=_(be);d(Mt.$$.fragment,dl),Bs=n(dl),kn=r(dl,"P",{"data-svelte-h":!0}),s(kn)!=="svelte-4nmimv"&&(kn.textContent=Ic),dl.forEach(l),Gs=n(T),Te=r(T,"DIV",{class:!0});var cl=_(Te);d(qt.$$.fragment,cl),Zs=n(cl),Nn=r(cl,"P",{"data-svelte-h":!0}),s(Nn)!=="svelte-11q8u7l"&&(Nn.textContent=Mc),cl.forEach(l),Js=n(T),Oe=r(T,"DIV",{class:!0});var ml=_(Oe);d(Et.$$.fragment,ml),Qs=n(ml),Dn=r(ml,"P",{"data-svelte-h":!0}),s(Dn)!=="svelte-18uwvbi"&&(Dn.textContent=qc),ml.forEach(l),Xs=n(T),B=r(T,"DIV",{class:!0});var Qo=_(B);d(Rt.$$.fragment,Qo),Ys=n(Qo),Fn=r(Qo,"P",{"data-svelte-h":!0}),s(Fn)!=="svelte-xesobz"&&(Fn.innerHTML=Ec),ei=n(Qo),Ln=r(Qo,"P",{"data-svelte-h":!0}),s(Ln)!=="svelte-qg43tm"&&(Ln.innerHTML=Rc),Qo.forEach(l),ti=n(T),G=r(T,"DIV",{class:!0});var Xo=_(G);d(Ut.$$.fragment,Xo),ai=n(Xo),zn=r(Xo,"P",{"data-svelte-h":!0}),s(zn)!=="svelte-dkae9b"&&(zn.innerHTML=Uc),ni=n(Xo),In=r(Xo,"P",{"data-svelte-h":!0}),s(In)!=="svelte-hmd5cw"&&(In.innerHTML=Hc),Xo.forEach(l),oi=n(T),xe=r(T,"DIV",{class:!0});var pl=_(xe);d(Ht.$$.fragment,pl),ri=n(pl),Mn=r(pl,"P",{"data-svelte-h":!0}),s(Mn)!=="svelte-nqksfz"&&(Mn.innerHTML=Vc),pl.forEach(l),li=n(T),$e=r(T,"DIV",{class:!0});var gl=_($e);d(Vt.$$.fragment,gl),si=n(gl),qn=r(gl,"P",{"data-svelte-h":!0}),s(qn)!=="svelte-17kjsy4"&&(qn.textContent=jc),gl.forEach(l),ii=n(T),M=r(T,"DIV",{class:!0});var tt=_(M);d(jt.$$.fragment,tt),di=n(tt),En=r(tt,"P",{"data-svelte-h":!0}),s(En)!=="svelte-1861yti"&&(En.textContent=Sc),ci=n(tt),Rn=r(tt,"P",{"data-svelte-h":!0}),s(Rn)!=="svelte-1mn1gnw"&&(Rn.textContent=Kc),mi=n(tt),Un=r(tt,"P",{"data-svelte-h":!0}),s(Un)!=="svelte-1xvpyih"&&(Un.textContent=Ac),tt.forEach(l),T.forEach(l),$r=n(e),d(St.$$.fragment,e),Pr=n(e),U=r(e,"DIV",{class:!0});var Yo=_(U);d(Kt.$$.fragment,Yo),pi=n(Yo),Hn=r(Yo,"P",{"data-svelte-h":!0}),s(Hn)!=="svelte-xqyw6w"&&(Hn.textContent=Wc),gi=n(Yo),Pe=r(Yo,"DIV",{class:!0});var _l=_(Pe);d(At.$$.fragment,_l),_i=n(_l),Vn=r(_l,"P",{"data-svelte-h":!0}),s(Vn)!=="svelte-v7dhdf"&&(Vn.textContent=Bc),_l.forEach(l),Yo.forEach(l),wr=n(e),d(Wt.$$.fragment,e),yr=n(e),H=r(e,"DIV",{class:!0});var er=_(H);d(Bt.$$.fragment,er),hi=n(er),jn=r(er,"P",{"data-svelte-h":!0}),s(jn)!=="svelte-1m10f71"&&(jn.innerHTML=Gc),ui=n(er),Sn=r(er,"P",{"data-svelte-h":!0}),s(Sn)!=="svelte-1xl7jqc"&&(Sn.innerHTML=Zc),er.forEach(l),Cr=n(e),d(Gt.$$.fragment,e),kr=n(e),O=r(e,"DIV",{class:!0});var w=_(O);d(Zt.$$.fragment,w),fi=n(w),Kn=r(w,"P",{"data-svelte-h":!0}),s(Kn)!=="svelte-hyhzxp"&&(Kn.textContent=Jc),vi=n(w),we=r(w,"DIV",{class:!0});var hl=_(we);d(Jt.$$.fragment,hl),bi=n(hl),An=r(hl,"P",{"data-svelte-h":!0}),s(An)!=="svelte-2814fy"&&(An.textContent=Qc),hl.forEach(l),Ti=n(w),ye=r(w,"DIV",{class:!0});var ul=_(ye);d(Qt.$$.fragment,ul),Oi=n(ul),Wn=r(ul,"P",{"data-svelte-h":!0}),s(Wn)!=="svelte-pt6g01"&&(Wn.textContent=Xc),ul.forEach(l),xi=n(w),Z=r(w,"DIV",{class:!0});var tr=_(Z);d(Xt.$$.fragment,tr),$i=n(tr),Bn=r(tr,"P",{"data-svelte-h":!0}),s(Bn)!=="svelte-8qlty5"&&(Bn.innerHTML=Yc),Pi=n(tr),Gn=r(tr,"P",{"data-svelte-h":!0}),s(Gn)!=="svelte-1tyo99t"&&(Gn.textContent=em),tr.forEach(l),wi=n(w),Ce=r(w,"DIV",{class:!0});var fl=_(Ce);d(Yt.$$.fragment,fl),yi=n(fl),Zn=r(fl,"P",{"data-svelte-h":!0}),s(Zn)!=="svelte-4nmimv"&&(Zn.textContent=tm),fl.forEach(l),Ci=n(w),ke=r(w,"DIV",{class:!0});var vl=_(ke);d(ea.$$.fragment,vl),ki=n(vl),Jn=r(vl,"P",{"data-svelte-h":!0}),s(Jn)!=="svelte-db7iek"&&(Jn.textContent=am),vl.forEach(l),Ni=n(w),Ne=r(w,"DIV",{class:!0});var bl=_(Ne);d(ta.$$.fragment,bl),Di=n(bl),Qn=r(bl,"P",{"data-svelte-h":!0}),s(Qn)!=="svelte-18uwvbi"&&(Qn.textContent=nm),bl.forEach(l),Fi=n(w),J=r(w,"DIV",{class:!0});var ar=_(J);d(aa.$$.fragment,ar),Li=n(ar),Xn=r(ar,"P",{"data-svelte-h":!0}),s(Xn)!=="svelte-xesobz"&&(Xn.innerHTML=om),zi=n(ar),Yn=r(ar,"P",{"data-svelte-h":!0}),s(Yn)!=="svelte-qg43tm"&&(Yn.innerHTML=rm),ar.forEach(l),Ii=n(w),Q=r(w,"DIV",{class:!0});var nr=_(Q);d(na.$$.fragment,nr),Mi=n(nr),eo=r(nr,"P",{"data-svelte-h":!0}),s(eo)!=="svelte-dkae9b"&&(eo.innerHTML=lm),qi=n(nr),to=r(nr,"P",{"data-svelte-h":!0}),s(to)!=="svelte-hmd5cw"&&(to.innerHTML=sm),nr.forEach(l),Ei=n(w),De=r(w,"DIV",{class:!0});var Tl=_(De);d(oa.$$.fragment,Tl),Ri=n(Tl),ao=r(Tl,"P",{"data-svelte-h":!0}),s(ao)!=="svelte-svckwe"&&(ao.textContent=im),Tl.forEach(l),Ui=n(w),Fe=r(w,"DIV",{class:!0});var Ol=_(Fe);d(ra.$$.fragment,Ol),Hi=n(Ol),no=r(Ol,"P",{"data-svelte-h":!0}),s(no)!=="svelte-nqksfz"&&(no.innerHTML=dm),Ol.forEach(l),Vi=n(w),Le=r(w,"DIV",{class:!0});var xl=_(Le);d(la.$$.fragment,xl),ji=n(xl),oo=r(xl,"P",{"data-svelte-h":!0}),s(oo)!=="svelte-17kjsy4"&&(oo.textContent=cm),xl.forEach(l),w.forEach(l),Nr=n(e),d(sa.$$.fragment,e),Dr=n(e),V=r(e,"DIV",{class:!0});var or=_(V);d(ia.$$.fragment,or),Si=n(or),ro=r(or,"P",{"data-svelte-h":!0}),s(ro)!=="svelte-1lspykg"&&(ro.innerHTML=mm),Ki=n(or),lo=r(or,"P",{"data-svelte-h":!0}),s(lo)!=="svelte-1xl7jqc"&&(lo.innerHTML=pm),or.forEach(l),Fr=n(e),d(da.$$.fragment,e),Lr=n(e),P=r(e,"DIV",{class:!0});var k=_(P);d(ca.$$.fragment,k),Ai=n(k),so=r(k,"P",{"data-svelte-h":!0}),s(so)!=="svelte-1ggwo37"&&(so.textContent=gm),Wi=n(k),ze=r(k,"DIV",{class:!0});var $l=_(ze);d(ma.$$.fragment,$l),Bi=n($l),io=r($l,"P",{"data-svelte-h":!0}),s(io)!=="svelte-mcz8nm"&&(io.innerHTML=_m),$l.forEach(l),Gi=n(k),X=r(k,"DIV",{class:!0});var rr=_(X);d(pa.$$.fragment,rr),Zi=n(rr),co=r(rr,"P",{"data-svelte-h":!0}),s(co)!=="svelte-16i1nac"&&(co.textContent=hm),Ji=n(rr),mo=r(rr,"P",{"data-svelte-h":!0}),s(mo)!=="svelte-tgti68"&&(mo.textContent=um),rr.forEach(l),Qi=n(k),Ie=r(k,"DIV",{class:!0});var Pl=_(Ie);d(ga.$$.fragment,Pl),Xi=n(Pl),po=r(Pl,"P",{"data-svelte-h":!0}),s(po)!=="svelte-1cvsgkk"&&(po.textContent=fm),Pl.forEach(l),Yi=n(k),Y=r(k,"DIV",{class:!0});var lr=_(Y);d(_a.$$.fragment,lr),ed=n(lr),go=r(lr,"P",{"data-svelte-h":!0}),s(go)!=="svelte-8qlty5"&&(go.innerHTML=vm),td=n(lr),_o=r(lr,"P",{"data-svelte-h":!0}),s(_o)!=="svelte-1tyo99t"&&(_o.textContent=bm),lr.forEach(l),ad=n(k),Me=r(k,"DIV",{class:!0});var wl=_(Me);d(ha.$$.fragment,wl),nd=n(wl),ho=r(wl,"P",{"data-svelte-h":!0}),s(ho)!=="svelte-4nmimv"&&(ho.textContent=Tm),wl.forEach(l),od=n(k),qe=r(k,"DIV",{class:!0});var yl=_(qe);d(ua.$$.fragment,yl),rd=n(yl),uo=r(yl,"P",{"data-svelte-h":!0}),s(uo)!=="svelte-ndgk7s"&&(uo.textContent=Om),yl.forEach(l),ld=n(k),Ee=r(k,"DIV",{class:!0});var Cl=_(Ee);d(fa.$$.fragment,Cl),sd=n(Cl),fo=r(Cl,"P",{"data-svelte-h":!0}),s(fo)!=="svelte-18uwvbi"&&(fo.textContent=xm),Cl.forEach(l),id=n(k),Re=r(k,"DIV",{class:!0});var kl=_(Re);d(va.$$.fragment,kl),dd=n(kl),vo=r(kl,"P",{"data-svelte-h":!0}),s(vo)!=="svelte-nqksfz"&&(vo.innerHTML=$m),kl.forEach(l),cd=n(k),Ue=r(k,"DIV",{class:!0});var Nl=_(Ue);d(ba.$$.fragment,Nl),md=n(Nl),bo=r(Nl,"P",{"data-svelte-h":!0}),s(bo)!=="svelte-y2dr0o"&&(bo.textContent=Pm),Nl.forEach(l),pd=n(k),q=r(k,"DIV",{class:!0});var at=_(q);d(Ta.$$.fragment,at),gd=n(at),To=r(at,"P",{"data-svelte-h":!0}),s(To)!=="svelte-xlsvih"&&(To.textContent=wm),_d=n(at),Oo=r(at,"P",{"data-svelte-h":!0}),s(Oo)!=="svelte-1mn1gnw"&&(Oo.textContent=ym),hd=n(at),xo=r(at,"P",{"data-svelte-h":!0}),s(xo)!=="svelte-1xvpyih"&&(xo.textContent=Cm),at.forEach(l),k.forEach(l),zr=n(e),d(Oa.$$.fragment,e),Ir=n(e),ae=r(e,"DIV",{class:!0});var Dl=_(ae);d(xa.$$.fragment,Dl),ud=n(Dl),$o=r(Dl,"P",{"data-svelte-h":!0}),s($o)!=="svelte-aondqr"&&($o.textContent=km),Dl.forEach(l),Mr=n(e),d($a.$$.fragment,e),qr=n(e),x=r(e,"DIV",{class:!0});var y=_(x);d(Pa.$$.fragment,y),fd=n(y),Po=r(y,"P",{"data-svelte-h":!0}),s(Po)!=="svelte-hys9rl"&&(Po.innerHTML=Nm),vd=n(y),He=r(y,"DIV",{class:!0});var Fl=_(He);d(wa.$$.fragment,Fl),bd=n(Fl),wo=r(Fl,"P",{"data-svelte-h":!0}),s(wo)!=="svelte-185nst0"&&(wo.textContent=Dm),Fl.forEach(l),Td=n(y),Ve=r(y,"DIV",{class:!0});var Ll=_(Ve);d(ya.$$.fragment,Ll),Od=n(Ll),yo=r(Ll,"P",{"data-svelte-h":!0}),s(yo)!=="svelte-3nt516"&&(yo.textContent=Fm),Ll.forEach(l),xd=n(y),je=r(y,"DIV",{class:!0});var zl=_(je);d(Ca.$$.fragment,zl),$d=n(zl),Co=r(zl,"P",{"data-svelte-h":!0}),s(Co)!=="svelte-3jfrz9"&&(Co.textContent=Lm),zl.forEach(l),Pd=n(y),Se=r(y,"DIV",{class:!0});var Il=_(Se);d(ka.$$.fragment,Il),wd=n(Il),ko=r(Il,"P",{"data-svelte-h":!0}),s(ko)!=="svelte-lcc1u3"&&(ko.textContent=zm),Il.forEach(l),yd=n(y),Ke=r(y,"DIV",{class:!0});var Ml=_(Ke);d(Na.$$.fragment,Ml),Cd=n(Ml),No=r(Ml,"P",{"data-svelte-h":!0}),s(No)!=="svelte-1gqqzmu"&&(No.innerHTML=Im),Ml.forEach(l),kd=n(y),Ae=r(y,"DIV",{class:!0});var ql=_(Ae);d(Da.$$.fragment,ql),Nd=n(ql),Do=r(ql,"P",{"data-svelte-h":!0}),s(Do)!=="svelte-ffqz5"&&(Do.textContent=Mm),ql.forEach(l),Dd=n(y),We=r(y,"DIV",{class:!0});var El=_(We);d(Fa.$$.fragment,El),Fd=n(El),Fo=r(El,"P",{"data-svelte-h":!0}),s(Fo)!=="svelte-febvhf"&&(Fo.textContent=qm),El.forEach(l),Ld=n(y),Be=r(y,"DIV",{class:!0});var Rl=_(Be);d(La.$$.fragment,Rl),zd=n(Rl),Lo=r(Rl,"P",{"data-svelte-h":!0}),s(Lo)!=="svelte-1hbodkw"&&(Lo.textContent=Em),Rl.forEach(l),Id=n(y),Ge=r(y,"DIV",{class:!0});var Ul=_(Ge);d(za.$$.fragment,Ul),Md=n(Ul),zo=r(Ul,"P",{"data-svelte-h":!0}),s(zo)!=="svelte-1hfgx92"&&(zo.textContent=Rm),Ul.forEach(l),qd=n(y),Ze=r(y,"DIV",{class:!0});var Hl=_(Ze);d(Ia.$$.fragment,Hl),Ed=n(Hl),Io=r(Hl,"P",{"data-svelte-h":!0}),s(Io)!=="svelte-yrsdu6"&&(Io.textContent=Um),Hl.forEach(l),Rd=n(y),Je=r(y,"DIV",{class:!0});var Vl=_(Je);d(Ma.$$.fragment,Vl),Ud=n(Vl),Mo=r(Vl,"P",{"data-svelte-h":!0}),s(Mo)!=="svelte-3k7k5e"&&(Mo.textContent=Hm),Vl.forEach(l),y.forEach(l),Er=n(e),d(qa.$$.fragment,e),Rr=n(e),j=r(e,"DIV",{class:!0});var sr=_(j);d(Ea.$$.fragment,sr),Hd=n(sr),qo=r(sr,"P",{"data-svelte-h":!0}),s(qo)!=="svelte-12bspjw"&&(qo.innerHTML=Vm),Vd=n(sr),Eo=r(sr,"P",{"data-svelte-h":!0}),s(Eo)!=="svelte-1xl7jqc"&&(Eo.innerHTML=jm),sr.forEach(l),Ur=n(e),d(Ra.$$.fragment,e),Hr=n(e),N=r(e,"DIV",{class:!0});var L=_(N);d(Ua.$$.fragment,L),jd=n(L),Ro=r(L,"P",{"data-svelte-h":!0}),s(Ro)!=="svelte-qafafj"&&(Ro.innerHTML=Sm),Sd=n(L),Uo=r(L,"P",{"data-svelte-h":!0}),s(Uo)!=="svelte-bkmbwh"&&(Uo.innerHTML=Km),Kd=n(L),Ho=r(L,"UL",{"data-svelte-h":!0}),s(Ho)!=="svelte-1ytuxgw"&&(Ho.innerHTML=Am),Ad=n(L),Vo=r(L,"P",{"data-svelte-h":!0}),s(Vo)!=="svelte-18tbp4c"&&(Vo.innerHTML=Wm),Wd=n(L),Qe=r(L,"DIV",{class:!0});var jl=_(Qe);d(Ha.$$.fragment,jl),Bd=n(jl),jo=r(jl,"P",{"data-svelte-h":!0}),s(jo)!=="svelte-1cvsgkk"&&(jo.textContent=Bm),jl.forEach(l),Gd=n(L),Xe=r(L,"DIV",{class:!0});var Sl=_(Xe);d(Va.$$.fragment,Sl),Zd=n(Sl),So=r(Sl,"P",{"data-svelte-h":!0}),s(So)!=="svelte-1g38ldc"&&(So.textContent=Gm),Sl.forEach(l),L.forEach(l),Vr=n(e),d(ja.$$.fragment,e),jr=n(e),ne=r(e,"DIV",{class:!0});var Kl=_(ne);d(Sa.$$.fragment,Kl),Jd=n(Kl),Ko=r(Kl,"P",{"data-svelte-h":!0}),s(Ko)!=="svelte-14oyph8"&&(Ko.innerHTML=Zm),Kl.forEach(l),Sr=n(e),d(Ka.$$.fragment,e),Kr=n(e),oe=r(e,"DIV",{class:!0});var Al=_(oe);d(Aa.$$.fragment,Al),Qd=n(Al),Ao=r(Al,"P",{"data-svelte-h":!0}),s(Ao)!=="svelte-1aeuhep"&&(Ao.innerHTML=Jm),Al.forEach(l),Ar=n(e),d(Wa.$$.fragment,e),Wr=n(e),dr=r(e,"P",{}),_(dr).forEach(l),this.h()},h(){h(ee,"name","hf:doc:metadata"),h(ee,"content",rp),h(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){t(document.head,ee),v(e,cr,f),v(e,ir,f),v(e,mr,f),c(nt,e,f),v(e,pr,f),v(e,ot,f),v(e,gr,f),c(rt,e,f),v(e,_r,f),v(e,R,f),c(lt,R,null),t(R,Wl),t(R,Ba),t(R,Bl),t(R,Ga),v(e,hr,f),c(st,e,f),v(e,ur,f),v(e,$,f),c(it,$,null),t($,Gl),t($,Za),t($,Zl),t($,re),c(dt,re,null),t(re,Jl),t(re,Ja),t($,Ql),t($,S),c(ct,S,null),t(S,Xl),t(S,Qa),t(S,Yl),t(S,Xa),t($,es),t($,le),c(mt,le,null),t(le,ts),t(le,Ya),t($,as),t($,se),c(pt,se,null),t(se,ns),t(se,en),t($,os),t($,K),c(gt,K,null),t(K,rs),t(K,tn),t(K,ls),t(K,an),t($,ss),t($,ie),c(_t,ie,null),t(ie,is),t(ie,nn),t($,ds),t($,de),c(ht,de,null),t(de,cs),t(de,on),t($,ms),t($,ce),c(ut,ce,null),t(ce,ps),t(ce,rn),t($,gs),t($,me),c(ft,me,null),t(me,_s),t(me,ln),t($,hs),t($,z),c(vt,z,null),t(z,us),t(z,sn),t(z,fs),t(z,dn),t(z,vs),t(z,cn),v(e,fr,f),c(bt,e,f),v(e,vr,f),v(e,te,f),c(Tt,te,null),t(te,bs),t(te,mn),v(e,br,f),c(Ot,e,f),v(e,Tr,f),v(e,D,f),c(xt,D,null),t(D,Ts),t(D,pn),t(D,Os),t(D,pe),c($t,pe,null),t(pe,xs),t(pe,gn),t(D,$s),t(D,ge),c(Pt,ge,null),t(ge,Ps),t(ge,_n),t(D,ws),t(D,I),c(wt,I,null),t(I,ys),t(I,hn),t(I,Cs),t(I,un),t(I,ks),t(I,fn),t(D,Ns),t(D,_e),c(yt,_e,null),t(_e,Ds),t(_e,vn),v(e,Or,f),c(Ct,e,f),v(e,xr,f),v(e,b,f),c(kt,b,null),t(b,Fs),t(b,bn),t(b,Ls),t(b,he),c(Nt,he,null),t(he,zs),t(he,Tn),t(b,Is),t(b,ue),c(Dt,ue,null),t(ue,Ms),t(ue,On),t(b,qs),t(b,A),c(Ft,A,null),t(A,Es),t(A,xn),t(A,Rs),t(A,$n),t(b,Us),t(b,fe),c(Lt,fe,null),t(fe,Hs),t(fe,Pn),t(b,Vs),t(b,ve),c(zt,ve,null),t(ve,js),t(ve,wn),t(b,Ss),t(b,W),c(It,W,null),t(W,Ks),t(W,yn),t(W,As),t(W,Cn),t(b,Ws),t(b,be),c(Mt,be,null),t(be,Bs),t(be,kn),t(b,Gs),t(b,Te),c(qt,Te,null),t(Te,Zs),t(Te,Nn),t(b,Js),t(b,Oe),c(Et,Oe,null),t(Oe,Qs),t(Oe,Dn),t(b,Xs),t(b,B),c(Rt,B,null),t(B,Ys),t(B,Fn),t(B,ei),t(B,Ln),t(b,ti),t(b,G),c(Ut,G,null),t(G,ai),t(G,zn),t(G,ni),t(G,In),t(b,oi),t(b,xe),c(Ht,xe,null),t(xe,ri),t(xe,Mn),t(b,li),t(b,$e),c(Vt,$e,null),t($e,si),t($e,qn),t(b,ii),t(b,M),c(jt,M,null),t(M,di),t(M,En),t(M,ci),t(M,Rn),t(M,mi),t(M,Un),v(e,$r,f),c(St,e,f),v(e,Pr,f),v(e,U,f),c(Kt,U,null),t(U,pi),t(U,Hn),t(U,gi),t(U,Pe),c(At,Pe,null),t(Pe,_i),t(Pe,Vn),v(e,wr,f),c(Wt,e,f),v(e,yr,f),v(e,H,f),c(Bt,H,null),t(H,hi),t(H,jn),t(H,ui),t(H,Sn),v(e,Cr,f),c(Gt,e,f),v(e,kr,f),v(e,O,f),c(Zt,O,null),t(O,fi),t(O,Kn),t(O,vi),t(O,we),c(Jt,we,null),t(we,bi),t(we,An),t(O,Ti),t(O,ye),c(Qt,ye,null),t(ye,Oi),t(ye,Wn),t(O,xi),t(O,Z),c(Xt,Z,null),t(Z,$i),t(Z,Bn),t(Z,Pi),t(Z,Gn),t(O,wi),t(O,Ce),c(Yt,Ce,null),t(Ce,yi),t(Ce,Zn),t(O,Ci),t(O,ke),c(ea,ke,null),t(ke,ki),t(ke,Jn),t(O,Ni),t(O,Ne),c(ta,Ne,null),t(Ne,Di),t(Ne,Qn),t(O,Fi),t(O,J),c(aa,J,null),t(J,Li),t(J,Xn),t(J,zi),t(J,Yn),t(O,Ii),t(O,Q),c(na,Q,null),t(Q,Mi),t(Q,eo),t(Q,qi),t(Q,to),t(O,Ei),t(O,De),c(oa,De,null),t(De,Ri),t(De,ao),t(O,Ui),t(O,Fe),c(ra,Fe,null),t(Fe,Hi),t(Fe,no),t(O,Vi),t(O,Le),c(la,Le,null),t(Le,ji),t(Le,oo),v(e,Nr,f),c(sa,e,f),v(e,Dr,f),v(e,V,f),c(ia,V,null),t(V,Si),t(V,ro),t(V,Ki),t(V,lo),v(e,Fr,f),c(da,e,f),v(e,Lr,f),v(e,P,f),c(ca,P,null),t(P,Ai),t(P,so),t(P,Wi),t(P,ze),c(ma,ze,null),t(ze,Bi),t(ze,io),t(P,Gi),t(P,X),c(pa,X,null),t(X,Zi),t(X,co),t(X,Ji),t(X,mo),t(P,Qi),t(P,Ie),c(ga,Ie,null),t(Ie,Xi),t(Ie,po),t(P,Yi),t(P,Y),c(_a,Y,null),t(Y,ed),t(Y,go),t(Y,td),t(Y,_o),t(P,ad),t(P,Me),c(ha,Me,null),t(Me,nd),t(Me,ho),t(P,od),t(P,qe),c(ua,qe,null),t(qe,rd),t(qe,uo),t(P,ld),t(P,Ee),c(fa,Ee,null),t(Ee,sd),t(Ee,fo),t(P,id),t(P,Re),c(va,Re,null),t(Re,dd),t(Re,vo),t(P,cd),t(P,Ue),c(ba,Ue,null),t(Ue,md),t(Ue,bo),t(P,pd),t(P,q),c(Ta,q,null),t(q,gd),t(q,To),t(q,_d),t(q,Oo),t(q,hd),t(q,xo),v(e,zr,f),c(Oa,e,f),v(e,Ir,f),v(e,ae,f),c(xa,ae,null),t(ae,ud),t(ae,$o),v(e,Mr,f),c($a,e,f),v(e,qr,f),v(e,x,f),c(Pa,x,null),t(x,fd),t(x,Po),t(x,vd),t(x,He),c(wa,He,null),t(He,bd),t(He,wo),t(x,Td),t(x,Ve),c(ya,Ve,null),t(Ve,Od),t(Ve,yo),t(x,xd),t(x,je),c(Ca,je,null),t(je,$d),t(je,Co),t(x,Pd),t(x,Se),c(ka,Se,null),t(Se,wd),t(Se,ko),t(x,yd),t(x,Ke),c(Na,Ke,null),t(Ke,Cd),t(Ke,No),t(x,kd),t(x,Ae),c(Da,Ae,null),t(Ae,Nd),t(Ae,Do),t(x,Dd),t(x,We),c(Fa,We,null),t(We,Fd),t(We,Fo),t(x,Ld),t(x,Be),c(La,Be,null),t(Be,zd),t(Be,Lo),t(x,Id),t(x,Ge),c(za,Ge,null),t(Ge,Md),t(Ge,zo),t(x,qd),t(x,Ze),c(Ia,Ze,null),t(Ze,Ed),t(Ze,Io),t(x,Rd),t(x,Je),c(Ma,Je,null),t(Je,Ud),t(Je,Mo),v(e,Er,f),c(qa,e,f),v(e,Rr,f),v(e,j,f),c(Ea,j,null),t(j,Hd),t(j,qo),t(j,Vd),t(j,Eo),v(e,Ur,f),c(Ra,e,f),v(e,Hr,f),v(e,N,f),c(Ua,N,null),t(N,jd),t(N,Ro),t(N,Sd),t(N,Uo),t(N,Kd),t(N,Ho),t(N,Ad),t(N,Vo),t(N,Wd),t(N,Qe),c(Ha,Qe,null),t(Qe,Bd),t(Qe,jo),t(N,Gd),t(N,Xe),c(Va,Xe,null),t(Xe,Zd),t(Xe,So),v(e,Vr,f),c(ja,e,f),v(e,jr,f),v(e,ne,f),c(Sa,ne,null),t(ne,Jd),t(ne,Ko),v(e,Sr,f),c(Ka,e,f),v(e,Kr,f),v(e,oe,f),c(Aa,oe,null),t(oe,Qd),t(oe,Ao),v(e,Ar,f),c(Wa,e,f),v(e,Wr,f),v(e,dr,f),Br=!0},p:Xm,i(e){Br||(m(nt.$$.fragment,e),m(rt.$$.fragment,e),m(lt.$$.fragment,e),m(st.$$.fragment,e),m(it.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(mt.$$.fragment,e),m(pt.$$.fragment,e),m(gt.$$.fragment,e),m(_t.$$.fragment,e),m(ht.$$.fragment,e),m(ut.$$.fragment,e),m(ft.$$.fragment,e),m(vt.$$.fragment,e),m(bt.$$.fragment,e),m(Tt.$$.fragment,e),m(Ot.$$.fragment,e),m(xt.$$.fragment,e),m($t.$$.fragment,e),m(Pt.$$.fragment,e),m(wt.$$.fragment,e),m(yt.$$.fragment,e),m(Ct.$$.fragment,e),m(kt.$$.fragment,e),m(Nt.$$.fragment,e),m(Dt.$$.fragment,e),m(Ft.$$.fragment,e),m(Lt.$$.fragment,e),m(zt.$$.fragment,e),m(It.$$.fragment,e),m(Mt.$$.fragment,e),m(qt.$$.fragment,e),m(Et.$$.fragment,e),m(Rt.$$.fragment,e),m(Ut.$$.fragment,e),m(Ht.$$.fragment,e),m(Vt.$$.fragment,e),m(jt.$$.fragment,e),m(St.$$.fragment,e),m(Kt.$$.fragment,e),m(At.$$.fragment,e),m(Wt.$$.fragment,e),m(Bt.$$.fragment,e),m(Gt.$$.fragment,e),m(Zt.$$.fragment,e),m(Jt.$$.fragment,e),m(Qt.$$.fragment,e),m(Xt.$$.fragment,e),m(Yt.$$.fragment,e),m(ea.$$.fragment,e),m(ta.$$.fragment,e),m(aa.$$.fragment,e),m(na.$$.fragment,e),m(oa.$$.fragment,e),m(ra.$$.fragment,e),m(la.$$.fragment,e),m(sa.$$.fragment,e),m(ia.$$.fragment,e),m(da.$$.fragment,e),m(ca.$$.fragment,e),m(ma.$$.fragment,e),m(pa.$$.fragment,e),m(ga.$$.fragment,e),m(_a.$$.fragment,e),m(ha.$$.fragment,e),m(ua.$$.fragment,e),m(fa.$$.fragment,e),m(va.$$.fragment,e),m(ba.$$.fragment,e),m(Ta.$$.fragment,e),m(Oa.$$.fragment,e),m(xa.$$.fragment,e),m($a.$$.fragment,e),m(Pa.$$.fragment,e),m(wa.$$.fragment,e),m(ya.$$.fragment,e),m(Ca.$$.fragment,e),m(ka.$$.fragment,e),m(Na.$$.fragment,e),m(Da.$$.fragment,e),m(Fa.$$.fragment,e),m(La.$$.fragment,e),m(za.$$.fragment,e),m(Ia.$$.fragment,e),m(Ma.$$.fragment,e),m(qa.$$.fragment,e),m(Ea.$$.fragment,e),m(Ra.$$.fragment,e),m(Ua.$$.fragment,e),m(Ha.$$.fragment,e),m(Va.$$.fragment,e),m(ja.$$.fragment,e),m(Sa.$$.fragment,e),m(Ka.$$.fragment,e),m(Aa.$$.fragment,e),m(Wa.$$.fragment,e),Br=!0)},o(e){p(nt.$$.fragment,e),p(rt.$$.fragment,e),p(lt.$$.fragment,e),p(st.$$.fragment,e),p(it.$$.fragment,e),p(dt.$$.fragment,e),p(ct.$$.fragment,e),p(mt.$$.fragment,e),p(pt.$$.fragment,e),p(gt.$$.fragment,e),p(_t.$$.fragment,e),p(ht.$$.fragment,e),p(ut.$$.fragment,e),p(ft.$$.fragment,e),p(vt.$$.fragment,e),p(bt.$$.fragment,e),p(Tt.$$.fragment,e),p(Ot.$$.fragment,e),p(xt.$$.fragment,e),p($t.$$.fragment,e),p(Pt.$$.fragment,e),p(wt.$$.fragment,e),p(yt.$$.fragment,e),p(Ct.$$.fragment,e),p(kt.$$.fragment,e),p(Nt.$$.fragment,e),p(Dt.$$.fragment,e),p(Ft.$$.fragment,e),p(Lt.$$.fragment,e),p(zt.$$.fragment,e),p(It.$$.fragment,e),p(Mt.$$.fragment,e),p(qt.$$.fragment,e),p(Et.$$.fragment,e),p(Rt.$$.fragment,e),p(Ut.$$.fragment,e),p(Ht.$$.fragment,e),p(Vt.$$.fragment,e),p(jt.$$.fragment,e),p(St.$$.fragment,e),p(Kt.$$.fragment,e),p(At.$$.fragment,e),p(Wt.$$.fragment,e),p(Bt.$$.fragment,e),p(Gt.$$.fragment,e),p(Zt.$$.fragment,e),p(Jt.$$.fragment,e),p(Qt.$$.fragment,e),p(Xt.$$.fragment,e),p(Yt.$$.fragment,e),p(ea.$$.fragment,e),p(ta.$$.fragment,e),p(aa.$$.fragment,e),p(na.$$.fragment,e),p(oa.$$.fragment,e),p(ra.$$.fragment,e),p(la.$$.fragment,e),p(sa.$$.fragment,e),p(ia.$$.fragment,e),p(da.$$.fragment,e),p(ca.$$.fragment,e),p(ma.$$.fragment,e),p(pa.$$.fragment,e),p(ga.$$.fragment,e),p(_a.$$.fragment,e),p(ha.$$.fragment,e),p(ua.$$.fragment,e),p(fa.$$.fragment,e),p(va.$$.fragment,e),p(ba.$$.fragment,e),p(Ta.$$.fragment,e),p(Oa.$$.fragment,e),p(xa.$$.fragment,e),p($a.$$.fragment,e),p(Pa.$$.fragment,e),p(wa.$$.fragment,e),p(ya.$$.fragment,e),p(Ca.$$.fragment,e),p(ka.$$.fragment,e),p(Na.$$.fragment,e),p(Da.$$.fragment,e),p(Fa.$$.fragment,e),p(La.$$.fragment,e),p(za.$$.fragment,e),p(Ia.$$.fragment,e),p(Ma.$$.fragment,e),p(qa.$$.fragment,e),p(Ea.$$.fragment,e),p(Ra.$$.fragment,e),p(Ua.$$.fragment,e),p(Ha.$$.fragment,e),p(Va.$$.fragment,e),p(ja.$$.fragment,e),p(Sa.$$.fragment,e),p(Ka.$$.fragment,e),p(Aa.$$.fragment,e),p(Wa.$$.fragment,e),Br=!1},d(e){e&&(l(cr),l(ir),l(mr),l(pr),l(ot),l(gr),l(_r),l(R),l(hr),l(ur),l($),l(fr),l(vr),l(te),l(br),l(Tr),l(D),l(Or),l(xr),l(b),l($r),l(Pr),l(U),l(wr),l(yr),l(H),l(Cr),l(kr),l(O),l(Nr),l(Dr),l(V),l(Fr),l(Lr),l(P),l(zr),l(Ir),l(ae),l(Mr),l(qr),l(x),l(Er),l(Rr),l(j),l(Ur),l(Hr),l(N),l(Vr),l(jr),l(ne),l(Sr),l(Kr),l(oe),l(Ar),l(Wr),l(dr)),l(ee),g(nt,e),g(rt,e),g(lt),g(st,e),g(it),g(dt),g(ct),g(mt),g(pt),g(gt),g(_t),g(ht),g(ut),g(ft),g(vt),g(bt,e),g(Tt),g(Ot,e),g(xt),g($t),g(Pt),g(wt),g(yt),g(Ct,e),g(kt),g(Nt),g(Dt),g(Ft),g(Lt),g(zt),g(It),g(Mt),g(qt),g(Et),g(Rt),g(Ut),g(Ht),g(Vt),g(jt),g(St,e),g(Kt),g(At),g(Wt,e),g(Bt),g(Gt,e),g(Zt),g(Jt),g(Qt),g(Xt),g(Yt),g(ea),g(ta),g(aa),g(na),g(oa),g(ra),g(la),g(sa,e),g(ia),g(da,e),g(ca),g(ma),g(pa),g(ga),g(_a),g(ha),g(ua),g(fa),g(va),g(ba),g(Ta),g(Oa,e),g(xa),g($a,e),g(Pa),g(wa),g(ya),g(Ca),g(ka),g(Na),g(Da),g(Fa),g(La),g(za),g(Ia),g(Ma),g(qa,e),g(Ea),g(Ra,e),g(Ua),g(Ha),g(Va),g(ja,e),g(Sa),g(Ka,e),g(Aa),g(Wa,e)}}}const rp='{"title":"Trainer","local":"trainer","sections":[{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"IterativeSFTTrainer","local":"trl.IterativeSFTTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"ORPOConfig","local":"trl.ORPOConfig","sections":[],"depth":2},{"title":"ORPOTrainer","local":"trl.ORPOTrainer","sections":[],"depth":2},{"title":"PPOConfig","local":"trl.PPOConfig","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"set_seed","local":"trl.set_seed","sections":[],"depth":2}],"depth":1}';function lp(Xd){return Ym(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mp extends ep{constructor(ee){super(),tp(this,ee,lp,op,Qm,{})}}export{mp as component};
