import{s as xs,o as zs,n as Kt}from"../chunks/scheduler.25b97de1.js";import{S as Qs,i as Fs,g as o,s as n,r,A as Ys,h as i,f as s,c as l,j as Lt,u as h,x as c,k as Vs,y as b,a,v as m,d,t as u,w as M}from"../chunks/index.d9030fc9.js";import{T as Dt}from"../chunks/Tip.baa67368.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{H as w,E as $s}from"../chunks/EditOnGithub.91d95064.js";function Es(U){let p,J="One important concept you need to know when writing your own generation loop, is <code>cache_position</code>. In case you want to reuse an already filled Cache object by calling <code>forward()</code>, you have to pass in a valid <code>cache_position</code> which will indicate the positions of inputs in the sequence. Note that <code>cache_position</code> is not affected by padding, and always adds one more position for each token. For example, if key/value cache contains 10 tokens (no matter how many of it is a pad token), the cache position for the next token should be <code>torch.tensor([10])</code>.";return{c(){p=o("p"),p.innerHTML=J},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-fyl20k"&&(p.innerHTML=J)},m(y,f){a(y,p,f)},p:Kt,d(y){y&&s(p)}}}function qs(U){let p,J="Cache quantization can be detrimental in terms of latency if the context length is short and there is enough GPU VRAM available to run without cache quantization. It is recommended to seek balance between memory efficiency and latency.";return{c(){p=o("p"),p.textContent=J},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-46etli"&&(p.textContent=J)},m(y,f){a(y,p,f)},p:Kt,d(y){y&&s(p)}}}function Hs(U){let p,J="Cache offloading requires a GPU and can be slower than dynamic KV cache. Use it if you are getting CUDA out of memory errors.";return{c(){p=o("p"),p.textContent=J},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-16njdjl"&&(p.textContent=J)},m(y,f){a(y,p,f)},p:Kt,d(y){y&&s(p)}}}function Ss(U){let p,J,y,f,W,Ve,v,Pt=`Efficient caching is crucial for optimizing the performance of models in various generative tasks,
including text generation, translation, summarization and other transformer-based applications.
Effective caching helps reduce computation time and improve response rates, especially in real-time or resource-intensive applications.`,xe,Z,Ot=`Transformers support various caching methods, leveraging “Cache” classes to abstract and manage the caching logic.
This document outlines best practices for using these classes to maximize performance and efficiency.
Check out all the available <code>Cache</code> classes in the <a href="./internal/generation_utils.md">API documentation</a>.`,ze,_,Qe,G,es="Imagine you’re having a conversation with someone, and instead of remembering what was said previously, you have to start from scratch every time you respond. This would be slow and inefficient, right? In the world of Transformer models, a similar concept applies, and that’s where Caching keys and values come into play. From now on, I’ll refer to the concept as KV Cache.",Fe,X,ts="KV cache is needed to optimize the generation in autoregressive models, where the model predicts text token by token. This process can be slow since the model can generate only one token at a time, and each new prediction is dependent on the previous context. That means, to predict token number 1000 in the generation, you need information from the previous 999 tokens, which comes in the form of some matrix multiplications across the representations of those tokens. But to predict token number 1001, you also need the same information from the first 999 tokens, plus additional information from token number 1000. That is where key-value cache is used to optimize the sequential generation process by storing previous calculations to reuse in subsequent tokens, so they don’t need to be computed again.",Ye,R,ss="More concretely, key-value cache acts as a memory bank for these generative models, where the model stores key-value pairs derived from self-attention layers for previously processed tokens. By storing this information, the model can avoid redundant computations and instead retrieve keys and values of previous tokens from the cache.",$e,g,_e,as="<em>For the Curious Minds Who Like to Dive Deep</em>",Yt,B,$t,Ge,ns="When utilizing a cache object in the input, the Attention module performs several critical steps to integrate past and present information seamlessly.",Et,Xe,ls="The Attention module concatenates the current key-values with the past key-values stored in the cache. This results in attention weights of shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>. Essentially, the past and current key-values are combined to compute attention scores, ensuring that the model considers both previous context and new input. The concatenated key-values are used to compute the attention scores resulting in attention weights of shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>.",qt,Re,os="Therefore, when iteratively calling <code>forward()</code> instead of the <code>generate()</code> method, it’s crucial to ensure that the attention mask shape matches the combined length of past and current key-values. The attention mask should have the shape <code>(batch_size, past_kv_length + new_tokens_length)</code>. This is usually handled internally when you call <code>generate()</code> method. If you want to implement your own generation loop with Cache classes, take this into consideration and prepare the attention mask to hold values to current and past tokens.",Ht,k,St,Be,is="See an example below for how to implement your own generation loop.",At,N,Ee,V,qe,x,cs=`In 🤗 Transformers, we support various Cache types to optimize the performance across different models and tasks. By default, all models generate with caching,
with the <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.DynamicCache">~DynamicCache</a> class being the default cache for most models. It allows us to dynamically grow cache size, by saving more and more keys and values as we generate. If for some reason you don’t want to use caches, you can pass <code>use_cache=False</code> into the <code>generate()</code> method.`,He,z,ps="Refer to the table below to see the difference between cache types and choose the one that suits best for your use-case.",Se,Q,rs="<thead><tr><th>Cache Type</th> <th>Memory Efficient</th> <th>Supports torch.compile()</th> <th>Initialization Recommended</th> <th>Latency</th> <th>Long Context Generation</th></tr></thead> <tbody><tr><td>Dynamic Cache</td> <td>No</td> <td>No</td> <td>No</td> <td>Mid</td> <td>No</td></tr> <tr><td>Static Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>No</td></tr> <tr><td>Offloaded Cache</td> <td>Yes</td> <td>No</td> <td>No</td> <td>Low</td> <td>Yes</td></tr> <tr><td>Offloaded Static Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>Yes</td></tr> <tr><td>Quantized Cache</td> <td>Yes</td> <td>No</td> <td>No</td> <td>Low</td> <td>Yes</td></tr> <tr><td>Sliding Window Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>No</td></tr> <tr><td>Sink Cache</td> <td>Yes</td> <td>No</td> <td>Yes</td> <td>Mid</td> <td>Yes</td></tr></tbody>",Ae,F,hs='These cache classes can be set with a <code>cache_implementation</code> argument when generating. To learn about the available options for the cache_implementation flag, please refer to the <a href="./main_classes/text_generation.md#transformers.GenerationConfig">API Documentation</a>. Now, let’s explore each cache type in detail and see how to use them. Note that the below examples are for decoder-only Tranformer-based models. We also support [“Model-Specific Cache”] classes for models such as Mamba or Jamba, keep reading for more details.',Le,Y,De,$,ms=`The key and value cache can occupy a large portion of memory, becoming a <a href="https://huggingface.co/blog/llama31#inference-memory-requirements" rel="nofollow">bottleneck for long-context generation</a>, especially for Large Language Models.
Quantizing the cache when using <code>generate()</code> can significantly reduce memory requirements at the cost of speed.`,Ke,E,ds='KV Cache quantization in <code>transformers</code> is largely inspired by the paper <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">“KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache”</a> and currently supports <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.QuantoQuantizedCache">~QuantoQuantizedCache</a> and <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.HQQQuantizedCache">~HQQQuantizedCache</a> classes. For more information on the inner workings see the paper.',Pe,q,us=`To enable quantization of the key-value cache, one needs to indicate <code>cache_implementation=&quot;quantized&quot;</code> in the <code>generation_config</code>.
Quantization related arguments should be passed to the <code>generation_config</code> either as a <code>dict</code> or an instance of a <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.QuantizedCacheConfig">~QuantizedCacheConfig</a> class.
One has to indicate which quantization backend to use in the <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.QuantizedCacheConfig">~QuantizedCacheConfig</a>, the default is <code>quanto</code>.`,Oe,C,et,H,tt,S,st,A,Ms=`Similarly to KV cache quantization, <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.OffloadedCache">~OffloadedCache</a> strategy aims to reduce GPU VRAM usage.
It does so by moving the KV cache for most layers to the CPU.
As the model’s <code>forward()</code> method iterates over the layers, this strategy maintains the current layer cache on the GPU.
At the same time it asynchronously prefetches the next layer cache as well as sending the previous layer cache back to the CPU.
Unlike KV cache quantization, this strategy always produces the same result as the default KV cache implementation.
Thus, it can serve as a drop-in replacement or a fallback for it.`,at,L,ys=`Depending on your model and the characteristics of your generation task (size of context, number of generated tokens, number of beams, etc.)
you may notice a small degradation in generation throughput compared to the default KV cache implementation.`,nt,D,gs=`To enable KV cache offloading, pass <code>cache_implementation=&quot;offloaded&quot;</code> in the <code>generation_config</code> or directly to the <code>generate()</code> call.
Use <code>cache_implementation=&quot;offloaded_static&quot;</code> for an offloaded static cache (see also <a href="#offloaded-static-cache">Offloaded Static Cache</a> below).`,lt,K,ot,I,it,P,js="The example below shows how KV cache offloading can be used as a fallback strategy.",ct,O,pt,ee,ws="On a GPU with 50 GB of RAM, running this code will print",rt,te,ht,se,Js="before successfully generating 40 beams.",mt,ae,dt,ne,bs=`Since the “DynamicCache” dynamically grows with each generation step, it prevents you from taking advantage of JIT optimizations. The <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.StaticCache">~StaticCache</a> pre-allocates
a specific maximum size for the keys and values, allowing you to generate up to the maximum length without having to modify cache size. Check the below usage example.`,ut,le,fs='For more examples with Static Cache and JIT compilation, take a look at <a href="./llm_optims.md#static-kv-cache-and-torchcompile">StaticCache &amp; torchcompile</a>',Mt,oe,yt,ie,gt,ce,Ts=`Like <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.OffloadedCache">~OffloadedCache</a> exists for offloading a “DynamicCache”, there is also an offloaded static cache. It fully supports
JIT optimizations. Just pass <code>cache_implementation=&quot;offloaded_static&quot;</code> in the <code>generation_config</code> or directly to the <code>generate()</code> call.
This will use the <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.OffloadedStaticCache">~OffloadedStaticCache</a> implementation instead.`,jt,pe,wt,re,Jt,he,Us="As the name suggests, this cache type implements a sliding window over previous keys and values, retaining only the last <code>sliding_window</code> tokens. It should be used with models like Mistral that support sliding window attention. Additionally, similar to Static Cache, this one is JIT-friendly and can be used with the same compile tecniques as Static Cache.",bt,me,ks="Note that you can use this cache only for models that support sliding window, e.g. Mistral models.",ft,de,Tt,ue,Ut,Me,Cs='Sink Cache was introduced in <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">“Efficient Streaming Language Models with Attention Sinks”</a>. It allows you to generate long sequences of text (“infinite length” according to the paper) without any fine-tuning. That is achieved by smart handling of previous keys and values, specifically it retains a few initial tokens from the sequence, called “sink tokens”. This is based on the observation that these initial tokens attract a significant portion of attention scores during the generation process. Tokens that come after “sink tokens” are discarded on a sliding windowed basis, keeping only the latest <code>window_size</code> tokens. By keeping these initial tokens as “attention sinks,” the model maintains stable performance even when dealing with very long texts, thus discarding most of the previous knowledge.',kt,ye,Is="Unlike other cache classes, this one can’t be used directly by indicating a <code>cache_implementation</code>. You have to initialize the Cache before calling on <code>generate()</code> as follows.",Ct,ge,It,je,Wt,we,Ws='The <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.EncoderDecoderCache">~EncoderDecoderCache</a> is a wrapper designed to handle the caching needs of encoder-decoder models. This cache type is specifically built to manage both self-attention and cross-attention caches, ensuring storage and retrieval of past key/values required for these complex models. Cool thing about Encoder-Decoder Cache is that you can set different cache types for the encoder and for the decoder, depending on your use case. Currently this cache is only supported in <a href="./model_doc/whisper.md">Whisper</a> models but we will be adding more models soon.',vt,Je,vs="In terms of usage, there is nothing special to be done and calling <code>generate()</code> or <code>forward()</code> will handle everything for you.",Zt,be,_t,fe,Zs='Some models require storing previous keys, values, or states in a specific way, and the above cache classes cannot be used. For such cases, we have several specialized cache classes that are designed for specific models. These models only accept their own dedicated cache classes and do not support using any other cache types. Some examples include <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.HybridCache">~HybridCache</a> for <a href="./model_doc/gemma2.md">Gemma2</a> series models or <a href="/docs/transformers/pr_30674/en/internal/generation_utils#transformers.MambaCache">~MambaCache</a> for <a href="./model_doc/mamba.md">Mamba</a> architecture models.',Gt,Te,Xt,Ue,_s="We have seen how to use each of the cache types when generating. What if you want to use cache in iterative generation setting, for example in applications like chatbots, where interactions involve multiple turns and continuous back-and-forth exchanges. Iterative generation with cache allows these systems to handle ongoing conversations effectively without reprocessing the entire context at each step. But there are some tips that you should know before you start implementing:",Rt,ke,Gs='The general format when doing iterative generation is as below. First you have to initialize an empty cache of the type you want, and you can start feeding in new prompts iteratively. Keeping track of dialogues history and formatting can be done with chat templates, read more on that in <a href="./chat_templating.md">chat_templating</a>',Bt,Ce,Xs="In case you are using Sink Cache, you have to crop your inputs to that maximum length because Sink Cache can generate text longer than its maximum window size, but it expects the first input to not exceed the maximum cache length.",Nt,Ie,Vt,We,xt,ve,Rs="Sometimes you would want to fist fill-in cache object with key/values for certain prefix prompt and re-use it several times to generate different sequences from it. We are working hard on adding this feature to 🤗 Transformers and will update this section soon.",zt,Ze,Qt,Ne,Ft;return W=new w({props:{title:"Best Practices for Generation with Cache",local:"best-practices-for-generation-with-cache",headingTag:"h1"}}),_=new w({props:{title:"What is Cache and why we should care?",local:"what-is-cache-and-why-we-should-care",headingTag:"h2"}}),B=new w({props:{title:"Under the Hood: How Cache Object Works in Attention Mechanism",local:"under-the-hood-how-cache-object-works-in-attention-mechanism",headingTag:"h3"}}),k=new Dt({props:{warning:!0,$$slots:{default:[Es]},$$scope:{ctx:U}}}),N=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name.&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = inputs.input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_position = torch.arange(inputs.input_ids.shape[<span class="hljs-number">1</span>], dtype=torch.int64, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>max_new_tokens = <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_new_tokens):
<span class="hljs-meta">... </span>    outputs = model(**inputs, cache_position=cache_position, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)     
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Greedily sample one next token</span>
<span class="hljs-meta">... </span>    next_token_ids = outputs.logits[:, -<span class="hljs-number">1</span>:].argmax(-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    generated_ids = torch.cat([generated_ids, next_token_ids], dim=-<span class="hljs-number">1</span>)   
...
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare inputs for the next generation step by leaaving unprocessed tokens, in our case we have only one new token</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># and expanding attn mask for the new token, as explained above</span>
<span class="hljs-meta">... </span>    attention_mask = inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>]
<span class="hljs-meta">... </span>    attention_mask = torch.cat([attention_mask, attention_mask.new_ones((attention_mask.shape[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>))], dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    inputs = {<span class="hljs-string">&quot;input_ids&quot;</span>: next_token_ids, <span class="hljs-string">&quot;attention_mask&quot;</span>: attention_mask}
<span class="hljs-meta">... </span>    cache_position = cache_position[-<span class="hljs-number">1</span>:] + <span class="hljs-number">1</span> <span class="hljs-comment"># add one more position for the next token</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;[INST] Hello, what&#x27;s your name. [/INST]  Hello! My name is LLaMA,&quot;</span>`,wrap:!1}}),V=new w({props:{title:"Generate with Cache",local:"generate-with-cache",headingTag:"h2"}}),Y=new w({props:{title:"Quantized Cache",local:"quantized-cache",headingTag:"h3"}}),C=new Dt({props:{warning:!0,$$slots:{default:[qs]},$$scope:{ctx:U}}}),H=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTNBMCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySSUyMGxpa2UlMjByb2NrJTIwbXVzaWMlMjBiZWNhdXNlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJxdWFudGl6ZWQlMjIlMkMlMjBjYWNoZV9jb25maWclM0QlN0IlMjJuYml0cyUyMiUzQSUyMDQlMkMlMjAlMjJiYWNrZW5kJTIyJTNBJTIwJTIycXVhbnRvJTIyJTdEKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I like rock music because&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;quantized&quot;</span>, cache_config={<span class="hljs-string">&quot;nbits&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;backend&quot;</span>: <span class="hljs-string">&quot;quanto&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. It&#x27;</span>s a great way to express myself <span class="hljs-keyword">and</span> rel

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. I like to listen to it when I&#x27;</span>m feeling`,wrap:!1}}),S=new w({props:{title:"Offloaded Cache",local:"offloaded-cache",headingTag:"h2"}}),K=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBY2twdCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChja3B0KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNrcHQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElM0EwJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJGdW4lMjBmYWN0JTNBJTIwVGhlJTIwc2hvcnRlc3QlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjMlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMm9mZmxvYWRlZCUyMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Fun fact: The shortest&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">23</span>, cache_implementation=<span class="hljs-string">&quot;offloaded&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Fun fact: The shortest war <span class="hljs-keyword">in</span> history was between Britain <span class="hljs-keyword">and</span> Zanzibar on August <span class="hljs-number">27</span>, <span class="hljs-number">1896.</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">23</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Fun fact: The shortest war <span class="hljs-keyword">in</span> history was between Britain <span class="hljs-keyword">and</span> Zanzibar on August <span class="hljs-number">27</span>, <span class="hljs-number">1896.</span>`,wrap:!1}}),I=new Dt({props:{warning:!0,$$slots:{default:[Hs]},$$scope:{ctx:U}}}),O=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">resilient_generate</span>(<span class="hljs-params">model, *args, **kwargs</span>):
<span class="hljs-meta">... </span>    oom = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> model.generate(*args, **kwargs)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> torch.cuda.OutOfMemoryError <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(e)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;retrying with cache_implementation=&#x27;offloaded&#x27;&quot;</span>)
<span class="hljs-meta">... </span>        oom = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> oom:
<span class="hljs-meta">... </span>        torch.cuda.empty_cache()
<span class="hljs-meta">... </span>        kwargs[<span class="hljs-string">&quot;cache_implementation&quot;</span>] = <span class="hljs-string">&quot;offloaded&quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> model.generate(*args, **kwargs)
...
...
<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;okay &quot;</span>*<span class="hljs-number">1000</span> + <span class="hljs-string">&quot;Fun fact: The most&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
<span class="hljs-meta">&gt;&gt;&gt; </span>beams = { <span class="hljs-string">&quot;num_beams&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;num_beam_groups&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;diversity_penalty&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">23</span>, <span class="hljs-string">&quot;early_stopping&quot;</span>: <span class="hljs-literal">True</span>, }
<span class="hljs-meta">&gt;&gt;&gt; </span>out = resilient_generate(model, **inputs, **beams)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = tokenizer.batch_decode(out[:,-<span class="hljs-number">28</span>:], skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),te=new T({props:{code:"Q1VEQSUyMG91dCUyMG9mJTIwbWVtb3J5LiUyMFRyaWVkJTIwdG8lMjBhbGxvY2F0ZSUyMDQuODMlMjBHaUIuJTIwR1BVJTBBcmV0cnlpbmclMjB3aXRoJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0Qnb2ZmbG9hZGVkJw==",highlighted:`CUDA <span class="hljs-keyword">out</span> <span class="hljs-keyword">of</span> memory. Tried <span class="hljs-keyword">to</span> allocate <span class="hljs-number">4.83</span> GiB. GPU
retrying <span class="hljs-keyword">with</span> cache_implementation=<span class="hljs-string">&#x27;offloaded&#x27;</span>`,wrap:!1}}),ae=new w({props:{title:"Static Cache",local:"static-cache",headingTag:"h3"}}),oe=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBuYW1lJTIwaXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwc2ltcGx5JTIwcGFzcyUyMHRoZSUyMGNhY2hlJTIwaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIlMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># simply pass the cache implementation=&quot;static&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hello, my name is [Your Name], and I am a [Your Profession] with [Number of Years] of&quot;</span>`,wrap:!1}}),ie=new w({props:{title:"Offloaded Static Cache",local:"offloaded-static-cache",headingTag:"h2"}}),pe=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBuYW1lJTIwaXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwc2ltcGx5JTIwcGFzcyUyMHRoZSUyMGNhY2hlJTIwaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIlMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyb2ZmbG9hZGVkX3N0YXRpYyUyMiklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># simply pass the cache implementation=&quot;static&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;offloaded_static&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hello, my name is [Your Name], and I am a [Your Profession] with [Number of Years] of&quot;</span>`,wrap:!1}}),re=new w({props:{title:"Sliding Window Cache",local:"sliding-window-cache",headingTag:"h3"}}),de=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwU2lua0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUzQTAlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlllc3RlcmRheSUyMEklMjB3YXMlMjBvbiUyMGElMjByb2NrJTIwY29uY2VydCUyMGFuZC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwY2FuJTIwYmUlMjB1c2VkJTIwYnklMjBwYXNzaW5nJTIwaW4lMjBjYWNoZSUyMGltcGxlbWVudGF0aW9uJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMzAlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMnNsaWRpbmdfd2luZG93JTIyKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Yesterday I was on a rock concert and.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># can be used by passing in cache implementation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">30</span>, cache_implementation=<span class="hljs-string">&quot;sliding_window&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Yesterday I was on a rock concert and. I was so excited to see my favorite band. I was so excited that I was jumping up and down and screaming. I was so excited that I&quot;</span>`,wrap:!1}}),ue=new w({props:{title:"Sink Cache",local:"sink-cache",headingTag:"h3"}}),ge=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwU2lua0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTNBMCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBzdG9yeSUyMGFib3V0JTIwdW5pY29ybnMlMkMlMjBmYWlyaWVzJTIwYW5kJTIwbWFnaWMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMGdldCUyMG91ciUyMGNhY2hlJTJDJTIwc3BlY2lmeSUyMG51bWJlciUyMG9mJTIwc2luayUyMHRva2VucyUyMGFuZCUyMHdpbmRvdyUyMHNpemUlMEElMjMlMjBOb3RlJTIwdGhhdCUyMHdpbmRvdyUyMHNpemUlMjBhbHJlYWR5JTIwaW5jbHVkZXMlMjBzaW5rJTIwdG9rZW5zJTJDJTIwc28lMjBoYXMlMjB0byUyMGJlJTIwbGFyZ2VyJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU2lua0NhY2hlKHdpbmRvd19sZW5ndGglM0QyNTYlMkMlMjBudW1fc2lua190b2tlbnMlM0Q0KSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;This is a long story about unicorns, fairies and magic.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get our cache, specify number of sink tokens and window size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that window size already includes sink tokens, so has to be larger</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">30</span>, past_key_values=past_key_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;This is a long story about unicorns, fairies and magic. It is a fantasy world where unicorns and fairies live together in harmony. The story follows a young girl named Lily&quot;</span>`,wrap:!1}}),je=new w({props:{title:"Encoder-Decoder Cache",local:"encoder-decoder-cache",headingTag:"h3"}}),be=new w({props:{title:"Model-specific Cache Classes",local:"model-specific-cache-classes",headingTag:"h3"}}),Te=new w({props:{title:"Iterative Generation with Cache",local:"iterative-generation-with-cache",headingTag:"h2"}}),Ie=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer,AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.cache_utils <span class="hljs-keyword">import</span> (
<span class="hljs-meta">&gt;&gt;&gt; </span>    DynamicCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    SinkCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    StaticCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    SlidingWindowCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    QuantoQuantizedCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    QuantizedCacheConfig,
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&#x27;auto&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>user_prompts = [<span class="hljs-string">&quot;Hello, what&#x27;s your name?&quot;</span>, <span class="hljs-string">&quot;Btw, yesterday I was on a rock concert.&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>max_cache_length = past_key_values.get_max_length()

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> user_prompts:
<span class="hljs-meta">... </span>    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt})
<span class="hljs-meta">... </span>    inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(model.device)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(past_key_values, SinkCache):
<span class="hljs-meta">... </span>        inputs = {k: v[:, -max_cache_length:] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">... </span>
<span class="hljs-meta">... </span>    input_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    
<span class="hljs-meta">... </span>    outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">256</span>, past_key_values=past_key_values)
<span class="hljs-meta">... </span>    completion = tokenizer.decode(outputs[<span class="hljs-number">0</span>, input_length: ], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: completion})

<span class="hljs-built_in">print</span>(messages)
[{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name?&quot;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot; Hello! My name is LLaMA, I&#x27;m a large language model trained by a team of researcher at Meta AI. 😊&quot;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Btw, yesterday I was on a rock concert.&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27; Oh, cool! That sounds like a lot of fun! 🎉 Did you enjoy the concert? What was the band like? 🤔&#x27;</span>}]`,wrap:!1}}),We=new w({props:{title:"Re-use Cache to continue generation",local:"re-use-cache-to-continue-generation",headingTag:"h2"}}),Ze=new $s({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/kv_cache.md"}}),{c(){p=o("meta"),J=n(),y=o("p"),f=n(),r(W.$$.fragment),Ve=n(),v=o("p"),v.textContent=Pt,xe=n(),Z=o("p"),Z.innerHTML=Ot,ze=n(),r(_.$$.fragment),Qe=n(),G=o("p"),G.textContent=es,Fe=n(),X=o("p"),X.textContent=ts,Ye=n(),R=o("p"),R.textContent=ss,$e=n(),g=o("details"),_e=o("summary"),_e.innerHTML=as,Yt=n(),r(B.$$.fragment),$t=n(),Ge=o("p"),Ge.textContent=ns,Et=n(),Xe=o("p"),Xe.innerHTML=ls,qt=n(),Re=o("p"),Re.innerHTML=os,Ht=n(),r(k.$$.fragment),St=n(),Be=o("p"),Be.textContent=is,At=n(),r(N.$$.fragment),Ee=n(),r(V.$$.fragment),qe=n(),x=o("p"),x.innerHTML=cs,He=n(),z=o("p"),z.textContent=ps,Se=n(),Q=o("table"),Q.innerHTML=rs,Ae=n(),F=o("p"),F.innerHTML=hs,Le=n(),r(Y.$$.fragment),De=n(),$=o("p"),$.innerHTML=ms,Ke=n(),E=o("p"),E.innerHTML=ds,Pe=n(),q=o("p"),q.innerHTML=us,Oe=n(),r(C.$$.fragment),et=n(),r(H.$$.fragment),tt=n(),r(S.$$.fragment),st=n(),A=o("p"),A.innerHTML=Ms,at=n(),L=o("p"),L.textContent=ys,nt=n(),D=o("p"),D.innerHTML=gs,lt=n(),r(K.$$.fragment),ot=n(),r(I.$$.fragment),it=n(),P=o("p"),P.textContent=js,ct=n(),r(O.$$.fragment),pt=n(),ee=o("p"),ee.textContent=ws,rt=n(),r(te.$$.fragment),ht=n(),se=o("p"),se.textContent=Js,mt=n(),r(ae.$$.fragment),dt=n(),ne=o("p"),ne.innerHTML=bs,ut=n(),le=o("p"),le.innerHTML=fs,Mt=n(),r(oe.$$.fragment),yt=n(),r(ie.$$.fragment),gt=n(),ce=o("p"),ce.innerHTML=Ts,jt=n(),r(pe.$$.fragment),wt=n(),r(re.$$.fragment),Jt=n(),he=o("p"),he.innerHTML=Us,bt=n(),me=o("p"),me.textContent=ks,ft=n(),r(de.$$.fragment),Tt=n(),r(ue.$$.fragment),Ut=n(),Me=o("p"),Me.innerHTML=Cs,kt=n(),ye=o("p"),ye.innerHTML=Is,Ct=n(),r(ge.$$.fragment),It=n(),r(je.$$.fragment),Wt=n(),we=o("p"),we.innerHTML=Ws,vt=n(),Je=o("p"),Je.innerHTML=vs,Zt=n(),r(be.$$.fragment),_t=n(),fe=o("p"),fe.innerHTML=Zs,Gt=n(),r(Te.$$.fragment),Xt=n(),Ue=o("p"),Ue.textContent=_s,Rt=n(),ke=o("p"),ke.innerHTML=Gs,Bt=n(),Ce=o("p"),Ce.textContent=Xs,Nt=n(),r(Ie.$$.fragment),Vt=n(),r(We.$$.fragment),xt=n(),ve=o("p"),ve.textContent=Rs,zt=n(),r(Ze.$$.fragment),Qt=n(),Ne=o("p"),this.h()},l(e){const t=Ys("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(s),J=l(e),y=i(e,"P",{}),Lt(y).forEach(s),f=l(e),h(W.$$.fragment,e),Ve=l(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-ivdsz6"&&(v.textContent=Pt),xe=l(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-ev2dx"&&(Z.innerHTML=Ot),ze=l(e),h(_.$$.fragment,e),Qe=l(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-pgg2dh"&&(G.textContent=es),Fe=l(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1pcidqj"&&(X.textContent=ts),Ye=l(e),R=i(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1m78q9l"&&(R.textContent=ss),$e=l(e),g=i(e,"DETAILS",{});var j=Lt(g);_e=i(j,"SUMMARY",{"data-svelte-h":!0}),c(_e)!=="svelte-8dl4q2"&&(_e.innerHTML=as),Yt=l(j),h(B.$$.fragment,j),$t=l(j),Ge=i(j,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-1e25at2"&&(Ge.textContent=ns),Et=l(j),Xe=i(j,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-1l5g8w7"&&(Xe.innerHTML=ls),qt=l(j),Re=i(j,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-8mjlg7"&&(Re.innerHTML=os),Ht=l(j),h(k.$$.fragment,j),St=l(j),Be=i(j,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-181iwu3"&&(Be.textContent=is),At=l(j),h(N.$$.fragment,j),j.forEach(s),Ee=l(e),h(V.$$.fragment,e),qe=l(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1gghc0n"&&(x.innerHTML=cs),He=l(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-14tr67y"&&(z.textContent=ps),Se=l(e),Q=i(e,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-yhqrld"&&(Q.innerHTML=rs),Ae=l(e),F=i(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1po4v5x"&&(F.innerHTML=hs),Le=l(e),h(Y.$$.fragment,e),De=l(e),$=i(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1yajrsk"&&($.innerHTML=ms),Ke=l(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1am08th"&&(E.innerHTML=ds),Pe=l(e),q=i(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1wyyrxc"&&(q.innerHTML=us),Oe=l(e),h(C.$$.fragment,e),et=l(e),h(H.$$.fragment,e),tt=l(e),h(S.$$.fragment,e),st=l(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-tz00sa"&&(A.innerHTML=Ms),at=l(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1x4pr6r"&&(L.textContent=ys),nt=l(e),D=i(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-6aujat"&&(D.innerHTML=gs),lt=l(e),h(K.$$.fragment,e),ot=l(e),h(I.$$.fragment,e),it=l(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-f3m4wg"&&(P.textContent=js),ct=l(e),h(O.$$.fragment,e),pt=l(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-opu10i"&&(ee.textContent=ws),rt=l(e),h(te.$$.fragment,e),ht=l(e),se=i(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-83p2wm"&&(se.textContent=Js),mt=l(e),h(ae.$$.fragment,e),dt=l(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1fuxc6s"&&(ne.innerHTML=bs),ut=l(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1ihym5y"&&(le.innerHTML=fs),Mt=l(e),h(oe.$$.fragment,e),yt=l(e),h(ie.$$.fragment,e),gt=l(e),ce=i(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-114fjpt"&&(ce.innerHTML=Ts),jt=l(e),h(pe.$$.fragment,e),wt=l(e),h(re.$$.fragment,e),Jt=l(e),he=i(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-krlgtc"&&(he.innerHTML=Us),bt=l(e),me=i(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-gmo390"&&(me.textContent=ks),ft=l(e),h(de.$$.fragment,e),Tt=l(e),h(ue.$$.fragment,e),Ut=l(e),Me=i(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-128onc7"&&(Me.innerHTML=Cs),kt=l(e),ye=i(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1vy8lmv"&&(ye.innerHTML=Is),Ct=l(e),h(ge.$$.fragment,e),It=l(e),h(je.$$.fragment,e),Wt=l(e),we=i(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-xy34h7"&&(we.innerHTML=Ws),vt=l(e),Je=i(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-159fa3b"&&(Je.innerHTML=vs),Zt=l(e),h(be.$$.fragment,e),_t=l(e),fe=i(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1urmgtq"&&(fe.innerHTML=Zs),Gt=l(e),h(Te.$$.fragment,e),Xt=l(e),Ue=i(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-au9ho2"&&(Ue.textContent=_s),Rt=l(e),ke=i(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-1lko7wn"&&(ke.innerHTML=Gs),Bt=l(e),Ce=i(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-g93psr"&&(Ce.textContent=Xs),Nt=l(e),h(Ie.$$.fragment,e),Vt=l(e),h(We.$$.fragment,e),xt=l(e),ve=i(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-47ynnt"&&(ve.textContent=Rs),zt=l(e),h(Ze.$$.fragment,e),Qt=l(e),Ne=i(e,"P",{}),Lt(Ne).forEach(s),this.h()},h(){Vs(p,"name","hf:doc:metadata"),Vs(p,"content",As)},m(e,t){b(document.head,p),a(e,J,t),a(e,y,t),a(e,f,t),m(W,e,t),a(e,Ve,t),a(e,v,t),a(e,xe,t),a(e,Z,t),a(e,ze,t),m(_,e,t),a(e,Qe,t),a(e,G,t),a(e,Fe,t),a(e,X,t),a(e,Ye,t),a(e,R,t),a(e,$e,t),a(e,g,t),b(g,_e),b(g,Yt),m(B,g,null),b(g,$t),b(g,Ge),b(g,Et),b(g,Xe),b(g,qt),b(g,Re),b(g,Ht),m(k,g,null),b(g,St),b(g,Be),b(g,At),m(N,g,null),a(e,Ee,t),m(V,e,t),a(e,qe,t),a(e,x,t),a(e,He,t),a(e,z,t),a(e,Se,t),a(e,Q,t),a(e,Ae,t),a(e,F,t),a(e,Le,t),m(Y,e,t),a(e,De,t),a(e,$,t),a(e,Ke,t),a(e,E,t),a(e,Pe,t),a(e,q,t),a(e,Oe,t),m(C,e,t),a(e,et,t),m(H,e,t),a(e,tt,t),m(S,e,t),a(e,st,t),a(e,A,t),a(e,at,t),a(e,L,t),a(e,nt,t),a(e,D,t),a(e,lt,t),m(K,e,t),a(e,ot,t),m(I,e,t),a(e,it,t),a(e,P,t),a(e,ct,t),m(O,e,t),a(e,pt,t),a(e,ee,t),a(e,rt,t),m(te,e,t),a(e,ht,t),a(e,se,t),a(e,mt,t),m(ae,e,t),a(e,dt,t),a(e,ne,t),a(e,ut,t),a(e,le,t),a(e,Mt,t),m(oe,e,t),a(e,yt,t),m(ie,e,t),a(e,gt,t),a(e,ce,t),a(e,jt,t),m(pe,e,t),a(e,wt,t),m(re,e,t),a(e,Jt,t),a(e,he,t),a(e,bt,t),a(e,me,t),a(e,ft,t),m(de,e,t),a(e,Tt,t),m(ue,e,t),a(e,Ut,t),a(e,Me,t),a(e,kt,t),a(e,ye,t),a(e,Ct,t),m(ge,e,t),a(e,It,t),m(je,e,t),a(e,Wt,t),a(e,we,t),a(e,vt,t),a(e,Je,t),a(e,Zt,t),m(be,e,t),a(e,_t,t),a(e,fe,t),a(e,Gt,t),m(Te,e,t),a(e,Xt,t),a(e,Ue,t),a(e,Rt,t),a(e,ke,t),a(e,Bt,t),a(e,Ce,t),a(e,Nt,t),m(Ie,e,t),a(e,Vt,t),m(We,e,t),a(e,xt,t),a(e,ve,t),a(e,zt,t),m(Ze,e,t),a(e,Qt,t),a(e,Ne,t),Ft=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),k.$set(j);const Bs={};t&2&&(Bs.$$scope={dirty:t,ctx:e}),C.$set(Bs);const Ns={};t&2&&(Ns.$$scope={dirty:t,ctx:e}),I.$set(Ns)},i(e){Ft||(d(W.$$.fragment,e),d(_.$$.fragment,e),d(B.$$.fragment,e),d(k.$$.fragment,e),d(N.$$.fragment,e),d(V.$$.fragment,e),d(Y.$$.fragment,e),d(C.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(K.$$.fragment,e),d(I.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(ge.$$.fragment,e),d(je.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d(Ie.$$.fragment,e),d(We.$$.fragment,e),d(Ze.$$.fragment,e),Ft=!0)},o(e){u(W.$$.fragment,e),u(_.$$.fragment,e),u(B.$$.fragment,e),u(k.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(C.$$.fragment,e),u(H.$$.fragment,e),u(S.$$.fragment,e),u(K.$$.fragment,e),u(I.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(je.$$.fragment,e),u(be.$$.fragment,e),u(Te.$$.fragment,e),u(Ie.$$.fragment,e),u(We.$$.fragment,e),u(Ze.$$.fragment,e),Ft=!1},d(e){e&&(s(J),s(y),s(f),s(Ve),s(v),s(xe),s(Z),s(ze),s(Qe),s(G),s(Fe),s(X),s(Ye),s(R),s($e),s(g),s(Ee),s(qe),s(x),s(He),s(z),s(Se),s(Q),s(Ae),s(F),s(Le),s(De),s($),s(Ke),s(E),s(Pe),s(q),s(Oe),s(et),s(tt),s(st),s(A),s(at),s(L),s(nt),s(D),s(lt),s(ot),s(it),s(P),s(ct),s(pt),s(ee),s(rt),s(ht),s(se),s(mt),s(dt),s(ne),s(ut),s(le),s(Mt),s(yt),s(gt),s(ce),s(jt),s(wt),s(Jt),s(he),s(bt),s(me),s(ft),s(Tt),s(Ut),s(Me),s(kt),s(ye),s(Ct),s(It),s(Wt),s(we),s(vt),s(Je),s(Zt),s(_t),s(fe),s(Gt),s(Xt),s(Ue),s(Rt),s(ke),s(Bt),s(Ce),s(Nt),s(Vt),s(xt),s(ve),s(zt),s(Qt),s(Ne)),s(p),M(W,e),M(_,e),M(B),M(k),M(N),M(V,e),M(Y,e),M(C,e),M(H,e),M(S,e),M(K,e),M(I,e),M(O,e),M(te,e),M(ae,e),M(oe,e),M(ie,e),M(pe,e),M(re,e),M(de,e),M(ue,e),M(ge,e),M(je,e),M(be,e),M(Te,e),M(Ie,e),M(We,e),M(Ze,e)}}}const As='{"title":"Best Practices for Generation with Cache","local":"best-practices-for-generation-with-cache","sections":[{"title":"What is Cache and why we should care?","local":"what-is-cache-and-why-we-should-care","sections":[{"title":"Under the Hood: How Cache Object Works in Attention Mechanism","local":"under-the-hood-how-cache-object-works-in-attention-mechanism","sections":[],"depth":3}],"depth":2},{"title":"Generate with Cache","local":"generate-with-cache","sections":[{"title":"Quantized Cache","local":"quantized-cache","sections":[],"depth":3}],"depth":2},{"title":"Offloaded Cache","local":"offloaded-cache","sections":[{"title":"Static Cache","local":"static-cache","sections":[],"depth":3}],"depth":2},{"title":"Offloaded Static Cache","local":"offloaded-static-cache","sections":[{"title":"Sliding Window Cache","local":"sliding-window-cache","sections":[],"depth":3},{"title":"Sink Cache","local":"sink-cache","sections":[],"depth":3},{"title":"Encoder-Decoder Cache","local":"encoder-decoder-cache","sections":[],"depth":3},{"title":"Model-specific Cache Classes","local":"model-specific-cache-classes","sections":[],"depth":3}],"depth":2},{"title":"Iterative Generation with Cache","local":"iterative-generation-with-cache","sections":[],"depth":2},{"title":"Re-use Cache to continue generation","local":"re-use-cache-to-continue-generation","sections":[],"depth":2}],"depth":1}';function Ls(U){return zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ta extends Qs{constructor(p){super(),Fs(this,p,Ls,Ss,xs,{})}}export{ta as component};
