import{s as Yt,n as Qt,o as Nt}from"../chunks/scheduler.7da89386.js";import{S as Pt,i as zt,g as s,s as i,r as p,A as Dt,h as o,f as l,c as a,j as Bt,u as m,x as r,k as ce,y as Ot,a as n,v as u,d as h,t as d,w as c}from"../chunks/index.20910acc.js";import{C as ue}from"../chunks/CodeBlock.cde23137.js";import{H as f,E as qt}from"../chunks/EditOnGithub.ba36cbd0.js";function Kt(ht){let M,fe,he,Me,g,we,b,dt="Using several Gaudi servers to perform multi-node training can be done easily. This guide shows how to:",_e,T,ct="<li>set up several Gaudi instances</li> <li>set up your computing environment</li> <li>launch a multi-node run</li>",ye,C,ge,U,ft="Two types of configurations are possible:",be,v,Mt="<li>scale-out using Gaudi NICs or Host NICs (on-premises)</li> <li>scale-out using AWS DL1 instances</li>",Te,$,Ce,L,wt='To set up your servers on premises, check out the <a href="https://docs.habana.ai/en/latest/Installation_Guide/Bare_Metal_Fresh_OS.html" rel="nofollow">installation</a> and <a href="https://docs.habana.ai/en/latest/PyTorch/PyTorch_Scaling_Guide/index.html" rel="nofollow">distributed training</a> pages of Habana Gaudi’s documentation.',Ue,x,ve,A,_t="Proceed with the following steps to correctly set up your DL1 instances.",$e,J,Le,H,yt=`To allow all instances to communicate with each other, you need to set up a <em>security group</em> as described by AWS in step 1 of <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa-start.html#efa-start-security" rel="nofollow">this link</a>.
Once this is done, it should look as follows:`,xe,w,gt='<img alt="Rules of the security group" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/habana/multi_node_security_group.png" width="800"/> <em style="color: grey">Security group for multi-node training on AWS DL1 instances</em>',Ae,X,Je,S,bt="When you launch instances from the AWS EC2 console, you can choose the number of nodes to set up.",He,j,Tt=`We recommend using the <a href="https://docs.habana.ai/en/latest/Installation_Guide/Habana_Deep_Learning_AMI.html" rel="nofollow">Habana Deep Learning Base AMI</a> for your AWS DL1 instances.
It is an EFA-enabled AMI so you do not need to install the EFA software (which may be necessary if you use a different AMI, installation instructions <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa-start.html" rel="nofollow">here</a>).`,Xe,Z,Ct="Then, in the <em>Network settings</em>, select the <em>security group</em> you created in the previous step. You also have to select a specific <em>subnet</em> to unlock the <em>Advanced network configuration</em> in which you can enable the <em>Elastic Fabric Adapter</em>.",Se,I,Ut="The last parameter to set is the <em>Placement group</em> in the <em>Advanced details</em>. You can create one if you do not have any. The <em>placement strategy</em> should be set to <em>cluster</em>.",je,W,vt="Here is how it should look:",Ze,_,$t='<img alt="Rules of the security group" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/habana/multi_node_launch_instances.png" width="800"/> <em style="color: grey">Parameters for launching EFA-enabled AWS instances. The important parameters to set are circled in red. For the sake of clarity, not all parameters are represented.</em>',Ie,k,Lt='More information <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa-start.html#efa-start-instances" rel="nofollow">here</a>.',We,E,ke,G,xt="Once your Gaudi instances are ready, you need to:",Ee,R,At='<li>Enable password-less SSH on your instances so that they can communicate with each other. <a href="https://docs.habana.ai/en/latest/AWS_User_Guides/AWS_Distributed_Training_Multiple_DL1/AWS_Distributed_Training_Multiple_DL1.html#running-distributed-training-over-multiple-dl1-instances" rel="nofollow">This explains how to do it</a>.</li> <li>On AWS, to train through EFA, <code>hccl_ofi_wrapper</code> should be installed. <a href="https://docs.habana.ai/en/latest/AWS_User_Guides/AWS_Distributed_Training_Multiple_DL1/AWS_Distributed_Training_Multiple_DL1.html#build-and-store-custom-docker-image-for-training" rel="nofollow">Here is how to do it</a>.</li> <li>On AWS, you need to set the following environment variables (the easiest way is to write a <code>.deepspeed_env</code> file as described <a href="https://huggingface.co/docs/optimum/habana/usage_guides/multi_node_training#environment-variables" rel="nofollow">here</a>):</li>',Ge,V,Jt='<li><code>HCCL_OVER_OFI=1</code></li> <li><code>LD_LIBRARY_PATH=path_to_hccl_ofi_wrapper:/opt/amazon/openmpi/lib:/opt/amazon/efa/lib</code> where <code>path_to_hccl_ofi_wrapper</code> is the path to the <code>hccl_ofi_wrapper</code> folder which you installed in the previous step.</li> <li>(optional) <code>HCCL_SOCKET_IFNAME=my_network_interface</code>. If not set, the first network interface with a name that does not start with <code>lo</code> or <code>docker</code> will be used. More information <a href="https://docs.habana.ai/en/latest/API_Reference_Guides/HCCL_APIs/Using_HCCL.html?highlight=HCCL_SOCKET_IFNAME#hccl-socket-ifname" rel="nofollow">here</a>.</li>',Re,F,Ht=`To make this easier, we provide a Dockerfile <a href="https://github.com/huggingface/optimum-habana/tree/main/examples/multi-node-training" rel="nofollow">here</a>.
You will just have to copy the public key of the leader node in the <code>~/.ssh/authorized_keys</code> file of all other nodes to enable password-less SSH.`,Ve,B,Xt='Then, you need to write a <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">hostfile</a> with the addresses and the numbers of devices of your nodes as follows:',Fe,Y,Be,Q,St="Finally, there are two possible ways to run your training script on several nodes:",Ye,N,jt='<li>With the <a href="https://github.com/huggingface/optimum-habana/blob/main/examples/gaudi_spawn.py" rel="nofollow"><code>gaudi_spawn.py</code></a> script, you can run the following command:</li>',Qe,P,Ne,z,Zt="where <code>--argX</code> is an argument of the script to run.",Pe,y,It='<li>With the <a href="https://huggingface.co/docs/optimum/habana/package_reference/distributed_runner" rel="nofollow"><code>DistributedRunner</code></a>, you can add this code snippet to a script:</li>',ze,D,De,O,Oe,q,Wt='If you need to set environment variables for all nodes, you can specify them in a <a href="https://www.deepspeed.ai/getting-started/#multi-node-environment-variables" rel="nofollow"><code>.deepspeed_env</code></a> file which should be located in the local path you are executing from or in your home directory. The format is the following:',qe,K,Ke,ee,kt='You can find an example for AWS instances <a href="https://github.com/huggingface/optimum-habana/tree/main/examples/multi-node-training/EFA/.deepspeed_env" rel="nofollow">here</a>.',et,te,tt,le,Et='<li>It is strongly recommended to use gradient checkpointing for multi-node runs to get the highest speedups. You can enable it with <code>--gradient_checkpointing</code> in <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">these examples</a> or with <code>gradient_checkpointing=True</code> in your <code>GaudiTrainingArguments</code>.</li> <li>Larger batch sizes should lead to higher speedups.</li> <li>Multi-node inference is not recommended and can provide inconsistent results.</li> <li>On AWS DL1 instances, run your Docker containers with the <code>--privileged</code> flag so that EFA devices are visible.</li>',lt,ne,nt,ie,Gt=`In this example, we fine-tune a pre-trained GPT2-XL model on the <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText dataset</a>.
We are going to use the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples/language-modeling#gpt-2gpt-and-causal-language-modeling" rel="nofollow">causal language modeling example which is given in the Github repository</a>.`,it,ae,Rt="The first step consists in training the model on several nodes with this command:",at,se,st,oe,Vt="Evaluation is not performed in the same command because we do not recommend performing multi-node inference at the moment.",ot,re,Ft=`Once the model is trained, we can evaluate it with the following command.
The argument <code>--model_name_or_path</code> should be equal to the argument <code>--output_dir</code> of the previous command.`,rt,pe,pt,me,mt,de,ut;return g=new f({props:{title:"Multi-node Training",local:"multi-node-training",headingTag:"h1"}}),C=new f({props:{title:"Setting up several Gaudi instances",local:"setting-up-several-gaudi-instances",headingTag:"h2"}}),$=new f({props:{title:"On premises",local:"on-premises",headingTag:"h3"}}),x=new f({props:{title:"AWS DL1 instances",local:"aws-dl1-instances",headingTag:"h3"}}),J=new f({props:{title:"1. Set up an EFA-enabled security group",local:"1-set-up-an-efa-enabled-security-group",headingTag:"h4"}}),X=new f({props:{title:"2. Launching instances",local:"2-launching-instances",headingTag:"h4"}}),E=new f({props:{title:"Launching a Multi-node Run",local:"launching-a-multi-node-run",headingTag:"h2"}}),Y=new ue({props:{code:"",highlighted:`ip_1 <span class="hljs-attribute">slots</span>=8
ip_2 <span class="hljs-attribute">slots</span>=8
<span class="hljs-built_in">..</span>.
ip_n <span class="hljs-attribute">slots</span>=8`,wrap:!1}}),P=new ue({props:{code:"cHl0aG9uJTIwZ2F1ZGlfc3Bhd24ucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWhvc3RmaWxlJTIwcGF0aF90b19teV9ob3N0ZmlsZSUyMC0tdXNlX2RlZXBzcGVlZCUyMCU1QyUwQSUyMCUyMCUyMCUyMHBhdGhfdG9fbXlfc2NyaXB0LnB5JTIwLS1hcmdzMSUyMC0tYXJnczIlMjAuLi4lMjAtLWFyZ3NOJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kZWVwc3BlZWQlMjBwYXRoX3RvX215X2RlZXBzcGVlZF9jb25maWc=",highlighted:`python gaudi_spawn.py \\
    --hostfile path_to_my_hostfile --use_deepspeed \\
    path_to_my_script.py --args1 --args2 ... --argsN \\
    --deepspeed path_to_my_deepspeed_config`,wrap:!1}}),D=new ue({props:{code:"ZnJvbSUyMG9wdGltdW0uaGFiYW5hLmRpc3RyaWJ1dGVkJTIwaW1wb3J0JTIwRGlzdHJpYnV0ZWRSdW5uZXIlMEElMEFkaXN0cmlidXRlZF9ydW5uZXIlMjAlM0QlMjBEaXN0cmlidXRlZFJ1bm5lciglMEElMjAlMjAlMjAlMjBjb21tYW5kX2xpc3QlM0QlNUIlMjJwYXRoX3RvX215X3NjcmlwdC5weSUyMC0tYXJnczElMjAtLWFyZ3MyJTIwLi4uJTIwLS1hcmdzTiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGhvc3RmaWxlJTNEcGF0aF90b19teV9ob3N0ZmlsZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9kZWVwc3BlZWQlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.habana.distributed <span class="hljs-keyword">import</span> DistributedRunner

distributed_runner = DistributedRunner(
    command_list=[<span class="hljs-string">&quot;path_to_my_script.py --args1 --args2 ... --argsN&quot;</span>],
    hostfile=path_to_my_hostfile,
    use_deepspeed=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),O=new f({props:{title:"Environment Variables",local:"environment-variables",headingTag:"h2"}}),K=new ue({props:{code:"ZW52X3ZhcmlhYmxlXzFfbmFtZSUzRHZhbHVlJTBBZW52X3ZhcmlhYmxlXzJfbmFtZSUzRHZhbHVlJTBBLi4u",highlighted:`<span class="hljs-attribute">env_variable_1_name</span>=value
<span class="hljs-attribute">env_variable_2_name</span>=value
<span class="hljs-built_in">..</span>.`,wrap:!1}}),te=new f({props:{title:"Recommendations",local:"recommendations",headingTag:"h2"}}),ne=new f({props:{title:"Example",local:"example",headingTag:"h2"}}),se=new ue({props:{code:"cHl0aG9uJTIwLi4lMkZnYXVkaV9zcGF3bi5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taG9zdGZpbGUlMjBwYXRoX3RvX2hvc3RmaWxlJTIwLS11c2VfZGVlcHNwZWVkJTIwcnVuX2NsbS5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZ3B0Mi14bCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ2F1ZGlfY29uZmlnX25hbWUlMjBIYWJhbmElMkZncHQyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjB3aWtpdGV4dCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9jb25maWdfbmFtZSUyMHdpa2l0ZXh0LTItcmF3LXYxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kb190cmFpbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMCUyRnRtcCUyRmdwdDJfeGxfbXVsdGlfbm9kZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDRlLTA0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLXVzZV9oYWJhbmElMjAlNUMlMEElMjAlMjAlMjAlMjAtLXVzZV9sYXp5X21vZGUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRocm91Z2hwdXRfd2FybXVwX3N0ZXBzJTIwMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGVlcHNwZWVkJTIwcGF0aF90b19kZWVwc3BlZWRfY29uZmln",highlighted:`python ../gaudi_spawn.py \\
    --hostfile path_to_hostfile --use_deepspeed run_clm.py \\
    --model_name_or_path gpt2-xl \\
    --gaudi_config_name Habana/gpt2 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --output_dir /tmp/gpt2_xl_multi_node \\
    --learning_rate 4e-04 \\
    --per_device_train_batch_size 16 \\
    --gradient_checkpointing \\
    --num_train_epochs 1 \\
    --use_habana \\
    --use_lazy_mode \\
    --throughput_warmup_steps 3 \\
    --deepspeed path_to_deepspeed_config`,wrap:!1}}),pe=new ue({props:{code:"cHl0aG9uJTIwcnVuX2NsbS5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwJTJGdG1wJTJGZ3B0Ml94bF9tdWx0aV9ub2RlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1nYXVkaV9jb25maWdfbmFtZSUyMEhhYmFuYSUyRmdwdDIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRvX2V2YWwlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjAlMkZ0bXAlMkZncHQyX3hsX211bHRpX25vZGUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdXNlX2hhYmFuYSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdXNlX2xhenlfbW9kZQ==",highlighted:`python run_clm.py \\
    --model_name_or_path /tmp/gpt2_xl_multi_node \\
    --gaudi_config_name Habana/gpt2 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_eval \\
    --output_dir /tmp/gpt2_xl_multi_node \\
    --per_device_eval_batch_size 8 \\
    --use_habana \\
    --use_lazy_mode`,wrap:!1}}),me=new qt({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/usage_guides/multi_node_training.mdx"}}),{c(){M=s("meta"),fe=i(),he=s("p"),Me=i(),p(g.$$.fragment),we=i(),b=s("p"),b.textContent=dt,_e=i(),T=s("ul"),T.innerHTML=ct,ye=i(),p(C.$$.fragment),ge=i(),U=s("p"),U.textContent=ft,be=i(),v=s("ul"),v.innerHTML=Mt,Te=i(),p($.$$.fragment),Ce=i(),L=s("p"),L.innerHTML=wt,Ue=i(),p(x.$$.fragment),ve=i(),A=s("p"),A.textContent=_t,$e=i(),p(J.$$.fragment),Le=i(),H=s("p"),H.innerHTML=yt,xe=i(),w=s("p"),w.innerHTML=gt,Ae=i(),p(X.$$.fragment),Je=i(),S=s("p"),S.textContent=bt,He=i(),j=s("p"),j.innerHTML=Tt,Xe=i(),Z=s("p"),Z.innerHTML=Ct,Se=i(),I=s("p"),I.innerHTML=Ut,je=i(),W=s("p"),W.textContent=vt,Ze=i(),_=s("p"),_.innerHTML=$t,Ie=i(),k=s("p"),k.innerHTML=Lt,We=i(),p(E.$$.fragment),ke=i(),G=s("p"),G.textContent=xt,Ee=i(),R=s("ol"),R.innerHTML=At,Ge=i(),V=s("ul"),V.innerHTML=Jt,Re=i(),F=s("p"),F.innerHTML=Ht,Ve=i(),B=s("p"),B.innerHTML=Xt,Fe=i(),p(Y.$$.fragment),Be=i(),Q=s("p"),Q.textContent=St,Ye=i(),N=s("ol"),N.innerHTML=jt,Qe=i(),p(P.$$.fragment),Ne=i(),z=s("p"),z.innerHTML=Zt,Pe=i(),y=s("ol"),y.innerHTML=It,ze=i(),p(D.$$.fragment),De=i(),p(O.$$.fragment),Oe=i(),q=s("p"),q.innerHTML=Wt,qe=i(),p(K.$$.fragment),Ke=i(),ee=s("p"),ee.innerHTML=kt,et=i(),p(te.$$.fragment),tt=i(),le=s("ul"),le.innerHTML=Et,lt=i(),p(ne.$$.fragment),nt=i(),ie=s("p"),ie.innerHTML=Gt,it=i(),ae=s("p"),ae.textContent=Rt,at=i(),p(se.$$.fragment),st=i(),oe=s("p"),oe.textContent=Vt,ot=i(),re=s("p"),re.innerHTML=Ft,rt=i(),p(pe.$$.fragment),pt=i(),p(me.$$.fragment),mt=i(),de=s("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(l),fe=a(e),he=o(e,"P",{}),Bt(he).forEach(l),Me=a(e),m(g.$$.fragment,e),we=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-qp9xqj"&&(b.textContent=dt),_e=a(e),T=o(e,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-rop6rm"&&(T.innerHTML=ct),ye=a(e),m(C.$$.fragment,e),ge=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-se31mi"&&(U.textContent=ft),be=a(e),v=o(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-1pscikw"&&(v.innerHTML=Mt),Te=a(e),m($.$$.fragment,e),Ce=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-18nj2e2"&&(L.innerHTML=wt),Ue=a(e),m(x.$$.fragment,e),ve=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-14m84ei"&&(A.textContent=_t),$e=a(e),m(J.$$.fragment,e),Le=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-qelz45"&&(H.innerHTML=yt),xe=a(e),w=o(e,"P",{align:!0,"data-svelte-h":!0}),r(w)!=="svelte-m2xgzf"&&(w.innerHTML=gt),Ae=a(e),m(X.$$.fragment,e),Je=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-y05o67"&&(S.textContent=bt),He=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1pruiwv"&&(j.innerHTML=Tt),Xe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-11ei7i0"&&(Z.innerHTML=Ct),Se=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-10npfah"&&(I.innerHTML=Ut),je=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-mqh90v"&&(W.textContent=vt),Ze=a(e),_=o(e,"P",{align:!0,"data-svelte-h":!0}),r(_)!=="svelte-1rpt0sv"&&(_.innerHTML=$t),Ie=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1nw6w8y"&&(k.innerHTML=Lt),We=a(e),m(E.$$.fragment,e),ke=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-3ctcip"&&(G.textContent=xt),Ee=a(e),R=o(e,"OL",{"data-svelte-h":!0}),r(R)!=="svelte-b1tfty"&&(R.innerHTML=At),Ge=a(e),V=o(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-1n1xpfi"&&(V.innerHTML=Jt),Re=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-70g0as"&&(F.innerHTML=Ht),Ve=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-17iru9e"&&(B.innerHTML=Xt),Fe=a(e),m(Y.$$.fragment,e),Be=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-ce1e0i"&&(Q.textContent=St),Ye=a(e),N=o(e,"OL",{"data-svelte-h":!0}),r(N)!=="svelte-2kg0w5"&&(N.innerHTML=jt),Qe=a(e),m(P.$$.fragment,e),Ne=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-nmkk8f"&&(z.innerHTML=Zt),Pe=a(e),y=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-nk8702"&&(y.innerHTML=It),ze=a(e),m(D.$$.fragment,e),De=a(e),m(O.$$.fragment,e),Oe=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1vzj3zu"&&(q.innerHTML=Wt),qe=a(e),m(K.$$.fragment,e),Ke=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1qg1oma"&&(ee.innerHTML=kt),et=a(e),m(te.$$.fragment,e),tt=a(e),le=o(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-12vfvg0"&&(le.innerHTML=Et),lt=a(e),m(ne.$$.fragment,e),nt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ww31kw"&&(ie.innerHTML=Gt),it=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1y1hqcv"&&(ae.textContent=Rt),at=a(e),m(se.$$.fragment,e),st=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-472z3o"&&(oe.textContent=Vt),ot=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1lr4pmk"&&(re.innerHTML=Ft),rt=a(e),m(pe.$$.fragment,e),pt=a(e),m(me.$$.fragment,e),mt=a(e),de=o(e,"P",{}),Bt(de).forEach(l),this.h()},h(){ce(M,"name","hf:doc:metadata"),ce(M,"content",el),ce(w,"align","center"),ce(_,"align","center"),ce(y,"start","2")},m(e,t){Ot(document.head,M),n(e,fe,t),n(e,he,t),n(e,Me,t),u(g,e,t),n(e,we,t),n(e,b,t),n(e,_e,t),n(e,T,t),n(e,ye,t),u(C,e,t),n(e,ge,t),n(e,U,t),n(e,be,t),n(e,v,t),n(e,Te,t),u($,e,t),n(e,Ce,t),n(e,L,t),n(e,Ue,t),u(x,e,t),n(e,ve,t),n(e,A,t),n(e,$e,t),u(J,e,t),n(e,Le,t),n(e,H,t),n(e,xe,t),n(e,w,t),n(e,Ae,t),u(X,e,t),n(e,Je,t),n(e,S,t),n(e,He,t),n(e,j,t),n(e,Xe,t),n(e,Z,t),n(e,Se,t),n(e,I,t),n(e,je,t),n(e,W,t),n(e,Ze,t),n(e,_,t),n(e,Ie,t),n(e,k,t),n(e,We,t),u(E,e,t),n(e,ke,t),n(e,G,t),n(e,Ee,t),n(e,R,t),n(e,Ge,t),n(e,V,t),n(e,Re,t),n(e,F,t),n(e,Ve,t),n(e,B,t),n(e,Fe,t),u(Y,e,t),n(e,Be,t),n(e,Q,t),n(e,Ye,t),n(e,N,t),n(e,Qe,t),u(P,e,t),n(e,Ne,t),n(e,z,t),n(e,Pe,t),n(e,y,t),n(e,ze,t),u(D,e,t),n(e,De,t),u(O,e,t),n(e,Oe,t),n(e,q,t),n(e,qe,t),u(K,e,t),n(e,Ke,t),n(e,ee,t),n(e,et,t),u(te,e,t),n(e,tt,t),n(e,le,t),n(e,lt,t),u(ne,e,t),n(e,nt,t),n(e,ie,t),n(e,it,t),n(e,ae,t),n(e,at,t),u(se,e,t),n(e,st,t),n(e,oe,t),n(e,ot,t),n(e,re,t),n(e,rt,t),u(pe,e,t),n(e,pt,t),u(me,e,t),n(e,mt,t),n(e,de,t),ut=!0},p:Qt,i(e){ut||(h(g.$$.fragment,e),h(C.$$.fragment,e),h($.$$.fragment,e),h(x.$$.fragment,e),h(J.$$.fragment,e),h(X.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),ut=!0)},o(e){d(g.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(x.$$.fragment,e),d(J.$$.fragment,e),d(X.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(se.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),ut=!1},d(e){e&&(l(fe),l(he),l(Me),l(we),l(b),l(_e),l(T),l(ye),l(ge),l(U),l(be),l(v),l(Te),l(Ce),l(L),l(Ue),l(ve),l(A),l($e),l(Le),l(H),l(xe),l(w),l(Ae),l(Je),l(S),l(He),l(j),l(Xe),l(Z),l(Se),l(I),l(je),l(W),l(Ze),l(_),l(Ie),l(k),l(We),l(ke),l(G),l(Ee),l(R),l(Ge),l(V),l(Re),l(F),l(Ve),l(B),l(Fe),l(Be),l(Q),l(Ye),l(N),l(Qe),l(Ne),l(z),l(Pe),l(y),l(ze),l(De),l(Oe),l(q),l(qe),l(Ke),l(ee),l(et),l(tt),l(le),l(lt),l(nt),l(ie),l(it),l(ae),l(at),l(st),l(oe),l(ot),l(re),l(rt),l(pt),l(mt),l(de)),l(M),c(g,e),c(C,e),c($,e),c(x,e),c(J,e),c(X,e),c(E,e),c(Y,e),c(P,e),c(D,e),c(O,e),c(K,e),c(te,e),c(ne,e),c(se,e),c(pe,e),c(me,e)}}}const el='{"title":"Multi-node Training","local":"multi-node-training","sections":[{"title":"Setting up several Gaudi instances","local":"setting-up-several-gaudi-instances","sections":[{"title":"On premises","local":"on-premises","sections":[],"depth":3},{"title":"AWS DL1 instances","local":"aws-dl1-instances","sections":[{"title":"1. Set up an EFA-enabled security group","local":"1-set-up-an-efa-enabled-security-group","sections":[],"depth":4},{"title":"2. Launching instances","local":"2-launching-instances","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Launching a Multi-node Run","local":"launching-a-multi-node-run","sections":[],"depth":2},{"title":"Environment Variables","local":"environment-variables","sections":[],"depth":2},{"title":"Recommendations","local":"recommendations","sections":[],"depth":2},{"title":"Example","local":"example","sections":[],"depth":2}],"depth":1}';function tl(ht){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends Pt{constructor(M){super(),zt(this,M,tl,Kt,Yt,{})}}export{sl as component};
