import{s as qn,o as Xn,n as A}from"../chunks/scheduler.b108d059.js";import{S as Yn,i as Pn,g as r,s,r as d,A as On,h as u,f as l,c as a,j as Nn,u as M,x as p,k as Qn,y as Dn,a as n,v as m,d as c,t as h,w as y}from"../chunks/index.008de539.js";import{T as C}from"../chunks/Tip.aeb15ab7.js";import{C as U}from"../chunks/CodeBlock.7b00c886.js";import{H as J,E as Kn}from"../chunks/getInferenceSnippets.79dc142e.js";function es(T){let i,w='This example is not intended to be a in-detail example on how to deploy Large Language Models (LLMs) on Azure AI but rather focused on how to build agents with it, this being said, it’s highly recommended to read more about Azure AI deployments in the example <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/examples/deploy-large-language-models" rel="nofollow">“Deploy Large Language Models (LLMs) on Azure AI”</a>.';return{c(){i=r("p"),i.innerHTML=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-19l1ld9"&&(i.innerHTML=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function ts(T){let i,w="Note that you can select any LLM available on the Hugging Face Hub with the “Deploy to AzureML” option enabled, or directly select any of the LLMs available in either the Azure ML or Azure AI Foundry Hub Model Catalog under the “HuggingFace” collection (note that for Azure AI Foundry the Hugging Face Collection will only be available for Hub-based projects).";return{c(){i=r("p"),i.textContent=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-1a5zyti"&&(i.textContent=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function ls(T){let i,w="Note that endpoint names must to be globally unique per region i.e., even if you don’t have any endpoint named that way running under your subscription, if the name is reserved by another Azure customer, then you won’t be able to use the same name. Adding a timestamp or a custom identifier is recommended to prevent running into HTTP 400 validation issues when trying to deploy an endpoint with an already locked / reserved name. Also the endpoint name must be between 3 and 32 characters long.";return{c(){i=r("p"),i.textContent=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-zrbum5"&&(i.textContent=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function ns(T){let i,w="On standard Azure ML deployments you’d need to create the <code>MLClient</code> using the Azure ML Workspace as the <code>workspace_name</code> whereas for Azure AI Foundry, you need to provide the Azure AI Foundry Hub name as the <code>workspace_name</code> instead, and that will deploy the endpoint under the Azure AI Foundry too.";return{c(){i=r("p"),i.innerHTML=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-fg1top"&&(i.innerHTML=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function ss(T){let i,w='Since for some models and inference engines you need to run those on a GPU-accelerated instance, you may need to request a quota increase for some of the supported instances as per the model you want to deploy. Also, keep into consideration that each model comes with a list of all the supported instances, being the recommended one for each tier the lower instance in terms of available VRAM. Read more about quota increase requests for Azure ML at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-manage-quotas?view=azureml-api-2" rel="nofollow">Manage and increase quotas and limits for resources with Azure Machine Learning</a>.';return{c(){i=r("p"),i.innerHTML=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-3styqc"&&(i.innerHTML=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function as(T){let i,w="In Azure AI Foundry the endpoint will only be listed within the “My assets -> Models + endpoints” tab once the deployment is created, not before as in Azure ML where the endpoint is shown even if it doesn’t contain any active or in-progress deployments.";return{c(){i=r("p"),i.textContent=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-13fiegq"&&(i.textContent=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function is(T){let i,w="Note that whilst the Azure AI Endpoint creation is relatively fast, the deployment will take longer since it needs to allocate the resources on Azure so expect it to take ~10-15 minutes, but it could as well take longer depending on the instance provisioning and availability.";return{c(){i=r("p"),i.textContent=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-1q2pvid"&&(i.textContent=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function os(T){let i,w="Alternatively, you can also build the API URL manually as it follows, since the URIs are globally unique per region, meaning that there will only be one endpoint named the same way within the same region:",o,f,b,$,I="Or just retrieve it from either the Azure AI Foundry or the Azure ML Studio.",_;return f=new U({props:{code:"YXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRiU3Qm9zLmdldGVudignRU5EUE9JTlRfTkFNRScpJTdELiU3Qm9zLmdldGVudignTE9DQVRJT04nKSU3RC5pbmZlcmVuY2UubWwuYXp1cmUuY29tJTJGdjElMjI=",highlighted:'api_url = <span class="hljs-string">f&quot;https://<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ENDPOINT_NAME&#x27;</span>)}</span>.<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>.inference.ml.azure.com/v1&quot;</span>',wrap:!1}}),{c(){i=r("p"),i.textContent=w,o=s(),d(f.$$.fragment),b=s(),$=r("p"),$.textContent=I},l(g){i=u(g,"P",{"data-svelte-h":!0}),p(i)!=="svelte-ufs9gh"&&(i.textContent=w),o=a(g),M(f.$$.fragment,g),b=a(g),$=u(g,"P",{"data-svelte-h":!0}),p($)!=="svelte-vz1qru"&&($.textContent=I)},m(g,j){n(g,i,j),n(g,o,j),m(f,g,j),n(g,b,j),n(g,$,j),_=!0},p:A,i(g){_||(c(f.$$.fragment,g),_=!0)},o(g){h(f.$$.fragment,g),_=!1},d(g){g&&(l(i),l(o),l(b),l($)),y(f,g)}}}function rs(T){let i,w='In this case for the sake of simplicity, the tools to be used have been ported from <a href="https://github.com/huggingface/smolagents/blob/main/examples/multiple_tools.py" rel="nofollow">https://github.com/huggingface/smolagents/blob/main/examples/multiple_tools.py</a>, so all the credit goes to the original authors and maintainers of the <code>smolagents</code> GitHub repository. Also only the tools for querying the World Time API and the Wikipedia API have been kept, since those have a generous Free Tier that allows anyone to use those without paying or having to create an account / API token.';return{c(){i=r("p"),i.innerHTML=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-1oj3ydq"&&(i.innerHTML=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function us(T){let i,w='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Microsoft-Azure/tree/main/examples/azure-ai/build-agents-with-smolagents/azure-notebook.ipynb" rel="nofollow">here</a>!';return{c(){i=r("p"),i.innerHTML=w},l(o){i=u(o,"P",{"data-svelte-h":!0}),p(i)!=="svelte-1dgigov"&&(i.innerHTML=w)},m(o,f){n(o,i,f)},p:A,d(o){o&&l(i)}}}function ps(T){let i,w,o,f,b,$,I,_='This example showcases how to build agents with <a href="https://github.com/huggingface/smolagents" rel="nofollow"><code>smolagents</code></a>, leveraging Large Language Models (LLMs) from the Hugging Face Collection in Azure AI Foundry Hub deployed as an Azure ML Managed Online Endpoint.',g,j,rt,H,Nl="TL;DR Smolagents is an open-source Python library designed to make it extremely easy to build and run agents using just a few lines of code. Azure AI Foundry provides a unified platform for enterprise AI operations, model builders, and application development. Azure Machine Learning is a cloud service for accelerating and managing the machine learning (ML) project lifecycle.",ut,pt,dt,G,Ql='This example will specifically deploy <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> from the Hugging Face Hub (or see it on <a href="https://ml.azure.com/models/qwen-qwen2.5-coder-32b-instruct/version/2/catalog/registry/HuggingFace" rel="nofollow">AzureML</a> or on <a href="https://ai.azure.com/explore/models/qwen-qwen2.5-coder-32b-instruct/version/2/registry/HuggingFace" rel="nofollow">Azure AI Foundry</a>) as an Azure ML Managed Online Endpoint on Azure AI Foundry Hub.',Mt,L,ql="Qwen2.5-Coder is the latest series of Code-Specific Qwen large language models (formerly known as CodeQwen), bringing the following improvements upon CodeQwen1.5:",mt,x,Xl="<li>Significantly improvements in code generation, code reasoning and code fixing. Base on the strong Qwen2.5, we scale up the training tokens into 5.5 trillion including source code, text-code grounding, Synthetic data, etc. Qwen2.5-Coder-32B has become the current state-of-the-art open-source codeLLM, with its coding abilities matching those of GPT-4o.</li> <li>A more comprehensive foundation for real-world applications such as Code Agents. Not only enhancing coding capabilities but also maintaining its strengths in mathematics and general competencies.</li> <li>Long-context Support up to 128K tokens.</li>",ct,F,Yl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/build-agents-with-smolagents/qwen2.5-coder-hub.png" alt="Qwen2.5 Coder 32B Instruct on the Hugging Face Hub"/>',ht,S,Pl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/build-agents-with-smolagents/qwen2.5-coder-azure-ai.png" alt="Qwen2.5 Coder 32B Instruct on Azure AI Foundry"/>',yt,N,Ol='For more information, make sure to check <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct/blob/main/README.md" rel="nofollow">their model card on the Hugging Face Hub</a>.',wt,v,ft,Q,gt,q,Dl='To run the following example, you will need to comply with the following pre-requisites, alternatively, you can also read more about those in the <a href="https://learn.microsoft.com/en-us/azure/machine-learning/quickstart-create-resources?view=azureml-api-2" rel="nofollow">Azure Machine Learning Tutorial: Create resources you need to get started</a>.',Tt,X,Kl="<li>An Azure account with an active subscription.</li> <li>The Azure CLI installed and logged in.</li> <li>The Azure Machine Learning extension for the Azure CLI.</li> <li>An Azure Resource Group.</li> <li>A project based on an Azure AI Foundry Hub.</li>",Ut,Y,en='For more information, please go through the steps in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/configure" rel="nofollow">Configure Microsoft Azure for Azure AI</a>.',jt,P,Jt,O,tn='In this example, the <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ml/azure-ai-ml" rel="nofollow">Azure Machine Learning SDK for Python</a> will be used to create the endpoint and the deployment, as well as to invoke the deployed API. Along with it, you will also need to install <code>azure-identity</code> to authenticate with your Azure credentials via Python.',bt,D,$t,K,ln='More information at <a href="https://learn.microsoft.com/en-us/python/api/overview/azure/ai-ml-readme?view=azure-python" rel="nofollow">Azure Machine Learning SDK for Python</a>.',It,ee,nn="Then, for convenience setting the following environment variables is recommended as those will be used along the example for the Azure ML Client, so make sure to update and set those values accordingly as per your Microsoft Azure account and resources.",Ct,te,At,le,sn="Finally, you also need to define both the endpoint and deployment names, as those will be used throughout the example too:",vt,z,zt,ne,Bt,se,Zt,ae,Vt,ie,an="Initially, you need to authenticate into the Azure AI Foundry Hub via Azure ML with the Azure ML Python SDK, which will be later used to deploy <code>Qwen/Qwen2.5-Coder-32B-Instruct</code> as an Azure ML Managed Online Endpoint in your Azure AI Foundry Hub.",Wt,B,Et,oe,Rt,re,kt,ue,on="Before creating the Managed Online Endpoint, you need to build the model URI, which is formatted as it follows <code>azureml://registries/&lt;REGISTRY_NAME&gt;/models/&lt;MODEL_ID&gt;/labels/latest</code> (even if the URI contains <code>azureml</code> it’s the same as in Azure AI Foundry, since the model catalog is shared), that means that the <code>REGISTRY_NAME</code> should be set to “HuggingFace” as you intend to deploy a model from the Hugging Face Collection, and the <code>MODEL_ID</code> won’t be the Hugging Face Hub ID, but rather the ID with hyphen replacements for both backslash (/) and underscores (_) with hyphens (-), and then into lower case, as follows:",_t,pe,Ht,de,rn='Note that you will need to verify in advance that the URI is valid, and that the given Hugging Face Hub Model ID exists on Azure, since Hugging Face is publishing those models into their collection, meaning that some models may be available on the Hugging Face Hub but not yet on the Azure Model Catalog (you can request adding a model following the guide <a href="https://huggingface.co/docs/microsoft-azure/guides/request-model-addition" rel="nofollow">Request a model addition</a>).',Gt,Me,un="Alternatively, you can use the following snippet to verify if a model is available on the Azure Model Catalog programmatically:",Lt,me,xt,ce,pn='Then you can create the Managed Online Endpoint specifying its name (note that the name must be unique per entire region, not only within a single subscription, resource group, workspace, etc., so it’s a nice practice to add some sort of unique name to it in case multi-region deployments are intended) via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlineendpoint?view=azure-python" rel="nofollow">ManagedOnlineEndpoint Python class</a>.',Ft,he,dn='Also note that by default the <code>ManagedOnlineEndpoint</code> will use the <code>key</code> authentication method, meaning that there will be a primary and secondary key that should be sent within the Authentication headers as a Bearer token; but also the <code>aml_token</code> authentication method can be used, read more about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-authenticate-online-endpoint" rel="nofollow">Authenticate clients for online endpoints</a>.',St,ye,Mn='The deployment, created via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlinedeployment?view=azure-python" rel="nofollow">ManagedOnlineDeployment Python class</a>, will define the actual model deployment that will be exposed via the previously created endpoint. The <code>ManagedOnlineDeployment</code> will expect: the <code>model</code> i.e., the previously created URI <code>azureml://registries/HuggingFace/models/qwen-qwen2.5-coder-32b-instruct/labels/latest</code>, the <code>endpoint_name</code>, and the instance requirements being the <code>instance_type</code> and the <code>instance_count</code>.',Nt,we,mn='Every model in the Hugging Face Collection is powered by an efficient inference backend, and each of those can run on a wide variety of instance types (as listed in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/supported-hardware" rel="nofollow">Supported Hardware</a>); in this case, a NVIDIA H100 GPU will be used i.e., <code>Standard_NC40ads_H100_v5</code>.',Qt,Z,qt,fe,Xt,ge,Yt,Te,cn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/build-agents-with-smolagents/azure-ai-endpoint.png" alt="Azure AI Endpoint from Azure AI Foundry"/>',Pt,V,Ot,Ue,Dt,je,hn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/build-agents-with-smolagents/azure-ai-deployment.png" alt="Azure AI Deployment from Azure AI Foundry"/>',Kt,W,el,Je,yn='Once deployed, via either the Azure AI Foundry or the Azure ML Studio you’ll be able to inspect the endpoint details, the real-time logs, how to consume the endpoint, and even use the, still on preview, <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-model-monitoring?view=azureml-api-2" rel="nofollow">monitoring feature</a>.',tl,be,wn='Find more information about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-endpoints-online?view=azureml-api-2#managed-online-endpoints" rel="nofollow">Azure ML Managed Online Endpoints</a>',ll,$e,nl,Ie,fn='Now that the Azure AI Endpoint is running, you can start sending requests to it. Since there are multiple approaches, but the following is just covering the OpenAI Python SDK approach, you should visit e.g. <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/examples/deploy-large-language-models" rel="nofollow">Deploy Large Language Models (LLMs) on Azure AI</a> to see different alternatives.',sl,Ce,gn="So on, the steps to follow for building the agent are going to be:",al,Ae,Tn="<li>Create the OpenAI client with <code>smolagents</code>, connected to the running Azure AI Endpoint via the <code>smolagents.OpenAIServerModel</code> (note that <code>smolagents</code> also exposes the <code>smolagents.AzureOpenAIServerModel</code> but that’s the client for using OpenAI via the Azure, not to connect to Azure AI).</li> <li>Define the set of tools that the agent will have access to i.e., Python functions with the <code>smolagents.tool</code> decorator.</li> <li>Create the <code>smolagents.CodeAgent</code> leveraging the code-LLM deployed on Azure AI, adding the set tools previously defined, so that the agent can use those when appropriate, using a local executor (not recommended if code to be executed is sensible or unidentified).</li>",il,ve,ol,ze,Un="Since every LLM in the Hugging Face catalog is deployed with an inference engine that exposes OpenAI-compatible routes, you can also leverage the OpenAI Python SDK via <code>smolagents</code> to send requests to the deployed Azure ML Endpoint.",rl,Be,ul,Ze,jn="To use the OpenAI Python SDK with Azure ML Managed Online Endpoints, you need to first retrieve:",pl,Ve,Jn="<li><code>api_url</code> with the <code>/v1</code> route (that contains the <code>v1/chat/completions</code> endpoint that the OpenAI Python SDK will send requests to)</li> <li><code>api_key</code> which is the API Key in Azure AI or the primary key in Azure ML (unless a dedicated Azure ML Token is used instead)</li>",dl,We,Ml,E,ml,Ee,bn="Then you can use the OpenAI Python SDK normally, making sure to include the extra header <code>azureml-model-deployment</code> header that contains the Azure AI / ML Deployment name.",cl,Re,$n="The extra header will be provided via the <code>default_headers</code> argument of the OpenAI Python SDK when instantiating the client, to be provided in <code>smolagents</code> via the <code>client_kwargs</code> argument of <code>smolagents.OpenAIServerModel</code>, that will propagate those to the underlying <code>OpenAI</code> client.",hl,ke,yl,_e,wl,He,In="<code>smolagents</code> will be used to build the tools that the agent will leverage, as well as to build the <code>smolagents.CodeAgent</code> itself. The following tools will be defined, using the <code>smolagents.tool</code> decorator, that will prepare the Python functions to be used as tools within the LLM Agent.",fl,Ge,Cn="Note that the function signatures should come with proper typing so as to guide the LLM, as well as a clear function name and, most importantly, well-formatted docstrings indicating what the function does, what are the arguments, what it returns, and what errors can be raised; if applicable.",gl,Le,An="In this case, the tools that will be provided to the agent are the following:",Tl,xe,vn="<li><p>World Time API - <code>get_time_in_timezone</code>: fetches the current time on a given location using the World Time API.</p></li> <li><p>Wikipedia API - <code>search_wikipedia</code>: fetches a summary of a Wikipedia entry using the Wikipedia API.</p></li>",Ul,R,jl,Fe,Jl,Se,bl,Ne,$l,Qe,Il,qe,Cl,Xe,Al,Ye,zn="Since in this case the deployed LLM on Azure AI is a coding-specific LLM, the agent will be created with <code>smolagents.CodeAgent</code> that adds the relevant prompt and parsing functionality, so as to interpret the LLM outputs as code. Alternatively, one could also use <code>smolagents.ToolCallingAgent</code> which is a tool calling agent, meaning that the given LLM should have tool calling capabilities.",vl,Pe,Bn="Then, the <code>smolagents.CodeAgent</code> expects both the <code>model</code> and the set of <code>tools</code> that the model has access to, and then via the <code>run</code> method, you can leverage all the potential of the agent in an automatic way, without manual intervention; so that the agent will use the given tools if needed, to answer or comply with your initial request.",zl,Oe,Bl,De,Zl,Ke,Vl,et,Wl,tt,Zn="Once you are done using the Azure AI Endpoint / Deployment, you can delete the resources as it follows, meaning that you will stop paying for the instance on which the model is running and all the attached costs will be stopped.",El,lt,Rl,nt,kl,st,Vn="Throughout this example you learnt how to deploy an Azure ML Managed Online Endpoint on an Azure AI Foundry Hub-based project running an open model from the Hugging Face Collection in the Azure AI Foundry Hub / Azure ML Model Catalog, leverage it to build agents with <code>smolagents</code>, and finally, how to stop and release the resources.",_l,at,Wn='If you have any doubt, issue or question about this example, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue</a> and we’ll do our best to help!',Hl,Gl,Ll,k,xl,it,Fl,ot,Sl;return b=new J({props:{title:"Build Agents with smolagents on Azure AI",local:"build-agents-with-smolagents-on-azure-ai",headingTag:"h1"}}),j=new C({props:{warning:!0,$$slots:{default:[es]},$$scope:{ctx:T}}}),v=new C({props:{$$slots:{default:[ts]},$$scope:{ctx:T}}}),Q=new J({props:{title:"Pre-requisites",local:"pre-requisites",headingTag:"h2"}}),P=new J({props:{title:"Setup and installation",local:"setup-and-installation",headingTag:"h2"}}),D=new U({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGF6dXJlLWFpLW1sJTIwYXp1cmUtaWRlbnRpdHklMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"%pip install azure-ai-ml azure-identity --upgrade --quiet",wrap:!1}}),te=new U({props:{code:"JTI1ZW52JTIwTE9DQVRJT04lMjBlYXN0dXMlMEElMjVlbnYlMjBTVUJTQ1JJUFRJT05fSUQlMjAlM0NZT1VSX1NVQlNDUklQVElPTl9JRCUzRSUwQSUyNWVudiUyMFJFU09VUkNFX0dST1VQJTIwJTNDWU9VUl9SRVNPVVJDRV9HUk9VUCUzRSUwQSUyNWVudiUyMEFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjAlM0NZT1VSX0FJX0ZPVU5EUllfSFVCX1BST0pFQ1QlM0U=",highlighted:`%env LOCATION eastus
%env SUBSCRIPTION_ID &lt;YOUR_SUBSCRIPTION_ID&gt;
%env RESOURCE_GROUP &lt;YOUR_RESOURCE_GROUP&gt;
%env AI_FOUNDRY_HUB_PROJECT &lt;YOUR_AI_FOUNDRY_HUB_PROJECT&gt;`,wrap:!1}}),z=new C({props:{$$slots:{default:[ls]},$$scope:{ctx:T}}}),ne=new U({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdXVpZCUyMGltcG9ydCUyMHV1aWQ0JTBBJTBBb3MuZW52aXJvbiU1QiUyMkVORFBPSU5UX05BTUUlMjIlNUQlMjAlM0QlMjBmJTIycXdlbi1jb2Rlci1lbmRwb2ludC0lN0JzdHIodXVpZDQoKSklNUIlM0E4JTVEJTdEJTIyJTBBb3MuZW52aXJvbiU1QiUyMkRFUExPWU1FTlRfTkFNRSUyMiU1RCUyMCUzRCUyMGYlMjJxd2VuLWNvZGVyLWRlcGxveW1lbnQtJTdCc3RyKHV1aWQ0KCkpJTVCJTNBOCU1RCU3RCUyMg==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> uuid <span class="hljs-keyword">import</span> uuid4

os.environ[<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>] = <span class="hljs-string">f&quot;qwen-coder-endpoint-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>
os.environ[<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>] = <span class="hljs-string">f&quot;qwen-coder-deployment-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>`,wrap:!1}}),se=new U({props:{code:"IWVjaG8lMjAlMjRFTkRQT0lOVF9OQU1FJTBBIWVjaG8lMjAlMjRERVBMT1lNRU5UX05BTUU=",highlighted:`!echo $ENDPOINT_NAME
!echo $DEPLOYMENT_NAME`,wrap:!1}}),ae=new J({props:{title:"Authenticate to Azure ML",local:"authenticate-to-azure-ml",headingTag:"h2"}}),B=new C({props:{$$slots:{default:[ns]},$$scope:{ctx:T}}}),oe=new U({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYXp1cmUuYWkubWwlMjBpbXBvcnQlMjBNTENsaWVudCUwQWZyb20lMjBhenVyZS5pZGVudGl0eSUyMGltcG9ydCUyMERlZmF1bHRBenVyZUNyZWRlbnRpYWwlMEElMEFjbGllbnQlMjAlM0QlMjBNTENsaWVudCglMEElMjAlMjAlMjAlMjBjcmVkZW50aWFsJTNERGVmYXVsdEF6dXJlQ3JlZGVudGlhbCgpJTJDJTBBJTIwJTIwJTIwJTIwc3Vic2NyaXB0aW9uX2lkJTNEb3MuZ2V0ZW52KCUyMlNVQlNDUklQVElPTl9JRCUyMiklMkMlMEElMjAlMjAlMjAlMjByZXNvdXJjZV9ncm91cF9uYW1lJTNEb3MuZ2V0ZW52KCUyMlJFU09VUkNFX0dST1VQJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHdvcmtzcGFjZV9uYW1lJTNEb3MuZ2V0ZW52KCUyMkFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> azure.ai.ml <span class="hljs-keyword">import</span> MLClient
<span class="hljs-keyword">from</span> azure.identity <span class="hljs-keyword">import</span> DefaultAzureCredential

client = MLClient(
    credential=DefaultAzureCredential(),
    subscription_id=os.getenv(<span class="hljs-string">&quot;SUBSCRIPTION_ID&quot;</span>),
    resource_group_name=os.getenv(<span class="hljs-string">&quot;RESOURCE_GROUP&quot;</span>),
    workspace_name=os.getenv(<span class="hljs-string">&quot;AI_FOUNDRY_HUB_PROJECT&quot;</span>),
)`,wrap:!1}}),re=new J({props:{title:"Create and Deploy Azure AI Endpoint",local:"create-and-deploy-azure-ai-endpoint",headingTag:"h2"}}),pe=new U({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMEElMEFtb2RlbF91cmklMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwZiUyMmF6dXJlbWwlM0ElMkYlMkZyZWdpc3RyaWVzJTJGSHVnZ2luZ0ZhY2UlMkZtb2RlbHMlMkYlN0Jtb2RlbF9pZC5yZXBsYWNlKCclMkYnJTJDJTIwJy0nKS5yZXBsYWNlKCdfJyUyQyUyMCctJykubG93ZXIoKSU3RCUyRmxhYmVscyUyRmxhdGVzdCUyMiUwQSklMEFtb2RlbF91cmk=",highlighted:`model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>

model_uri = (
    <span class="hljs-string">f&quot;azureml://registries/HuggingFace/models/<span class="hljs-subst">{model_id.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).replace(<span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).lower()}</span>/labels/latest&quot;</span>
)
model_uri`,wrap:!1}}),me=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldChmJTIyaHR0cHMlM0ElMkYlMkZnZW5lcmF0ZS1henVyZW1sLXVybHMuYXp1cmV3ZWJzaXRlcy5uZXQlMkZhcGklMkZnZW5lcmF0ZSUzRm1vZGVsSWQlM0QlN0Jtb2RlbF9pZCU3RCUyMiklMEFpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwISUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiU1QiU3QnJlc3BvbnNlLnN0YXR1c19jb2RlJTNEJTdEJTVEJTIwJTdCbW9kZWxfaWQlM0QlN0QlMjBub3QlMjBhdmFpbGFibGUlMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwQ29sbGVjdGlvbiUyMGluJTIwQXp1cmUlMjBNTCUyME1vZGVsJTIwQ2F0YWxvZyUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">import</span> requests

response = requests.get(<span class="hljs-string">f&quot;https://generate-azureml-urls.azurewebsites.net/api/generate?modelId=<span class="hljs-subst">{model_id}</span>&quot;</span>)
<span class="hljs-keyword">if</span> response.status_code != <span class="hljs-number">200</span>:
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;[{response.status_code=}] {model_id=} not available on the Hugging Face Collection in Azure ML Model Catalog&quot;</span>
    )`,wrap:!1}}),Z=new C({props:{warning:!0,$$slots:{default:[ss]},$$scope:{ctx:T}}}),fe=new U({props:{code:"ZnJvbSUyMGF6dXJlLmFpLm1sLmVudGl0aWVzJTIwaW1wb3J0JTIwTWFuYWdlZE9ubGluZUVuZHBvaW50JTJDJTIwTWFuYWdlZE9ubGluZURlcGxveW1lbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyME1hbmFnZWRPbmxpbmVFbmRwb2ludChuYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpKSUwQSUwQWRlcGxveW1lbnQlMjAlM0QlMjBNYW5hZ2VkT25saW5lRGVwbG95bWVudCglMEElMjAlMjAlMjAlMjBuYW1lJTNEb3MuZ2V0ZW52KCUyMkRFUExPWU1FTlRfTkFNRSUyMiklMkMlMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbF91cmklMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyU3RhbmRhcmRfTkM0MGFkc19IMTAwX3Y1JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> azure.ai.ml.entities <span class="hljs-keyword">import</span> ManagedOnlineEndpoint, ManagedOnlineDeployment

endpoint = ManagedOnlineEndpoint(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>))

deployment = ManagedOnlineDeployment(
    name=os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
    endpoint_name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>),
    model=model_uri,
    instance_type=<span class="hljs-string">&quot;Standard_NC40ads_H100_v5&quot;</span>,
    instance_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),ge=new U({props:{code:"Y2xpZW50LmJlZ2luX2NyZWF0ZV9vcl91cGRhdGUoZW5kcG9pbnQpLndhaXQoKQ==",highlighted:"client.begin_create_or_update(endpoint).wait()",wrap:!1}}),V=new C({props:{$$slots:{default:[as]},$$scope:{ctx:T}}}),Ue=new U({props:{code:"Y2xpZW50Lm9ubGluZV9kZXBsb3ltZW50cy5iZWdpbl9jcmVhdGVfb3JfdXBkYXRlKGRlcGxveW1lbnQpLndhaXQoKQ==",highlighted:"client.online_deployments.begin_create_or_update(deployment).wait()",wrap:!1}}),W=new C({props:{$$slots:{default:[is]},$$scope:{ctx:T}}}),$e=new J({props:{title:"Build agents with smolagents",local:"build-agents-with-smolagents",headingTag:"h2"}}),ve=new J({props:{title:"Create OpenAI Client",local:"create-openai-client",headingTag:"h3"}}),Be=new U({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJvcGVuYWklNUQlMjIlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:'%pip install <span class="hljs-string">&quot;smolagents[openai]&quot;</span> --upgrade --quiet',wrap:!1}}),We=new U({props:{code:"YXBpX2tleSUyMCUzRCUyMGNsaWVudC5vbmxpbmVfZW5kcG9pbnRzLmdldF9rZXlzKG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkucHJpbWFyeV9rZXklMEFhcGlfdXJsJTIwJTNEJTIwY2xpZW50Lm9ubGluZV9lbmRwb2ludHMuZ2V0KG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkuc2NvcmluZ191cmkucmVwbGFjZSglMjIlMkZnZW5lcmF0ZSUyMiUyQyUyMCUyMiUyRnYxJTIyKQ==",highlighted:`api_key = client.online_endpoints.get_keys(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).primary_key
api_url = client.online_endpoints.get(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).scoring_uri.replace(<span class="hljs-string">&quot;/generate&quot;</span>, <span class="hljs-string">&quot;/v1&quot;</span>)`,wrap:!1}}),E=new C({props:{$$slots:{default:[os]},$$scope:{ctx:T}}}),ke=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBhcGlfYmFzZSUzRGFwaV91cmwlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEYXBpX2tleSUyQyUwQSUyMCUyMCUyMCUyMGNsaWVudF9rd2FyZ3MlM0QlN0IlMjJkZWZhdWx0X2hlYWRlcnMlMjIlM0ElMjAlN0IlMjJhenVyZW1sLW1vZGVsLWRlcGxveW1lbnQlMjIlM0ElMjBvcy5nZXRlbnYoJTIyREVQTE9ZTUVOVF9OQU1FJTIyKSU3RCU3RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel

model = OpenAIServerModel(
    model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
    api_base=api_url,
    api_key=api_key,
    client_kwargs={<span class="hljs-string">&quot;default_headers&quot;</span>: {<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)}},
)`,wrap:!1}}),_e=new J({props:{title:"Build Python Tools",local:"build-python-tools",headingTag:"h3"}}),R=new C({props:{$$slots:{default:[rs]},$$scope:{ctx:T}}}),Fe=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29s",highlighted:'<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool',wrap:!1}}),Se=new J({props:{title:"World Time API - get_time_in_timezone",local:"world-time-api---gettimeintimezone",headingTag:"h4"}}),Ne=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGdldF90aW1lX2luX3RpbWV6b25lKGxvY2F0aW9uJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBGZXRjaGVzJTIwdGhlJTIwY3VycmVudCUyMHRpbWUlMjBmb3IlMjBhJTIwZ2l2ZW4lMjBsb2NhdGlvbiUyMHVzaW5nJTIwdGhlJTIwV29ybGQlMjBUaW1lJTIwQVBJLiUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzQSUyMFRoZSUyMGxvY2F0aW9uJTIwZm9yJTIwd2hpY2glMjB0byUyMGZldGNoJTIwdGhlJTIwY3VycmVudCUyMHRpbWUlMkMlMjBmb3JtYXR0ZWQlMjBhcyUyMCdSZWdpb24lMkZDaXR5Jy4lMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RyJTNBJTIwQSUyMHN0cmluZyUyMGluZGljYXRpbmclMjB0aGUlMjBjdXJyZW50JTIwdGltZSUyMGluJTIwdGhlJTIwc3BlY2lmaWVkJTIwbG9jYXRpb24lMkMlMjBvciUyMGFuJTIwZXJyb3IlMjBtZXNzYWdlJTIwaWYlMjB0aGUlMjByZXF1ZXN0JTIwZmFpbHMuJTBBJTIwJTIwJTIwJTIwUmFpc2VzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVxdWVzdHMuZXhjZXB0aW9ucy5SZXF1ZXN0RXhjZXB0aW9uJTNBJTIwSWYlMjB0aGVyZSUyMGlzJTIwYW4lMjBpc3N1ZSUyMHdpdGglMjB0aGUlMjBIVFRQJTIwcmVxdWVzdC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQSUyMCUyMCUyMCUyMHVybCUyMCUzRCUyMGYlMjJodHRwJTNBJTJGJTJGd29ybGR0aW1lYXBpLm9yZyUyRmFwaSUyRnRpbWV6b25lJTJGJTdCbG9jYXRpb24lN0QuanNvbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZS5yYWlzZV9mb3Jfc3RhdHVzKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwcmVzcG9uc2UuanNvbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VycmVudF90aW1lJTIwJTNEJTIwZGF0YSU1QiUyMmRhdGV0aW1lJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZiUyMlRoZSUyMGN1cnJlbnQlMjB0aW1lJTIwaW4lMjAlN0Jsb2NhdGlvbiU3RCUyMGlzJTIwJTdCY3VycmVudF90aW1lJTdELiUyMiUwQSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMHJlcXVlc3RzLmV4Y2VwdGlvbnMuUmVxdWVzdEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJFcnJvciUyMGZldGNoaW5nJTIwdGltZSUyMGRhdGElM0ElMjAlN0JzdHIoZSklN0QlMjI=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_time_in_timezone</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Fetches the current time for a given location using the World Time API.
    Args:
        location: The location for which to fetch the current time, formatted as &#x27;Region/City&#x27;.
    Returns:
        str: A string indicating the current time in the specified location, or an error message if the request fails.
    Raises:
        requests.exceptions.RequestException: If there is an issue with the HTTP request.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">import</span> requests

    url = <span class="hljs-string">f&quot;http://worldtimeapi.org/api/timezone/<span class="hljs-subst">{location}</span>.json&quot;</span>

    <span class="hljs-keyword">try</span>:
        response = requests.get(url)
        response.raise_for_status()

        data = response.json()
        current_time = data[<span class="hljs-string">&quot;datetime&quot;</span>]

        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current time in <span class="hljs-subst">{location}</span> is <span class="hljs-subst">{current_time}</span>.&quot;</span>

    <span class="hljs-keyword">except</span> requests.exceptions.RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time data: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),Qe=new J({props:{title:"Wikipedia API - search_wikipedia",local:"wikipedia-api---searchwikipedia",headingTag:"h4"}}),qe=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMHNlYXJjaF93aWtpcGVkaWEocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEZldGNoZXMlMjBhJTIwc3VtbWFyeSUyMG9mJTIwYSUyMFdpa2lwZWRpYSUyMHBhZ2UlMjBmb3IlMjBhJTIwZ2l2ZW4lMjBxdWVyeS4lMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnklM0ElMjBUaGUlMjBzZWFyY2glMjB0ZXJtJTIwdG8lMjBsb29rJTIwdXAlMjBvbiUyMFdpa2lwZWRpYS4lMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RyJTNBJTIwQSUyMHN1bW1hcnklMjBvZiUyMHRoZSUyMFdpa2lwZWRpYSUyMHBhZ2UlMjBpZiUyMHN1Y2Nlc3NmdWwlMkMlMjBvciUyMGFuJTIwZXJyb3IlMjBtZXNzYWdlJTIwaWYlMjB0aGUlMjByZXF1ZXN0JTIwZmFpbHMuJTBBJTIwJTIwJTIwJTIwUmFpc2VzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVxdWVzdHMuZXhjZXB0aW9ucy5SZXF1ZXN0RXhjZXB0aW9uJTNBJTIwSWYlMjB0aGVyZSUyMGlzJTIwYW4lMjBpc3N1ZSUyMHdpdGglMjB0aGUlMjBIVFRQJTIwcmVxdWVzdC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQSUyMCUyMCUyMCUyMHVybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZhcGklMkZyZXN0X3YxJTJGcGFnZSUyRnN1bW1hcnklMkYlN0JxdWVyeSU3RCUyMiUwQSUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZS5yYWlzZV9mb3Jfc3RhdHVzKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwcmVzcG9uc2UuanNvbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlMjAlM0QlMjBkYXRhJTVCJTIydGl0bGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHRyYWN0JTIwJTNEJTIwZGF0YSU1QiUyMmV4dHJhY3QlMjIlNUQlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyU3VtbWFyeSUyMGZvciUyMCU3QnRpdGxlJTdEJTNBJTIwJTdCZXh0cmFjdCU3RCUyMiUwQSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMHJlcXVlc3RzLmV4Y2VwdGlvbnMuUmVxdWVzdEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJFcnJvciUyMGZldGNoaW5nJTIwV2lraXBlZGlhJTIwZGF0YSUzQSUyMCU3QnN0cihlKSU3RCUyMg==",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search_wikipedia</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Fetches a summary of a Wikipedia page for a given query.
    Args:
        query: The search term to look up on Wikipedia.
    Returns:
        str: A summary of the Wikipedia page if successful, or an error message if the request fails.
    Raises:
        requests.exceptions.RequestException: If there is an issue with the HTTP request.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">import</span> requests

    url = <span class="hljs-string">f&quot;https://en.wikipedia.org/api/rest_v1/page/summary/<span class="hljs-subst">{query}</span>&quot;</span>

    <span class="hljs-keyword">try</span>:
        response = requests.get(url)
        response.raise_for_status()

        data = response.json()
        title = data[<span class="hljs-string">&quot;title&quot;</span>]
        extract = data[<span class="hljs-string">&quot;extract&quot;</span>]

        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Summary for <span class="hljs-subst">{title}</span>: <span class="hljs-subst">{extract}</span>&quot;</span>

    <span class="hljs-keyword">except</span> requests.exceptions.RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching Wikipedia data: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),Xe=new J({props:{title:"Create Agent",local:"create-agent",headingTag:"h3"}}),Oe=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdldF90aW1lX2luX3RpbWV6b25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VhcmNoX3dpa2lwZWRpYSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW1fb3V0cHV0cyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent

agent = CodeAgent(
    tools=[
        get_time_in_timezone,
        search_wikipedia,
    ],
    model=model,
    stream_outputs=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),De=new U({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNvdWxkJTIweW91JTIwY3JlYXRlJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMGdpdmVuJTIwdGhlJTIwc3VtbWFyeSUyMG9mJTIwJ1doYXQlMjBpcyUyMGElMjBMZW11ciUzRiclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjByZXBsYWNlcyUyMGFsbCUyMHRoZSUyMG9jY3VycmVuY2VzJTIwb2YlMjB0aGUlMjBsZXR0ZXIlMjBFJTIwd2l0aCUyMHRoZSUyMGxldHRlciUyMFUlMjAoaWdub3JlJTIwdGhlJTIwY2FzaW5nKSUyMiUwQSklMEElMjMlMjBTdW1tYXJ5JTIwZm9yJTIwTHVtdXIlM0ElMjBMdW11cnMlMjBhcnUlMjB3dXQtbm9zdWQlMjBwcmltYXR1cyUyMG9mJTIwdGh1JTIwc3VwdXJmYW1pbHklMjBMdW11cm9pZHVhJTJDJTIwZGl2aWR1ZCUyMGludG8lMjA4JTIwZmFtaWxpdXMlMjBhbmQlMjBjb25zaXN0aW5nJTIwb2YlMjAxNSUyMGd1bnVyYSUyMGFuZCUyMGFyb3VuZCUyMDEwMCUyMHV4aXN0aW5nJTIwc3B1Y2l1cy4lMjBUaHV5JTIwYXJ1JTIwdW5kdW1pYyUyMHRvJTIwdGh1JTIwaXNsYW5kJTIwb2YlMjBNYWRhZ2FzY2FyLiUyME1vc3QlMjB1eGlzdGluZyUyMGx1bXVycyUyMGFydSUyMHNtYWxsJTJDJTIwd2l0aCUyMGElMjBwb2ludHVkJTIwc25vdXQlMkMlMjBsYXJndSUyMHV5dXMlMkMlMjBhbmQlMjBhJTIwbG9uZyUyMHRhaWwuJTIwVGh1eSUyMGNoaXVmbHklMjBsaXZ1JTIwaW4lMjB0cnV1cyUyMGFuZCUyMGFydSUyMGFjdGl2dSUyMGF0JTIwbmlnaHQu",highlighted:`agent.run(
    <span class="hljs-string">&quot;Could you create a Python function that given the summary of &#x27;What is a Lemur?&#x27;&quot;</span>
    <span class="hljs-string">&quot; replaces all the occurrences of the letter E with the letter U (ignore the casing)&quot;</span>
)
<span class="hljs-comment"># Summary for Lumur: Lumurs aru wut-nosud primatus of thu supurfamily Lumuroidua, dividud into 8 familius and consisting of 15 gunura and around 100 uxisting spucius. Thuy aru undumic to thu island of Madagascar. Most uxisting lumurs aru small, with a pointud snout, largu uyus, and a long tail. Thuy chiufly livu in truus and aru activu at night.</span>`,wrap:!1}}),Ke=new U({props:{code:"YWdlbnQucnVuKCUyMldoYXQlMjB0aW1lJTIwaXMlMjBpbiUyMFRoYWlsYW5kJTIwcmlnaHQlMjBub3clM0YlMjBBbmQlMjB3aGF0J3MlMjB0aGUlMjB0aW1lJTIwZGlmZmVyZW5jZSUyMHdpdGglMjBGcmFuY2UlM0YlMjIpJTBBJTIzJTIwVGhlJTIwY3VycmVudCUyMHRpbWUlMjBpbiUyMFRoYWlsYW5kJTIwaXMlMjA1JTIwaG91cnMlMjBhaGVhZCUyMG9mJTIwdGhlJTIwY3VycmVudCUyMHRpbWUlMjBpbiUyMEZyYW5jZS4=",highlighted:`agent.run(<span class="hljs-string">&quot;What time is in Thailand right now? And what&#x27;s the time difference with France?&quot;</span>)
<span class="hljs-comment"># The current time in Thailand is 5 hours ahead of the current time in France.</span>`,wrap:!1}}),et=new J({props:{title:"Release resources",local:"release-resources",headingTag:"h2"}}),lt=new U({props:{code:"Y2xpZW50Lm9ubGluZV9lbmRwb2ludHMuYmVnaW5fZGVsZXRlKG5hbWUlM0Rvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMikpLnJlc3VsdCgp",highlighted:'client.online_endpoints.begin_delete(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).result()',wrap:!1}}),nt=new J({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),k=new C({props:{$$slots:{default:[us]},$$scope:{ctx:T}}}),it=new Kn({props:{source:"https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/azure-ai/examples/build-agents-with-smolagents.mdx"}}),{c(){i=r("meta"),w=s(),o=r("p"),f=s(),d(b.$$.fragment),$=s(),I=r("p"),I.innerHTML=_,g=s(),d(j.$$.fragment),rt=s(),H=r("p"),H.textContent=Nl,ut=s(),pt=r("hr"),dt=s(),G=r("p"),G.innerHTML=Ql,Mt=s(),L=r("p"),L.textContent=ql,mt=s(),x=r("ul"),x.innerHTML=Xl,ct=s(),F=r("p"),F.innerHTML=Yl,ht=s(),S=r("p"),S.innerHTML=Pl,yt=s(),N=r("p"),N.innerHTML=Ol,wt=s(),d(v.$$.fragment),ft=s(),d(Q.$$.fragment),gt=s(),q=r("p"),q.innerHTML=Dl,Tt=s(),X=r("ul"),X.innerHTML=Kl,Ut=s(),Y=r("p"),Y.innerHTML=en,jt=s(),d(P.$$.fragment),Jt=s(),O=r("p"),O.innerHTML=tn,bt=s(),d(D.$$.fragment),$t=s(),K=r("p"),K.innerHTML=ln,It=s(),ee=r("p"),ee.textContent=nn,Ct=s(),d(te.$$.fragment),At=s(),le=r("p"),le.textContent=sn,vt=s(),d(z.$$.fragment),zt=s(),d(ne.$$.fragment),Bt=s(),d(se.$$.fragment),Zt=s(),d(ae.$$.fragment),Vt=s(),ie=r("p"),ie.innerHTML=an,Wt=s(),d(B.$$.fragment),Et=s(),d(oe.$$.fragment),Rt=s(),d(re.$$.fragment),kt=s(),ue=r("p"),ue.innerHTML=on,_t=s(),d(pe.$$.fragment),Ht=s(),de=r("p"),de.innerHTML=rn,Gt=s(),Me=r("p"),Me.textContent=un,Lt=s(),d(me.$$.fragment),xt=s(),ce=r("p"),ce.innerHTML=pn,Ft=s(),he=r("p"),he.innerHTML=dn,St=s(),ye=r("p"),ye.innerHTML=Mn,Nt=s(),we=r("p"),we.innerHTML=mn,Qt=s(),d(Z.$$.fragment),qt=s(),d(fe.$$.fragment),Xt=s(),d(ge.$$.fragment),Yt=s(),Te=r("p"),Te.innerHTML=cn,Pt=s(),d(V.$$.fragment),Ot=s(),d(Ue.$$.fragment),Dt=s(),je=r("p"),je.innerHTML=hn,Kt=s(),d(W.$$.fragment),el=s(),Je=r("p"),Je.innerHTML=yn,tl=s(),be=r("p"),be.innerHTML=wn,ll=s(),d($e.$$.fragment),nl=s(),Ie=r("p"),Ie.innerHTML=fn,sl=s(),Ce=r("p"),Ce.textContent=gn,al=s(),Ae=r("ol"),Ae.innerHTML=Tn,il=s(),d(ve.$$.fragment),ol=s(),ze=r("p"),ze.innerHTML=Un,rl=s(),d(Be.$$.fragment),ul=s(),Ze=r("p"),Ze.textContent=jn,pl=s(),Ve=r("ul"),Ve.innerHTML=Jn,dl=s(),d(We.$$.fragment),Ml=s(),d(E.$$.fragment),ml=s(),Ee=r("p"),Ee.innerHTML=bn,cl=s(),Re=r("p"),Re.innerHTML=$n,hl=s(),d(ke.$$.fragment),yl=s(),d(_e.$$.fragment),wl=s(),He=r("p"),He.innerHTML=In,fl=s(),Ge=r("p"),Ge.textContent=Cn,gl=s(),Le=r("p"),Le.textContent=An,Tl=s(),xe=r("ul"),xe.innerHTML=vn,Ul=s(),d(R.$$.fragment),jl=s(),d(Fe.$$.fragment),Jl=s(),d(Se.$$.fragment),bl=s(),d(Ne.$$.fragment),$l=s(),d(Qe.$$.fragment),Il=s(),d(qe.$$.fragment),Cl=s(),d(Xe.$$.fragment),Al=s(),Ye=r("p"),Ye.innerHTML=zn,vl=s(),Pe=r("p"),Pe.innerHTML=Bn,zl=s(),d(Oe.$$.fragment),Bl=s(),d(De.$$.fragment),Zl=s(),d(Ke.$$.fragment),Vl=s(),d(et.$$.fragment),Wl=s(),tt=r("p"),tt.textContent=Zn,El=s(),d(lt.$$.fragment),Rl=s(),d(nt.$$.fragment),kl=s(),st=r("p"),st.innerHTML=Vn,_l=s(),at=r("p"),at.innerHTML=Wn,Hl=s(),Gl=r("hr"),Ll=s(),d(k.$$.fragment),xl=s(),d(it.$$.fragment),Fl=s(),ot=r("p"),this.h()},l(e){const t=On("svelte-u9bgzb",document.head);i=u(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),o=u(e,"P",{}),Nn(o).forEach(l),f=a(e),M(b.$$.fragment,e),$=a(e),I=u(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1yjfd37"&&(I.innerHTML=_),g=a(e),M(j.$$.fragment,e),rt=a(e),H=u(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1rumppw"&&(H.textContent=Nl),ut=a(e),pt=u(e,"HR",{}),dt=a(e),G=u(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1ytznsv"&&(G.innerHTML=Ql),Mt=a(e),L=u(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-t2snjh"&&(L.textContent=ql),mt=a(e),x=u(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-2qa9z2"&&(x.innerHTML=Xl),ct=a(e),F=u(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1qa3dgf"&&(F.innerHTML=Yl),ht=a(e),S=u(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-5yqx08"&&(S.innerHTML=Pl),yt=a(e),N=u(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-116q64m"&&(N.innerHTML=Ol),wt=a(e),M(v.$$.fragment,e),ft=a(e),M(Q.$$.fragment,e),gt=a(e),q=u(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-dnkqle"&&(q.innerHTML=Dl),Tt=a(e),X=u(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-dlzkka"&&(X.innerHTML=Kl),Ut=a(e),Y=u(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1myp7ii"&&(Y.innerHTML=en),jt=a(e),M(P.$$.fragment,e),Jt=a(e),O=u(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-bexho5"&&(O.innerHTML=tn),bt=a(e),M(D.$$.fragment,e),$t=a(e),K=u(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1v277rw"&&(K.innerHTML=ln),It=a(e),ee=u(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-11uslf2"&&(ee.textContent=nn),Ct=a(e),M(te.$$.fragment,e),At=a(e),le=u(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1wrtw53"&&(le.textContent=sn),vt=a(e),M(z.$$.fragment,e),zt=a(e),M(ne.$$.fragment,e),Bt=a(e),M(se.$$.fragment,e),Zt=a(e),M(ae.$$.fragment,e),Vt=a(e),ie=u(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-137z4r5"&&(ie.innerHTML=an),Wt=a(e),M(B.$$.fragment,e),Et=a(e),M(oe.$$.fragment,e),Rt=a(e),M(re.$$.fragment,e),kt=a(e),ue=u(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-thijw5"&&(ue.innerHTML=on),_t=a(e),M(pe.$$.fragment,e),Ht=a(e),de=u(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1hy4n1w"&&(de.innerHTML=rn),Gt=a(e),Me=u(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1kr526q"&&(Me.textContent=un),Lt=a(e),M(me.$$.fragment,e),xt=a(e),ce=u(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1qpei6p"&&(ce.innerHTML=pn),Ft=a(e),he=u(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1kte4k3"&&(he.innerHTML=dn),St=a(e),ye=u(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-174nxv0"&&(ye.innerHTML=Mn),Nt=a(e),we=u(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1weda3f"&&(we.innerHTML=mn),Qt=a(e),M(Z.$$.fragment,e),qt=a(e),M(fe.$$.fragment,e),Xt=a(e),M(ge.$$.fragment,e),Yt=a(e),Te=u(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1frbq80"&&(Te.innerHTML=cn),Pt=a(e),M(V.$$.fragment,e),Ot=a(e),M(Ue.$$.fragment,e),Dt=a(e),je=u(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1fetlmg"&&(je.innerHTML=hn),Kt=a(e),M(W.$$.fragment,e),el=a(e),Je=u(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1v1bv0"&&(Je.innerHTML=yn),tl=a(e),be=u(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-kgt4mo"&&(be.innerHTML=wn),ll=a(e),M($e.$$.fragment,e),nl=a(e),Ie=u(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-wl3396"&&(Ie.innerHTML=fn),sl=a(e),Ce=u(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-3qp0re"&&(Ce.textContent=gn),al=a(e),Ae=u(e,"OL",{"data-svelte-h":!0}),p(Ae)!=="svelte-34lshc"&&(Ae.innerHTML=Tn),il=a(e),M(ve.$$.fragment,e),ol=a(e),ze=u(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-u79z4g"&&(ze.innerHTML=Un),rl=a(e),M(Be.$$.fragment,e),ul=a(e),Ze=u(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-9zyo13"&&(Ze.textContent=jn),pl=a(e),Ve=u(e,"UL",{"data-svelte-h":!0}),p(Ve)!=="svelte-kvalv2"&&(Ve.innerHTML=Jn),dl=a(e),M(We.$$.fragment,e),Ml=a(e),M(E.$$.fragment,e),ml=a(e),Ee=u(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1t4oej1"&&(Ee.innerHTML=bn),cl=a(e),Re=u(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-17nvwth"&&(Re.innerHTML=$n),hl=a(e),M(ke.$$.fragment,e),yl=a(e),M(_e.$$.fragment,e),wl=a(e),He=u(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1x22a9j"&&(He.innerHTML=In),fl=a(e),Ge=u(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-11zlvue"&&(Ge.textContent=Cn),gl=a(e),Le=u(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-rn49tj"&&(Le.textContent=An),Tl=a(e),xe=u(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-sgwz2l"&&(xe.innerHTML=vn),Ul=a(e),M(R.$$.fragment,e),jl=a(e),M(Fe.$$.fragment,e),Jl=a(e),M(Se.$$.fragment,e),bl=a(e),M(Ne.$$.fragment,e),$l=a(e),M(Qe.$$.fragment,e),Il=a(e),M(qe.$$.fragment,e),Cl=a(e),M(Xe.$$.fragment,e),Al=a(e),Ye=u(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-zdpi90"&&(Ye.innerHTML=zn),vl=a(e),Pe=u(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-5w6nx1"&&(Pe.innerHTML=Bn),zl=a(e),M(Oe.$$.fragment,e),Bl=a(e),M(De.$$.fragment,e),Zl=a(e),M(Ke.$$.fragment,e),Vl=a(e),M(et.$$.fragment,e),Wl=a(e),tt=u(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-rntoeu"&&(tt.textContent=Zn),El=a(e),M(lt.$$.fragment,e),Rl=a(e),M(nt.$$.fragment,e),kl=a(e),st=u(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-nwgpno"&&(st.innerHTML=Vn),_l=a(e),at=u(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1nopug0"&&(at.innerHTML=Wn),Hl=a(e),Gl=u(e,"HR",{}),Ll=a(e),M(k.$$.fragment,e),xl=a(e),M(it.$$.fragment,e),Fl=a(e),ot=u(e,"P",{}),Nn(ot).forEach(l),this.h()},h(){Qn(i,"name","hf:doc:metadata"),Qn(i,"content",ds)},m(e,t){Dn(document.head,i),n(e,w,t),n(e,o,t),n(e,f,t),m(b,e,t),n(e,$,t),n(e,I,t),n(e,g,t),m(j,e,t),n(e,rt,t),n(e,H,t),n(e,ut,t),n(e,pt,t),n(e,dt,t),n(e,G,t),n(e,Mt,t),n(e,L,t),n(e,mt,t),n(e,x,t),n(e,ct,t),n(e,F,t),n(e,ht,t),n(e,S,t),n(e,yt,t),n(e,N,t),n(e,wt,t),m(v,e,t),n(e,ft,t),m(Q,e,t),n(e,gt,t),n(e,q,t),n(e,Tt,t),n(e,X,t),n(e,Ut,t),n(e,Y,t),n(e,jt,t),m(P,e,t),n(e,Jt,t),n(e,O,t),n(e,bt,t),m(D,e,t),n(e,$t,t),n(e,K,t),n(e,It,t),n(e,ee,t),n(e,Ct,t),m(te,e,t),n(e,At,t),n(e,le,t),n(e,vt,t),m(z,e,t),n(e,zt,t),m(ne,e,t),n(e,Bt,t),m(se,e,t),n(e,Zt,t),m(ae,e,t),n(e,Vt,t),n(e,ie,t),n(e,Wt,t),m(B,e,t),n(e,Et,t),m(oe,e,t),n(e,Rt,t),m(re,e,t),n(e,kt,t),n(e,ue,t),n(e,_t,t),m(pe,e,t),n(e,Ht,t),n(e,de,t),n(e,Gt,t),n(e,Me,t),n(e,Lt,t),m(me,e,t),n(e,xt,t),n(e,ce,t),n(e,Ft,t),n(e,he,t),n(e,St,t),n(e,ye,t),n(e,Nt,t),n(e,we,t),n(e,Qt,t),m(Z,e,t),n(e,qt,t),m(fe,e,t),n(e,Xt,t),m(ge,e,t),n(e,Yt,t),n(e,Te,t),n(e,Pt,t),m(V,e,t),n(e,Ot,t),m(Ue,e,t),n(e,Dt,t),n(e,je,t),n(e,Kt,t),m(W,e,t),n(e,el,t),n(e,Je,t),n(e,tl,t),n(e,be,t),n(e,ll,t),m($e,e,t),n(e,nl,t),n(e,Ie,t),n(e,sl,t),n(e,Ce,t),n(e,al,t),n(e,Ae,t),n(e,il,t),m(ve,e,t),n(e,ol,t),n(e,ze,t),n(e,rl,t),m(Be,e,t),n(e,ul,t),n(e,Ze,t),n(e,pl,t),n(e,Ve,t),n(e,dl,t),m(We,e,t),n(e,Ml,t),m(E,e,t),n(e,ml,t),n(e,Ee,t),n(e,cl,t),n(e,Re,t),n(e,hl,t),m(ke,e,t),n(e,yl,t),m(_e,e,t),n(e,wl,t),n(e,He,t),n(e,fl,t),n(e,Ge,t),n(e,gl,t),n(e,Le,t),n(e,Tl,t),n(e,xe,t),n(e,Ul,t),m(R,e,t),n(e,jl,t),m(Fe,e,t),n(e,Jl,t),m(Se,e,t),n(e,bl,t),m(Ne,e,t),n(e,$l,t),m(Qe,e,t),n(e,Il,t),m(qe,e,t),n(e,Cl,t),m(Xe,e,t),n(e,Al,t),n(e,Ye,t),n(e,vl,t),n(e,Pe,t),n(e,zl,t),m(Oe,e,t),n(e,Bl,t),m(De,e,t),n(e,Zl,t),m(Ke,e,t),n(e,Vl,t),m(et,e,t),n(e,Wl,t),n(e,tt,t),n(e,El,t),m(lt,e,t),n(e,Rl,t),m(nt,e,t),n(e,kl,t),n(e,st,t),n(e,_l,t),n(e,at,t),n(e,Hl,t),n(e,Gl,t),n(e,Ll,t),m(k,e,t),n(e,xl,t),m(it,e,t),n(e,Fl,t),n(e,ot,t),Sl=!0},p(e,[t]){const En={};t&2&&(En.$$scope={dirty:t,ctx:e}),j.$set(En);const Rn={};t&2&&(Rn.$$scope={dirty:t,ctx:e}),v.$set(Rn);const kn={};t&2&&(kn.$$scope={dirty:t,ctx:e}),z.$set(kn);const _n={};t&2&&(_n.$$scope={dirty:t,ctx:e}),B.$set(_n);const Hn={};t&2&&(Hn.$$scope={dirty:t,ctx:e}),Z.$set(Hn);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),V.$set(Gn);const Ln={};t&2&&(Ln.$$scope={dirty:t,ctx:e}),W.$set(Ln);const xn={};t&2&&(xn.$$scope={dirty:t,ctx:e}),E.$set(xn);const Fn={};t&2&&(Fn.$$scope={dirty:t,ctx:e}),R.$set(Fn);const Sn={};t&2&&(Sn.$$scope={dirty:t,ctx:e}),k.$set(Sn)},i(e){Sl||(c(b.$$.fragment,e),c(j.$$.fragment,e),c(v.$$.fragment,e),c(Q.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(z.$$.fragment,e),c(ne.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(B.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(Z.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(V.$$.fragment,e),c(Ue.$$.fragment,e),c(W.$$.fragment,e),c($e.$$.fragment,e),c(ve.$$.fragment,e),c(Be.$$.fragment,e),c(We.$$.fragment,e),c(E.$$.fragment,e),c(ke.$$.fragment,e),c(_e.$$.fragment,e),c(R.$$.fragment,e),c(Fe.$$.fragment,e),c(Se.$$.fragment,e),c(Ne.$$.fragment,e),c(Qe.$$.fragment,e),c(qe.$$.fragment,e),c(Xe.$$.fragment,e),c(Oe.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(lt.$$.fragment,e),c(nt.$$.fragment,e),c(k.$$.fragment,e),c(it.$$.fragment,e),Sl=!0)},o(e){h(b.$$.fragment,e),h(j.$$.fragment,e),h(v.$$.fragment,e),h(Q.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(te.$$.fragment,e),h(z.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(B.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(Z.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(V.$$.fragment,e),h(Ue.$$.fragment,e),h(W.$$.fragment,e),h($e.$$.fragment,e),h(ve.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),h(E.$$.fragment,e),h(ke.$$.fragment,e),h(_e.$$.fragment,e),h(R.$$.fragment,e),h(Fe.$$.fragment,e),h(Se.$$.fragment,e),h(Ne.$$.fragment,e),h(Qe.$$.fragment,e),h(qe.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(lt.$$.fragment,e),h(nt.$$.fragment,e),h(k.$$.fragment,e),h(it.$$.fragment,e),Sl=!1},d(e){e&&(l(w),l(o),l(f),l($),l(I),l(g),l(rt),l(H),l(ut),l(pt),l(dt),l(G),l(Mt),l(L),l(mt),l(x),l(ct),l(F),l(ht),l(S),l(yt),l(N),l(wt),l(ft),l(gt),l(q),l(Tt),l(X),l(Ut),l(Y),l(jt),l(Jt),l(O),l(bt),l($t),l(K),l(It),l(ee),l(Ct),l(At),l(le),l(vt),l(zt),l(Bt),l(Zt),l(Vt),l(ie),l(Wt),l(Et),l(Rt),l(kt),l(ue),l(_t),l(Ht),l(de),l(Gt),l(Me),l(Lt),l(xt),l(ce),l(Ft),l(he),l(St),l(ye),l(Nt),l(we),l(Qt),l(qt),l(Xt),l(Yt),l(Te),l(Pt),l(Ot),l(Dt),l(je),l(Kt),l(el),l(Je),l(tl),l(be),l(ll),l(nl),l(Ie),l(sl),l(Ce),l(al),l(Ae),l(il),l(ol),l(ze),l(rl),l(ul),l(Ze),l(pl),l(Ve),l(dl),l(Ml),l(ml),l(Ee),l(cl),l(Re),l(hl),l(yl),l(wl),l(He),l(fl),l(Ge),l(gl),l(Le),l(Tl),l(xe),l(Ul),l(jl),l(Jl),l(bl),l($l),l(Il),l(Cl),l(Al),l(Ye),l(vl),l(Pe),l(zl),l(Bl),l(Zl),l(Vl),l(Wl),l(tt),l(El),l(Rl),l(kl),l(st),l(_l),l(at),l(Hl),l(Gl),l(Ll),l(xl),l(Fl),l(ot)),l(i),y(b,e),y(j,e),y(v,e),y(Q,e),y(P,e),y(D,e),y(te,e),y(z,e),y(ne,e),y(se,e),y(ae,e),y(B,e),y(oe,e),y(re,e),y(pe,e),y(me,e),y(Z,e),y(fe,e),y(ge,e),y(V,e),y(Ue,e),y(W,e),y($e,e),y(ve,e),y(Be,e),y(We,e),y(E,e),y(ke,e),y(_e,e),y(R,e),y(Fe,e),y(Se,e),y(Ne,e),y(Qe,e),y(qe,e),y(Xe,e),y(Oe,e),y(De,e),y(Ke,e),y(et,e),y(lt,e),y(nt,e),y(k,e),y(it,e)}}}const ds='{"title":"Build Agents with smolagents on Azure AI","local":"build-agents-with-smolagents-on-azure-ai","sections":[{"title":"Pre-requisites","local":"pre-requisites","sections":[],"depth":2},{"title":"Setup and installation","local":"setup-and-installation","sections":[],"depth":2},{"title":"Authenticate to Azure ML","local":"authenticate-to-azure-ml","sections":[],"depth":2},{"title":"Create and Deploy Azure AI Endpoint","local":"create-and-deploy-azure-ai-endpoint","sections":[],"depth":2},{"title":"Build agents with smolagents","local":"build-agents-with-smolagents","sections":[{"title":"Create OpenAI Client","local":"create-openai-client","sections":[],"depth":3},{"title":"Build Python Tools","local":"build-python-tools","sections":[{"title":"World Time API - get_time_in_timezone","local":"world-time-api---gettimeintimezone","sections":[],"depth":4},{"title":"Wikipedia API - search_wikipedia","local":"wikipedia-api---searchwikipedia","sections":[],"depth":4}],"depth":3},{"title":"Create Agent","local":"create-agent","sections":[],"depth":3}],"depth":2},{"title":"Release resources","local":"release-resources","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Ms(T){return Xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends Yn{constructor(i){super(),Pn(this,i,Ms,ps,qn,{})}}export{fs as component};
