import{s as bl,n as Il,o as Bl}from"../chunks/scheduler.ea9963d4.js";import{S as Zl,i as Cl,e as p,s as t,c as i,h as Gl,a as o,d as a,b as n,f as gl,g as c,j as w,k as fl,l as $l,m as e,n as h,t as J,o as M,p as T}from"../chunks/index.2ecb6441.js";import{C as kl,H as u,E as Wl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b27212aa.js";import{C as d}from"../chunks/CodeBlock.5675cb3b.js";function Nl(ll){let j,cs,is,hs,y,Js,r,Ms,m,al="Official utilities to use the Hugging Face Hub API.",Ts,U,ws,g,us,f,js,b,ds,I,ys,B,el='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',rs,Z,tl='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',ms,C,Us,G,gs,$,nl="You can use <code>@huggingface/hub</code> in CLI mode to upload files and folders to your repo.",fs,k,bs,W,pl="You can also install globally with <code>npm install -g @huggingface/hub</code>. Then you can do:",Is,N,Bs,Q,Zs,V,il='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',Cs,R,ol="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",Gs,E,$s,Y,cl='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',ks,v,Ws,H,hl='The <code>@huggingface/hub</code> package provide basic capabilities to scan the cache directory. Learn more about <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Manage huggingface_hub cache-system</a>.',Ns,x,Qs,F,Jl="You can get the list of cached repositories using the <code>scanCacheDir</code> function.",Vs,S,Rs,A,Ml="Note: this does not work in the browser",Es,L,Ys,X,Tl="You can cache a file of a repository using the <code>downloadFileToCacheDir</code> function.",vs,_,Hs,z,wl="Note: this does not work in the browser",xs,q,Fs,D,ul="You can download an entire repository at a given revision in the cache directory using the <code>snapshotDownload</code> function.",Ss,P,As,K,jl="The code use internally the <code>downloadFileToCacheDir</code> function.",Ls,O,dl="Note: this does not work in the browser",Xs,ss,_s,ls,yl="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",zs,as,rl="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",qs,es,ml="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",Ds,ts,Ps,ns,Ul="<li><code>@huggingface/tasks</code> : Typings only</li>",Ks,ps,Os,os,sl;return y=new kl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),r=new u({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),U=new u({props:{title:"Install",local:"install",headingTag:"h2"}}),g=new d({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),f=new u({props:{title:"Deno",local:"deno",headingTag:"h3"}}),b=new d({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),I=new u({props:{title:"Usage",local:"usage",headingTag:"h2"}}),C=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> * <span class="hljs-keyword">as</span> hub <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">const</span> specificModel = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">modelInfo</span>({<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>});
<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">checkRepoAccess</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Local folder URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./models&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-comment">// Edit a file by adding prefix &amp; suffix</span>
<span class="hljs-keyword">await</span> <span class="hljs-title function_">commit</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">operations</span>: [{
    <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;edit&quot;</span>,
    <span class="hljs-attr">originalContent</span>: originalFile,
    <span class="hljs-attr">edits</span>: [{
      <span class="hljs-attr">start</span>: <span class="hljs-number">0</span>,
      <span class="hljs-attr">end</span>: <span class="hljs-number">0</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;prefix&quot;</span>])
    }, {
      <span class="hljs-attr">start</span>: originalFile.<span class="hljs-property">length</span>,
      <span class="hljs-attr">end</span>: originalFile.<span class="hljs-property">length</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;suffix&quot;</span>])
    }]
  }]
})

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),G=new u({props:{title:"CLI usage",local:"cli-usage",headingTag:"h2"}}),k=new d({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjB1cGxvYWQlMjBjb3lvdHRlNTA4JTJGdGVzdC1tb2RlbCUyMC4lMEFucHglMjAlNDBodWdnaW5nZmFjZSUyRmh1YiUyMHVwbG9hZCUyMGRhdGFzZXRzJTJGY295b3R0ZTUwOCUyRnRlc3QtZGF0YXNldCUyMC4lMEElMjMlMjBTYW1lJTIwdGhpbmclMEFucHglMjAlNDBodWdnaW5nZmFjZSUyRmh1YiUyMHVwbG9hZCUyMC0tcmVwby10eXBlJTIwZGF0YXNldCUyMGNveW90dGU1MDglMkZ0ZXN0LWRhdGFzZXQlMjAuJTBBJTIzJTIwVXBsb2FkJTIwbmV3JTIwZGF0YSUyMHdpdGglMjAwJTIwaGlzdG9yeSUyMGluJTIwYSUyMHNlcGFyYXRlJTIwYnJhbmNoJTBBbnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjBicmFuY2glMjBjcmVhdGUlMjBjb3lvdHRlNTA4JTJGdGVzdC1tb2RlbCUyMHJlbGVhc2UlMjAtLWVtcHR5JTBBbnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjB1cGxvYWQlMjBjb3lvdHRlNTA4JTJGdGVzdC1tb2RlbCUyMC4lMjAtLXJldmlzaW9uJTIwcmVsZWFzZSUwQSUwQW5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTIwLS1oZWxwJTBBbnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjB1cGxvYWQlMjAtLWhlbHA=",highlighted:`npx @huggingface/hub upload coyotte508/test-model .
npx @huggingface/hub upload datasets/coyotte508/test-dataset .
<span class="hljs-meta prompt_"># </span><span class="language-bash">Same thing</span>
npx @huggingface/hub upload --repo-type dataset coyotte508/test-dataset .
<span class="hljs-meta prompt_"># </span><span class="language-bash">Upload new data with 0 <span class="hljs-built_in">history</span> <span class="hljs-keyword">in</span> a separate branch</span>
npx @huggingface/hub branch create coyotte508/test-model release --empty
npx @huggingface/hub upload coyotte508/test-model . --revision release

npx @huggingface/hub --help
npx @huggingface/hub upload --help`,wrap:!1}}),N=new d({props:{code:"aGZqcyUyMHVwbG9hZCUyMGNveW90dGU1MDglMkZ0ZXN0LW1vZGVsJTIwLiUwQSUwQWhmanMlMjBicmFuY2glMjBjcmVhdGUlMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQlMjBjb3lvdHRlNTA4JTJGdGVzdC1kYXRhc2V0JTIwcmVsZWFzZSUyMC0tZW1wdHklMEFoZmpzJTIwdXBsb2FkJTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTIwY295b3R0ZTUwOCUyRnRlc3QtZGF0YXNldCUyMC4lMjAtLXJldmlzaW9uJTIwcmVsZWFzZSUwQSUwQWhmanMlMjAtLWhlbHAlMEFoZmpzJTIwJTIwdXBsb2FkJTIwLS1oZWxw",highlighted:`hfjs upload coyotte508/test-model .

hfjs branch create --repo-type dataset coyotte508/test-dataset release --empty
hfjs upload --repo-type dataset coyotte508/test-dataset . --revision release

hfjs --help
hfjs  upload --help`,wrap:!1}}),Q=new u({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),E=new d({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),v=new u({props:{title:"Hugging face cache",local:"hugging-face-cache",headingTag:"h2"}}),x=new u({props:{title:"scanCacheDir",local:"scancachedir",headingTag:"h3"}}),S=new d({props:{code:"aW1wb3J0JTIwJTdCJTIwc2NhbkNhY2hlRGlyJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHNjYW5DYWNoZURpcigpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzdWx0KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { scanCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">scanCacheDir</span>();

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);`,wrap:!1}}),L=new u({props:{title:"downloadFileToCacheDir",local:"downloadfiletocachedir",headingTag:"h3"}}),_=new d({props:{code:"aW1wb3J0JTIwJTdCJTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZmlsZSUyMCUzRCUyMGF3YWl0JTIwZG93bmxvYWRGaWxlVG9DYWNoZURpciglN0IlMEElMjAlMjByZXBvJTNBJTIwJ2ZvbyUyRmJhciclMkMlMEElMjAlMjBwYXRoJTNBJTIwJ1JFQURNRS5tZCclMEElN0QpJTNCJTBBJTBBY29uc29sZS5sb2coZmlsZSklM0I=",highlighted:`<span class="hljs-keyword">import</span> { downloadFileToCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> file = <span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFileToCacheDir</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
  <span class="hljs-attr">path</span>: <span class="hljs-string">&#x27;README.md&#x27;</span>
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(file);`,wrap:!1}}),q=new u({props:{title:"snapshotDownload",local:"snapshotdownload",headingTag:"h3"}}),P=new d({props:{code:"aW1wb3J0JTIwJTdCJTIwc25hcHNob3REb3dubG9hZCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwZGlyZWN0b3J5JTIwJTNEJTIwYXdhaXQlMjBzbmFwc2hvdERvd25sb2FkKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAnZm9vJTJGYmFyJyUyQyUwQSU3RCklM0IlMEElMEFjb25zb2xlLmxvZyhkaXJlY3RvcnkpJTNC",highlighted:`<span class="hljs-keyword">import</span> { snapshotDownload } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> directory = <span class="hljs-keyword">await</span> <span class="hljs-title function_">snapshotDownload</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&#x27;foo/bar&#x27;</span>,
});

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(directory);`,wrap:!1}}),ss=new u({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),ts=new u({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),ps=new Wl({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){j=p("meta"),cs=t(),is=p("p"),hs=t(),i(y.$$.fragment),Js=t(),i(r.$$.fragment),Ms=t(),m=p("p"),m.textContent=al,Ts=t(),i(U.$$.fragment),ws=t(),i(g.$$.fragment),us=t(),i(f.$$.fragment),js=t(),i(b.$$.fragment),ds=t(),i(I.$$.fragment),ys=t(),B=p("p"),B.innerHTML=el,rs=t(),Z=p("p"),Z.innerHTML=tl,ms=t(),i(C.$$.fragment),Us=t(),i(G.$$.fragment),gs=t(),$=p("p"),$.innerHTML=nl,fs=t(),i(k.$$.fragment),bs=t(),W=p("p"),W.innerHTML=pl,Is=t(),i(N.$$.fragment),Bs=t(),i(Q.$$.fragment),Zs=t(),V=p("p"),V.innerHTML=il,Cs=t(),R=p("p"),R.textContent=ol,Gs=t(),i(E.$$.fragment),$s=t(),Y=p("p"),Y.innerHTML=cl,ks=t(),i(v.$$.fragment),Ws=t(),H=p("p"),H.innerHTML=hl,Ns=t(),i(x.$$.fragment),Qs=t(),F=p("p"),F.innerHTML=Jl,Vs=t(),i(S.$$.fragment),Rs=t(),A=p("p"),A.textContent=Ml,Es=t(),i(L.$$.fragment),Ys=t(),X=p("p"),X.innerHTML=Tl,vs=t(),i(_.$$.fragment),Hs=t(),z=p("p"),z.textContent=wl,xs=t(),i(q.$$.fragment),Fs=t(),D=p("p"),D.innerHTML=ul,Ss=t(),i(P.$$.fragment),As=t(),K=p("p"),K.innerHTML=jl,Ls=t(),O=p("p"),O.textContent=dl,Xs=t(),i(ss.$$.fragment),_s=t(),ls=p("p"),ls.innerHTML=yl,zs=t(),as=p("p"),as.innerHTML=rl,qs=t(),es=p("p"),es.innerHTML=ml,Ds=t(),i(ts.$$.fragment),Ps=t(),ns=p("ul"),ns.innerHTML=Ul,Ks=t(),i(ps.$$.fragment),Os=t(),os=p("p"),this.h()},l(s){const l=Gl("svelte-u9bgzb",document.head);j=o(l,"META",{name:!0,content:!0}),l.forEach(a),cs=n(s),is=o(s,"P",{}),gl(is).forEach(a),hs=n(s),c(y.$$.fragment,s),Js=n(s),c(r.$$.fragment,s),Ms=n(s),m=o(s,"P",{"data-svelte-h":!0}),w(m)!=="svelte-a2asrt"&&(m.textContent=al),Ts=n(s),c(U.$$.fragment,s),ws=n(s),c(g.$$.fragment,s),us=n(s),c(f.$$.fragment,s),js=n(s),c(b.$$.fragment,s),ds=n(s),c(I.$$.fragment,s),ys=n(s),B=o(s,"P",{"data-svelte-h":!0}),w(B)!=="svelte-1nqczoz"&&(B.innerHTML=el),rs=n(s),Z=o(s,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-6ptpin"&&(Z.innerHTML=tl),ms=n(s),c(C.$$.fragment,s),Us=n(s),c(G.$$.fragment,s),gs=n(s),$=o(s,"P",{"data-svelte-h":!0}),w($)!=="svelte-1z0peli"&&($.innerHTML=nl),fs=n(s),c(k.$$.fragment,s),bs=n(s),W=o(s,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1aiynz7"&&(W.innerHTML=pl),Is=n(s),c(N.$$.fragment,s),Bs=n(s),c(Q.$$.fragment,s),Zs=n(s),V=o(s,"P",{"data-svelte-h":!0}),w(V)!=="svelte-bfok93"&&(V.innerHTML=il),Cs=n(s),R=o(s,"P",{"data-svelte-h":!0}),w(R)!=="svelte-1az135e"&&(R.textContent=ol),Gs=n(s),c(E.$$.fragment,s),$s=n(s),Y=o(s,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-1qsa6tj"&&(Y.innerHTML=cl),ks=n(s),c(v.$$.fragment,s),Ws=n(s),H=o(s,"P",{"data-svelte-h":!0}),w(H)!=="svelte-8xjlck"&&(H.innerHTML=hl),Ns=n(s),c(x.$$.fragment,s),Qs=n(s),F=o(s,"P",{"data-svelte-h":!0}),w(F)!=="svelte-1s5ry35"&&(F.innerHTML=Jl),Vs=n(s),c(S.$$.fragment,s),Rs=n(s),A=o(s,"P",{"data-svelte-h":!0}),w(A)!=="svelte-zyh43t"&&(A.textContent=Ml),Es=n(s),c(L.$$.fragment,s),Ys=n(s),X=o(s,"P",{"data-svelte-h":!0}),w(X)!=="svelte-1ucnuxi"&&(X.innerHTML=Tl),vs=n(s),c(_.$$.fragment,s),Hs=n(s),z=o(s,"P",{"data-svelte-h":!0}),w(z)!=="svelte-zyh43t"&&(z.textContent=wl),xs=n(s),c(q.$$.fragment,s),Fs=n(s),D=o(s,"P",{"data-svelte-h":!0}),w(D)!=="svelte-1yti9iu"&&(D.innerHTML=ul),Ss=n(s),c(P.$$.fragment,s),As=n(s),K=o(s,"P",{"data-svelte-h":!0}),w(K)!=="svelte-809o1h"&&(K.innerHTML=jl),Ls=n(s),O=o(s,"P",{"data-svelte-h":!0}),w(O)!=="svelte-zyh43t"&&(O.textContent=dl),Xs=n(s),c(ss.$$.fragment,s),_s=n(s),ls=o(s,"P",{"data-svelte-h":!0}),w(ls)!=="svelte-1gspubq"&&(ls.innerHTML=yl),zs=n(s),as=o(s,"P",{"data-svelte-h":!0}),w(as)!=="svelte-em0etc"&&(as.innerHTML=rl),qs=n(s),es=o(s,"P",{"data-svelte-h":!0}),w(es)!=="svelte-lja874"&&(es.innerHTML=ml),Ds=n(s),c(ts.$$.fragment,s),Ps=n(s),ns=o(s,"UL",{"data-svelte-h":!0}),w(ns)!=="svelte-mopwlb"&&(ns.innerHTML=Ul),Ks=n(s),c(ps.$$.fragment,s),Os=n(s),os=o(s,"P",{}),gl(os).forEach(a),this.h()},h(){fl(j,"name","hf:doc:metadata"),fl(j,"content",Ql)},m(s,l){$l(document.head,j),e(s,cs,l),e(s,is,l),e(s,hs,l),h(y,s,l),e(s,Js,l),h(r,s,l),e(s,Ms,l),e(s,m,l),e(s,Ts,l),h(U,s,l),e(s,ws,l),h(g,s,l),e(s,us,l),h(f,s,l),e(s,js,l),h(b,s,l),e(s,ds,l),h(I,s,l),e(s,ys,l),e(s,B,l),e(s,rs,l),e(s,Z,l),e(s,ms,l),h(C,s,l),e(s,Us,l),h(G,s,l),e(s,gs,l),e(s,$,l),e(s,fs,l),h(k,s,l),e(s,bs,l),e(s,W,l),e(s,Is,l),h(N,s,l),e(s,Bs,l),h(Q,s,l),e(s,Zs,l),e(s,V,l),e(s,Cs,l),e(s,R,l),e(s,Gs,l),h(E,s,l),e(s,$s,l),e(s,Y,l),e(s,ks,l),h(v,s,l),e(s,Ws,l),e(s,H,l),e(s,Ns,l),h(x,s,l),e(s,Qs,l),e(s,F,l),e(s,Vs,l),h(S,s,l),e(s,Rs,l),e(s,A,l),e(s,Es,l),h(L,s,l),e(s,Ys,l),e(s,X,l),e(s,vs,l),h(_,s,l),e(s,Hs,l),e(s,z,l),e(s,xs,l),h(q,s,l),e(s,Fs,l),e(s,D,l),e(s,Ss,l),h(P,s,l),e(s,As,l),e(s,K,l),e(s,Ls,l),e(s,O,l),e(s,Xs,l),h(ss,s,l),e(s,_s,l),e(s,ls,l),e(s,zs,l),e(s,as,l),e(s,qs,l),e(s,es,l),e(s,Ds,l),h(ts,s,l),e(s,Ps,l),e(s,ns,l),e(s,Ks,l),h(ps,s,l),e(s,Os,l),e(s,os,l),sl=!0},p:Il,i(s){sl||(J(y.$$.fragment,s),J(r.$$.fragment,s),J(U.$$.fragment,s),J(g.$$.fragment,s),J(f.$$.fragment,s),J(b.$$.fragment,s),J(I.$$.fragment,s),J(C.$$.fragment,s),J(G.$$.fragment,s),J(k.$$.fragment,s),J(N.$$.fragment,s),J(Q.$$.fragment,s),J(E.$$.fragment,s),J(v.$$.fragment,s),J(x.$$.fragment,s),J(S.$$.fragment,s),J(L.$$.fragment,s),J(_.$$.fragment,s),J(q.$$.fragment,s),J(P.$$.fragment,s),J(ss.$$.fragment,s),J(ts.$$.fragment,s),J(ps.$$.fragment,s),sl=!0)},o(s){M(y.$$.fragment,s),M(r.$$.fragment,s),M(U.$$.fragment,s),M(g.$$.fragment,s),M(f.$$.fragment,s),M(b.$$.fragment,s),M(I.$$.fragment,s),M(C.$$.fragment,s),M(G.$$.fragment,s),M(k.$$.fragment,s),M(N.$$.fragment,s),M(Q.$$.fragment,s),M(E.$$.fragment,s),M(v.$$.fragment,s),M(x.$$.fragment,s),M(S.$$.fragment,s),M(L.$$.fragment,s),M(_.$$.fragment,s),M(q.$$.fragment,s),M(P.$$.fragment,s),M(ss.$$.fragment,s),M(ts.$$.fragment,s),M(ps.$$.fragment,s),sl=!1},d(s){s&&(a(cs),a(is),a(hs),a(Js),a(Ms),a(m),a(Ts),a(ws),a(us),a(js),a(ds),a(ys),a(B),a(rs),a(Z),a(ms),a(Us),a(gs),a($),a(fs),a(bs),a(W),a(Is),a(Bs),a(Zs),a(V),a(Cs),a(R),a(Gs),a($s),a(Y),a(ks),a(Ws),a(H),a(Ns),a(Qs),a(F),a(Vs),a(Rs),a(A),a(Es),a(Ys),a(X),a(vs),a(Hs),a(z),a(xs),a(Fs),a(D),a(Ss),a(As),a(K),a(Ls),a(O),a(Xs),a(_s),a(ls),a(zs),a(as),a(qs),a(es),a(Ds),a(Ps),a(ns),a(Ks),a(Os),a(os)),a(j),T(y,s),T(r,s),T(U,s),T(g,s),T(f,s),T(b,s),T(I,s),T(C,s),T(G,s),T(k,s),T(N,s),T(Q,s),T(E,s),T(v,s),T(x,s),T(S,s),T(L,s),T(_,s),T(q,s),T(P,s),T(ss,s),T(ts,s),T(ps,s)}}}const Ql='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"CLI usage","local":"cli-usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Hugging face cache","local":"hugging-face-cache","sections":[{"title":"scanCacheDir","local":"scancachedir","sections":[],"depth":3},{"title":"downloadFileToCacheDir","local":"downloadfiletocachedir","sections":[],"depth":3},{"title":"snapshotDownload","local":"snapshotdownload","sections":[],"depth":3}],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Vl(ll){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hl extends Zl{constructor(j){super(),Cl(this,j,Vl,Nl,bl,{})}}export{Hl as component};
