import{s as Iy,a as G,n as uy,o as dy}from"../chunks/scheduler.ef843396.js";import{S as Cy,i as by,e as M,s as a,c as y,q as u,H as tt,h as fy,a as p,d as s,b as n,f as d,g as J,j as i,r as C,u as at,k as h,l as U,m as t,n as w,t as o,o as m,p as T}from"../chunks/index.05ef1181.js";import{C as c}from"../chunks/CodeBlock.096de90c.js";import{C as By}from"../chunks/CourseFloatingBanner.8ae644fb.js";import{H as r,E as gy}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ef6649bf.js";function Gy(yp){let b,yt,nt,Jt,Z,wt,v,ot,A,Jp="Now that we’ve studied the theory behind Reinforce, <strong>you’re ready to code your Reinforce agent with PyTorch</strong>. And you’ll test its robustness using CartPole-v1 and PixelCopter,.",mt,_,wp="You’ll then be able to iterate and improve this implementation for more advanced environments.",Tt,f,op='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/envs.gif" alt="Environments"/>',rt,X,mp="To validate this hands-on for the certification process, you need to push your trained models to the Hub and:",ct,W,Tp="<li>Get a result of &gt;= 350 for <code>Cartpole-v1</code></li> <li>Get a result of &gt;= 5 for <code>PixelCopter</code>.</li>",Ut,k,rp="To find your result, go to the leaderboard and find your model, <strong>the result = mean_reward - std of reward</strong>. <strong>If you don’t see your model on the leaderboard, go at the bottom of the leaderboard page and click on the refresh button</strong>.",ht,S,cp="<strong>If you don’t find your model, go to the bottom of the page and click on the refresh button.</strong>",jt,H,Up='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',It,V,hp='And you can check your progress here 👉 <a href="https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course" rel="nofollow">https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course</a>',ut,$,jp="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",dt,Q,Ip='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit4/unit4.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',Ct,R,up="We strongly <strong>recommend students use Google Colab for the hands-on exercises</strong> instead of running them on their personal computers.",bt,E,dp="By using Google Colab, <strong>you can focus on learning and experimenting without worrying about the technical aspects</strong> of setting up your environments.",ft,Y,Bt,x,Cp,gt,z,bp="In this notebook, you’ll code your first Deep Reinforcement Learning algorithm from scratch: Reinforce (also called Monte Carlo Policy Gradient).",Gt,N,fp="Reinforce is a <em>Policy-based method</em>: a Deep Reinforcement Learning algorithm that tries <strong>to optimize the policy directly without using an action-value function</strong>.",Zt,F,Bp="More precisely, Reinforce is a <em>Policy-gradient method</em>, a subclass of <em>Policy-based methods</em> that aims <strong>to optimize the policy directly by estimating the weights of the optimal policy using gradient ascent</strong>.",vt,L,gp="To test its robustness, we’re going to train it in 2 different simple environments:",At,q,Gp="<li>Cartpole-v1</li> <li>PixelcopterEnv</li>",_t,K,Zp="⬇️ Here is an example of what <strong>you will achieve at the end of this notebook.</strong> ⬇️",Xt,P,vp,Wt,D,kt,O,Ap='<li><a href="https://www.gymlibrary.dev/environments/classic_control/cart_pole/" rel="nofollow">CartPole-v1</a></li> <li><a href="https://pygame-learning-environment.readthedocs.io/en/latest/user/games/pixelcopter.html" rel="nofollow">PixelCopter</a></li>',St,ll,Ht,el,_p="<li>Python</li> <li>PyTorch</li>",Vt,sl,Xp='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',$t,tl,Qt,al,Wp="At the end of the notebook, you will:",Rt,nl,kp="<li>Be able to <strong>code a Reinforce algorithm from scratch using PyTorch.</strong></li> <li>Be able to <strong>test the robustness of your agent using simple environments.</strong></li> <li>Be able to <strong>push your trained agent to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",Et,Ml,Yt,pl,Sp="Before diving into the notebook, you need to:",xt,il,Hp='🔲 📚 <a href="https://huggingface.co/deep-rl-course/unit4/introduction" rel="nofollow">Study Policy Gradients by reading Unit 4</a>',zt,yl,Nt,Jl,Ft,wl,Vp="It’s better to run this colab in a copy on your Google Drive, so that <strong>if it times out</strong> you still have the saved notebook on your Google Drive and do not need to fill everything in from scratch.",Lt,ol,$p="To do that you can either do <code>Ctrl + S</code> or <code>File &gt; Save a copy in Google Drive.</code>",qt,ml,Kt,Tl,Qp="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",Pt,rl,Rp,Dt,cl,Ep="<li><code>Hardware Accelerator &gt; GPU</code></li>",Ot,Ul,Yp,la,hl,ea,jl,xp="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",sa,Il,zp="The following cell will install the librairies and create and run a virtual screen 🖥",ta,ul,aa,dl,na,Cl,Ma,bl,Np="The first step is to install the dependencies. We’ll install multiple ones:",pa,fl,Fp="<li><code>gym</code></li> <li><code>gym-games</code>: Extra gym environments made with PyGame.</li> <li><code>huggingface_hub</code>: The Hub works as a central place where anyone can share and explore models and datasets. It has versioning, metrics, visualizations, and other features that will allow you to easily collaborate with others.</li>",ia,Bl,Lp="You may be wondering why we install gym and not gymnasium, a more recent version of gym? <strong>Because the gym-games we are using are not updated yet with gymnasium</strong>.",ya,gl,qp="The differences you’ll encounter here:",Ja,Gl,Kp="<li>In <code>gym</code> we don’t have <code>terminated</code> and <code>truncated</code> but only <code>done</code>.</li> <li>In <code>gym</code> using <code>env.step()</code> returns <code>state, reward, done, info</code></li>",wa,Zl,Pp='You can learn more about the differences between Gym and Gymnasium here 👉 <a href="https://gymnasium.farama.org/content/migration-guide/" rel="nofollow">https://gymnasium.farama.org/content/migration-guide/</a>',oa,vl,Dp='You can see here all the Reinforce models available 👉 <a href="https://huggingface.co/models?other=reinforce" rel="nofollow">https://huggingface.co/models?other=reinforce</a>',ma,Al,Op='And you can find all the Deep Reinforcement Learning models here 👉 <a href="https://huggingface.co/models?pipeline_tag=reinforcement-learning" rel="nofollow">https://huggingface.co/models?pipeline_tag=reinforcement-learning</a>',Ta,_l,ra,Xl,ca,Wl,li="In addition to importing the installed libraries, we also import:",Ua,kl,ei="<li><code>imageio</code>: A library that will help us to generate a replay video</li>",ha,Sl,ja,Hl,Ia,Vl,si="<li>Let’s check if we have a GPU</li> <li>If it’s the case you should see <code>device:cuda0</code></li>",ua,$l,da,Ql,Ca,Rl,ti="We’re now ready to implement our Reinforce algorithm 🔥",ba,El,fa,Yl,Ba,xl,ga,zl,Ga,Nl,ai='As explained in <a href="https://stable-baselines3.readthedocs.io/en/master/guide/rl_tips.html" rel="nofollow">Reinforcement Learning Tips and Tricks</a>, when you implement your agent from scratch, you need <strong>to be sure that it works correctly and find bugs with easy environments before going deeper</strong> as finding bugs will be much easier in simple environments.',Za,Fl,ni="<p>Try to have some “sign of life” on toy problems</p>",va,Ll,Mi="<p>Validate the implementation by making it run on harder and harder envs (you can compare results against the RL zoo). You usually need to run hyperparameter optimization for that step.</p>",Aa,ql,_a,Kl,pi="<p>A pole is attached by an un-actuated joint to a cart, which moves along a frictionless track. The pendulum is placed upright on the cart and the goal is to balance the pole by applying forces in the left and right direction on the cart.</p>",Xa,Pl,ii="So, we start with CartPole-v1. The goal is to push the cart left or right <strong>so that the pole stays in the equilibrium.</strong>",Wa,Dl,yi="The episode ends if:",ka,Ol,Ji="<li>The pole Angle is greater than ±12°</li> <li>The Cart Position is greater than ±2.4</li> <li>The episode length is greater than 500</li>",Sa,le,wi="We get a reward 💰 of +1 every timestep that the Pole stays in the equilibrium.",Ha,ee,Va,se,$a,te,Qa,ae,Ra,ne,oi="This implementation is based on three implementations:",Ea,Me,mi='<li><a href="https://github.com/pytorch/examples/blob/main/reinforcement_learning/reinforce.py" rel="nofollow">PyTorch official Reinforcement Learning example</a></li> <li><a href="https://github.com/udacity/deep-reinforcement-learning/blob/master/reinforce/REINFORCE.ipynb" rel="nofollow">Udacity Reinforce</a></li> <li><a href="https://github.com/huggingface/deep-rl-class/pull/95" rel="nofollow">Improvement of the integration by Chris1nexus</a></li>',Ya,pe,Ti,xa,ie,ri="So we want:",za,ye,ci="<li>Two fully connected layers (fc1 and fc2).</li> <li>To use ReLU as activation function of fc1</li> <li>To use Softmax to output a probability distribution over actions</li>",Na,Je,Fa,we,La,oe,qa,me,Ui="I made a mistake, can you guess where?",Ka,Te,hi="<li>To find out let’s make a forward pass:</li>",Pa,re,Da,ce,ji="<li><p>Here we see that the error says <code>ValueError: The value argument to log_prob must be a Tensor</code></p></li> <li><p>It means that <code>action</code> in <code>m.log_prob(action)</code> must be a Tensor <strong>but it’s not.</strong></p></li> <li><p>Do you know why? Check the act function and try to see why it does not work.</p></li>",Oa,Ue,Ii="Advice 💡: Something is wrong in this implementation. Remember that for the act function <strong>we want to sample an action from the probability distribution over actions</strong>.",ln,he,en,je,sn,Ie,ui="By using CartPole, it was easier to debug since <strong>we know that the bug comes from our integration and not from our simple environment</strong>.",tn,ue,di="<li><p>Since <strong>we want to sample an action from the probability distribution over actions</strong>, we can’t use <code>action = np.argmax(m)</code> since it will always output the action that has the highest probability.</p></li> <li><p>We need to replace this with <code>action = m.sample()</code> which will sample an action from the probability distribution P(.|s)</p></li>",an,de,nn,Ce,Ci="This is the Reinforce algorithm pseudocode:",Mn,be,bi,pn,fe,fi='<li><p>When we calculate the return Gt (line 6), we see that we calculate the sum of discounted rewards <strong>starting at timestep t</strong>.</p></li> <li><p>Why? Because our policy should only <strong>reinforce actions on the basis of the consequences</strong>: so rewards obtained before taking an action are useless (since they were not because of the action), <strong>only the ones that come after the action matters</strong>.</p></li> <li><p>Before coding this you should read this section <a href="https://spinningup.openai.com/en/latest/spinningup/rl_intro3.html#don-t-let-the-past-distract-you" rel="nofollow">don’t let the past distract you</a> that explains why we use reward-to-go policy gradient.</p></li>',yn,Be,Bi=`We use an interesting technique coded by <a href="https://github.com/Chris1nexus" rel="nofollow">Chris1nexus</a> to <strong>compute the return at each timestep efficiently</strong>. The comments explained the procedure. Don’t hesitate also <a href="https://github.com/huggingface/deep-rl-class/pull/95" rel="nofollow">to check the PR explanation</a>
But overall the idea is to <strong>compute the return at each timestep efficiently</strong>.`,Jn,ge,gi="The second question you may ask is <strong>why do we minimize the loss</strong>? Didn’t we talk about Gradient Ascent, not Gradient Descent earlier?",wn,Ks,Ge,qM,Ps,Gi="minimize an objective function.",j,Ds,Zi="So let’s say we want to reinforce action 3 at a certain timestep. Before training this action P is 0.25.",KM,B,PM,on,Ty='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>t</mi><mi>h</mi><mi>e</mi><mi>t</mi><mi>a</mi></mrow><annotation encoding="application/x-tex">theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">t</span><span class="mord mathnormal">h</span><span class="mord mathnormal">e</span><span class="mord mathnormal">t</span><span class="mord mathnormal">a</span></span></span></span>',mn,Tn,ry='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo><mo>&gt;</mo><mn>0.25</mn></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta) &gt; 0.25 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.25</span></span></span></span>',DM,g,OM,rn,cy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>p</mi><msub><mi>i</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal">p</span><span class="mord"><span class="mord mathnormal">i</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',cn,Os,vi="minimize other action probability.",lp,lt,ep,Ze,sp,Un,Uy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>−</mo><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">1 - \\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',hn,tp,ve,ap,jn,hy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',In,np,et,Mp,un,jy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',dn,Ae,Cn,_e,bn,Xe,fn,We,Bn,ke,Ai="<li>We’re now ready to train our agent.</li> <li>But first, we define a variable containing all the training hyperparameters.</li> <li>You can change the training parameters (and should 😉)</li>",gn,Se,Gn,He,Zn,Ve,vn,$e,An,Qe,_i="<li>Here we define the evaluation method that we’re going to use to test our Reinforce agent.</li>",_n,Re,Xn,Ee,Wn,Ye,kn,xe,Sn,ze,Xi="Now that we saw we got good results after the training, we can publish our trained model on the hub 🤗 with one line of code.",Hn,Ne,Wi="Here’s an example of a Model Card:",Vn,st,ki,$n,Fe,Qn,Le,Rn,qe,En,Ke,Yn,Pe,xn,De,Si="By using <code>push_to_hub</code>, <strong>you evaluate, record a replay, generate a model card of your agent, and push it to the Hub</strong>.",zn,Oe,Hi="This way:",Nn,ls,Vi='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share an agent with the community that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',Fn,es,$i="To be able to share your model with the community there are three more steps to follow:",Ln,ss,Qi='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',qn,ts,Ri="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",Kn,as,Ei='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',Pn,ns,Yi,Dn,Ms,On,ps,xi="If you don’t want to use Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code> (or <code>login</code>)",lM,is,zi="3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function",eM,ys,sM,Js,Ni="Now that we tested the robustness of our implementation, let’s try a more complex environment: PixelCopter 🚁",tM,ws,aM,os,nM,ms,Fi='<li><a href="https://pygame-learning-environment.readthedocs.io/en/latest/user/games/pixelcopter.html" rel="nofollow">The Environment documentation</a></li>',MM,Ts,pM,rs,iM,cs,yM,Us,Li="The observation space (7) 👀:",JM,hs,qi="<li>player y position</li> <li>player velocity</li> <li>player distance to floor</li> <li>player distance to ceiling</li> <li>next block x distance to player</li> <li>next blocks top y location</li> <li>next blocks bottom y location</li>",wM,js,Ki="The action space(2) 🎮:",oM,Is,Pi="<li>Up (press accelerator)</li> <li>Do nothing (don’t press accelerator)</li>",mM,us,Di="The reward function 💰:",TM,ds,Oi="<li>For each vertical block it passes, it gains a positive reward of +1. Each time a terminal state is reached it receives a negative reward of -1.</li>",rM,Cs,cM,bs,ly="<li>We need to have a deeper neural network since the environment is more complex</li>",UM,fs,hM,Bs,jM,gs,IM,Gs,uM,Zs,ey="<li>Because this environment is more complex.</li> <li>Especially for the hidden size, we need more neurons.</li>",dM,vs,CM,As,bM,_s,sy="<li>We’re now ready to train our agent 🔥.</li>",fM,Xs,BM,Ws,gM,ks,GM,Ss,ZM,Hs,vM,Vs,ty="The best way to learn <strong>is to try things on your own</strong>! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. But also try to find better parameters.",AM,$s,ay='In the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">Leaderboard</a> you will find your agents. Can you get to the top?',_M,Qs,ny="Here are some ideas to climb up the leaderboard:",XM,Rs,My=`<li>Train more steps</li> <li>Try different hyperparameters by looking at what your classmates have done 👉 <a href="https://huggingface.co/models?other=reinforce" rel="nofollow">https://huggingface.co/models?other=reinforce</a></li> <li><strong>Push your new trained model</strong> on the Hub 🔥</li> <li><strong>Improving the implementation for more complex environments</strong> (for instance, what about changing the network to a Convolutional Neural Network to handle
frames as observation)?</li>`,WM,kM,SM,Es,py=`<strong>Congrats on finishing this unit</strong>! There was a lot of information.
And congrats on finishing the tutorial. You’ve just coded your first Deep Reinforcement Learning agent from scratch using PyTorch and shared it on the Hub 🥳.`,HM,Ys,iy=`Don’t hesitate to iterate on this unit <strong>by improving the implementation for more complex environments</strong> (for instance, what about changing the network to a Convolutional Neural Network to handle
frames as observation)?`,VM,xs,yy=`In the next unit, <strong>we’re going to learn more about Unity MLAgents</strong>, by training agents in Unity environments. This way, you will be ready to participate in the <strong>AI vs AI challenges where you’ll train your agents
to compete against other agents in a snowball fight and a soccer game.</strong>`,$M,zs,Jy="Sound fun? See you next time!",QM,Ns,wy='Finally, we would love <strong>to hear what you think of the course and how we can improve it</strong>. If you have some feedback then please 👉  <a href="https://forms.gle/BzKXWzLAGZESGNaE9" rel="nofollow">fill this form</a>',RM,Fs,oy="See you in Unit 5! 🔥",EM,Ls,YM,qs,xM,Mt,zM;return Z=new r({props:{title:"Hands on",local:"hands-on",headingTag:"h1"}}),v=new By({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit4/unit4.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),Y=new r({props:{title:"Unit 4: Code your first Deep Reinforcement Learning Algorithm with PyTorch: Reinforce. And test its robustness 💪",local:"unit-4-code-your-first-deep-reinforcement-learning-algorithm-with-pytorch-reinforce-and-test-its-robustness-",headingTag:"h1"}}),D=new r({props:{title:"🎮 Environments:",local:"-environments",headingTag:"h3"}}),ll=new r({props:{title:"📚 RL-Library:",local:"-rl-library",headingTag:"h3"}}),tl=new r({props:{title:"Objectives of this notebook 🏆",local:"objectives-of-this-notebook-",headingTag:"h2"}}),Ml=new r({props:{title:"Prerequisites 🏗️",local:"prerequisites-",headingTag:"h2"}}),yl=new r({props:{title:"Let’s code Reinforce algorithm from scratch 🔥",local:"lets-code-reinforce-algorithm-from-scratch-",headingTag:"h1"}}),Jl=new r({props:{title:"Some advice 💡",local:"some-advice-",headingTag:"h2"}}),ml=new r({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),hl=new r({props:{title:"Create a virtual display 🖥",local:"create-a-virtual-display-",headingTag:"h2"}}),ul=new c({props:{code:"JTI1JTI1Y2FwdHVyZSUwQSFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uLW9wZW5nbCUwQSFhcHQlMjBpbnN0YWxsJTIwZmZtcGVnJTBBIWFwdCUyMGluc3RhbGwlMjB4dmZiJTBBIXBpcCUyMGluc3RhbGwlMjBweXZpcnR1YWxkaXNwbGF5JTBBIXBpcCUyMGluc3RhbGwlMjBweWdsZXQlM0QlM0QxLjUuMQ==",highlighted:`%%capture
!apt install python-opengl
!apt install ffmpeg
!apt install xvfb
!pip install pyvirtualdisplay
!pip install pyglet==<span class="hljs-number">1.5</span><span class="hljs-number">.1</span>`,wrap:!1}}),dl=new c({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),Cl=new r({props:{title:"Install the dependencies 🔽",local:"install-the-dependencies-",headingTag:"h2"}}),_l=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtciUyMGh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGZGVlcC1ybC1jbGFzcyUyRm1haW4lMkZub3RlYm9va3MlMkZ1bml0NCUyRnJlcXVpcmVtZW50cy11bml0NC50eHQ=",highlighted:"!pip install -r https://raw.githubusercontent.com/huggingface/deep-rl-class/main/notebooks/unit4/requirements-unit4.txt",wrap:!1}}),Xl=new r({props:{title:"Import the packages 📦",local:"import-the-packages-",headingTag:"h2"}}),Sl=new c({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVxdWUlMEElMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBJTI1bWF0cGxvdGxpYiUyMGlubGluZSUwQSUwQSUyMyUyMFB5VG9yY2glMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHRvcmNoLm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBhcyUyMEYlMEFpbXBvcnQlMjB0b3JjaC5vcHRpbSUyMGFzJTIwb3B0aW0lMEFmcm9tJTIwdG9yY2guZGlzdHJpYnV0aW9ucyUyMGltcG9ydCUyMENhdGVnb3JpY2FsJTBBJTBBJTIzJTIwR3ltJTBBaW1wb3J0JTIwZ3ltJTBBaW1wb3J0JTIwZ3ltX3B5Z2FtZSUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTIwJTIzJTIwVG8lMjBsb2clMjB0byUyMG91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjb3VudCUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1cGxvYWQlMjBtb2RlbHMlMjB0byUyMHRoZSUyMEh1Yi4lMEFpbXBvcnQlMjBpbWFnZWlv",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> deque

<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
%matplotlib inline

<span class="hljs-comment"># PyTorch</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">import</span> torch.optim <span class="hljs-keyword">as</span> optim
<span class="hljs-keyword">from</span> torch.distributions <span class="hljs-keyword">import</span> Categorical

<span class="hljs-comment"># Gym</span>
<span class="hljs-keyword">import</span> gym
<span class="hljs-keyword">import</span> gym_pygame

<span class="hljs-comment"># Hugging Face Hub</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login <span class="hljs-comment"># To log to our Hugging Face account to be able to upload models to the Hub.</span>
<span class="hljs-keyword">import</span> imageio`,wrap:!1}}),Hl=new r({props:{title:"Check if we have a GPU",local:"check-if-we-have-a-gpu",headingTag:"h2"}}),$l=new c({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElM0EwJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMik=",highlighted:'device = torch.device(<span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)',wrap:!1}}),Ql=new c({props:{code:"cHJpbnQoZGV2aWNlKQ==",highlighted:'<span class="hljs-built_in">print</span>(device)',wrap:!1}}),El=new r({props:{title:"First agent: Playing CartPole-v1 🤖",local:"first-agent-playing-cartpole-v1-",headingTag:"h1"}}),Yl=new r({props:{title:"Create the CartPole environment and understand how it works",local:"create-the-cartpole-environment-and-understand-how-it-works",headingTag:"h2"}}),xl=new r({props:{title:"The environment 🎮",local:"the-environment-",headingTag:"h3"}}),zl=new r({props:{title:"Why do we use a simple environment like CartPole-v1?",local:"why-do-we-use-a-simple-environment-like-cartpole-v1",headingTag:"h3"}}),ql=new r({props:{title:"The CartPole-v1 environment",local:"the-cartpole-v1-environment",headingTag:"h3"}}),ee=new c({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyQ2FydFBvbGUtdjElMjIlMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBlbnYlMEFlbnYlMjAlM0QlMjBneW0ubWFrZShlbnZfaWQpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwZXZhbHVhdGlvbiUyMGVudiUwQWV2YWxfZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQSUwQSUyMyUyMEdldCUyMHRoZSUyMHN0YXRlJTIwc3BhY2UlMjBhbmQlMjBhY3Rpb24lMjBzcGFjZSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSU1QjAlNUQlMEFhX3NpemUlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLm4=",highlighted:`env_id = <span class="hljs-string">&quot;CartPole-v1&quot;</span>
<span class="hljs-comment"># Create the env</span>
env = gym.make(env_id)

<span class="hljs-comment"># Create the evaluation env</span>
eval_env = gym.make(env_id)

<span class="hljs-comment"># Get the state space and action space</span>
s_size = env.observation_space.shape[<span class="hljs-number">0</span>]
a_size = env.action_space.n`,wrap:!1}}),se=new c({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),te=new c({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),ae=new r({props:{title:"Let’s build the Reinforce Architecture",local:"lets-build-the-reinforce-architecture",headingTag:"h2"}}),Je=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMHR3byUyMGZ1bGx5JTIwY29ubmVjdGVkJTIwbGF5ZXJzJTBBJTBBJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBEZWZpbmUlMjB0aGUlMjBmb3J3YXJkJTIwcGFzcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHN0YXRlJTIwZ29lcyUyMHRvJTIwZmMxJTIwdGhlbiUyMHdlJTIwYXBwbHklMjBSZUxVJTIwYWN0aXZhdGlvbiUyMGZ1bmN0aW9uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZmMxJTIwb3V0cHV0cyUyMGdvZXMlMjB0byUyMGZjMiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFdlJTIwb3V0cHV0JTIwdGhlJTIwc29mdG1heCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGFjdChzZWxmJTJDJTIwc3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR2l2ZW4lMjBhJTIwc3RhdGUlMkMlMjB0YWtlJTIwYWN0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHN0YXRlKS5mbG9hdCgpLnVuc3F1ZWV6ZSgwKS50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvYnMlMjAlM0QlMjBzZWxmLmZvcndhcmQoc3RhdGUpLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbSUyMCUzRCUyMENhdGVnb3JpY2FsKHByb2JzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMG5wLmFyZ21heChtKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFjdGlvbi5pdGVtKCklMkMlMjBtLmxvZ19wcm9iKGFjdGlvbik=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        <span class="hljs-comment"># Create two fully connected layers</span>



    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment"># Define the forward pass</span>
        <span class="hljs-comment"># state goes to fc1 then we apply ReLU activation function</span>

        <span class="hljs-comment"># fc1 outputs goes to fc2</span>

        <span class="hljs-comment"># We output the softmax</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Given a state, take action
        &quot;&quot;&quot;</span>
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = np.argmax(m)
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),we=new r({props:{title:"Solution",local:"solution",headingTag:"h3"}}),oe=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBhX3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwRi5yZWx1KHNlbGYuZmMxKHgpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZjMih4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc29mdG1heCh4JTJDJTIwZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBhY3Qoc2VsZiUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTIwJTNEJTIwdG9yY2guZnJvbV9udW1weShzdGF0ZSkuZmxvYXQoKS51bnNxdWVlemUoMCkudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2JzJTIwJTNEJTIwc2VsZi5mb3J3YXJkKHN0YXRlKS5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG0lMjAlM0QlMjBDYXRlZ29yaWNhbChwcm9icyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBucC5hcmdtYXgobSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhY3Rpb24uaXRlbSgpJTJDJTIwbS5sb2dfcHJvYihhY3Rpb24p",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = np.argmax(m)
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),re=new c({props:{code:"ZGVidWdfcG9saWN5JTIwJTNEJTIwUG9saWN5KHNfc2l6ZSUyQyUyMGFfc2l6ZSUyQyUyMDY0KS50byhkZXZpY2UpJTBBZGVidWdfcG9saWN5LmFjdChlbnYucmVzZXQoKSk=",highlighted:`debug_policy = Policy(s_size, a_size, <span class="hljs-number">64</span>).to(device)
debug_policy.act(env.reset())`,wrap:!1}}),he=new r({props:{title:"(Real) Solution",local:"real-solution",headingTag:"h3"}}),je=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBhX3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwRi5yZWx1KHNlbGYuZmMxKHgpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZjMih4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc29mdG1heCh4JTJDJTIwZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBhY3Qoc2VsZiUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTIwJTNEJTIwdG9yY2guZnJvbV9udW1weShzdGF0ZSkuZmxvYXQoKS51bnNxdWVlemUoMCkudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2JzJTIwJTNEJTIwc2VsZi5mb3J3YXJkKHN0YXRlKS5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG0lMjAlM0QlMjBDYXRlZ29yaWNhbChwcm9icyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBtLnNhbXBsZSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9uLml0ZW0oKSUyQyUyMG0ubG9nX3Byb2IoYWN0aW9uKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),de=new r({props:{title:"Let’s build the Reinforce Training Algorithm",local:"lets-build-the-reinforce-training-algorithm",headingTag:"h3"}}),Ae=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reinforce</span>(<span class="hljs-params">policy, optimizer, n_training_episodes, max_t, gamma, print_every</span>):
    <span class="hljs-comment"># Help us to calculate the score during the training</span>
    scores_deque = deque(maxlen=<span class="hljs-number">100</span>)
    scores = []
    <span class="hljs-comment"># Line 3 of pseudocode</span>
    <span class="hljs-keyword">for</span> i_episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, n_training_episodes+<span class="hljs-number">1</span>):
        saved_log_probs = []
        rewards = []
        state = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> reset the environment</span>
        <span class="hljs-comment"># Line 4 of pseudocode</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_t):
            action, log_prob = <span class="hljs-comment"># TODO get the action</span>
            saved_log_probs.append(log_prob)
            state, reward, done, _ = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> take an env step</span>
            rewards.append(reward)
            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
        scores_deque.append(<span class="hljs-built_in">sum</span>(rewards))
        scores.append(<span class="hljs-built_in">sum</span>(rewards))

        <span class="hljs-comment"># Line 6 of pseudocode: calculate the return</span>
        returns = deque(maxlen=max_t)
        n_steps = <span class="hljs-built_in">len</span>(rewards)
        <span class="hljs-comment"># Compute the discounted returns at each timestep,</span>
        <span class="hljs-comment"># as the sum of the gamma-discounted return at time t (G_t) + the reward at time t</span>

        <span class="hljs-comment"># In O(N) time, where N is the number of time steps</span>
        <span class="hljs-comment"># (this definition of the discounted return G_t follows the definition of this quantity</span>
        <span class="hljs-comment"># shown at page 44 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_t = r_(t+1) + r_(t+2) + ...</span>

        <span class="hljs-comment"># Given this formulation, the returns at each timestep t can be computed</span>
        <span class="hljs-comment"># by re-using the computed future returns G_(t+1) to compute the current return G_t</span>
        <span class="hljs-comment"># G_t = r_(t+1) + gamma*G_(t+1)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma* G_t</span>
        <span class="hljs-comment"># (this follows a dynamic programming approach, with which we memorize solutions in order</span>
        <span class="hljs-comment"># to avoid computing them multiple times)</span>

        <span class="hljs-comment"># This is correct since the above is equivalent to (see also page 46 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma*r_(t+1) + gamma*gamma*r_(t+2) + ...</span>


        <span class="hljs-comment">## Given the above, we calculate the returns at timestep t as:</span>
        <span class="hljs-comment">#               gamma[t] * return[t] + reward[t]</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment">## We compute this starting from the last timestep to the first, in order</span>
        <span class="hljs-comment">## to employ the formula presented above and avoid redundant computations that would be needed</span>
        <span class="hljs-comment">## if we were to do it from first to last.</span>

        <span class="hljs-comment">## Hence, the queue &quot;returns&quot; will hold the returns in chronological order, from t=0 to t=n_steps</span>
        <span class="hljs-comment">## thanks to the appendleft() function which allows to append to the position 0 in constant time O(1)</span>
        <span class="hljs-comment">## a normal python list would instead require O(N) to do this.</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps)[::-<span class="hljs-number">1</span>]:
            disc_return_t = (returns[<span class="hljs-number">0</span>] <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(returns)&gt;<span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0</span>)
            returns.appendleft(    ) <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> complete here</span>

        <span class="hljs-comment">## standardization of the returns is employed to make training more stable</span>
        eps = np.finfo(np.float32).eps.item()

        <span class="hljs-comment">## eps is the smallest representable float, which is</span>
        <span class="hljs-comment"># added to the standard deviation of the returns to avoid numerical instabilities</span>
        returns = torch.tensor(returns)
        returns = (returns - returns.mean()) / (returns.std() + eps)

        <span class="hljs-comment"># Line 7:</span>
        policy_loss = []
        <span class="hljs-keyword">for</span> log_prob, disc_return <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(saved_log_probs, returns):
            policy_loss.append(-log_prob * disc_return)
        policy_loss = torch.cat(policy_loss).<span class="hljs-built_in">sum</span>()

        <span class="hljs-comment"># Line 8: PyTorch prefers gradient descent</span>
        optimizer.zero_grad()
        policy_loss.backward()
        optimizer.step()

        <span class="hljs-keyword">if</span> i_episode % print_every == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Episode {}\\tAverage Score: {:.2f}&#x27;</span>.<span class="hljs-built_in">format</span>(i_episode, np.mean(scores_deque)))

    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),_e=new r({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Xe=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reinforce</span>(<span class="hljs-params">policy, optimizer, n_training_episodes, max_t, gamma, print_every</span>):
    <span class="hljs-comment"># Help us to calculate the score during the training</span>
    scores_deque = deque(maxlen=<span class="hljs-number">100</span>)
    scores = []
    <span class="hljs-comment"># Line 3 of pseudocode</span>
    <span class="hljs-keyword">for</span> i_episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, n_training_episodes + <span class="hljs-number">1</span>):
        saved_log_probs = []
        rewards = []
        state = env.reset()
        <span class="hljs-comment"># Line 4 of pseudocode</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_t):
            action, log_prob = policy.act(state)
            saved_log_probs.append(log_prob)
            state, reward, done, _ = env.step(action)
            rewards.append(reward)
            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
        scores_deque.append(<span class="hljs-built_in">sum</span>(rewards))
        scores.append(<span class="hljs-built_in">sum</span>(rewards))

        <span class="hljs-comment"># Line 6 of pseudocode: calculate the return</span>
        returns = deque(maxlen=max_t)
        n_steps = <span class="hljs-built_in">len</span>(rewards)
        <span class="hljs-comment"># Compute the discounted returns at each timestep,</span>
        <span class="hljs-comment"># as</span>
        <span class="hljs-comment">#      the sum of the gamma-discounted return at time t (G_t) + the reward at time t</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment"># In O(N) time, where N is the number of time steps</span>
        <span class="hljs-comment"># (this definition of the discounted return G_t follows the definition of this quantity</span>
        <span class="hljs-comment"># shown at page 44 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_t = r_(t+1) + r_(t+2) + ...</span>

        <span class="hljs-comment"># Given this formulation, the returns at each timestep t can be computed</span>
        <span class="hljs-comment"># by re-using the computed future returns G_(t+1) to compute the current return G_t</span>
        <span class="hljs-comment"># G_t = r_(t+1) + gamma*G_(t+1)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma* G_t</span>
        <span class="hljs-comment"># (this follows a dynamic programming approach, with which we memorize solutions in order</span>
        <span class="hljs-comment"># to avoid computing them multiple times)</span>

        <span class="hljs-comment"># This is correct since the above is equivalent to (see also page 46 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma*r_(t+1) + gamma*gamma*r_(t+2) + ...</span>

        <span class="hljs-comment">## Given the above, we calculate the returns at timestep t as:</span>
        <span class="hljs-comment">#               gamma[t] * return[t] + reward[t]</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment">## We compute this starting from the last timestep to the first, in order</span>
        <span class="hljs-comment">## to employ the formula presented above and avoid redundant computations that would be needed</span>
        <span class="hljs-comment">## if we were to do it from first to last.</span>

        <span class="hljs-comment">## Hence, the queue &quot;returns&quot; will hold the returns in chronological order, from t=0 to t=n_steps</span>
        <span class="hljs-comment">## thanks to the appendleft() function which allows to append to the position 0 in constant time O(1)</span>
        <span class="hljs-comment">## a normal python list would instead require O(N) to do this.</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps)[::-<span class="hljs-number">1</span>]:
            disc_return_t = returns[<span class="hljs-number">0</span>] <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(returns) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0</span>
            returns.appendleft(gamma * disc_return_t + rewards[t])

        <span class="hljs-comment">## standardization of the returns is employed to make training more stable</span>
        eps = np.finfo(np.float32).eps.item()
        <span class="hljs-comment">## eps is the smallest representable float, which is</span>
        <span class="hljs-comment"># added to the standard deviation of the returns to avoid numerical instabilities</span>
        returns = torch.tensor(returns)
        returns = (returns - returns.mean()) / (returns.std() + eps)

        <span class="hljs-comment"># Line 7:</span>
        policy_loss = []
        <span class="hljs-keyword">for</span> log_prob, disc_return <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(saved_log_probs, returns):
            policy_loss.append(-log_prob * disc_return)
        policy_loss = torch.cat(policy_loss).<span class="hljs-built_in">sum</span>()

        <span class="hljs-comment"># Line 8: PyTorch prefers gradient descent</span>
        optimizer.zero_grad()
        policy_loss.backward()
        optimizer.step()

        <span class="hljs-keyword">if</span> i_episode % print_every == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Episode {}\\tAverage Score: {:.2f}&quot;</span>.<span class="hljs-built_in">format</span>(i_episode, np.mean(scores_deque)))

    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),We=new r({props:{title:"Train it",local:"train-it",headingTag:"h2"}}),Se=new c({props:{code:"Y2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaF9zaXplJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwMTAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMm5fZXZhbHVhdGlvbl9lcGlzb2RlcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3QlMjIlM0ElMjAxMDAwJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FtbWElMjIlM0ElMjAxLjAlMkMlMEElMjAlMjAlMjAlMjAlMjJsciUyMiUzQSUyMDFlLTIlMkMlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGF0ZV9zcGFjZSUyMiUzQSUyMHNfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbl9zcGFjZSUyMiUzQSUyMGFfc2l6ZSUyQyUwQSU3RA==",highlighted:`cartpole_hyperparameters = {
    <span class="hljs-string">&quot;h_size&quot;</span>: <span class="hljs-number">16</span>,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: <span class="hljs-number">10</span>,
    <span class="hljs-string">&quot;max_t&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;gamma&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-number">1e-2</span>,
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;state_space&quot;</span>: s_size,
    <span class="hljs-string">&quot;action_space&quot;</span>: a_size,
}`,wrap:!1}}),He=new c({props:{code:"JTIzJTIwQ3JlYXRlJTIwcG9saWN5JTIwYW5kJTIwcGxhY2UlMjBpdCUyMHRvJTIwdGhlJTIwZGV2aWNlJTBBY2FydHBvbGVfcG9saWN5JTIwJTNEJTIwUG9saWN5KCUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMnN0YXRlX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyYWN0aW9uX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyaF9zaXplJTIyJTVEJTJDJTBBKS50byhkZXZpY2UpJTBBY2FydHBvbGVfb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShjYXJ0cG9sZV9wb2xpY3kucGFyYW1ldGVycygpJTJDJTIwbHIlM0RjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJsciUyMiU1RCk=",highlighted:`<span class="hljs-comment"># Create policy and place it to the device</span>
cartpole_policy = Policy(
    cartpole_hyperparameters[<span class="hljs-string">&quot;state_space&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;action_space&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;h_size&quot;</span>],
).to(device)
cartpole_optimizer = optim.Adam(cartpole_policy.parameters(), lr=cartpole_hyperparameters[<span class="hljs-string">&quot;lr&quot;</span>])`,wrap:!1}}),Ve=new c({props:{code:"c2NvcmVzJTIwJTNEJTIwcmVpbmZvcmNlKCUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX3BvbGljeSUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX29wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fdHJhaW5pbmdfZXBpc29kZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMmdhbW1hJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwMTAwJTJDJTBBKQ==",highlighted:`scores = reinforce(
    cartpole_policy,
    cartpole_optimizer,
    cartpole_hyperparameters[<span class="hljs-string">&quot;n_training_episodes&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;gamma&quot;</span>],
    <span class="hljs-number">100</span>,
)`,wrap:!1}}),$e=new r({props:{title:"Define evaluation method 📝",local:"define-evaluation-method-",headingTag:"h2"}}),Re=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate_agent</span>(<span class="hljs-params">env, max_steps, n_eval_episodes, policy</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate the agent for \`\`n_eval_episodes\`\` episodes and returns average reward and std of reward.
    :param env: The evaluation environment
    :param n_eval_episodes: Number of episode to evaluate the agent
    :param policy: The Reinforce agent
    &quot;&quot;&quot;</span>
    episode_rewards = []
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_eval_episodes):
        state = env.reset()
        step = <span class="hljs-number">0</span>
        done = <span class="hljs-literal">False</span>
        total_rewards_ep = <span class="hljs-number">0</span>

        <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
            action, _ = policy.act(state)
            new_state, reward, done, info = env.step(action)
            total_rewards_ep += reward

            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
            state = new_state
        episode_rewards.append(total_rewards_ep)
    mean_reward = np.mean(episode_rewards)
    std_reward = np.std(episode_rewards)

    <span class="hljs-keyword">return</span> mean_reward, std_reward`,wrap:!1}}),Ee=new r({props:{title:"Evaluate our agent 📈",local:"evaluate-our-agent-",headingTag:"h2"}}),Ye=new c({props:{code:"ZXZhbHVhdGVfYWdlbnQoJTBBJTIwJTIwJTIwJTIwZXZhbF9lbnYlMkMlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fZXZhbHVhdGlvbl9lcGlzb2RlcyUyMiU1RCUyQyUyMGNhcnRwb2xlX3BvbGljeSUwQSk=",highlighted:`evaluate_agent(
    eval_env, cartpole_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>], cartpole_hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>], cartpole_policy
)`,wrap:!1}}),xe=new r({props:{title:"Publish our trained model on the Hub 🔥",local:"publish-our-trained-model-on-the-hub-",headingTag:"h3"}}),Fe=new r({props:{title:"Push to the Hub",local:"push-to-the-hub",headingTag:"h3"}}),Le=new r({props:{title:"Do not modify this code",local:"do-not-modify-this-code",headingTag:"h4"}}),qe=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwc25hcHNob3RfZG93bmxvYWQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnJlcG9jYXJkJTIwaW1wb3J0JTIwbWV0YWRhdGFfZXZhbF9yZXN1bHQlMkMlMjBtZXRhZGF0YV9zYXZlJTBBJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjBqc29uJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQWltcG9ydCUyMHRlbXBmaWxlJTBBJTBBaW1wb3J0JTIwb3M=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, snapshot_download
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> metadata_eval_result, metadata_save

<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> imageio

<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">import</span> os`,wrap:!1}}),Ke=new c({props:{code:"ZGVmJTIwcmVjb3JkX3ZpZGVvKGVudiUyQyUyMHBvbGljeSUyQyUyMG91dF9kaXJlY3RvcnklMkMlMjBmcHMlM0QzMCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBHZW5lcmF0ZSUyMGElMjByZXBsYXklMjB2aWRlbyUyMG9mJTIwdGhlJTIwYWdlbnQlMEElMjAlMjAlMjAlMjAlM0FwYXJhbSUyMGVudiUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwUXRhYmxlJTNBJTIwUXRhYmxlJTIwb2YlMjBvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwb3V0X2RpcmVjdG9yeSUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwZnBzJTNBJTIwaG93JTIwbWFueSUyMGZyYW1lJTIwcGVyJTIwc2Vjb25kcyUyMCh3aXRoJTIwdGF4aS12MyUyMGFuZCUyMGZyb3plbmxha2UtdjElMjB3ZSUyMHVzZSUyMDEpJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZG9uZSUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGVudi5yZW5kZXIobW9kZSUzRCUyMnJnYl9hcnJheSUyMiklMEElMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltZyklMEElMjAlMjAlMjAlMjB3aGlsZSUyMG5vdCUyMGRvbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwKGluZGV4KSUyMHRoYXQlMjBoYXZlJTIwdGhlJTIwbWF4aW11bSUyMGV4cGVjdGVkJTIwZnV0dXJlJTIwcmV3YXJkJTIwZ2l2ZW4lMjB0aGF0JTIwc3RhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMkMlMjBfJTIwJTNEJTIwcG9saWN5LmFjdChzdGF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGF0ZSUyQyUyMHJld2FyZCUyQyUyMGRvbmUlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnN0ZXAoYWN0aW9uKSUyMCUyMCUyMyUyMFdlJTIwZGlyZWN0bHklMjBwdXQlMjBuZXh0X3N0YXRlJTIwJTNEJTIwc3RhdGUlMjBmb3IlMjByZWNvcmRpbmclMjBsb2dpYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGVudi5yZW5kZXIobW9kZSUzRCUyMnJnYl9hcnJheSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltZyklMEElMjAlMjAlMjAlMjBpbWFnZWlvLm1pbXNhdmUob3V0X2RpcmVjdG9yeSUyQyUyMCU1Qm5wLmFycmF5KGltZyklMjBmb3IlMjBpJTJDJTIwaW1nJTIwaW4lMjBlbnVtZXJhdGUoaW1hZ2VzKSU1RCUyQyUyMGZwcyUzRGZwcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">record_video</span>(<span class="hljs-params">env, policy, out_directory, fps=<span class="hljs-number">30</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate a replay video of the agent
    :param env
    :param Qtable: Qtable of our agent
    :param out_directory
    :param fps: how many frame per seconds (with taxi-v3 and frozenlake-v1 we use 1)
    &quot;&quot;&quot;</span>
    images = []
    done = <span class="hljs-literal">False</span>
    state = env.reset()
    img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
    images.append(img)
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> done:
        <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
        action, _ = policy.act(state)
        state, reward, done, info = env.step(action)  <span class="hljs-comment"># We directly put next_state = state for recording logic</span>
        img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
        images.append(img)
    imageio.mimsave(out_directory, [np.array(img) <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images)], fps=fps)`,wrap:!1}}),Pe=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">repo_id,
                model,
                hyperparameters,
                eval_env,
                video_fps=<span class="hljs-number">30</span>
                </span>):
  <span class="hljs-string">&quot;&quot;&quot;
  Evaluate, Generate a video and Upload a model to Hugging Face Hub.
  This method does the complete pipeline:
  - It evaluates the model
  - It generates the model card
  - It generates a replay video of the agent
  - It pushes everything to the Hub

  :param repo_id: repo_id: id of the model repository from the Hugging Face Hub
  :param model: the pytorch model we want to save
  :param hyperparameters: training hyperparameters
  :param eval_env: evaluation environment
  :param video_fps: how many frame per seconds to record our video replay
  &quot;&quot;&quot;</span>

  _, repo_name = repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)
  api = HfApi()

  <span class="hljs-comment"># Step 1: Create the repo</span>
  repo_url = api.create_repo(
        repo_id=repo_id,
        exist_ok=<span class="hljs-literal">True</span>,
  )

  <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdirname:
    local_directory = Path(tmpdirname)

    <span class="hljs-comment"># Step 2: Save the model</span>
    torch.save(model, local_directory / <span class="hljs-string">&quot;model.pt&quot;</span>)

    <span class="hljs-comment"># Step 3: Save the hyperparameters to JSON</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_directory / <span class="hljs-string">&quot;hyperparameters.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
      json.dump(hyperparameters, outfile)

    <span class="hljs-comment"># Step 4: Evaluate the model and build JSON</span>
    mean_reward, std_reward = evaluate_agent(eval_env,
                                            hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
                                            hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>],
                                            model)
    <span class="hljs-comment"># Get datetime</span>
    eval_datetime = datetime.datetime.now()
    eval_form_datetime = eval_datetime.isoformat()

    evaluate_data = {
          <span class="hljs-string">&quot;env_id&quot;</span>: hyperparameters[<span class="hljs-string">&quot;env_id&quot;</span>],
          <span class="hljs-string">&quot;mean_reward&quot;</span>: mean_reward,
          <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>],
          <span class="hljs-string">&quot;eval_datetime&quot;</span>: eval_form_datetime,
    }

    <span class="hljs-comment"># Write a JSON file</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_directory / <span class="hljs-string">&quot;results.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
        json.dump(evaluate_data, outfile)

    <span class="hljs-comment"># Step 5: Create the model card</span>
    env_name = hyperparameters[<span class="hljs-string">&quot;env_id&quot;</span>]

    metadata = {}
    metadata[<span class="hljs-string">&quot;tags&quot;</span>] = [
          env_name,
          <span class="hljs-string">&quot;reinforce&quot;</span>,
          <span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
          <span class="hljs-string">&quot;custom-implementation&quot;</span>,
          <span class="hljs-string">&quot;deep-rl-class&quot;</span>
      ]

    <span class="hljs-comment"># Add metrics</span>
    <span class="hljs-built_in">eval</span> = metadata_eval_result(
        model_pretty_name=repo_name,
        task_pretty_name=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        task_id=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        metrics_pretty_name=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_id=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_value=<span class="hljs-string">f&quot;<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>,
        dataset_pretty_name=env_name,
        dataset_id=env_name,
      )

    <span class="hljs-comment"># Merges both dictionaries</span>
    metadata = {**metadata, **<span class="hljs-built_in">eval</span>}

    model_card = <span class="hljs-string">f&quot;&quot;&quot;
  # **Reinforce** Agent playing **<span class="hljs-subst">{env_id}</span>**
  This is a trained model of a **Reinforce** agent playing **<span class="hljs-subst">{env_id}</span>** .
  To learn to use this model and train yours check Unit 4 of the Deep Reinforcement Learning Course: https://huggingface.co/deep-rl-course/unit4/introduction
  &quot;&quot;&quot;</span>

    readme_path = local_directory / <span class="hljs-string">&quot;README.md&quot;</span>
    readme = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> readme_path.exists():
        <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;r&quot;</span>, encoding=<span class="hljs-string">&quot;utf8&quot;</span>) <span class="hljs-keyword">as</span> f:
          readme = f.read()
    <span class="hljs-keyword">else</span>:
      readme = model_card

    <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
      f.write(readme)

    <span class="hljs-comment"># Save our metrics to Readme metadata</span>
    metadata_save(readme_path, metadata)

    <span class="hljs-comment"># Step 6: Record a video</span>
    video_path =  local_directory / <span class="hljs-string">&quot;replay.mp4&quot;</span>
    record_video(env, model, video_path, video_fps)

    <span class="hljs-comment"># Step 7. Push everything to the Hub</span>
    api.upload_folder(
          repo_id=repo_id,
          folder_path=local_directory,
          path_in_repo=<span class="hljs-string">&quot;.&quot;</span>,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Your model is pushed to the Hub. You can view your model here: <span class="hljs-subst">{repo_url}</span>&quot;</span>)`,wrap:!1}}),Ms=new c({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),ys=new c({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMiUyMiUyMCUyMCUyMyUyMFRPRE8lMjBEZWZpbmUlMjB5b3VyJTIwcmVwbyUyMGlkJTIwJTdCdXNlcm5hbWUlMkZSZWluZm9yY2UtJTdCbW9kZWwtaWQlN0QlN0QlMEFwdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjByZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfcG9saWN5JTJDJTIwJTIwJTIzJTIwVGhlJTIwbW9kZWwlMjB3ZSUyMHdhbnQlMjB0byUyMHNhdmUlMEElMjAlMjAlMjAlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlMkMlMjAlMjAlMjMlMjBIeXBlcnBhcmFtZXRlcnMlMEElMjAlMjAlMjAlMjBldmFsX2VudiUyQyUyMCUyMCUyMyUyMEV2YWx1YXRpb24lMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMHZpZGVvX2ZwcyUzRDMwJTBBKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># TODO Define your repo id {username/Reinforce-{model-id}}</span>
push_to_hub(
    repo_id,
    cartpole_policy,  <span class="hljs-comment"># The model we want to save</span>
    cartpole_hyperparameters,  <span class="hljs-comment"># Hyperparameters</span>
    eval_env,  <span class="hljs-comment"># Evaluation environment</span>
    video_fps=<span class="hljs-number">30</span>
)`,wrap:!1}}),ws=new r({props:{title:"Second agent: PixelCopter 🚁",local:"second-agent-pixelcopter-",headingTag:"h2"}}),os=new r({props:{title:"Study the PixelCopter environment 👀",local:"study-the-pixelcopter-environment-",headingTag:"h3"}}),Ts=new c({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyUGl4ZWxjb3B0ZXItUExFLXYwJTIyJTBBZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQWV2YWxfZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSU1QjAlNUQlMEFhX3NpemUlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLm4=",highlighted:`env_id = <span class="hljs-string">&quot;Pixelcopter-PLE-v0&quot;</span>
env = gym.make(env_id)
eval_env = gym.make(env_id)
s_size = env.observation_space.shape[<span class="hljs-number">0</span>]
a_size = env.action_space.n`,wrap:!1}}),rs=new c({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),cs=new c({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),Cs=new r({props:{title:"Define the new Policy 🧠",local:"define-the-new-policy-",headingTag:"h3"}}),fs=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERlZmluZSUyMHRoZSUyMHRocmVlJTIwbGF5ZXJzJTIwaGVyZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGVmaW5lJTIwdGhlJTIwZm9yd2FyZCUyMHByb2Nlc3MlMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zb2Z0bWF4KHglMkMlMjBkaW0lM0QxKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGFjdChzZWxmJTJDJTIwc3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHN0YXRlKS5mbG9hdCgpLnVuc3F1ZWV6ZSgwKS50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvYnMlMjAlM0QlMjBzZWxmLmZvcndhcmQoc3RhdGUpLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbSUyMCUzRCUyMENhdGVnb3JpY2FsKHByb2JzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMG0uc2FtcGxlKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhY3Rpb24uaXRlbSgpJTJDJTIwbS5sb2dfcHJvYihhY3Rpb24p",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        <span class="hljs-comment"># Define the three layers here</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment"># Define the forward process here</span>
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),Bs=new r({props:{title:"Solution",local:"solution",headingTag:"h4"}}),gs=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBoX3NpemUlMjAqJTIwMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMyUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMjAqJTIwMiUyQyUyMGFfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBGLnJlbHUoc2VsZi5mYzEoeCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMEYucmVsdShzZWxmLmZjMih4KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5mYzMoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBGLnNvZnRtYXgoeCUyQyUyMGRpbSUzRDEpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwYWN0KHNlbGYlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGF0ZSUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoc3RhdGUpLmZsb2F0KCkudW5zcXVlZXplKDApLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9icyUyMCUzRCUyMHNlbGYuZm9yd2FyZChzdGF0ZSkuY3B1KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtJTIwJTNEJTIwQ2F0ZWdvcmljYWwocHJvYnMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwbS5zYW1wbGUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFjdGlvbi5pdGVtKCklMkMlMjBtLmxvZ19wcm9iKGFjdGlvbik=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, h_size * <span class="hljs-number">2</span>)
        self.fc3 = nn.Linear(h_size * <span class="hljs-number">2</span>, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),Gs=new r({props:{title:"Define the hyperparameters ⚙️",local:"define-the-hyperparameters-",headingTag:"h3"}}),vs=new c({props:{code:"cGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaF9zaXplJTIyJTNBJTIwNjQlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwNTAwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJuX2V2YWx1YXRpb25fZXBpc29kZXMlMjIlM0ElMjAxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF90JTIyJTNBJTIwMTAwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJnYW1tYSUyMiUzQSUyMDAuOTklMkMlMEElMjAlMjAlMjAlMjAlMjJsciUyMiUzQSUyMDFlLTQlMkMlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGF0ZV9zcGFjZSUyMiUzQSUyMHNfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbl9zcGFjZSUyMiUzQSUyMGFfc2l6ZSUyQyUwQSU3RA==",highlighted:`pixelcopter_hyperparameters = {
    <span class="hljs-string">&quot;h_size&quot;</span>: <span class="hljs-number">64</span>,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: <span class="hljs-number">50000</span>,
    <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: <span class="hljs-number">10</span>,
    <span class="hljs-string">&quot;max_t&quot;</span>: <span class="hljs-number">10000</span>,
    <span class="hljs-string">&quot;gamma&quot;</span>: <span class="hljs-number">0.99</span>,
    <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-number">1e-4</span>,
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;state_space&quot;</span>: s_size,
    <span class="hljs-string">&quot;action_space&quot;</span>: a_size,
}`,wrap:!1}}),As=new r({props:{title:"Train it",local:"train-it",headingTag:"h3"}}),Xs=new c({props:{code:"JTIzJTIwQ3JlYXRlJTIwcG9saWN5JTIwYW5kJTIwcGxhY2UlMjBpdCUyMHRvJTIwdGhlJTIwZGV2aWNlJTBBJTIzJTIwdG9yY2gubWFudWFsX3NlZWQoNTApJTBBcGl4ZWxjb3B0ZXJfcG9saWN5JTIwJTNEJTIwUG9saWN5KCUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMnN0YXRlX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyYWN0aW9uX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyaF9zaXplJTIyJTVEJTJDJTBBKS50byhkZXZpY2UpJTBBcGl4ZWxjb3B0ZXJfb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShwaXhlbGNvcHRlcl9wb2xpY3kucGFyYW1ldGVycygpJTJDJTIwbHIlM0RwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlNUIlMjJsciUyMiU1RCk=",highlighted:`<span class="hljs-comment"># Create policy and place it to the device</span>
<span class="hljs-comment"># torch.manual_seed(50)</span>
pixelcopter_policy = Policy(
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;state_space&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;action_space&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;h_size&quot;</span>],
).to(device)
pixelcopter_optimizer = optim.Adam(pixelcopter_policy.parameters(), lr=pixelcopter_hyperparameters[<span class="hljs-string">&quot;lr&quot;</span>])`,wrap:!1}}),Ws=new c({props:{code:"c2NvcmVzJTIwJTNEJTIwcmVpbmZvcmNlKCUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX3BvbGljeSUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX29wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fdHJhaW5pbmdfZXBpc29kZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMmdhbW1hJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwMTAwMCUyQyUwQSk=",highlighted:`scores = reinforce(
    pixelcopter_policy,
    pixelcopter_optimizer,
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;n_training_episodes&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;gamma&quot;</span>],
    <span class="hljs-number">1000</span>,
)`,wrap:!1}}),ks=new r({props:{title:"Publish our trained model on the Hub 🔥",local:"publish-our-trained-model-on-the-hub-",headingTag:"h3"}}),Ss=new c({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMiUyMiUyMCUyMCUyMyUyMFRPRE8lMjBEZWZpbmUlMjB5b3VyJTIwcmVwbyUyMGlkJTIwJTdCdXNlcm5hbWUlMkZSZWluZm9yY2UtJTdCbW9kZWwtaWQlN0QlN0QlMEFwdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjByZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfcG9saWN5JTJDJTIwJTIwJTIzJTIwVGhlJTIwbW9kZWwlMjB3ZSUyMHdhbnQlMjB0byUyMHNhdmUlMEElMjAlMjAlMjAlMjBwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlMkMlMjAlMjAlMjMlMjBIeXBlcnBhcmFtZXRlcnMlMEElMjAlMjAlMjAlMjBldmFsX2VudiUyQyUyMCUyMCUyMyUyMEV2YWx1YXRpb24lMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMHZpZGVvX2ZwcyUzRDMwJTBBKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># TODO Define your repo id {username/Reinforce-{model-id}}</span>
push_to_hub(
    repo_id,
    pixelcopter_policy,  <span class="hljs-comment"># The model we want to save</span>
    pixelcopter_hyperparameters,  <span class="hljs-comment"># Hyperparameters</span>
    eval_env,  <span class="hljs-comment"># Evaluation environment</span>
    video_fps=<span class="hljs-number">30</span>
)`,wrap:!1}}),Hs=new r({props:{title:"Some additional challenges 🏆",local:"some-additional-challenges-",headingTag:"h2"}}),Ls=new r({props:{title:"Keep Learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h3"}}),qs=new gy({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unit4/hands-on.mdx"}}),{c(){b=M("meta"),yt=a(),nt=M("p"),Jt=a(),y(Z.$$.fragment),wt=a(),y(v.$$.fragment),ot=a(),A=M("p"),A.innerHTML=Jp,mt=a(),_=M("p"),_.textContent=wp,Tt=a(),f=M("figure"),f.innerHTML=op,rt=a(),X=M("p"),X.textContent=mp,ct=a(),W=M("ul"),W.innerHTML=Tp,Ut=a(),k=M("p"),k.innerHTML=rp,ht=a(),S=M("p"),S.innerHTML=cp,jt=a(),H=M("p"),H.innerHTML=Up,It=a(),V=M("p"),V.innerHTML=hp,ut=a(),$=M("p"),$.innerHTML=jp,dt=a(),Q=M("p"),Q.innerHTML=Ip,Ct=a(),R=M("p"),R.innerHTML=up,bt=a(),E=M("p"),E.innerHTML=dp,ft=a(),y(Y.$$.fragment),Bt=a(),x=M("img"),gt=a(),z=M("p"),z.textContent=bp,Gt=a(),N=M("p"),N.innerHTML=fp,Zt=a(),F=M("p"),F.innerHTML=Bp,vt=a(),L=M("p"),L.textContent=gp,At=a(),q=M("ul"),q.innerHTML=Gp,_t=a(),K=M("p"),K.innerHTML=Zp,Xt=a(),P=M("img"),Wt=a(),y(D.$$.fragment),kt=a(),O=M("ul"),O.innerHTML=Ap,St=a(),y(ll.$$.fragment),Ht=a(),el=M("ul"),el.innerHTML=_p,Vt=a(),sl=M("p"),sl.innerHTML=Xp,$t=a(),y(tl.$$.fragment),Qt=a(),al=M("p"),al.textContent=Wp,Rt=a(),nl=M("ul"),nl.innerHTML=kp,Et=a(),y(Ml.$$.fragment),Yt=a(),pl=M("p"),pl.textContent=Sp,xt=a(),il=M("p"),il.innerHTML=Hp,zt=a(),y(yl.$$.fragment),Nt=a(),y(Jl.$$.fragment),Ft=a(),wl=M("p"),wl.innerHTML=Vp,Lt=a(),ol=M("p"),ol.innerHTML=$p,qt=a(),y(ml.$$.fragment),Kt=a(),Tl=M("ul"),Tl.innerHTML=Qp,Pt=a(),rl=M("img"),Dt=a(),cl=M("ul"),cl.innerHTML=Ep,Ot=a(),Ul=M("img"),la=a(),y(hl.$$.fragment),ea=a(),jl=M("p"),jl.innerHTML=xp,sa=a(),Il=M("p"),Il.textContent=zp,ta=a(),y(ul.$$.fragment),aa=a(),y(dl.$$.fragment),na=a(),y(Cl.$$.fragment),Ma=a(),bl=M("p"),bl.textContent=Np,pa=a(),fl=M("ul"),fl.innerHTML=Fp,ia=a(),Bl=M("p"),Bl.innerHTML=Lp,ya=a(),gl=M("p"),gl.textContent=qp,Ja=a(),Gl=M("ul"),Gl.innerHTML=Kp,wa=a(),Zl=M("p"),Zl.innerHTML=Pp,oa=a(),vl=M("p"),vl.innerHTML=Dp,ma=a(),Al=M("p"),Al.innerHTML=Op,Ta=a(),y(_l.$$.fragment),ra=a(),y(Xl.$$.fragment),ca=a(),Wl=M("p"),Wl.textContent=li,Ua=a(),kl=M("ul"),kl.innerHTML=ei,ha=a(),y(Sl.$$.fragment),ja=a(),y(Hl.$$.fragment),Ia=a(),Vl=M("ul"),Vl.innerHTML=si,ua=a(),y($l.$$.fragment),da=a(),y(Ql.$$.fragment),Ca=a(),Rl=M("p"),Rl.textContent=ti,ba=a(),y(El.$$.fragment),fa=a(),y(Yl.$$.fragment),Ba=a(),y(xl.$$.fragment),ga=a(),y(zl.$$.fragment),Ga=a(),Nl=M("p"),Nl.innerHTML=ai,Za=a(),Fl=M("blockquote"),Fl.innerHTML=ni,va=a(),Ll=M("blockquote"),Ll.innerHTML=Mi,Aa=a(),y(ql.$$.fragment),_a=a(),Kl=M("blockquote"),Kl.innerHTML=pi,Xa=a(),Pl=M("p"),Pl.innerHTML=ii,Wa=a(),Dl=M("p"),Dl.textContent=yi,ka=a(),Ol=M("ul"),Ol.innerHTML=Ji,Sa=a(),le=M("p"),le.textContent=wi,Ha=a(),y(ee.$$.fragment),Va=a(),y(se.$$.fragment),$a=a(),y(te.$$.fragment),Qa=a(),y(ae.$$.fragment),Ra=a(),ne=M("p"),ne.textContent=oi,Ea=a(),Me=M("ul"),Me.innerHTML=mi,Ya=a(),pe=M("img"),xa=a(),ie=M("p"),ie.textContent=ri,za=a(),ye=M("ul"),ye.innerHTML=ci,Na=a(),y(Je.$$.fragment),Fa=a(),y(we.$$.fragment),La=a(),y(oe.$$.fragment),qa=a(),me=M("p"),me.textContent=Ui,Ka=a(),Te=M("ul"),Te.innerHTML=hi,Pa=a(),y(re.$$.fragment),Da=a(),ce=M("ul"),ce.innerHTML=ji,Oa=a(),Ue=M("p"),Ue.innerHTML=Ii,ln=a(),y(he.$$.fragment),en=a(),y(je.$$.fragment),sn=a(),Ie=M("p"),Ie.innerHTML=ui,tn=a(),ue=M("ul"),ue.innerHTML=di,an=a(),y(de.$$.fragment),nn=a(),Ce=M("p"),Ce.textContent=Ci,Mn=a(),be=M("img"),pn=a(),fe=M("ul"),fe.innerHTML=fi,yn=a(),Be=M("p"),Be.innerHTML=Bi,Jn=a(),ge=M("p"),ge.innerHTML=gi,wn=a(),Ks=M("ul"),Ge=M("li"),qM=u("We want to maximize our utility function $J(\\theta)$, but in PyTorch and TensorFlow, it’s better to "),Ps=M("strong"),Ps.textContent=Gi,j=M("ul"),Ds=M("li"),Ds.textContent=Zi,KM=a(),B=M("li"),PM=u("So we want to modify"),on=new tt(!1),mn=u(" such that"),Tn=new tt(!1),DM=a(),g=M("li"),OM=u("Because all P must sum to 1, max"),rn=new tt(!1),cn=u(" will "),Os=M("strong"),Os.textContent=vi,lp=a(),lt=M("li"),ep=u("So we should tell PyTorch "),Ze=M("strong"),sp=u("to min"),Un=new tt(!1),hn=u("."),tp=a(),ve=M("li"),ap=u("This loss function approaches 0 as"),jn=new tt(!1),In=u(" nears 1."),np=a(),et=M("li"),Mp=u("So we are encouraging the gradient to max"),un=new tt(!1),dn=a(),y(Ae.$$.fragment),Cn=a(),y(_e.$$.fragment),bn=a(),y(Xe.$$.fragment),fn=a(),y(We.$$.fragment),Bn=a(),ke=M("ul"),ke.innerHTML=Ai,gn=a(),y(Se.$$.fragment),Gn=a(),y(He.$$.fragment),Zn=a(),y(Ve.$$.fragment),vn=a(),y($e.$$.fragment),An=a(),Qe=M("ul"),Qe.innerHTML=_i,_n=a(),y(Re.$$.fragment),Xn=a(),y(Ee.$$.fragment),Wn=a(),y(Ye.$$.fragment),kn=a(),y(xe.$$.fragment),Sn=a(),ze=M("p"),ze.textContent=Xi,Hn=a(),Ne=M("p"),Ne.textContent=Wi,Vn=a(),st=M("img"),$n=a(),y(Fe.$$.fragment),Qn=a(),y(Le.$$.fragment),Rn=a(),y(qe.$$.fragment),En=a(),y(Ke.$$.fragment),Yn=a(),y(Pe.$$.fragment),xn=a(),De=M("p"),De.innerHTML=Si,zn=a(),Oe=M("p"),Oe.textContent=Hi,Nn=a(),ls=M("ul"),ls.innerHTML=Vi,Fn=a(),es=M("p"),es.textContent=$i,Ln=a(),ss=M("p"),ss.innerHTML=Qi,qn=a(),ts=M("p"),ts.textContent=Ri,Kn=a(),as=M("ul"),as.innerHTML=Ei,Pn=a(),ns=M("img"),Dn=a(),y(Ms.$$.fragment),On=a(),ps=M("p"),ps.innerHTML=xi,lM=a(),is=M("p"),is.innerHTML=zi,eM=a(),y(ys.$$.fragment),sM=a(),Js=M("p"),Js.textContent=Ni,tM=a(),y(ws.$$.fragment),aM=a(),y(os.$$.fragment),nM=a(),ms=M("ul"),ms.innerHTML=Fi,MM=a(),y(Ts.$$.fragment),pM=a(),y(rs.$$.fragment),iM=a(),y(cs.$$.fragment),yM=a(),Us=M("p"),Us.textContent=Li,JM=a(),hs=M("ul"),hs.innerHTML=qi,wM=a(),js=M("p"),js.textContent=Ki,oM=a(),Is=M("ul"),Is.innerHTML=Pi,mM=a(),us=M("p"),us.textContent=Di,TM=a(),ds=M("ul"),ds.innerHTML=Oi,rM=a(),y(Cs.$$.fragment),cM=a(),bs=M("ul"),bs.innerHTML=ly,UM=a(),y(fs.$$.fragment),hM=a(),y(Bs.$$.fragment),jM=a(),y(gs.$$.fragment),IM=a(),y(Gs.$$.fragment),uM=a(),Zs=M("ul"),Zs.innerHTML=ey,dM=a(),y(vs.$$.fragment),CM=a(),y(As.$$.fragment),bM=a(),_s=M("ul"),_s.innerHTML=sy,fM=a(),y(Xs.$$.fragment),BM=a(),y(Ws.$$.fragment),gM=a(),y(ks.$$.fragment),GM=a(),y(Ss.$$.fragment),ZM=a(),y(Hs.$$.fragment),vM=a(),Vs=M("p"),Vs.innerHTML=ty,AM=a(),$s=M("p"),$s.innerHTML=ay,_M=a(),Qs=M("p"),Qs.textContent=ny,XM=a(),Rs=M("ul"),Rs.innerHTML=My,WM=a(),kM=M("hr"),SM=a(),Es=M("p"),Es.innerHTML=py,HM=a(),Ys=M("p"),Ys.innerHTML=iy,VM=a(),xs=M("p"),xs.innerHTML=yy,$M=a(),zs=M("p"),zs.textContent=Jy,QM=a(),Ns=M("p"),Ns.innerHTML=wy,RM=a(),Fs=M("p"),Fs.textContent=oy,EM=a(),y(Ls.$$.fragment),YM=a(),y(qs.$$.fragment),xM=a(),Mt=M("p"),this.h()},l(l){const e=fy("svelte-u9bgzb",document.head);b=p(e,"META",{name:!0,content:!0}),e.forEach(s),yt=n(l),nt=p(l,"P",{}),d(nt).forEach(s),Jt=n(l),J(Z.$$.fragment,l),wt=n(l),J(v.$$.fragment,l),ot=n(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-fi9d8o"&&(A.innerHTML=Jp),mt=n(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-liqaak"&&(_.textContent=wp),Tt=n(l),f=p(l,"FIGURE",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-1dadvfq"&&(f.innerHTML=op),rt=n(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1u0hqjo"&&(X.textContent=mp),ct=n(l),W=p(l,"UL",{"data-svelte-h":!0}),i(W)!=="svelte-qqschq"&&(W.innerHTML=Tp),Ut=n(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-h6mhk8"&&(k.innerHTML=rp),ht=n(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1c0nyzi"&&(S.innerHTML=cp),jt=n(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1qkxyrx"&&(H.innerHTML=Up),It=n(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-znarat"&&(V.innerHTML=hp),ut=n(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-10pdw2g"&&($.innerHTML=jp),dt=n(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-8tt267"&&(Q.innerHTML=Ip),Ct=n(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-uilrpw"&&(R.innerHTML=up),bt=n(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-p9mrd0"&&(E.innerHTML=dp),ft=n(l),J(Y.$$.fragment,l),Bt=n(l),x=p(l,"IMG",{src:!0,alt:!0}),gt=n(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-11hwml8"&&(z.textContent=bp),Gt=n(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-nwil7u"&&(N.innerHTML=fp),Zt=n(l),F=p(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-jsssl2"&&(F.innerHTML=Bp),vt=n(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1wpzntl"&&(L.textContent=gp),At=n(l),q=p(l,"UL",{"data-svelte-h":!0}),i(q)!=="svelte-1c5irle"&&(q.innerHTML=Gp),_t=n(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-4ucrls"&&(K.innerHTML=Zp),Xt=n(l),P=p(l,"IMG",{src:!0,alt:!0}),Wt=n(l),J(D.$$.fragment,l),kt=n(l),O=p(l,"UL",{"data-svelte-h":!0}),i(O)!=="svelte-1tbp2wd"&&(O.innerHTML=Ap),St=n(l),J(ll.$$.fragment,l),Ht=n(l),el=p(l,"UL",{"data-svelte-h":!0}),i(el)!=="svelte-ud7zzn"&&(el.innerHTML=_p),Vt=n(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-qqj2y4"&&(sl.innerHTML=Xp),$t=n(l),J(tl.$$.fragment,l),Qt=n(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-nsjs09"&&(al.textContent=Wp),Rt=n(l),nl=p(l,"UL",{"data-svelte-h":!0}),i(nl)!=="svelte-14xf3th"&&(nl.innerHTML=kp),Et=n(l),J(Ml.$$.fragment,l),Yt=n(l),pl=p(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1v25wk6"&&(pl.textContent=Sp),xt=n(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1rlbolh"&&(il.innerHTML=Hp),zt=n(l),J(yl.$$.fragment,l),Nt=n(l),J(Jl.$$.fragment,l),Ft=n(l),wl=p(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-ob9gmy"&&(wl.innerHTML=Vp),Lt=n(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-kifkkx"&&(ol.innerHTML=$p),qt=n(l),J(ml.$$.fragment,l),Kt=n(l),Tl=p(l,"UL",{"data-svelte-h":!0}),i(Tl)!=="svelte-1funvfi"&&(Tl.innerHTML=Qp),Pt=n(l),rl=p(l,"IMG",{src:!0,alt:!0}),Dt=n(l),cl=p(l,"UL",{"data-svelte-h":!0}),i(cl)!=="svelte-1cge6gn"&&(cl.innerHTML=Ep),Ot=n(l),Ul=p(l,"IMG",{src:!0,alt:!0}),la=n(l),J(hl.$$.fragment,l),ea=n(l),jl=p(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-pdx5k3"&&(jl.innerHTML=xp),sa=n(l),Il=p(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-tsd2zd"&&(Il.textContent=zp),ta=n(l),J(ul.$$.fragment,l),aa=n(l),J(dl.$$.fragment,l),na=n(l),J(Cl.$$.fragment,l),Ma=n(l),bl=p(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1pw2whq"&&(bl.textContent=Np),pa=n(l),fl=p(l,"UL",{"data-svelte-h":!0}),i(fl)!=="svelte-k2qrfp"&&(fl.innerHTML=Fp),ia=n(l),Bl=p(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-1vmixr"&&(Bl.innerHTML=Lp),ya=n(l),gl=p(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-1wv28c2"&&(gl.textContent=qp),Ja=n(l),Gl=p(l,"UL",{"data-svelte-h":!0}),i(Gl)!=="svelte-myoczt"&&(Gl.innerHTML=Kp),wa=n(l),Zl=p(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1qs6q29"&&(Zl.innerHTML=Pp),oa=n(l),vl=p(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-xcqr7v"&&(vl.innerHTML=Dp),ma=n(l),Al=p(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-hj7hlz"&&(Al.innerHTML=Op),Ta=n(l),J(_l.$$.fragment,l),ra=n(l),J(Xl.$$.fragment,l),ca=n(l),Wl=p(l,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-dqxg7f"&&(Wl.textContent=li),Ua=n(l),kl=p(l,"UL",{"data-svelte-h":!0}),i(kl)!=="svelte-1gjders"&&(kl.innerHTML=ei),ha=n(l),J(Sl.$$.fragment,l),ja=n(l),J(Hl.$$.fragment,l),Ia=n(l),Vl=p(l,"UL",{"data-svelte-h":!0}),i(Vl)!=="svelte-1gy9cwb"&&(Vl.innerHTML=si),ua=n(l),J($l.$$.fragment,l),da=n(l),J(Ql.$$.fragment,l),Ca=n(l),Rl=p(l,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-vuxvq9"&&(Rl.textContent=ti),ba=n(l),J(El.$$.fragment,l),fa=n(l),J(Yl.$$.fragment,l),Ba=n(l),J(xl.$$.fragment,l),ga=n(l),J(zl.$$.fragment,l),Ga=n(l),Nl=p(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-gt4x2w"&&(Nl.innerHTML=ai),Za=n(l),Fl=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Fl)!=="svelte-1tbaqzz"&&(Fl.innerHTML=ni),va=n(l),Ll=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Ll)!=="svelte-183qkv9"&&(Ll.innerHTML=Mi),Aa=n(l),J(ql.$$.fragment,l),_a=n(l),Kl=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Kl)!=="svelte-9v2bo0"&&(Kl.innerHTML=pi),Xa=n(l),Pl=p(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-13r4rlx"&&(Pl.innerHTML=ii),Wa=n(l),Dl=p(l,"P",{"data-svelte-h":!0}),i(Dl)!=="svelte-oceozx"&&(Dl.textContent=yi),ka=n(l),Ol=p(l,"UL",{"data-svelte-h":!0}),i(Ol)!=="svelte-1c26av6"&&(Ol.innerHTML=Ji),Sa=n(l),le=p(l,"P",{"data-svelte-h":!0}),i(le)!=="svelte-poz2v2"&&(le.textContent=wi),Ha=n(l),J(ee.$$.fragment,l),Va=n(l),J(se.$$.fragment,l),$a=n(l),J(te.$$.fragment,l),Qa=n(l),J(ae.$$.fragment,l),Ra=n(l),ne=p(l,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-2qybsb"&&(ne.textContent=oi),Ea=n(l),Me=p(l,"UL",{"data-svelte-h":!0}),i(Me)!=="svelte-1sj03by"&&(Me.innerHTML=mi),Ya=n(l),pe=p(l,"IMG",{src:!0,alt:!0}),xa=n(l),ie=p(l,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-56izqm"&&(ie.textContent=ri),za=n(l),ye=p(l,"UL",{"data-svelte-h":!0}),i(ye)!=="svelte-5b172v"&&(ye.innerHTML=ci),Na=n(l),J(Je.$$.fragment,l),Fa=n(l),J(we.$$.fragment,l),La=n(l),J(oe.$$.fragment,l),qa=n(l),me=p(l,"P",{"data-svelte-h":!0}),i(me)!=="svelte-131hsl5"&&(me.textContent=Ui),Ka=n(l),Te=p(l,"UL",{"data-svelte-h":!0}),i(Te)!=="svelte-f2pb1"&&(Te.innerHTML=hi),Pa=n(l),J(re.$$.fragment,l),Da=n(l),ce=p(l,"UL",{"data-svelte-h":!0}),i(ce)!=="svelte-kheb3v"&&(ce.innerHTML=ji),Oa=n(l),Ue=p(l,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-r1i79m"&&(Ue.innerHTML=Ii),ln=n(l),J(he.$$.fragment,l),en=n(l),J(je.$$.fragment,l),sn=n(l),Ie=p(l,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-tmktf2"&&(Ie.innerHTML=ui),tn=n(l),ue=p(l,"UL",{"data-svelte-h":!0}),i(ue)!=="svelte-mzudog"&&(ue.innerHTML=di),an=n(l),J(de.$$.fragment,l),nn=n(l),Ce=p(l,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-adbt0w"&&(Ce.textContent=Ci),Mn=n(l),be=p(l,"IMG",{src:!0,alt:!0}),pn=n(l),fe=p(l,"UL",{"data-svelte-h":!0}),i(fe)!=="svelte-1wxltag"&&(fe.innerHTML=fi),yn=n(l),Be=p(l,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-1ucwq0c"&&(Be.innerHTML=Bi),Jn=n(l),ge=p(l,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-1tam5jq"&&(ge.innerHTML=gi),wn=n(l),Ks=p(l,"UL",{});var my=d(Ks);Ge=p(my,"LI",{});var NM=d(Ge);qM=C(NM,"We want to maximize our utility function $J(\\theta)$, but in PyTorch and TensorFlow, it’s better to "),Ps=p(NM,"STRONG",{"data-svelte-h":!0}),i(Ps)!=="svelte-147747o"&&(Ps.textContent=Gi),j=p(NM,"UL",{});var I=d(j);Ds=p(I,"LI",{"data-svelte-h":!0}),i(Ds)!=="svelte-1pp5ztk"&&(Ds.textContent=Zi),KM=n(I),B=p(I,"LI",{});var pt=d(B);PM=C(pt,"So we want to modify"),on=at(pt,!1),mn=C(pt," such that"),Tn=at(pt,!1),pt.forEach(s),DM=n(I),g=p(I,"LI",{});var it=d(g);OM=C(it,"Because all P must sum to 1, max"),rn=at(it,!1),cn=C(it," will "),Os=p(it,"STRONG",{"data-svelte-h":!0}),i(Os)!=="svelte-5xkb6z"&&(Os.textContent=vi),it.forEach(s),lp=n(I),lt=p(I,"LI",{});var pp=d(lt);ep=C(pp,"So we should tell PyTorch "),Ze=p(pp,"STRONG",{});var FM=d(Ze);sp=C(FM,"to min"),Un=at(FM,!1),hn=C(FM,"."),FM.forEach(s),pp.forEach(s),tp=n(I),ve=p(I,"LI",{});var LM=d(ve);ap=C(LM,"This loss function approaches 0 as"),jn=at(LM,!1),In=C(LM," nears 1."),LM.forEach(s),np=n(I),et=p(I,"LI",{});var ip=d(et);Mp=C(ip,"So we are encouraging the gradient to max"),un=at(ip,!1),ip.forEach(s),I.forEach(s),NM.forEach(s),my.forEach(s),dn=n(l),J(Ae.$$.fragment,l),Cn=n(l),J(_e.$$.fragment,l),bn=n(l),J(Xe.$$.fragment,l),fn=n(l),J(We.$$.fragment,l),Bn=n(l),ke=p(l,"UL",{"data-svelte-h":!0}),i(ke)!=="svelte-aryts0"&&(ke.innerHTML=Ai),gn=n(l),J(Se.$$.fragment,l),Gn=n(l),J(He.$$.fragment,l),Zn=n(l),J(Ve.$$.fragment,l),vn=n(l),J($e.$$.fragment,l),An=n(l),Qe=p(l,"UL",{"data-svelte-h":!0}),i(Qe)!=="svelte-1f2fdos"&&(Qe.innerHTML=_i),_n=n(l),J(Re.$$.fragment,l),Xn=n(l),J(Ee.$$.fragment,l),Wn=n(l),J(Ye.$$.fragment,l),kn=n(l),J(xe.$$.fragment,l),Sn=n(l),ze=p(l,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-13d1cnp"&&(ze.textContent=Xi),Hn=n(l),Ne=p(l,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-1ifum22"&&(Ne.textContent=Wi),Vn=n(l),st=p(l,"IMG",{src:!0}),$n=n(l),J(Fe.$$.fragment,l),Qn=n(l),J(Le.$$.fragment,l),Rn=n(l),J(qe.$$.fragment,l),En=n(l),J(Ke.$$.fragment,l),Yn=n(l),J(Pe.$$.fragment,l),xn=n(l),De=p(l,"P",{"data-svelte-h":!0}),i(De)!=="svelte-1ss5nh"&&(De.innerHTML=Si),zn=n(l),Oe=p(l,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-vgzxi7"&&(Oe.textContent=Hi),Nn=n(l),ls=p(l,"UL",{"data-svelte-h":!0}),i(ls)!=="svelte-bcjr5d"&&(ls.innerHTML=Vi),Fn=n(l),es=p(l,"P",{"data-svelte-h":!0}),i(es)!=="svelte-6k9qpu"&&(es.textContent=$i),Ln=n(l),ss=p(l,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-932u9c"&&(ss.innerHTML=Qi),qn=n(l),ts=p(l,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1cn3tld"&&(ts.textContent=Ri),Kn=n(l),as=p(l,"UL",{"data-svelte-h":!0}),i(as)!=="svelte-19b5tev"&&(as.innerHTML=Ei),Pn=n(l),ns=p(l,"IMG",{src:!0,alt:!0}),Dn=n(l),J(Ms.$$.fragment,l),On=n(l),ps=p(l,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-14yhksh"&&(ps.innerHTML=xi),lM=n(l),is=p(l,"P",{"data-svelte-h":!0}),i(is)!=="svelte-1enm9m5"&&(is.innerHTML=zi),eM=n(l),J(ys.$$.fragment,l),sM=n(l),Js=p(l,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-s4clfq"&&(Js.textContent=Ni),tM=n(l),J(ws.$$.fragment,l),aM=n(l),J(os.$$.fragment,l),nM=n(l),ms=p(l,"UL",{"data-svelte-h":!0}),i(ms)!=="svelte-19tqm2y"&&(ms.innerHTML=Fi),MM=n(l),J(Ts.$$.fragment,l),pM=n(l),J(rs.$$.fragment,l),iM=n(l),J(cs.$$.fragment,l),yM=n(l),Us=p(l,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-xr9zu2"&&(Us.textContent=Li),JM=n(l),hs=p(l,"UL",{"data-svelte-h":!0}),i(hs)!=="svelte-hfzbwg"&&(hs.innerHTML=qi),wM=n(l),js=p(l,"P",{"data-svelte-h":!0}),i(js)!=="svelte-1j0vapy"&&(js.textContent=Ki),oM=n(l),Is=p(l,"UL",{"data-svelte-h":!0}),i(Is)!=="svelte-109j46n"&&(Is.innerHTML=Pi),mM=n(l),us=p(l,"P",{"data-svelte-h":!0}),i(us)!=="svelte-1kwknxb"&&(us.textContent=Di),TM=n(l),ds=p(l,"UL",{"data-svelte-h":!0}),i(ds)!=="svelte-14go64c"&&(ds.innerHTML=Oi),rM=n(l),J(Cs.$$.fragment,l),cM=n(l),bs=p(l,"UL",{"data-svelte-h":!0}),i(bs)!=="svelte-kjz32c"&&(bs.innerHTML=ly),UM=n(l),J(fs.$$.fragment,l),hM=n(l),J(Bs.$$.fragment,l),jM=n(l),J(gs.$$.fragment,l),IM=n(l),J(Gs.$$.fragment,l),uM=n(l),Zs=p(l,"UL",{"data-svelte-h":!0}),i(Zs)!=="svelte-4ebgyj"&&(Zs.innerHTML=ey),dM=n(l),J(vs.$$.fragment,l),CM=n(l),J(As.$$.fragment,l),bM=n(l),_s=p(l,"UL",{"data-svelte-h":!0}),i(_s)!=="svelte-c51ubm"&&(_s.innerHTML=sy),fM=n(l),J(Xs.$$.fragment,l),BM=n(l),J(Ws.$$.fragment,l),gM=n(l),J(ks.$$.fragment,l),GM=n(l),J(Ss.$$.fragment,l),ZM=n(l),J(Hs.$$.fragment,l),vM=n(l),Vs=p(l,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-h9supy"&&(Vs.innerHTML=ty),AM=n(l),$s=p(l,"P",{"data-svelte-h":!0}),i($s)!=="svelte-131ixzr"&&($s.innerHTML=ay),_M=n(l),Qs=p(l,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-1uth36j"&&(Qs.textContent=ny),XM=n(l),Rs=p(l,"UL",{"data-svelte-h":!0}),i(Rs)!=="svelte-su8kur"&&(Rs.innerHTML=My),WM=n(l),kM=p(l,"HR",{}),SM=n(l),Es=p(l,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-jb70tl"&&(Es.innerHTML=py),HM=n(l),Ys=p(l,"P",{"data-svelte-h":!0}),i(Ys)!=="svelte-h09rnt"&&(Ys.innerHTML=iy),VM=n(l),xs=p(l,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-st4ijf"&&(xs.innerHTML=yy),$M=n(l),zs=p(l,"P",{"data-svelte-h":!0}),i(zs)!=="svelte-2auufk"&&(zs.textContent=Jy),QM=n(l),Ns=p(l,"P",{"data-svelte-h":!0}),i(Ns)!=="svelte-ol1ouv"&&(Ns.innerHTML=wy),RM=n(l),Fs=p(l,"P",{"data-svelte-h":!0}),i(Fs)!=="svelte-kyrcnn"&&(Fs.textContent=oy),EM=n(l),J(Ls.$$.fragment,l),YM=n(l),J(qs.$$.fragment,l),xM=n(l),Mt=p(l,"P",{}),d(Mt).forEach(s),this.h()},h(){h(b,"name","hf:doc:metadata"),h(b,"content",Zy),h(f,"class","image table text-center m-0 w-full"),G(x.src,Cp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/thumbnail.png")||h(x,"src",Cp),h(x,"alt","thumbnail"),G(P.src,vp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/envs.gif")||h(P,"src",vp),h(P,"alt","Environments"),G(rl.src,Rp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||h(rl,"src",Rp),h(rl,"alt","GPU Step 1"),G(Ul.src,Yp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||h(Ul,"src",Yp),h(Ul,"alt","GPU Step 2"),G(pe.src,Ti="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/reinforce.png")||h(pe,"src",Ti),h(pe,"alt","Reinforce"),G(be.src,bi="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/pg_pseudocode.png")||h(be,"src",bi),h(be,"alt","Policy gradient pseudocode"),on.a=mn,Tn.a=null,rn.a=cn,Un.a=hn,jn.a=In,un.a=null,G(st.src,ki="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/modelcard.png")||h(st,"src",ki),G(ns.src,Yi="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||h(ns,"src",Yi),h(ns,"alt","Create HF Token")},m(l,e){U(document.head,b),t(l,yt,e),t(l,nt,e),t(l,Jt,e),w(Z,l,e),t(l,wt,e),w(v,l,e),t(l,ot,e),t(l,A,e),t(l,mt,e),t(l,_,e),t(l,Tt,e),t(l,f,e),t(l,rt,e),t(l,X,e),t(l,ct,e),t(l,W,e),t(l,Ut,e),t(l,k,e),t(l,ht,e),t(l,S,e),t(l,jt,e),t(l,H,e),t(l,It,e),t(l,V,e),t(l,ut,e),t(l,$,e),t(l,dt,e),t(l,Q,e),t(l,Ct,e),t(l,R,e),t(l,bt,e),t(l,E,e),t(l,ft,e),w(Y,l,e),t(l,Bt,e),t(l,x,e),t(l,gt,e),t(l,z,e),t(l,Gt,e),t(l,N,e),t(l,Zt,e),t(l,F,e),t(l,vt,e),t(l,L,e),t(l,At,e),t(l,q,e),t(l,_t,e),t(l,K,e),t(l,Xt,e),t(l,P,e),t(l,Wt,e),w(D,l,e),t(l,kt,e),t(l,O,e),t(l,St,e),w(ll,l,e),t(l,Ht,e),t(l,el,e),t(l,Vt,e),t(l,sl,e),t(l,$t,e),w(tl,l,e),t(l,Qt,e),t(l,al,e),t(l,Rt,e),t(l,nl,e),t(l,Et,e),w(Ml,l,e),t(l,Yt,e),t(l,pl,e),t(l,xt,e),t(l,il,e),t(l,zt,e),w(yl,l,e),t(l,Nt,e),w(Jl,l,e),t(l,Ft,e),t(l,wl,e),t(l,Lt,e),t(l,ol,e),t(l,qt,e),w(ml,l,e),t(l,Kt,e),t(l,Tl,e),t(l,Pt,e),t(l,rl,e),t(l,Dt,e),t(l,cl,e),t(l,Ot,e),t(l,Ul,e),t(l,la,e),w(hl,l,e),t(l,ea,e),t(l,jl,e),t(l,sa,e),t(l,Il,e),t(l,ta,e),w(ul,l,e),t(l,aa,e),w(dl,l,e),t(l,na,e),w(Cl,l,e),t(l,Ma,e),t(l,bl,e),t(l,pa,e),t(l,fl,e),t(l,ia,e),t(l,Bl,e),t(l,ya,e),t(l,gl,e),t(l,Ja,e),t(l,Gl,e),t(l,wa,e),t(l,Zl,e),t(l,oa,e),t(l,vl,e),t(l,ma,e),t(l,Al,e),t(l,Ta,e),w(_l,l,e),t(l,ra,e),w(Xl,l,e),t(l,ca,e),t(l,Wl,e),t(l,Ua,e),t(l,kl,e),t(l,ha,e),w(Sl,l,e),t(l,ja,e),w(Hl,l,e),t(l,Ia,e),t(l,Vl,e),t(l,ua,e),w($l,l,e),t(l,da,e),w(Ql,l,e),t(l,Ca,e),t(l,Rl,e),t(l,ba,e),w(El,l,e),t(l,fa,e),w(Yl,l,e),t(l,Ba,e),w(xl,l,e),t(l,ga,e),w(zl,l,e),t(l,Ga,e),t(l,Nl,e),t(l,Za,e),t(l,Fl,e),t(l,va,e),t(l,Ll,e),t(l,Aa,e),w(ql,l,e),t(l,_a,e),t(l,Kl,e),t(l,Xa,e),t(l,Pl,e),t(l,Wa,e),t(l,Dl,e),t(l,ka,e),t(l,Ol,e),t(l,Sa,e),t(l,le,e),t(l,Ha,e),w(ee,l,e),t(l,Va,e),w(se,l,e),t(l,$a,e),w(te,l,e),t(l,Qa,e),w(ae,l,e),t(l,Ra,e),t(l,ne,e),t(l,Ea,e),t(l,Me,e),t(l,Ya,e),t(l,pe,e),t(l,xa,e),t(l,ie,e),t(l,za,e),t(l,ye,e),t(l,Na,e),w(Je,l,e),t(l,Fa,e),w(we,l,e),t(l,La,e),w(oe,l,e),t(l,qa,e),t(l,me,e),t(l,Ka,e),t(l,Te,e),t(l,Pa,e),w(re,l,e),t(l,Da,e),t(l,ce,e),t(l,Oa,e),t(l,Ue,e),t(l,ln,e),w(he,l,e),t(l,en,e),w(je,l,e),t(l,sn,e),t(l,Ie,e),t(l,tn,e),t(l,ue,e),t(l,an,e),w(de,l,e),t(l,nn,e),t(l,Ce,e),t(l,Mn,e),t(l,be,e),t(l,pn,e),t(l,fe,e),t(l,yn,e),t(l,Be,e),t(l,Jn,e),t(l,ge,e),t(l,wn,e),t(l,Ks,e),U(Ks,Ge),U(Ge,qM),U(Ge,Ps),U(Ge,j),U(j,Ds),U(j,KM),U(j,B),U(B,PM),on.m(Ty,B),U(B,mn),Tn.m(ry,B),U(j,DM),U(j,g),U(g,OM),rn.m(cy,g),U(g,cn),U(g,Os),U(j,lp),U(j,lt),U(lt,ep),U(lt,Ze),U(Ze,sp),Un.m(Uy,Ze),U(Ze,hn),U(j,tp),U(j,ve),U(ve,ap),jn.m(hy,ve),U(ve,In),U(j,np),U(j,et),U(et,Mp),un.m(jy,et),t(l,dn,e),w(Ae,l,e),t(l,Cn,e),w(_e,l,e),t(l,bn,e),w(Xe,l,e),t(l,fn,e),w(We,l,e),t(l,Bn,e),t(l,ke,e),t(l,gn,e),w(Se,l,e),t(l,Gn,e),w(He,l,e),t(l,Zn,e),w(Ve,l,e),t(l,vn,e),w($e,l,e),t(l,An,e),t(l,Qe,e),t(l,_n,e),w(Re,l,e),t(l,Xn,e),w(Ee,l,e),t(l,Wn,e),w(Ye,l,e),t(l,kn,e),w(xe,l,e),t(l,Sn,e),t(l,ze,e),t(l,Hn,e),t(l,Ne,e),t(l,Vn,e),t(l,st,e),t(l,$n,e),w(Fe,l,e),t(l,Qn,e),w(Le,l,e),t(l,Rn,e),w(qe,l,e),t(l,En,e),w(Ke,l,e),t(l,Yn,e),w(Pe,l,e),t(l,xn,e),t(l,De,e),t(l,zn,e),t(l,Oe,e),t(l,Nn,e),t(l,ls,e),t(l,Fn,e),t(l,es,e),t(l,Ln,e),t(l,ss,e),t(l,qn,e),t(l,ts,e),t(l,Kn,e),t(l,as,e),t(l,Pn,e),t(l,ns,e),t(l,Dn,e),w(Ms,l,e),t(l,On,e),t(l,ps,e),t(l,lM,e),t(l,is,e),t(l,eM,e),w(ys,l,e),t(l,sM,e),t(l,Js,e),t(l,tM,e),w(ws,l,e),t(l,aM,e),w(os,l,e),t(l,nM,e),t(l,ms,e),t(l,MM,e),w(Ts,l,e),t(l,pM,e),w(rs,l,e),t(l,iM,e),w(cs,l,e),t(l,yM,e),t(l,Us,e),t(l,JM,e),t(l,hs,e),t(l,wM,e),t(l,js,e),t(l,oM,e),t(l,Is,e),t(l,mM,e),t(l,us,e),t(l,TM,e),t(l,ds,e),t(l,rM,e),w(Cs,l,e),t(l,cM,e),t(l,bs,e),t(l,UM,e),w(fs,l,e),t(l,hM,e),w(Bs,l,e),t(l,jM,e),w(gs,l,e),t(l,IM,e),w(Gs,l,e),t(l,uM,e),t(l,Zs,e),t(l,dM,e),w(vs,l,e),t(l,CM,e),w(As,l,e),t(l,bM,e),t(l,_s,e),t(l,fM,e),w(Xs,l,e),t(l,BM,e),w(Ws,l,e),t(l,gM,e),w(ks,l,e),t(l,GM,e),w(Ss,l,e),t(l,ZM,e),w(Hs,l,e),t(l,vM,e),t(l,Vs,e),t(l,AM,e),t(l,$s,e),t(l,_M,e),t(l,Qs,e),t(l,XM,e),t(l,Rs,e),t(l,WM,e),t(l,kM,e),t(l,SM,e),t(l,Es,e),t(l,HM,e),t(l,Ys,e),t(l,VM,e),t(l,xs,e),t(l,$M,e),t(l,zs,e),t(l,QM,e),t(l,Ns,e),t(l,RM,e),t(l,Fs,e),t(l,EM,e),w(Ls,l,e),t(l,YM,e),w(qs,l,e),t(l,xM,e),t(l,Mt,e),zM=!0},p:uy,i(l){zM||(o(Z.$$.fragment,l),o(v.$$.fragment,l),o(Y.$$.fragment,l),o(D.$$.fragment,l),o(ll.$$.fragment,l),o(tl.$$.fragment,l),o(Ml.$$.fragment,l),o(yl.$$.fragment,l),o(Jl.$$.fragment,l),o(ml.$$.fragment,l),o(hl.$$.fragment,l),o(ul.$$.fragment,l),o(dl.$$.fragment,l),o(Cl.$$.fragment,l),o(_l.$$.fragment,l),o(Xl.$$.fragment,l),o(Sl.$$.fragment,l),o(Hl.$$.fragment,l),o($l.$$.fragment,l),o(Ql.$$.fragment,l),o(El.$$.fragment,l),o(Yl.$$.fragment,l),o(xl.$$.fragment,l),o(zl.$$.fragment,l),o(ql.$$.fragment,l),o(ee.$$.fragment,l),o(se.$$.fragment,l),o(te.$$.fragment,l),o(ae.$$.fragment,l),o(Je.$$.fragment,l),o(we.$$.fragment,l),o(oe.$$.fragment,l),o(re.$$.fragment,l),o(he.$$.fragment,l),o(je.$$.fragment,l),o(de.$$.fragment,l),o(Ae.$$.fragment,l),o(_e.$$.fragment,l),o(Xe.$$.fragment,l),o(We.$$.fragment,l),o(Se.$$.fragment,l),o(He.$$.fragment,l),o(Ve.$$.fragment,l),o($e.$$.fragment,l),o(Re.$$.fragment,l),o(Ee.$$.fragment,l),o(Ye.$$.fragment,l),o(xe.$$.fragment,l),o(Fe.$$.fragment,l),o(Le.$$.fragment,l),o(qe.$$.fragment,l),o(Ke.$$.fragment,l),o(Pe.$$.fragment,l),o(Ms.$$.fragment,l),o(ys.$$.fragment,l),o(ws.$$.fragment,l),o(os.$$.fragment,l),o(Ts.$$.fragment,l),o(rs.$$.fragment,l),o(cs.$$.fragment,l),o(Cs.$$.fragment,l),o(fs.$$.fragment,l),o(Bs.$$.fragment,l),o(gs.$$.fragment,l),o(Gs.$$.fragment,l),o(vs.$$.fragment,l),o(As.$$.fragment,l),o(Xs.$$.fragment,l),o(Ws.$$.fragment,l),o(ks.$$.fragment,l),o(Ss.$$.fragment,l),o(Hs.$$.fragment,l),o(Ls.$$.fragment,l),o(qs.$$.fragment,l),zM=!0)},o(l){m(Z.$$.fragment,l),m(v.$$.fragment,l),m(Y.$$.fragment,l),m(D.$$.fragment,l),m(ll.$$.fragment,l),m(tl.$$.fragment,l),m(Ml.$$.fragment,l),m(yl.$$.fragment,l),m(Jl.$$.fragment,l),m(ml.$$.fragment,l),m(hl.$$.fragment,l),m(ul.$$.fragment,l),m(dl.$$.fragment,l),m(Cl.$$.fragment,l),m(_l.$$.fragment,l),m(Xl.$$.fragment,l),m(Sl.$$.fragment,l),m(Hl.$$.fragment,l),m($l.$$.fragment,l),m(Ql.$$.fragment,l),m(El.$$.fragment,l),m(Yl.$$.fragment,l),m(xl.$$.fragment,l),m(zl.$$.fragment,l),m(ql.$$.fragment,l),m(ee.$$.fragment,l),m(se.$$.fragment,l),m(te.$$.fragment,l),m(ae.$$.fragment,l),m(Je.$$.fragment,l),m(we.$$.fragment,l),m(oe.$$.fragment,l),m(re.$$.fragment,l),m(he.$$.fragment,l),m(je.$$.fragment,l),m(de.$$.fragment,l),m(Ae.$$.fragment,l),m(_e.$$.fragment,l),m(Xe.$$.fragment,l),m(We.$$.fragment,l),m(Se.$$.fragment,l),m(He.$$.fragment,l),m(Ve.$$.fragment,l),m($e.$$.fragment,l),m(Re.$$.fragment,l),m(Ee.$$.fragment,l),m(Ye.$$.fragment,l),m(xe.$$.fragment,l),m(Fe.$$.fragment,l),m(Le.$$.fragment,l),m(qe.$$.fragment,l),m(Ke.$$.fragment,l),m(Pe.$$.fragment,l),m(Ms.$$.fragment,l),m(ys.$$.fragment,l),m(ws.$$.fragment,l),m(os.$$.fragment,l),m(Ts.$$.fragment,l),m(rs.$$.fragment,l),m(cs.$$.fragment,l),m(Cs.$$.fragment,l),m(fs.$$.fragment,l),m(Bs.$$.fragment,l),m(gs.$$.fragment,l),m(Gs.$$.fragment,l),m(vs.$$.fragment,l),m(As.$$.fragment,l),m(Xs.$$.fragment,l),m(Ws.$$.fragment,l),m(ks.$$.fragment,l),m(Ss.$$.fragment,l),m(Hs.$$.fragment,l),m(Ls.$$.fragment,l),m(qs.$$.fragment,l),zM=!1},d(l){l&&(s(yt),s(nt),s(Jt),s(wt),s(ot),s(A),s(mt),s(_),s(Tt),s(f),s(rt),s(X),s(ct),s(W),s(Ut),s(k),s(ht),s(S),s(jt),s(H),s(It),s(V),s(ut),s($),s(dt),s(Q),s(Ct),s(R),s(bt),s(E),s(ft),s(Bt),s(x),s(gt),s(z),s(Gt),s(N),s(Zt),s(F),s(vt),s(L),s(At),s(q),s(_t),s(K),s(Xt),s(P),s(Wt),s(kt),s(O),s(St),s(Ht),s(el),s(Vt),s(sl),s($t),s(Qt),s(al),s(Rt),s(nl),s(Et),s(Yt),s(pl),s(xt),s(il),s(zt),s(Nt),s(Ft),s(wl),s(Lt),s(ol),s(qt),s(Kt),s(Tl),s(Pt),s(rl),s(Dt),s(cl),s(Ot),s(Ul),s(la),s(ea),s(jl),s(sa),s(Il),s(ta),s(aa),s(na),s(Ma),s(bl),s(pa),s(fl),s(ia),s(Bl),s(ya),s(gl),s(Ja),s(Gl),s(wa),s(Zl),s(oa),s(vl),s(ma),s(Al),s(Ta),s(ra),s(ca),s(Wl),s(Ua),s(kl),s(ha),s(ja),s(Ia),s(Vl),s(ua),s(da),s(Ca),s(Rl),s(ba),s(fa),s(Ba),s(ga),s(Ga),s(Nl),s(Za),s(Fl),s(va),s(Ll),s(Aa),s(_a),s(Kl),s(Xa),s(Pl),s(Wa),s(Dl),s(ka),s(Ol),s(Sa),s(le),s(Ha),s(Va),s($a),s(Qa),s(Ra),s(ne),s(Ea),s(Me),s(Ya),s(pe),s(xa),s(ie),s(za),s(ye),s(Na),s(Fa),s(La),s(qa),s(me),s(Ka),s(Te),s(Pa),s(Da),s(ce),s(Oa),s(Ue),s(ln),s(en),s(sn),s(Ie),s(tn),s(ue),s(an),s(nn),s(Ce),s(Mn),s(be),s(pn),s(fe),s(yn),s(Be),s(Jn),s(ge),s(wn),s(Ks),s(dn),s(Cn),s(bn),s(fn),s(Bn),s(ke),s(gn),s(Gn),s(Zn),s(vn),s(An),s(Qe),s(_n),s(Xn),s(Wn),s(kn),s(Sn),s(ze),s(Hn),s(Ne),s(Vn),s(st),s($n),s(Qn),s(Rn),s(En),s(Yn),s(xn),s(De),s(zn),s(Oe),s(Nn),s(ls),s(Fn),s(es),s(Ln),s(ss),s(qn),s(ts),s(Kn),s(as),s(Pn),s(ns),s(Dn),s(On),s(ps),s(lM),s(is),s(eM),s(sM),s(Js),s(tM),s(aM),s(nM),s(ms),s(MM),s(pM),s(iM),s(yM),s(Us),s(JM),s(hs),s(wM),s(js),s(oM),s(Is),s(mM),s(us),s(TM),s(ds),s(rM),s(cM),s(bs),s(UM),s(hM),s(jM),s(IM),s(uM),s(Zs),s(dM),s(CM),s(bM),s(_s),s(fM),s(BM),s(gM),s(GM),s(ZM),s(vM),s(Vs),s(AM),s($s),s(_M),s(Qs),s(XM),s(Rs),s(WM),s(kM),s(SM),s(Es),s(HM),s(Ys),s(VM),s(xs),s($M),s(zs),s(QM),s(Ns),s(RM),s(Fs),s(EM),s(YM),s(xM),s(Mt)),s(b),T(Z,l),T(v,l),T(Y,l),T(D,l),T(ll,l),T(tl,l),T(Ml,l),T(yl,l),T(Jl,l),T(ml,l),T(hl,l),T(ul,l),T(dl,l),T(Cl,l),T(_l,l),T(Xl,l),T(Sl,l),T(Hl,l),T($l,l),T(Ql,l),T(El,l),T(Yl,l),T(xl,l),T(zl,l),T(ql,l),T(ee,l),T(se,l),T(te,l),T(ae,l),T(Je,l),T(we,l),T(oe,l),T(re,l),T(he,l),T(je,l),T(de,l),T(Ae,l),T(_e,l),T(Xe,l),T(We,l),T(Se,l),T(He,l),T(Ve,l),T($e,l),T(Re,l),T(Ee,l),T(Ye,l),T(xe,l),T(Fe,l),T(Le,l),T(qe,l),T(Ke,l),T(Pe,l),T(Ms,l),T(ys,l),T(ws,l),T(os,l),T(Ts,l),T(rs,l),T(cs,l),T(Cs,l),T(fs,l),T(Bs,l),T(gs,l),T(Gs,l),T(vs,l),T(As,l),T(Xs,l),T(Ws,l),T(ks,l),T(Ss,l),T(Hs,l),T(Ls,l),T(qs,l)}}}const Zy='{"title":"Hands on","local":"hands-on","sections":[],"depth":1}';function vy(yp){return dy(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sy extends Cy{constructor(b){super(),by(this,b,vy,Gy,Iy,{})}}export{Sy as component};
