import{s as Pt,a as ut,n as el,o as tl}from"../chunks/scheduler.ef843396.js";import{S as ll,i as sl,e as o,s as n,c as r,h as nl,a as i,d as l,b as a,f as wt,g as p,j as c,k as y,l as al,m as s,n as d,t as M,o as m,p as h}from"../chunks/index.05ef1181.js";import{C as yt}from"../chunks/CodeBlock.096de90c.js";import{H as w,E as ol}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ef6649bf.js";function il(Ut){let U,ue,he,we,f,Ue,v,Jt='To get started, download the project from <a href="https://huggingface.co/ivan267/imitation-learning-tutorial-godot-project/tree/main" rel="nofollow">here</a> (click on the download icon next to <code>GDRL-IL-Project.zip</code>). The zip file features both the “Starter” and “Complete” projects.',Je,Z,bt="The game code is already implemented in the starter project and the nodes are configured. We will focus on:",be,I,Tt="<li>Implementing the code for the AIController node,</li> <li>Recording expert demonstrations,</li> <li>Training the agent and exporting an .onnx file which we can use for inference in Godot.</li>",Te,G,je,_,jt="Extract the zip file, open Godot, click “Import” and navigate to the <code>Starter\\Godot</code> folder of the extracted archive.",fe,W,ve,J,ft="<p>You can search for “robot” in the FileSystem search.</p>",Ze,g,vt="This scene contains a couple of different nodes, including the <code>robot</code> node, which contains the visual shape of the robot, <code>CameraXRotation</code> node which is used to rotate the camera “up-down” using the mouse in human control modes. The AI agent does not control this node since it is not necessary for learning the task. <code>RaycastSensors</code> node contains two Raycast sensors that help the agent to “sense” parts of the game world, including walls, floors, etc.",Ie,k,Zt,Ge,S,_e,b,It="<p>You might have to collapse the “robot” branch to find it more easily, or you can type <code>aicontroller</code> in the Filter box above the <code>Robot</code> node.</p>",We,B,ge,X,ke,V,Gt="In <code>get_obs()</code>, we first get the obs from the two Raycast sensors added to the <code>AIController3D</code> node in the inspector, and add them to the obs, then we get the relative position vectors to chest, lever, key, and raft, which we separate into directions and distances, and then we add them to the obs as well.",Se,C,_t="We also add other game state info to the obs:",Be,Y,Wt="<li>has the lever has been pulled,</li> <li>was the key collected,</li> <li>was the chest opened,</li> <li>is the player on floor (also determines whether the player can jump),</li> <li>the normalized local velocity of the player.</li>",Xe,Q,gt="We convert boolean values such as <code>_is_lever_pulled</code> to floats (0 or 1).",Ve,x,kt="In <code>get_reward()</code>, we only need to return the current reward.",Ce,R,Ye,E,Qe,N,xe,F,Re,A,St="For <code>get_action()</code> (only needed if using the demo record mode), we need to provide the actions that we want the agent to send when it encounters the same state. It is important for the values to be in the correct range (<code>-1.0 to 1.0</code>), which is why we have the <code>-1 + 2 * variable</code> for boolean states, and in the correct order, as defined in <code>get_action_space()</code>.",Ee,z,Bt="In demo record mode, <code>set_action()</code> is called without providing actions, as we need to set the action values based on human input. In training/inference modes, the method is called with an <code>action</code> argument containing values for all of the actions provided by the RL model, so we have an <code>if/else</code> to handle both cases.",Ne,$,Xt="More info is included in the code comments.",Fe,H,Ae,D,ze,O,Vt="This code part records mouse movement in case of human control and demo record modes.",$e,L,Ct="<strong>Finally, save the script. We are ready for the next step.</strong>",He,q,De,T,Yt="<p>You can search for “demo” in the FileSystem search, and you can search for “aicontroller” in the scene’s filter box.</p>",Oe,K,Qt,Le,P,xt="You don’t need to make any changes as everything is preset, but let’s go over the things you would need to set in your own env:",qe,ee,Rt="The scene contains modified <code>Level &gt; Robot &gt; AIController3D</code> node settings:",Ke,te,Et="<li><code>Control Mode</code> is set to <code>Record Expert Demos</code></li> <li><code>Expert Demo Save Path</code> is filled out</li> <li><code>Action Repeat</code> is set to the same value as is set for the <code>Sync</code> node in <code>training_scene</code> and <code>onnx_inference_scene</code>. This means that every action set by the agent is repeated for 3 physics frames. The setting in <code>AIController</code> adds the same action repeat to the human input (which introduces some lag) to match the same behavior. This is a fairly low value which doesn’t introduce much lag. If you change this value, make sure to change it in all 3 places.</li> <li><code>Remove Last Episode</code> key allows us to set a key that can be used to remove a failed episode during recording, without having to restart the entire session. E.g. if the robot falls in the water and the game resets, we can use this key to remove the previously recorded episode while recording the next one. It is set to <code>R</code>, but you can change it to any key by clicking on it, and then clicking on the <code>Configure</code> button.</li>",Pe,le,Nt="Another way to make episode recording easier in challenging environments is to slow down the environment during recording. This can easily be done by clicking on the <code>Sync</code> node in the scene, and adjusting the <code>Speed Up</code> property (set to 1 by default).",et,se,tt,j,Ft="<p>Note that the demos will only be saved if we have recorded at least one complete episode and closed the game window by clicking on “X” or pressing ALT+F4. Using the stop button in Godot editor will not save the demos. It’s best to try recording just one episode first, then check if you see “expert_demos.json” in the filesystem or in the Godot project folder.</p>",lt,ne,At="Make sure that you are still in the <code>demo_record_scene</code>, <code>press F6</code> and the demo recording will start.",st,ae,zt="Controls:",nt,oe,$t="<li>mouse controls the camera (if you need to adjust mouse sensitivity, open the <code>robot</code> scene, click on the <code>Robot</code> node and adjust the <code>Rotation Speed</code>, keep it the same value for recording demos, training and inference),</li> <li><code>WASD</code> controls the player movement,</li> <li><code>SPACE</code> jumps,</li> <li><code>E</code> activates the lever and opens the chest</li>",at,ie,Ht="You can take a few practice first to get familiar with the env. If you wish to skip recording demos, you can also find the pre-recorded demos in the completed project and use the <code>expert_demos.json</code> file from there.",ot,ce,Dt="The recorded demos should include at least 22-24 complete successful episodes. Multiple demo files can also be used in the training stage, so you don’t have to record all demos in one go (you can change the file name using the <code>Expert Demo Save Path</code> property mentioned before).",it,re,Ot="Recording 23 episodes took me ~10 minutes (as the key has 2 alternating spawning positions, 22 or 24 would provide an equal distribution of key positions in the demos, but it is fairly close). When approaching the lever or chest, I pressed and held the <code>E</code> key slightly longer to ensure the action is recorded for multiple steps when near those objects. I also removed a couple of episodes that I didn’t complete successfully by pressing the <code>R</code> key during the following episode.",ct,pe,Lt="Here’s a sped-up video of the demo recording process:",rt,u,qt,pt,de,dt,Me,Kt="You can export the game from Godot using <code>Project &gt; Export</code>.",Mt,me,mt,ye,ht;return f=new w({props:{title:"Getting started:",local:"getting-started",headingTag:"h1"}}),G=new w({props:{title:"Open the starter project in Godot",local:"open-the-starter-project-in-godot",headingTag:"h3"}}),W=new w({props:{title:"Open the robot scene",local:"open-the-robot-scene",headingTag:"h3"}}),S=new w({props:{title:"Click on the scroll next to AIController3D to open the script for editing",local:"click-on-the-scroll-next-to-aicontroller3d-to-open-the-script-for-editing",headingTag:"h3"}}),B=new w({props:{title:"Replace the get_obs() and get_reward() methods with the implementation below:",local:"replace-the-getobs-and-getreward-methods-with-the-implementation-below",headingTag:"h3"}}),X=new yt({props:{code:"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",highlighted:`func get_obs() -&gt; Dictionary:
	var observations: Array[<span class="hljs-built_in">float</span>] = []
	<span class="hljs-keyword">for</span> raycast_sensor <span class="hljs-keyword">in</span> raycast_sensors:
		observations.append_array(raycast_sensor.get_observation())

	var level_size = <span class="hljs-number">16.0</span>

	var chest_local = to_local(chest.global_position)
	var chest_direction = chest_local.normalized()
	var chest_distance = clampf(chest_local.length(), <span class="hljs-number">0.0</span>, level_size)
	
	var lever_local = to_local(lever.global_position)
	var lever_direction = lever_local.normalized()
	var lever_distance = clampf(lever_local.length(), <span class="hljs-number">0.0</span>, level_size)
		
	var key_local = to_local(key.global_position)
	var key_direction = key_local.normalized()
	var key_distance = clampf(key_local.length(), <span class="hljs-number">0.0</span>, level_size)
	
	var raft_local = to_local(raft.global_position)
	var raft_direction = raft_local.normalized()
	var raft_distance = clampf(raft_local.length(), <span class="hljs-number">0.0</span>, level_size)
	
	var player_speed = player.global_basis.inverse() * player.velocity.limit_length(<span class="hljs-number">5.0</span>) / <span class="hljs-number">5.0</span>

	(
		observations
		.append_array(
			[
				chest_direction.x,
				chest_direction.y,
				chest_direction.z,
				chest_distance,
				lever_direction.x,
				lever_direction.y,
				lever_direction.z,
				lever_distance,
				key_direction.x,
				key_direction.y,
				key_direction.z,
				key_distance,
				raft_direction.x,
				raft_direction.y,
				raft_direction.z,
				raft_distance,
				raft.movement_direction_multiplier,
				<span class="hljs-built_in">float</span>(player._is_lever_pulled),
				<span class="hljs-built_in">float</span>(player._is_chest_opened),
				<span class="hljs-built_in">float</span>(player._is_key_collected),
				<span class="hljs-built_in">float</span>(player.is_on_floor()),
				player_speed.x,
				player_speed.y,
				player_speed.z,
			]
		)
	)
	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>: observations}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">return</span> reward`,wrap:!1}}),R=new w({props:{title:"Replace the _physics_process() and reset() methods with the implementation below:",local:"replace-the-physicsprocess-and-reset-methods-with-the-implementation-below",headingTag:"h3"}}),E=new yt({props:{code:"ZnVuYyUyMF9waHlzaWNzX3Byb2Nlc3MoZGVsdGElM0ElMjBmbG9hdCklMjAtJTNFJTIwdm9pZCUzQSUwQSUwOSUyMyUyMFJlc2V0JTIwb24lMjB0aW1lb3V0JTJDJTIwdGhpcyUyMGlzJTIwaW1wbGVtZW50ZWQlMjBpbiUyMHBhcmVudCUyMGNsYXNzJTIwdG8lMjBzZXQlMjBuZWVkc19yZXNldCUyMHRvJTIwdHJ1ZSUyQyUwQSUwOSUyMyUyMHdlJTIwYXJlJTIwcmUtaW1wbGVtZW50aW5nJTIwaGVyZSUyMHRvJTIwY2FsbCUyMHBsYXllci5nYW1lX292ZXIoKSUyMHRoYXQlMjBoYW5kbGVzJTIwdGhlJTIwZ2FtZSUyMHJlc2V0LiUwQSUwOW5fc3RlcHMlMjAlMkIlM0QlMjAxJTBBJTA5aWYlMjBuX3N0ZXBzJTIwJTNFJTIwcmVzZXRfYWZ0ZXIlM0ElMEElMDklMDlwbGF5ZXIuZ2FtZV9vdmVyKCklMEElMEElMDklMjMlMjBJbiUyMHRyYWluaW5nJTIwb3IlMjBvbm54JTIwaW5mZXJlbmNlJTIwbW9kZXMlMkMlMjB0aGlzJTIwbWV0aG9kJTIwd2lsbCUyMGJlJTIwY2FsbGVkJTIwYnklMjBzeW5jJTIwbm9kZSUyMHdpdGglMjBhY3Rpb25zJTIwcHJvdmlkZWQlMkMlMEElMDklMjMlMjBGb3IlMjBleHBlcnQlMjBkZW1vJTIwcmVjb3JkaW5nJTIwbW9kZSUyQyUyMGl0JTIwd2lsbCUyMGJlJTIwY2FsbGVkJTIwd2l0aG91dCUyMGFueSUyMGFjdGlvbnMlMjAoYXMlMjB3ZSUyMHNldCUyMHRoZSUyMGFjdGlvbnMlMjBiYXNlZCUyMG9uJTIwaHVtYW4lMjBpbnB1dCklMkMlMEElMDklMjMlMjBGb3IlMjBodW1hbiUyMGNvbnRyb2wlMjBtb2RlJTIwdGhlJTIwbWV0aG9kJTIwd2lsbCUyMG5vdCUyMGJlJTIwY2FsbGVkJTJDJTIwc28lMjB3ZSUyMGNhbGwlMjBpdCUyMGhlcmUlMjB3aXRob3V0JTIwYW55JTIwYWN0aW9ucyUyMHByb3ZpZGVkLiUwQSUwOWlmJTIwY29udHJvbF9tb2RlJTIwJTNEJTNEJTIwQ29udHJvbE1vZGVzLkhVTUFOJTNBJTBBJTA5JTA5c2V0X2FjdGlvbigpJTBBJTBBJTA5JTIzJTIwUmVzZXQlMjB0aGUlMjBnYW1lJTIwZmFzdGVyJTIwaWYlMjB0aGUlMjBsZXZlciUyMGlzJTIwbm90JTIwcHVsbGVkLiUwQSUwOXN0ZXBzX3dpdGhvdXRfbGV2ZXJfcHVsbGVkJTIwJTJCJTNEJTIwMSUwQSUwOWlmJTIwc3RlcHNfd2l0aG91dF9sZXZlcl9wdWxsZWQlMjAlM0UlMjAyMDAlMjBhbmQlMjAobm90JTIwcGxheWVyLl9pc19sZXZlcl9wdWxsZWQpJTNBJTBBJTA5JTA5cGxheWVyLmdhbWVfb3ZlcigpJTBBJTBBZnVuYyUyMHJlc2V0KCklM0ElMEElMDlzdXBlci5yZXNldCgpJTBBJTA5c3RlcHNfd2l0aG91dF9sZXZlcl9wdWxsZWQlMjAlM0QlMjAw",highlighted:`func _physics_process(delta: <span class="hljs-built_in">float</span>) -&gt; void:
	<span class="hljs-comment"># Reset on timeout, this is implemented in parent class to set needs_reset to true,</span>
	<span class="hljs-comment"># we are re-implementing here to call player.game_over() that handles the game reset.</span>
	n_steps += <span class="hljs-number">1</span>
	<span class="hljs-keyword">if</span> n_steps &gt; reset_after:
		player.game_over()

	<span class="hljs-comment"># In training or onnx inference modes, this method will be called by sync node with actions provided,</span>
	<span class="hljs-comment"># For expert demo recording mode, it will be called without any actions (as we set the actions based on human input),</span>
	<span class="hljs-comment"># For human control mode the method will not be called, so we call it here without any actions provided.</span>
	<span class="hljs-keyword">if</span> control_mode == ControlModes.HUMAN:
		set_action()

	<span class="hljs-comment"># Reset the game faster if the lever is not pulled.</span>
	steps_without_lever_pulled += <span class="hljs-number">1</span>
	<span class="hljs-keyword">if</span> steps_without_lever_pulled &gt; <span class="hljs-number">200</span> <span class="hljs-keyword">and</span> (<span class="hljs-keyword">not</span> player._is_lever_pulled):
		player.game_over()

func reset():
	<span class="hljs-built_in">super</span>.reset()
	steps_without_lever_pulled = <span class="hljs-number">0</span>`,wrap:!1}}),N=new w({props:{title:"Replace the get_action_space() , get_action() , and set_action() methods with the implementation below:",local:"replace-the-getactionspace--getaction--and-setaction-methods-with-the-implementation-below",headingTag:"h3"}}),F=new yt({props:{code:"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",highlighted:`<span class="hljs-comment"># Defines the actions for the AI agent (&quot;size&quot;: 2 means 2 floats for this action)</span>
func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;movement&quot;</span>: {<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>},
		<span class="hljs-string">&quot;rotation&quot;</span>: {<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>},
		<span class="hljs-string">&quot;jump&quot;</span>: {<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>},
		<span class="hljs-string">&quot;use_action&quot;</span>: {<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>}
	}

<span class="hljs-comment"># We return the action values in the same order as defined in get_action_space() (important), but all in one array</span>
<span class="hljs-comment"># For actions of size 1, we return 1 float in the array, for size 2, 2 floats in the array, etc.</span>
<span class="hljs-comment"># set_action is called just before get_action by the sync node, so we can read the newly set values</span>
func get_action():
	<span class="hljs-keyword">return</span> [
		<span class="hljs-comment"># &quot;movement&quot; action values</span>
		player.requested_movement.x,
		player.requested_movement.y,
		<span class="hljs-comment"># &quot;rotation&quot; action value</span>
		player.requested_rotation.x,
		<span class="hljs-comment"># &quot;jump&quot; action value (-1 if not requested, 1 if requested)</span>
		-<span class="hljs-number">1.0</span> + <span class="hljs-number">2.0</span> * <span class="hljs-built_in">float</span>(player.jump_requested),
		<span class="hljs-comment"># &quot;use_action&quot; action value (-1 if not requested, 1 if requested)</span>
		-<span class="hljs-number">1.0</span> + <span class="hljs-number">2.0</span> * <span class="hljs-built_in">float</span>(player.use_action_requested)
	]

<span class="hljs-comment"># Here we set human control and AI control actions to the robot</span>
func set_action(action = null) -&gt; void:
	<span class="hljs-comment"># If there&#x27;s no action provided, it means that AI is not controlling the robot (human control),</span>
	<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> action:
		<span class="hljs-comment"># Only rotate if the mouse has moved since the last set_action call</span>
		<span class="hljs-keyword">if</span> previous_mouse_movement == mouse_movement:
			mouse_movement = Vector2.ZERO

		player.requested_movement = Input.get_vector(
			<span class="hljs-string">&quot;move_left&quot;</span>, <span class="hljs-string">&quot;move_right&quot;</span>, <span class="hljs-string">&quot;move_forward&quot;</span>, <span class="hljs-string">&quot;move_back&quot;</span>
		)
		player.requested_rotation = mouse_movement

		var use_action = Input.is_action_pressed(<span class="hljs-string">&quot;requested_action&quot;</span>)
		var jump = Input.is_action_pressed(<span class="hljs-string">&quot;requested_jump&quot;</span>)

		player.use_action_requested = use_action
		player.jump_requested = jump

		previous_mouse_movement = mouse_movement	
	<span class="hljs-keyword">else</span>:
		<span class="hljs-comment"># If there is action provided, we set the actions received from the AI agent </span>
		player.requested_movement = Vector2(action.movement[<span class="hljs-number">0</span>], action.movement[<span class="hljs-number">1</span>])
		<span class="hljs-comment"># The agent only rotates the robot along the Y axis, no need to rotate the camera along X axis</span>
		player.requested_rotation = Vector2(action.rotation[<span class="hljs-number">0</span>], <span class="hljs-number">0.0</span>)
		player.jump_requested = <span class="hljs-built_in">bool</span>(action.jump[<span class="hljs-number">0</span>] &gt; <span class="hljs-number">0</span>)
		player.use_action_requested = <span class="hljs-built_in">bool</span>(action.use_action[<span class="hljs-number">0</span>] &gt; <span class="hljs-number">0</span>)`,wrap:!1}}),H=new w({props:{title:"Replace the _input method with the implementation below:",local:"replace-the-input-method-with-the-implementation-below",headingTag:"h3"}}),D=new yt({props:{code:"JTIzJTIwUmVjb3JkJTIwbW91c2UlMjBtb3ZlbWVudCUyMGZvciUyMGh1bWFuJTIwYW5kJTIwZGVtb19yZWNvcmQlMjBtb2RlcyUwQSUyMyUyMFdlJTIwZG9uJ3QlMjBkaXJlY3RseSUyMHJvdGF0ZSUyMGluJTIwaW5wdXQlMjB0byUyMGFsbG93JTIwZm9yJTIwZnJhbWUlMjBza2lwcGluZyUyMChhY3Rpb25fcmVwZWF0JTIwc2V0dGluZyklMjB3aGljaCUwQSUyMyUyMHdpbGwlMjBhbHNvJTIwYmUlMjBhcHBsaWVkJTIwdG8lMjB0aGUlMjBBSSUyMGFnZW50JTIwaW4lMjB0cmFpbmluZyUyRmluZmVyZW5jZSUyMG1vZGVzLiUwQWZ1bmMlMjBfaW5wdXQoZXZlbnQpJTNBJTBBJTA5aWYlMjBub3QlMjAoaGV1cmlzdGljJTIwJTNEJTNEJTIwJTIyaHVtYW4lMjIlMjBvciUyMGhldXJpc3RpYyUyMCUzRCUzRCUyMCUyMmRlbW9fcmVjb3JkJTIyKSUzQSUwQSUwOSUwOXJldHVybiUwQSUwQSUwOWlmJTIwZXZlbnQlMjBpcyUyMElucHV0RXZlbnRNb3VzZU1vdGlvbiUzQSUwQSUwOSUwOXZhciUyMG1vdmVtZW50X3NjYWxlJTNBJTIwZmxvYXQlMjAlM0QlMjAwLjAwNSUwQSUwOSUwOW1vdXNlX21vdmVtZW50LnklMjAlM0QlMjBjbGFtcGYoZXZlbnQucmVsYXRpdmUueSUyMColMjBtb3ZlbWVudF9zY2FsZSUyQyUyMC0xLjAlMkMlMjAxLjApJTBBJTA5JTA5bW91c2VfbW92ZW1lbnQueCUyMCUzRCUyMGNsYW1wZihldmVudC5yZWxhdGl2ZS54JTIwKiUyMG1vdmVtZW50X3NjYWxlJTJDJTIwLTEuMCUyQyUyMDEuMCk=",highlighted:`<span class="hljs-comment"># Record mouse movement for human and demo_record modes</span>
<span class="hljs-comment"># We don&#x27;t directly rotate in input to allow for frame skipping (action_repeat setting) which</span>
<span class="hljs-comment"># will also be applied to the AI agent in training/inference modes.</span>
func _<span class="hljs-built_in">input</span>(event):
	<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> (heuristic == <span class="hljs-string">&quot;human&quot;</span> <span class="hljs-keyword">or</span> heuristic == <span class="hljs-string">&quot;demo_record&quot;</span>):
		<span class="hljs-keyword">return</span>

	<span class="hljs-keyword">if</span> event <span class="hljs-keyword">is</span> InputEventMouseMotion:
		var movement_scale: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.005</span>
		mouse_movement.y = clampf(event.relative.y * movement_scale, -<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>)
		mouse_movement.x = clampf(event.relative.x * movement_scale, -<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>)`,wrap:!1}}),q=new w({props:{title:"Open the demo record scene, and click on AIController3D node",local:"open-the-demo-record-scene-and-click-on-aicontroller3d-node",headingTag:"h3"}}),se=new w({props:{title:"Let’s record some demos:",local:"lets-record-some-demos",headingTag:"h3"}}),de=new w({props:{title:"Export the game for training:",local:"export-the-game-for-training",headingTag:"h3"}}),me=new ol({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unitbonus5/getting-started.mdx"}}),{c(){U=o("meta"),ue=n(),he=o("p"),we=n(),r(f.$$.fragment),Ue=n(),v=o("p"),v.innerHTML=Jt,Je=n(),Z=o("p"),Z.textContent=bt,be=n(),I=o("ul"),I.innerHTML=Tt,Te=n(),r(G.$$.fragment),je=n(),_=o("p"),_.innerHTML=jt,fe=n(),r(W.$$.fragment),ve=n(),J=o("blockquote"),J.innerHTML=ft,Ze=n(),g=o("p"),g.innerHTML=vt,Ie=n(),k=o("img"),Ge=n(),r(S.$$.fragment),_e=n(),b=o("blockquote"),b.innerHTML=It,We=n(),r(B.$$.fragment),ge=n(),r(X.$$.fragment),ke=n(),V=o("p"),V.innerHTML=Gt,Se=n(),C=o("p"),C.textContent=_t,Be=n(),Y=o("ul"),Y.innerHTML=Wt,Xe=n(),Q=o("p"),Q.innerHTML=gt,Ve=n(),x=o("p"),x.innerHTML=kt,Ce=n(),r(R.$$.fragment),Ye=n(),r(E.$$.fragment),Qe=n(),r(N.$$.fragment),xe=n(),r(F.$$.fragment),Re=n(),A=o("p"),A.innerHTML=St,Ee=n(),z=o("p"),z.innerHTML=Bt,Ne=n(),$=o("p"),$.textContent=Xt,Fe=n(),r(H.$$.fragment),Ae=n(),r(D.$$.fragment),ze=n(),O=o("p"),O.textContent=Vt,$e=n(),L=o("p"),L.innerHTML=Ct,He=n(),r(q.$$.fragment),De=n(),T=o("blockquote"),T.innerHTML=Yt,Oe=n(),K=o("img"),Le=n(),P=o("p"),P.textContent=xt,qe=n(),ee=o("p"),ee.innerHTML=Rt,Ke=n(),te=o("ul"),te.innerHTML=Et,Pe=n(),le=o("p"),le.innerHTML=Nt,et=n(),r(se.$$.fragment),tt=n(),j=o("blockquote"),j.innerHTML=Ft,lt=n(),ne=o("p"),ne.innerHTML=At,st=n(),ae=o("p"),ae.textContent=zt,nt=n(),oe=o("ul"),oe.innerHTML=$t,at=n(),ie=o("p"),ie.innerHTML=Ht,ot=n(),ce=o("p"),ce.innerHTML=Dt,it=n(),re=o("p"),re.innerHTML=Ot,ct=n(),pe=o("p"),pe.textContent=Lt,rt=n(),u=o("video"),pt=n(),r(de.$$.fragment),dt=n(),Me=o("p"),Me.innerHTML=Kt,Mt=n(),r(me.$$.fragment),mt=n(),ye=o("p"),this.h()},l(e){const t=nl("svelte-u9bgzb",document.head);U=i(t,"META",{name:!0,content:!0}),t.forEach(l),ue=a(e),he=i(e,"P",{}),wt(he).forEach(l),we=a(e),p(f.$$.fragment,e),Ue=a(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1qb7a4d"&&(v.innerHTML=Jt),Je=a(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1amr1o0"&&(Z.textContent=bt),be=a(e),I=i(e,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-1y323ju"&&(I.innerHTML=Tt),Te=a(e),p(G.$$.fragment,e),je=a(e),_=i(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-npkgc1"&&(_.innerHTML=jt),fe=a(e),p(W.$$.fragment,e),ve=a(e),J=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(J)!=="svelte-9l881n"&&(J.innerHTML=ft),Ze=a(e),g=i(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-1ube8yo"&&(g.innerHTML=vt),Ie=a(e),k=i(e,"IMG",{src:!0,alt:!0}),Ge=a(e),p(S.$$.fragment,e),_e=a(e),b=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(b)!=="svelte-19iet2z"&&(b.innerHTML=It),We=a(e),p(B.$$.fragment,e),ge=a(e),p(X.$$.fragment,e),ke=a(e),V=i(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-jh3wu3"&&(V.innerHTML=Gt),Se=a(e),C=i(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1fea4rp"&&(C.textContent=_t),Be=a(e),Y=i(e,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-1h1wquf"&&(Y.innerHTML=Wt),Xe=a(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-13tyx2h"&&(Q.innerHTML=gt),Ve=a(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-n47bel"&&(x.innerHTML=kt),Ce=a(e),p(R.$$.fragment,e),Ye=a(e),p(E.$$.fragment,e),Qe=a(e),p(N.$$.fragment,e),xe=a(e),p(F.$$.fragment,e),Re=a(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-zwgvhy"&&(A.innerHTML=St),Ee=a(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1u26gdc"&&(z.innerHTML=Bt),Ne=a(e),$=i(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1pngomy"&&($.textContent=Xt),Fe=a(e),p(H.$$.fragment,e),Ae=a(e),p(D.$$.fragment,e),ze=a(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-16wo2en"&&(O.textContent=Vt),$e=a(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1xk6pzp"&&(L.innerHTML=Ct),He=a(e),p(q.$$.fragment,e),De=a(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-15gif3l"&&(T.innerHTML=Yt),Oe=a(e),K=i(e,"IMG",{src:!0,alt:!0}),Le=a(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-140ih9d"&&(P.textContent=xt),qe=a(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1kxoy08"&&(ee.innerHTML=Rt),Ke=a(e),te=i(e,"UL",{"data-svelte-h":!0}),c(te)!=="svelte-1me19ds"&&(te.innerHTML=Et),Pe=a(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1vrpmg4"&&(le.innerHTML=Nt),et=a(e),p(se.$$.fragment,e),tt=a(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(j)!=="svelte-15jos0p"&&(j.innerHTML=Ft),lt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1u58l5w"&&(ne.innerHTML=At),st=a(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-955cdc"&&(ae.textContent=zt),nt=a(e),oe=i(e,"UL",{"data-svelte-h":!0}),c(oe)!=="svelte-lgd0ry"&&(oe.innerHTML=$t),at=a(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-7gdr6v"&&(ie.innerHTML=Ht),ot=a(e),ce=i(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1kchvdy"&&(ce.innerHTML=Dt),it=a(e),re=i(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-h82rtc"&&(re.innerHTML=Ot),ct=a(e),pe=i(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-6wv9et"&&(pe.textContent=Lt),rt=a(e),u=i(e,"VIDEO",{src:!0,type:!0,mute:!0}),wt(u).forEach(l),pt=a(e),p(de.$$.fragment,e),dt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-57pgql"&&(Me.innerHTML=Kt),Mt=a(e),p(me.$$.fragment,e),mt=a(e),ye=i(e,"P",{}),wt(ye).forEach(l),this.h()},h(){y(U,"name","hf:doc:metadata"),y(U,"content",cl),y(J,"class","tip"),ut(k.src,Zt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit13/open-robot-scene.jpg")||y(k,"src",Zt),y(k,"alt","open robot scene"),y(b,"class","tip"),y(T,"class","tip"),ut(K.src,Qt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit13/demo_record_scene.jpg")||y(K,"src",Qt),y(K,"alt","open robot scene"),y(j,"class","tip"),ut(u.src,qt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit13/demo_record.mp4")||y(u,"src",qt),y(u,"type","video/mp4"),u.controls=!0,u.autoplay=!0,u.loop=!0,y(u,"mute","")},m(e,t){al(document.head,U),s(e,ue,t),s(e,he,t),s(e,we,t),d(f,e,t),s(e,Ue,t),s(e,v,t),s(e,Je,t),s(e,Z,t),s(e,be,t),s(e,I,t),s(e,Te,t),d(G,e,t),s(e,je,t),s(e,_,t),s(e,fe,t),d(W,e,t),s(e,ve,t),s(e,J,t),s(e,Ze,t),s(e,g,t),s(e,Ie,t),s(e,k,t),s(e,Ge,t),d(S,e,t),s(e,_e,t),s(e,b,t),s(e,We,t),d(B,e,t),s(e,ge,t),d(X,e,t),s(e,ke,t),s(e,V,t),s(e,Se,t),s(e,C,t),s(e,Be,t),s(e,Y,t),s(e,Xe,t),s(e,Q,t),s(e,Ve,t),s(e,x,t),s(e,Ce,t),d(R,e,t),s(e,Ye,t),d(E,e,t),s(e,Qe,t),d(N,e,t),s(e,xe,t),d(F,e,t),s(e,Re,t),s(e,A,t),s(e,Ee,t),s(e,z,t),s(e,Ne,t),s(e,$,t),s(e,Fe,t),d(H,e,t),s(e,Ae,t),d(D,e,t),s(e,ze,t),s(e,O,t),s(e,$e,t),s(e,L,t),s(e,He,t),d(q,e,t),s(e,De,t),s(e,T,t),s(e,Oe,t),s(e,K,t),s(e,Le,t),s(e,P,t),s(e,qe,t),s(e,ee,t),s(e,Ke,t),s(e,te,t),s(e,Pe,t),s(e,le,t),s(e,et,t),d(se,e,t),s(e,tt,t),s(e,j,t),s(e,lt,t),s(e,ne,t),s(e,st,t),s(e,ae,t),s(e,nt,t),s(e,oe,t),s(e,at,t),s(e,ie,t),s(e,ot,t),s(e,ce,t),s(e,it,t),s(e,re,t),s(e,ct,t),s(e,pe,t),s(e,rt,t),s(e,u,t),s(e,pt,t),d(de,e,t),s(e,dt,t),s(e,Me,t),s(e,Mt,t),d(me,e,t),s(e,mt,t),s(e,ye,t),ht=!0},p:el,i(e){ht||(M(f.$$.fragment,e),M(G.$$.fragment,e),M(W.$$.fragment,e),M(S.$$.fragment,e),M(B.$$.fragment,e),M(X.$$.fragment,e),M(R.$$.fragment,e),M(E.$$.fragment,e),M(N.$$.fragment,e),M(F.$$.fragment,e),M(H.$$.fragment,e),M(D.$$.fragment,e),M(q.$$.fragment,e),M(se.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),ht=!0)},o(e){m(f.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(S.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(R.$$.fragment,e),m(E.$$.fragment,e),m(N.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(D.$$.fragment,e),m(q.$$.fragment,e),m(se.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),ht=!1},d(e){e&&(l(ue),l(he),l(we),l(Ue),l(v),l(Je),l(Z),l(be),l(I),l(Te),l(je),l(_),l(fe),l(ve),l(J),l(Ze),l(g),l(Ie),l(k),l(Ge),l(_e),l(b),l(We),l(ge),l(ke),l(V),l(Se),l(C),l(Be),l(Y),l(Xe),l(Q),l(Ve),l(x),l(Ce),l(Ye),l(Qe),l(xe),l(Re),l(A),l(Ee),l(z),l(Ne),l($),l(Fe),l(Ae),l(ze),l(O),l($e),l(L),l(He),l(De),l(T),l(Oe),l(K),l(Le),l(P),l(qe),l(ee),l(Ke),l(te),l(Pe),l(le),l(et),l(tt),l(j),l(lt),l(ne),l(st),l(ae),l(nt),l(oe),l(at),l(ie),l(ot),l(ce),l(it),l(re),l(ct),l(pe),l(rt),l(u),l(pt),l(dt),l(Me),l(Mt),l(mt),l(ye)),l(U),h(f,e),h(G,e),h(W,e),h(S,e),h(B,e),h(X,e),h(R,e),h(E,e),h(N,e),h(F,e),h(H,e),h(D,e),h(q,e),h(se,e),h(de,e),h(me,e)}}}const cl='{"title":"Getting started:","local":"getting-started","sections":[{"title":"Open the starter project in Godot","local":"open-the-starter-project-in-godot","sections":[],"depth":3},{"title":"Open the robot scene","local":"open-the-robot-scene","sections":[],"depth":3},{"title":"Click on the scroll next to AIController3D to open the script for editing","local":"click-on-the-scroll-next-to-aicontroller3d-to-open-the-script-for-editing","sections":[],"depth":3},{"title":"Replace the get_obs() and get_reward() methods with the implementation below:","local":"replace-the-getobs-and-getreward-methods-with-the-implementation-below","sections":[],"depth":3},{"title":"Replace the _physics_process() and reset() methods with the implementation below:","local":"replace-the-physicsprocess-and-reset-methods-with-the-implementation-below","sections":[],"depth":3},{"title":"Replace the get_action_space() , get_action() , and set_action() methods with the implementation below:","local":"replace-the-getactionspace--getaction--and-setaction-methods-with-the-implementation-below","sections":[],"depth":3},{"title":"Replace the _input method with the implementation below:","local":"replace-the-input-method-with-the-implementation-below","sections":[],"depth":3},{"title":"Open the demo record scene, and click on AIController3D node","local":"open-the-demo-record-scene-and-click-on-aicontroller3d-node","sections":[],"depth":3},{"title":"Let’s record some demos:","local":"lets-record-some-demos","sections":[],"depth":3},{"title":"Export the game for training:","local":"export-the-game-for-training","sections":[],"depth":3}],"depth":1}';function rl(Ut){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends ll{constructor(U){super(),sl(this,U,rl,il,Pt,{})}}export{hl as component};
