import{s as ep,n as np,o as pp}from"../chunks/scheduler.7bc62968.js";import{S as lp,i as ip,g as l,s as n,r,m as z,H as x,A as mp,h as i,f as t,c as p,j as v,u as o,x as m,n as $,B as w,k as Wn,y,a as e,v as c,d as h,t as g,w as d}from"../chunks/index.2f8492b0.js";import{H as u,E as rp}from"../chunks/index.514d62da.js";function op(He){let f,fa,ua,ba,O,xa,C,wa,L,qe=`Convolutional Neural Networks have taken a big step towards solving the image classification problem.
But there remains another big task to solve: object detection. Object detection not only requires categorizing the object from the image but also accurately predicting its location (in this case, the coordinates of the bounding boxes of the object) in the image. This is where the big breakthrough of YOLO came in. Before delving deeper into YOLO, let’s go through the history of object detection algorithms using CNNs.`,za,k,$a,_,Oa,T,Ae=`RCNN is one of the simplest ways possible to use convolutional neural networks for object detection. In simple terms, the basic idea is to
detect a “region” and then use CNN to classify the region. So this is a multi-step process. Based on this idea the RCNN paper was shared in 2012[1]`,Ca,P,Fe="The RCNN uses following steps,",La,Y,Be="<li>Use Selective Search algorithm to select a region.</li> <li>Use CNN based classifier to classify an object from the region.</li>",ka,N,Ue="For training purpose, the paper proposed the following steps",_a,j,Ee="<li>Make a dataset of regions detected from the Object detection dataset.</li> <li>Fine tune Alexnet model on the regions dataset.</li> <li>Then use the fine tuned model on the object detection dataset.</li>",Ta,M,De=`The following is a basic pipeline of RCNN
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/RCNN.png" alt="rcnn"/>`,Pa,S,Ya,R,Ge="Fast RCNN is focused on improvisation over the original RCNN. They added these four improvements",Na,I,We="<li>Training in a single-stage instead of multi-stage like RCNN. Uses multi-task loss</li> <li>No disk storage required.</li> <li>Introduces ROI pooling layer to only get the features from the  Region of Interests.</li> <li>Trains an end-to-end model in contrary to multi-step RCNN / SPPnet models using multi-task loss.</li>",ja,H,Ke='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/Fast%20R-CNN.png" alt="fast_rcnn"/>',Ma,q,Sa,A,Ve="The Faster R-CNN completely removes the need for the Selective Search algorithm! These features resulted in an improvement of the inference time by 90% compared to that of Fast R-CNN!!",Ra,F,Xe="<li>It introduces RPN, Regional Proposal Network. The RPN is an attention based model which trains the model to give “attention” to the region of the image containing the object.</li> <li>It merges RPN with Fast RCNN, making it an End-to-End object detection model.</li>",Ia,B,Qe='<img src="https://cdn-uploads.huggingface.co/production/uploads/6141a88b3a0ec78603c9e784/n8eDqnlEvDS5SIKGoSUpz.png" alt="Faster RCNN"/>',Ha,U,qa,E,Je="<li>A Feature Pyramid network is a kind of Inception model for Object detection.</li> <li>It first downscales the image into lower dimensional embeddings.</li> <li>Then it upscalses them again.</li> <li>From every upscaled images it tries to predict the output (in this case the categories.)</li> <li>But there are also skip connections between the similar dimensional features as well!</li>",Aa,D,Ze="Please refer to the following images which are taken from the paper.[20]",Fa,G,sn='<a href="https://huggingface.co/datasets/hf-vision/course-assets/blob/main/FPN.png" rel="nofollow">FPN</a> <a href="https://huggingface.co/datasets/hf-vision/course-assets/blob/main/FPN_2.png" rel="nofollow">FPN2</a>',Ba,W,Ua,K,an="YOLO was a ground breaking innovation of its time. A real time object detector, end to end trainable with a single network.",Ea,V,Da,X,tn="The detection systems before consisted of utilizing image classifiers on patches of images. Systems like deformable parts models (DPM) used a sliding window approach where the classifier is run at evenly spaced locations over the entire image.",Ga,Q,en="Other works like RCNN used a two-step detection. First, they detected many possible regions of interest, generated as bounding boxes by a Region Proposal Network. Then a classifier is run through all proposed regions to make final predictions. Post-processing, such as refining the bounding boxes, eliminating duplicate detections, and re-scoring the boxes based on other objects in the scene, needs to be done.",Wa,J,nn="These complex pipelines are slow and hard to optimise because each individual component must be trained separately.",Ka,Z,Va,ss,pn="YOLO is a single step detector where the bounding box and the class of the object is predicted in the same pass, simultaneously. This makes the system super fast - 45-frames-per-second fast.",Xa,as,Qa,ts,ln="YOLO reframes the Object Detection task as a single regression problem, which predicts bounding box coordinates and class probabilities.",Ja,es,mn="In this design, we divide the image into an $S \\times S$ grid. If the center of the object falls into a grid cell, that grid cell is responsible to detect that object. We can define $B$ as the maximum number of objects to be detected in each cell. So each grid cell predicts $B$ bounding boxes including confidence scores for each box.",Za,ns,st,ps,rn="The confidence score of a bounding box should reflect how accurately the box was predicted. It should be close to the IOU (Intersection over Union) of the ground truth box versus the predicted box. If the grid was not supposed to predict a box, then it should be zero. So this should encode the probability of the center of the box being present in the grid and the correctness of the bounding box.",at,ls,$e,tt,Kn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext>confidence</mtext><mo>:</mo><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><mtext>Object</mtext><mo stretchy="false">)</mo><mo>×</mo><msubsup><mtext>IOU</mtext><mtext>pred</mtext><mtext>truth</mtext></msubsup></mrow><annotation encoding="application/x-tex">\\text{confidence} := P(\\text{Object}) \\times \\text{IOU}_{\\text{pred}}^{\\text{truth}}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord text"><span class="mord">confidence</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">:=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord text"><span class="mord">Object</span></span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.3054em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord text"><span class="mord">IOU</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9223em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">pred</span></span></span></span></span><span style="top:-3.1362em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">truth</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span></span></span></span></span>',et,is,nt,ms,on="The coordinates of a bounding box are encoded in 4 numbers $(x, y, w, h)$. The $(x, y)$ coordinates represent the center of the box relative to the bounds of the grid cell. The width and height are normalized to image dimensions.",pt,rs,lt,os,cn="The class probabilities is a $C$ long vecto,r representing conditional class probabilities of each class given an object existed in a cell. Each grid cell only predicts one vector, i.e a single class will be assigned to each grid cell and so all the $B$ bounding boxes predicted by that grid cell will have the same class.",it,cs,Oe,mt,Vn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mi>C</mi><mi>i</mi></msub><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><msub><mtext>class</mtext><mi>i</mi></msub><mo>∣</mo><mtext>Object</mtext><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">C_i = P(\\text{class}_i \\mid \\text{Object})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">C</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0715em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord"><span class="mord text"><span class="mord">class</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∣</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Object</span></span><span class="mclose">)</span></span></span></span></span>',rt,hs,Ce,ot,Xn=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mtable rowspacing="0.25em" columnalign="right left" columnspacing="0em"><mtr><mtd class ="mtr-glue"></mtd><mtd><mstyle scriptlevel="0" displaystyle="true"><mrow><msub><mi>C</mi><mi>i</mi></msub><mo>×</mo><mtext>confidence</mtext></mrow></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="true"><mrow><mrow></mrow><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><msub><mtext>class</mtext><mi>i</mi></msub><mo>∣</mo><mtext>Object</mtext><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mtext>Object</mtext><mo stretchy="false">)</mo><mo>×</mo><msubsup><mtext>IOU</mtext><mtext>pred</mtext><mtext>truth</mtext></msubsup></mrow></mstyle></mtd><mtd class ="mtr-glue"></mtd><mtd class ="mml-eqn-num"></mtd></mtr><mtr><mtd class ="mtr-glue"></mtd><mtd><mstyle scriptlevel="0" displaystyle="true"><mrow></mrow></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="true"><mrow><mrow></mrow><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><msub><mtext>class</mtext><mi>i</mi></msub><mo stretchy="false">)</mo><mo>×</mo><msubsup><mtext>IOU</mtext><mtext>pred</mtext><mtext>truth</mtext></msubsup></mrow></mstyle></mtd><mtd class ="mtr-glue"></mtd><mtd class ="mml-eqn-num"></mtd></mtr></mtable><annotation encoding="application/x-tex">\\begin{align}
C_i \\times \\text{confidence} &amp;= P(\\text{class}_i \\mid \\text{Object}) \\times P(\\text{Object}) \\times \\text{IOU}_{\\text{pred}}^{\\text{truth}}\\\\
&amp;=P(\\text{class}_i) \\times \\text{IOU}_{\\text{pred}}^{\\text{truth}}
\\end{align}
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:3.2109em;vertical-align:-1.3554em;"></span><span class="mtable"><span class="col-align-r"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8554em;"><span style="top:-3.9331em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">C</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0715em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord text"><span class="mord">confidence</span></span></span></span><span style="top:-2.3277em;"><span class="pstrut" style="height:3em;"></span><span class="mord"></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.3554em;"><span></span></span></span></span></span><span class="col-align-l"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8554em;"><span style="top:-3.9331em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord"><span class="mord text"><span class="mord">class</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∣</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord text"><span class="mord">Object</span></span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord text"><span class="mord">Object</span></span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord text"><span class="mord">IOU</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9223em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">pred</span></span></span></span></span><span style="top:-3.1362em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">truth</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.3277em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord"><span class="mord text"><span class="mord">class</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord text"><span class="mord">IOU</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9223em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">pred</span></span></span></span></span><span style="top:-3.1362em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">truth</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.3554em;"><span></span></span></span></span></span></span></span><span class="tag"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8554em;"><span style="top:-3.8554em;"><span class="pstrut" style="height:2.9223em;"></span><span class="eqn-num"></span></span><span style="top:-2.25em;"><span class="pstrut" style="height:2.9223em;"></span><span class="eqn-num"></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.3554em;"><span></span></span></span></span></span></span></span></span>`,ct,gs,hn="To recap, we have an image, divided into $S \\times S$ grid. Each grid cell contains $B$ bounding boxes consisting of 5 values - confidence + 4 coordinates and $C$ long vector containing conditional probabilities of each class. So, each grid cell is a $B \\times 5 + C$ long vector. The whole grid is $S \\times S \\times (B \\times 5 + C)$.",ht,ds,gn="So if we have a learnable system which converts an image to an $S \\times S \\times (B \\times 5 + C)$ feature map, we are one step closer to the task.",gt,us,dt,vs,dn="In the original YOLOv1 design the input is an RGB image of size $448 \\times 448$. The image is divided into a $S \\times S = 7 \\times 7$ grid, where each grid cell is responsible for detecting $B=2$ bounding boxes and $C=20$ classes.",ut,ys,un="The network architecture is a simple convolutional neural network. The input image is passed through a series of convolutional layers, followed by a fully connected layer. The final layer outputs are reshaped to $7 \\times 7 \\times (2 \\times 5 + 20) = 7 \\times 7 \\times 30$.",vt,fs,Le,yt,Qn=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext>LeakyReLU</mtext><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo>=</mo><mrow><mo fence="true">{</mo><mtable rowspacing="0.36em" columnalign="left left" columnspacing="1em"><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mi>x</mi></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><mtext>if </mtext><mi>x</mi><mo>&gt;</mo><mn>0</mn></mrow></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><mn>0.1</mn><mi>x</mi></mrow></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mtext>otherwise</mtext></mstyle></mtd></mtr></mtable></mrow></mrow><annotation encoding="application/x-tex">\\text{LeakyReLU}(x) = \\begin{cases}
x &amp; \\text{if } x &gt; 0\\\\
0.1x &amp; \\text{otherwise}
\\end{cases}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">LeakyReLU</span></span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3em;vertical-align:-1.25em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size4">{</span></span><span class="mord"><span class="mtable"><span class="col-align-l"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.69em;"><span style="top:-3.69em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord mathnormal">x</span></span></span><span style="top:-2.25em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord">0.1</span><span class="mord mathnormal">x</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.19em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:1em;"></span><span class="col-align-l"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.69em;"><span style="top:-3.69em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord text"><span class="mord">if </span></span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord">0</span></span></span><span style="top:-2.25em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord text"><span class="mord">otherwise</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.19em;"><span></span></span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span></span>`,ft,bs,vn="See figure below for the architecture of YOLOv1.",bt,xs,yn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/yolov1_arch.png" alt="v1_arch"/>',xt,ws,wt,zs,fn="The network is trained end-to-end on the image and the ground truth bounding boxes. The loss function is a sum of squared error loss. The loss function is designed to penalize the network for incorrect predictions of bounding box coordinates, confidence and class probabilities. We will discuss the loss function in the next section.",zt,$s,bn="YOLO predicts multiple bounding boxes per grid cell. At training time, we only want one bounding box predictor to be responsible for each object. We assign one predictor to be “responsible” for predicting an object based on which prediction has the highest current IOU with the ground truth. This leads to specialization between the bounding box predictors. Each predictor gets better at predicting certain sizes, aspect ratios, or classes of objects, improving overall recall. We will encode this information in the loss function for grid cell $i$ and bounding box $b$ using $\\mathbb{1}{ib}^{\\text{obj}}$. $\\mathbb{1}{ib}^{\\text{noobj}}$ is the opposite of $\\mathbb{1}_{ib}^{\\text{obj}}$.",$t,Os,Ot,Cs,xn="Now that we have a learnable system which converts an image to a $S \\times S \\times (B\\times5 + C)$ feature map, we need to train it.",Ct,Ls,wn="A simple function to train such a system is to use a sum of squared error loss. We can use the squared error between the predicted values and the true values, i.e for bounding box coordinates, confidence and class probabilities.",Lt,b,ke,kt,Jn=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msup><mi mathvariant="script">L</mi><mi>i</mi></msup><mo>=</mo><msubsup><mi mathvariant="script">L</mi><mtext>coord</mtext><mi>i</mi></msubsup><mo>+</mo><msubsup><mi mathvariant="script">L</mi><mtext>conf</mtext><mi>i</mi></msubsup><mo>+</mo><msubsup><mi mathvariant="script">L</mi><mtext>class</mtext><mi>i</mi></msubsup><mspace linebreak="newline"></mspace></mrow><annotation encoding="application/x-tex">
\\mathcal{L}^{i} = \\mathcal{L}^{i}_{\\text{coord}} + \\mathcal{L}^{i}_{\\text{conf}} + \\mathcal{L}^{i}_{\\text{class}}\\\\
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8747em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1217em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">coord</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1217em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">conf</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1217em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">class</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span><span class="mspace newline"></span></span></span></span>`,_t,Tt,Zn=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mtable rowspacing="0.25em" columnalign="right left" columnspacing="0em"><mtr><mtd><mstyle scriptlevel="0" displaystyle="true"><msubsup><mi mathvariant="script">L</mi><mtext>coord</mtext><mi>i</mi></msubsup></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="true"><mrow><mrow></mrow><mo>=</mo><munderover><mo>∑</mo><mrow><mi>b</mi><mo>=</mo><mn>0</mn></mrow><mi>B</mi></munderover><msubsup><mn mathvariant="double-struck">1</mn><mrow><mi>i</mi><mi>b</mi></mrow><mtext>obj</mtext></msubsup><mrow><mo fence="true">[</mo><msup><mrow><mo fence="true">(</mo><msub><mover accent="true"><mi>x</mi><mo>^</mo></mover><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo>−</mo><msub><mi>x</mi><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo>+</mo><msup><mrow><mo fence="true">(</mo><msub><mover accent="true"><mi>y</mi><mo>^</mo></mover><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo>−</mo><msub><mi>y</mi><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo>+</mo><msup><mrow><mo fence="true">(</mo><msub><mover accent="true"><mi>w</mi><mo>^</mo></mover><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo>−</mo><msub><mi>w</mi><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo>+</mo><msup><mrow><mo fence="true">(</mo><msub><mover accent="true"><mi>h</mi><mo>^</mo></mover><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo>−</mo><msub><mi>h</mi><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo fence="true">]</mo></mrow></mrow></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="true"><msubsup><mi mathvariant="script">L</mi><mtext>conf</mtext><mi>i</mi></msubsup></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="true"><mrow><mrow></mrow><mo>=</mo><munderover><mo>∑</mo><mrow><mi>b</mi><mo>=</mo><mn>0</mn></mrow><mi>B</mi></munderover><mo stretchy="false">(</mo><msub><mover accent="true"><mtext>conf</mtext><mo>^</mo></mover><mi>i</mi></msub><mo>−</mo><msub><mtext>conf</mtext><mi>i</mi></msub><msup><mo stretchy="false">)</mo><mn>2</mn></msup></mrow></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="true"><msubsup><mi mathvariant="script">L</mi><mtext>class</mtext><mi>i</mi></msubsup></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="true"><mrow><mrow></mrow><mo>=</mo><msubsup><mn mathvariant="double-struck">1</mn><mi>i</mi><mtext>obj</mtext></msubsup><munderover><mo>∑</mo><mrow><mi>c</mi><mo>=</mo><mn>0</mn></mrow><mi>C</mi></munderover><mo stretchy="false">(</mo><msub><mover accent="true"><mi>P</mi><mo>^</mo></mover><mi>i</mi></msub><mo>−</mo><msub><mi>P</mi><mi>i</mi></msub><msup><mo stretchy="false">)</mo><mn>2</mn></msup></mrow></mstyle></mtd></mtr></mtable><annotation encoding="application/x-tex">\\begin{align*}
\\mathcal{L}^{i}_{\\text{coord}} &amp;= \\sum_{b=0}^{B} \\mathbb{1}_{ib}^{\\text{obj}} \\left[ \\left( \\hat{x}_{ib} - x_{ib} \\right)^2 + \\left( \\hat{y}_{ib} - y_{ib} \\right)^2 + 
\\left( 
    \\hat{w}_{ib} - w_{ib}
\\right)^2 + 
\\left( 
    \\hat{h}_{ib} - h_{ib}
    \\right)^2
\\right]\\\\
\\mathcal{L}^{i}_{\\text{conf}} &amp;= \\sum_{b=0}^{B} (\\hat{\\text{conf}}_{i} - \\text{conf}_{i})^2\\\\
\\mathcal{L}^{i}_{\\text{class}} &amp;= \\mathbb{1}_i^\\text{obj}\\sum_{c=0}^{C} (\\hat{P}_{i} - P_{i})^2
\\end{align*}
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:10.2563em;vertical-align:-4.8782em;"></span><span class="mord"><span class="mtable"><span class="col-align-r"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:5.3782em;"><span style="top:-7.3782em;"><span class="pstrut" style="height:3.8283em;"></span><span class="mord"><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">coord</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span></span><span style="top:-3.9477em;"><span class="pstrut" style="height:3.8283em;"></span><span class="mord"><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">conf</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span></span><span style="top:-0.5173em;"><span class="pstrut" style="height:3.8283em;"></span><span class="mord"><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">class</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:4.8782em;"><span></span></span></span></span></span><span class="col-align-l"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:5.3782em;"><span style="top:-7.3782em;"><span class="pstrut" style="height:3.8283em;"></span><span class="mord"><span class="mord"></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8479em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mrel mtight">=</span><span class="mord mtight">0</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.3021em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord">1</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.967em;"><span style="top:-2.3987em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span><span style="top:-3.1809em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">obj</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3013em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size3">[</span></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;">(</span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.6944em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal">x</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2222em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;">)</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.954em;"><span style="top:-3.2029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;">(</span><span class="mord"><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6944em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.1944em;"><span class="mord">^</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;">)</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.954em;"><span style="top:-3.2029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;">(</span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.6944em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.1667em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0269em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0269em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;">)</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.954em;"><span style="top:-3.2029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size2">(</span></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9579em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal">h</span></span><span style="top:-3.2634em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.25em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal">h</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size2">)</span></span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:1.354em;"><span style="top:-3.6029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size3">]</span></span></span></span></span><span style="top:-3.9477em;"><span class="pstrut" style="height:3.8283em;"></span><span class="mord"><span class="mord"></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8479em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mrel mtight">=</span><span class="mord mtight">0</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.3021em;"><span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9579em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord text"><span class="mord">conf</span></span></span><span style="top:-3.2634em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.25em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord text"><span class="mord">conf</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span><span style="top:-0.5173em;"><span class="pstrut" style="height:3.8283em;"></span><span class="mord"><span class="mord"></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord"><span class="mord">1</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.967em;"><span style="top:-2.4231em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.1809em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord text mtight"><span class="mord mtight">obj</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2769em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8829em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">c</span><span class="mrel mtight">=</span><span class="mord mtight">0</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.07153em;">C</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2671em;"><span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9468em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span></span><span style="top:-3.2523em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.1667em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.1389em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.1389em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:4.8782em;"><span></span></span></span></span></span></span></span></span></span></span></span>`,Pt,ks,zn="where",Yt,_s,$n="<li>$\\mathbb{1}_{ib}^{\\text{obj}}$ is 1 if the $b$-th bounding box in the $i$-th grid cell is responsible for detecting the object, 0 otherwise.</li> <li>$\\mathbb{1}_i^\\text{obj}$ is 1 if the $i$-th grid cell contains an object, 0 otherwise.</li>",Nt,Ts,On="But this loss function does not necessarily align well with the task of object detection. The simple addition of losses for both tasks (classification and localization) weights the loss equally.",jt,Ps,Cn="To rectify, YOLOv1 uses a weighted sum of squared error loss. First, we assign a separate weight to localization error called $\\lambda_{\\text{coord}}$. It is usually set to 5.",Mt,Ys,_e,St,sp=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msup><mi mathvariant="script">L</mi><mi>i</mi></msup><mo>=</mo><msub><mi>λ</mi><mtext>coord</mtext></msub><msubsup><mi mathvariant="script">L</mi><mtext>coord</mtext><mi>i</mi></msubsup><mo>+</mo><msubsup><mi mathvariant="script">L</mi><mtext>conf</mtext><mi>i</mi></msubsup><mo>+</mo><msubsup><mi mathvariant="script">L</mi><mtext>class</mtext><mi>i</mi></msubsup><mspace linebreak="newline"></mspace></mrow><annotation encoding="application/x-tex">
\\mathcal{L}^{i} = \\lambda_{\\text{coord}}
    \\mathcal{L}^{i}_{\\text{coord}} + \\mathcal{L}^{i}_{\\text{conf}} + \\mathcal{L}^{i}_{\\text{class}}\\\\
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8747em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1217em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathnormal">λ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">coord</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">coord</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1217em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">conf</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1217em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">class</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span><span class="mspace newline"></span></span></span></span>`,Rt,Ns,Ln="In addition, many grid cells do not contain objects. The confidence is close to zero and thus the grid cells containing the objects often overpower the gradients. This makes the network unstable during training.",It,js,kn="To rectify, we also weigh the loss from the confidence predictions in the grid cells that do not contain objects lower than in the grid cells that contain objects. We use a separate weight for the confidence loss called $\\lambda_{\\text{noobj}}$, which is usually set to 0.5.",Ht,Ms,Te,qt,ap=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mi mathvariant="script">L</mi><mtext>conf</mtext><mi>i</mi></msubsup><mo>=</mo><munderover><mo>∑</mo><mrow><mi>b</mi><mo>=</mo><mn>0</mn></mrow><mi>B</mi></munderover><mrow><mo fence="true">[</mo><msubsup><mn mathvariant="double-struck">1</mn><mrow><mi>i</mi><mi>b</mi></mrow><mtext>obj</mtext></msubsup><msup><mrow><mo fence="true">(</mo><msub><mover accent="true"><mtext>conf</mtext><mo>^</mo></mover><mi>i</mi></msub><mo>−</mo><msub><mtext>conf</mtext><mi>i</mi></msub><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo>+</mo><msub><mi>λ</mi><mtext>noobj</mtext></msub><msubsup><mn mathvariant="double-struck">1</mn><mrow><mi>i</mi><mi>b</mi></mrow><mtext>noobj</mtext></msubsup><msup><mrow><mo fence="true">(</mo><msub><mover accent="true"><mtext>conf</mtext><mo>^</mo></mover><mi>i</mi></msub><mo>−</mo><msub><mtext>conf</mtext><mi>i</mi></msub><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo fence="true">]</mo></mrow></mrow><annotation encoding="application/x-tex">
\\mathcal{L}^{i}_{\\text{conf}} = \\sum_{b=0}^{B} \\left[
    \\mathbb{1}_{ib}^{\\text{obj}} \\left( \\hat{\\text{conf}}_{i} - \\text{conf}_{i} \\right)^2 +
    \\lambda_{\\text{noobj}} \\mathbb{1}_{ib}^{\\text{noobj}} \\left( \\hat{\\text{conf}}_{i} - \\text{conf}_{i} \\right)^2
\\right]
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1217em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">conf</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.1304em;vertical-align:-1.3021em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8479em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mrel mtight">=</span><span class="mord mtight">0</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.3021em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size3">[</span></span><span class="mord"><span class="mord">1</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.967em;"><span style="top:-2.3987em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span><span style="top:-3.1809em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">obj</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3013em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size2">(</span></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9579em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord text"><span class="mord">conf</span></span></span><span style="top:-3.2634em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.25em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord text"><span class="mord">conf</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size2">)</span></span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:1.354em;"><span style="top:-3.6029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal">λ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">noobj</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord">1</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.967em;"><span style="top:-2.3987em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span><span style="top:-3.1809em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">noobj</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3013em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size2">(</span></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9579em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord text"><span class="mord">conf</span></span></span><span style="top:-3.2634em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.25em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord text"><span class="mord">conf</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size2">)</span></span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:1.354em;"><span style="top:-3.6029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size3">]</span></span></span></span></span></span></span>`,At,Ss,_n="The sum of squared error for bounding box coordinates can be problematic. It equally weighs errors in large boxes and small boxes. The small deviations in large boxes should not be penalized as much as small deviations in small boxes.",Ft,Rs,Tn="To rectify, YOLOv1 uses a sum of squared error loss for the <strong>square root</strong> of the bounding box width and height. This makes the loss function scale invariant.",Bt,Is,Pe,Ut,tp=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mi mathvariant="script">L</mi><mtext>coord</mtext><mi>i</mi></msubsup><mo>=</mo><munderover><mo>∑</mo><mrow><mi>b</mi><mo>=</mo><mn>0</mn></mrow><mi>B</mi></munderover><msubsup><mn mathvariant="double-struck">1</mn><mrow><mi>i</mi><mi>b</mi></mrow><mtext>obj</mtext></msubsup><mrow><mo fence="true">[</mo><msup><mrow><mo fence="true">(</mo><msub><mover accent="true"><mi>x</mi><mo>^</mo></mover><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo>−</mo><msub><mi>x</mi><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo>+</mo><msup><mrow><mo fence="true">(</mo><msub><mover accent="true"><mi>y</mi><mo>^</mo></mover><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo>−</mo><msub><mi>y</mi><mrow><mi>i</mi><mi>b</mi></mrow></msub><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo>+</mo><msup><mrow><mo fence="true">(</mo><msqrt><msub><mover accent="true"><mi>w</mi><mo>^</mo></mover><mrow><mi>i</mi><mi>b</mi></mrow></msub></msqrt><mo>−</mo><msqrt><msub><mi>w</mi><mrow><mi>i</mi><mi>b</mi></mrow></msub></msqrt><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo>+</mo><msup><mrow><mo fence="true">(</mo><msqrt><msub><mover accent="true"><mi>h</mi><mo>^</mo></mover><mrow><mi>i</mi><mi>b</mi></mrow></msub></msqrt><mo>−</mo><msqrt><msub><mi>h</mi><mrow><mi>i</mi><mi>b</mi></mrow></msub></msqrt><mo fence="true">)</mo></mrow><mn>2</mn></msup><mo fence="true">]</mo></mrow></mrow><annotation encoding="application/x-tex">
\\mathcal{L}^{i}_{\\text{coord}} = \\sum_{b=0}^{B} \\mathbb{1}_{ib}^{\\text{obj}} \\left[ \\left( \\hat{x}_{ib} - x_{ib} \\right)^2 + \\left( \\hat{y}_{ib} - y_{ib} \\right)^2 +
\\left(
    \\sqrt{\\hat{w}_{ib}} - \\sqrt{w_{ib}}
\\right)^2 +
\\left(
    \\sqrt{\\hat{h}_{ib}} - \\sqrt{h_{ib}}
\\right)^2
\\right]
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1217em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8747em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">coord</span></span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.1304em;vertical-align:-1.3021em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8479em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mrel mtight">=</span><span class="mord mtight">0</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.3021em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord">1</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.967em;"><span style="top:-2.3987em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span><span style="top:-3.1809em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">obj</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3013em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size4">[</span></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;">(</span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.6944em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal">x</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2222em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;">)</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.954em;"><span style="top:-3.2029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;">(</span><span class="mord"><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6944em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.1944em;"><span class="mord">^</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;">)</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.954em;"><span style="top:-3.2029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size2">(</span></span><span class="mord sqrt"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.0061em;"><span class="svg-align" style="top:-3.2em;"><span class="pstrut" style="height:3.2em;"></span><span class="mord" style="padding-left:1em;"><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.6944em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.1667em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0269em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.9661em;"><span class="pstrut" style="height:3.2em;"></span><span class="hide-tail" style="min-width:1.02em;height:1.28em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='1.28em' viewBox='0 0 400000 1296' preserveAspectRatio='xMinYMin slice'><path d='M263,681c0.7,0,18,39.7,52,119
c34,79.3,68.167,158.7,102.5,238c34.3,79.3,51.8,119.3,52.5,120
c340,-704.7,510.7,-1060.3,512,-1067
l0 -0
c4.7,-7.3,11,-11,19,-11
H40000v40H1012.3
s-271.3,567,-271.3,567c-38.7,80.7,-84,175,-136,283c-52,108,-89.167,185.3,-111.5,232
c-22.3,46.7,-33.8,70.3,-34.5,71c-4.7,4.7,-12.3,7,-23,7s-12,-1,-12,-1
s-109,-253,-109,-253c-72.7,-168,-109.3,-252,-110,-252c-10.7,8,-22,16.7,-34,26
c-22,17.3,-33.3,26,-34,26s-26,-26,-26,-26s76,-59,76,-59s76,-60,76,-60z
M1001 80h400000v40h-400000z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2339em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord sqrt"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7742em;"><span class="svg-align" style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord" style="padding-left:0.833em;"><span class="mord"><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0269em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.7342em;"><span class="pstrut" style="height:3em;"></span><span class="hide-tail" style="min-width:0.853em;height:1.08em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='1.08em' viewBox='0 0 400000 1080' preserveAspectRatio='xMinYMin slice'><path d='M95,702
c-2.7,0,-7.17,-2.7,-13.5,-8c-5.8,-5.3,-9.5,-10,-9.5,-14
c0,-2,0.3,-3.3,1,-4c1.3,-2.7,23.83,-20.7,67.5,-54
c44.2,-33.3,65.8,-50.3,66.5,-51c1.3,-1.3,3,-2,5,-2c4.7,0,8.7,3.3,12,10
s173,378,173,378c0.7,0,35.3,-71,104,-213c68.7,-142,137.5,-285,206.5,-429
c69,-144,104.5,-217.7,106.5,-221
l0 -0
c5.3,-9.3,12,-14,20,-14
H400000v40H845.2724
s-225.272,467,-225.272,467s-235,486,-235,486c-2.7,4.7,-9,7,-19,7
c-6,0,-10,-1,-12,-3s-194,-422,-194,-422s-65,47,-65,47z
M834 80h400000v40h-400000z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2658em;"><span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size2">)</span></span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:1.354em;"><span style="top:-3.6029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="minner"><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size3">(</span></span><span class="mord sqrt"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.4378em;"><span class="svg-align" style="top:-3.8em;"><span class="pstrut" style="height:3.8em;"></span><span class="mord" style="padding-left:1em;"><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9579em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal">h</span></span><span style="top:-3.2634em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.25em;"><span class="mord">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-3.3978em;"><span class="pstrut" style="height:3.8em;"></span><span class="hide-tail" style="min-width:1.02em;height:1.88em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='1.88em' viewBox='0 0 400000 1944' preserveAspectRatio='xMinYMin slice'><path d='M983 90
l0 -0
c4,-6.7,10,-10,18,-10 H400000v40
H1013.1s-83.4,268,-264.1,840c-180.7,572,-277,876.3,-289,913c-4.7,4.7,-12.7,7,-24,7
s-12,0,-12,0c-1.3,-3.3,-3.7,-11.7,-7,-25c-35.3,-125.3,-106.7,-373.3,-214,-744
c-10,12,-21,25,-33,39s-32,39,-32,39c-6,-5.3,-15,-14,-27,-26s25,-30,25,-30
c26.7,-32.7,52,-63,76,-91s52,-60,52,-60s208,722,208,722
c56,-175.3,126.3,-397.3,211,-666c84.7,-268.7,153.8,-488.2,207.5,-658.5
c53.7,-170.3,84.5,-266.8,92.5,-289.5z
M1001 80h400000v40h-400000z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4022em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord sqrt"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.0061em;"><span class="svg-align" style="top:-3.2em;"><span class="pstrut" style="height:3.2em;"></span><span class="mord" style="padding-left:1em;"><span class="mord"><span class="mord mathnormal">h</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ib</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.9661em;"><span class="pstrut" style="height:3.2em;"></span><span class="hide-tail" style="min-width:1.02em;height:1.28em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='1.28em' viewBox='0 0 400000 1296' preserveAspectRatio='xMinYMin slice'><path d='M263,681c0.7,0,18,39.7,52,119
c34,79.3,68.167,158.7,102.5,238c34.3,79.3,51.8,119.3,52.5,120
c340,-704.7,510.7,-1060.3,512,-1067
l0 -0
c4.7,-7.3,11,-11,19,-11
H40000v40H1012.3
s-271.3,567,-271.3,567c-38.7,80.7,-84,175,-136,283c-52,108,-89.167,185.3,-111.5,232
c-22.3,46.7,-33.8,70.3,-34.5,71c-4.7,4.7,-12.3,7,-23,7s-12,-1,-12,-1
s-109,-253,-109,-253c-72.7,-168,-109.3,-252,-110,-252c-10.7,8,-22,16.7,-34,26
c-22,17.3,-33.3,26,-34,26s-26,-26,-26,-26s76,-59,76,-59s76,-60,76,-60z
M1001 80h400000v40h-400000z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2339em;"><span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size3">)</span></span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:1.654em;"><span style="top:-3.9029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size4">]</span></span></span></span></span></span></span>`,Et,Hs,Dt,qs,Pn="Inference is simple. We pass the image through the network and get the $S \\times S \\times (B \\times 5 + C)$ feature map. We then filter out the boxes which have confidence scores less than a threshold.",Gt,As,Wt,Fs,Yn="In rare cases, for large objects, the network tends to predict multiple boxes from multiple grid cells. To eliminate duplicate detections, we use a technique called Non-Maximum Suppression (NMS). NMS works by selecting the box with the highest confidence score and eliminating all other boxes with an IOU greater than a threshold. This is done iteratively until no overlapping boxes remain.",Kt,Bs,Nn=`The end to end flow looks like this:
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/object-detection-gif.gif" alt="nms"/>`,Vt,Us,Xt,Es,jn="So far, we have seen the basic characteristics of YOLO and how it allows for highly accurate and fast predictions. This was actually the first version of YOLO, called YOLOv1. YOLOv1 was released in 2015, and since then, multiple versions have been released. It was groundbreaking in terms of accuracy and speed, since it introduced the concept of using a single convolutional neural network (CNN) that processes the entire image at once, dividing it into an S × S grid. Each grid cell predicts bounding boxes and class probabilities directly. However, it suffered from poor localization and detection of multiple objects in small image areas. In the following years, many new versions were released by different teams to gradually improve the accuracy, speed, and robustness.",Qt,Ds,Jt,Gs,Mn="A year after releasing the first version, YOLOv2[5] came out. The improvements focused on both accuracy and speed, but also dealt with the localization problem. First, YOLOv2 replaced YOLOv1’s backbone architecture with Darknet-19, which is a variant of the Darknet architecture. Darknet-19 is lighter than the previous version’s backbone, and it consists of 19 convolutional layers followed by max-pooling layers. This led to YOLOv2 having the ability to capture more information. Also, it applied batch normalization to all convolutional layers and hence removed the dropout layers, dealing with the overfitting problem and increasing the mAP. It also introduced the concept of anchor boxes, which added prior knowledge to the width and height of the detected boxes (specifically, they used anchor boxes). Additionally, to deal with the poor localization, YOLOv2 predicted the class and objects for every anchor box and grid cell (now 13x13). So we have a maximum (for 5 anchor boxes) of 13x13x5 = 845 boxes.",Zt,Ws,se,Ks,Sn="YOLOv3[6] again significantly improved the detection speed and accuracy by replacing the Darknet-19 architecture with the more complex but efficient Darknet-53. Also, it dealt with the localization problem better by using three different scales for object detection (13x13, 26x26, and 52x52 grids). This helped find objects of different sizes in the same area. It increased the bounding boxes to: 13 x 13 x 3 + 26 x 26 x 3 + 52 x 52 x 3 = 10,647. Non-Maximum Suppression (NMS) was still used to filter out redundant overlapping boxes.",ae,Vs,te,Xs,Rn="Back in 2020, YOLOv4[7] became one of the best detection models in terms of speed and accuracy, achieving state-of-the-art results on object detection benchmarks. The authors changed the backbone architecture again, opting for the faster and more accurate CSPDarknet53[8]. An important improvement of this version was the optimization for efficient resource utilization, making it suitable for deployment on various hardware platforms, including edge devices. Also, it included a number of augmentations before training that further improved the model’s generalization. The authors included this improvement in a set of methodologies called bag-of-freebies. Bag-of-freebies are optimization methods that have a cost to the training process but aim to increase the model’s accuracy in real-time detection without increasing the inference time.",ee,Qs,ne,Js,In="YOLOv5[9] translated the Darknet framework (written in C) to the more flexible and easy-to-use PyTorch framework. This version automated the previous anchor detection mechanism, introducing the auto-anchors. Auto-anchors train the model anchors automatically to match your data. During training, YOLO automatically uses k-means initially and genetic methods to evolve the new better-matched anchors and places them back into the YOLO model. Also, it offers different types of models that depend on the hardware constraints, with names similar to today’s YOLOv8 models: YOLOv5s, YOLOv5m, YOLOv5l, and YOLOv5x.",pe,Zs,le,sa,Hn=`The next version, YOLOv6[10][11], was released by the Meituan Vision AI Department under the article title: “YOLOv6: A Single-Stage Object Detection Framework for Industry.” This team made further improvements in terms of speed and accuracy by focusing on five aspects:
1) Reparameterization using the RepVGG technique, which is a modified version of VGG with skip connections. During inference, these connections are fused to improve the speed.
2) Quantization of reparameterization-based detectors. Which added blocks that are called Rep-PANs.
3) Recognition of the importance of considering different hardware costs and capabilities for model deployment. Specifically, the authors tested the latency with lowpower GPUs (like Tesla T4) compared to the previous works which mostly used high-cost machines (like V100).
4) Introduction to new types of loss functions such as, Varifocal Loss for Classification. IoU Series Loss  for Bounding Box Regression, and Distribution Focal Loss.
5) Accuracy improvements during training using knowledge distillation.
In 2023, YOLOv6 v3[12] was released with the title “YOLOv6 v3.0: A Full-Scale Reload,”, which introduced enhancements to the network architecture and training scheme, once again advancing speed and accuracy (evaluated on the COCO dataset) compared to previously released versions.`,ie,aa,me,ta,qn="YOLOv7 was released with the paper titled “YOLOv7: Trainable bag-of-freebies sets new state-of-the-art for real-time object detectors”[13][14] by the authors of YOLOv4. Specifically, this version of bag-of-freebies includes a new label assignment method called coarse-to-fine lead-guided label assignment and uses gradient flow propagation paths to analyze how re-parameterized convolution should be combined with different networks. They also proposed “extend” and “compound scaling” methods for the real-time object detector that can effectively utilize parameters and computation. Again, all these improvements took real-time object detection to a new state-of-the-art, outperforming previous releases.",re,ea,oe,na,An="YOLOv8[15], developed by Ultralytics in 2023, became again the new SOTA. It introduced improvements on the backbone and neck alongside an anchor-free approach, which eliminates the need for predefined anchor boxes. Instead, predictions are made directly. This version supports a wide range of vision tasks, including classification, segmentation, and pose estimation. Additionally, YOLOv8 has scaling capabilities with pre-trained models available in various sizes: nano, small, medium, large, and extra-large, and can be easily fine-tuned on custom datasets.",ce,pa,he,la,Fn="YOLOv9 was released with the paper titled “YOLOv9: Learning What You Want to Learn Using Programmable Gradient Information”[16][17] by the same authors as YOLOv7 and YOLOv4. This paper highlights the issue of information loss that existing methods and architectures have during layer-by-layer feature extraction and spatial transformation. To address this issue, the authors proposed:",ge,ia,Bn="<li>Concept of programmable gradient information (PGI) to cope with the various changes required by deep networks to achieve multiple objectives.</li> <li>Generalized Efficient Layer Aggregation Network (GELAN), a new lightweight network architecture that achieves better parameter utilization than the current methods without sacrificing computational efficiency.</li>",de,ma,Un="With these changes, YOLOv9 set new benchmarks on the MS COCO challenge.",ue,ra,En=`Taking into consideration the timeline and the different licensing of the models we can create the following figure:
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/yolo_evolution.png" alt="yolo_evolution"/>`,ve,oa,ye,ca,Dn=`This short chapter presented the history/evolution of YOLO in a linear way. However, this is not the case — many other versions of YOLO were released in parallel. Notice the release of YOLOv4 and YOLOv5 in the same year. Other versions that we did not cover include YOLOvX (2021), which was based on YOLOv3 (2018), and YOLOR (2021), which was based on YOLOv4 (2020), and many others.
Also, it is important to understand that the selection of the ‘best’ model version depends on the user requirements, such as speed, accuracy, hardware limitations, and user-friendliness. For example, YOLOv2 is very good at speed. YOLOv3 provides a balance between accuracy and speed. YOLOv4 has the best ability for adapting or being compatible across different hardware.`,fe,ha,be,ga,Gn=`[1][Rich feature hierarchies for accurate object detection and semantic segmentation](<a href="https://arxiv.org/abs/1311.2524v5" rel="nofollow">https://arxiv.org/abs/1311.2524v5</a>) <br/>
[2][Fast R-CNN](<a href="https://arxiv.org/abs/1504.08083" rel="nofollow">https://arxiv.org/abs/1504.08083</a>) <br/>
[3][Faster R-CNN](<a href="https://arxiv.org/pdf/1506.01497.pdf" rel="nofollow">https://arxiv.org/pdf/1506.01497.pdf</a>) <br/>
[4][Feature Pyramid Network](<a href="https://arxiv.org/pdf/1612.03144.pdf" rel="nofollow">https://arxiv.org/pdf/1612.03144.pdf</a>) <br/>
[5][YOLO9000: Better, Faster, Stronger](<a href="https://arxiv.org/abs/1612.08242" rel="nofollow">https://arxiv.org/abs/1612.08242</a>) <br/>
[6][YOLOv3: An Incremental Improvement](<a href="https://arxiv.org/abs/1804.02767" rel="nofollow">https://arxiv.org/abs/1804.02767</a>) <br/>
[7][YOLOv4: Optimal Speed and Accuracy of Object Detection](<a href="https://arxiv.org/abs/2004.10934" rel="nofollow">https://arxiv.org/abs/2004.10934</a>) <br/>
[8][YOLOv4 GitHub repo](<a href="https://github.com/AlexeyAB/darknet" rel="nofollow">https://github.com/AlexeyAB/darknet</a>) <br/>
[9][Ultralytics YOLOv5](<a href="https://docs.ultralytics.com/models/yolov5/" rel="nofollow">https://docs.ultralytics.com/models/yolov5/</a>) <br/>
[10][YOLOv6: A Single-Stage Object Detection Framework for Industrial Applications](<a href="https://arxiv.org/abs/2209.02976" rel="nofollow">https://arxiv.org/abs/2209.02976</a>) <br/>
[11][YOLOv6 GitHub repo](<a href="https://github.com/meituan/YOLOv6" rel="nofollow">https://github.com/meituan/YOLOv6</a>) <br/>
[12][YOLOv6 v3.0: A Full-Scale Reloading](<a href="https://arxiv.org/abs/2301.05586" rel="nofollow">https://arxiv.org/abs/2301.05586</a>) <br/>
[13][YOLOv7: Trainable bag-of-freebies sets new state-of-the-art for real-time object detectors](<a href="https://arxiv.org/abs/2207.02696" rel="nofollow">https://arxiv.org/abs/2207.02696</a>) <br/>
[14][YOLOv7 GitHub repo](<a href="https://github.com/WongKinYiu/yolov7" rel="nofollow">https://github.com/WongKinYiu/yolov7</a>) <br/>
[15][Ultralytics YOLOv8](<a href="https://github.com/ultralytics/ultralytics" rel="nofollow">https://github.com/ultralytics/ultralytics</a>) <br/>
[16][YOLOv9: Learning What You Want to Learn Using Programmable Gradient Information](<a href="https://arxiv.org/abs/2402.13616" rel="nofollow">https://arxiv.org/abs/2402.13616</a>) <br/>
[17][YOLOv9 GitHub repo](<a href="https://github.com/WongKinYiu/yolov9" rel="nofollow">https://github.com/WongKinYiu/yolov9</a>) <br/>
[18][YOLOvX](<a href="https://yolovx.com/" rel="nofollow">https://yolovx.com/</a>) <br/>
[19][You Only Learn One Representation: Unified Network for Multiple Tasks](<a href="https://arxiv.org/abs/2105.04206" rel="nofollow">https://arxiv.org/abs/2105.04206</a>)
[20][Feature Pyramid network Paper](<a href="https://arxiv.org/abs/1612.03144" rel="nofollow">https://arxiv.org/abs/1612.03144</a>)`,xe,da,we,va,ze;return O=new u({props:{title:"YOLO",local:"yolo",headingTag:"h1"}}),C=new u({props:{title:"A short introduction to Object Detection",local:"a-short-introduction-to-object-detection",headingTag:"h2"}}),k=new u({props:{title:"RCNN, Fast RCNN, Faster RCNN",local:"rcnn-fast-rcnn-faster-rcnn",headingTag:"h3"}}),_=new u({props:{title:"R- CNN (Region-based Convolutional Neural Networks)",local:"r--cnn-region-based-convolutional-neural-networks",headingTag:"h4"}}),S=new u({props:{title:"Fast RCNN",local:"fast-rcnn",headingTag:"h4"}}),q=new u({props:{title:"Faster RCNN",local:"faster-rcnn",headingTag:"h4"}}),U=new u({props:{title:"Feature Pyramid Network (FPN)",local:"feature-pyramid-network-fpn",headingTag:"h4"}}),W=new u({props:{title:"YOLO architecture",local:"yolo-architecture",headingTag:"h2"}}),V=new u({props:{title:"Before YOLO",local:"before-yolo",headingTag:"h3"}}),Z=new u({props:{title:"YOLO",local:"yolo",headingTag:"h3"}}),as=new u({props:{title:"Reframing Object Detection",local:"reframing-object-detection",headingTag:"h4"}}),ns=new u({props:{title:"Confidence",local:"confidence",headingTag:"h4"}}),is=new u({props:{title:"Coordinates",local:"coordinates",headingTag:"h4"}}),rs=new u({props:{title:"Class",local:"class",headingTag:"h4"}}),us=new u({props:{title:"Network Architecture",local:"network-architecture",headingTag:"h4"}}),ws=new u({props:{title:"Training",local:"training",headingTag:"h4"}}),Os=new u({props:{title:"Loss Function",local:"loss-function",headingTag:"h5"}}),Hs=new u({props:{title:"Inference",local:"inference",headingTag:"h4"}}),As=new u({props:{title:"Non-Maximum Suppression",local:"non-maximum-suppression",headingTag:"h5"}}),Us=new u({props:{title:"Evolution of YOLO",local:"evolution-of-yolo",headingTag:"h2"}}),Ds=new u({props:{title:"YOLOv2 (2016)",local:"yolov2-2016",headingTag:"h3"}}),Ws=new u({props:{title:"YOLOv3 (2018)",local:"yolov3-2018",headingTag:"h3"}}),Vs=new u({props:{title:"YOLOv4 (2020)",local:"yolov4-2020",headingTag:"h3"}}),Qs=new u({props:{title:"YOLOv5 (2020)",local:"yolov5-2020",headingTag:"h3"}}),Zs=new u({props:{title:"YOLOv6 (2022)",local:"yolov6-2022",headingTag:"h3"}}),aa=new u({props:{title:"YOLOv7 (2022)",local:"yolov7-2022",headingTag:"h3"}}),ea=new u({props:{title:"YOLOv8 (2023)",local:"yolov8-2023",headingTag:"h3"}}),pa=new u({props:{title:"YOLOv9 (2024)",local:"yolov9-2024",headingTag:"h3"}}),oa=new u({props:{title:"Note about the different versions",local:"note-about-the-different-versions",headingTag:"h3"}}),ha=new u({props:{title:"Reference",local:"reference",headingTag:"h2"}}),da=new rp({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit2/cnns/yolo.mdx"}}),{c(){f=l("meta"),fa=n(),ua=l("p"),ba=n(),r(O.$$.fragment),xa=n(),r(C.$$.fragment),wa=n(),L=l("p"),L.textContent=qe,za=n(),r(k.$$.fragment),$a=n(),r(_.$$.fragment),Oa=n(),T=l("p"),T.textContent=Ae,Ca=n(),P=l("p"),P.textContent=Fe,La=n(),Y=l("ol"),Y.innerHTML=Be,ka=n(),N=l("p"),N.textContent=Ue,_a=n(),j=l("ol"),j.innerHTML=Ee,Ta=n(),M=l("p"),M.innerHTML=De,Pa=n(),r(S.$$.fragment),Ya=n(),R=l("p"),R.textContent=Ge,Na=n(),I=l("ul"),I.innerHTML=We,ja=n(),H=l("p"),H.innerHTML=Ke,Ma=n(),r(q.$$.fragment),Sa=n(),A=l("p"),A.textContent=Ve,Ra=n(),F=l("ul"),F.innerHTML=Xe,Ia=n(),B=l("p"),B.innerHTML=Qe,Ha=n(),r(U.$$.fragment),qa=n(),E=l("ul"),E.innerHTML=Je,Aa=n(),D=l("p"),D.textContent=Ze,Fa=n(),G=l("p"),G.innerHTML=sn,Ba=n(),r(W.$$.fragment),Ua=n(),K=l("p"),K.textContent=an,Ea=n(),r(V.$$.fragment),Da=n(),X=l("p"),X.textContent=tn,Ga=n(),Q=l("p"),Q.textContent=en,Wa=n(),J=l("p"),J.textContent=nn,Ka=n(),r(Z.$$.fragment),Va=n(),ss=l("p"),ss.textContent=pn,Xa=n(),r(as.$$.fragment),Qa=n(),ts=l("p"),ts.textContent=ln,Ja=n(),es=l("p"),es.textContent=mn,Za=n(),r(ns.$$.fragment),st=n(),ps=l("p"),ps.textContent=rn,at=n(),ls=l("p"),$e=z(`Formally,
`),tt=new x(!1),et=n(),r(is.$$.fragment),nt=n(),ms=l("p"),ms.textContent=on,pt=n(),r(rs.$$.fragment),lt=n(),os=l("p"),os.textContent=cn,it=n(),cs=l("p"),Oe=z("Formally,"),mt=new x(!1),rt=n(),hs=l("p"),Ce=z(`At test time, we multiply the conditional class probabilities and the individual box confidence predictions, which gives us class-specific confidence scores for each box. These scores encode both the probability of that class appearing in the box and how well the predicted box fits the object.
`),ot=new x(!1),ct=n(),gs=l("p"),gs.textContent=hn,ht=n(),ds=l("p"),ds.textContent=gn,gt=n(),r(us.$$.fragment),dt=n(),vs=l("p"),vs.textContent=dn,ut=n(),ys=l("p"),ys.textContent=un,vt=n(),fs=l("p"),Le=z(`The YOLOv1 design took inspiration from GoogLeNet, which used 1x1 convolutions to reduce the depth of the feature maps. This was done to reduce the number of parameters and the amount of computation in the network. The network has 24 convolutional layers followed by 2 fully connected layers. It uses a linear activation function for the final layer, and all other layers use the leaky rectified linear activation:
`),yt=new x(!1),ft=n(),bs=l("p"),bs.textContent=vn,bt=n(),xs=l("p"),xs.innerHTML=yn,xt=n(),r(ws.$$.fragment),wt=n(),zs=l("p"),zs.textContent=fn,zt=n(),$s=l("p"),$s.textContent=bn,$t=n(),r(Os.$$.fragment),Ot=n(),Cs=l("p"),Cs.textContent=xn,Ct=n(),Ls=l("p"),Ls.textContent=wn,Lt=n(),b=l("p"),ke=z(`The loss for each grid cell $(i)$ can look like this:
`),kt=new x(!1),_t=n(),Tt=new x(!1),Pt=n(),ks=l("p"),ks.textContent=zn,Yt=n(),_s=l("ul"),_s.innerHTML=$n,Nt=n(),Ts=l("p"),Ts.textContent=On,jt=n(),Ps=l("p"),Ps.textContent=Cn,Mt=n(),Ys=l("p"),_e=z("So the loss for each grid cell $(i)$ can look like this:"),St=new x(!1),Rt=n(),Ns=l("p"),Ns.textContent=Ln,It=n(),js=l("p"),js.textContent=kn,Ht=n(),Ms=l("p"),Te=z("So the confidence loss for each grid cell $(i)$ can look like this:"),qt=new x(!1),At=n(),Ss=l("p"),Ss.textContent=_n,Ft=n(),Rs=l("p"),Rs.innerHTML=Tn,Bt=n(),Is=l("p"),Pe=z(`So the localization loss for each grid cell $(i)$ can look like this:
`),Ut=new x(!1),Et=n(),r(Hs.$$.fragment),Dt=n(),qs=l("p"),qs.textContent=Pn,Gt=n(),r(As.$$.fragment),Wt=n(),Fs=l("p"),Fs.textContent=Yn,Kt=n(),Bs=l("p"),Bs.innerHTML=Nn,Vt=n(),r(Us.$$.fragment),Xt=n(),Es=l("p"),Es.textContent=jn,Qt=n(),r(Ds.$$.fragment),Jt=n(),Gs=l("p"),Gs.textContent=Mn,Zt=n(),r(Ws.$$.fragment),se=n(),Ks=l("p"),Ks.textContent=Sn,ae=n(),r(Vs.$$.fragment),te=n(),Xs=l("p"),Xs.textContent=Rn,ee=n(),r(Qs.$$.fragment),ne=n(),Js=l("p"),Js.textContent=In,pe=n(),r(Zs.$$.fragment),le=n(),sa=l("p"),sa.textContent=Hn,ie=n(),r(aa.$$.fragment),me=n(),ta=l("p"),ta.textContent=qn,re=n(),r(ea.$$.fragment),oe=n(),na=l("p"),na.textContent=An,ce=n(),r(pa.$$.fragment),he=n(),la=l("p"),la.textContent=Fn,ge=n(),ia=l("ul"),ia.innerHTML=Bn,de=n(),ma=l("p"),ma.textContent=Un,ue=n(),ra=l("p"),ra.innerHTML=En,ve=n(),r(oa.$$.fragment),ye=n(),ca=l("p"),ca.textContent=Dn,fe=n(),r(ha.$$.fragment),be=n(),ga=l("p"),ga.innerHTML=Gn,xe=n(),r(da.$$.fragment),we=n(),va=l("p"),this.h()},l(s){const a=mp("svelte-u9bgzb",document.head);f=i(a,"META",{name:!0,content:!0}),a.forEach(t),fa=p(s),ua=i(s,"P",{}),v(ua).forEach(t),ba=p(s),o(O.$$.fragment,s),xa=p(s),o(C.$$.fragment,s),wa=p(s),L=i(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-44eeq6"&&(L.textContent=qe),za=p(s),o(k.$$.fragment,s),$a=p(s),o(_.$$.fragment,s),Oa=p(s),T=i(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-gevjsz"&&(T.textContent=Ae),Ca=p(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-iu9c9q"&&(P.textContent=Fe),La=p(s),Y=i(s,"OL",{"data-svelte-h":!0}),m(Y)!=="svelte-1tmkrqm"&&(Y.innerHTML=Be),ka=p(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-192j6x5"&&(N.textContent=Ue),_a=p(s),j=i(s,"OL",{"data-svelte-h":!0}),m(j)!=="svelte-g51e7w"&&(j.innerHTML=Ee),Ta=p(s),M=i(s,"P",{"data-svelte-h":!0}),m(M)!=="svelte-o83vjz"&&(M.innerHTML=De),Pa=p(s),o(S.$$.fragment,s),Ya=p(s),R=i(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-bq7cnw"&&(R.textContent=Ge),Na=p(s),I=i(s,"UL",{"data-svelte-h":!0}),m(I)!=="svelte-px63f5"&&(I.innerHTML=We),ja=p(s),H=i(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-l3fqzp"&&(H.innerHTML=Ke),Ma=p(s),o(q.$$.fragment,s),Sa=p(s),A=i(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-19rolk7"&&(A.textContent=Ve),Ra=p(s),F=i(s,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-c8smom"&&(F.innerHTML=Xe),Ia=p(s),B=i(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-iag2le"&&(B.innerHTML=Qe),Ha=p(s),o(U.$$.fragment,s),qa=p(s),E=i(s,"UL",{"data-svelte-h":!0}),m(E)!=="svelte-zi4zwq"&&(E.innerHTML=Je),Aa=p(s),D=i(s,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1yda85i"&&(D.textContent=Ze),Fa=p(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1e5k2dt"&&(G.innerHTML=sn),Ba=p(s),o(W.$$.fragment,s),Ua=p(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-t2ng0z"&&(K.textContent=an),Ea=p(s),o(V.$$.fragment,s),Da=p(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1a6pwhd"&&(X.textContent=tn),Ga=p(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-vlnniq"&&(Q.textContent=en),Wa=p(s),J=i(s,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1p6f06g"&&(J.textContent=nn),Ka=p(s),o(Z.$$.fragment,s),Va=p(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-1m5fqil"&&(ss.textContent=pn),Xa=p(s),o(as.$$.fragment,s),Qa=p(s),ts=i(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-13tfsac"&&(ts.textContent=ln),Ja=p(s),es=i(s,"P",{"data-svelte-h":!0}),m(es)!=="svelte-1hf1854"&&(es.textContent=mn),Za=p(s),o(ns.$$.fragment,s),st=p(s),ps=i(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-1r42z5o"&&(ps.textContent=rn),at=p(s),ls=i(s,"P",{});var Ye=v(ls);$e=$(Ye,`Formally,
`),tt=w(Ye,!1),Ye.forEach(t),et=p(s),o(is.$$.fragment,s),nt=p(s),ms=i(s,"P",{"data-svelte-h":!0}),m(ms)!=="svelte-fnhh14"&&(ms.textContent=on),pt=p(s),o(rs.$$.fragment,s),lt=p(s),os=i(s,"P",{"data-svelte-h":!0}),m(os)!=="svelte-1sht3ao"&&(os.textContent=cn),it=p(s),cs=i(s,"P",{});var Ne=v(cs);Oe=$(Ne,"Formally,"),mt=w(Ne,!1),Ne.forEach(t),rt=p(s),hs=i(s,"P",{});var je=v(hs);Ce=$(je,`At test time, we multiply the conditional class probabilities and the individual box confidence predictions, which gives us class-specific confidence scores for each box. These scores encode both the probability of that class appearing in the box and how well the predicted box fits the object.
`),ot=w(je,!1),je.forEach(t),ct=p(s),gs=i(s,"P",{"data-svelte-h":!0}),m(gs)!=="svelte-rgk0d2"&&(gs.textContent=hn),ht=p(s),ds=i(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-rbqrpv"&&(ds.textContent=gn),gt=p(s),o(us.$$.fragment,s),dt=p(s),vs=i(s,"P",{"data-svelte-h":!0}),m(vs)!=="svelte-kwy4md"&&(vs.textContent=dn),ut=p(s),ys=i(s,"P",{"data-svelte-h":!0}),m(ys)!=="svelte-16xyxuk"&&(ys.textContent=un),vt=p(s),fs=i(s,"P",{});var Me=v(fs);Le=$(Me,`The YOLOv1 design took inspiration from GoogLeNet, which used 1x1 convolutions to reduce the depth of the feature maps. This was done to reduce the number of parameters and the amount of computation in the network. The network has 24 convolutional layers followed by 2 fully connected layers. It uses a linear activation function for the final layer, and all other layers use the leaky rectified linear activation:
`),yt=w(Me,!1),Me.forEach(t),ft=p(s),bs=i(s,"P",{"data-svelte-h":!0}),m(bs)!=="svelte-1xvoeje"&&(bs.textContent=vn),bt=p(s),xs=i(s,"P",{"data-svelte-h":!0}),m(xs)!=="svelte-1wizz4x"&&(xs.innerHTML=yn),xt=p(s),o(ws.$$.fragment,s),wt=p(s),zs=i(s,"P",{"data-svelte-h":!0}),m(zs)!=="svelte-1a9zc86"&&(zs.textContent=fn),zt=p(s),$s=i(s,"P",{"data-svelte-h":!0}),m($s)!=="svelte-11os2se"&&($s.textContent=bn),$t=p(s),o(Os.$$.fragment,s),Ot=p(s),Cs=i(s,"P",{"data-svelte-h":!0}),m(Cs)!=="svelte-t4ro0w"&&(Cs.textContent=xn),Ct=p(s),Ls=i(s,"P",{"data-svelte-h":!0}),m(Ls)!=="svelte-1d4212h"&&(Ls.textContent=wn),Lt=p(s),b=i(s,"P",{});var ya=v(b);ke=$(ya,`The loss for each grid cell $(i)$ can look like this:
`),kt=w(ya,!1),_t=p(ya),Tt=w(ya,!1),ya.forEach(t),Pt=p(s),ks=i(s,"P",{"data-svelte-h":!0}),m(ks)!=="svelte-d9l6yv"&&(ks.textContent=zn),Yt=p(s),_s=i(s,"UL",{"data-svelte-h":!0}),m(_s)!=="svelte-rsqa99"&&(_s.innerHTML=$n),Nt=p(s),Ts=i(s,"P",{"data-svelte-h":!0}),m(Ts)!=="svelte-ufw4ig"&&(Ts.textContent=On),jt=p(s),Ps=i(s,"P",{"data-svelte-h":!0}),m(Ps)!=="svelte-1ujt87l"&&(Ps.textContent=Cn),Mt=p(s),Ys=i(s,"P",{});var Se=v(Ys);_e=$(Se,"So the loss for each grid cell $(i)$ can look like this:"),St=w(Se,!1),Se.forEach(t),Rt=p(s),Ns=i(s,"P",{"data-svelte-h":!0}),m(Ns)!=="svelte-1d14bex"&&(Ns.textContent=Ln),It=p(s),js=i(s,"P",{"data-svelte-h":!0}),m(js)!=="svelte-t53whb"&&(js.textContent=kn),Ht=p(s),Ms=i(s,"P",{});var Re=v(Ms);Te=$(Re,"So the confidence loss for each grid cell $(i)$ can look like this:"),qt=w(Re,!1),Re.forEach(t),At=p(s),Ss=i(s,"P",{"data-svelte-h":!0}),m(Ss)!=="svelte-1empphz"&&(Ss.textContent=_n),Ft=p(s),Rs=i(s,"P",{"data-svelte-h":!0}),m(Rs)!=="svelte-ns6hiw"&&(Rs.innerHTML=Tn),Bt=p(s),Is=i(s,"P",{});var Ie=v(Is);Pe=$(Ie,`So the localization loss for each grid cell $(i)$ can look like this:
`),Ut=w(Ie,!1),Ie.forEach(t),Et=p(s),o(Hs.$$.fragment,s),Dt=p(s),qs=i(s,"P",{"data-svelte-h":!0}),m(qs)!=="svelte-1mta3wv"&&(qs.textContent=Pn),Gt=p(s),o(As.$$.fragment,s),Wt=p(s),Fs=i(s,"P",{"data-svelte-h":!0}),m(Fs)!=="svelte-rwf8te"&&(Fs.textContent=Yn),Kt=p(s),Bs=i(s,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-h0mjxm"&&(Bs.innerHTML=Nn),Vt=p(s),o(Us.$$.fragment,s),Xt=p(s),Es=i(s,"P",{"data-svelte-h":!0}),m(Es)!=="svelte-swemwl"&&(Es.textContent=jn),Qt=p(s),o(Ds.$$.fragment,s),Jt=p(s),Gs=i(s,"P",{"data-svelte-h":!0}),m(Gs)!=="svelte-1lt6ugx"&&(Gs.textContent=Mn),Zt=p(s),o(Ws.$$.fragment,s),se=p(s),Ks=i(s,"P",{"data-svelte-h":!0}),m(Ks)!=="svelte-ub9rxj"&&(Ks.textContent=Sn),ae=p(s),o(Vs.$$.fragment,s),te=p(s),Xs=i(s,"P",{"data-svelte-h":!0}),m(Xs)!=="svelte-1mfrmzf"&&(Xs.textContent=Rn),ee=p(s),o(Qs.$$.fragment,s),ne=p(s),Js=i(s,"P",{"data-svelte-h":!0}),m(Js)!=="svelte-dzjfzw"&&(Js.textContent=In),pe=p(s),o(Zs.$$.fragment,s),le=p(s),sa=i(s,"P",{"data-svelte-h":!0}),m(sa)!=="svelte-18t4l6p"&&(sa.textContent=Hn),ie=p(s),o(aa.$$.fragment,s),me=p(s),ta=i(s,"P",{"data-svelte-h":!0}),m(ta)!=="svelte-ben89t"&&(ta.textContent=qn),re=p(s),o(ea.$$.fragment,s),oe=p(s),na=i(s,"P",{"data-svelte-h":!0}),m(na)!=="svelte-hfkvk6"&&(na.textContent=An),ce=p(s),o(pa.$$.fragment,s),he=p(s),la=i(s,"P",{"data-svelte-h":!0}),m(la)!=="svelte-9g0jbs"&&(la.textContent=Fn),ge=p(s),ia=i(s,"UL",{"data-svelte-h":!0}),m(ia)!=="svelte-1toitx1"&&(ia.innerHTML=Bn),de=p(s),ma=i(s,"P",{"data-svelte-h":!0}),m(ma)!=="svelte-1urlb0n"&&(ma.textContent=Un),ue=p(s),ra=i(s,"P",{"data-svelte-h":!0}),m(ra)!=="svelte-1juv9dj"&&(ra.innerHTML=En),ve=p(s),o(oa.$$.fragment,s),ye=p(s),ca=i(s,"P",{"data-svelte-h":!0}),m(ca)!=="svelte-13yg5lf"&&(ca.textContent=Dn),fe=p(s),o(ha.$$.fragment,s),be=p(s),ga=i(s,"P",{"data-svelte-h":!0}),m(ga)!=="svelte-zdm0iw"&&(ga.innerHTML=Gn),xe=p(s),o(da.$$.fragment,s),we=p(s),va=i(s,"P",{}),v(va).forEach(t),this.h()},h(){Wn(f,"name","hf:doc:metadata"),Wn(f,"content",cp),tt.a=null,mt.a=null,ot.a=null,yt.a=null,kt.a=_t,Tt.a=null,St.a=null,qt.a=null,Ut.a=null},m(s,a){y(document.head,f),e(s,fa,a),e(s,ua,a),e(s,ba,a),c(O,s,a),e(s,xa,a),c(C,s,a),e(s,wa,a),e(s,L,a),e(s,za,a),c(k,s,a),e(s,$a,a),c(_,s,a),e(s,Oa,a),e(s,T,a),e(s,Ca,a),e(s,P,a),e(s,La,a),e(s,Y,a),e(s,ka,a),e(s,N,a),e(s,_a,a),e(s,j,a),e(s,Ta,a),e(s,M,a),e(s,Pa,a),c(S,s,a),e(s,Ya,a),e(s,R,a),e(s,Na,a),e(s,I,a),e(s,ja,a),e(s,H,a),e(s,Ma,a),c(q,s,a),e(s,Sa,a),e(s,A,a),e(s,Ra,a),e(s,F,a),e(s,Ia,a),e(s,B,a),e(s,Ha,a),c(U,s,a),e(s,qa,a),e(s,E,a),e(s,Aa,a),e(s,D,a),e(s,Fa,a),e(s,G,a),e(s,Ba,a),c(W,s,a),e(s,Ua,a),e(s,K,a),e(s,Ea,a),c(V,s,a),e(s,Da,a),e(s,X,a),e(s,Ga,a),e(s,Q,a),e(s,Wa,a),e(s,J,a),e(s,Ka,a),c(Z,s,a),e(s,Va,a),e(s,ss,a),e(s,Xa,a),c(as,s,a),e(s,Qa,a),e(s,ts,a),e(s,Ja,a),e(s,es,a),e(s,Za,a),c(ns,s,a),e(s,st,a),e(s,ps,a),e(s,at,a),e(s,ls,a),y(ls,$e),tt.m(Kn,ls),e(s,et,a),c(is,s,a),e(s,nt,a),e(s,ms,a),e(s,pt,a),c(rs,s,a),e(s,lt,a),e(s,os,a),e(s,it,a),e(s,cs,a),y(cs,Oe),mt.m(Vn,cs),e(s,rt,a),e(s,hs,a),y(hs,Ce),ot.m(Xn,hs),e(s,ct,a),e(s,gs,a),e(s,ht,a),e(s,ds,a),e(s,gt,a),c(us,s,a),e(s,dt,a),e(s,vs,a),e(s,ut,a),e(s,ys,a),e(s,vt,a),e(s,fs,a),y(fs,Le),yt.m(Qn,fs),e(s,ft,a),e(s,bs,a),e(s,bt,a),e(s,xs,a),e(s,xt,a),c(ws,s,a),e(s,wt,a),e(s,zs,a),e(s,zt,a),e(s,$s,a),e(s,$t,a),c(Os,s,a),e(s,Ot,a),e(s,Cs,a),e(s,Ct,a),e(s,Ls,a),e(s,Lt,a),e(s,b,a),y(b,ke),kt.m(Jn,b),y(b,_t),Tt.m(Zn,b),e(s,Pt,a),e(s,ks,a),e(s,Yt,a),e(s,_s,a),e(s,Nt,a),e(s,Ts,a),e(s,jt,a),e(s,Ps,a),e(s,Mt,a),e(s,Ys,a),y(Ys,_e),St.m(sp,Ys),e(s,Rt,a),e(s,Ns,a),e(s,It,a),e(s,js,a),e(s,Ht,a),e(s,Ms,a),y(Ms,Te),qt.m(ap,Ms),e(s,At,a),e(s,Ss,a),e(s,Ft,a),e(s,Rs,a),e(s,Bt,a),e(s,Is,a),y(Is,Pe),Ut.m(tp,Is),e(s,Et,a),c(Hs,s,a),e(s,Dt,a),e(s,qs,a),e(s,Gt,a),c(As,s,a),e(s,Wt,a),e(s,Fs,a),e(s,Kt,a),e(s,Bs,a),e(s,Vt,a),c(Us,s,a),e(s,Xt,a),e(s,Es,a),e(s,Qt,a),c(Ds,s,a),e(s,Jt,a),e(s,Gs,a),e(s,Zt,a),c(Ws,s,a),e(s,se,a),e(s,Ks,a),e(s,ae,a),c(Vs,s,a),e(s,te,a),e(s,Xs,a),e(s,ee,a),c(Qs,s,a),e(s,ne,a),e(s,Js,a),e(s,pe,a),c(Zs,s,a),e(s,le,a),e(s,sa,a),e(s,ie,a),c(aa,s,a),e(s,me,a),e(s,ta,a),e(s,re,a),c(ea,s,a),e(s,oe,a),e(s,na,a),e(s,ce,a),c(pa,s,a),e(s,he,a),e(s,la,a),e(s,ge,a),e(s,ia,a),e(s,de,a),e(s,ma,a),e(s,ue,a),e(s,ra,a),e(s,ve,a),c(oa,s,a),e(s,ye,a),e(s,ca,a),e(s,fe,a),c(ha,s,a),e(s,be,a),e(s,ga,a),e(s,xe,a),c(da,s,a),e(s,we,a),e(s,va,a),ze=!0},p:np,i(s){ze||(h(O.$$.fragment,s),h(C.$$.fragment,s),h(k.$$.fragment,s),h(_.$$.fragment,s),h(S.$$.fragment,s),h(q.$$.fragment,s),h(U.$$.fragment,s),h(W.$$.fragment,s),h(V.$$.fragment,s),h(Z.$$.fragment,s),h(as.$$.fragment,s),h(ns.$$.fragment,s),h(is.$$.fragment,s),h(rs.$$.fragment,s),h(us.$$.fragment,s),h(ws.$$.fragment,s),h(Os.$$.fragment,s),h(Hs.$$.fragment,s),h(As.$$.fragment,s),h(Us.$$.fragment,s),h(Ds.$$.fragment,s),h(Ws.$$.fragment,s),h(Vs.$$.fragment,s),h(Qs.$$.fragment,s),h(Zs.$$.fragment,s),h(aa.$$.fragment,s),h(ea.$$.fragment,s),h(pa.$$.fragment,s),h(oa.$$.fragment,s),h(ha.$$.fragment,s),h(da.$$.fragment,s),ze=!0)},o(s){g(O.$$.fragment,s),g(C.$$.fragment,s),g(k.$$.fragment,s),g(_.$$.fragment,s),g(S.$$.fragment,s),g(q.$$.fragment,s),g(U.$$.fragment,s),g(W.$$.fragment,s),g(V.$$.fragment,s),g(Z.$$.fragment,s),g(as.$$.fragment,s),g(ns.$$.fragment,s),g(is.$$.fragment,s),g(rs.$$.fragment,s),g(us.$$.fragment,s),g(ws.$$.fragment,s),g(Os.$$.fragment,s),g(Hs.$$.fragment,s),g(As.$$.fragment,s),g(Us.$$.fragment,s),g(Ds.$$.fragment,s),g(Ws.$$.fragment,s),g(Vs.$$.fragment,s),g(Qs.$$.fragment,s),g(Zs.$$.fragment,s),g(aa.$$.fragment,s),g(ea.$$.fragment,s),g(pa.$$.fragment,s),g(oa.$$.fragment,s),g(ha.$$.fragment,s),g(da.$$.fragment,s),ze=!1},d(s){s&&(t(fa),t(ua),t(ba),t(xa),t(wa),t(L),t(za),t($a),t(Oa),t(T),t(Ca),t(P),t(La),t(Y),t(ka),t(N),t(_a),t(j),t(Ta),t(M),t(Pa),t(Ya),t(R),t(Na),t(I),t(ja),t(H),t(Ma),t(Sa),t(A),t(Ra),t(F),t(Ia),t(B),t(Ha),t(qa),t(E),t(Aa),t(D),t(Fa),t(G),t(Ba),t(Ua),t(K),t(Ea),t(Da),t(X),t(Ga),t(Q),t(Wa),t(J),t(Ka),t(Va),t(ss),t(Xa),t(Qa),t(ts),t(Ja),t(es),t(Za),t(st),t(ps),t(at),t(ls),t(et),t(nt),t(ms),t(pt),t(lt),t(os),t(it),t(cs),t(rt),t(hs),t(ct),t(gs),t(ht),t(ds),t(gt),t(dt),t(vs),t(ut),t(ys),t(vt),t(fs),t(ft),t(bs),t(bt),t(xs),t(xt),t(wt),t(zs),t(zt),t($s),t($t),t(Ot),t(Cs),t(Ct),t(Ls),t(Lt),t(b),t(Pt),t(ks),t(Yt),t(_s),t(Nt),t(Ts),t(jt),t(Ps),t(Mt),t(Ys),t(Rt),t(Ns),t(It),t(js),t(Ht),t(Ms),t(At),t(Ss),t(Ft),t(Rs),t(Bt),t(Is),t(Et),t(Dt),t(qs),t(Gt),t(Wt),t(Fs),t(Kt),t(Bs),t(Vt),t(Xt),t(Es),t(Qt),t(Jt),t(Gs),t(Zt),t(se),t(Ks),t(ae),t(te),t(Xs),t(ee),t(ne),t(Js),t(pe),t(le),t(sa),t(ie),t(me),t(ta),t(re),t(oe),t(na),t(ce),t(he),t(la),t(ge),t(ia),t(de),t(ma),t(ue),t(ra),t(ve),t(ye),t(ca),t(fe),t(be),t(ga),t(xe),t(we),t(va)),t(f),d(O,s),d(C,s),d(k,s),d(_,s),d(S,s),d(q,s),d(U,s),d(W,s),d(V,s),d(Z,s),d(as,s),d(ns,s),d(is,s),d(rs,s),d(us,s),d(ws,s),d(Os,s),d(Hs,s),d(As,s),d(Us,s),d(Ds,s),d(Ws,s),d(Vs,s),d(Qs,s),d(Zs,s),d(aa,s),d(ea,s),d(pa,s),d(oa,s),d(ha,s),d(da,s)}}}const cp='{"title":"YOLO","local":"yolo","sections":[{"title":"A short introduction to Object Detection","local":"a-short-introduction-to-object-detection","sections":[{"title":"RCNN, Fast RCNN, Faster RCNN","local":"rcnn-fast-rcnn-faster-rcnn","sections":[{"title":"R- CNN (Region-based Convolutional Neural Networks)","local":"r--cnn-region-based-convolutional-neural-networks","sections":[],"depth":4},{"title":"Fast RCNN","local":"fast-rcnn","sections":[],"depth":4},{"title":"Faster RCNN","local":"faster-rcnn","sections":[],"depth":4},{"title":"Feature Pyramid Network (FPN)","local":"feature-pyramid-network-fpn","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"YOLO architecture","local":"yolo-architecture","sections":[{"title":"Before YOLO","local":"before-yolo","sections":[],"depth":3},{"title":"YOLO","local":"yolo","sections":[{"title":"Reframing Object Detection","local":"reframing-object-detection","sections":[],"depth":4},{"title":"Confidence","local":"confidence","sections":[],"depth":4},{"title":"Coordinates","local":"coordinates","sections":[],"depth":4},{"title":"Class","local":"class","sections":[],"depth":4},{"title":"Network Architecture","local":"network-architecture","sections":[],"depth":4},{"title":"Training","local":"training","sections":[{"title":"Loss Function","local":"loss-function","sections":[],"depth":5}],"depth":4},{"title":"Inference","local":"inference","sections":[{"title":"Non-Maximum Suppression","local":"non-maximum-suppression","sections":[],"depth":5}],"depth":4}],"depth":3}],"depth":2},{"title":"Evolution of YOLO","local":"evolution-of-yolo","sections":[{"title":"YOLOv2 (2016)","local":"yolov2-2016","sections":[],"depth":3},{"title":"YOLOv3 (2018)","local":"yolov3-2018","sections":[],"depth":3},{"title":"YOLOv4 (2020)","local":"yolov4-2020","sections":[],"depth":3},{"title":"YOLOv5 (2020)","local":"yolov5-2020","sections":[],"depth":3},{"title":"YOLOv6 (2022)","local":"yolov6-2022","sections":[],"depth":3},{"title":"YOLOv7 (2022)","local":"yolov7-2022","sections":[],"depth":3},{"title":"YOLOv8 (2023)","local":"yolov8-2023","sections":[],"depth":3},{"title":"YOLOv9 (2024)","local":"yolov9-2024","sections":[],"depth":3},{"title":"Note about the different versions","local":"note-about-the-different-versions","sections":[],"depth":3}],"depth":2},{"title":"Reference","local":"reference","sections":[],"depth":2}],"depth":1}';function hp(He){return pp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vp extends lp{constructor(f){super(),ip(this,f,hp,op,ep,{})}}export{vp as component};
