import{s as dt,n as mt,o as ut}from"../chunks/scheduler.c57aa7ef.js";import{S as ct,i as ht,g as r,s,r as p,A as Mt,h as o,f as a,c as n,j as ft,u as f,x as i,k as Xe,y as yt,a as l,v as d,d as m,t as u,w as c}from"../chunks/index.c50cb18e.js";import{C as h}from"../chunks/CodeBlock.34f0a53d.js";import{H as Ve,E as bt}from"../chunks/EditOnGithub.958a8a49.js";function gt(Ye){let M,te,O,ae,g,le,w,Ee='PEFT’s practical benefits extends to other Hugging Face libraries like <a href="https://hf.co/docs/diffusers" rel="nofollow">Diffusers</a> and <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a>. One of the main benefits of PEFT is that an adapter file generated by a PEFT method is a lot smaller than the original model, which makes it super easy to manage and use multiple adapters. You can use one pretrained base model for multiple tasks by simply loading a new adapter finetuned for the task you’re solving. Or you can combine multiple adapters with a text-to-image diffusion model to create new effects.',se,T,qe="This tutorial will show you how PEFT can help you manage adapters in Diffusers and Transformers.",ne,J,re,$,Qe="Diffusers is a generative AI library for creating images and videos from text or images with diffusion models. LoRA is an especially popular training method for diffusion models because you can very quickly train and share diffusion models to generate images in new styles. To make it easier to use and try multiple LoRA models, Diffusers uses the PEFT library to help manage different adapters for inference.",oe,_,Ne='For example, load a base model and then load the <a href="https://huggingface.co/artificialguybr/3DRedmond-V1" rel="nofollow">artificialguybr/3DRedmond-V1</a> adapter for inference with the <a href="https://huggingface.co/docs/diffusers/v0.24.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights" rel="nofollow"><code>load_lora_weights</code></a> method. The <code>adapter_name</code> argument in the loading method is enabled by PEFT and allows you to set a name for the adapter so it is easier to reference.',ie,Z,pe,y,Se='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers.png"/>',fe,j,Pe='Now let’s try another cool LoRA model, <a href="https://huggingface.co/ostris/super-cereal-sdxl-lora" rel="nofollow">ostris/super-cereal-sdxl-lora</a>. All you need to do is load and name this new adapter with <code>adapter_name</code>, and use the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters" rel="nofollow"><code>set_adapters</code></a> method to set it as the currently active adapter.',de,U,me,b,ze='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers-2.png"/>',ue,v,Ae='Finally, you can call the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.disable_lora" rel="nofollow"><code>disable_lora</code></a> method to restore the base model.',ce,W,he,k,De='Learn more about how PEFT supports Diffusers in the <a href="https://huggingface.co/docs/diffusers/tutorials/using_peft_for_inference" rel="nofollow">Inference with PEFT</a> tutorial.',Me,C,ye,B,Ke='🤗 <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a> is a collection of pretrained models for all types of tasks in all modalities. You can load these models for training or inference. Many of the models are large language models (LLMs), so it makes sense to integrate PEFT with Transformers to manage and train adapters.',be,G,Oe="Load a base pretrained model to train.",ge,L,we,x,et='Next, add an adapter configuration to specify how to adapt the model parameters. Call the <a href="/docs/peft/pr_1828/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the configuration to the base model.',Te,F,Je,H,tt='Now you can train the model with Transformer’s <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class or whichever training framework you prefer.',$e,I,at='To use the newly trained model for inference, the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModel" rel="nofollow">AutoModel</a> class uses PEFT on the backend to load the adapter weights and configuration file into a base pretrained model.',_e,R,Ze,X,lt='Alternatively, you can use transformers <a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">Pipelines</a> to load the model for conveniently running inference:',je,V,Ue,Y,st='If you’re interested in comparing or using more than one adapter, you can call the <a href="/docs/peft/pr_1828/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the adapter configuration to the base model. The only requirement is the adapter type must be the same (you can’t mix a LoRA and LoHa adapter).',ve,E,We,q,nt='Call <a href="/docs/peft/pr_1828/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> again to attach a new adapter to the base model.',ke,Q,Ce,N,rt='Then you can use <a href="/docs/peft/pr_1828/en/package_reference/peft_model#peft.PeftModel.set_adapter">set_adapter()</a> to set the currently active adapter.',Be,S,Ge,P,ot='To disable the adapter, call the <a href="https://github.com/huggingface/transformers/blob/4e3490f79b40248c53ee54365a9662611e880892/src/transformers/integrations/peft.py#L313" rel="nofollow">disable_adapters</a> method.',Le,z,xe,A,it='The <a href="https://github.com/huggingface/transformers/blob/4e3490f79b40248c53ee54365a9662611e880892/src/transformers/integrations/peft.py#L336" rel="nofollow">enable_adapters</a> can be used to enable the adapters again.',Fe,D,pt='If you’re curious, check out the <a href="https://huggingface.co/docs/transformers/main/peft" rel="nofollow">Load and train adapters with PEFT</a> tutorial to learn more.',He,K,Ie,ee,Re;return g=new Ve({props:{title:"PEFT integrations",local:"peft-integrations",headingTag:"h1"}}),J=new Ve({props:{title:"Diffusers",local:"diffusers",headingTag:"h2"}}),Z=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGYXJ0aWZpY2lhbGd1eWJyX18zRFJlZG1vbmQtVjElMjIlMkMlMjAlMEElMjAlMjAlMjAlMjB3ZWlnaHRfbmFtZSUzRCUyMjNEUmVkbW9uZC0zRFJlbmRlclN0eWxlLTNEUmVuZGVyQUYuc2FmZXRlbnNvcnMlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjBhZGFwdGVyX25hbWUlM0QlMjIzZCUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnN1c2hpJTIwcm9sbHMlMjBzaGFwZWQlMjBsaWtlJTIwa2F3YWlpJTIwY2F0JTIwZmFjZXMlMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(
    <span class="hljs-string">&quot;peft-internal-testing/artificialguybr__3DRedmond-V1&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;3DRedmond-3DRenderStyle-3DRenderAF.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;3d&quot;</span>
)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),U=new h({props:{code:"cGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyb3N0cmlzJTJGc3VwZXItY2VyZWFsLXNkeGwtbG9yYSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHdlaWdodF9uYW1lJTNEJTIyY2VyZWFsX2JveF9zZHhsX3YxLnNhZmV0ZW5zb3JzJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEJTIyY2VyZWFsJTIyJTBBKSUwQXBpcGVsaW5lLnNldF9hZGFwdGVycyglMjJjZXJlYWwlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJzdXNoaSUyMHJvbGxzJTIwc2hhcGVkJTIwbGlrZSUyMGthd2FpaSUyMGNhdCUyMGZhY2VzJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`pipeline.load_lora_weights(
    <span class="hljs-string">&quot;ostris/super-cereal-sdxl-lora&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;cereal_box_sdxl_v1.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;cereal&quot;</span>
)
pipeline.set_adapters(<span class="hljs-string">&quot;cereal&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),W=new h({props:{code:"cGlwZWxpbmUuZGlzYWJsZV9sb3JhKCk=",highlighted:"pipeline.disable_lora()",wrap:!1}}),C=new Ve({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),L=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)`,wrap:!1}}),F=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)
model.add_adapter(peft_config)`,wrap:!1}}),R=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGb3B0LTM1MG0tbG9yYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;peft-internal-testing/opt-350m-lora&quot;</span>)`,wrap:!1}}),V=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWwlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjAlMjJwZWZ0LWludGVybmFsLXRlc3RpbmclMkZvcHQtMzUwbS1sb3JhJTIyKSUwQXByaW50KG1vZGVsKCUyMkhlbGxvJTIwV29ybGQlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;peft-internal-testing/opt-350m-lora&quot;</span>)
<span class="hljs-built_in">print</span>(model(<span class="hljs-string">&quot;Hello World&quot;</span>))`,wrap:!1}}),E=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZ18xJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl8xJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
model.add_adapter(lora_config_1, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),Q=new h({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWdfMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMiUyMik=",highlighted:'model.add_adapter(lora_config_2, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)',wrap:!1}}),S=new h({props:{code:"bW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),z=new h({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygp",highlighted:"model.disable_adapters()",wrap:!1}}),K=new bt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/tutorial/peft_integrations.md"}}),{c(){M=r("meta"),te=s(),O=r("p"),ae=s(),p(g.$$.fragment),le=s(),w=r("p"),w.innerHTML=Ee,se=s(),T=r("p"),T.textContent=qe,ne=s(),p(J.$$.fragment),re=s(),$=r("p"),$.textContent=Qe,oe=s(),_=r("p"),_.innerHTML=Ne,ie=s(),p(Z.$$.fragment),pe=s(),y=r("div"),y.innerHTML=Se,fe=s(),j=r("p"),j.innerHTML=Pe,de=s(),p(U.$$.fragment),me=s(),b=r("div"),b.innerHTML=ze,ue=s(),v=r("p"),v.innerHTML=Ae,ce=s(),p(W.$$.fragment),he=s(),k=r("p"),k.innerHTML=De,Me=s(),p(C.$$.fragment),ye=s(),B=r("p"),B.innerHTML=Ke,be=s(),G=r("p"),G.textContent=Oe,ge=s(),p(L.$$.fragment),we=s(),x=r("p"),x.innerHTML=et,Te=s(),p(F.$$.fragment),Je=s(),H=r("p"),H.innerHTML=tt,$e=s(),I=r("p"),I.innerHTML=at,_e=s(),p(R.$$.fragment),Ze=s(),X=r("p"),X.innerHTML=lt,je=s(),p(V.$$.fragment),Ue=s(),Y=r("p"),Y.innerHTML=st,ve=s(),p(E.$$.fragment),We=s(),q=r("p"),q.innerHTML=nt,ke=s(),p(Q.$$.fragment),Ce=s(),N=r("p"),N.innerHTML=rt,Be=s(),p(S.$$.fragment),Ge=s(),P=r("p"),P.innerHTML=ot,Le=s(),p(z.$$.fragment),xe=s(),A=r("p"),A.innerHTML=it,Fe=s(),D=r("p"),D.innerHTML=pt,He=s(),p(K.$$.fragment),Ie=s(),ee=r("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(a),te=n(e),O=o(e,"P",{}),ft(O).forEach(a),ae=n(e),f(g.$$.fragment,e),le=n(e),w=o(e,"P",{"data-svelte-h":!0}),i(w)!=="svelte-a6a8i"&&(w.innerHTML=Ee),se=n(e),T=o(e,"P",{"data-svelte-h":!0}),i(T)!=="svelte-4mutq9"&&(T.textContent=qe),ne=n(e),f(J.$$.fragment,e),re=n(e),$=o(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-d4l0h1"&&($.textContent=Qe),oe=n(e),_=o(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-rcmzt6"&&(_.innerHTML=Ne),ie=n(e),f(Z.$$.fragment,e),pe=n(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(y)!=="svelte-1cw2tql"&&(y.innerHTML=Se),fe=n(e),j=o(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-4vggr3"&&(j.innerHTML=Pe),de=n(e),f(U.$$.fragment,e),me=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-pvy16"&&(b.innerHTML=ze),ue=n(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-dtlzi"&&(v.innerHTML=Ae),ce=n(e),f(W.$$.fragment,e),he=n(e),k=o(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1nfye23"&&(k.innerHTML=De),Me=n(e),f(C.$$.fragment,e),ye=n(e),B=o(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1b1b0a9"&&(B.innerHTML=Ke),be=n(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-luca6i"&&(G.textContent=Oe),ge=n(e),f(L.$$.fragment,e),we=n(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-75bsu2"&&(x.innerHTML=et),Te=n(e),f(F.$$.fragment,e),Je=n(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-rsm0q6"&&(H.innerHTML=tt),$e=n(e),I=o(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-11qdvon"&&(I.innerHTML=at),_e=n(e),f(R.$$.fragment,e),Ze=n(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1xfm1"&&(X.innerHTML=lt),je=n(e),f(V.$$.fragment,e),Ue=n(e),Y=o(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-190dgm6"&&(Y.innerHTML=st),ve=n(e),f(E.$$.fragment,e),We=n(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-16tzebw"&&(q.innerHTML=nt),ke=n(e),f(Q.$$.fragment,e),Ce=n(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-yv29ic"&&(N.innerHTML=rt),Be=n(e),f(S.$$.fragment,e),Ge=n(e),P=o(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-lfmda3"&&(P.innerHTML=ot),Le=n(e),f(z.$$.fragment,e),xe=n(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1orofvq"&&(A.innerHTML=it),Fe=n(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1o6emrm"&&(D.innerHTML=pt),He=n(e),f(K.$$.fragment,e),Ie=n(e),ee=o(e,"P",{}),ft(ee).forEach(a),this.h()},h(){Xe(M,"name","hf:doc:metadata"),Xe(M,"content",wt),Xe(y,"class","flex justify-center"),Xe(b,"class","flex justify-center")},m(e,t){yt(document.head,M),l(e,te,t),l(e,O,t),l(e,ae,t),d(g,e,t),l(e,le,t),l(e,w,t),l(e,se,t),l(e,T,t),l(e,ne,t),d(J,e,t),l(e,re,t),l(e,$,t),l(e,oe,t),l(e,_,t),l(e,ie,t),d(Z,e,t),l(e,pe,t),l(e,y,t),l(e,fe,t),l(e,j,t),l(e,de,t),d(U,e,t),l(e,me,t),l(e,b,t),l(e,ue,t),l(e,v,t),l(e,ce,t),d(W,e,t),l(e,he,t),l(e,k,t),l(e,Me,t),d(C,e,t),l(e,ye,t),l(e,B,t),l(e,be,t),l(e,G,t),l(e,ge,t),d(L,e,t),l(e,we,t),l(e,x,t),l(e,Te,t),d(F,e,t),l(e,Je,t),l(e,H,t),l(e,$e,t),l(e,I,t),l(e,_e,t),d(R,e,t),l(e,Ze,t),l(e,X,t),l(e,je,t),d(V,e,t),l(e,Ue,t),l(e,Y,t),l(e,ve,t),d(E,e,t),l(e,We,t),l(e,q,t),l(e,ke,t),d(Q,e,t),l(e,Ce,t),l(e,N,t),l(e,Be,t),d(S,e,t),l(e,Ge,t),l(e,P,t),l(e,Le,t),d(z,e,t),l(e,xe,t),l(e,A,t),l(e,Fe,t),l(e,D,t),l(e,He,t),d(K,e,t),l(e,Ie,t),l(e,ee,t),Re=!0},p:mt,i(e){Re||(m(g.$$.fragment,e),m(J.$$.fragment,e),m(Z.$$.fragment,e),m(U.$$.fragment,e),m(W.$$.fragment,e),m(C.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(R.$$.fragment,e),m(V.$$.fragment,e),m(E.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(K.$$.fragment,e),Re=!0)},o(e){u(g.$$.fragment,e),u(J.$$.fragment,e),u(Z.$$.fragment,e),u(U.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(K.$$.fragment,e),Re=!1},d(e){e&&(a(te),a(O),a(ae),a(le),a(w),a(se),a(T),a(ne),a(re),a($),a(oe),a(_),a(ie),a(pe),a(y),a(fe),a(j),a(de),a(me),a(b),a(ue),a(v),a(ce),a(he),a(k),a(Me),a(ye),a(B),a(be),a(G),a(ge),a(we),a(x),a(Te),a(Je),a(H),a($e),a(I),a(_e),a(Ze),a(X),a(je),a(Ue),a(Y),a(ve),a(We),a(q),a(ke),a(Ce),a(N),a(Be),a(Ge),a(P),a(Le),a(xe),a(A),a(Fe),a(D),a(He),a(Ie),a(ee)),a(M),c(g,e),c(J,e),c(Z,e),c(U,e),c(W,e),c(C,e),c(L,e),c(F,e),c(R,e),c(V,e),c(E,e),c(Q,e),c(S,e),c(z,e),c(K,e)}}}const wt='{"title":"PEFT integrations","local":"peft-integrations","sections":[{"title":"Diffusers","local":"diffusers","sections":[],"depth":2},{"title":"Transformers","local":"transformers","sections":[],"depth":2}],"depth":1}';function Tt(Ye){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends ct{constructor(M){super(),ht(this,M,Tt,gt,dt,{})}}export{jt as component};
