import{s as xl,o as Yl,n as at}from"../chunks/scheduler.2427eaa0.js";import{S as Ql,i as El,g as p,s as a,r as M,B as Nl,h as o,f as s,c as n,j as Xl,u as c,x as r,k as xs,y as Fl,a as l,v as u,d as y,t as h,w as d}from"../chunks/index.0f2ff8a3.js";import{T as lt}from"../chunks/Tip.4e204c61.js";import{C as w}from"../chunks/CodeBlock.1bc84186.js";import{H as U,E as Pl}from"../chunks/index.61bead48.js";function zl(j){let i,J='Want to be listed as an Inference Provider on the Hugging Face Hub? Please reach out to us on social networks or <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">here on the Hub</a>.';return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-3qkokv"&&(i.innerHTML=J)},m(m,T){l(m,i,T)},p:at,d(m){m&&s(i)}}}function Ll(j){let i,J='If your implementation strictly follows the OpenAI API for LLMs and VLMs, you may be able to skip most of this section. In that case, simply open a PR on <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> to register.';return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-90vl22"&&(i.innerHTML=J)},m(m,T){l(m,i,T)},p:at,d(m){m&&s(i)}}}function Dl(j){let i,J=`Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.`;return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-19q0jcc"&&(i.innerHTML=J)},m(m,T){l(m,i,T)},p:at,d(m){m&&s(i)}}}function Ol(j){let i,J="To proceed with this step, we have to enable your account server-side. Make sure you have an organization on the Hub for your enterprise.";return{c(){i=p("p"),i.textContent=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1letj1o"&&(i.textContent=J)},m(m,T){l(m,i,T)},p:at,d(m){m&&s(i)}}}function Kl(j){let i,J="This is publicly accessible. It’s useful to be transparent by default and it helps debug client SDKs, etc.";return{c(){i=p("p"),i.textContent=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-94fcay"&&(i.textContent=J)},m(m,T){l(m,i,T)},p:at,d(m){m&&s(i)}}}function ea(j){let i,J="Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.";return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-33g0sl"&&(i.innerHTML=J)},m(m,T){l(m,i,T)},p:at,d(m){m&&s(i)}}}function ta(j){let i,J,m,T,B,it,f,pt,A,Ys="This guide details the steps for registering as an inference provider on the Hub and provides implementation guidance.",ot,q,Qs='<li><strong>Implement standard task APIs</strong> - Follow our task API schemas for compatibility (see <a href="#1-prerequisites">Prerequisites</a>).</li> <li><strong>Submit a PR for JS client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> (see <a href="#2-js-client-integration">JS Client Integration</a>).</li> <li><strong>Register model mappings</strong> - Use our Model Mapping API to link your models to Hub models (see <a href="#3-model-mapping-api">Model Mapping API</a>).</li> <li><strong>Implement a billing endpoint</strong> - Provide an API for billing (see <a href="#4-billing">Billing</a>).</li> <li><strong>Submit a PR for Python client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> (see <a href="#5-python-client-integration">Python client integration</a>).</li> <li><strong>Register your provider server-side and provide an icon</strong> - Reach out to us to add your provider server-side and provide your SVG icon.</li> <li><strong>Create documentation on your side</strong> - Add documentation and do a lot of communication on your side.</li> <li><strong>Add a documentation page</strong> - Open a Pull Request in this repo (huggingface/hub-docs) to add a provider-specific page in the documentation.</li> <li><strong>Share share share</strong> do a lot of comms so that your integration is as successful as possible!</li>',rt,G,Mt,g,ct,Z,Es=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> repo.`,ut,_,Ns=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation downstream (for Python SDK, to generate code snippets, etc.).`,yt,R,ht,V,Fs=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,dt,I,Ps='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',mt,S,zs='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',Ut,C,Jt,H,Tt,W,Ls=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,jt,X,Ds=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,wt,x,Os='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',ft,Y,gt,Q,Ks="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation. Here are the steps to follow:",It,E,Ct,N,el="Create a new file under <code>packages/inference/src/providers/{provider_name}.ts</code> and copy-paste the following snippet.",bt,F,$t,P,tl="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. You have to define at least <code>makeRoute</code>, <code>preparePayload</code> and <code>getResponse</code>.",vt,z,sl='If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern used in the existing providers implementation, e.g. <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/together.ts" rel="nofollow">Together AI provider implementation</a>.',kt,L,ll='For text-generation and conversational tasks, you can just inherit from <code>BaseTextGenerationTask</code> and <code>BaseConversationalTask</code> respectively (defined in <a href="(https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/providerHelper.ts)">providerHelper.ts</a>) and override the methods if needed. Examples can be found in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/cerebras.ts" rel="nofollow">Cerebras</a> or <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/fireworks.ts" rel="nofollow">Fireworks</a> provider implementations.',Bt,D,At,O,al='Go to <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/lib/getProviderHelper.ts" rel="nofollow">packages/inference/src/lib/getProviderHelper.ts</a> and add your provider to <code>PROVIDERS</code>. You will need to add your provider to the <code>INFERENCE_PROVIDERS</code> list as well in <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/types.ts" rel="nofollow">packages/inference/src/types.ts</a>. Please try to respect alphabetical order.',qt,K,nl='Update the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/README.md" rel="nofollow">README.md</a> in the <code>packages/inference</code> directory to include your provider in the list of supported providers and the list of supported models links.',Gt,ee,Zt,te,il="Congratulations! You now have a JS implementation to successfully make inference calls on your infra! Time to integrate with the Hub!",_t,se,pl="First step is to use the Model Mapping API to register which HF models are supported.",Rt,b,Vt,le,St,ae,Ht,ne,ol="Create a new mapping item, with the following body (JSON-encoded):",Wt,ie,Xt,pe,rl=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different).</li>`,xt,oe,Ml="In the future, we will add support for a new parameter (ping us if it’s important to you now):",Yt,re,Qt,Me,Et,ce,cl=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,Nt,ue,Ft,ye,ul="The endpoint validates that:",Pt,he,yl=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>(in the future) we auto-test that the Partner’s API successfully responds to a
huggingface.js/inference call of the corresponding task i.e. the API specs are valid.</li>`,zt,de,Lt,me,Dt,Ue,Ot,Je,hl="Call this HTTP PUT endpoint:",Kt,Te,es,je,dl="With the following body (JSON-encoded):",ts,we,ss,fe,ls,ge,as,Ie,ml="This gets all mapping items from the DB. For clarity, the output is grouped by task.",ns,$,is,Ce,Ul="Here is an example of response:",ps,be,os,$e,rs,ve,Jl=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.
More details about the pricing structure can be found on the <a href="./pricing.md">pricing page</a>.`,Ms,v,Tl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',cs,ke,jl=`We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,us,Be,ys,Ae,wl=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.`,hs,qe,ds,Ge,fl=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,ms,Ze,Us,_e,Js,Re,gl="We require the price to be an <strong>integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",Ts,Ve,js,Se,Il=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,ws,He,Cl="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",fs,We,bl="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",gs,Xe,Is,xe,Cs,k,bs,Ye,$s,Qe,$l="Create a new file under <code>src/huggingface_hub/inference/_providers/{provider_name}.py</code> and copy-paste the following snippet.",vs,Ee,vl="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of <code>_prepare_payload_as_dict</code> or <code>_prepare_payload_as_bytes</code> must be overwritten.",ks,Ne,kl="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",Bs,Fe,Bl="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",As,Pe,qs,ze,Gs,Le,Al='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',Zs,De,_s,Oe,ql='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</li>',Rs,Ke,Vs,et,Gl="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",Ss,tt,Zl="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",Hs,st,Ws,nt,Xs;return B=new U({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),f=new lt({props:{$$slots:{default:[zl]},$$scope:{ctx:j}}}),G=new U({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),g=new lt({props:{$$slots:{default:[Ll]},$$scope:{ctx:j}}}),R=new U({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),C=new lt({props:{$$slots:{default:[Dl]},$$scope:{ctx:j}}}),H=new U({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),Y=new U({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),E=new U({props:{title:"Implement the provider helper (JS)",local:"implement-the-provider-helper-js",headingTag:"h3"}}),F=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">TaskProviderHelper</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;./providerHelper&quot;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTask</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">TaskProviderHelper</span> {

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params"></span>) {
		<span class="hljs-variable language_">super</span>(<span class="hljs-string">&quot;your-provider-name&quot;</span>, <span class="hljs-string">&quot;your-api-base-url&quot;</span>, <span class="hljs-string">&quot;task-name&quot;</span>);
	}

    <span class="hljs-keyword">override</span> <span class="hljs-title function_">prepareHeaders</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">HeaderParams</span>, <span class="hljs-attr">binary</span>: <span class="hljs-built_in">boolean</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt; {
        <span class="hljs-comment">// Override the headers to use for the request.</span>
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">super</span>.<span class="hljs-title function_">prepareHeaders</span>(params, binary);
    }

	<span class="hljs-title function_">makeRoute</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">UrlParams</span>): <span class="hljs-built_in">string</span> {
        <span class="hljs-comment">// Return the route to use for the request. e.g. /v1/chat/completions route is commonly use for chat completion.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">preparePayload</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">BodyParams</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">unknown</span>&gt; {
        <span class="hljs-comment">// Return the payload to use for the request, as a dict.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">getResponse</span>(<span class="hljs-attr">response</span>: <span class="hljs-built_in">unknown</span>, outputType?: <span class="hljs-string">&quot;url&quot;</span> | <span class="hljs-string">&quot;blob&quot;</span>): <span class="hljs-built_in">string</span> | <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-title class_">Blob</span>&gt;{
		<span class="hljs-comment">// Return the response in the expected format.</span>
        <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
    }
}`,wrap:!1}}),D=new U({props:{title:"Register the provider",local:"register-the-provider",headingTag:"h3"}}),ee=new U({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),b=new lt({props:{$$slots:{default:[Ol]},$$scope:{ctx:j}}}),le=new U({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),ae=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),ie=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),re=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaGZGaWx0ZXIlMjIlM0ElMjAlNUIlMjJzdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAlNUVQb3dlciUyMHVzZXIlMjBtb3ZlJTNBJTIwcmVnaXN0ZXIlMjBhJTIwJTIydGFnJTIyJTIwc2xpY2UlMjBvZiUyMEhGJTIwaW4lMjBvbmUlMjBnby4lMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBFeGFtcGxlJTNBJTIwdGFnJTIwJTNEJTNEJTIwJTIyYmFzZV9tb2RlbCUzQWFkYXB0ZXIlM0FibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMjBmb3IlMjBhbGwlMjBGbHV4LWRldiUyMExvUkFzJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hfFilter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-comment">// ^Power user move: register a &quot;tag&quot; slice of HF in one go.</span>
    <span class="hljs-comment">// Example: tag == &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot; for all Flux-dev LoRAs</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Me=new U({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),ue=new U({props:{title:"Validation",local:"validation",headingTag:"h4"}}),de=new U({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),me=new w({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRmhmTW9kZWwlM0RuYW1lc3BhY2UlMkZtb2RlbC1uYW1l",highlighted:"DELETE /api/partners/{provider}/models?hfModel=namespace/model-name",wrap:!1}}),Ue=new U({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),Te=new w({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/status",wrap:!1}}),we=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaGZNb2RlbCUyMiUzQSUyMCUyMm5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMjIlMkMlMjAlMkYlMkYlMjBUaGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBtb2RlbCUyMG9uJTIwSEYlMEElMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJsaXZlJTIyJTIwJTdDJTIwJTIyc3RhZ2luZyUyMiUyMCUyRiUyRiUyMFRoZSUyMG5ldyUyMHN0YXR1cyUyQyUyMG9uZSUyMG9mJTIwJTIyc3RhZ2luZyUyMiUyMG9yJTIwJTIybGl2ZSUyMiUwQSU3RCUyMCUyMCUyMA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;namespace/model-name&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// The name of the model on HF</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),fe=new U({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),ge=new w({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),$=new lt({props:{warning:!0,$$slots:{default:[Kl]},$$scope:{ctx:j}}}),be=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$e=new U({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),Be=new U({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),qe=new w({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),Ze=new w({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),_e=new U({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),Ve=new U({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),Xe=new w({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),xe=new U({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),k=new lt({props:{$$slots:{default:[ea]},$$scope:{ctx:j}}}),Ye=new U({props:{title:"Implement the provider helper (Python)",local:"implement-the-provider-helper-python",headingTag:"h3"}}),Pe=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),ze=new U({props:{title:"Register the Provider",local:"register-the-provider",headingTag:"h3"}}),De=new U({props:{title:"Add tests",local:"add-tests",headingTag:"h3"}}),Ke=new U({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),st=new Pl({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/register-as-a-provider.md"}}),{c(){i=p("meta"),J=a(),m=p("p"),T=a(),M(B.$$.fragment),it=a(),M(f.$$.fragment),pt=a(),A=p("p"),A.textContent=Ys,ot=a(),q=p("ol"),q.innerHTML=Qs,rt=a(),M(G.$$.fragment),Mt=a(),M(g.$$.fragment),ct=a(),Z=p("p"),Z.innerHTML=Es,ut=a(),_=p("p"),_.textContent=Ns,yt=a(),M(R.$$.fragment),ht=a(),V=p("p"),V.innerHTML=Fs,dt=a(),I=p("div"),I.innerHTML=Ps,mt=a(),S=p("p"),S.innerHTML=zs,Ut=a(),M(C.$$.fragment),Jt=a(),M(H.$$.fragment),Tt=a(),W=p("p"),W.textContent=Ls,jt=a(),X=p("p"),X.textContent=Ds,wt=a(),x=p("p"),x.innerHTML=Os,ft=a(),M(Y.$$.fragment),gt=a(),Q=p("p"),Q.textContent=Ks,It=a(),M(E.$$.fragment),Ct=a(),N=p("p"),N.innerHTML=el,bt=a(),M(F.$$.fragment),$t=a(),P=p("p"),P.innerHTML=tl,vt=a(),z=p("p"),z.innerHTML=sl,kt=a(),L=p("p"),L.innerHTML=ll,Bt=a(),M(D.$$.fragment),At=a(),O=p("p"),O.innerHTML=al,qt=a(),K=p("p"),K.innerHTML=nl,Gt=a(),M(ee.$$.fragment),Zt=a(),te=p("p"),te.textContent=il,_t=a(),se=p("p"),se.textContent=pl,Rt=a(),M(b.$$.fragment),Vt=a(),M(le.$$.fragment),St=a(),M(ae.$$.fragment),Ht=a(),ne=p("p"),ne.textContent=ol,Wt=a(),M(ie.$$.fragment),Xt=a(),pe=p("ul"),pe.innerHTML=rl,xt=a(),oe=p("p"),oe.textContent=Ml,Yt=a(),M(re.$$.fragment),Qt=a(),M(Me.$$.fragment),Et=a(),ce=p("p"),ce.innerHTML=cl,Nt=a(),M(ue.$$.fragment),Ft=a(),ye=p("p"),ye.textContent=ul,Pt=a(),he=p("ul"),he.innerHTML=yl,zt=a(),M(de.$$.fragment),Lt=a(),M(me.$$.fragment),Dt=a(),M(Ue.$$.fragment),Ot=a(),Je=p("p"),Je.textContent=hl,Kt=a(),M(Te.$$.fragment),es=a(),je=p("p"),je.textContent=dl,ts=a(),M(we.$$.fragment),ss=a(),M(fe.$$.fragment),ls=a(),M(ge.$$.fragment),as=a(),Ie=p("p"),Ie.textContent=ml,ns=a(),M($.$$.fragment),is=a(),Ce=p("p"),Ce.textContent=Ul,ps=a(),M(be.$$.fragment),os=a(),M($e.$$.fragment),rs=a(),ve=p("p"),ve.innerHTML=Jl,Ms=a(),v=p("div"),v.innerHTML=Tl,cs=a(),ke=p("p"),ke.textContent=jl,us=a(),M(Be.$$.fragment),ys=a(),Ae=p("p"),Ae.textContent=wl,hs=a(),M(qe.$$.fragment),ds=a(),Ge=p("p"),Ge.textContent=fl,ms=a(),M(Ze.$$.fragment),Us=a(),M(_e.$$.fragment),Js=a(),Re=p("p"),Re.innerHTML=gl,Ts=a(),M(Ve.$$.fragment),js=a(),Se=p("p"),Se.textContent=Il,ws=a(),He=p("p"),He.innerHTML=Cl,fs=a(),We=p("p"),We.innerHTML=bl,gs=a(),M(Xe.$$.fragment),Is=a(),M(xe.$$.fragment),Cs=a(),M(k.$$.fragment),bs=a(),M(Ye.$$.fragment),$s=a(),Qe=p("p"),Qe.innerHTML=$l,vs=a(),Ee=p("p"),Ee.innerHTML=vl,ks=a(),Ne=p("p"),Ne.textContent=kl,Bs=a(),Fe=p("p"),Fe.textContent=Bl,As=a(),M(Pe.$$.fragment),qs=a(),M(ze.$$.fragment),Gs=a(),Le=p("ul"),Le.innerHTML=Al,Zs=a(),M(De.$$.fragment),_s=a(),Oe=p("ul"),Oe.innerHTML=ql,Rs=a(),M(Ke.$$.fragment),Vs=a(),et=p("p"),et.innerHTML=Gl,Ss=a(),tt=p("p"),tt.innerHTML=Zl,Hs=a(),M(st.$$.fragment),Ws=a(),nt=p("p"),this.h()},l(e){const t=Nl("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(s),J=n(e),m=o(e,"P",{}),Xl(m).forEach(s),T=n(e),c(B.$$.fragment,e),it=n(e),c(f.$$.fragment,e),pt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-eo2v07"&&(A.textContent=Ys),ot=n(e),q=o(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-8emskd"&&(q.innerHTML=Qs),rt=n(e),c(G.$$.fragment,e),Mt=n(e),c(g.$$.fragment,e),ct=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-iwney4"&&(Z.innerHTML=Es),ut=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1xoupob"&&(_.textContent=Ns),yt=n(e),c(R.$$.fragment,e),ht=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-hjt0h1"&&(V.innerHTML=Fs),dt=n(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-1cxy3tx"&&(I.innerHTML=Ps),mt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-vmhaok"&&(S.innerHTML=zs),Ut=n(e),c(C.$$.fragment,e),Jt=n(e),c(H.$$.fragment,e),Tt=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-epfhsj"&&(W.textContent=Ls),jt=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-n5dyw"&&(X.textContent=Ds),wt=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-qm2nt8"&&(x.innerHTML=Os),ft=n(e),c(Y.$$.fragment,e),gt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-aqaw0f"&&(Q.textContent=Ks),It=n(e),c(E.$$.fragment,e),Ct=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ccsiy1"&&(N.innerHTML=el),bt=n(e),c(F.$$.fragment,e),$t=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-qutua8"&&(P.innerHTML=tl),vt=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-uj5o95"&&(z.innerHTML=sl),kt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ozzcb1"&&(L.innerHTML=ll),Bt=n(e),c(D.$$.fragment,e),At=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-dq2kwm"&&(O.innerHTML=al),qt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-kajnqt"&&(K.innerHTML=nl),Gt=n(e),c(ee.$$.fragment,e),Zt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1vjzmk"&&(te.textContent=il),_t=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1147onl"&&(se.textContent=pl),Rt=n(e),c(b.$$.fragment,e),Vt=n(e),c(le.$$.fragment,e),St=n(e),c(ae.$$.fragment,e),Ht=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-f1hll8"&&(ne.textContent=ol),Wt=n(e),c(ie.$$.fragment,e),Xt=n(e),pe=o(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-u6m976"&&(pe.innerHTML=rl),xt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1h7c5bh"&&(oe.textContent=Ml),Yt=n(e),c(re.$$.fragment,e),Qt=n(e),c(Me.$$.fragment,e),Et=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1avk6lq"&&(ce.innerHTML=cl),Nt=n(e),c(ue.$$.fragment,e),Ft=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-pwj71q"&&(ye.textContent=ul),Pt=n(e),he=o(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-1i002r6"&&(he.innerHTML=yl),zt=n(e),c(de.$$.fragment,e),Lt=n(e),c(me.$$.fragment,e),Dt=n(e),c(Ue.$$.fragment,e),Ot=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-18yjufw"&&(Je.textContent=hl),Kt=n(e),c(Te.$$.fragment,e),es=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1ar1qn2"&&(je.textContent=dl),ts=n(e),c(we.$$.fragment,e),ss=n(e),c(fe.$$.fragment,e),ls=n(e),c(ge.$$.fragment,e),as=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-16sv3hm"&&(Ie.textContent=ml),ns=n(e),c($.$$.fragment,e),is=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1ovcz13"&&(Ce.textContent=Ul),ps=n(e),c(be.$$.fragment,e),os=n(e),c($e.$$.fragment,e),rs=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1vo10n6"&&(ve.innerHTML=Jl),Ms=n(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1roilif"&&(v.innerHTML=Tl),cs=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1072wo1"&&(ke.textContent=jl),us=n(e),c(Be.$$.fragment,e),ys=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-74sgny"&&(Ae.textContent=wl),hs=n(e),c(qe.$$.fragment,e),ds=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-krncuc"&&(Ge.textContent=fl),ms=n(e),c(Ze.$$.fragment,e),Us=n(e),c(_e.$$.fragment,e),Js=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-cj93i4"&&(Re.innerHTML=gl),Ts=n(e),c(Ve.$$.fragment,e),js=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-speu7d"&&(Se.textContent=Il),ws=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-13ler1d"&&(He.innerHTML=Cl),fs=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-ub059v"&&(We.innerHTML=bl),gs=n(e),c(Xe.$$.fragment,e),Is=n(e),c(xe.$$.fragment,e),Cs=n(e),c(k.$$.fragment,e),bs=n(e),c(Ye.$$.fragment,e),$s=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-102eqn3"&&(Qe.innerHTML=$l),vs=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-lavds"&&(Ee.innerHTML=vl),ks=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-f0qt8k"&&(Ne.textContent=kl),Bs=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-w9ft7n"&&(Fe.textContent=Bl),As=n(e),c(Pe.$$.fragment,e),qs=n(e),c(ze.$$.fragment,e),Gs=n(e),Le=o(e,"UL",{"data-svelte-h":!0}),r(Le)!=="svelte-117ozzs"&&(Le.innerHTML=Al),Zs=n(e),c(De.$$.fragment,e),_s=n(e),Oe=o(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-vl7c7p"&&(Oe.innerHTML=ql),Rs=n(e),c(Ke.$$.fragment,e),Vs=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1yfr1yr"&&(et.innerHTML=Gl),Ss=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1duzsqa"&&(tt.innerHTML=Zl),Hs=n(e),c(st.$$.fragment,e),Ws=n(e),nt=o(e,"P",{}),Xl(nt).forEach(s),this.h()},h(){xs(i,"name","hf:doc:metadata"),xs(i,"content",sa),xs(I,"class","flex justify-center"),xs(v,"class","flex justify-center")},m(e,t){Fl(document.head,i),l(e,J,t),l(e,m,t),l(e,T,t),u(B,e,t),l(e,it,t),u(f,e,t),l(e,pt,t),l(e,A,t),l(e,ot,t),l(e,q,t),l(e,rt,t),u(G,e,t),l(e,Mt,t),u(g,e,t),l(e,ct,t),l(e,Z,t),l(e,ut,t),l(e,_,t),l(e,yt,t),u(R,e,t),l(e,ht,t),l(e,V,t),l(e,dt,t),l(e,I,t),l(e,mt,t),l(e,S,t),l(e,Ut,t),u(C,e,t),l(e,Jt,t),u(H,e,t),l(e,Tt,t),l(e,W,t),l(e,jt,t),l(e,X,t),l(e,wt,t),l(e,x,t),l(e,ft,t),u(Y,e,t),l(e,gt,t),l(e,Q,t),l(e,It,t),u(E,e,t),l(e,Ct,t),l(e,N,t),l(e,bt,t),u(F,e,t),l(e,$t,t),l(e,P,t),l(e,vt,t),l(e,z,t),l(e,kt,t),l(e,L,t),l(e,Bt,t),u(D,e,t),l(e,At,t),l(e,O,t),l(e,qt,t),l(e,K,t),l(e,Gt,t),u(ee,e,t),l(e,Zt,t),l(e,te,t),l(e,_t,t),l(e,se,t),l(e,Rt,t),u(b,e,t),l(e,Vt,t),u(le,e,t),l(e,St,t),u(ae,e,t),l(e,Ht,t),l(e,ne,t),l(e,Wt,t),u(ie,e,t),l(e,Xt,t),l(e,pe,t),l(e,xt,t),l(e,oe,t),l(e,Yt,t),u(re,e,t),l(e,Qt,t),u(Me,e,t),l(e,Et,t),l(e,ce,t),l(e,Nt,t),u(ue,e,t),l(e,Ft,t),l(e,ye,t),l(e,Pt,t),l(e,he,t),l(e,zt,t),u(de,e,t),l(e,Lt,t),u(me,e,t),l(e,Dt,t),u(Ue,e,t),l(e,Ot,t),l(e,Je,t),l(e,Kt,t),u(Te,e,t),l(e,es,t),l(e,je,t),l(e,ts,t),u(we,e,t),l(e,ss,t),u(fe,e,t),l(e,ls,t),u(ge,e,t),l(e,as,t),l(e,Ie,t),l(e,ns,t),u($,e,t),l(e,is,t),l(e,Ce,t),l(e,ps,t),u(be,e,t),l(e,os,t),u($e,e,t),l(e,rs,t),l(e,ve,t),l(e,Ms,t),l(e,v,t),l(e,cs,t),l(e,ke,t),l(e,us,t),u(Be,e,t),l(e,ys,t),l(e,Ae,t),l(e,hs,t),u(qe,e,t),l(e,ds,t),l(e,Ge,t),l(e,ms,t),u(Ze,e,t),l(e,Us,t),u(_e,e,t),l(e,Js,t),l(e,Re,t),l(e,Ts,t),u(Ve,e,t),l(e,js,t),l(e,Se,t),l(e,ws,t),l(e,He,t),l(e,fs,t),l(e,We,t),l(e,gs,t),u(Xe,e,t),l(e,Is,t),u(xe,e,t),l(e,Cs,t),u(k,e,t),l(e,bs,t),u(Ye,e,t),l(e,$s,t),l(e,Qe,t),l(e,vs,t),l(e,Ee,t),l(e,ks,t),l(e,Ne,t),l(e,Bs,t),l(e,Fe,t),l(e,As,t),u(Pe,e,t),l(e,qs,t),u(ze,e,t),l(e,Gs,t),l(e,Le,t),l(e,Zs,t),u(De,e,t),l(e,_s,t),l(e,Oe,t),l(e,Rs,t),u(Ke,e,t),l(e,Vs,t),l(e,et,t),l(e,Ss,t),l(e,tt,t),l(e,Hs,t),u(st,e,t),l(e,Ws,t),l(e,nt,t),Xs=!0},p(e,[t]){const _l={};t&2&&(_l.$$scope={dirty:t,ctx:e}),f.$set(_l);const Rl={};t&2&&(Rl.$$scope={dirty:t,ctx:e}),g.$set(Rl);const Vl={};t&2&&(Vl.$$scope={dirty:t,ctx:e}),C.$set(Vl);const Sl={};t&2&&(Sl.$$scope={dirty:t,ctx:e}),b.$set(Sl);const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),$.$set(Hl);const Wl={};t&2&&(Wl.$$scope={dirty:t,ctx:e}),k.$set(Wl)},i(e){Xs||(y(B.$$.fragment,e),y(f.$$.fragment,e),y(G.$$.fragment,e),y(g.$$.fragment,e),y(R.$$.fragment,e),y(C.$$.fragment,e),y(H.$$.fragment,e),y(Y.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(b.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(re.$$.fragment,e),y(Me.$$.fragment,e),y(ue.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(Ue.$$.fragment,e),y(Te.$$.fragment,e),y(we.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y($.$$.fragment,e),y(be.$$.fragment,e),y($e.$$.fragment,e),y(Be.$$.fragment,e),y(qe.$$.fragment,e),y(Ze.$$.fragment,e),y(_e.$$.fragment,e),y(Ve.$$.fragment,e),y(Xe.$$.fragment,e),y(xe.$$.fragment,e),y(k.$$.fragment,e),y(Ye.$$.fragment,e),y(Pe.$$.fragment,e),y(ze.$$.fragment,e),y(De.$$.fragment,e),y(Ke.$$.fragment,e),y(st.$$.fragment,e),Xs=!0)},o(e){h(B.$$.fragment,e),h(f.$$.fragment,e),h(G.$$.fragment,e),h(g.$$.fragment,e),h(R.$$.fragment,e),h(C.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(b.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(Me.$$.fragment,e),h(ue.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(Ue.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h($.$$.fragment,e),h(be.$$.fragment,e),h($e.$$.fragment,e),h(Be.$$.fragment,e),h(qe.$$.fragment,e),h(Ze.$$.fragment,e),h(_e.$$.fragment,e),h(Ve.$$.fragment,e),h(Xe.$$.fragment,e),h(xe.$$.fragment,e),h(k.$$.fragment,e),h(Ye.$$.fragment,e),h(Pe.$$.fragment,e),h(ze.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(st.$$.fragment,e),Xs=!1},d(e){e&&(s(J),s(m),s(T),s(it),s(pt),s(A),s(ot),s(q),s(rt),s(Mt),s(ct),s(Z),s(ut),s(_),s(yt),s(ht),s(V),s(dt),s(I),s(mt),s(S),s(Ut),s(Jt),s(Tt),s(W),s(jt),s(X),s(wt),s(x),s(ft),s(gt),s(Q),s(It),s(Ct),s(N),s(bt),s($t),s(P),s(vt),s(z),s(kt),s(L),s(Bt),s(At),s(O),s(qt),s(K),s(Gt),s(Zt),s(te),s(_t),s(se),s(Rt),s(Vt),s(St),s(Ht),s(ne),s(Wt),s(Xt),s(pe),s(xt),s(oe),s(Yt),s(Qt),s(Et),s(ce),s(Nt),s(Ft),s(ye),s(Pt),s(he),s(zt),s(Lt),s(Dt),s(Ot),s(Je),s(Kt),s(es),s(je),s(ts),s(ss),s(ls),s(as),s(Ie),s(ns),s(is),s(Ce),s(ps),s(os),s(rs),s(ve),s(Ms),s(v),s(cs),s(ke),s(us),s(ys),s(Ae),s(hs),s(ds),s(Ge),s(ms),s(Us),s(Js),s(Re),s(Ts),s(js),s(Se),s(ws),s(He),s(fs),s(We),s(gs),s(Is),s(Cs),s(bs),s($s),s(Qe),s(vs),s(Ee),s(ks),s(Ne),s(Bs),s(Fe),s(As),s(qs),s(Gs),s(Le),s(Zs),s(_s),s(Oe),s(Rs),s(Vs),s(et),s(Ss),s(tt),s(Hs),s(Ws),s(nt)),s(i),d(B,e),d(f,e),d(G,e),d(g,e),d(R,e),d(C,e),d(H,e),d(Y,e),d(E,e),d(F,e),d(D,e),d(ee,e),d(b,e),d(le,e),d(ae,e),d(ie,e),d(re,e),d(Me,e),d(ue,e),d(de,e),d(me,e),d(Ue,e),d(Te,e),d(we,e),d(fe,e),d(ge,e),d($,e),d(be,e),d($e,e),d(Be,e),d(qe,e),d(Ze,e),d(_e,e),d(Ve,e),d(Xe,e),d(xe,e),d(k,e),d(Ye,e),d(Pe,e),d(ze,e),d(De,e),d(Ke,e),d(st,e)}}}const sa='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Prerequisites","local":"1-prerequisites","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[{"title":"Implement the provider helper (JS)","local":"implement-the-provider-helper-js","sections":[],"depth":3},{"title":"Register the provider","local":"register-the-provider","sections":[],"depth":3}],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"Implement the provider helper (Python)","local":"implement-the-provider-helper-python","sections":[],"depth":3},{"title":"Register the Provider","local":"register-the-provider","sections":[],"depth":3},{"title":"Add tests","local":"add-tests","sections":[],"depth":3}],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function la(j){return Yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ra extends Ql{constructor(i){super(),El(this,i,la,ta,xl,{})}}export{ra as component};
