# Runtime Logs

The Logs page gives you monitoring and debugging capabilities for your deployed models. This view allows you to track the
operational status and runtime logs of your inference endpoints in real-time.

## Accessing the Logs Interface

The Logs page is accessible through the main navigation tabs within your endpoint dashboard, alongside Overview, Analytics, Usage & Cost,
and Settings. The interface displays logs for your specific model deployment.

![banner](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/logs/logs.png)

## Deployment Status Overview

At the top of the logs interface, you'll find deployment information that provides an at-a-glance view of your Inference Endpoints's current
state. The deployment status section shows the deployment identifier (for example `6pajyw3k` like in the image above) and replica information
(z7ghx), along with the combined deployment-replica identifier (6pajyw3k-z7ghx).

Next to the filter, you'll find a status indicator. The interface also tracks important timestamps, showing when the endpoint was started and
when it was stopped, giving you precise timing information for deployment lifecycle management.

## Log Filtering and Display Options

The logs view provides flexible filtering capabilities to help you focus on the information most relevant to your needs. The filter
controls include toggleable options for Timestamp, Log Level, Content, and Replica information. These filters allow you to customize the
log display based on your specific debugging or monitoring requirements.

The timestamp display defaults to UTC format, ensuring consistent time references across different geographical locations and team members.

The main log display area presents a paginated view of log entries. By default the latest 50 lines are loaded and by clicking the
"Load More" option you can access additional historical log data.

<EditOnGithub source="https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/guides/logs.md" />



<!--HF DOCBUILD BODY END-->

HF_DOC_BODY_END

