import{s as tU,f as eU,n as jU,o as sU}from"../chunks/scheduler.3e37077e.js";import{S as aU,i as iU,g as j,s as t,r as i,A as CU,h as s,f as U,c as e,j as TU,u as C,x as a,k as cM,l as yU,y as IU,a as T,v as y,d as I,t as n,w as A}from"../chunks/index.0b341bf5.js";import{C as J}from"../chunks/CodeBlock.6444d2b6.js";import{H as wl}from"../chunks/Heading.639933af.js";import{E as nU}from"../chunks/EditOnGithub.aed3507d.js";function AU(mM){let w,Ol,ol,rl,o,cl,p,VM="Multi-agent systems enable specialized agents to collaborate on complex tasks, improving modularity, scalability, and robustness. Instead of relying on a single agent, tasks are distributed among agents with distinct capabilities.",ml,O,dM="In <strong>smolagents</strong>, different agents can be combined to generate Python code, call external tools, perform web searches, and more. By orchestrating these agents, we can create powerful workflows.",Vl,r,uM="A typical setup might include:",dl,c,RM="<li>A <strong>Manager Agent</strong> for task delegation</li> <li>A <strong>Code Interpreter Agent</strong> for code execution</li> <li>A <strong>Web Search Agent</strong> for information retrieval</li>",ul,m,NM="The diagram below illustrates a simple multi-agent architecture where a <strong>Manager Agent</strong> coordinates a <strong>Code Interpreter Tool</strong> and a <strong>Web Search Agent</strong>, which in turn utilizes tools like the <code>DuckDuckGoSearchTool</code> and <code>VisitWebpageTool</code> to gather relevant information.",Rl,V,QM,Nl,d,Ql,u,FM="A multi-agent system consists of multiple specialized agents working together under the coordination of an <strong>Orchestrator Agent</strong>. This approach enables complex workflows by distributing tasks among agents with distinct roles.",Fl,R,hM="For example, a <strong>Multi-Agent RAG system</strong> can integrate:",hl,N,bM="<li>A <strong>Web Agent</strong> for browsing the internet.</li> <li>A <strong>Retriever Agent</strong> for fetching information from knowledge bases.</li> <li>An <strong>Image Generation Agent</strong> for producing visuals.</li>",bl,Q,gM="All of these agents operate under an orchestrator that manages task delegation and interaction.",gl,F,El,h,EM="The reception is approaching! With your help, Alfred is now nearly finished with the preparations.",Bl,b,BM="But now there’s a problem: the Batmobile has disappeared. Alfred needs to find a replacement, and find it quickly.",Dl,g,DM="Fortunately, a few biopics have been done on Bruce Wayne’s life, so maybe Alfred could get a car left behind on one of the movie set, and re-engineer it up to modern standards, which certainly would include a full self-driving option.",Sl,E,SM="But this could be anywhere in the filming locations around the world - which could be numerous.",fl,B,fM="So Alfred wants your help. Could you build an agent able to solve this task?",Gl,D,GM="<p>👉 Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to there, and represent them on a map, with a color varying by cargo plane transfer time. Also represent some supercar factories with the same cargo plane transfer time.</p>",Zl,S,ZM="Let’s build this!",Wl,f,kl,G,vl,Z,WM="We can start with creating a baseline, simple agent to give us a simple report.",Yl,W,Xl,k,xl,v,kM="We could already improve this a bit by throwing in some dedicated planning steps, and adding more prompting.",_l,Y,Hl,X,$l,x,vM="Thanks to these quick changes, we obtained a much more concise report by simply providing our agent a detailed prompt, and giving it planning capabilities!",zl,_,YM="💸 But as you can see, the context window is quickly filling up. So <strong>if we ask our agent to combine the results of detailed search with another, it will be slower and quickly ramp up tokens and costs</strong>.",ql,H,XM="➡️ We need to improve the structure of our system.",Ll,$,Kl,z,xM="Multi-agent structures allow to separate memories between different sub-tasks, with two great benefits:",Pl,q,_M="<li>Each agent is more focused on its core task, thus more performant</li> <li>Separating memories reduces the count of input tokens at each step, thus reducing latency and cost.</li>",lM,L,HM="Let’s create a team with a dedicated web search agent, managed by another agent.",MM,K,$M="The manager agent should have plotting capabilities to redact its final report: so let us give it access to additional imports, including <code>matplotlib</code>, and <code>geopandas</code> + <code>shapely</code> for spatial plotting.",UM,P,TM,ll,zM="The manager agent will need to do some mental heavy lifting.",tM,Ml,qM="So we give it a stronger model, and add a <code>planning_interval</code> to the mix.",eM,Ul,jM,Tl,LM="Let us inspect what this team looks like:",sM,tl,aM,el,KM="This will generate something like this, helping us understanding the underlying structure:",iM,jl,CM,sl,yM,al,PM="I don’t know how that went in your run, but in mine, the manager agent masterfully divided tasks given to the web agent in <code>1. Search for Batman filming locations</code>, then <code>2. Find supercar factories</code>, before aggregating the lists and plotting the map.",IM,il,lU="Let’s see what the map looks like by inspecting it directly from the agent state:",nM,Cl,AM,yl,JM,Il,MU="TODO",wM,nl,oM,Al,UU='<li><a href="https://huggingface.co/docs/smolagents/main/en/examples/multiagents" rel="nofollow">Multi-Agent Systems</a> – Overview of multi-agent systems.</li> <li><a href="https://weaviate.io/blog/what-is-agentic-rag" rel="nofollow">What is Agentic RAG?</a> – Introduction to Agentic RAG.</li> <li><a href="https://huggingface.co/learn/cookbook/multiagent_rag_system" rel="nofollow">Multi-Agent RAG System 🤖🤝🤖 Recipe</a> – Step-by-step guide to building a multi-agent RAG system.</li>',pM,Jl,OM,pl,rM;return o=new wl({props:{title:"Multi-Agent Systems",local:"multi-agent-systems",headingTag:"h1"}}),d=new wl({props:{title:"Multi-Agent Systems in Action",local:"multi-agent-systems-in-action",headingTag:"h2"}}),F=new wl({props:{title:"Solving a complex task with a multi-agent hierarchy",local:"solving-a-complex-task-with-a-multi-agent-hierarchy",headingTag:"h2"}}),f=new J({props:{code:"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",highlighted:`<span class="hljs-comment"># We first make a tool to get the cargo plane transfer time.</span>
<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_cargo_travel_time</span>(<span class="hljs-params">
    origin_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    destination_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    cruising_speed_kmh: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">float</span>] = <span class="hljs-number">750.0</span>,  <span class="hljs-comment"># Average speed for cargo planes</span>
</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Calculate the travel time for a cargo plane between two points on Earth using great-circle distance.

    Args:
        origin_coords: Tuple of (latitude, longitude) for the starting point
        destination_coords: Tuple of (latitude, longitude) for the destination
        cruising_speed_kmh: Optional cruising speed in km/h (defaults to 750 km/h for typical cargo planes)

    Returns:
        float: The estimated travel time in hours

    Example:
        &gt;&gt;&gt; # Chicago (41.8781° N, 87.6298° W) to Sydney (33.8688° S, 151.2093° E)
        &gt;&gt;&gt; result = calculate_cargo_travel_time((41.8781, -87.6298), (-33.8688, 151.2093))
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_radians</span>(<span class="hljs-params">degrees: <span class="hljs-built_in">float</span></span>) -&gt; <span class="hljs-built_in">float</span>:
        <span class="hljs-keyword">return</span> degrees * (math.pi / <span class="hljs-number">180</span>)

    <span class="hljs-comment"># Extract coordinates</span>
    lat1, lon1 = <span class="hljs-built_in">map</span>(to_radians, origin_coords)
    lat2, lon2 = <span class="hljs-built_in">map</span>(to_radians, destination_coords)

    <span class="hljs-comment"># Earth&#x27;s radius in kilometers</span>
    EARTH_RADIUS_KM = <span class="hljs-number">6371.0</span>

    <span class="hljs-comment"># Calculate great-circle distance using the haversine formula</span>
    dlon = lon2 - lon1
    dlat = lat2 - lat1

    a = math.sin(dlat / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span> + math.cos(lat1) * math.cos(lat2) * math.sin(dlon / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
    c = <span class="hljs-number">2</span> * math.asin(math.sqrt(a))
    distance = EARTH_RADIUS_KM * c

    <span class="hljs-comment"># Add 10% to account for non-direct routes and air traffic controls</span>
    actual_distance = distance * <span class="hljs-number">1.1</span>

    <span class="hljs-comment"># Calculate flight time</span>
    <span class="hljs-comment"># Add 1 hour for takeoff and landing procedures</span>
    flight_time = (actual_distance / cruising_speed_kmh) + <span class="hljs-number">1.0</span>

    <span class="hljs-comment"># Format the results</span>
    <span class="hljs-keyword">return</span> flight_time


<span class="hljs-built_in">print</span>(calculate_cargo_travel_time((<span class="hljs-number">41.8781</span>, -<span class="hljs-number">87.6298</span>), (-<span class="hljs-number">33.8688</span>, <span class="hljs-number">151.2093</span>)))<span class="hljs-keyword">import</span> os`,wrap:!1}}),G=new J({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyME9wZW5BSVNlcnZlck1vZGVsJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwobW9kZWxfaWQlM0QlMjJncHQtNG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, OpenAIServerModel, VisitWebpageTool

model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)`,wrap:!1}}),W=new J({props:{code:"dGFzayUyMCUzRCUyMCUyMiUyMiUyMkZpbmQlMjBhbGwlMjBCYXRtYW4lMjBmaWxtaW5nJTIwbG9jYXRpb25zJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGNhbGN1bGF0ZSUyMHRoZSUyMHRpbWUlMjB0byUyMHRyYW5zZmVyJTIwdmlhJTIwY2FyZ28lMjBwbGFuZSUyMHRvJTIwaGVyZSUyMCh3ZSdyZSUyMGluJTIwR290aGFtJTJDJTIwNDAuNzEyOCVDMiVCMCUyME4lMkMlMjA3NC4wMDYwJUMyJUIwJTIwVyklMkMlMjBhbmQlMjByZXR1cm4lMjB0aGVtJTIwdG8lMjBtZSUyMGFzJTIwYSUyMHBhbmRhcyUyMGRhdGFmcmFtZS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMiUyMiUyMg==",highlighted:`task = <span class="hljs-string">&quot;&quot;&quot;Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W), and return them to me as a pandas dataframe.
Also give me some supercar factories with the same cargo plane transfer time.&quot;&quot;&quot;</span>`,wrap:!1}}),k=new J({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBWaXNpdFdlYnBhZ2VUb29sKCklMkMlMjBjYWxjdWxhdGVfY2FyZ29fdHJhdmVsX3RpbWUlNUQlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2F1dGhvcml6ZWRfaW1wb3J0cyUzRCU1QiUyMnBhbmRhcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwJTJDJTBBKSUwQSUwQXJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1bih0YXNrKXJlc3VsdA==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

agent = CodeAgent(
    model=model,
    tools=[DuckDuckGoSearchTool(), VisitWebpageTool(), calculate_cargo_travel_time],
    additional_authorized_imports=[<span class="hljs-string">&quot;pandas&quot;</span>],
    max_steps=<span class="hljs-number">20</span>,
)

result = agent.run(task)result`,wrap:!1}}),Y=new J({props:{code:"YWdlbnQucGxhbm5pbmdfaW50ZXJ2YWwlMjAlM0QlMjA0JTBBJTBBZGV0YWlsZWRfcmVwb3J0JTIwJTNEJTIwYWdlbnQucnVuKGYlMjIlMjIlMjIlMEFZb3UncmUlMjBhbiUyMGV4cGVydCUyMGFuYWx5c3QuJTIwWW91JTIwbWFrZSUyMGNvbXByZWhlbnNpdmUlMjByZXBvcnRzJTIwYWZ0ZXIlMjB2aXNpdGluZyUyMG1hbnklMjB3ZWJzaXRlcy4lMEFEb24ndCUyMGhlc2l0YXRlJTIwdG8lMjBzZWFyY2glMjBmb3IlMjBtYW55JTIwcXVlcmllcyUyMGF0JTIwb25jZSUyMGluJTIwYSUyMGZvciUyMGxvb3AuJTBBRm9yJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMHRoYXQlMjB5b3UlMjBmaW5kJTJDJTIwdmlzaXQlMjB0aGUlMjBzb3VyY2UlMjB1cmwlMjB0byUyMGNvbmZpcm0lMjBudW1iZXJzLiUwQSUwQSU3QnRhc2slN0QlMEElMjIlMjIlMjIpJTBBJTBBcHJpbnQoZGV0YWlsZWRfcmVwb3J0KQ==",highlighted:`agent.planning_interval = <span class="hljs-number">4</span>

detailed_report = agent.run(<span class="hljs-string">f&quot;&quot;&quot;
You&#x27;re an expert analyst. You make comprehensive reports after visiting many websites.
Don&#x27;t hesitate to search for many queries at once in a for loop.
For each data point that you find, visit the source url to confirm numbers.

<span class="hljs-subst">{task}</span>
&quot;&quot;&quot;</span>)

<span class="hljs-built_in">print</span>(detailed_report)`,wrap:!1}}),X=new J({props:{code:"ZGV0YWlsZWRfcmVwb3J0",highlighted:"detailed_report",wrap:!1}}),$=new wl({props:{title:"✌️ Splitting the task between two agents",local:"-splitting-the-task-between-two-agents",headingTag:"h3"}}),P=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjBtYXRwbG90bGliJTIwZ2VvcGFuZGFzJTIwc2hhcGVseSUyMC1xJTBBJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbCglMjJncHQtNG8lMjIpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBWaXNpdFdlYnBhZ2VUb29sKCklMkMlMjBjYWxjdWxhdGVfY2FyZ29fdHJhdmVsX3RpbWUlNUQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyd2ViX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJCcm93c2VzJTIwdGhlJTIwd2ViJTIwdG8lMjBmaW5kJTIwaW5mb3JtYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEEp",highlighted:`!pip install matplotlib geopandas shapely -q

model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>)

web_agent = CodeAgent(
    model=model,
    tools=[DuckDuckGoSearchTool(), VisitWebpageTool(), calculate_cargo_travel_time],
    name=<span class="hljs-string">&quot;web_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Browses the web to find information&quot;</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),Ul=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.utils <span class="hljs-keyword">import</span> encode_image_base64, make_image_url

model = OpenAIServerModel(<span class="hljs-string">&quot;o1&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_reasoning_and_plot</span>(<span class="hljs-params">final_answer, agent_memory</span>):
    final_answer
    multimodal_model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>)
    filepath = <span class="hljs-string">&quot;saved_map.png&quot;</span>
    <span class="hljs-keyword">assert</span> os.path.exists(filepath), <span class="hljs-string">&quot;Make sure to save the plot under saved_map.png!&quot;</span>
    image = Image.<span class="hljs-built_in">open</span>(filepath)
    prompt = (
        <span class="hljs-string">f&quot;Here is a user-given task and the agent steps: <span class="hljs-subst">{agent_memory.get_succinct_steps()}</span>. Now here is the plot that was made.&quot;</span>
        <span class="hljs-string">&quot;Please check that the reasoning process and plot are correct: do they correctly answer the given task?&quot;</span>
        <span class="hljs-string">&quot;First list 3 reasons why yes/no, then write your final decision: PASS in caps lock if it is satisfactory, FAIL if it is not.&quot;</span>
        <span class="hljs-string">&quot;Don&#x27;t be harsh: if the plot mostly solves the task, it should pass.&quot;</span>
        <span class="hljs-string">&quot;But if any data was hallucinated/invented, you should refuse it. Also to pass, a plot should be made using px.scatter_map and not any other method (scatter_map looks nicer).&quot;</span>
    )
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: prompt,
                },
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>, <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: make_image_url(encode_image_base64(image))}},
            ],
        }
    ]
    output = multimodal_model(messages).content
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Feedback: &quot;</span>, output)
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;FAIL&quot;</span> <span class="hljs-keyword">in</span> output:
        <span class="hljs-keyword">raise</span> Exception(output)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>


manager_agent = CodeAgent(
    model=model,
    tools=[],
    managed_agents=[web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;geopandas&quot;</span>, <span class="hljs-string">&quot;plotly&quot;</span>, <span class="hljs-string">&quot;shapely&quot;</span>, <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>, <span class="hljs-string">&quot;numpy&quot;</span>],
    planning_interval=<span class="hljs-number">4</span>,
    verbosity_level=<span class="hljs-number">2</span>,
    final_answer_checks=[check_reasoning_and_plot],
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),tl=new J({props:{code:"bWFuYWdlcl9hZ2VudC52aXN1YWxpemUoKQ==",highlighted:"manager_agent.visualize()",wrap:!1}}),jl=new J({props:{code:"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",highlighted:`CodeAgent | o1
├── ✅ Authorized imports: [<span class="hljs-string">&#x27;geopandas&#x27;</span>, <span class="hljs-string">&#x27;plotly&#x27;</span>, <span class="hljs-string">&#x27;shapely&#x27;</span>, <span class="hljs-string">&#x27;json&#x27;</span>, <span class="hljs-string">&#x27;pandas&#x27;</span>, <span class="hljs-string">&#x27;numpy&#x27;</span>]
├── 🛠️ Tools:
│   ┏━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
│   ┃ Name         ┃ Description                                   ┃ Arguments                                    ┃
│   ┡━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
│   │ final_answer │ Provides a final answer to the given problem. │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer to the      │
│   │              │                                               │ problem                                      │
│   └──────────────┴───────────────────────────────────────────────┴──────────────────────────────────────────────┘
└── 🤖 Managed agents:
    └── web_agent | CodeAgent | gpt-4o
        ├── ✅ Authorized imports: []
        ├── 📝 Description: Browses the web to find information
        └── 🛠️ Tools:
            ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
            ┃ Name                        ┃ Description                       ┃ Arguments                         ┃
            ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
            │ web_search                  │ Performs a duckduckgo web search  │ query (\`string\`): The search      │
            │                             │ based on your query (think a      │ query to perform.                 │
            │                             │ Google search) then returns the   │                                   │
            │                             │ top search results.               │                                   │
            │ visit_webpage               │ Visits a webpage at the given url │ url (\`string\`): The url of the    │
            │                             │ <span class="hljs-keyword">and</span> reads its content <span class="hljs-keyword">as</span> a        │ webpage to visit.                 │
            │                             │ markdown string. Use this to      │                                   │
            │                             │ browse webpages.                  │                                   │
            │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a   │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of │
            │                             │ cargo plane between two points on │ (latitude, longitude) <span class="hljs-keyword">for</span> the     │
            │                             │ Earth using great-circle          │ starting point                    │
            │                             │ distance.                         │ destination_coords (\`array\`):     │
            │                             │                                   │ <span class="hljs-type">Tuple</span> of (latitude, longitude)    │
            │                             │                                   │ <span class="hljs-keyword">for</span> the destination               │
            │                             │                                   │ cruising_speed_kmh (\`number\`):    │
            │                             │                                   │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h   │
            │                             │                                   │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical │
            │                             │                                   │ cargo planes)                     │
            │ final_answer                │ Provides a final answer to the    │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer  │
            │                             │ given problem.                    │ to the problem                    │
            └─────────────────────────────┴───────────────────────────────────┴───────────────────────────────────┘`,wrap:!1}}),sl=new J({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oZiUyMiUyMiUyMiUwQSU3QnRhc2slN0QlMEFSZXByZXNlbnQlMjB0aGlzJTIwYXMlMjBzcGF0aWFsJTIwbWFwJTIwb2YlMjB0aGUlMjB3b3JsZCUyQyUyMHdpdGglMjB0aGUlMjBsb2NhdGlvbnMlMjByZXByZXNlbnRlZCUyMGFzJTIwc2NhdHRlciUyMHBvaW50cyUyMHByb3BvcnRpb25hbCUyMGluJTIwc2l6ZSUyMHRvJTIwdGhlJTIwdHJhdmVsJTIwdGltZSUyQyUyMGFuZCUyMHNhdmUlMjBpdCUyMHRvJTIwc2F2ZWRfbWFwLnBuZyElMEElMEFIZXJlJ3MlMjBhbiUyMGV4YW1wbGUlMjBvZiUyMGhvdyUyMHRvJTIwcGxvdCUyMGFuZCUyMHJldHVybiUyMGElMjBtYXAlM0ElMEFpbXBvcnQlMjBwbG90bHkuZXhwcmVzcyUyMGFzJTIwcHglMEFkZiUyMCUzRCUyMHB4LmRhdGEuY2Fyc2hhcmUoKSUwQWZpZyUyMCUzRCUyMHB4LnNjYXR0ZXJfbWFwKGRmJTJDJTIwbGF0JTNEJTIyY2VudHJvaWRfbGF0JTIyJTJDJTIwbG9uJTNEJTIyY2VudHJvaWRfbG9uJTIyJTJDJTIwdGV4dCUzRCUyMm5hbWUlMjIlMkMlMjBjb2xvciUzRCUyMnBlYWtfaG91ciUyMiUyQyUyMHNpemUlM0QlMjJjYXJfaG91cnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjBjb2xvcl9jb250aW51b3VzX3NjYWxlJTNEcHguY29sb3JzLnNlcXVlbnRpYWwuTWFnbWElMkMlMjBzaXplX21heCUzRDE1JTJDJTIwem9vbSUzRDEwKSUwQWZpZy5zaG93KCklMEFmaWcud3JpdGVfaW1hZ2UoJTIyc2F2ZWRfaW1hZ2UucG5nJTIyKSUwQWZpbmFsX2Fuc3dlcihmaWcpJTBBJTIyJTIyJTIyKQ==",highlighted:`manager_agent.run(<span class="hljs-string">f&quot;&quot;&quot;
<span class="hljs-subst">{task}</span>
Represent this as spatial map of the world, with the locations represented as scatter points proportional in size to the travel time, and save it to saved_map.png!

Here&#x27;s an example of how to plot and return a map:
import plotly.express as px
df = px.data.carshare()
fig = px.scatter_map(df, lat=&quot;centroid_lat&quot;, lon=&quot;centroid_lon&quot;, text=&quot;name&quot;, color=&quot;peak_hour&quot;, size=&quot;car_hours&quot;,
     color_continuous_scale=px.colors.sequential.Magma, size_max=15, zoom=10)
fig.show()
fig.write_image(&quot;saved_image.png&quot;)
final_answer(fig)
&quot;&quot;&quot;</span>)`,wrap:!1}}),Cl=new J({props:{code:"bWFuYWdlcl9hZ2VudC5weXRob25fZXhlY3V0b3Iuc3RhdGUlNUIlMjJmaWclMjIlNUQ=",highlighted:'manager_agent.python_executor.state[<span class="hljs-string">&quot;fig&quot;</span>]',wrap:!1}}),yl=new wl({props:{title:"Adding telemetry",local:"adding-telemetry",headingTag:"h2"}}),nl=new wl({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Jl=new nU({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/multi_agent_systems.mdx"}}),{c(){w=j("meta"),Ol=t(),ol=j("p"),rl=t(),i(o.$$.fragment),cl=t(),p=j("p"),p.textContent=VM,ml=t(),O=j("p"),O.innerHTML=dM,Vl=t(),r=j("p"),r.textContent=uM,dl=t(),c=j("ul"),c.innerHTML=RM,ul=t(),m=j("p"),m.innerHTML=NM,Rl=t(),V=j("img"),Nl=t(),i(d.$$.fragment),Ql=t(),u=j("p"),u.innerHTML=FM,Fl=t(),R=j("p"),R.innerHTML=hM,hl=t(),N=j("ul"),N.innerHTML=bM,bl=t(),Q=j("p"),Q.textContent=gM,gl=t(),i(F.$$.fragment),El=t(),h=j("p"),h.textContent=EM,Bl=t(),b=j("p"),b.textContent=BM,Dl=t(),g=j("p"),g.textContent=DM,Sl=t(),E=j("p"),E.textContent=SM,fl=t(),B=j("p"),B.textContent=fM,Gl=t(),D=j("blockquote"),D.innerHTML=GM,Zl=t(),S=j("p"),S.textContent=ZM,Wl=t(),i(f.$$.fragment),kl=t(),i(G.$$.fragment),vl=t(),Z=j("p"),Z.textContent=WM,Yl=t(),i(W.$$.fragment),Xl=t(),i(k.$$.fragment),xl=t(),v=j("p"),v.textContent=kM,_l=t(),i(Y.$$.fragment),Hl=t(),i(X.$$.fragment),$l=t(),x=j("p"),x.textContent=vM,zl=t(),_=j("p"),_.innerHTML=YM,ql=t(),H=j("p"),H.textContent=XM,Ll=t(),i($.$$.fragment),Kl=t(),z=j("p"),z.textContent=xM,Pl=t(),q=j("ul"),q.innerHTML=_M,lM=t(),L=j("p"),L.textContent=HM,MM=t(),K=j("p"),K.innerHTML=$M,UM=t(),i(P.$$.fragment),TM=t(),ll=j("p"),ll.textContent=zM,tM=t(),Ml=j("p"),Ml.innerHTML=qM,eM=t(),i(Ul.$$.fragment),jM=t(),Tl=j("p"),Tl.textContent=LM,sM=t(),i(tl.$$.fragment),aM=t(),el=j("p"),el.textContent=KM,iM=t(),i(jl.$$.fragment),CM=t(),i(sl.$$.fragment),yM=t(),al=j("p"),al.innerHTML=PM,IM=t(),il=j("p"),il.textContent=lU,nM=t(),i(Cl.$$.fragment),AM=t(),i(yl.$$.fragment),JM=t(),Il=j("p"),Il.textContent=MU,wM=t(),i(nl.$$.fragment),oM=t(),Al=j("ul"),Al.innerHTML=UU,pM=t(),i(Jl.$$.fragment),OM=t(),pl=j("p"),this.h()},l(l){const M=CU("svelte-u9bgzb",document.head);w=s(M,"META",{name:!0,content:!0}),M.forEach(U),Ol=e(l),ol=s(l,"P",{}),TU(ol).forEach(U),rl=e(l),C(o.$$.fragment,l),cl=e(l),p=s(l,"P",{"data-svelte-h":!0}),a(p)!=="svelte-mopgvx"&&(p.textContent=VM),ml=e(l),O=s(l,"P",{"data-svelte-h":!0}),a(O)!=="svelte-495kbr"&&(O.innerHTML=dM),Vl=e(l),r=s(l,"P",{"data-svelte-h":!0}),a(r)!=="svelte-7rzbsb"&&(r.textContent=uM),dl=e(l),c=s(l,"UL",{"data-svelte-h":!0}),a(c)!=="svelte-4g0mr"&&(c.innerHTML=RM),ul=e(l),m=s(l,"P",{"data-svelte-h":!0}),a(m)!=="svelte-1w7g1oo"&&(m.innerHTML=NM),Rl=e(l),V=s(l,"IMG",{src:!0,style:!0}),Nl=e(l),C(d.$$.fragment,l),Ql=e(l),u=s(l,"P",{"data-svelte-h":!0}),a(u)!=="svelte-1y9d32a"&&(u.innerHTML=FM),Fl=e(l),R=s(l,"P",{"data-svelte-h":!0}),a(R)!=="svelte-5zisae"&&(R.innerHTML=hM),hl=e(l),N=s(l,"UL",{"data-svelte-h":!0}),a(N)!=="svelte-1yhsihd"&&(N.innerHTML=bM),bl=e(l),Q=s(l,"P",{"data-svelte-h":!0}),a(Q)!=="svelte-1rcqnot"&&(Q.textContent=gM),gl=e(l),C(F.$$.fragment,l),El=e(l),h=s(l,"P",{"data-svelte-h":!0}),a(h)!=="svelte-5kqcy3"&&(h.textContent=EM),Bl=e(l),b=s(l,"P",{"data-svelte-h":!0}),a(b)!=="svelte-beftqy"&&(b.textContent=BM),Dl=e(l),g=s(l,"P",{"data-svelte-h":!0}),a(g)!=="svelte-tpf9f5"&&(g.textContent=DM),Sl=e(l),E=s(l,"P",{"data-svelte-h":!0}),a(E)!=="svelte-vokbk8"&&(E.textContent=SM),fl=e(l),B=s(l,"P",{"data-svelte-h":!0}),a(B)!=="svelte-s6dymp"&&(B.textContent=fM),Gl=e(l),D=s(l,"BLOCKQUOTE",{"data-svelte-h":!0}),a(D)!=="svelte-1qc49n6"&&(D.innerHTML=GM),Zl=e(l),S=s(l,"P",{"data-svelte-h":!0}),a(S)!=="svelte-1nbo15e"&&(S.textContent=ZM),Wl=e(l),C(f.$$.fragment,l),kl=e(l),C(G.$$.fragment,l),vl=e(l),Z=s(l,"P",{"data-svelte-h":!0}),a(Z)!=="svelte-kn61ej"&&(Z.textContent=WM),Yl=e(l),C(W.$$.fragment,l),Xl=e(l),C(k.$$.fragment,l),xl=e(l),v=s(l,"P",{"data-svelte-h":!0}),a(v)!=="svelte-1ii1il1"&&(v.textContent=kM),_l=e(l),C(Y.$$.fragment,l),Hl=e(l),C(X.$$.fragment,l),$l=e(l),x=s(l,"P",{"data-svelte-h":!0}),a(x)!=="svelte-8nkvul"&&(x.textContent=vM),zl=e(l),_=s(l,"P",{"data-svelte-h":!0}),a(_)!=="svelte-mcuqsy"&&(_.innerHTML=YM),ql=e(l),H=s(l,"P",{"data-svelte-h":!0}),a(H)!=="svelte-vkmihl"&&(H.textContent=XM),Ll=e(l),C($.$$.fragment,l),Kl=e(l),z=s(l,"P",{"data-svelte-h":!0}),a(z)!=="svelte-9zsog"&&(z.textContent=xM),Pl=e(l),q=s(l,"UL",{"data-svelte-h":!0}),a(q)!=="svelte-gafqe4"&&(q.innerHTML=_M),lM=e(l),L=s(l,"P",{"data-svelte-h":!0}),a(L)!=="svelte-hh9or6"&&(L.textContent=HM),MM=e(l),K=s(l,"P",{"data-svelte-h":!0}),a(K)!=="svelte-1kj6qcw"&&(K.innerHTML=$M),UM=e(l),C(P.$$.fragment,l),TM=e(l),ll=s(l,"P",{"data-svelte-h":!0}),a(ll)!=="svelte-kidlug"&&(ll.textContent=zM),tM=e(l),Ml=s(l,"P",{"data-svelte-h":!0}),a(Ml)!=="svelte-1nmw54d"&&(Ml.innerHTML=qM),eM=e(l),C(Ul.$$.fragment,l),jM=e(l),Tl=s(l,"P",{"data-svelte-h":!0}),a(Tl)!=="svelte-x8evmd"&&(Tl.textContent=LM),sM=e(l),C(tl.$$.fragment,l),aM=e(l),el=s(l,"P",{"data-svelte-h":!0}),a(el)!=="svelte-19bs310"&&(el.textContent=KM),iM=e(l),C(jl.$$.fragment,l),CM=e(l),C(sl.$$.fragment,l),yM=e(l),al=s(l,"P",{"data-svelte-h":!0}),a(al)!=="svelte-1k7lori"&&(al.innerHTML=PM),IM=e(l),il=s(l,"P",{"data-svelte-h":!0}),a(il)!=="svelte-1djejr1"&&(il.textContent=lU),nM=e(l),C(Cl.$$.fragment,l),AM=e(l),C(yl.$$.fragment,l),JM=e(l),Il=s(l,"P",{"data-svelte-h":!0}),a(Il)!=="svelte-1yyqpus"&&(Il.textContent=MU),wM=e(l),C(nl.$$.fragment,l),oM=e(l),Al=s(l,"UL",{"data-svelte-h":!0}),a(Al)!=="svelte-sve9y7"&&(Al.innerHTML=UU),pM=e(l),C(Jl.$$.fragment,l),OM=e(l),pl=s(l,"P",{}),TU(pl).forEach(U),this.h()},h(){cM(w,"name","hf:doc:metadata"),cM(w,"content",JU),eU(V.src,QM="https://mermaid.ink/img/pako:eNp1kc1qhTAQRl9FUiQb8wIpdNO76eKubrmFks1oRg3VSYgjpYjv3lFL_2hnMWQOJwn5sqgmelRWleUSKLAtFs09jqhtoWuYUFfFAa6QA9QDTnpzamheuhxn8pt40-6l13UtS0ddhtQXj6dbR4XUGQg6zEYasTF393KjeSDGnDJKNxzj8I_7hLW5IOSmP9CH9hv_NL-d94d4DVNg84p1EnK4qlIj5hGClySWbadT-6OdsrL02MI8sFOOVkciw8zx8kaNspxnrJQE0fXKtjBMMs3JA-MpgOQwftIE9Bzj14w-cMznI_39E9Z3p0uFoA?type=png")||cM(V,"src",QM),yU(V,"background","white")},m(l,M){IU(document.head,w),T(l,Ol,M),T(l,ol,M),T(l,rl,M),y(o,l,M),T(l,cl,M),T(l,p,M),T(l,ml,M),T(l,O,M),T(l,Vl,M),T(l,r,M),T(l,dl,M),T(l,c,M),T(l,ul,M),T(l,m,M),T(l,Rl,M),T(l,V,M),T(l,Nl,M),y(d,l,M),T(l,Ql,M),T(l,u,M),T(l,Fl,M),T(l,R,M),T(l,hl,M),T(l,N,M),T(l,bl,M),T(l,Q,M),T(l,gl,M),y(F,l,M),T(l,El,M),T(l,h,M),T(l,Bl,M),T(l,b,M),T(l,Dl,M),T(l,g,M),T(l,Sl,M),T(l,E,M),T(l,fl,M),T(l,B,M),T(l,Gl,M),T(l,D,M),T(l,Zl,M),T(l,S,M),T(l,Wl,M),y(f,l,M),T(l,kl,M),y(G,l,M),T(l,vl,M),T(l,Z,M),T(l,Yl,M),y(W,l,M),T(l,Xl,M),y(k,l,M),T(l,xl,M),T(l,v,M),T(l,_l,M),y(Y,l,M),T(l,Hl,M),y(X,l,M),T(l,$l,M),T(l,x,M),T(l,zl,M),T(l,_,M),T(l,ql,M),T(l,H,M),T(l,Ll,M),y($,l,M),T(l,Kl,M),T(l,z,M),T(l,Pl,M),T(l,q,M),T(l,lM,M),T(l,L,M),T(l,MM,M),T(l,K,M),T(l,UM,M),y(P,l,M),T(l,TM,M),T(l,ll,M),T(l,tM,M),T(l,Ml,M),T(l,eM,M),y(Ul,l,M),T(l,jM,M),T(l,Tl,M),T(l,sM,M),y(tl,l,M),T(l,aM,M),T(l,el,M),T(l,iM,M),y(jl,l,M),T(l,CM,M),y(sl,l,M),T(l,yM,M),T(l,al,M),T(l,IM,M),T(l,il,M),T(l,nM,M),y(Cl,l,M),T(l,AM,M),y(yl,l,M),T(l,JM,M),T(l,Il,M),T(l,wM,M),y(nl,l,M),T(l,oM,M),T(l,Al,M),T(l,pM,M),y(Jl,l,M),T(l,OM,M),T(l,pl,M),rM=!0},p:jU,i(l){rM||(I(o.$$.fragment,l),I(d.$$.fragment,l),I(F.$$.fragment,l),I(f.$$.fragment,l),I(G.$$.fragment,l),I(W.$$.fragment,l),I(k.$$.fragment,l),I(Y.$$.fragment,l),I(X.$$.fragment,l),I($.$$.fragment,l),I(P.$$.fragment,l),I(Ul.$$.fragment,l),I(tl.$$.fragment,l),I(jl.$$.fragment,l),I(sl.$$.fragment,l),I(Cl.$$.fragment,l),I(yl.$$.fragment,l),I(nl.$$.fragment,l),I(Jl.$$.fragment,l),rM=!0)},o(l){n(o.$$.fragment,l),n(d.$$.fragment,l),n(F.$$.fragment,l),n(f.$$.fragment,l),n(G.$$.fragment,l),n(W.$$.fragment,l),n(k.$$.fragment,l),n(Y.$$.fragment,l),n(X.$$.fragment,l),n($.$$.fragment,l),n(P.$$.fragment,l),n(Ul.$$.fragment,l),n(tl.$$.fragment,l),n(jl.$$.fragment,l),n(sl.$$.fragment,l),n(Cl.$$.fragment,l),n(yl.$$.fragment,l),n(nl.$$.fragment,l),n(Jl.$$.fragment,l),rM=!1},d(l){l&&(U(Ol),U(ol),U(rl),U(cl),U(p),U(ml),U(O),U(Vl),U(r),U(dl),U(c),U(ul),U(m),U(Rl),U(V),U(Nl),U(Ql),U(u),U(Fl),U(R),U(hl),U(N),U(bl),U(Q),U(gl),U(El),U(h),U(Bl),U(b),U(Dl),U(g),U(Sl),U(E),U(fl),U(B),U(Gl),U(D),U(Zl),U(S),U(Wl),U(kl),U(vl),U(Z),U(Yl),U(Xl),U(xl),U(v),U(_l),U(Hl),U($l),U(x),U(zl),U(_),U(ql),U(H),U(Ll),U(Kl),U(z),U(Pl),U(q),U(lM),U(L),U(MM),U(K),U(UM),U(TM),U(ll),U(tM),U(Ml),U(eM),U(jM),U(Tl),U(sM),U(aM),U(el),U(iM),U(CM),U(yM),U(al),U(IM),U(il),U(nM),U(AM),U(JM),U(Il),U(wM),U(oM),U(Al),U(pM),U(OM),U(pl)),U(w),A(o,l),A(d,l),A(F,l),A(f,l),A(G,l),A(W,l),A(k,l),A(Y,l),A(X,l),A($,l),A(P,l),A(Ul,l),A(tl,l),A(jl,l),A(sl,l),A(Cl,l),A(yl,l),A(nl,l),A(Jl,l)}}}const JU='{"title":"Multi-Agent Systems","local":"multi-agent-systems","sections":[{"title":"Multi-Agent Systems in Action","local":"multi-agent-systems-in-action","sections":[],"depth":2},{"title":"Solving a complex task with a multi-agent hierarchy","local":"solving-a-complex-task-with-a-multi-agent-hierarchy","sections":[{"title":"✌️ Splitting the task between two agents","local":"-splitting-the-task-between-two-agents","sections":[],"depth":3}],"depth":2},{"title":"Adding telemetry","local":"adding-telemetry","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function wU(mM){return sU(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mU extends aU{constructor(w){super(),iU(this,w,wU,AU,tU,{})}}export{mU as component};
