import{s as ye,f as de,o as Ue,n as qs}from"../chunks/scheduler.25b97de1.js";import{S as he,i as je,g as i,s as l,r as p,A as ue,h as M,f as a,c as t,j as rs,u as c,x as T,k as A,y as u,a as n,v as m,d as y,t as d,w as U}from"../chunks/index.d9030fc9.js";import{T as Je}from"../chunks/Tip.baa67368.js";import{D as js}from"../chunks/Docstring.ffac8efa.js";import{C as Us}from"../chunks/CodeBlock.e6cd0d95.js";import{E as me}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as G,E as be}from"../chunks/EditOnGithub.91d95064.js";function Te(V){let r,w="Example:",j,h,J;return h=new Us({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdFBvc2VDb25maWclMkMlMjBWaXRQb3NlRm9yUG9zZUVzdGltYXRpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVml0UG9zZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVml0UG9zZUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBWaXRQb3NlRm9yUG9zZUVzdGltYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitPoseConfig, VitPoseForPoseEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VitPose configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VitPoseConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitPoseForPoseEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=i("p"),r.textContent=w,j=l(),p(h.$$.fragment)},l(o){r=M(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-11lpom8"&&(r.textContent=w),j=t(o),c(h.$$.fragment,o)},m(o,b){n(o,r,b),n(o,j,b),m(h,o,b),J=!0},p:qs,i(o){J||(y(h.$$.fragment,o),J=!0)},o(o){d(h.$$.fragment,o),J=!1},d(o){o&&(a(r),a(j)),U(h,o)}}}function we(V){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=w},l(j){r=M(j,"P",{"data-svelte-h":!0}),T(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(j,h){n(j,r,h)},p:qs,d(j){j&&a(r)}}}function fe(V){let r,w="Examples:",j,h,J;return h=new Us({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFZpdFBvc2VGb3JQb3NlRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMiUyMiklMEFtb2RlbCUyMCUzRCUyMFZpdFBvc2VGb3JQb3NlRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFib3hlcyUyMCUzRCUyMCU1QiU1QiU1QjQxMi44JTJDJTIwMTU3LjYxJTJDJTIwNTMuMDUlMkMlMjAxMzguMDElNUQlMkMlMjAlNUIzODQuNDMlMkMlMjAxNzIuMjElMkMlMjAxNS4xMiUyQyUyMDM1Ljc0JTVEJTVEJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwYm94ZXMlM0Rib3hlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWhlYXRtYXBzJTIwJTNEJTIwb3V0cHV0cy5oZWF0bWFwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VitPoseForPoseEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitPoseForPoseEstimation.from_pretrained(<span class="hljs-string">&quot;&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[[<span class="hljs-number">412.8</span>, <span class="hljs-number">157.61</span>, <span class="hljs-number">53.05</span>, <span class="hljs-number">138.01</span>], [<span class="hljs-number">384.43</span>, <span class="hljs-number">172.21</span>, <span class="hljs-number">15.12</span>, <span class="hljs-number">35.74</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, boxes=boxes, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>heatmaps = outputs.heatmaps`,wrap:!1}}),{c(){r=i("p"),r.textContent=w,j=l(),p(h.$$.fragment)},l(o){r=M(o,"P",{"data-svelte-h":!0}),T(r)!=="svelte-kvfsh7"&&(r.textContent=w),j=t(o),c(h.$$.fragment,o)},m(o,b){n(o,r,b),n(o,j,b),m(h,o,b),J=!0},p:qs,i(o){J||(y(h.$$.fragment,o),J=!0)},o(o){d(h.$$.fragment,o),J=!1},d(o){o&&(a(r),a(j)),U(h,o)}}}function ge(V){let r,w,j,h,J,o,b,us,W,Os='The VitPose model was proposed in <a href="https://arxiv.org/abs/2204.12484" rel="nofollow">ViTPose: Simple Vision Transformer Baselines for Human Pose Estimation</a> by Yufei Xu, Jing Zhang, Qiming Zhang, Dacheng Tao. VitPose employs a standard, non-hierarchical <a href="https://arxiv.org/pdf/2010.11929v2" rel="nofollow">Vision Transformer</a> as backbone for the task of keypoint estimation. A simple decoder head is added on top to predict the heatmaps from a given image. Despite its simplicity, the model gets state-of-the-art results on the challenging MS COCO Keypoint Detection benchmark.',Js,x,se="The abstract from the paper is the following:",bs,z,ee="<em>Although no specific domain knowledge is considered in the design, plain vision transformers have shown excellent performance in visual recognition tasks. However, little effort has been made to reveal the potential of such simple structures for pose estimation tasks. In this paper, we show the surprisingly good capabilities of plain vision transformers for pose estimation from various aspects, namely simplicity in model structure, scalability in model size, flexibility in training paradigm, and transferability of knowledge between models, through a simple baseline model called ViTPose. Specifically, ViTPose employs plain and non-hierarchical vision transformers as backbones to extract features for a given person instance and a lightweight decoder for pose estimation. It can be scaled up from 100M to 1B parameters by taking the advantages of the scalable model capacity and high parallelism of transformers, setting a new Pareto front between throughput and performance. Besides, ViTPose is very flexible regarding the attention type, input resolution, pre-training and finetuning strategy, as well as dealing with multiple pose tasks. We also empirically demonstrate that the knowledge of large ViTPose models can be easily transferred to small ones via a simple knowledge token. Experimental results show that our basic ViTPose model outperforms representative methods on the challenging MS COCO Keypoint Detection benchmark, while the largest model sets a new state-of-the-art.</em>",Ts,S,ae=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a> and <a href="https://github.com/SangbumChoi" rel="nofollow">sangbumchoi</a>.
The original code can be found <a href="https://github.com/ViTAE-Transformer/ViTPose" rel="nofollow">here</a>.`,ws,X,fs,R,ne=`<li>To enable MoE (Mixture of Experts) function in the backbone, user has to give appropriate configuration such as <code>num_experts</code> and input value <code>dataset_index</code> to the backbone model.
However, it is not used in default parameters. Below is the code snippet for usage of MoE function.</li>`,gs,P,Cs,F,le='<li>ViTPose is a so-called top-down keypoint detection model. This means that one first uses an object detector, like <a href="rt_detr.md">RT-DETR</a>, to detect people (or other instances) in an image. Next, ViTPose takes the cropped images as input and predicts the keypoints.</li>',Is,$,_s,D,As,Y,ks,H,Vs,K,vs,v,te,Bs,L,Qs,C,q,Ss,is,oe="Constructs a VitPose image processor.",Xs,B,O,Rs,Ms,re="Preprocess an image or batch of images.",Ns,ss,Zs,f,es,Ps,ps,ie=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/model_doc/vitpose#transformers.VitPoseForPoseEstimation">VitPoseForPoseEstimation</a>. It is used to instantiate a
VitPose model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the VitPose
<a href="https://huggingface.co/google/vitpose-base-patch16-224" rel="nofollow">google/vitpose-base-patch16-224</a> architecture.`,Fs,cs,Me=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,$s,Q,Es,as,Gs,I,ns,Ds,ms,pe=`The VitPose model with a pose estimation head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ys,g,ls,Hs,ys,ce='The <a href="/docs/transformers/pr_30530/en/model_doc/vitpose#transformers.VitPoseForPoseEstimation">VitPoseForPoseEstimation</a> forward method, overrides the <code>__call__</code> special method.',Ks,N,Ls,Z,Ws,ts,xs,hs,zs;return J=new G({props:{title:"VitPose",local:"vitpose",headingTag:"h1"}}),b=new G({props:{title:"Overview",local:"overview",headingTag:"h2"}}),X=new G({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h2"}}),P=new Us({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdFBvc2VCYWNrYm9uZUNvbmZpZyUyQyUyMFZpdFBvc2VCYWNrYm9uZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBY29uZmlnJTIwJTNEJTIwVml0UG9zZUJhY2tib25lQ29uZmlnKG51bV9leHBlcnRzJTNEMyUyQyUyMG91dF9pbmRpY2VzJTNEJTVCLTElNUQpJTBBbW9kZWwlMjAlM0QlMjBWaXRQb3NlQmFja2JvbmUoY29uZmlnKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnJhbmRuKDMlMkMlMjAzJTJDJTIwMjU2JTJDJTIwMTkyKSUwQWRhdGFzZXRfaW5kZXglMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSUyQyUyMDIlMkMlMjAzJTVEKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwaXhlbF92YWx1ZXMlMkMlMjBkYXRhc2V0X2luZGV4KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitPoseBackboneConfig, VitPoseBackbone
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>config = VitPoseBackboneConfig(num_experts=<span class="hljs-number">3</span>, out_indices=[-<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitPoseBackbone(config)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = torch.randn(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">192</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_index = torch.tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, dataset_index)`,wrap:!1}}),$=new Us({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    RTDetrForObjectDetection,
    RTDetrImageProcessor,
    VitPoseConfig,
    VitPoseForPoseEstimation,
    VitPoseImageProcessor,
)


url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000000139.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Stage 1. Run Object Detector (User can replace this object_detector part)</span>
person_image_processor = RTDetrImageProcessor.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd_coco_o365&quot;</span>)
person_model = RTDetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd_coco_o365&quot;</span>)
inputs = person_image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = person_model(**inputs)

results = person_image_processor.post_process_object_detection(
    outputs, target_sizes=torch.tensor([(image.height, image.width)]), threshold=<span class="hljs-number">0.3</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">pascal_voc_to_coco</span>(<span class="hljs-params">bboxes: np.ndarray</span>) -&gt; np.ndarray:
    <span class="hljs-string">&quot;&quot;&quot;
    Converts bounding boxes from the Pascal VOC format to the COCO format.

    In other words, converts from (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format
    to (top_left_x, top_left_y, width, height).

    Args:
        bboxes (\`np.ndarray\` of shape \`(batch_size, 4)):
            Bounding boxes in Pascal VOC format.

    Returns:
        \`np.ndarray\` of shape \`(batch_size, 4) in COCO format.
    &quot;&quot;&quot;</span>
    bboxes[:, <span class="hljs-number">2</span>] = bboxes[:, <span class="hljs-number">2</span>] - bboxes[:, <span class="hljs-number">0</span>]
    bboxes[:, <span class="hljs-number">3</span>] = bboxes[:, <span class="hljs-number">3</span>] - bboxes[:, <span class="hljs-number">1</span>]

    <span class="hljs-keyword">return</span> bboxes

<span class="hljs-comment"># Human label refers 0 index in COCO dataset</span>
boxes = results[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;boxes&quot;</span>][results[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;labels&quot;</span>] == <span class="hljs-number">0</span>]
boxes = [pascal_voc_to_coco(boxes.cpu().numpy())]

<span class="hljs-comment"># Stage 2. Run ViTPose</span>
config = VitPoseConfig()
image_processor = VitPoseImageProcessor.from_pretrained(<span class="hljs-string">&quot;nielsr/vitpose-base-simple&quot;</span>)
model = VitPoseForPoseEstimation.from_pretrained(<span class="hljs-string">&quot;nielsr/vitpose-base-simple&quot;</span>)

pixel_values = image_processor(image, boxes=boxes, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(pixel_values)

pose_results = image_processor.post_process_pose_estimation(outputs, boxes=boxes)[<span class="hljs-number">0</span>]

<span class="hljs-keyword">for</span> pose_result <span class="hljs-keyword">in</span> pose_results:
    <span class="hljs-built_in">print</span>(pose_result)`,wrap:!1}}),D=new G({props:{title:"Visualization for supervision user",local:"visualization-for-supervision-user",headingTag:"h3"}}),Y=new Us({props:{code:"aW1wb3J0JTIwc3VwZXJ2aXNpb24lMjBhcyUyMHN2JTBBJTBBa2V5X3BvaW50cyUyMCUzRCUyMHN2LktleVBvaW50cyh4eSUzRHRvcmNoLmNhdCglNUJwb3NlX3Jlc3VsdCU1QidrZXlwb2ludHMnJTVELnVuc3F1ZWV6ZSgwKSUyMGZvciUyMHBvc2VfcmVzdWx0JTIwaW4lMjBwb3NlX3Jlc3VsdHMlNUQpLmNwdSgpLm51bXB5KCkpJTBBJTBBZWRnZV9hbm5vdGF0b3IlMjAlM0QlMjBzdi5FZGdlQW5ub3RhdG9yKCUwQSUyMCUyMCUyMCUyMGNvbG9yJTNEc3YuQ29sb3IuR1JFRU4lMkMlMEElMjAlMjAlMjAlMjB0aGlja25lc3MlM0Q1JTBBKSUwQWFubm90YXRlZF9mcmFtZSUyMCUzRCUyMGVkZ2VfYW5ub3RhdG9yLmFubm90YXRlKCUwQSUyMCUyMCUyMCUyMHNjZW5lJTNEaW1hZ2UuY29weSgpJTJDJTBBJTIwJTIwJTIwJTIwa2V5X3BvaW50cyUzRGtleV9wb2ludHMlMEEp",highlighted:`<span class="hljs-keyword">import</span> supervision <span class="hljs-keyword">as</span> sv

key_points = sv.KeyPoints(xy=torch.cat([pose_result[<span class="hljs-string">&#x27;keypoints&#x27;</span>].unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> pose_result <span class="hljs-keyword">in</span> pose_results]).cpu().numpy())

edge_annotator = sv.EdgeAnnotator(
    color=sv.Color.GREEN,
    thickness=<span class="hljs-number">5</span>
)
annotated_frame = edge_annotator.annotate(
    scene=image.copy(),
    key_points=key_points
)`,wrap:!1}}),H=new G({props:{title:"Visualization for advanced user",local:"visualization-for-advanced-user",headingTag:"h3"}}),K=new Us({props:{code:"aW1wb3J0JTIwbWF0aCUwQWltcG9ydCUyMGN2MiUwQSUwQWRlZiUyMGRyYXdfcG9pbnRzKGltYWdlJTJDJTIwa2V5cG9pbnRzJTJDJTIwc2NvcmVzJTJDJTIwcG9zZV9rZXlwb2ludF9jb2xvciUyQyUyMGtleXBvaW50X3Njb3JlX3RocmVzaG9sZCUyQyUyMHJhZGl1cyUyQyUyMHNob3dfa2V5cG9pbnRfd2VpZ2h0KSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcG9zZV9rZXlwb2ludF9jb2xvciUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFzc2VydCUyMGxlbihwb3NlX2tleXBvaW50X2NvbG9yKSUyMCUzRCUzRCUyMGxlbihrZXlwb2ludHMpJTBBJTIwJTIwJTIwJTIwZm9yJTIwa2lkJTJDJTIwKGtwdCUyQyUyMGtwdF9zY29yZSklMjBpbiUyMGVudW1lcmF0ZSh6aXAoa2V5cG9pbnRzJTJDJTIwc2NvcmVzKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4X2Nvb3JkJTJDJTIweV9jb29yZCUyMCUzRCUyMGludChrcHQlNUIwJTVEKSUyQyUyMGludChrcHQlNUIxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwa3B0X3Njb3JlJTIwJTNFJTIwa2V5cG9pbnRfc2NvcmVfdGhyZXNob2xkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sb3IlMjAlM0QlMjB0dXBsZShpbnQoYyklMjBmb3IlMjBjJTIwaW4lMjBwb3NlX2tleXBvaW50X2NvbG9yJTVCa2lkJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2hvd19rZXlwb2ludF93ZWlnaHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdjIuY2lyY2xlKGltYWdlJTJDJTIwKGludCh4X2Nvb3JkKSUyQyUyMGludCh5X2Nvb3JkKSklMkMlMjByYWRpdXMlMkMlMjBjb2xvciUyQyUyMC0xKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zcGFyZW5jeSUyMCUzRCUyMG1heCgwJTJDJTIwbWluKDElMkMlMjBrcHRfc2NvcmUpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN2Mi5hZGRXZWlnaHRlZChpbWFnZSUyQyUyMHRyYW5zcGFyZW5jeSUyQyUyMGltYWdlJTJDJTIwMSUyMC0lMjB0cmFuc3BhcmVuY3klMkMlMjAwJTJDJTIwZHN0JTNEaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN2Mi5jaXJjbGUoaW1hZ2UlMkMlMjAoaW50KHhfY29vcmQpJTJDJTIwaW50KHlfY29vcmQpKSUyQyUyMHJhZGl1cyUyQyUyMGNvbG9yJTJDJTIwLTEpJTBBJTBBZGVmJTIwZHJhd19saW5rcyhpbWFnZSUyQyUyMGtleXBvaW50cyUyQyUyMHNjb3JlcyUyQyUyMGtleXBvaW50X2VkZ2VzJTJDJTIwbGlua19jb2xvcnMlMkMlMjBrZXlwb2ludF9zY29yZV90aHJlc2hvbGQlMkMlMjB0aGlja25lc3MlMkMlMjBzaG93X2tleXBvaW50X3dlaWdodCUyQyUyMHN0aWNrX3dpZHRoJTIwJTNEJTIwMiklM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMkMlMjB3aWR0aCUyQyUyMF8lMjAlM0QlMjBpbWFnZS5zaGFwZSUwQSUyMCUyMCUyMCUyMGlmJTIwa2V5cG9pbnRfZWRnZXMlMjBpcyUyMG5vdCUyME5vbmUlMjBhbmQlMjBsaW5rX2NvbG9ycyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFzc2VydCUyMGxlbihsaW5rX2NvbG9ycyklMjAlM0QlM0QlMjBsZW4oa2V5cG9pbnRfZWRnZXMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwc2tfaWQlMkMlMjBzayUyMGluJTIwZW51bWVyYXRlKGtleXBvaW50X2VkZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHgxJTJDJTIweTElMkMlMjBzY29yZTElMjAlM0QlMjAoaW50KGtleXBvaW50cyU1QnNrJTVCMCU1RCUyQyUyMDAlNUQpJTJDJTIwaW50KGtleXBvaW50cyU1QnNrJTVCMCU1RCUyQyUyMDElNUQpJTJDJTIwc2NvcmVzJTVCc2slNUIwJTVEJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHgyJTJDJTIweTIlMkMlMjBzY29yZTIlMjAlM0QlMjAoaW50KGtleXBvaW50cyU1QnNrJTVCMSU1RCUyQyUyMDAlNUQpJTJDJTIwaW50KGtleXBvaW50cyU1QnNrJTVCMSU1RCUyQyUyMDElNUQpJTJDJTIwc2NvcmVzJTVCc2slNUIxJTVEJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHgxJTIwJTNFJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuZCUyMHgxJTIwJTNDJTIwd2lkdGglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbmQlMjB5MSUyMCUzRSUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbmQlMjB5MSUyMCUzQyUyMGhlaWdodCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuZCUyMHgyJTIwJTNFJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuZCUyMHgyJTIwJTNDJTIwd2lkdGglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbmQlMjB5MiUyMCUzRSUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbmQlMjB5MiUyMCUzQyUyMGhlaWdodCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuZCUyMHNjb3JlMSUyMCUzRSUyMGtleXBvaW50X3Njb3JlX3RocmVzaG9sZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuZCUyMHNjb3JlMiUyMCUzRSUyMGtleXBvaW50X3Njb3JlX3RocmVzaG9sZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb2xvciUyMCUzRCUyMHR1cGxlKGludChjKSUyMGZvciUyMGMlMjBpbiUyMGxpbmtfY29sb3JzJTVCc2tfaWQlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzaG93X2tleXBvaW50X3dlaWdodCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFglMjAlM0QlMjAoeDElMkMlMjB4MiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBZJTIwJTNEJTIwKHkxJTJDJTIweTIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVhbl94JTIwJTNEJTIwbnAubWVhbihYKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lYW5feSUyMCUzRCUyMG5wLm1lYW4oWSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsZW5ndGglMjAlM0QlMjAoKFklNUIwJTVEJTIwLSUyMFklNUIxJTVEKSUyMCoqJTIwMiUyMCUyQiUyMChYJTVCMCU1RCUyMC0lMjBYJTVCMSU1RCklMjAqKiUyMDIpJTIwKiolMjAwLjUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbmdsZSUyMCUzRCUyMG1hdGguZGVncmVlcyhtYXRoLmF0YW4yKFklNUIwJTVEJTIwLSUyMFklNUIxJTVEJTJDJTIwWCU1QjAlNUQlMjAtJTIwWCU1QjElNUQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBvbHlnb24lMjAlM0QlMjBjdjIuZWxsaXBzZTJQb2x5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMChpbnQobWVhbl94KSUyQyUyMGludChtZWFuX3kpKSUyQyUyMChpbnQobGVuZ3RoJTIwJTJGJTIwMiklMkMlMjBpbnQoc3RpY2tfd2lkdGgpKSUyQyUyMGludChhbmdsZSklMkMlMjAwJTJDJTIwMzYwJTJDJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdjIuZmlsbENvbnZleFBvbHkoaW1hZ2UlMkMlMjBwb2x5Z29uJTJDJTIwY29sb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNwYXJlbmN5JTIwJTNEJTIwbWF4KDAlMkMlMjBtaW4oMSUyQyUyMDAuNSUyMColMjAoa2V5cG9pbnRzJTVCc2slNUIwJTVEJTJDJTIwMiU1RCUyMCUyQiUyMGtleXBvaW50cyU1QnNrJTVCMSU1RCUyQyUyMDIlNUQpKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdjIuYWRkV2VpZ2h0ZWQoaW1hZ2UlMkMlMjB0cmFuc3BhcmVuY3klMkMlMjBpbWFnZSUyQyUyMDElMjAtJTIwdHJhbnNwYXJlbmN5JTJDJTIwMCUyQyUyMGRzdCUzRGltYWdlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdjIubGluZShpbWFnZSUyQyUyMCh4MSUyQyUyMHkxKSUyQyUyMCh4MiUyQyUyMHkyKSUyQyUyMGNvbG9yJTJDJTIwdGhpY2tuZXNzJTNEdGhpY2tuZXNzKSUwQSUwQSUwQSUyMyUyME5vdGUlM0ElMjBrZXlwb2ludF9lZGdlcyUyMGFuZCUyMGNvbG9yJTIwcGFsZXR0ZSUyMGFyZSUyMGRhdGFzZXQtc3BlY2lmaWMlMEFrZXlwb2ludF9lZGdlcyUyMCUzRCUyMG1vZGVsLmNvbmZpZy5lZGdlcyUwQSUwQXBhbGV0dGUlMjAlM0QlMjBucC5hcnJheSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIyNTUlMkMlMjAxMjglMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMjU1JTJDJTIwMTUzJTJDJTIwNTElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIyNTUlMkMlMjAxNzglMkMlMjAxMDIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIyMzAlMkMlMjAyMzAlMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMjU1JTJDJTIwMTUzJTJDJTIwMjU1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMTUzJTJDJTIwMjA0JTJDJTIwMjU1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMjU1JTJDJTIwMTAyJTJDJTIwMjU1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMjU1JTJDJTIwNTElMkMlMjAyNTUlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIxMDIlMkMlMjAxNzglMkMlMjAyNTUlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUI1MSUyQyUyMDE1MyUyQyUyMDI1NSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjI1NSUyQyUyMDE1MyUyQyUyMDE1MyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjI1NSUyQyUyMDEwMiUyQyUyMDEwMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjI1NSUyQyUyMDUxJTJDJTIwNTElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIxNTMlMkMlMjAyNTUlMkMlMjAxNTMlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIxMDIlMkMlMjAyNTUlMkMlMjAxMDIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUI1MSUyQyUyMDI1NSUyQyUyMDUxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMCUyQyUyMDI1NSUyQyUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwJTJDJTIwMCUyQyUyMDI1NSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjI1NSUyQyUyMDAlMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMjU1JTJDJTIwMjU1JTJDJTIwMjU1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQWxpbmtfY29sb3JzJTIwJTNEJTIwcGFsZXR0ZSU1QiU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjA3JTJDJTIwNyUyQyUyMDclMkMlMjA5JTJDJTIwOSUyQyUyMDklMkMlMjA5JTJDJTIwOSUyQyUyMDE2JTJDJTIwMTYlMkMlMjAxNiUyQyUyMDE2JTJDJTIwMTYlMkMlMjAxNiUyQyUyMDE2JTVEJTVEJTBBa2V5cG9pbnRfY29sb3JzJTIwJTNEJTIwcGFsZXR0ZSU1QiU1QjE2JTJDJTIwMTYlMkMlMjAxNiUyQyUyMDE2JTJDJTIwMTYlMkMlMjA5JTJDJTIwOSUyQyUyMDklMkMlMjA5JTJDJTIwOSUyQyUyMDklMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlNUQlNUQlMEElMEFudW1weV9pbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlKSUwQSUwQWZvciUyMHBvc2VfcmVzdWx0JTIwaW4lMjBwb3NlX3Jlc3VsdHMlM0ElMEElMjAlMjAlMjAlMjBzY29yZXMlMjAlM0QlMjBucC5hcnJheShwb3NlX3Jlc3VsdCU1QiUyMnNjb3JlcyUyMiU1RCklMEElMjAlMjAlMjAlMjBrZXlwb2ludHMlMjAlM0QlMjBucC5hcnJheShwb3NlX3Jlc3VsdCU1QiUyMmtleXBvaW50cyUyMiU1RCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBkcmF3JTIwZWFjaCUyMHBvaW50JTIwb24lMjBpbWFnZSUwQSUyMCUyMCUyMCUyMGRyYXdfcG9pbnRzKG51bXB5X2ltYWdlJTJDJTIwa2V5cG9pbnRzJTJDJTIwc2NvcmVzJTJDJTIwa2V5cG9pbnRfY29sb3JzJTJDJTIwa2V5cG9pbnRfc2NvcmVfdGhyZXNob2xkJTNEMC4zJTJDJTIwcmFkaXVzJTNENCUyQyUyMHNob3dfa2V5cG9pbnRfd2VpZ2h0JTNERmFsc2UpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZHJhdyUyMGxpbmtzJTBBJTIwJTIwJTIwJTIwZHJhd19saW5rcyhudW1weV9pbWFnZSUyQyUyMGtleXBvaW50cyUyQyUyMHNjb3JlcyUyQyUyMGtleXBvaW50X2VkZ2VzJTJDJTIwbGlua19jb2xvcnMlMkMlMjBrZXlwb2ludF9zY29yZV90aHJlc2hvbGQlM0QwLjMlMkMlMjB0aGlja25lc3MlM0QxJTJDJTIwc2hvd19rZXlwb2ludF93ZWlnaHQlM0RGYWxzZSklMEElMEFwb3NlX2ltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KG51bXB5X2ltYWdlKSUwQXBvc2VfaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">import</span> cv2

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_points</span>(<span class="hljs-params">image, keypoints, scores, pose_keypoint_color, keypoint_score_threshold, radius, show_keypoint_weight</span>):
    <span class="hljs-keyword">if</span> pose_keypoint_color <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">len</span>(pose_keypoint_color) == <span class="hljs-built_in">len</span>(keypoints)
    <span class="hljs-keyword">for</span> kid, (kpt, kpt_score) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">zip</span>(keypoints, scores)):
        x_coord, y_coord = <span class="hljs-built_in">int</span>(kpt[<span class="hljs-number">0</span>]), <span class="hljs-built_in">int</span>(kpt[<span class="hljs-number">1</span>])
        <span class="hljs-keyword">if</span> kpt_score &gt; keypoint_score_threshold:
            color = <span class="hljs-built_in">tuple</span>(<span class="hljs-built_in">int</span>(c) <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> pose_keypoint_color[kid])
            <span class="hljs-keyword">if</span> show_keypoint_weight:
                cv2.circle(image, (<span class="hljs-built_in">int</span>(x_coord), <span class="hljs-built_in">int</span>(y_coord)), radius, color, -<span class="hljs-number">1</span>)
                transparency = <span class="hljs-built_in">max</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">min</span>(<span class="hljs-number">1</span>, kpt_score))
                cv2.addWeighted(image, transparency, image, <span class="hljs-number">1</span> - transparency, <span class="hljs-number">0</span>, dst=image)
            <span class="hljs-keyword">else</span>:
                cv2.circle(image, (<span class="hljs-built_in">int</span>(x_coord), <span class="hljs-built_in">int</span>(y_coord)), radius, color, -<span class="hljs-number">1</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_links</span>(<span class="hljs-params">image, keypoints, scores, keypoint_edges, link_colors, keypoint_score_threshold, thickness, show_keypoint_weight, stick_width = <span class="hljs-number">2</span></span>):
    height, width, _ = image.shape
    <span class="hljs-keyword">if</span> keypoint_edges <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> link_colors <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">len</span>(link_colors) == <span class="hljs-built_in">len</span>(keypoint_edges)
        <span class="hljs-keyword">for</span> sk_id, sk <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(keypoint_edges):
            x1, y1, score1 = (<span class="hljs-built_in">int</span>(keypoints[sk[<span class="hljs-number">0</span>], <span class="hljs-number">0</span>]), <span class="hljs-built_in">int</span>(keypoints[sk[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>]), scores[sk[<span class="hljs-number">0</span>]])
            x2, y2, score2 = (<span class="hljs-built_in">int</span>(keypoints[sk[<span class="hljs-number">1</span>], <span class="hljs-number">0</span>]), <span class="hljs-built_in">int</span>(keypoints[sk[<span class="hljs-number">1</span>], <span class="hljs-number">1</span>]), scores[sk[<span class="hljs-number">1</span>]])
            <span class="hljs-keyword">if</span> (
                x1 &gt; <span class="hljs-number">0</span>
                <span class="hljs-keyword">and</span> x1 &lt; width
                <span class="hljs-keyword">and</span> y1 &gt; <span class="hljs-number">0</span>
                <span class="hljs-keyword">and</span> y1 &lt; height
                <span class="hljs-keyword">and</span> x2 &gt; <span class="hljs-number">0</span>
                <span class="hljs-keyword">and</span> x2 &lt; width
                <span class="hljs-keyword">and</span> y2 &gt; <span class="hljs-number">0</span>
                <span class="hljs-keyword">and</span> y2 &lt; height
                <span class="hljs-keyword">and</span> score1 &gt; keypoint_score_threshold
                <span class="hljs-keyword">and</span> score2 &gt; keypoint_score_threshold
            ):
                color = <span class="hljs-built_in">tuple</span>(<span class="hljs-built_in">int</span>(c) <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> link_colors[sk_id])
                <span class="hljs-keyword">if</span> show_keypoint_weight:
                    X = (x1, x2)
                    Y = (y1, y2)
                    mean_x = np.mean(X)
                    mean_y = np.mean(Y)
                    length = ((Y[<span class="hljs-number">0</span>] - Y[<span class="hljs-number">1</span>]) ** <span class="hljs-number">2</span> + (X[<span class="hljs-number">0</span>] - X[<span class="hljs-number">1</span>]) ** <span class="hljs-number">2</span>) ** <span class="hljs-number">0.5</span>
                    angle = math.degrees(math.atan2(Y[<span class="hljs-number">0</span>] - Y[<span class="hljs-number">1</span>], X[<span class="hljs-number">0</span>] - X[<span class="hljs-number">1</span>]))
                    polygon = cv2.ellipse2Poly(
                        (<span class="hljs-built_in">int</span>(mean_x), <span class="hljs-built_in">int</span>(mean_y)), (<span class="hljs-built_in">int</span>(length / <span class="hljs-number">2</span>), <span class="hljs-built_in">int</span>(stick_width)), <span class="hljs-built_in">int</span>(angle), <span class="hljs-number">0</span>, <span class="hljs-number">360</span>, <span class="hljs-number">1</span>
                    )
                    cv2.fillConvexPoly(image, polygon, color)
                    transparency = <span class="hljs-built_in">max</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">min</span>(<span class="hljs-number">1</span>, <span class="hljs-number">0.5</span> * (keypoints[sk[<span class="hljs-number">0</span>], <span class="hljs-number">2</span>] + keypoints[sk[<span class="hljs-number">1</span>], <span class="hljs-number">2</span>])))
                    cv2.addWeighted(image, transparency, image, <span class="hljs-number">1</span> - transparency, <span class="hljs-number">0</span>, dst=image)
                <span class="hljs-keyword">else</span>:
                    cv2.line(image, (x1, y1), (x2, y2), color, thickness=thickness)


<span class="hljs-comment"># Note: keypoint_edges and color palette are dataset-specific</span>
keypoint_edges = model.config.edges

palette = np.array(
    [
        [<span class="hljs-number">255</span>, <span class="hljs-number">128</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">153</span>, <span class="hljs-number">51</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">178</span>, <span class="hljs-number">102</span>],
        [<span class="hljs-number">230</span>, <span class="hljs-number">230</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">153</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">153</span>, <span class="hljs-number">204</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">102</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">51</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">102</span>, <span class="hljs-number">178</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">51</span>, <span class="hljs-number">153</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">153</span>, <span class="hljs-number">153</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">102</span>, <span class="hljs-number">102</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">51</span>, <span class="hljs-number">51</span>],
        [<span class="hljs-number">153</span>, <span class="hljs-number">255</span>, <span class="hljs-number">153</span>],
        [<span class="hljs-number">102</span>, <span class="hljs-number">255</span>, <span class="hljs-number">102</span>],
        [<span class="hljs-number">51</span>, <span class="hljs-number">255</span>, <span class="hljs-number">51</span>],
        [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
    ]
)

link_colors = palette[[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>]]
keypoint_colors = palette[[<span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]

numpy_image = np.array(image)

<span class="hljs-keyword">for</span> pose_result <span class="hljs-keyword">in</span> pose_results:
    scores = np.array(pose_result[<span class="hljs-string">&quot;scores&quot;</span>])
    keypoints = np.array(pose_result[<span class="hljs-string">&quot;keypoints&quot;</span>])

    <span class="hljs-comment"># draw each point on image</span>
    draw_points(numpy_image, keypoints, scores, keypoint_colors, keypoint_score_threshold=<span class="hljs-number">0.3</span>, radius=<span class="hljs-number">4</span>, show_keypoint_weight=<span class="hljs-literal">False</span>)

    <span class="hljs-comment"># draw links</span>
    draw_links(numpy_image, keypoints, scores, keypoint_edges, link_colors, keypoint_score_threshold=<span class="hljs-number">0.3</span>, thickness=<span class="hljs-number">1</span>, show_keypoint_weight=<span class="hljs-literal">False</span>)

pose_image = Image.fromarray(numpy_image)
pose_image`,wrap:!1}}),L=new G({props:{title:"VitPoseImageProcessor",local:"transformers.VitPoseImageProcessor",headingTag:"h2"}}),q=new js({props:{name:"class transformers.VitPoseImageProcessor",anchor:"transformers.VitPoseImageProcessor",parameters:[{name:"do_affine_transform",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitPoseImageProcessor.do_affine_transform",description:`<strong>do_affine_transform</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply an affine transformation to the input images.`,name:"do_affine_transform"},{anchor:"transformers.VitPoseImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 192}</code>):
Resolution of the image after <code>affine_transform</code> is applied. Only has an effect if <code>do_affine_transform</code> is set to <code>True</code>. Can
be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.VitPoseImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.).`,name:"do_rescale"},{anchor:"transformers.VitPoseImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.VitPoseImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.VitPoseImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>List[int]</code>, defaults to <code>[0.485, 0.456, 0.406]</code>, <em>optional</em>) &#x2014;
The sequence of means for each channel, to be used when normalizing images.`,name:"image_mean"},{anchor:"transformers.VitPoseImageProcessor.image_std",description:`<strong>image_std</strong> (<code>List[int]</code>, defaults to <code>[0.229, 0.224, 0.225]</code>, <em>optional</em>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/vitpose/image_processing_vitpose.py#L325"}}),O=new js({props:{name:"preprocess",anchor:"transformers.VitPoseImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"boxes",val:": typing.Union[typing.List[typing.List[float]], numpy.ndarray]"},{name:"do_affine_transform",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.VitPoseImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VitPoseImageProcessor.preprocess.boxes",description:`<strong>boxes</strong> (<code>List[List[List[float]]]</code> or <code>np.ndarray</code>) &#x2014;
List or array of bounding boxes for each image. Each box should be a list of 4 floats representing the bounding
box coordinates in COCO format (top_left_x, top_left_y, width, height).`,name:"boxes"},{anchor:"transformers.VitPoseImageProcessor.preprocess.do_affine_transform",description:`<strong>do_affine_transform</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_affine_transform</code>) &#x2014;
Whether to apply an affine transformation to the input images.`,name:"do_affine_transform"},{anchor:"transformers.VitPoseImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> specifying the size of the output image after
resizing.`,name:"size"},{anchor:"transformers.VitPoseImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.VitPoseImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VitPoseImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VitPoseImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VitPoseImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.VitPoseImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_30530/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>, defaults to <code>&apos;np&apos;</code>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/vitpose/image_processing_vitpose.py#L420",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model, of shape (batch_size, num_channels, height,
width).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),ss=new G({props:{title:"VitPoseConfig",local:"transformers.VitPoseConfig",headingTag:"h2"}}),es=new js({props:{name:"class transformers.VitPoseConfig",anchor:"transformers.VitPoseConfig",parameters:[{name:"backbone_config",val:": PretrainedConfig = None"},{name:"backbone",val:": str = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": dict = None"},{name:"initializer_range",val:": float = 0.02"},{name:"scale_factor",val:": int = 4"},{name:"use_simple_decoder",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitPoseConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>VitPoseBackboneConfig()</code>) &#x2014;
The configuration of the backbone model. Currently, only <code>backbone_config</code> with <code>vitpose_backbone</code> as <code>model_type</code> is supported.`,name:"backbone_config"},{anchor:"transformers.VitPoseConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.VitPoseConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.VitPoseConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.VitPoseConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.VitPoseConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VitPoseConfig.scale_factor",description:`<strong>scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Factor to upscale the feature maps coming from the ViT backbone.`,name:"scale_factor"},{anchor:"transformers.VitPoseConfig.use_simple_decoder",description:`<strong>use_simple_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use a <code>VitPoseSimpleDecoder</code> to decode the feature maps from the backbone into heatmaps. Otherwise it uses <code>VitPoseClassicDecoder</code>.`,name:"use_simple_decoder"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/vitpose/configuration_vitpose.py#L26"}}),Q=new me({props:{anchor:"transformers.VitPoseConfig.example",$$slots:{default:[Te]},$$scope:{ctx:V}}}),as=new G({props:{title:"VitPoseForPoseEstimation",local:"transformers.VitPoseForPoseEstimation",headingTag:"h2"}}),ns=new js({props:{name:"class transformers.VitPoseForPoseEstimation",anchor:"transformers.VitPoseForPoseEstimation",parameters:[{name:"config",val:": VitPoseConfig"}],parametersDescription:[{anchor:"transformers.VitPoseForPoseEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/vitpose#transformers.VitPoseConfig">VitPoseConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/vitpose/modeling_vitpose.py#L237"}}),ls=new js({props:{name:"forward",anchor:"transformers.VitPoseForPoseEstimation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"dataset_index",val:": typing.Optional[torch.Tensor] = None"},{name:"flip_pairs",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VitPoseForPoseEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/vitpose#transformers.VitPoseImageProcessor">VitPoseImageProcessor</a>. See
<a href="/docs/transformers/pr_30530/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">VitPoseImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VitPoseForPoseEstimation.forward.dataset_index",description:`<strong>dataset_index</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>) &#x2014;
Index to use in the Mixture-of-Experts (MoE) blocks of the backbone.</p>
<p>This corresponds to the dataset index used during training, e.g. For the single dataset index 0 refers to the corresponding dataset. For the multiple datasets index 0 refers to dataset A (e.g. MPII) and index 1 refers to dataset B (e.g. CrowdPose).`,name:"dataset_index"},{anchor:"transformers.VitPoseForPoseEstimation.forward.flip_pairs",description:`<strong>flip_pairs</strong> (<code>torch.tensor</code>, <em>optional</em>) &#x2014;
Whether to mirror pairs of keypoints (for example, left ear &#x2014; right ear).`,name:"flip_pairs"},{anchor:"transformers.VitPoseForPoseEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VitPoseForPoseEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VitPoseForPoseEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/vitpose/modeling_vitpose.py#L260",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.vitpose.modeling_vitpose.VitPoseEstimatorOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30530/en/model_doc/vitpose#transformers.VitPoseConfig"
>VitPoseConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Loss is not supported at this moment. See <a
  href="https://github.com/ViTAE-Transformer/ViTPose/tree/main/mmpose/models/losses"
  rel="nofollow"
>https://github.com/ViTAE-Transformer/ViTPose/tree/main/mmpose/models/losses</a> for further detail.</p>
</li>
<li>
<p><strong>heatmaps</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_keypoints, height, width)</code>) — Heatmaps as predicted by the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.vitpose.modeling_vitpose.VitPoseEstimatorOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new Je({props:{$$slots:{default:[we]},$$scope:{ctx:V}}}),Z=new me({props:{anchor:"transformers.VitPoseForPoseEstimation.forward.example",$$slots:{default:[fe]},$$scope:{ctx:V}}}),ts=new be({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/vitpose.md"}}),{c(){r=i("meta"),w=l(),j=i("p"),h=l(),p(J.$$.fragment),o=l(),p(b.$$.fragment),us=l(),W=i("p"),W.innerHTML=Os,Js=l(),x=i("p"),x.textContent=se,bs=l(),z=i("p"),z.innerHTML=ee,Ts=l(),S=i("p"),S.innerHTML=ae,ws=l(),p(X.$$.fragment),fs=l(),R=i("ul"),R.innerHTML=ne,gs=l(),p(P.$$.fragment),Cs=l(),F=i("ul"),F.innerHTML=le,Is=l(),p($.$$.fragment),_s=l(),p(D.$$.fragment),As=l(),p(Y.$$.fragment),ks=l(),p(H.$$.fragment),Vs=l(),p(K.$$.fragment),vs=l(),v=i("img"),Bs=l(),p(L.$$.fragment),Qs=l(),C=i("div"),p(q.$$.fragment),Ss=l(),is=i("p"),is.textContent=oe,Xs=l(),B=i("div"),p(O.$$.fragment),Rs=l(),Ms=i("p"),Ms.textContent=re,Ns=l(),p(ss.$$.fragment),Zs=l(),f=i("div"),p(es.$$.fragment),Ps=l(),ps=i("p"),ps.innerHTML=ie,Fs=l(),cs=i("p"),cs.innerHTML=Me,$s=l(),p(Q.$$.fragment),Es=l(),p(as.$$.fragment),Gs=l(),I=i("div"),p(ns.$$.fragment),Ds=l(),ms=i("p"),ms.innerHTML=pe,Ys=l(),g=i("div"),p(ls.$$.fragment),Hs=l(),ys=i("p"),ys.innerHTML=ce,Ks=l(),p(N.$$.fragment),Ls=l(),p(Z.$$.fragment),Ws=l(),p(ts.$$.fragment),xs=l(),hs=i("p"),this.h()},l(s){const e=ue("svelte-u9bgzb",document.head);r=M(e,"META",{name:!0,content:!0}),e.forEach(a),w=t(s),j=M(s,"P",{}),rs(j).forEach(a),h=t(s),c(J.$$.fragment,s),o=t(s),c(b.$$.fragment,s),us=t(s),W=M(s,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1ijga8w"&&(W.innerHTML=Os),Js=t(s),x=M(s,"P",{"data-svelte-h":!0}),T(x)!=="svelte-vfdo9a"&&(x.textContent=se),bs=t(s),z=M(s,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1r8g7qv"&&(z.innerHTML=ee),Ts=t(s),S=M(s,"P",{"data-svelte-h":!0}),T(S)!=="svelte-1pkw5cm"&&(S.innerHTML=ae),ws=t(s),c(X.$$.fragment,s),fs=t(s),R=M(s,"UL",{"data-svelte-h":!0}),T(R)!=="svelte-1j4in9t"&&(R.innerHTML=ne),gs=t(s),c(P.$$.fragment,s),Cs=t(s),F=M(s,"UL",{"data-svelte-h":!0}),T(F)!=="svelte-siu8fi"&&(F.innerHTML=le),Is=t(s),c($.$$.fragment,s),_s=t(s),c(D.$$.fragment,s),As=t(s),c(Y.$$.fragment,s),ks=t(s),c(H.$$.fragment,s),Vs=t(s),c(K.$$.fragment,s),vs=t(s),v=M(s,"IMG",{src:!0,alt:!0,width:!0}),Bs=t(s),c(L.$$.fragment,s),Qs=t(s),C=M(s,"DIV",{class:!0});var k=rs(C);c(q.$$.fragment,k),Ss=t(k),is=M(k,"P",{"data-svelte-h":!0}),T(is)!=="svelte-1uf40pk"&&(is.textContent=oe),Xs=t(k),B=M(k,"DIV",{class:!0});var os=rs(B);c(O.$$.fragment,os),Rs=t(os),Ms=M(os,"P",{"data-svelte-h":!0}),T(Ms)!=="svelte-1x3yxsa"&&(Ms.textContent=re),os.forEach(a),k.forEach(a),Ns=t(s),c(ss.$$.fragment,s),Zs=t(s),f=M(s,"DIV",{class:!0});var _=rs(f);c(es.$$.fragment,_),Ps=t(_),ps=M(_,"P",{"data-svelte-h":!0}),T(ps)!=="svelte-1t49qam"&&(ps.innerHTML=ie),Fs=t(_),cs=M(_,"P",{"data-svelte-h":!0}),T(cs)!=="svelte-l1blo3"&&(cs.innerHTML=Me),$s=t(_),c(Q.$$.fragment,_),_.forEach(a),Es=t(s),c(as.$$.fragment,s),Gs=t(s),I=M(s,"DIV",{class:!0});var ds=rs(I);c(ns.$$.fragment,ds),Ds=t(ds),ms=M(ds,"P",{"data-svelte-h":!0}),T(ms)!=="svelte-1eb2kd5"&&(ms.innerHTML=pe),Ys=t(ds),g=M(ds,"DIV",{class:!0});var E=rs(g);c(ls.$$.fragment,E),Hs=t(E),ys=M(E,"P",{"data-svelte-h":!0}),T(ys)!=="svelte-oywgzg"&&(ys.innerHTML=ce),Ks=t(E),c(N.$$.fragment,E),Ls=t(E),c(Z.$$.fragment,E),E.forEach(a),ds.forEach(a),Ws=t(s),c(ts.$$.fragment,s),xs=t(s),hs=M(s,"P",{}),rs(hs).forEach(a),this.h()},h(){A(r,"name","hf:doc:metadata"),A(r,"content",Ce),de(v.src,te="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/vitpose-coco.jpg")||A(v,"src",te),A(v,"alt","drawing"),A(v,"width","600"),A(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,e){u(document.head,r),n(s,w,e),n(s,j,e),n(s,h,e),m(J,s,e),n(s,o,e),m(b,s,e),n(s,us,e),n(s,W,e),n(s,Js,e),n(s,x,e),n(s,bs,e),n(s,z,e),n(s,Ts,e),n(s,S,e),n(s,ws,e),m(X,s,e),n(s,fs,e),n(s,R,e),n(s,gs,e),m(P,s,e),n(s,Cs,e),n(s,F,e),n(s,Is,e),m($,s,e),n(s,_s,e),m(D,s,e),n(s,As,e),m(Y,s,e),n(s,ks,e),m(H,s,e),n(s,Vs,e),m(K,s,e),n(s,vs,e),n(s,v,e),n(s,Bs,e),m(L,s,e),n(s,Qs,e),n(s,C,e),m(q,C,null),u(C,Ss),u(C,is),u(C,Xs),u(C,B),m(O,B,null),u(B,Rs),u(B,Ms),n(s,Ns,e),m(ss,s,e),n(s,Zs,e),n(s,f,e),m(es,f,null),u(f,Ps),u(f,ps),u(f,Fs),u(f,cs),u(f,$s),m(Q,f,null),n(s,Es,e),m(as,s,e),n(s,Gs,e),n(s,I,e),m(ns,I,null),u(I,Ds),u(I,ms),u(I,Ys),u(I,g),m(ls,g,null),u(g,Hs),u(g,ys),u(g,Ks),m(N,g,null),u(g,Ls),m(Z,g,null),n(s,Ws,e),m(ts,s,e),n(s,xs,e),n(s,hs,e),zs=!0},p(s,[e]){const k={};e&2&&(k.$$scope={dirty:e,ctx:s}),Q.$set(k);const os={};e&2&&(os.$$scope={dirty:e,ctx:s}),N.$set(os);const _={};e&2&&(_.$$scope={dirty:e,ctx:s}),Z.$set(_)},i(s){zs||(y(J.$$.fragment,s),y(b.$$.fragment,s),y(X.$$.fragment,s),y(P.$$.fragment,s),y($.$$.fragment,s),y(D.$$.fragment,s),y(Y.$$.fragment,s),y(H.$$.fragment,s),y(K.$$.fragment,s),y(L.$$.fragment,s),y(q.$$.fragment,s),y(O.$$.fragment,s),y(ss.$$.fragment,s),y(es.$$.fragment,s),y(Q.$$.fragment,s),y(as.$$.fragment,s),y(ns.$$.fragment,s),y(ls.$$.fragment,s),y(N.$$.fragment,s),y(Z.$$.fragment,s),y(ts.$$.fragment,s),zs=!0)},o(s){d(J.$$.fragment,s),d(b.$$.fragment,s),d(X.$$.fragment,s),d(P.$$.fragment,s),d($.$$.fragment,s),d(D.$$.fragment,s),d(Y.$$.fragment,s),d(H.$$.fragment,s),d(K.$$.fragment,s),d(L.$$.fragment,s),d(q.$$.fragment,s),d(O.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(Q.$$.fragment,s),d(as.$$.fragment,s),d(ns.$$.fragment,s),d(ls.$$.fragment,s),d(N.$$.fragment,s),d(Z.$$.fragment,s),d(ts.$$.fragment,s),zs=!1},d(s){s&&(a(w),a(j),a(h),a(o),a(us),a(W),a(Js),a(x),a(bs),a(z),a(Ts),a(S),a(ws),a(fs),a(R),a(gs),a(Cs),a(F),a(Is),a(_s),a(As),a(ks),a(Vs),a(vs),a(v),a(Bs),a(Qs),a(C),a(Ns),a(Zs),a(f),a(Es),a(Gs),a(I),a(Ws),a(xs),a(hs)),a(r),U(J,s),U(b,s),U(X,s),U(P,s),U($,s),U(D,s),U(Y,s),U(H,s),U(K,s),U(L,s),U(q),U(O),U(ss,s),U(es),U(Q),U(as,s),U(ns),U(ls),U(N),U(Z),U(ts,s)}}}const Ce='{"title":"VitPose","local":"vitpose","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage Tips","local":"usage-tips","sections":[{"title":"Visualization for supervision user","local":"visualization-for-supervision-user","sections":[],"depth":3},{"title":"Visualization for advanced user","local":"visualization-for-advanced-user","sections":[],"depth":3}],"depth":2},{"title":"VitPoseImageProcessor","local":"transformers.VitPoseImageProcessor","sections":[],"depth":2},{"title":"VitPoseConfig","local":"transformers.VitPoseConfig","sections":[],"depth":2},{"title":"VitPoseForPoseEstimation","local":"transformers.VitPoseForPoseEstimation","sections":[],"depth":2}],"depth":1}';function Ie(V){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ne extends he{constructor(r){super(),je(this,r,Ie,ge,ye,{})}}export{Ne as component};
