import{s as ca,o as ma,n as A}from"../chunks/scheduler.25b97de1.js";import{S as pa,i as ha,g as m,s as n,r as u,A as ua,h as p,f as o,c as r,j as R,u as f,x as y,k as V,y as c,a as l,v as g,d as b,t as M,w as _}from"../chunks/index.d9030fc9.js";import{T as Rt}from"../chunks/Tip.baa67368.js";import{D as we}from"../chunks/Docstring.e257edda.js";import{C as Te}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Se}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as S,E as fa}from"../chunks/EditOnGithub.91d95064.js";function ga(C){let a,w="Example:",d,i,h;return i=new Te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hbWJhQ29uZmlnJTJDJTIwTWFtYmFNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYW1iYSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTWFtYmFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTWFtYmFNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MambaConfig, MambaModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mamba configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MambaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=m("p"),a.textContent=w,d=n(),u(i.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),y(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(t),f(i.$$.fragment,t)},m(t,T){l(t,a,T),l(t,d,T),g(i,t,T),h=!0},p:A,i(t){h||(b(i.$$.fragment,t),h=!0)},o(t){M(i.$$.fragment,t),h=!1},d(t){t&&(o(a),o(d)),_(i,t)}}}function ba(C){let a,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=m("p"),a.innerHTML=w},l(d){a=p(d,"P",{"data-svelte-h":!0}),y(a)!=="svelte-fincs2"&&(a.innerHTML=w)},m(d,i){l(d,a,i)},p:A,d(d){d&&o(a)}}}function Ma(C){let a,w="Example:",d,i,h;return i=new Te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYU1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwTWFtYmFNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaModel.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){a=m("p"),a.textContent=w,d=n(),u(i.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),y(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(t),f(i.$$.fragment,t)},m(t,T){l(t,a,T),l(t,d,T),g(i,t,T),h=!0},p:A,i(t){h||(b(i.$$.fragment,t),h=!0)},o(t){M(i.$$.fragment,t),h=!1},d(t){t&&(o(a),o(d)),_(i,t)}}}function _a(C){let a,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=m("p"),a.innerHTML=w},l(d){a=p(d,"P",{"data-svelte-h":!0}),y(a)!=="svelte-fincs2"&&(a.innerHTML=w)},m(d,i){l(d,a,i)},p:A,d(d){d&&o(a)}}}function ya(C){let a,w="Example:",d,i,h;return i=new Te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1hbWJhRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwTWFtYmFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForCausalLM.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){a=m("p"),a.textContent=w,d=n(),u(i.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),y(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(t),f(i.$$.fragment,t)},m(t,T){l(t,a,T),l(t,d,T),g(i,t,T),h=!0},p:A,i(t){h||(b(i.$$.fragment,t),h=!0)},o(t){M(i.$$.fragment,t),h=!1},d(t){t&&(o(a),o(d)),_(i,t)}}}function wa(C){let a,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=m("p"),a.innerHTML=w},l(d){a=p(d,"P",{"data-svelte-h":!0}),y(a)!=="svelte-fincs2"&&(a.innerHTML=w)},m(d,i){l(d,a,i)},p:A,d(d){d&&o(a)}}}function Ta(C){let a,w="Example of single-label classification:",d,i,h;return i=new Te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1hbWJhRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YXRlLXNwYWNlcyUyRm1hbWJhLTEzMG0taGYlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYW1iYUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN0YXRlLXNwYWNlcyUyRm1hbWJhLTEzMG0taGYlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyME1hbWJhRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){a=m("p"),a.textContent=w,d=n(),u(i.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),y(a)!=="svelte-ykxpe4"&&(a.textContent=w),d=r(t),f(i.$$.fragment,t)},m(t,T){l(t,a,T),l(t,d,T),g(i,t,T),h=!0},p:A,i(t){h||(b(i.$$.fragment,t),h=!0)},o(t){M(i.$$.fragment,t),h=!1},d(t){t&&(o(a),o(d)),_(i,t)}}}function va(C){let a,w="Example of multi-label classification:",d,i,h;return i=new Te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1hbWJhRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YXRlLXNwYWNlcyUyRm1hbWJhLTEzMG0taGYlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYW1iYUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN0YXRlLXNwYWNlcyUyRm1hbWJhLTEzMG0taGYlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyME1hbWJhRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){a=m("p"),a.textContent=w,d=n(),u(i.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),y(a)!=="svelte-1l8e32d"&&(a.textContent=w),d=r(t),f(i.$$.fragment,t)},m(t,T){l(t,a,T),l(t,d,T),g(i,t,T),h=!0},p:A,i(t){h||(b(i.$$.fragment,t),h=!0)},o(t){M(i.$$.fragment,t),h=!1},d(t){t&&(o(a),o(d)),_(i,t)}}}function Ca(C){let a,w,d,i,h,t,T,Ne,P,Vt='The Mamba model was proposed in <a href="https://arxiv.org/abs/2312.00752" rel="nofollow">Mamba: Linear-Time Sequence Modeling with Selective State Spaces</a> by Albert Gu and Tri Dao.',Ee,D,St='This model is a new paradigm architecture based on <code>state-space-models</code>. You can read more about the intuition behind these <a href="https://srush.github.io/annotated-s4/" rel="nofollow">here</a>.',Xe,K,Nt="The abstract from the paper is the following:",Be,O,Et="<em>Foundation models, now powering most of the exciting applications in deep learning, are almost universally based on the Transformer architecture and its core attention module. Many subquadratic-time architectures such as linear attention, gated convolution and recurrent models, and structured state space models (SSMs) have been developed to address Transformers’ computational inefficiency on long sequences, but they have not performed as well as attention on important modalities such as language. We identify that a key weakness of such models is their inability to perform content-based reasoning, and make several improvements. First, simply letting the SSM parameters be functions of the input addresses their weakness with discrete modalities, allowing the model to selectively propagate or forget information along the sequence length dimension depending on the current token. Second, even though this change prevents the use of efficient convolutions, we design a hardware-aware parallel algorithm in recurrent mode. We integrate these selective SSMs into a simplified end-to-end neural network architecture without attention or even MLP blocks (Mamba). Mamba enjoys fast inference (5× higher throughput than Transformers) and linear scaling in sequence length, and its performance improves on real data up to million-length sequences. As a general sequence model backbone, Mamba achieves state-of-the-art performance across several modalities such as language, audio, and genomics. On language modeling, our Mamba-3B model outperforms Transformers of the same size and matches Transformers twice its size, both in pretraining and downstream evaluation.</em>",He,ee,Xt="Tips:",Ye,te,Bt='<li>Mamba is a new <code>state space model</code> architecture that rivals the classic Transformers. It is based on the line of progress on structured state space models, with an efficient hardware-aware design and implementation in the spirit of <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a>.</li> <li>Mamba stacks <code>mixer</code> layers, which are the equivalent of <code>Attention</code> layers. The core logic of <code>mamba</code> is held in the <code>MambaMixer</code> class.</li> <li>Two implementations cohabit: one is optimized and uses fast cuda kernels, while the other one is naive but can run on any device!</li> <li>The current implementation leverages the original cuda kernels: the equivalent of flash attention for Mamba are hosted in the <a href="https://github.com/state-spaces/mamba" rel="nofollow"><code>mamba-ssm</code></a> and the <a href="https://github.com/Dao-AILab/causal-conv1d" rel="nofollow"><code>causal_conv1d</code></a> repositories. Make sure to install them if your hardware supports them!</li> <li>Contributions to make the naive path faster are welcome 🤗</li>',Le,ae,Ht=`This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZ</a>.
The original code can be found <a href="https://github.com/state-spaces/mamba" rel="nofollow">here</a>.`,Qe,se,Ae,oe,Pe,ne,De,re,Ke,le,Yt="The slow version is not very stable for training, and the fast one needs <code>float32</code>!",Oe,ie,et,de,tt,k,ce,mt,ve,Lt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaModel">MambaModel</a>. It is used to instantiate a MAMBA
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the MAMBA
<a href="https://huggingface.co/state-spaces/mamba-2.8b" rel="nofollow">state-spaces/mamba-2.8b</a> architecture.`,pt,Ce,Qt=`Configuration objects inherit from <a href="/docs/transformers/pr_31155/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31155/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ht,N,at,me,st,J,pe,ut,Ue,At="The bare MAMBA Model transformer outputting raw hidden-states without any specific head on top.",ft,Je,Pt=`This model inherits from <a href="/docs/transformers/pr_31155/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gt,$e,Dt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bt,W,he,Mt,je,Kt='The <a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaModel">MambaModel</a> forward method, overrides the <code>__call__</code> special method.',_t,E,yt,X,ot,ue,nt,$,fe,wt,ke,Ot=`The MAMBA Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Tt,xe,ea=`This model inherits from <a href="/docs/transformers/pr_31155/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vt,ze,ta=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ct,I,ge,Ut,Fe,aa='The <a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaForCausalLM">MambaForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Jt,B,$t,H,rt,be,lt,v,Me,jt,We,sa=`Mamba Model backbone with a sequence classification/regression head on top
(a linear layer on top of the pooled output) e.g. for GLUE tasks.`,kt,Ie,oa=`<a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaForSequenceClassification">MambaForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,xt,Ge,na=`Since it does classification on the last token, it requires to know the position of the last token.
If a <code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row.
If no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,zt,Ze,ra=`This model inherits from <a href="/docs/transformers/pr_31155/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ft,qe,la=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wt,j,_e,It,Re,ia='The <a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaForSequenceClassification">MambaForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Gt,Y,Zt,L,qt,Q,it,ye,dt,Ve,ct;return h=new S({props:{title:"Mamba",local:"mamba",headingTag:"h1"}}),T=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),se=new S({props:{title:"Usage",local:"usage",headingTag:"h1"}}),oe=new S({props:{title:"A simple generation example:",local:"a-simple-generation-example",headingTag:"h3"}}),ne=new Te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hbWJhQ29uZmlnJTJDJTIwTWFtYmFGb3JDYXVzYWxMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YXRlLXNwYWNlcyUyRm1hbWJhLTEzMG0taGYlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYW1iYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJIZXklMjBob3clMjBhcmUlMjB5b3UlMjBkb2luZyUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIwJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MambaConfig, MambaForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
model = MambaForCausalLM.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
input_ids = tokenizer(<span class="hljs-string">&quot;Hey how are you doing?&quot;</span>, return_tensors= <span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

out = model.generate(input_ids, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(out))`,wrap:!1}}),re=new S({props:{title:"Peft finetuning",local:"peft-finetuning",headingTag:"h3"}}),ie=new Te({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YXRlLXNwYWNlcyUyRm1hbWJhLTEzMG0taGYlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMkFiaXJhdGUlMkZlbmdsaXNoX3F1b3RlcyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGcmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfZGlyJTNEJy4lMkZsb2dzJyUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QyZS0zJTBBKSUwQWxvcmFfY29uZmlnJTIwJTNEJTIwJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByJTNEOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIyeF9wcm9qJTIyJTJDJTIwJTIyZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmluX3Byb2olMjIlMkMlMjAlMjJvdXRfcHJvaiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTBBKSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEbG9yYV9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnF1b3RlJTIyJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, TrainingArguments
model_id = <span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id)
dataset = load_dataset(<span class="hljs-string">&quot;Abirate/english_quotes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    logging_dir=<span class="hljs-string">&#x27;./logs&#x27;</span>,
    logging_steps=<span class="hljs-number">10</span>,
    learning_rate=<span class="hljs-number">2e-3</span>
)
lora_config =  LoraConfig(
        r=<span class="hljs-number">8</span>,
        target_modules=[<span class="hljs-string">&quot;x_proj&quot;</span>, <span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;in_proj&quot;</span>, <span class="hljs-string">&quot;out_proj&quot;</span>],
        task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
        bias=<span class="hljs-string">&quot;none&quot;</span>
)
trainer = SFTTrainer(
    model=model,
    tokenizer=tokenizer,
    args=training_args,
    peft_config=lora_config,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;quote&quot;</span>,
)
trainer.train()`,wrap:!1}}),de=new S({props:{title:"MambaConfig",local:"transformers.MambaConfig",headingTag:"h2"}}),ce=new we({props:{name:"class transformers.MambaConfig",anchor:"transformers.MambaConfig",parameters:[{name:"vocab_size",val:" = 50280"},{name:"hidden_size",val:" = 768"},{name:"state_size",val:" = 16"},{name:"num_hidden_layers",val:" = 32"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 0"},{name:"expand",val:" = 2"},{name:"conv_kernel",val:" = 4"},{name:"use_bias",val:" = False"},{name:"use_conv_bias",val:" = True"},{name:"hidden_act",val:" = 'silu'"},{name:"initializer_range",val:" = 0.1"},{name:"residual_in_fp32",val:" = True"},{name:"time_step_rank",val:" = 'auto'"},{name:"time_step_scale",val:" = 1.0"},{name:"time_step_min",val:" = 0.001"},{name:"time_step_max",val:" = 0.1"},{name:"time_step_init_scheme",val:" = 'random'"},{name:"time_step_floor",val:" = 0.0001"},{name:"rescale_prenorm_residual",val:" = False"},{name:"use_cache",val:" = True"},{name:"classifier_dropout",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MambaConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50280) &#x2014;
Vocabulary size of the MAMBA model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaModel">MambaModel</a>.`,name:"vocab_size"},{anchor:"transformers.MambaConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"hidden_size"},{anchor:"transformers.MambaConfig.state_size",description:"<strong>state_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014; shape of the state space latents.",name:"state_size"},{anchor:"transformers.MambaConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the model.`,name:"num_hidden_layers"},{anchor:"transformers.MambaConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon to use in the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.MambaConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.MambaConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the beginning of sentence token in the vocabulary.`,name:"bos_token_id"},{anchor:"transformers.MambaConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the end of sentence token in the vocabulary.`,name:"eos_token_id"},{anchor:"transformers.MambaConfig.expand",description:"<strong>expand</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014; Expanding factor used to determine the intermediate size.",name:"expand"},{anchor:"transformers.MambaConfig.conv_kernel",description:"<strong>conv_kernel</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Size of the convolution kernel.",name:"conv_kernel"},{anchor:"transformers.MambaConfig.use_bias",description:`<strong>use_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use bias in [&#x201C;in_proj&#x201D;, &#x201C;out_proj&#x201D;] of the mixer block`,name:"use_bias"},{anchor:"transformers.MambaConfig.use_conv_bias",description:`<strong>use_conv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use bias in the convolution layer of the mixer block.`,name:"use_conv_bias"},{anchor:"transformers.MambaConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.MambaConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MambaConfig.residual_in_fp32",description:`<strong>residual_in_fp32</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not residuals should be in <code>float32</code>. If set to <code>False</code> residuals will keep the same <code>dtype</code> as the rest of the model`,name:"residual_in_fp32"},{anchor:"transformers.MambaConfig.time_step_rank",description:`<strong>time_step_rank</strong> (<code>Union[int,str]</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
Rank of the discretization projection matrix. <code>&quot;auto&quot;</code> means that it will default to <code>math.ceil(self.hidden_size / 16)</code>`,name:"time_step_rank"},{anchor:"transformers.MambaConfig.time_step_scale",description:`<strong>time_step_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Scale used used to scale <code>dt_proj.bias</code>.`,name:"time_step_scale"},{anchor:"transformers.MambaConfig.time_step_min",description:`<strong>time_step_min</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
Minimum <code>time_step</code> used to bound <code>dt_proj.bias</code>.`,name:"time_step_min"},{anchor:"transformers.MambaConfig.time_step_max",description:`<strong>time_step_max</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Maximum <code>time_step</code> used to bound <code>dt_proj.bias</code>.`,name:"time_step_max"},{anchor:"transformers.MambaConfig.time_step_init_scheme",description:`<strong>time_step_init_scheme</strong> (<code>float</code>, <em>optional</em>, defaults to <code>&quot;random&quot;</code>) &#x2014;
Init scheme used for <code>dt_proj.weight</code>. Should be one of <code>[&quot;random&quot;,&quot;uniform&quot;]</code>`,name:"time_step_init_scheme"},{anchor:"transformers.MambaConfig.time_step_floor",description:`<strong>time_step_floor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0001) &#x2014;
Minimum clamping value of the <code>dt_proj.bias</code> layer initialization.`,name:"time_step_floor"},{anchor:"transformers.MambaConfig.rescale_prenorm_residual",description:`<strong>rescale_prenorm_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to rescale <code>out_proj</code> weights when initializing.`,name:"rescale_prenorm_residual"},{anchor:"transformers.MambaConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the cache should be used.`,name:"use_cache"},{anchor:"transformers.MambaConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the classification head in <a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaForSequenceClassification">MambaForSequenceClassification</a> model.`,name:"classifier_dropout"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/models/mamba/configuration_mamba.py#L26"}}),N=new Se({props:{anchor:"transformers.MambaConfig.example",$$slots:{default:[ga]},$$scope:{ctx:C}}}),me=new S({props:{title:"MambaModel",local:"transformers.MambaModel",headingTag:"h2"}}),pe=new we({props:{name:"class transformers.MambaModel",anchor:"transformers.MambaModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MambaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaConfig">MambaConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31155/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/models/mamba/modeling_mamba.py#L531"}}),he=new we({props:{name:"forward",anchor:"transformers.MambaModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"cache_params",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MambaModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>cache_params.seqlen_offset&gt;0</code>, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MambaModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MambaModel.forward.cache_params",description:`<strong>cache_params</strong> (<code>MambaCache</code>, <em>optional</em>) &#x2014;
If passed along, the model uses the previous state in all the blocks (which will give the output for the
<code>input_ids</code> provided as if the model add <code>state_input_ids + input_ids</code> as context).`,name:"cache_params"},{anchor:"transformers.MambaModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the <code>cache_params</code> is returned and can be used to quickly generate the next logits.`,name:"use_cache"},{anchor:"transformers.MambaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MambaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31155/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/models/mamba/modeling_mamba.py#L560",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.mamba.modeling_mamba.MambaOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaConfig"
>MambaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>cache_params</strong> (<code>MambaCache</code>) — The state of the model at the last time step. Can be used in a forward method with the next <code>input_ids</code> to
avoid providing the old <code>input_ids</code>.</p>
<p>Includes both the State space model state matrices after the selective scan, and the Convolutional states</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.mamba.modeling_mamba.MambaOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Rt({props:{$$slots:{default:[ba]},$$scope:{ctx:C}}}),X=new Se({props:{anchor:"transformers.MambaModel.forward.example",$$slots:{default:[Ma]},$$scope:{ctx:C}}}),ue=new S({props:{title:"MambaLMHeadModel",local:"transformers.MambaForCausalLM",headingTag:"h2"}}),fe=new we({props:{name:"class transformers.MambaForCausalLM",anchor:"transformers.MambaForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MambaForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaConfig">MambaConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31155/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/models/mamba/modeling_mamba.py#L627"}}),ge=new we({props:{name:"forward",anchor:"transformers.MambaForCausalLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"cache_params",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MambaForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>cache_params.seqlen_offset&gt;0</code>, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MambaForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MambaForCausalLM.forward.cache_params",description:`<strong>cache_params</strong> (<code>MambaCache</code>, <em>optional</em>) &#x2014;
If passed along, the model uses the previous state in all the blocks (which will give the output for the
<code>input_ids</code> provided as if the model add <code>state_input_ids + input_ids</code> as context).`,name:"cache_params"},{anchor:"transformers.MambaForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the <code>cache_params</code> is returned and can be used to quickly generate the next logits.`,name:"use_cache"},{anchor:"transformers.MambaForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MambaForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31155/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MambaForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/models/mamba/modeling_mamba.py#L687",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.mamba.modeling_mamba.MambaCausalLMOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaConfig"
>MambaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>cache_params</strong> (<code>MambaCache</code>) — The state of the model at the last time step. Can be used in a forward method with the next <code>input_ids</code> to
avoid providing the old <code>input_ids</code>.</p>
<p>Includes both the State space model state matrices after the selective scan, and the Convolutional states</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.mamba.modeling_mamba.MambaCausalLMOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new Rt({props:{$$slots:{default:[_a]},$$scope:{ctx:C}}}),H=new Se({props:{anchor:"transformers.MambaForCausalLM.forward.example",$$slots:{default:[ya]},$$scope:{ctx:C}}}),be=new S({props:{title:"MambaForSequenceClassification",local:"transformers.MambaForSequenceClassification",headingTag:"h2"}}),Me=new we({props:{name:"class transformers.MambaForSequenceClassification",anchor:"transformers.MambaForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MambaForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaConfig">MambaConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31155/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/models/mamba/modeling_mamba.py#L771"}}),_e=new we({props:{name:"forward",anchor:"transformers.MambaForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"cache_params",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"use_cache",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MambaForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>cache_params.seqlen_offset&gt;0</code>, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MambaForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MambaForSequenceClassification.forward.cache_params",description:`<strong>cache_params</strong> (<code>MambaCache</code>, <em>optional</em>) &#x2014;
If passed along, the model uses the previous state in all the blocks (which will give the output for the
<code>input_ids</code> provided as if the model add <code>state_input_ids + input_ids</code> as context).`,name:"cache_params"},{anchor:"transformers.MambaForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the <code>cache_params</code> is returned and can be used to quickly generate the next logits.`,name:"use_cache"},{anchor:"transformers.MambaForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MambaForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31155/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MambaForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss.
Indices should be in <code>[0, ..., config.num_labels - 1]</code>.
If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss),
If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/models/mamba/modeling_mamba.py#L798",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.mamba.modeling_mamba.MambaSequenceClassifierOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaConfig"
>MambaConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.
Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>cache_params</strong> (<code>MambaCache</code>) — The state of the model at the last time step. Can be used in a forward method with the next <code>input_ids</code> to
avoid providing the old <code>input_ids</code>.</li>
</ul>
<p><code>transformers.models.mamba.modeling_mamba.MambaSequenceClassifierOutput</code> or <code>tuple(torch.FloatTensor)</code>: A <code>transformers.models.mamba.modeling_mamba.MambaSequenceClassifierOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31155/en/model_doc/mamba#transformers.MambaConfig"
>MambaConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.
Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>cache_params</strong> (<code>MambaCache</code>) — The state of the model at the last time step. Can be used in a forward method with the next <code>input_ids</code> to
avoid providing the old <code>input_ids</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.mamba.modeling_mamba.MambaSequenceClassifierOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new Rt({props:{$$slots:{default:[wa]},$$scope:{ctx:C}}}),L=new Se({props:{anchor:"transformers.MambaForSequenceClassification.forward.example",$$slots:{default:[Ta]},$$scope:{ctx:C}}}),Q=new Se({props:{anchor:"transformers.MambaForSequenceClassification.forward.example-2",$$slots:{default:[va]},$$scope:{ctx:C}}}),ye=new fa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mamba.md"}}),{c(){a=m("meta"),w=n(),d=m("p"),i=n(),u(h.$$.fragment),t=n(),u(T.$$.fragment),Ne=n(),P=m("p"),P.innerHTML=Vt,Ee=n(),D=m("p"),D.innerHTML=St,Xe=n(),K=m("p"),K.textContent=Nt,Be=n(),O=m("p"),O.innerHTML=Et,He=n(),ee=m("p"),ee.textContent=Xt,Ye=n(),te=m("ul"),te.innerHTML=Bt,Le=n(),ae=m("p"),ae.innerHTML=Ht,Qe=n(),u(se.$$.fragment),Ae=n(),u(oe.$$.fragment),Pe=n(),u(ne.$$.fragment),De=n(),u(re.$$.fragment),Ke=n(),le=m("p"),le.innerHTML=Yt,Oe=n(),u(ie.$$.fragment),et=n(),u(de.$$.fragment),tt=n(),k=m("div"),u(ce.$$.fragment),mt=n(),ve=m("p"),ve.innerHTML=Lt,pt=n(),Ce=m("p"),Ce.innerHTML=Qt,ht=n(),u(N.$$.fragment),at=n(),u(me.$$.fragment),st=n(),J=m("div"),u(pe.$$.fragment),ut=n(),Ue=m("p"),Ue.textContent=At,ft=n(),Je=m("p"),Je.innerHTML=Pt,gt=n(),$e=m("p"),$e.innerHTML=Dt,bt=n(),W=m("div"),u(he.$$.fragment),Mt=n(),je=m("p"),je.innerHTML=Kt,_t=n(),u(E.$$.fragment),yt=n(),u(X.$$.fragment),ot=n(),u(ue.$$.fragment),nt=n(),$=m("div"),u(fe.$$.fragment),wt=n(),ke=m("p"),ke.textContent=Ot,Tt=n(),xe=m("p"),xe.innerHTML=ea,vt=n(),ze=m("p"),ze.innerHTML=ta,Ct=n(),I=m("div"),u(ge.$$.fragment),Ut=n(),Fe=m("p"),Fe.innerHTML=aa,Jt=n(),u(B.$$.fragment),$t=n(),u(H.$$.fragment),rt=n(),u(be.$$.fragment),lt=n(),v=m("div"),u(Me.$$.fragment),jt=n(),We=m("p"),We.textContent=sa,kt=n(),Ie=m("p"),Ie.innerHTML=oa,xt=n(),Ge=m("p"),Ge.innerHTML=na,zt=n(),Ze=m("p"),Ze.innerHTML=ra,Ft=n(),qe=m("p"),qe.innerHTML=la,Wt=n(),j=m("div"),u(_e.$$.fragment),It=n(),Re=m("p"),Re.innerHTML=ia,Gt=n(),u(Y.$$.fragment),Zt=n(),u(L.$$.fragment),qt=n(),u(Q.$$.fragment),it=n(),u(ye.$$.fragment),dt=n(),Ve=m("p"),this.h()},l(e){const s=ua("svelte-u9bgzb",document.head);a=p(s,"META",{name:!0,content:!0}),s.forEach(o),w=r(e),d=p(e,"P",{}),R(d).forEach(o),i=r(e),f(h.$$.fragment,e),t=r(e),f(T.$$.fragment,e),Ne=r(e),P=p(e,"P",{"data-svelte-h":!0}),y(P)!=="svelte-1d6srga"&&(P.innerHTML=Vt),Ee=r(e),D=p(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-1luq6q2"&&(D.innerHTML=St),Xe=r(e),K=p(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-vfdo9a"&&(K.textContent=Nt),Be=r(e),O=p(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-1j9ofgw"&&(O.innerHTML=Et),He=r(e),ee=p(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-axv494"&&(ee.textContent=Xt),Ye=r(e),te=p(e,"UL",{"data-svelte-h":!0}),y(te)!=="svelte-k3qrrt"&&(te.innerHTML=Bt),Le=r(e),ae=p(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-11rhxoo"&&(ae.innerHTML=Ht),Qe=r(e),f(se.$$.fragment,e),Ae=r(e),f(oe.$$.fragment,e),Pe=r(e),f(ne.$$.fragment,e),De=r(e),f(re.$$.fragment,e),Ke=r(e),le=p(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-1b7b7tj"&&(le.innerHTML=Yt),Oe=r(e),f(ie.$$.fragment,e),et=r(e),f(de.$$.fragment,e),tt=r(e),k=p(e,"DIV",{class:!0});var G=R(k);f(ce.$$.fragment,G),mt=r(G),ve=p(G,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-qe74mw"&&(ve.innerHTML=Lt),pt=r(G),Ce=p(G,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-nduri3"&&(Ce.innerHTML=Qt),ht=r(G),f(N.$$.fragment,G),G.forEach(o),at=r(e),f(me.$$.fragment,e),st=r(e),J=p(e,"DIV",{class:!0});var x=R(J);f(pe.$$.fragment,x),ut=r(x),Ue=p(x,"P",{"data-svelte-h":!0}),y(Ue)!=="svelte-1p0vlfb"&&(Ue.textContent=At),ft=r(x),Je=p(x,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-d870a1"&&(Je.innerHTML=Pt),gt=r(x),$e=p(x,"P",{"data-svelte-h":!0}),y($e)!=="svelte-hswkmf"&&($e.innerHTML=Dt),bt=r(x),W=p(x,"DIV",{class:!0});var Z=R(W);f(he.$$.fragment,Z),Mt=r(Z),je=p(Z,"P",{"data-svelte-h":!0}),y(je)!=="svelte-6rjosa"&&(je.innerHTML=Kt),_t=r(Z),f(E.$$.fragment,Z),yt=r(Z),f(X.$$.fragment,Z),Z.forEach(o),x.forEach(o),ot=r(e),f(ue.$$.fragment,e),nt=r(e),$=p(e,"DIV",{class:!0});var z=R($);f(fe.$$.fragment,z),wt=r(z),ke=p(z,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-xhqj3f"&&(ke.textContent=Ot),Tt=r(z),xe=p(z,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-d870a1"&&(xe.innerHTML=ea),vt=r(z),ze=p(z,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-hswkmf"&&(ze.innerHTML=ta),Ct=r(z),I=p(z,"DIV",{class:!0});var q=R(I);f(ge.$$.fragment,q),Ut=r(q),Fe=p(q,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-17mfxpy"&&(Fe.innerHTML=aa),Jt=r(q),f(B.$$.fragment,q),$t=r(q),f(H.$$.fragment,q),q.forEach(o),z.forEach(o),rt=r(e),f(be.$$.fragment,e),lt=r(e),v=p(e,"DIV",{class:!0});var U=R(v);f(Me.$$.fragment,U),jt=r(U),We=p(U,"P",{"data-svelte-h":!0}),y(We)!=="svelte-7cwpxy"&&(We.textContent=sa),kt=r(U),Ie=p(U,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-1nyuwy5"&&(Ie.innerHTML=oa),xt=r(U),Ge=p(U,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-z3wot6"&&(Ge.innerHTML=na),zt=r(U),Ze=p(U,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-d870a1"&&(Ze.innerHTML=ra),Ft=r(U),qe=p(U,"P",{"data-svelte-h":!0}),y(qe)!=="svelte-hswkmf"&&(qe.innerHTML=la),Wt=r(U),j=p(U,"DIV",{class:!0});var F=R(j);f(_e.$$.fragment,F),It=r(F),Re=p(F,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-afrbt0"&&(Re.innerHTML=ia),Gt=r(F),f(Y.$$.fragment,F),Zt=r(F),f(L.$$.fragment,F),qt=r(F),f(Q.$$.fragment,F),F.forEach(o),U.forEach(o),it=r(e),f(ye.$$.fragment,e),dt=r(e),Ve=p(e,"P",{}),R(Ve).forEach(o),this.h()},h(){V(a,"name","hf:doc:metadata"),V(a,"content",Ua),V(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){c(document.head,a),l(e,w,s),l(e,d,s),l(e,i,s),g(h,e,s),l(e,t,s),g(T,e,s),l(e,Ne,s),l(e,P,s),l(e,Ee,s),l(e,D,s),l(e,Xe,s),l(e,K,s),l(e,Be,s),l(e,O,s),l(e,He,s),l(e,ee,s),l(e,Ye,s),l(e,te,s),l(e,Le,s),l(e,ae,s),l(e,Qe,s),g(se,e,s),l(e,Ae,s),g(oe,e,s),l(e,Pe,s),g(ne,e,s),l(e,De,s),g(re,e,s),l(e,Ke,s),l(e,le,s),l(e,Oe,s),g(ie,e,s),l(e,et,s),g(de,e,s),l(e,tt,s),l(e,k,s),g(ce,k,null),c(k,mt),c(k,ve),c(k,pt),c(k,Ce),c(k,ht),g(N,k,null),l(e,at,s),g(me,e,s),l(e,st,s),l(e,J,s),g(pe,J,null),c(J,ut),c(J,Ue),c(J,ft),c(J,Je),c(J,gt),c(J,$e),c(J,bt),c(J,W),g(he,W,null),c(W,Mt),c(W,je),c(W,_t),g(E,W,null),c(W,yt),g(X,W,null),l(e,ot,s),g(ue,e,s),l(e,nt,s),l(e,$,s),g(fe,$,null),c($,wt),c($,ke),c($,Tt),c($,xe),c($,vt),c($,ze),c($,Ct),c($,I),g(ge,I,null),c(I,Ut),c(I,Fe),c(I,Jt),g(B,I,null),c(I,$t),g(H,I,null),l(e,rt,s),g(be,e,s),l(e,lt,s),l(e,v,s),g(Me,v,null),c(v,jt),c(v,We),c(v,kt),c(v,Ie),c(v,xt),c(v,Ge),c(v,zt),c(v,Ze),c(v,Ft),c(v,qe),c(v,Wt),c(v,j),g(_e,j,null),c(j,It),c(j,Re),c(j,Gt),g(Y,j,null),c(j,Zt),g(L,j,null),c(j,qt),g(Q,j,null),l(e,it,s),g(ye,e,s),l(e,dt,s),l(e,Ve,s),ct=!0},p(e,[s]){const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),N.$set(G);const x={};s&2&&(x.$$scope={dirty:s,ctx:e}),E.$set(x);const Z={};s&2&&(Z.$$scope={dirty:s,ctx:e}),X.$set(Z);const z={};s&2&&(z.$$scope={dirty:s,ctx:e}),B.$set(z);const q={};s&2&&(q.$$scope={dirty:s,ctx:e}),H.$set(q);const U={};s&2&&(U.$$scope={dirty:s,ctx:e}),Y.$set(U);const F={};s&2&&(F.$$scope={dirty:s,ctx:e}),L.$set(F);const da={};s&2&&(da.$$scope={dirty:s,ctx:e}),Q.$set(da)},i(e){ct||(b(h.$$.fragment,e),b(T.$$.fragment,e),b(se.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(re.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(N.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(he.$$.fragment,e),b(E.$$.fragment,e),b(X.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(ge.$$.fragment,e),b(B.$$.fragment,e),b(H.$$.fragment,e),b(be.$$.fragment,e),b(Me.$$.fragment,e),b(_e.$$.fragment,e),b(Y.$$.fragment,e),b(L.$$.fragment,e),b(Q.$$.fragment,e),b(ye.$$.fragment,e),ct=!0)},o(e){M(h.$$.fragment,e),M(T.$$.fragment,e),M(se.$$.fragment,e),M(oe.$$.fragment,e),M(ne.$$.fragment,e),M(re.$$.fragment,e),M(ie.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(N.$$.fragment,e),M(me.$$.fragment,e),M(pe.$$.fragment,e),M(he.$$.fragment,e),M(E.$$.fragment,e),M(X.$$.fragment,e),M(ue.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(B.$$.fragment,e),M(H.$$.fragment,e),M(be.$$.fragment,e),M(Me.$$.fragment,e),M(_e.$$.fragment,e),M(Y.$$.fragment,e),M(L.$$.fragment,e),M(Q.$$.fragment,e),M(ye.$$.fragment,e),ct=!1},d(e){e&&(o(w),o(d),o(i),o(t),o(Ne),o(P),o(Ee),o(D),o(Xe),o(K),o(Be),o(O),o(He),o(ee),o(Ye),o(te),o(Le),o(ae),o(Qe),o(Ae),o(Pe),o(De),o(Ke),o(le),o(Oe),o(et),o(tt),o(k),o(at),o(st),o(J),o(ot),o(nt),o($),o(rt),o(lt),o(v),o(it),o(dt),o(Ve)),o(a),_(h,e),_(T,e),_(se,e),_(oe,e),_(ne,e),_(re,e),_(ie,e),_(de,e),_(ce),_(N),_(me,e),_(pe),_(he),_(E),_(X),_(ue,e),_(fe),_(ge),_(B),_(H),_(be,e),_(Me),_(_e),_(Y),_(L),_(Q),_(ye,e)}}}const Ua='{"title":"Mamba","local":"mamba","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2}],"depth":1}';function Ja(C){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ia extends pa{constructor(a){super(),ha(this,a,Ja,Ca,ca,{})}}export{Ia as component};
