import{s as wt,f as _t,o as jt,n as et}from"../chunks/scheduler.25b97de1.js";import{S as Tt,i as Jt,g as i,s as a,r as d,A as vt,h as p,f as n,c as o,j as ge,u as g,x as M,k as C,y as m,a as s,v as u,d as f,t as y,w as b}from"../chunks/index.d9030fc9.js";import{T as $t}from"../chunks/Tip.baa67368.js";import{D as Fe}from"../chunks/Docstring.e257edda.js";import{C as Ve}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Mt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as D,E as Ut}from"../chunks/EditOnGithub.91d95064.js";function Ct(k){let r,T="Example:",c,h,w;return h=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoQW55dGhpbmdDb25maWclMkMlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERlcHRoQW55dGhpbmclMjBzbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEZXB0aEFueXRoaW5nQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwRGVwdGhBbnl0aGluZyUyMHNtYWxsJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthAnythingConfig, DepthAnythingForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthAnythingConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthAnythingForDepthEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=i("p"),r.textContent=T,c=a(),d(h.$$.fragment)},l(l){r=p(l,"P",{"data-svelte-h":!0}),M(r)!=="svelte-11lpom8"&&(r.textContent=T),c=o(l),g(h.$$.fragment,l)},m(l,_){s(l,r,_),s(l,c,_),u(h,l,_),w=!0},p:et,i(l){w||(f(h.$$.fragment,l),w=!0)},o(l){y(h.$$.fragment,l),w=!1},d(l){l&&(n(r),n(c)),b(h,l)}}}function kt(k){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=T},l(c){r=p(c,"P",{"data-svelte-h":!0}),M(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(c,h){s(c,r,h)},p:et,d(c){c&&n(r)}}}function Wt(k){let r,T="Examples:",c,h,w;return h=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0ZWRfZGVwdGglMEElMEElMjMlMjBpbnRlcnBvbGF0ZSUyMHRvJTIwb3JpZ2luYWwlMjBzaXplJTBBcHJlZGljdGlvbiUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZSgxKSUyQyUwQSUyMCUyMCUyMCUyMHNpemUlM0RpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIyYmljdWJpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBb3V0cHV0JTIwJTNEJTIwcHJlZGljdGlvbi5zcXVlZXplKCkuY3B1KCkubnVtcHkoKSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`,wrap:!1}}),{c(){r=i("p"),r.textContent=T,c=a(),d(h.$$.fragment)},l(l){r=p(l,"P",{"data-svelte-h":!0}),M(r)!=="svelte-kvfsh7"&&(r.textContent=T),c=o(l),g(h.$$.fragment,l)},m(l,_){s(l,r,_),s(l,c,_),u(h,l,_),w=!0},p:et,i(l){w||(f(h.$$.fragment,l),w=!0)},o(l){y(h.$$.fragment,l),w=!1},d(l){l&&(n(r),n(c)),b(h,l)}}}function Bt(k){let r,T,c,h,w,l,_,fe,I,tt='Depth Anything V2 was introduced in <a href="https://arxiv.org/abs/2406.09414" rel="nofollow">the paper of the same name</a> by Lihe Yang et al. It uses the same architecture as the original <a href="depth_anything">Depth Anything model</a>, but uses synthetic data and a larger capacity teacher model to achieve much finer and robust depth predictions.',ye,x,nt="The abstract from the paper is the following:",be,R,st="<em>This work presents Depth Anything V2. Without pursuing fancy techniques, we aim to reveal crucial findings to pave the way towards building a powerful monocular depth estimation model. Notably, compared with V1, this version produces much finer and more robust depth predictions through three key practices: 1) replacing all labeled real images with synthetic images, 2) scaling up the capacity of our teacher model, and 3) teaching student models via the bridge of large-scale pseudo-labeled real images. Compared with the latest models built on Stable Diffusion, our models are significantly more efficient (more than 10x faster) and more accurate. We offer models of different scales (ranging from 25M to 1.3B params) to support extensive scenarios. Benefiting from their strong generalization capability, we fine-tune them with metric depth labels to obtain our metric depth models. In addition to our models, considering the limited diversity and frequent noise in current test sets, we construct a versatile evaluation benchmark with precise annotations and diverse scenes to facilitate future research.</em>",Me,W,at,we,z,ot='Depth Anything overview. Taken from the <a href="https://arxiv.org/abs/2401.10891">original paper</a>.',_e,F,lt=`The Depth Anything models were contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/DepthAnything/Depth-Anything-V2" rel="nofollow">here</a>.`,je,V,Te,H,rt="There are 2 main ways to use Depth Anything V2: either using the pipeline API, which abstracts away all the complexity for you, or by using the <code>DepthAnythingForDepthEstimation</code> class yourself.",Je,X,ve,L,it="The pipeline allows to use the model in a few lines of code:",$e,N,Ue,Y,Ce,S,pt="If you want to do the pre- and post-processing yourself, here’s how to do that:",ke,P,We,Q,Be,q,ht="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Depth Anything.",Ze,K,ct='<li><a href="../tasks/depth_estimation">Monocular depth estimation task guide</a></li> <li><a href="https://huggingface.co/spaces/depth-anything/Depth-Anything-V2" rel="nofollow">Depth Anything V2 demo</a>.</li> <li>A notebook showcasing inference with <a href="/docs/transformers/pr_30984/en/model_doc/depth_anything_v2#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Depth%20Anything/Predicting_depth_in_an_image_with_Depth_Anything.ipynb" rel="nofollow">here</a>. 🌎</li> <li><a href="https://huggingface.co/apple/coreml-depth-anything-v2-small" rel="nofollow">Core ML conversion of the <code>small</code> variant for use on Apple Silicon</a>.</li>',Ae,O,mt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ee,ee,Ge,j,te,He,ie,dt=`This is the configuration class to store the configuration of a <code>DepthAnythingModel</code>. It is used to instantiate an DepthAnything
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DepthAnything
<a href="https://huggingface.co/LiheYoung/depth-anything-small-hf" rel="nofollow">LiheYoung/depth-anything-small-hf</a> architecture.`,Xe,pe,gt=`Configuration objects inherit from <a href="/docs/transformers/pr_30984/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30984/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Le,B,Ne,Z,ne,Ye,he,ut=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/pr_30984/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,De,se,Ie,J,ae,Se,ce,ft="Depth Anything Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",Pe,me,yt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Qe,$,oe,qe,de,bt='The <a href="/docs/transformers/pr_30984/en/model_doc/depth_anything_v2#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',Ke,A,Oe,E,xe,le,Re,ue,ze;return w=new D({props:{title:"Depth Anything V2",local:"depth-anything-v2",headingTag:"h1"}}),_=new D({props:{title:"Overview",local:"overview",headingTag:"h2"}}),V=new D({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),X=new D({props:{title:"Pipeline API",local:"pipeline-api",headingTag:"h3"}}),N=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBsb2FkJTIwcGlwZSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZGVwdGgtYW55dGhpbmclMkZEZXB0aC1Bbnl0aGluZy1WMi1TbWFsbC1oZiUyMiklMEElMEElMjMlMjBsb2FkJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAnaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UpJTVCJTIyZGVwdGglMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load pipe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = pipe(image)[<span class="hljs-string">&quot;depth&quot;</span>]`,wrap:!1}}),Y=new D({props:{title:"Using the model yourself",local:"using-the-model-yourself",headingTag:"h3"}}),P=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZXB0aC1hbnl0aGluZyUyRkRlcHRoLUFueXRoaW5nLVYyLVNtYWxsLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZXB0aC1hbnl0aGluZyUyRkRlcHRoLUFueXRoaW5nLVYyLVNtYWxsLWhmJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aCUyMCUzRCUyMG91dHB1dHMucHJlZGljdGVkX2RlcHRoJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXByZWRpY3Rpb24lMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmludGVycG9sYXRlKCUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aC51bnNxdWVlemUoMSklMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpY3ViaWMlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGlnbl9jb3JuZXJzJTNERmFsc2UlMkMlMEEpJTBBJTBBJTIzJTIwdmlzdWFsaXplJTIwdGhlJTIwcHJlZGljdGlvbiUwQW91dHB1dCUyMCUzRCUyMHByZWRpY3Rpb24uc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEFmb3JtYXR0ZWQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NSUyMCUyRiUyMG5wLm1heChvdXRwdXQpKS5hc3R5cGUoJTIydWludDglMjIpJTBBZGVwdGglMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoZm9ybWF0dGVkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`,wrap:!1}}),Q=new D({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ee=new D({props:{title:"DepthAnythingConfig",local:"transformers.DepthAnythingConfig",headingTag:"h2"}}),te=new Fe({props:{name:"class transformers.DepthAnythingConfig",anchor:"transformers.DepthAnythingConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"patch_size",val:" = 14"},{name:"initializer_range",val:" = 0.02"},{name:"reassemble_hidden_size",val:" = 384"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [48, 96, 192, 384]"},{name:"fusion_hidden_size",val:" = 64"},{name:"head_in_index",val:" = -1"},{name:"head_hidden_size",val:" = 32"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>is_hybrid</code> is <code>True</code> or in case you want to
leverage the <a href="/docs/transformers/pr_30984/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a> API.`,name:"backbone_config"},{anchor:"transformers.DepthAnythingConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DepthAnythingConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DepthAnythingConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/pr_30984/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DepthAnythingConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DepthAnythingConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The size of the patches to extract from the backbone features.`,name:"patch_size"},{anchor:"transformers.DepthAnythingConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthAnythingConfig.reassemble_hidden_size",description:`<strong>reassemble_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the reassemble layers.`,name:"reassemble_hidden_size"},{anchor:"transformers.DepthAnythingConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DepthAnythingConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[48, 96, 192, 384]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DepthAnythingConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthAnythingConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the depth estimation head.`,name:"head_in_index"},{anchor:"transformers.DepthAnythingConfig.head_hidden_size",description:`<strong>head_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of output channels in the second convolution of the depth estimation head.`,name:"head_hidden_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/depth_anything/configuration_depth_anything.py#L28"}}),B=new Mt({props:{anchor:"transformers.DepthAnythingConfig.example",$$slots:{default:[Ct]},$$scope:{ctx:k}}}),ne=new Fe({props:{name:"to_dict",anchor:"transformers.DepthAnythingConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/depth_anything/configuration_depth_anything.py#L143"}}),se=new D({props:{title:"DepthAnythingForDepthEstimation",local:"transformers.DepthAnythingForDepthEstimation",headingTag:"h2"}}),ae=new Fe({props:{name:"class transformers.DepthAnythingForDepthEstimation",anchor:"transformers.DepthAnythingForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30984/en/model_doc/depth_anything_v2#transformers.DepthAnythingConfig">DepthAnythingConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30984/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/depth_anything/modeling_depth_anything.py#L356"}}),oe=new Fe({props:{name:"forward",anchor:"transformers.DepthAnythingForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30984/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30984/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30984/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/depth_anything/modeling_depth_anything.py#L375",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30984/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30984/en/model_doc/depth_anything_v2#transformers.DepthAnythingConfig"
>DepthAnythingConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30984/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new $t({props:{$$slots:{default:[kt]},$$scope:{ctx:k}}}),E=new Mt({props:{anchor:"transformers.DepthAnythingForDepthEstimation.forward.example",$$slots:{default:[Wt]},$$scope:{ctx:k}}}),le=new Ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/depth_anything_v2.md"}}),{c(){r=i("meta"),T=a(),c=i("p"),h=a(),d(w.$$.fragment),l=a(),d(_.$$.fragment),fe=a(),I=i("p"),I.innerHTML=tt,ye=a(),x=i("p"),x.textContent=nt,be=a(),R=i("p"),R.innerHTML=st,Me=a(),W=i("img"),we=a(),z=i("small"),z.innerHTML=ot,_e=a(),F=i("p"),F.innerHTML=lt,je=a(),d(V.$$.fragment),Te=a(),H=i("p"),H.innerHTML=rt,Je=a(),d(X.$$.fragment),ve=a(),L=i("p"),L.textContent=it,$e=a(),d(N.$$.fragment),Ue=a(),d(Y.$$.fragment),Ce=a(),S=i("p"),S.textContent=pt,ke=a(),d(P.$$.fragment),We=a(),d(Q.$$.fragment),Be=a(),q=i("p"),q.textContent=ht,Ze=a(),K=i("ul"),K.innerHTML=ct,Ae=a(),O=i("p"),O.textContent=mt,Ee=a(),d(ee.$$.fragment),Ge=a(),j=i("div"),d(te.$$.fragment),He=a(),ie=i("p"),ie.innerHTML=dt,Xe=a(),pe=i("p"),pe.innerHTML=gt,Le=a(),d(B.$$.fragment),Ne=a(),Z=i("div"),d(ne.$$.fragment),Ye=a(),he=i("p"),he.innerHTML=ut,De=a(),d(se.$$.fragment),Ie=a(),J=i("div"),d(ae.$$.fragment),Se=a(),ce=i("p"),ce.textContent=ft,Pe=a(),me=i("p"),me.innerHTML=yt,Qe=a(),$=i("div"),d(oe.$$.fragment),qe=a(),de=i("p"),de.innerHTML=bt,Ke=a(),d(A.$$.fragment),Oe=a(),d(E.$$.fragment),xe=a(),d(le.$$.fragment),Re=a(),ue=i("p"),this.h()},l(e){const t=vt("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(n),T=o(e),c=p(e,"P",{}),ge(c).forEach(n),h=o(e),g(w.$$.fragment,e),l=o(e),g(_.$$.fragment,e),fe=o(e),I=p(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-bx62jk"&&(I.innerHTML=tt),ye=o(e),x=p(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-vfdo9a"&&(x.textContent=nt),be=o(e),R=p(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1ybeoq5"&&(R.innerHTML=st),Me=o(e),W=p(e,"IMG",{src:!0,alt:!0,width:!0}),we=o(e),z=p(e,"SMALL",{"data-svelte-h":!0}),M(z)!=="svelte-1ldczql"&&(z.innerHTML=ot),_e=o(e),F=p(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-hg4duy"&&(F.innerHTML=lt),je=o(e),g(V.$$.fragment,e),Te=o(e),H=p(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1ct8de3"&&(H.innerHTML=rt),Je=o(e),g(X.$$.fragment,e),ve=o(e),L=p(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1yjxirq"&&(L.textContent=it),$e=o(e),g(N.$$.fragment,e),Ue=o(e),g(Y.$$.fragment,e),Ce=o(e),S=p(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-12aulqw"&&(S.textContent=pt),ke=o(e),g(P.$$.fragment,e),We=o(e),g(Q.$$.fragment,e),Be=o(e),q=p(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-msamn6"&&(q.textContent=ht),Ze=o(e),K=p(e,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-wkqkbo"&&(K.innerHTML=ct),Ae=o(e),O=p(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1xesile"&&(O.textContent=mt),Ee=o(e),g(ee.$$.fragment,e),Ge=o(e),j=p(e,"DIV",{class:!0});var v=ge(j);g(te.$$.fragment,v),He=o(v),ie=p(v,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-t94a1n"&&(ie.innerHTML=dt),Xe=o(v),pe=p(v,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-iuwjdn"&&(pe.innerHTML=gt),Le=o(v),g(B.$$.fragment,v),Ne=o(v),Z=p(v,"DIV",{class:!0});var re=ge(Z);g(ne.$$.fragment,re),Ye=o(re),he=p(re,"P",{"data-svelte-h":!0}),M(he)!=="svelte-7n3geu"&&(he.innerHTML=ut),re.forEach(n),v.forEach(n),De=o(e),g(se.$$.fragment,e),Ie=o(e),J=p(e,"DIV",{class:!0});var U=ge(J);g(ae.$$.fragment,U),Se=o(U),ce=p(U,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-1lyww6q"&&(ce.textContent=ft),Pe=o(U),me=p(U,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1gjh92c"&&(me.innerHTML=yt),Qe=o(U),$=p(U,"DIV",{class:!0});var G=ge($);g(oe.$$.fragment,G),qe=o(G),de=p(G,"P",{"data-svelte-h":!0}),M(de)!=="svelte-1ndl0d8"&&(de.innerHTML=bt),Ke=o(G),g(A.$$.fragment,G),Oe=o(G),g(E.$$.fragment,G),G.forEach(n),U.forEach(n),xe=o(e),g(le.$$.fragment,e),Re=o(e),ue=p(e,"P",{}),ge(ue).forEach(n),this.h()},h(){C(r,"name","hf:doc:metadata"),C(r,"content",Zt),_t(W.src,at="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_anything_overview.jpg")||C(W,"src",at),C(W,"alt","drawing"),C(W,"width","600"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,r),s(e,T,t),s(e,c,t),s(e,h,t),u(w,e,t),s(e,l,t),u(_,e,t),s(e,fe,t),s(e,I,t),s(e,ye,t),s(e,x,t),s(e,be,t),s(e,R,t),s(e,Me,t),s(e,W,t),s(e,we,t),s(e,z,t),s(e,_e,t),s(e,F,t),s(e,je,t),u(V,e,t),s(e,Te,t),s(e,H,t),s(e,Je,t),u(X,e,t),s(e,ve,t),s(e,L,t),s(e,$e,t),u(N,e,t),s(e,Ue,t),u(Y,e,t),s(e,Ce,t),s(e,S,t),s(e,ke,t),u(P,e,t),s(e,We,t),u(Q,e,t),s(e,Be,t),s(e,q,t),s(e,Ze,t),s(e,K,t),s(e,Ae,t),s(e,O,t),s(e,Ee,t),u(ee,e,t),s(e,Ge,t),s(e,j,t),u(te,j,null),m(j,He),m(j,ie),m(j,Xe),m(j,pe),m(j,Le),u(B,j,null),m(j,Ne),m(j,Z),u(ne,Z,null),m(Z,Ye),m(Z,he),s(e,De,t),u(se,e,t),s(e,Ie,t),s(e,J,t),u(ae,J,null),m(J,Se),m(J,ce),m(J,Pe),m(J,me),m(J,Qe),m(J,$),u(oe,$,null),m($,qe),m($,de),m($,Ke),u(A,$,null),m($,Oe),u(E,$,null),s(e,xe,t),u(le,e,t),s(e,Re,t),s(e,ue,t),ze=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),B.$set(v);const re={};t&2&&(re.$$scope={dirty:t,ctx:e}),A.$set(re);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),E.$set(U)},i(e){ze||(f(w.$$.fragment,e),f(_.$$.fragment,e),f(V.$$.fragment,e),f(X.$$.fragment,e),f(N.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(Q.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(B.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(A.$$.fragment,e),f(E.$$.fragment,e),f(le.$$.fragment,e),ze=!0)},o(e){y(w.$$.fragment,e),y(_.$$.fragment,e),y(V.$$.fragment,e),y(X.$$.fragment,e),y(N.$$.fragment,e),y(Y.$$.fragment,e),y(P.$$.fragment,e),y(Q.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(B.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(A.$$.fragment,e),y(E.$$.fragment,e),y(le.$$.fragment,e),ze=!1},d(e){e&&(n(T),n(c),n(h),n(l),n(fe),n(I),n(ye),n(x),n(be),n(R),n(Me),n(W),n(we),n(z),n(_e),n(F),n(je),n(Te),n(H),n(Je),n(ve),n(L),n($e),n(Ue),n(Ce),n(S),n(ke),n(We),n(Be),n(q),n(Ze),n(K),n(Ae),n(O),n(Ee),n(Ge),n(j),n(De),n(Ie),n(J),n(xe),n(Re),n(ue)),n(r),b(w,e),b(_,e),b(V,e),b(X,e),b(N,e),b(Y,e),b(P,e),b(Q,e),b(ee,e),b(te),b(B),b(ne),b(se,e),b(ae),b(oe),b(A),b(E),b(le,e)}}}const Zt='{"title":"Depth Anything V2","local":"depth-anything-v2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Pipeline API","local":"pipeline-api","sections":[],"depth":3},{"title":"Using the model yourself","local":"using-the-model-yourself","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthAnythingConfig","local":"transformers.DepthAnythingConfig","sections":[],"depth":2},{"title":"DepthAnythingForDepthEstimation","local":"transformers.DepthAnythingForDepthEstimation","sections":[],"depth":2}],"depth":1}';function At(k){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Tt{constructor(r){super(),Jt(this,r,At,Bt,wt,{})}}export{Ft as component};
