import{s as xn,f as Wn,o as _n,n as Ms}from"../chunks/scheduler.25b97de1.js";import{S as kn,i as Rn,g as o,s as n,r as d,A as Hn,h as i,f as l,c as a,j as Cn,u,x as r,k as hs,y as Vn,a as s,v as c,d as m,t as h,w as y}from"../chunks/index.d9030fc9.js";import{T as ys}from"../chunks/Tip.baa67368.js";import{C as f}from"../chunks/CodeBlock.e6cd0d95.js";import{D as Yn}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as b,E as zn}from"../chunks/EditOnGithub.91d95064.js";function Qn(T){let p,w='Read <a href="https://huggingface.co/blog/open-source-llms-as-agents" rel="nofollow">Open-source LLMs as LangChain Agents</a> blog post to learn more about ReAct agents.';return{c(){p=o("p"),p.innerHTML=w},l(M){p=i(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-ddq8hg"&&(p.innerHTML=w)},m(M,g){s(M,p,g)},p:Ms,d(M){M&&l(p)}}}function Nn(T){let p,w="The LLM can generate arbitrary code that will then be executed: do not add any unsafe imports!";return{c(){p=o("p"),p.textContent=w},l(M){p=i(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-sjm8o2"&&(p.textContent=w)},m(M,g){s(M,p,g)},p:Ms,d(M){M&&l(p)}}}function Xn(T){let p,w=`Please make sure to define the <code>&lt;&lt;tool_descriptions&gt;&gt;</code> string somewhere in the <code>template</code> so the agent is aware
of the available tools.`;return{c(){p=o("p"),p.innerHTML=w},l(M){p=i(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-xo5gv6"&&(p.innerHTML=w)},m(M,g){s(M,p,g)},p:Ms,d(M){M&&l(p)}}}function Sn(T){let p,w="Beware when adding tools to an agent that already works well because it can bias selection towards your tool or select another tool other than the one already defined.";return{c(){p=o("p"),p.textContent=w},l(M){p=i(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-fotfby"&&(p.textContent=w)},m(M,g){s(M,p,g)},p:Ms,d(M){M&&l(p)}}}function Ln(T){let p,w,M,g,B,wt,I,bt,$,gt,Z,fs='Large Language Models (LLMs) trained to perform <a href="./tasks/language_modeling.">causal language modeling</a> can tackle a wide range of tasks, but they often struggle with basic tasks like logic, calculation, and search. When prompted in domains in which they do not perform well, they often fail to generate the answer we expect them to.',Tt,C,ws="One approach to overcome this weakness is to create an <em>agent</em>.",Jt,x,bs="An agent is a system that uses an LLM as its engine, and it has access to functions called <em>tools</em>.",Ut,W,gs="These <em>tools</em> are functions for performing a task, and they contain all necessary description for the agent to properly use them.",jt,_,Ts="The agent can be programmed to:",vt,k,Js='<li>devise a series of actions/tools and run them all at once,  like the <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.CodeAgent">CodeAgent</a></li> <li>plan and execute actions/tools one by one and wait for the outcome of each action before launching the next one, like the <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.ReactJsonAgent">ReactJsonAgent</a></li>',Gt,R,Bt,H,It,V,Us="This agent has a planning step, then generates python code to execute all its actions at once. It natively handles different input and output types for its tools, thus it is the recommended choice for multimodal tasks.",$t,Y,Zt,z,js='This is the go-to agent to solve reasoning tasks, since the ReAct framework (<a href="https://huggingface.co/papers/2210.03629" rel="nofollow">Yao et al., 2022</a>) makes it really efficient to think on the basis of its previous observations.',Ct,Q,vs="We implement two versions of ReactJsonAgent:",xt,N,Gs='<li><a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.ReactJsonAgent">ReactJsonAgent</a> generates tool calls as a JSON in its output.</li> <li><a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.ReactCodeAgent">ReactCodeAgent</a> is a new type of ReactJsonAgent that generates its tool calls as blobs of code, which works really well for LLMs that have strong coding performance.</li>',Wt,J,_t,U,Bs='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif"/>',kt,X,Is='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/open-source-llms-as-agents/ReAct.png" alt="Framework of a React Agent"/>',Rt,S,$s="For example, here is how a ReAct Code agent would work its way through the following question.",Ht,L,Vt,A,Yt,F,Zs="To initialize an agent, you need these arguments:",zt,E,Cs="<li>an LLM to power your agent - the agent is not exactly the LLM, it’s more like the agent is a program that uses an LLM as its engine.</li> <li>a system prompt: what the LLM engine will be prompted with to generate its output</li> <li>a toolbox from which the agent pick tools to execute</li> <li>a parser to extract from the LLM output which tools are to call and with which arguments</li>",Qt,q,xs="Upon initialization of the agent system, the tool attributes are used to generate a tool description, then baked into the agent’s <code>system_prompt</code> to let it know which tools it can use and why.",Nt,P,Ws="To start with, please install the <code>agents</code> extras in order to install all default dependencies.",Xt,D,St,K,_s='Build your LLM engine by defining a <code>llm_engine</code> method which accepts a list of <a href="./chat_templating.">messages</a> and returns text. This callable also needs to accept a <code>stop</code> argument that indicates when to stop generating.',Lt,O,At,ee,ks="You could use any <code>llm_engine</code> method as long as:",Ft,te,Rs='<li>it follows the <a href="./chat_templating.md">messages format</a> (<code>List[Dict[str, str]]</code>) for its input <code>messages</code>, and it returns a <code>str</code>.</li> <li>it stops generating outputs at the sequences passed in the argument <code>stop_sequences</code></li>',Et,le,Hs='Additionally, <code>llm_engine</code> can also take a <code>grammar</code> argument. In the case where you specify a <code>grammar</code> upon agent initialization, this argument will be passed to the calls to llm_engine, with the <code>grammar</code> that you defined upon initialization, to allow <a href="https://huggingface.co/docs/text-generation-inference/conceptual/guidance" rel="nofollow">constrained generation</a> in order to force properly-formatted agent outputs.',qt,se,Vs="You will also need a <code>tools</code> argument which accepts a list of <code>Tools</code> - it can be an empty list. You can also add the default toolbox on top of your <code>tools</code> list by defining the optional argument <code>add_base_tools=True</code>.",Pt,ne,Ys=`Now you can create an agent, like <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.CodeAgent">CodeAgent</a>, and run it. You can also create a <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.TransformersEngine">TransformersEngine</a> with a pre-initialized pipeline to run inference on your local machine using <code>transformers</code>.
For convenience, since agentic behaviours generally require stronger models such as <code>Llama-3.1-70B-Instruct</code> that are harder to run locally for now, we also provide the <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.HfApiEngine">HfApiEngine</a> class that initializes a <code>huggingface_hub.InferenceClient</code> under the hood.`,Dt,ae,Kt,oe,zs=`This will be handy in case of emergency baguette need!
You can even leave the argument <code>llm_engine</code> undefined, and an <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.HfApiEngine">HfApiEngine</a> will be created by default.`,Ot,ie,el,re,Qs="Note that we used an additional <code>sentence</code> argument: you can pass text as additional arguments to the model.",tl,pe,Ns="You can also use this to indicate the path to local or remote files for the model to use:",ll,de,sl,ue,Xs="The prompt and output parser were automatically defined, but you can easily inspect them by calling the <code>system_prompt_template</code> on your agent.",nl,ce,al,me,Ss=`It’s important to explain as clearly as possible the task you want to perform.
Every <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.Agent.run">run()</a> operation is independent, and since an agent is powered by an LLM, minor variations in your prompt might yield completely different results.
You can also run an agent consecutively for different tasks: each time the attributes <code>agent.task</code> and <code>agent.logs</code> will be re-initialized.`,ol,he,il,ye,Ls=`A Python interpreter executes the code on a set of inputs passed along with your tools.
This should be safe because the only functions that can be called are the tools you provided (especially if it’s only tools by Hugging Face) and the print function, so you’re already limited in what can be executed.`,rl,Me,As=`The Python interpreter also doesn’t allow imports by default outside of a safe list, so all the most obvious attacks shouldn’t be an issue.
You can still authorize additional imports by passing the authorized modules as a list of strings in argument <code>additional_authorized_imports</code> upon initialization of your <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.ReactCodeAgent">ReactCodeAgent</a> or <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.CodeAgent">CodeAgent</a>:`,pl,fe,dl,we,Fs="The execution will stop at any code trying to perform an illegal operation or if there is a regular Python error with the code generated by the agent.",ul,j,cl,be,ml,ge,Es='An agent, or rather the LLM that drives the agent, generates an output based on the system prompt. The system prompt can be customized and tailored to the intended task. For example, check the system prompt for the <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.ReactCodeAgent">ReactCodeAgent</a> (below version is slightly simplified).',hl,Te,yl,Je,qs="The system prompt includes:",Ml,Ue,Ps="<li>An <em>introduction</em> that explains how the agent should behave and what tools are.</li> <li>A description of all the tools that is defined by a <code>&lt;&lt;tool_descriptions&gt;&gt;</code> token that is dynamically replaced at runtime with the tools defined/chosen by the user.<ul><li>The tool description comes from the tool attributes, <code>name</code>, <code>description</code>, <code>inputs</code> and <code>output_type</code>,  and a simple <code>jinja2</code> template that you can refine.</li></ul></li> <li>The expected output format.</li>",fl,je,Ds="You could improve the system prompt, for example, by adding an explanation of the output format.",wl,ve,Ks="For maximum flexibility, you can overwrite the whole system prompt template by passing your custom prompt as an argument to the <code>system_prompt</code> parameter.",bl,Ge,gl,v,Tl,Be,Jl,Ie,Os="Here are a few useful attributes to inspect what happened after a run:",Ul,$e,en="<li><code>agent.logs</code> stores the fine-grained logs of the agent. At every step of the agent’s run, everything gets stored in a dictionary that then is appended to <code>agent.logs</code>.</li> <li>Running <code>agent.write_inner_memory_from_logs()</code> creates an inner memory of the agent’s logs for the LLM to view, as a list of chat messages. This method goes over each step of the log and only stores what it’s interested in as a message: for instance, it will save the system prompt and task in separate messages, then for each step it will store the LLM output as a message, and the tool call output as another message. Use this if you want a higher-level view of what has happened - but not every log will be transcripted by this method.</li>",jl,Ze,vl,Ce,tn="A tool is an atomic function to be used by an agent.",Gl,xe,ln="You can for instance check the <code>PythonInterpreterTool</code>: it has a name, a description, input descriptions, an output type, and a <code>__call__</code> method to perform the action.",Bl,We,sn="When the agent is initialized, the tool attributes are used to generate a tool description which is baked into the agent’s system prompt. This lets the agent know which tools it can use and why.",Il,_e,$l,ke,nn="Transformers comes with a default toolbox for empowering agents, that you can add to your agent upon initialization with argument <code>add_base_tools = True</code>:",Zl,Re,an='<li><strong>Document question answering</strong>: given a document (such as a PDF) in image format, answer a question on this document (<a href="./model_doc/donut">Donut</a>)</li> <li><strong>Image question answering</strong>: given an image, answer a question on this image (<a href="./model_doc/vilt">VILT</a>)</li> <li><strong>Speech to text</strong>: given an audio recording of a person talking, transcribe the speech into text (<a href="./model_doc/whisper">Whisper</a>)</li> <li><strong>Text to speech</strong>: convert text to speech (<a href="./model_doc/speecht5">SpeechT5</a>)</li> <li><strong>Translation</strong>: translates a given sentence from source language to target language.</li> <li><strong>DuckDuckGo search*</strong>: performs a web search using DuckDuckGo browser.</li> <li><strong>Python code interpreter</strong>: runs your the LLM generated Python code in a secure environment. This tool will only be added to <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.ReactJsonAgent">ReactJsonAgent</a> if you initialize it with <code>add_base_tools=True</code>, since code-based agent can already natively execute Python code</li>',Cl,He,on='You can manually use a tool by calling the <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.load_tool">load_tool()</a> function and a task to perform.',xl,Ve,Wl,Ye,_l,ze,rn=`You can create your own tool for use cases not covered by the default tools from Hugging Face.
For example, let’s create a tool that returns the most downloaded model for a given task from the Hub.`,kl,Qe,pn="You’ll start with the code below.",Rl,Ne,Hl,Xe,dn='This code can be converted into a class that inherits from the <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.Tool">Tool</a> superclass.',Vl,Se,un="The custom tool needs:",Yl,Le,cn="<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name is <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>",zl,Ae,Ql,Fe,mn="Now that the custom <code>HfModelDownloadsTool</code> class is ready, you can save it to a file named <code>model_downloads.py</code> and import it for use.",Nl,Ee,Xl,qe,hn='You can also share your custom tool to the Hub by calling <a href="/docs/transformers/pr_28250/en/main_classes/agent#transformers.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Sl,Pe,Ll,De,yn="Load the tool with the <code>~Tool.load_tool</code> function and pass it to the <code>tools</code> parameter in your agent.",Al,Ke,Fl,Oe,Mn="You get the following:",El,et,ql,tt,fn=`And the output:
<code>&quot;The most downloaded model for the &#39;text-to-video&#39; task is ByteDance/AnimateDiff-Lightning.&quot;</code>`,Pl,lt,Dl,st,wn="If you have already initialized an agent, it is inconvenient to reinitialize it from scratch with a tool you want to use. With Transformers, you can manage an agent’s toolbox by adding or replacing a tool.",Kl,nt,bn="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",Ol,at,es,ot,gn="Now we can leverage both the new tool and the previous text-to-speech tool:",ts,it,ls,rt,Tn='<thead><tr><th><strong>Audio</strong></th></tr></thead> <tbody><tr><td><audio controls=""><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/damo.wav" type="audio/wav"/></audio></td></tr></tbody>',ss,G,ns,pt,Jn=`Use the <code>agent.toolbox.update_tool()</code> method to replace an existing tool in the agent’s toolbox.
This is useful if your new tool is a one-to-one replacement of the existing tool because the agent already knows how to perform that specific task.
Just make sure the new tool follows the same API as the replaced tool or adapt the system prompt template to ensure all examples using the replaced tool are updated.`,as,dt,os,ut,Un=`You can leverage tool collections by using the ToolCollection object, with the slug of the collection you want to use.
Then pass them as a list to initialize you agent, and start using them!`,is,ct,rs,mt,jn="To speed up the start, tools are loaded only if called by the agent.",ps,ht,vn="This gets you this image:",ds,Mt,Gn,us,yt,cs,ft,ms;return B=new b({props:{title:"Agents and tools",local:"agents-and-tools",headingTag:"h1"}}),I=new Yn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/agents.ipynb"}]}}),$=new b({props:{title:"What is an agent?",local:"what-is-an-agent",headingTag:"h3"}}),R=new b({props:{title:"Types of agents",local:"types-of-agents",headingTag:"h3"}}),H=new b({props:{title:"Code agent",local:"code-agent",headingTag:"h4"}}),Y=new b({props:{title:"React agents",local:"react-agents",headingTag:"h4"}}),J=new ys({props:{warning:!1,$$slots:{default:[Qn]},$$scope:{ctx:T}}}),L=new f({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkhvdyUyMG1hbnklMjBtb3JlJTIwYmxvY2tzJTIwKGFsc28lMjBkZW5vdGVkJTIwYXMlMjBsYXllcnMpJTIwaW4lMjBCRVJUJTIwYmFzZSUyMGVuY29kZXIlMjB0aGFuJTIwdGhlJTIwZW5jb2RlciUyMGZyb20lMjB0aGUlMjBhcmNoaXRlY3R1cmUlMjBwcm9wb3NlZCUyMGluJTIwQXR0ZW50aW9uJTIwaXMlMjBBbGwlMjBZb3UlMjBOZWVkJTNGJTIyJTJDJTBBKSUwQSUwQSUwQSUwQQ==",highlighted:`&gt;&gt;&gt; agent.<span class="hljs-built_in">run</span>(
<span class="hljs-built_in">..</span>.     <span class="hljs-string">&quot;How many more blocks (also denoted as layers) in BERT base encoder than the encoder from the architecture proposed in Attention is All You Need?&quot;</span>,
<span class="hljs-built_in">..</span>. )
=====New <span class="hljs-attribute">task</span>=====
How many more blocks (also denoted as layers) <span class="hljs-keyword">in</span> BERT base encoder than the encoder <span class="hljs-keyword">from</span> the architecture proposed <span class="hljs-keyword">in</span> Attention is All You Need?
====Agent is executing the code below:
bert_blocks = search(<span class="hljs-attribute">query</span>=<span class="hljs-string">&quot;number of blocks in BERT base encoder&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;BERT blocks:&quot;</span>, bert_blocks)
====
<span class="hljs-built_in">Print</span> outputs:
BERT blocks: twelve encoder blocks

====Agent is executing the code below:
attention_layer = search(<span class="hljs-attribute">query</span>=<span class="hljs-string">&quot;number of layers in Attention is All You Need&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attention layers:&quot;</span>, attention_layer)
====
<span class="hljs-built_in">Print</span> outputs:
Attention layers: Encoder: The encoder is composed of a stack of N = 6 identical layers. Each layer has two sub-layers. The first is a multi-head self-attention mechanism, <span class="hljs-keyword">and</span> the second is a simple, position- 2<span class="hljs-built_in"> Page </span>3 Figure 1: The Transformer - model architecture.

====Agent is executing the code below:
bert_blocks = 12
attention_layers = 6
diff = bert_blocks - attention_layers
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Difference in blocks:&quot;</span>, diff)
final_answer(diff)
====

<span class="hljs-built_in">Print</span> outputs:
Difference <span class="hljs-keyword">in</span> blocks: 6

Final answer: 6`,wrap:!1}}),A=new b({props:{title:"How can I build an agent?",local:"how-can-i-build-an-agent",headingTag:"h3"}}),D=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyU1QmFnZW50cyU1RA==",highlighted:"pip install transformers[agents]",wrap:!1}}),O=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTJDJTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBbG9naW4oJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIpJTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBJTBBZGVmJTIwbGxtX2VuZ2luZShtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTIyVGFzayUyMiU1RCklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQuY2hhdF9jb21wbGV0aW9uKG1lc3NhZ2VzJTJDJTIwc3RvcCUzRHN0b3Bfc2VxdWVuY2VzJTJDJTIwbWF4X3Rva2VucyUzRDEwMDApJTBBJTIwJTIwJTIwJTIwYW5zd2VyJTIwJTNEJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYW5zd2Vy",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login, InferenceClient

login(<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)

client = InferenceClient(model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">llm_engine</span>(<span class="hljs-params">messages, stop_sequences=[<span class="hljs-string">&quot;Task&quot;</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
    response = client.chat_completion(messages, stop=stop_sequences, max_tokens=<span class="hljs-number">1000</span>)
    answer = response.choices[<span class="hljs-number">0</span>].message.content
    <span class="hljs-keyword">return</span> answer`,wrap:!1}}),ae=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEhmQXBpRW5naW5lJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyQ291bGQlMjB5b3UlMjB0cmFuc2xhdGUlMjB0aGlzJTIwc2VudGVuY2UlMjBmcm9tJTIwRnJlbmNoJTJDJTIwc2F5JTIwaXQlMjBvdXQlMjBsb3VkJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwYXVkaW8uJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2VudGVuY2UlM0QlMjJPJUMzJUI5JTIwZXN0JTIwbGElMjBib3VsYW5nZXJpZSUyMGxhJTIwcGx1cyUyMHByb2NoZSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeAgent, HfApiEngine

llm_engine = HfApiEngine(model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
agent = CodeAgent(tools=[], llm_engine=llm_engine, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Could you translate this sentence from French, say it out loud and return the audio.&quot;</span>,
    sentence=<span class="hljs-string">&quot;Où est la boulangerie la plus proche?&quot;</span>,
)`,wrap:!1}}),ie=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJDb3VsZCUyMHlvdSUyMHRyYW5zbGF0ZSUyMHRoaXMlMjBzZW50ZW5jZSUyMGZyb20lMjBGcmVuY2glMkMlMjBzYXklMjBpdCUyMG91dCUyMGxvdWQlMjBhbmQlMjBnaXZlJTIwbWUlMjB0aGUlMjBhdWRpby4lMjIlMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZSUzRCUyMk8lQzMlQjklMjBlc3QlMjBsYSUyMGJvdWxhbmdlcmllJTIwbGElMjBwbHVzJTIwcHJvY2hlJTNGJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeAgent

agent = CodeAgent(tools=[], add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Could you translate this sentence from French, say it out loud and give me the audio.&quot;</span>,
    sentence=<span class="hljs-string">&quot;Où est la boulangerie la plus proche?&quot;</span>,
)`,wrap:!1}}),de=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMGxsbV9lbmdpbmUlM0RsbG1fZW5naW5lJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUwQWFnZW50LnJ1biglMjJXaHklMjBkb2VzJTIwTWlrZSUyMG5vdCUyMGtub3clMjBtYW55JTIwcGVvcGxlJTIwaW4lMjBOZXclMjBZb3JrJTNGJTIyJTJDJTIwYXVkaW8lM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZyZWNvcmRpbmcubXAzJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[], llm_engine=llm_engine, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>, audio=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&quot;</span>)`,wrap:!1}}),ce=new f({props:{code:"cHJpbnQoYWdlbnQuc3lzdGVtX3Byb21wdF90ZW1wbGF0ZSk=",highlighted:'<span class="hljs-built_in">print</span>(agent.system_prompt_template)',wrap:!1}}),he=new b({props:{title:"Code execution",local:"code-execution",headingTag:"h4"}}),fe=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJ3JlcXVlc3RzJyUyQyUyMCdiczQnJTVEKSUwQWFnZW50LnJ1biglMjJDb3VsZCUyMHlvdSUyMGdldCUyMG1lJTIwdGhlJTIwdGl0bGUlMjBvZiUyMHRoZSUyMHBhZ2UlMjBhdCUyMHVybCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGYmxvZyclM0YlMjIpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactCodeAgent(tools=[], additional_authorized_imports=[<span class="hljs-string">&#x27;requests&#x27;</span>, <span class="hljs-string">&#x27;bs4&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;Could you get me the title of the page at url &#x27;https://huggingface.co/blog&#x27;?&quot;</span>)

(...)
<span class="hljs-string">&#x27;Hugging Face – Blog&#x27;</span>`,wrap:!1}}),j=new ys({props:{warning:!0,$$slots:{default:[Nn]},$$scope:{ctx:T}}}),be=new b({props:{title:"The system prompt",local:"the-system-prompt",headingTag:"h3"}}),Te=new f({props:{code:"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",highlighted:`You will be given a task to solve as best you can.
You have access to the following tools:
&lt;&lt;tool_descriptions&gt;&gt;

To solve the task, you must plan forward to proceed in a series of steps, in a cycle of &#x27;Thought:&#x27;, &#x27;Code:&#x27;, and &#x27;Observation:&#x27; sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task, then the tools that you want to use.
Then in the &#x27;Code:&#x27; sequence, you shold write the code in simple Python. The code sequence must end with &#x27;/End code&#x27; sequence.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then be available in the &#x27;Observation:&#x27; field, for using this information as input for the next step.

In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
{examples}

Above example were using notional tools that might not exist for you. You only have acces to those tools:
&lt;&lt;tool_names&gt;&gt;
You also can perform computations in the python code you generate.

Always provide a &#x27;Thought:&#x27; and a &#x27;Code:\\n\`\`\`py&#x27; sequence ending with &#x27;\`\`\`&lt;end_code&gt;&#x27; sequence. You MUST provide at least the &#x27;Code:&#x27; sequence to move forward.

Remember to not perform too many operations in a single code block! You should split the task into intermediate code blocks.
Print results at the end of each step to save the intermediate results. Then use final_answer() to return the final result.

Remember to make sure that variables you use are all defined.

Now Begin!`,wrap:!1}}),Ge=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0SnNvbkFnZW50JTBBZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBQeXRob25JbnRlcnByZXRlclRvb2wlMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KHRvb2xzJTNEJTVCUHl0aG9uSW50ZXJwcmV0ZXJUb29sKCklNUQlMkMlMjBzeXN0ZW1fcHJvbXB0JTNEJTIyJTdCeW91cl9jdXN0b21fcHJvbXB0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactJsonAgent
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> PythonInterpreterTool

agent = ReactJsonAgent(tools=[PythonInterpreterTool()], system_prompt=<span class="hljs-string">&quot;{your_custom_prompt}&quot;</span>)`,wrap:!1}}),v=new ys({props:{warning:!0,$$slots:{default:[Xn]},$$scope:{ctx:T}}}),Be=new b({props:{title:"Inspecting an agent run",local:"inspecting-an-agent-run",headingTag:"h3"}}),Ze=new b({props:{title:"Tools",local:"tools",headingTag:"h2"}}),_e=new b({props:{title:"Default toolbox",local:"default-toolbox",headingTag:"h3"}}),Ve=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQXRvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIydGV4dC10by1zcGVlY2glMjIpJTBBYXVkaW8lMjAlM0QlMjB0b29sKCUyMlRoaXMlMjBpcyUyMGElMjB0ZXh0JTIwdG8lMjBzcGVlY2glMjB0b29sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

tool = load_tool(<span class="hljs-string">&quot;text-to-speech&quot;</span>)
audio = tool(<span class="hljs-string">&quot;This is a text to speech tool&quot;</span>)`,wrap:!1}}),Ye=new b({props:{title:"Create a new tool",local:"create-a-new-tool",headingTag:"h3"}}),Ne=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbW9kZWxzJTBBJTBBdGFzayUyMCUzRCUyMCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMEElMEFtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBcHJpbnQobW9kZWwuaWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

task = <span class="hljs-string">&quot;text-classification&quot;</span>

model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
<span class="hljs-built_in">print</span>(model.<span class="hljs-built_in">id</span>)`,wrap:!1}}),Ae=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEFjbGFzcyUyMEhGTW9kZWxEb3dubG9hZHNUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMm1vZGVsX2Rvd25sb2FkX2NvdW50ZXIlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJ0aGUlMjB0YXNrJTIwY2F0ZWdvcnklMjAoc3VjaCUyMGFzJTIwdGV4dC1jbGFzc2lmaWNhdGlvbiUyQyUyMGRlcHRoLWVzdGltYXRpb24lMkMlMjBldGMpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlMjAlM0QlMjAlMjJ0ZXh0JTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = (
        <span class="hljs-string">&quot;This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub. &quot;</span>
        <span class="hljs-string">&quot;It returns the name of the checkpoint.&quot;</span>
    )

    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>`,wrap:!1}}),Ee=new f({props:{code:"ZnJvbSUyMG1vZGVsX2Rvd25sb2FkcyUyMGltcG9ydCUyMEhGTW9kZWxEb3dubG9hZHNUb29sJTBBJTBBdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> model_downloads <span class="hljs-keyword">import</span> HFModelDownloadsTool

tool = HFModelDownloadsTool()`,wrap:!1}}),Pe=new f({props:{code:"dG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGaGYtbW9kZWwtZG93bmxvYWRzJTIyKQ==",highlighted:'tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>)',wrap:!1}}),Ke=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUyQyUyMENvZGVBZ2VudCUwQSUwQW1vZGVsX2Rvd25sb2FkX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJtb2RlbF9kb3dubG9hZF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(<span class="hljs-string">&quot;m-ric/hf-model-downloads&quot;</span>)
agent = CodeAgent(tools=[model_download_tool], llm_engine=llm_engine)
agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub?&quot;</span>
)`,wrap:!1}}),et=new f({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwTmV3JTIwdGFzayUyMCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQUNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTNGJTBBJTNEJTNEJTNEJTNEJTIwQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQSUwQW1vc3RfZG93bmxvYWRlZF9tb2RlbCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX2NvdW50ZXIodGFzayUzRCUyMnRleHQtdG8tdmlkZW8lMjIpJTBBcHJpbnQoZiUyMlRoZSUyMG1vc3QlMjBkb3dubG9hZGVkJTIwbW9kZWwlMjBmb3IlMjB0aGUlMjAndGV4dC10by12aWRlbyclMjB0YXNrJTIwaXMlMjAlN0Jtb3N0X2Rvd25sb2FkZWRfbW9kZWwlN0QuJTIyKSUwQSUzRCUzRCUzRCUzRA==",highlighted:`======== New task ========
Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub?
==== Agent is executing the code below:
most_downloaded_model = model_download_counter(task=&quot;text-to-video&quot;)
print(f&quot;The most downloaded model for the &#x27;text-to-video&#x27; task is {most_downloaded_model}.&quot;)
====`,wrap:!1}}),lt=new b({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),at=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBYWdlbnQudG9vbGJveC5hZGRfdG9vbChtb2RlbF9kb3dubG9hZF90b29sKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeAgent

agent = CodeAgent(tools=[], llm_engine=llm_engine, add_base_tools=<span class="hljs-literal">True</span>)
agent.toolbox.add_tool(model_download_tool)`,wrap:!1}}),it=new f({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMHJlYWQlMjBvdXQlMjBsb3VkJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwbW9kZWwlMjB0aGF0JTIwaGFzJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkcyUyMGluJTIwdGhlJTIwJ3RleHQtdG8tdmlkZW8nJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMjBhbmQlMjByZXR1cm4lMjB0aGUlMjBhdWRpbyUzRiUyMiUwQSk=",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you read out loud the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub and return the audio?&quot;</span>
)`,wrap:!1}}),G=new ys({props:{warning:!0,$$slots:{default:[Sn]},$$scope:{ctx:T}}}),dt=new b({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),ct=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwUmVhY3RDb2RlQWdlbnQlMEElMEFpbWFnZV90b29sX2NvbGxlY3Rpb24lMjAlM0QlMjBUb29sQ29sbGVjdGlvbihjb2xsZWN0aW9uX3NsdWclM0QlMjJodWdnaW5nZmFjZS10b29scyUyRmRpZmZ1c2lvbi10b29scy02NjMwYmIxOWE5NDJjMjMwNmEyY2RiNmYlMjIpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QippbWFnZV90b29sX2NvbGxlY3Rpb24udG9vbHMlNUQlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUyMlBsZWFzZSUyMGRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ToolCollection, ReactCodeAgent

image_tool_collection = ToolCollection(collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>)
agent = ReactCodeAgent(tools=[*image_tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),yt=new zn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/agents.md"}}),{c(){p=o("meta"),w=n(),M=o("p"),g=n(),d(B.$$.fragment),wt=n(),d(I.$$.fragment),bt=n(),d($.$$.fragment),gt=n(),Z=o("p"),Z.innerHTML=fs,Tt=n(),C=o("p"),C.innerHTML=ws,Jt=n(),x=o("p"),x.innerHTML=bs,Ut=n(),W=o("p"),W.innerHTML=gs,jt=n(),_=o("p"),_.textContent=Ts,vt=n(),k=o("ul"),k.innerHTML=Js,Gt=n(),d(R.$$.fragment),Bt=n(),d(H.$$.fragment),It=n(),V=o("p"),V.textContent=Us,$t=n(),d(Y.$$.fragment),Zt=n(),z=o("p"),z.innerHTML=js,Ct=n(),Q=o("p"),Q.textContent=vs,xt=n(),N=o("ul"),N.innerHTML=Gs,Wt=n(),d(J.$$.fragment),_t=n(),U=o("div"),U.innerHTML=Bs,kt=n(),X=o("p"),X.innerHTML=Is,Rt=n(),S=o("p"),S.textContent=$s,Ht=n(),d(L.$$.fragment),Vt=n(),d(A.$$.fragment),Yt=n(),F=o("p"),F.textContent=Zs,zt=n(),E=o("ul"),E.innerHTML=Cs,Qt=n(),q=o("p"),q.innerHTML=xs,Nt=n(),P=o("p"),P.innerHTML=Ws,Xt=n(),d(D.$$.fragment),St=n(),K=o("p"),K.innerHTML=_s,Lt=n(),d(O.$$.fragment),At=n(),ee=o("p"),ee.innerHTML=ks,Ft=n(),te=o("ol"),te.innerHTML=Rs,Et=n(),le=o("p"),le.innerHTML=Hs,qt=n(),se=o("p"),se.innerHTML=Vs,Pt=n(),ne=o("p"),ne.innerHTML=Ys,Dt=n(),d(ae.$$.fragment),Kt=n(),oe=o("p"),oe.innerHTML=zs,Ot=n(),d(ie.$$.fragment),el=n(),re=o("p"),re.innerHTML=Qs,tl=n(),pe=o("p"),pe.textContent=Ns,ll=n(),d(de.$$.fragment),sl=n(),ue=o("p"),ue.innerHTML=Xs,nl=n(),d(ce.$$.fragment),al=n(),me=o("p"),me.innerHTML=Ss,ol=n(),d(he.$$.fragment),il=n(),ye=o("p"),ye.textContent=Ls,rl=n(),Me=o("p"),Me.innerHTML=As,pl=n(),d(fe.$$.fragment),dl=n(),we=o("p"),we.textContent=Fs,ul=n(),d(j.$$.fragment),cl=n(),d(be.$$.fragment),ml=n(),ge=o("p"),ge.innerHTML=Es,hl=n(),d(Te.$$.fragment),yl=n(),Je=o("p"),Je.textContent=qs,Ml=n(),Ue=o("ul"),Ue.innerHTML=Ps,fl=n(),je=o("p"),je.textContent=Ds,wl=n(),ve=o("p"),ve.innerHTML=Ks,bl=n(),d(Ge.$$.fragment),gl=n(),d(v.$$.fragment),Tl=n(),d(Be.$$.fragment),Jl=n(),Ie=o("p"),Ie.textContent=Os,Ul=n(),$e=o("ul"),$e.innerHTML=en,jl=n(),d(Ze.$$.fragment),vl=n(),Ce=o("p"),Ce.textContent=tn,Gl=n(),xe=o("p"),xe.innerHTML=ln,Bl=n(),We=o("p"),We.textContent=sn,Il=n(),d(_e.$$.fragment),$l=n(),ke=o("p"),ke.innerHTML=nn,Zl=n(),Re=o("ul"),Re.innerHTML=an,Cl=n(),He=o("p"),He.innerHTML=on,xl=n(),d(Ve.$$.fragment),Wl=n(),d(Ye.$$.fragment),_l=n(),ze=o("p"),ze.textContent=rn,kl=n(),Qe=o("p"),Qe.textContent=pn,Rl=n(),d(Ne.$$.fragment),Hl=n(),Xe=o("p"),Xe.innerHTML=dn,Vl=n(),Se=o("p"),Se.textContent=un,Yl=n(),Le=o("ul"),Le.innerHTML=cn,zl=n(),d(Ae.$$.fragment),Ql=n(),Fe=o("p"),Fe.innerHTML=mn,Nl=n(),d(Ee.$$.fragment),Xl=n(),qe=o("p"),qe.innerHTML=hn,Sl=n(),d(Pe.$$.fragment),Ll=n(),De=o("p"),De.innerHTML=yn,Al=n(),d(Ke.$$.fragment),Fl=n(),Oe=o("p"),Oe.textContent=Mn,El=n(),d(et.$$.fragment),ql=n(),tt=o("p"),tt.innerHTML=fn,Pl=n(),d(lt.$$.fragment),Dl=n(),st=o("p"),st.textContent=wn,Kl=n(),nt=o("p"),nt.innerHTML=bn,Ol=n(),d(at.$$.fragment),es=n(),ot=o("p"),ot.textContent=gn,ts=n(),d(it.$$.fragment),ls=n(),rt=o("table"),rt.innerHTML=Tn,ss=n(),d(G.$$.fragment),ns=n(),pt=o("p"),pt.innerHTML=Jn,as=n(),d(dt.$$.fragment),os=n(),ut=o("p"),ut.textContent=Un,is=n(),d(ct.$$.fragment),rs=n(),mt=o("p"),mt.textContent=jn,ps=n(),ht=o("p"),ht.textContent=vn,ds=n(),Mt=o("img"),us=n(),d(yt.$$.fragment),cs=n(),ft=o("p"),this.h()},l(e){const t=Hn("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),M=i(e,"P",{}),Cn(M).forEach(l),g=a(e),u(B.$$.fragment,e),wt=a(e),u(I.$$.fragment,e),bt=a(e),u($.$$.fragment,e),gt=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1fkpjtq"&&(Z.innerHTML=fs),Tt=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1c8vvla"&&(C.innerHTML=ws),Jt=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-ueie6c"&&(x.innerHTML=bs),Ut=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1v15icf"&&(W.innerHTML=gs),jt=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1oh78rs"&&(_.textContent=Ts),vt=a(e),k=i(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-18le42s"&&(k.innerHTML=Js),Gt=a(e),u(R.$$.fragment,e),Bt=a(e),u(H.$$.fragment,e),It=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1o9o1oq"&&(V.textContent=Us),$t=a(e),u(Y.$$.fragment,e),Zt=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-un0fb8"&&(z.innerHTML=js),Ct=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1jksgzv"&&(Q.textContent=vs),xt=a(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1ifh9vd"&&(N.innerHTML=Gs),Wt=a(e),u(J.$$.fragment,e),_t=a(e),U=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-4ra9xq"&&(U.innerHTML=Bs),kt=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-f8aw2d"&&(X.innerHTML=Is),Rt=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-q1dbs5"&&(S.textContent=$s),Ht=a(e),u(L.$$.fragment,e),Vt=a(e),u(A.$$.fragment,e),Yt=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1vwgkxv"&&(F.textContent=Zs),zt=a(e),E=i(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-peqpvl"&&(E.innerHTML=Cs),Qt=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1pl6btk"&&(q.innerHTML=xs),Nt=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1dv7sdf"&&(P.innerHTML=Ws),Xt=a(e),u(D.$$.fragment,e),St=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-16hu4e5"&&(K.innerHTML=_s),Lt=a(e),u(O.$$.fragment,e),At=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-f52dcf"&&(ee.innerHTML=ks),Ft=a(e),te=i(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-hi869d"&&(te.innerHTML=Rs),Et=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1t4msyp"&&(le.innerHTML=Hs),qt=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1qjx3mb"&&(se.innerHTML=Vs),Pt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1rahg2a"&&(ne.innerHTML=Ys),Dt=a(e),u(ae.$$.fragment,e),Kt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1pm5xnp"&&(oe.innerHTML=zs),Ot=a(e),u(ie.$$.fragment,e),el=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1sxtmn2"&&(re.innerHTML=Qs),tl=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-18l0kfm"&&(pe.textContent=Ns),ll=a(e),u(de.$$.fragment,e),sl=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1d0hijn"&&(ue.innerHTML=Xs),nl=a(e),u(ce.$$.fragment,e),al=a(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-iorlkg"&&(me.innerHTML=Ss),ol=a(e),u(he.$$.fragment,e),il=a(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1ysbw77"&&(ye.textContent=Ls),rl=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-17kkpyd"&&(Me.innerHTML=As),pl=a(e),u(fe.$$.fragment,e),dl=a(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1iiqbq7"&&(we.textContent=Fs),ul=a(e),u(j.$$.fragment,e),cl=a(e),u(be.$$.fragment,e),ml=a(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-xygqb6"&&(ge.innerHTML=Es),hl=a(e),u(Te.$$.fragment,e),yl=a(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1xlke9j"&&(Je.textContent=qs),Ml=a(e),Ue=i(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-1jdqerr"&&(Ue.innerHTML=Ps),fl=a(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1poc7fx"&&(je.textContent=Ds),wl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-2xz207"&&(ve.innerHTML=Ks),bl=a(e),u(Ge.$$.fragment,e),gl=a(e),u(v.$$.fragment,e),Tl=a(e),u(Be.$$.fragment,e),Jl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-4h2er2"&&(Ie.textContent=Os),Ul=a(e),$e=i(e,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-1bn17ay"&&($e.innerHTML=en),jl=a(e),u(Ze.$$.fragment,e),vl=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-kl6fdx"&&(Ce.textContent=tn),Gl=a(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-2gk7zp"&&(xe.innerHTML=ln),Bl=a(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-u83m8z"&&(We.textContent=sn),Il=a(e),u(_e.$$.fragment,e),$l=a(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1uj21n8"&&(ke.innerHTML=nn),Zl=a(e),Re=i(e,"UL",{"data-svelte-h":!0}),r(Re)!=="svelte-vscpb2"&&(Re.innerHTML=an),Cl=a(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-ln98gx"&&(He.innerHTML=on),xl=a(e),u(Ve.$$.fragment,e),Wl=a(e),u(Ye.$$.fragment,e),_l=a(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-8dd7rj"&&(ze.textContent=rn),kl=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-jio97"&&(Qe.textContent=pn),Rl=a(e),u(Ne.$$.fragment,e),Hl=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-mqhkyr"&&(Xe.innerHTML=dn),Vl=a(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-hid0wz"&&(Se.textContent=un),Yl=a(e),Le=i(e,"UL",{"data-svelte-h":!0}),r(Le)!=="svelte-11dnyg5"&&(Le.innerHTML=cn),zl=a(e),u(Ae.$$.fragment,e),Ql=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-58l3g5"&&(Fe.innerHTML=mn),Nl=a(e),u(Ee.$$.fragment,e),Xl=a(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-on3abc"&&(qe.innerHTML=hn),Sl=a(e),u(Pe.$$.fragment,e),Ll=a(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-n0ukpl"&&(De.innerHTML=yn),Al=a(e),u(Ke.$$.fragment,e),Fl=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-rgc1m9"&&(Oe.textContent=Mn),El=a(e),u(et.$$.fragment,e),ql=a(e),tt=i(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-di3g23"&&(tt.innerHTML=fn),Pl=a(e),u(lt.$$.fragment,e),Dl=a(e),st=i(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-j71532"&&(st.textContent=wn),Kl=a(e),nt=i(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-ocb8u2"&&(nt.innerHTML=bn),Ol=a(e),u(at.$$.fragment,e),es=a(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1pyqvzc"&&(ot.textContent=gn),ts=a(e),u(it.$$.fragment,e),ls=a(e),rt=i(e,"TABLE",{"data-svelte-h":!0}),r(rt)!=="svelte-1tqzmpy"&&(rt.innerHTML=Tn),ss=a(e),u(G.$$.fragment,e),ns=a(e),pt=i(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-zx9fzv"&&(pt.innerHTML=Jn),as=a(e),u(dt.$$.fragment,e),os=a(e),ut=i(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-15fzsol"&&(ut.textContent=Un),is=a(e),u(ct.$$.fragment,e),rs=a(e),mt=i(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-6r1jgt"&&(mt.textContent=jn),ps=a(e),ht=i(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1azl0wr"&&(ht.textContent=vn),ds=a(e),Mt=i(e,"IMG",{src:!0}),us=a(e),u(yt.$$.fragment,e),cs=a(e),ft=i(e,"P",{}),Cn(ft).forEach(l),this.h()},h(){hs(p,"name","hf:doc:metadata"),hs(p,"content",An),hs(U,"class","flex justify-center"),Wn(Mt.src,Gn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rivers_and_lakes.png")||hs(Mt,"src",Gn)},m(e,t){Vn(document.head,p),s(e,w,t),s(e,M,t),s(e,g,t),c(B,e,t),s(e,wt,t),c(I,e,t),s(e,bt,t),c($,e,t),s(e,gt,t),s(e,Z,t),s(e,Tt,t),s(e,C,t),s(e,Jt,t),s(e,x,t),s(e,Ut,t),s(e,W,t),s(e,jt,t),s(e,_,t),s(e,vt,t),s(e,k,t),s(e,Gt,t),c(R,e,t),s(e,Bt,t),c(H,e,t),s(e,It,t),s(e,V,t),s(e,$t,t),c(Y,e,t),s(e,Zt,t),s(e,z,t),s(e,Ct,t),s(e,Q,t),s(e,xt,t),s(e,N,t),s(e,Wt,t),c(J,e,t),s(e,_t,t),s(e,U,t),s(e,kt,t),s(e,X,t),s(e,Rt,t),s(e,S,t),s(e,Ht,t),c(L,e,t),s(e,Vt,t),c(A,e,t),s(e,Yt,t),s(e,F,t),s(e,zt,t),s(e,E,t),s(e,Qt,t),s(e,q,t),s(e,Nt,t),s(e,P,t),s(e,Xt,t),c(D,e,t),s(e,St,t),s(e,K,t),s(e,Lt,t),c(O,e,t),s(e,At,t),s(e,ee,t),s(e,Ft,t),s(e,te,t),s(e,Et,t),s(e,le,t),s(e,qt,t),s(e,se,t),s(e,Pt,t),s(e,ne,t),s(e,Dt,t),c(ae,e,t),s(e,Kt,t),s(e,oe,t),s(e,Ot,t),c(ie,e,t),s(e,el,t),s(e,re,t),s(e,tl,t),s(e,pe,t),s(e,ll,t),c(de,e,t),s(e,sl,t),s(e,ue,t),s(e,nl,t),c(ce,e,t),s(e,al,t),s(e,me,t),s(e,ol,t),c(he,e,t),s(e,il,t),s(e,ye,t),s(e,rl,t),s(e,Me,t),s(e,pl,t),c(fe,e,t),s(e,dl,t),s(e,we,t),s(e,ul,t),c(j,e,t),s(e,cl,t),c(be,e,t),s(e,ml,t),s(e,ge,t),s(e,hl,t),c(Te,e,t),s(e,yl,t),s(e,Je,t),s(e,Ml,t),s(e,Ue,t),s(e,fl,t),s(e,je,t),s(e,wl,t),s(e,ve,t),s(e,bl,t),c(Ge,e,t),s(e,gl,t),c(v,e,t),s(e,Tl,t),c(Be,e,t),s(e,Jl,t),s(e,Ie,t),s(e,Ul,t),s(e,$e,t),s(e,jl,t),c(Ze,e,t),s(e,vl,t),s(e,Ce,t),s(e,Gl,t),s(e,xe,t),s(e,Bl,t),s(e,We,t),s(e,Il,t),c(_e,e,t),s(e,$l,t),s(e,ke,t),s(e,Zl,t),s(e,Re,t),s(e,Cl,t),s(e,He,t),s(e,xl,t),c(Ve,e,t),s(e,Wl,t),c(Ye,e,t),s(e,_l,t),s(e,ze,t),s(e,kl,t),s(e,Qe,t),s(e,Rl,t),c(Ne,e,t),s(e,Hl,t),s(e,Xe,t),s(e,Vl,t),s(e,Se,t),s(e,Yl,t),s(e,Le,t),s(e,zl,t),c(Ae,e,t),s(e,Ql,t),s(e,Fe,t),s(e,Nl,t),c(Ee,e,t),s(e,Xl,t),s(e,qe,t),s(e,Sl,t),c(Pe,e,t),s(e,Ll,t),s(e,De,t),s(e,Al,t),c(Ke,e,t),s(e,Fl,t),s(e,Oe,t),s(e,El,t),c(et,e,t),s(e,ql,t),s(e,tt,t),s(e,Pl,t),c(lt,e,t),s(e,Dl,t),s(e,st,t),s(e,Kl,t),s(e,nt,t),s(e,Ol,t),c(at,e,t),s(e,es,t),s(e,ot,t),s(e,ts,t),c(it,e,t),s(e,ls,t),s(e,rt,t),s(e,ss,t),c(G,e,t),s(e,ns,t),s(e,pt,t),s(e,as,t),c(dt,e,t),s(e,os,t),s(e,ut,t),s(e,is,t),c(ct,e,t),s(e,rs,t),s(e,mt,t),s(e,ps,t),s(e,ht,t),s(e,ds,t),s(e,Mt,t),s(e,us,t),c(yt,e,t),s(e,cs,t),s(e,ft,t),ms=!0},p(e,[t]){const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),J.$set(Bn);const In={};t&2&&(In.$$scope={dirty:t,ctx:e}),j.$set(In);const $n={};t&2&&($n.$$scope={dirty:t,ctx:e}),v.$set($n);const Zn={};t&2&&(Zn.$$scope={dirty:t,ctx:e}),G.$set(Zn)},i(e){ms||(m(B.$$.fragment,e),m(I.$$.fragment,e),m($.$$.fragment,e),m(R.$$.fragment,e),m(H.$$.fragment,e),m(Y.$$.fragment,e),m(J.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(de.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),m(j.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(Ge.$$.fragment,e),m(v.$$.fragment,e),m(Be.$$.fragment,e),m(Ze.$$.fragment,e),m(_e.$$.fragment,e),m(Ve.$$.fragment,e),m(Ye.$$.fragment,e),m(Ne.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(Pe.$$.fragment,e),m(Ke.$$.fragment,e),m(et.$$.fragment,e),m(lt.$$.fragment,e),m(at.$$.fragment,e),m(it.$$.fragment,e),m(G.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(yt.$$.fragment,e),ms=!0)},o(e){h(B.$$.fragment,e),h(I.$$.fragment,e),h($.$$.fragment,e),h(R.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(J.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(j.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(Ge.$$.fragment,e),h(v.$$.fragment,e),h(Be.$$.fragment,e),h(Ze.$$.fragment,e),h(_e.$$.fragment,e),h(Ve.$$.fragment,e),h(Ye.$$.fragment,e),h(Ne.$$.fragment,e),h(Ae.$$.fragment,e),h(Ee.$$.fragment,e),h(Pe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(lt.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),h(G.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(yt.$$.fragment,e),ms=!1},d(e){e&&(l(w),l(M),l(g),l(wt),l(bt),l(gt),l(Z),l(Tt),l(C),l(Jt),l(x),l(Ut),l(W),l(jt),l(_),l(vt),l(k),l(Gt),l(Bt),l(It),l(V),l($t),l(Zt),l(z),l(Ct),l(Q),l(xt),l(N),l(Wt),l(_t),l(U),l(kt),l(X),l(Rt),l(S),l(Ht),l(Vt),l(Yt),l(F),l(zt),l(E),l(Qt),l(q),l(Nt),l(P),l(Xt),l(St),l(K),l(Lt),l(At),l(ee),l(Ft),l(te),l(Et),l(le),l(qt),l(se),l(Pt),l(ne),l(Dt),l(Kt),l(oe),l(Ot),l(el),l(re),l(tl),l(pe),l(ll),l(sl),l(ue),l(nl),l(al),l(me),l(ol),l(il),l(ye),l(rl),l(Me),l(pl),l(dl),l(we),l(ul),l(cl),l(ml),l(ge),l(hl),l(yl),l(Je),l(Ml),l(Ue),l(fl),l(je),l(wl),l(ve),l(bl),l(gl),l(Tl),l(Jl),l(Ie),l(Ul),l($e),l(jl),l(vl),l(Ce),l(Gl),l(xe),l(Bl),l(We),l(Il),l($l),l(ke),l(Zl),l(Re),l(Cl),l(He),l(xl),l(Wl),l(_l),l(ze),l(kl),l(Qe),l(Rl),l(Hl),l(Xe),l(Vl),l(Se),l(Yl),l(Le),l(zl),l(Ql),l(Fe),l(Nl),l(Xl),l(qe),l(Sl),l(Ll),l(De),l(Al),l(Fl),l(Oe),l(El),l(ql),l(tt),l(Pl),l(Dl),l(st),l(Kl),l(nt),l(Ol),l(es),l(ot),l(ts),l(ls),l(rt),l(ss),l(ns),l(pt),l(as),l(os),l(ut),l(is),l(rs),l(mt),l(ps),l(ht),l(ds),l(Mt),l(us),l(cs),l(ft)),l(p),y(B,e),y(I,e),y($,e),y(R,e),y(H,e),y(Y,e),y(J,e),y(L,e),y(A,e),y(D,e),y(O,e),y(ae,e),y(ie,e),y(de,e),y(ce,e),y(he,e),y(fe,e),y(j,e),y(be,e),y(Te,e),y(Ge,e),y(v,e),y(Be,e),y(Ze,e),y(_e,e),y(Ve,e),y(Ye,e),y(Ne,e),y(Ae,e),y(Ee,e),y(Pe,e),y(Ke,e),y(et,e),y(lt,e),y(at,e),y(it,e),y(G,e),y(dt,e),y(ct,e),y(yt,e)}}}const An='{"title":"Agents and tools","local":"agents-and-tools","sections":[{"title":"What is an agent?","local":"what-is-an-agent","sections":[],"depth":3},{"title":"Types of agents","local":"types-of-agents","sections":[{"title":"Code agent","local":"code-agent","sections":[],"depth":4},{"title":"React agents","local":"react-agents","sections":[],"depth":4}],"depth":3},{"title":"How can I build an agent?","local":"how-can-i-build-an-agent","sections":[{"title":"Code execution","local":"code-execution","sections":[],"depth":4}],"depth":3},{"title":"The system prompt","local":"the-system-prompt","sections":[],"depth":3},{"title":"Inspecting an agent run","local":"inspecting-an-agent-run","sections":[],"depth":3},{"title":"Tools","local":"tools","sections":[{"title":"Default toolbox","local":"default-toolbox","sections":[],"depth":3},{"title":"Create a new tool","local":"create-a-new-tool","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[],"depth":3}],"depth":2}],"depth":1}';function Fn(T){return _n(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ea extends kn{constructor(p){super(),Rn(this,p,Fn,Ln,xn,{})}}export{ea as component};
