import{s as Rt,f as Wt,o as Bt,n as je}from"../chunks/scheduler.25b97de1.js";import{S as Dt,i as Ht,g as d,s as a,r as h,A as St,h as c,f as o,c as i,j as U,u as f,x as w,k as T,y as m,a as r,v as g,d as u,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as vt}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.e257edda.js";import{C as $t}from"../chunks/CodeBlock.e6cd0d95.js";import{E as wt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as V,E as Xt}from"../chunks/EditOnGithub.91d95064.js";function Vt(M){let n,y=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){n=d("p"),n.innerHTML=y},l(l){n=c(l,"P",{"data-svelte-h":!0}),w(n)!=="svelte-j665pk"&&(n.innerHTML=y)},m(l,p){r(l,n,p)},p:je,d(l){l&&o(n)}}}function qt(M){let n,y="Example:",l,p,v;return p=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdMUE5Nb2RlbCUyQyUyMEdMUE5Db25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR0xQTiUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwR0xQTkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GLPNModel, GLPNConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GLPN vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GLPNConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,l=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),w(n)!=="svelte-11lpom8"&&(n.textContent=y),l=i(s),f(p.$$.fragment,s)},m(s,$){r(s,n,$),r(s,l,$),g(p,s,$),v=!0},p:je,i(s){v||(u(p.$$.fragment,s),v=!0)},o(s){_(p.$$.fragment,s),v=!1},d(s){s&&(o(n),o(l)),b(p,s)}}}function At(M){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=y},l(l){n=c(l,"P",{"data-svelte-h":!0}),w(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(l,p){r(l,n,p)},p:je,d(l){l&&o(n)}}}function Qt(M){let n,y="Example:",l,p,v;return p=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">512</span>, <span class="hljs-number">15</span>, <span class="hljs-number">20</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,l=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),w(n)!=="svelte-11lpom8"&&(n.textContent=y),l=i(s),f(p.$$.fragment,s)},m(s,$){r(s,n,$),r(s,l,$),g(p,s,$),v=!0},p:je,i(s){v||(u(p.$$.fragment,s),v=!0)},o(s){_(p.$$.fragment,s),v=!1},d(s){s&&(o(n),o(l)),b(p,s)}}}function Yt(M){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=y},l(l){n=c(l,"P",{"data-svelte-h":!0}),w(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(l,p){r(l,n,p)},p:je,d(l){l&&o(n)}}}function Ot(M){let n,y="Examples:",l,p,v;return p=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0ZWRfZGVwdGglMEElMEElMjMlMjBpbnRlcnBvbGF0ZSUyMHRvJTIwb3JpZ2luYWwlMjBzaXplJTBBcHJlZGljdGlvbiUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZSgxKSUyQyUwQSUyMCUyMCUyMCUyMHNpemUlM0RpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIyYmljdWJpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBb3V0cHV0JTIwJTNEJTIwcHJlZGljdGlvbi5zcXVlZXplKCkuY3B1KCkubnVtcHkoKSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,l=a(),h(p.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),w(n)!=="svelte-kvfsh7"&&(n.textContent=y),l=i(s),f(p.$$.fragment,s)},m(s,$){r(s,n,$),r(s,l,$),g(p,s,$),v=!0},p:je,i(s){v||(u(p.$$.fragment,s),v=!0)},o(s){_(p.$$.fragment,s),v=!1},d(s){s&&(o(n),o(l)),b(p,s)}}}function Kt(M){let n,y,l,p,v,s,$,Ie,q,Je,A,Mt=`The GLPN model was proposed in <a href="https://arxiv.org/abs/2201.07436" rel="nofollow">Global-Local Path Networks for Monocular Depth Estimation with Vertical CutDepth</a>  by Doyeon Kim, Woonghyun Ga, Pyungwhan Ahn, Donggyu Joo, Sehwan Chun, Junmo Kim.
GLPN combines <a href="segformer">SegFormer</a>’s hierarchical mix-Transformer with a lightweight decoder for monocular depth estimation. The proposed decoder shows better performance than the previously proposed decoders, with considerably
less computational complexity.`,Ee,Q,Tt="The abstract from the paper is the following:",ze,Y,Pt="<em>Depth estimation from a single image is an important task that can be applied to various fields in computer vision, and has grown rapidly with the development of convolutional neural networks. In this paper, we propose a novel structure and training strategy for monocular depth estimation to further improve the prediction accuracy of the network. We deploy a hierarchical transformer encoder to capture and convey the global context, and design a lightweight yet powerful decoder to generate an estimated depth map while considering local connectivity. By constructing connected paths between multi-scale local features and the global decoding stream with our proposed selective feature fusion module, the network can integrate both representations and recover fine details. In addition, the proposed decoder shows better performance than the previously proposed decoders, with considerably less computational complexity. Furthermore, we improve the depth-specific augmentation method by utilizing an important observation in depth estimation to enhance the model. Our network achieves state-of-the-art performance over the challenging depth dataset NYU Depth V2. Extensive experiments have been conducted to validate and show the effectiveness of the proposed approach. Finally, our model shows better generalisation ability and robustness than other comparative models.</em>",ke,k,Gt,Fe,O,Nt='Summary of the approach. Taken from the <a href="https://arxiv.org/abs/2201.07436" target="_blank">original paper</a>.',Ze,K,Lt='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/vinvino02/GLPDepth" rel="nofollow">here</a>.',Re,ee,We,te,xt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with GLPN.",Be,oe,Ct='<li>Demo notebooks for <a href="/docs/transformers/pr_28250/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/GLPN" rel="nofollow">here</a>.</li> <li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li>',De,ne,He,P,se,ot,we,jt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_28250/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a>. It is used to instantiate an GLPN
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the GLPN
<a href="https://huggingface.co/vinvino02/glpn-kitti" rel="nofollow">vinvino02/glpn-kitti</a> architecture.`,nt,$e,Ut=`Configuration objects inherit from <a href="/docs/transformers/pr_28250/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_28250/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,st,F,Se,re,Xe,I,ae,rt,Z,ie,at,Me,It="Preprocess an image or a batch of images.",Ve,le,qe,L,de,it,Te,Jt="Constructs a GLPN image processor.",lt,R,ce,dt,Pe,Et="Preprocess the given images.",Ae,pe,Qe,x,me,ct,Ge,zt=`The bare GLPN encoder (Mix-Transformer) outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,pt,G,he,mt,Ne,kt='The <a href="/docs/transformers/pr_28250/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> forward method, overrides the <code>__call__</code> special method.',ht,W,ft,B,Ye,fe,Oe,C,ge,gt,Le,Ft=`GLPN Model transformer with a lightweight depth estimation head on top e.g. for KITTI, NYUv2.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ut,N,ue,_t,xe,Zt='The <a href="/docs/transformers/pr_28250/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',bt,D,yt,H,Ke,_e,et,Ue,tt;return v=new V({props:{title:"GLPN",local:"glpn",headingTag:"h1"}}),$=new vt({props:{$$slots:{default:[Vt]},$$scope:{ctx:M}}}),q=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ee=new V({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ne=new V({props:{title:"GLPNConfig",local:"transformers.GLPNConfig",headingTag:"h2"}}),se=new z({props:{name:"class transformers.GLPNConfig",anchor:"transformers.GLPNConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"num_encoder_blocks",val:" = 4"},{name:"depths",val:" = [2, 2, 2, 2]"},{name:"sr_ratios",val:" = [8, 4, 2, 1]"},{name:"hidden_sizes",val:" = [32, 64, 160, 256]"},{name:"patch_sizes",val:" = [7, 3, 3, 3]"},{name:"strides",val:" = [4, 2, 2, 2]"},{name:"num_attention_heads",val:" = [1, 2, 5, 8]"},{name:"mlp_ratios",val:" = [4, 4, 4, 4]"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"drop_path_rate",val:" = 0.1"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"decoder_hidden_size",val:" = 64"},{name:"max_depth",val:" = 10"},{name:"head_in_index",val:" = -1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.GLPNConfig.num_encoder_blocks",description:`<strong>num_encoder_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of encoder blocks (i.e. stages in the Mix Transformer encoder).`,name:"num_encoder_blocks"},{anchor:"transformers.GLPNConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2, 2]</code>) &#x2014;
The number of layers in each encoder block.`,name:"depths"},{anchor:"transformers.GLPNConfig.sr_ratios",description:`<strong>sr_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[8, 4, 2, 1]</code>) &#x2014;
Sequence reduction ratios in each encoder block.`,name:"sr_ratios"},{anchor:"transformers.GLPNConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 64, 160, 256]</code>) &#x2014;
Dimension of each of the encoder blocks.`,name:"hidden_sizes"},{anchor:"transformers.GLPNConfig.patch_sizes",description:`<strong>patch_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[7, 3, 3, 3]</code>) &#x2014;
Patch size before each encoder block.`,name:"patch_sizes"},{anchor:"transformers.GLPNConfig.strides",description:`<strong>strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 2, 2]</code>) &#x2014;
Stride before each encoder block.`,name:"strides"},{anchor:"transformers.GLPNConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 5, 8]</code>) &#x2014;
Number of attention heads for each attention layer in each block of the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.GLPNConfig.mlp_ratios",description:`<strong>mlp_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 4, 4, 4]</code>) &#x2014;
Ratio of the size of the hidden layer compared to the size of the input layer of the Mix FFNs in the
encoder blocks.`,name:"mlp_ratios"},{anchor:"transformers.GLPNConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.GLPNConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.GLPNConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.GLPNConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.GLPNConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for stochastic depth, used in the blocks of the Transformer encoder.`,name:"drop_path_rate"},{anchor:"transformers.GLPNConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GLPNConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The dimension of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.GLPNConfig.max_depth",description:`<strong>max_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The maximum depth of the decoder.`,name:"max_depth"},{anchor:"transformers.GLPNConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the head.`,name:"head_in_index"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/glpn/configuration_glpn.py#L24"}}),F=new wt({props:{anchor:"transformers.GLPNConfig.example",$$slots:{default:[qt]},$$scope:{ctx:M}}}),re=new V({props:{title:"GLPNFeatureExtractor",local:"transformers.GLPNFeatureExtractor",headingTag:"h2"}}),ae=new z({props:{name:"class transformers.GLPNFeatureExtractor",anchor:"transformers.GLPNFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/glpn/feature_extraction_glpn.py#L26"}}),ie=new z({props:{name:"__call__",anchor:"transformers.GLPNFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/image_processing_utils.py#L39"}}),le=new V({props:{title:"GLPNImageProcessor",local:"transformers.GLPNImageProcessor",headingTag:"h2"}}),de=new z({props:{name:"class transformers.GLPNImageProcessor",anchor:"transformers.GLPNImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:" = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions, rounding them down to the closest multiple of
<code>size_divisor</code>. Can be overridden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the closest
multiple of <code>size_divisor</code>. Can be overridden by <code>size_divisor</code> in <code>preprocess</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.). Can be
overridden by <code>do_rescale</code> in <code>preprocess</code>.`,name:"do_rescale"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/glpn/image_processing_glpn.py#L41"}}),ce=new z({props:{name:"preprocess",anchor:"transformers.GLPNImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": Optional = None"},{name:"size_divisor",val:": Optional = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code> or <code>TensorType</code> or <code>List[np.ndarray]</code> or <code>List[TensorType]</code>) &#x2014;
Images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_normalize=False</code>.`,name:"images"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the input such that the (height, width) dimensions are a multiple of <code>size_divisor</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.preprocess.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.size_divisor</code>) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the
closest multiple of <code>size_divisor</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PIL.Image</code> resampling filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.).`,name:"do_rescale"},{anchor:"transformers.GLPNImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>None</code>: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.GLPNImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GLPNImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/glpn/image_processing_glpn.py#L125"}}),pe=new V({props:{title:"GLPNModel",local:"transformers.GLPNModel",headingTag:"h2"}}),me=new z({props:{name:"class transformers.GLPNModel",anchor:"transformers.GLPNModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28250/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/glpn/modeling_glpn.py#L474"}}),he=new z({props:{name:"forward",anchor:"transformers.GLPNModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.GLPNModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_28250/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">GLPNImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.GLPNModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28250/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/glpn/modeling_glpn.py#L498",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28250/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28250/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28250/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),W=new vt({props:{$$slots:{default:[At]},$$scope:{ctx:M}}}),B=new wt({props:{anchor:"transformers.GLPNModel.forward.example",$$slots:{default:[Qt]},$$scope:{ctx:M}}}),fe=new V({props:{title:"GLPNForDepthEstimation",local:"transformers.GLPNForDepthEstimation",headingTag:"h2"}}),ge=new z({props:{name:"class transformers.GLPNForDepthEstimation",anchor:"transformers.GLPNForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28250/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/glpn/modeling_glpn.py#L675"}}),ue=new z({props:{name:"forward",anchor:"transformers.GLPNForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_28250/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">GLPNImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28250/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GLPNForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/glpn/modeling_glpn.py#L690",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28250/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28250/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28250/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new vt({props:{$$slots:{default:[Yt]},$$scope:{ctx:M}}}),H=new wt({props:{anchor:"transformers.GLPNForDepthEstimation.forward.example",$$slots:{default:[Ot]},$$scope:{ctx:M}}}),_e=new Xt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/glpn.md"}}),{c(){n=d("meta"),y=a(),l=d("p"),p=a(),h(v.$$.fragment),s=a(),h($.$$.fragment),Ie=a(),h(q.$$.fragment),Je=a(),A=d("p"),A.innerHTML=Mt,Ee=a(),Q=d("p"),Q.textContent=Tt,ze=a(),Y=d("p"),Y.innerHTML=Pt,ke=a(),k=d("img"),Fe=a(),O=d("small"),O.innerHTML=Nt,Ze=a(),K=d("p"),K.innerHTML=Lt,Re=a(),h(ee.$$.fragment),We=a(),te=d("p"),te.textContent=xt,Be=a(),oe=d("ul"),oe.innerHTML=Ct,De=a(),h(ne.$$.fragment),He=a(),P=d("div"),h(se.$$.fragment),ot=a(),we=d("p"),we.innerHTML=jt,nt=a(),$e=d("p"),$e.innerHTML=Ut,st=a(),h(F.$$.fragment),Se=a(),h(re.$$.fragment),Xe=a(),I=d("div"),h(ae.$$.fragment),rt=a(),Z=d("div"),h(ie.$$.fragment),at=a(),Me=d("p"),Me.textContent=It,Ve=a(),h(le.$$.fragment),qe=a(),L=d("div"),h(de.$$.fragment),it=a(),Te=d("p"),Te.textContent=Jt,lt=a(),R=d("div"),h(ce.$$.fragment),dt=a(),Pe=d("p"),Pe.textContent=Et,Ae=a(),h(pe.$$.fragment),Qe=a(),x=d("div"),h(me.$$.fragment),ct=a(),Ge=d("p"),Ge.innerHTML=zt,pt=a(),G=d("div"),h(he.$$.fragment),mt=a(),Ne=d("p"),Ne.innerHTML=kt,ht=a(),h(W.$$.fragment),ft=a(),h(B.$$.fragment),Ye=a(),h(fe.$$.fragment),Oe=a(),C=d("div"),h(ge.$$.fragment),gt=a(),Le=d("p"),Le.innerHTML=Ft,ut=a(),N=d("div"),h(ue.$$.fragment),_t=a(),xe=d("p"),xe.innerHTML=Zt,bt=a(),h(D.$$.fragment),yt=a(),h(H.$$.fragment),Ke=a(),h(_e.$$.fragment),et=a(),Ue=d("p"),this.h()},l(e){const t=St("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),y=i(e),l=c(e,"P",{}),U(l).forEach(o),p=i(e),f(v.$$.fragment,e),s=i(e),f($.$$.fragment,e),Ie=i(e),f(q.$$.fragment,e),Je=i(e),A=c(e,"P",{"data-svelte-h":!0}),w(A)!=="svelte-1rdmycr"&&(A.innerHTML=Mt),Ee=i(e),Q=c(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-vfdo9a"&&(Q.textContent=Tt),ze=i(e),Y=c(e,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-l8ay4x"&&(Y.innerHTML=Pt),ke=i(e),k=c(e,"IMG",{src:!0,alt:!0,width:!0}),Fe=i(e),O=c(e,"SMALL",{"data-svelte-h":!0}),w(O)!=="svelte-bacs7t"&&(O.innerHTML=Nt),Ze=i(e),K=c(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-1grdklu"&&(K.innerHTML=Lt),Re=i(e),f(ee.$$.fragment,e),We=i(e),te=c(e,"P",{"data-svelte-h":!0}),w(te)!=="svelte-fq64ti"&&(te.textContent=xt),Be=i(e),oe=c(e,"UL",{"data-svelte-h":!0}),w(oe)!=="svelte-6e4f9h"&&(oe.innerHTML=Ct),De=i(e),f(ne.$$.fragment,e),He=i(e),P=c(e,"DIV",{class:!0});var j=U(P);f(se.$$.fragment,j),ot=i(j),we=c(j,"P",{"data-svelte-h":!0}),w(we)!=="svelte-1fv9bdj"&&(we.innerHTML=jt),nt=i(j),$e=c(j,"P",{"data-svelte-h":!0}),w($e)!=="svelte-k8tpvv"&&($e.innerHTML=Ut),st=i(j),f(F.$$.fragment,j),j.forEach(o),Se=i(e),f(re.$$.fragment,e),Xe=i(e),I=c(e,"DIV",{class:!0});var be=U(I);f(ae.$$.fragment,be),rt=i(be),Z=c(be,"DIV",{class:!0});var ye=U(Z);f(ie.$$.fragment,ye),at=i(ye),Me=c(ye,"P",{"data-svelte-h":!0}),w(Me)!=="svelte-khengj"&&(Me.textContent=It),ye.forEach(o),be.forEach(o),Ve=i(e),f(le.$$.fragment,e),qe=i(e),L=c(e,"DIV",{class:!0});var J=U(L);f(de.$$.fragment,J),it=i(J),Te=c(J,"P",{"data-svelte-h":!0}),w(Te)!=="svelte-1e6g6g5"&&(Te.textContent=Jt),lt=i(J),R=c(J,"DIV",{class:!0});var ve=U(R);f(ce.$$.fragment,ve),dt=i(ve),Pe=c(ve,"P",{"data-svelte-h":!0}),w(Pe)!=="svelte-tvrlms"&&(Pe.textContent=Et),ve.forEach(o),J.forEach(o),Ae=i(e),f(pe.$$.fragment,e),Qe=i(e),x=c(e,"DIV",{class:!0});var E=U(x);f(me.$$.fragment,E),ct=i(E),Ge=c(E,"P",{"data-svelte-h":!0}),w(Ge)!=="svelte-dvd88g"&&(Ge.innerHTML=zt),pt=i(E),G=c(E,"DIV",{class:!0});var S=U(G);f(he.$$.fragment,S),mt=i(S),Ne=c(S,"P",{"data-svelte-h":!0}),w(Ne)!=="svelte-1gk4vnn"&&(Ne.innerHTML=kt),ht=i(S),f(W.$$.fragment,S),ft=i(S),f(B.$$.fragment,S),S.forEach(o),E.forEach(o),Ye=i(e),f(fe.$$.fragment,e),Oe=i(e),C=c(e,"DIV",{class:!0});var Ce=U(C);f(ge.$$.fragment,Ce),gt=i(Ce),Le=c(Ce,"P",{"data-svelte-h":!0}),w(Le)!=="svelte-1ec4khr"&&(Le.innerHTML=Ft),ut=i(Ce),N=c(Ce,"DIV",{class:!0});var X=U(N);f(ue.$$.fragment,X),_t=i(X),xe=c(X,"P",{"data-svelte-h":!0}),w(xe)!=="svelte-dlwmq7"&&(xe.innerHTML=Zt),bt=i(X),f(D.$$.fragment,X),yt=i(X),f(H.$$.fragment,X),X.forEach(o),Ce.forEach(o),Ke=i(e),f(_e.$$.fragment,e),et=i(e),Ue=c(e,"P",{}),U(Ue).forEach(o),this.h()},h(){T(n,"name","hf:doc:metadata"),T(n,"content",eo),Wt(k.src,Gt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/glpn_architecture.jpg")||T(k,"src",Gt),T(k,"alt","drawing"),T(k,"width","600"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,n),r(e,y,t),r(e,l,t),r(e,p,t),g(v,e,t),r(e,s,t),g($,e,t),r(e,Ie,t),g(q,e,t),r(e,Je,t),r(e,A,t),r(e,Ee,t),r(e,Q,t),r(e,ze,t),r(e,Y,t),r(e,ke,t),r(e,k,t),r(e,Fe,t),r(e,O,t),r(e,Ze,t),r(e,K,t),r(e,Re,t),g(ee,e,t),r(e,We,t),r(e,te,t),r(e,Be,t),r(e,oe,t),r(e,De,t),g(ne,e,t),r(e,He,t),r(e,P,t),g(se,P,null),m(P,ot),m(P,we),m(P,nt),m(P,$e),m(P,st),g(F,P,null),r(e,Se,t),g(re,e,t),r(e,Xe,t),r(e,I,t),g(ae,I,null),m(I,rt),m(I,Z),g(ie,Z,null),m(Z,at),m(Z,Me),r(e,Ve,t),g(le,e,t),r(e,qe,t),r(e,L,t),g(de,L,null),m(L,it),m(L,Te),m(L,lt),m(L,R),g(ce,R,null),m(R,dt),m(R,Pe),r(e,Ae,t),g(pe,e,t),r(e,Qe,t),r(e,x,t),g(me,x,null),m(x,ct),m(x,Ge),m(x,pt),m(x,G),g(he,G,null),m(G,mt),m(G,Ne),m(G,ht),g(W,G,null),m(G,ft),g(B,G,null),r(e,Ye,t),g(fe,e,t),r(e,Oe,t),r(e,C,t),g(ge,C,null),m(C,gt),m(C,Le),m(C,ut),m(C,N),g(ue,N,null),m(N,_t),m(N,xe),m(N,bt),g(D,N,null),m(N,yt),g(H,N,null),r(e,Ke,t),g(_e,e,t),r(e,et,t),r(e,Ue,t),tt=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),$.$set(j);const be={};t&2&&(be.$$scope={dirty:t,ctx:e}),F.$set(be);const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),W.$set(ye);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),B.$set(J);const ve={};t&2&&(ve.$$scope={dirty:t,ctx:e}),D.$set(ve);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),H.$set(E)},i(e){tt||(u(v.$$.fragment,e),u($.$$.fragment,e),u(q.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(F.$$.fragment,e),u(re.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(D.$$.fragment,e),u(H.$$.fragment,e),u(_e.$$.fragment,e),tt=!0)},o(e){_(v.$$.fragment,e),_($.$$.fragment,e),_(q.$$.fragment,e),_(ee.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(F.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(W.$$.fragment,e),_(B.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(D.$$.fragment,e),_(H.$$.fragment,e),_(_e.$$.fragment,e),tt=!1},d(e){e&&(o(y),o(l),o(p),o(s),o(Ie),o(Je),o(A),o(Ee),o(Q),o(ze),o(Y),o(ke),o(k),o(Fe),o(O),o(Ze),o(K),o(Re),o(We),o(te),o(Be),o(oe),o(De),o(He),o(P),o(Se),o(Xe),o(I),o(Ve),o(qe),o(L),o(Ae),o(Qe),o(x),o(Ye),o(Oe),o(C),o(Ke),o(et),o(Ue)),o(n),b(v,e),b($,e),b(q,e),b(ee,e),b(ne,e),b(se),b(F),b(re,e),b(ae),b(ie),b(le,e),b(de),b(ce),b(pe,e),b(me),b(he),b(W),b(B),b(fe,e),b(ge),b(ue),b(D),b(H),b(_e,e)}}}const eo='{"title":"GLPN","local":"glpn","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"GLPNConfig","local":"transformers.GLPNConfig","sections":[],"depth":2},{"title":"GLPNFeatureExtractor","local":"transformers.GLPNFeatureExtractor","sections":[],"depth":2},{"title":"GLPNImageProcessor","local":"transformers.GLPNImageProcessor","sections":[],"depth":2},{"title":"GLPNModel","local":"transformers.GLPNModel","sections":[],"depth":2},{"title":"GLPNForDepthEstimation","local":"transformers.GLPNForDepthEstimation","sections":[],"depth":2}],"depth":1}';function to(M){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class co extends Dt{constructor(n){super(),Ht(this,n,to,Kt,Rt,{})}}export{co as component};
