import{s as to,o as oo,n as ve}from"../chunks/scheduler.25b97de1.js";import{S as no,i as ao,g as l,s,r as h,A as so,h as c,f as n,c as r,j as q,u,x as m,k as F,y as i,a as d,v as f,d as g,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as Ne}from"../chunks/Tip.baa67368.js";import{D as j}from"../chunks/Docstring.e257edda.js";import{C as eo}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Kt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as be,E as ro}from"../chunks/EditOnGithub.91d95064.js";function io(w){let t,p='<li>Gemma2 uses sliding window attention every second layer, which makes it unsuitable for typical kv caching with <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.DynamicCache">~DynamicCache</a> or tuples of tensors. To enable caching in Gemma2 forward call, you must initialize a <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.HybridCache">~HybridCache</a> instance and pass it as <code>past_key_values</code> to the forward call. Note, that you also have to prepare <code>cache_position</code> if the <code>past_key_values</code> already contains previous keys and values.</li>';return{c(){t=l("ul"),t.innerHTML=p},l(a){t=c(a,"UL",{"data-svelte-h":!0}),m(t)!=="svelte-1rh0phk"&&(t.innerHTML=p)},m(a,v){d(a,t,v)},p:ve,d(a){a&&n(t)}}}function lo(w){let t,p;return t=new eo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbW1hMk1vZGVsJTJDJTIwR2VtbWEyQ29uZmlnJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEdlbW1hMiUyMGdlbW1hMi05YiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBHZW1tYTJDb25maWcoKSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBnZW1tYTItOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdlbW1hMk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Gemma2Model, Gemma2Config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Gemma2 gemma2-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Gemma2Config()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the gemma2-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Gemma2Model(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(t.$$.fragment)},l(a){u(t.$$.fragment,a)},m(a,v){f(t,a,v),p=!0},p:ve,i(a){p||(g(t.$$.fragment,a),p=!0)},o(a){_(t.$$.fragment,a),p=!1},d(a){b(t,a)}}}function co(w){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=p},l(a){t=c(a,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(a,v){d(a,t,v)},p:ve,d(a){a&&n(t)}}}function mo(w){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=p},l(a){t=c(a,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(a,v){d(a,t,v)},p:ve,d(a){a&&n(t)}}}function po(w){let t,p="Example:",a,v,G;return v=new eo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHZW1tYUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBHZW1tYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYS0yLTliJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTItOWIlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMGZhdm9yaXRlJTIwY29uZGltZW50JTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, GemmaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = GemmaForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-9b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-9b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>`,wrap:!1}}),{c(){t=l("p"),t.textContent=p,a=s(),h(v.$$.fragment)},l(y){t=c(y,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=p),a=r(y),u(v.$$.fragment,y)},m(y,x){d(y,t,x),d(y,a,x),f(v,y,x),G=!0},p:ve,i(y){G||(g(v.$$.fragment,y),G=!0)},o(y){_(v.$$.fragment,y),G=!1},d(y){y&&(n(t),n(a)),b(v,y)}}}function ho(w){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=p},l(a){t=c(a,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(a,v){d(a,t,v)},p:ve,d(a){a&&n(t)}}}function uo(w){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=p},l(a){t=c(a,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(a,v){d(a,t,v)},p:ve,d(a){a&&n(t)}}}function fo(w){let t,p,a,v,G,y,x,Be,X,Lt=`The Gemma2 model was proposed in <a href="https://blog.google/technology/developers/google-gemma-2/" rel="nofollow">Gemma2: Open Models Based on Gemini Technology and Research</a> by Gemma2 Team, Google.
Two Gemma2 models are released, with parameters sizes of 9 billion (9B) and 27 billion (27B).`,Je,Y,qt="The abstract from the blog post is the following:",Oe,Q,Ft="<em>Now we’re officially releasing Gemma 2 to researchers and developers globally. Available in both 9 billion (9B) and 27 billion (27B) parameter sizes, Gemma 2 is higher-performing and more efficient at inference than the first generation, with significant safety advancements built in. In fact, at 27B, it offers competitive alternatives to models more than twice its size, delivering the kind of performance that was only possible with proprietary models as recently as December.</em>",je,K,Pt="Tips:",Ue,ee,Wt="<li>The original checkpoints can be converted using the conversion script <code>src/transformers/models/Gemma2/convert_Gemma2_weights_to_hf.py</code></li>",Ze,U,Ae,te,Ht='This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>, <a href="https://huggingface.co/pcuenq" rel="nofollow">Pedro Cuenca</a> and <a href="">Tom Arsen</a>.',Ee,oe,De,I,ne,st,ye,St=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2Model">Gemma2Model</a>. It is used to instantiate an Gemma2
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Gemma2-7B.
e.g. <a href="https://huggingface.co/google/gemma2-7b" rel="nofollow">google/gemma2-7b</a>
Configuration objects inherit from <a href="/docs/transformers/pr_28250/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_28250/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,rt,Z,Re,ae,Ve,$,se,it,Te,Nt=`The bare Gemma2 Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,dt,ke,Bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,lt,we,Jt="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>Gemma2DecoderLayer</code>",ct,P,re,mt,$e,Ot='The <a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2Model">Gemma2Model</a> forward method, overrides the <code>__call__</code> special method.',pt,A,Xe,ie,Ye,N,de,ht,z,le,ut,Me,jt='The <a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2ForCausalLM">Gemma2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',ft,E,gt,D,Qe,ce,Ke,T,me,_t,Ce,Ut="The Gemma2 Model transformer with a sequence classification head on top (linear layer).",bt,Ge,Zt=`<a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2ForSequenceClassification">Gemma2ForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,vt,ze,At=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,yt,xe,Et=`This model inherits from <a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Tt,Ie,Dt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,kt,W,pe,wt,Le,Rt='The <a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2ForSequenceClassification">Gemma2ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',$t,R,et,he,tt,M,ue,Mt,qe,Vt=`The Gemma2 Model transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,Ct,Fe,Xt=`This model inherits from <a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Gt,Pe,Yt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zt,H,fe,xt,We,Qt='The <a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2ForTokenClassification">Gemma2ForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',It,V,ot,ge,nt,Se,at;return G=new be({props:{title:"Gemma2",local:"gemma2",headingTag:"h1"}}),x=new be({props:{title:"Overview",local:"overview",headingTag:"h2"}}),U=new Ne({props:{warning:!0,$$slots:{default:[io]},$$scope:{ctx:w}}}),oe=new be({props:{title:"Gemma2Config",local:"transformers.Gemma2Config",headingTag:"h2"}}),ne=new j({props:{name:"class transformers.Gemma2Config",anchor:"transformers.Gemma2Config",parameters:[{name:"vocab_size",val:" = 256000"},{name:"hidden_size",val:" = 3072"},{name:"intermediate_size",val:" = 24576"},{name:"num_hidden_layers",val:" = 28"},{name:"num_attention_heads",val:" = 16"},{name:"num_key_value_heads",val:" = 16"},{name:"head_dim",val:" = 256"},{name:"hidden_activation",val:" = 'gelu_pytorch_tanh'"},{name:"max_position_embeddings",val:" = 8192"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"bos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"final_logit_softcapping",val:" = 30.0"},{name:"attn_logit_softcapping",val:" = 50.0"},{name:"query_pre_attn_scalar",val:" = 224"},{name:"sliding_window",val:" = 4096"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Gemma2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256000) &#x2014;
Vocabulary size of the Gemma2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2Model">Gemma2Model</a>`,name:"vocab_size"},{anchor:"transformers.Gemma2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Gemma2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 24576) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Gemma2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 28) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.Gemma2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.Gemma2Config.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.Gemma2Config.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The attention head dimension.`,name:"head_dim"},{anchor:"transformers.Gemma2Config.hidden_activation",description:`<strong>hidden_activation</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_activation"},{anchor:"transformers.Gemma2Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.Gemma2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Gemma2Config.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.Gemma2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Gemma2Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.Gemma2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.Gemma2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.Gemma2Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.Gemma2Config.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Gemma2Config.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.Gemma2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Gemma2Config.final_logit_softcapping",description:"<strong>final_logit_softcapping</strong> (<code>float</code>, <em>optional</em>, defaults to 30.0) &#x2014; scaling factor when applying tanh softcapping on the logits.",name:"final_logit_softcapping"},{anchor:"transformers.Gemma2Config.attn_logit_softcapping",description:"<strong>attn_logit_softcapping</strong> (<code>float</code>, <em>optional</em>, defaults to 50.0) &#x2014; scaling factor when applying tanh softcapping on the attention scores.",name:"attn_logit_softcapping"},{anchor:"transformers.Gemma2Config.query_pre_attn_scalar",description:"<strong>query_pre_attn_scalar</strong> (<code>float</code>, <em>optional</em>, defaults to 224) &#x2014; scaling factor used on the attention scores",name:"query_pre_attn_scalar"},{anchor:"transformers.Gemma2Config.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014; in Gemma2, every other layer uses sliding window attention. This is the
size of the sliding window.`,name:"sliding_window"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/configuration_gemma2.py#L25"}}),Z=new Kt({props:{anchor:"transformers.Gemma2Config.example",$$slots:{default:[lo]},$$scope:{ctx:w}}}),ae=new be({props:{title:"Gemma2Model",local:"transformers.Gemma2Model",headingTag:"h2"}}),se=new j({props:{name:"class transformers.Gemma2Model",anchor:"transformers.Gemma2Model",parameters:[{name:"config",val:": Gemma2Config"}],parametersDescription:[{anchor:"transformers.Gemma2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2Config">Gemma2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; Gemma2Config`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/modeling_gemma2.py#L752"}}),re=new j({props:{name:"forward",anchor:"transformers.Gemma2Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Gemma2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Gemma2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Gemma2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Gemma2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Gemma2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Gemma2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Gemma2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Gemma2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Gemma2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28250/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Gemma2Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/modeling_gemma2.py#L785"}}),A=new Ne({props:{$$slots:{default:[co]},$$scope:{ctx:w}}}),ie=new be({props:{title:"Gemma2ForCausalLM",local:"transformers.Gemma2ForCausalLM",headingTag:"h2"}}),de=new j({props:{name:"class transformers.Gemma2ForCausalLM",anchor:"transformers.Gemma2ForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/modeling_gemma2.py#L946"}}),le=new j({props:{name:"forward",anchor:"transformers.Gemma2ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"},{name:"num_logits_to_keep",val:": int = 0"}],parametersDescription:[{anchor:"transformers.Gemma2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Gemma2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Gemma2ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Gemma2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Gemma2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Gemma2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Gemma2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Gemma2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Gemma2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28250/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Gemma2ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/modeling_gemma2.py#L976",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28250/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2Config"
>Gemma2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28250/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Ne({props:{$$slots:{default:[mo]},$$scope:{ctx:w}}}),D=new Kt({props:{anchor:"transformers.Gemma2ForCausalLM.forward.example",$$slots:{default:[po]},$$scope:{ctx:w}}}),ce=new be({props:{title:"Gemma2ForSequenceClassification",local:"transformers.Gemma2ForSequenceClassification",headingTag:"h2"}}),me=new j({props:{name:"class transformers.Gemma2ForSequenceClassification",anchor:"transformers.Gemma2ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Gemma2ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2Config">Gemma2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/modeling_gemma2.py#L1167"}}),pe=new j({props:{name:"forward",anchor:"transformers.Gemma2ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Gemma2ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28250/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/modeling_gemma2.py#L1198"}}),R=new Ne({props:{$$slots:{default:[ho]},$$scope:{ctx:w}}}),he=new be({props:{title:"Gemma2ForTokenClassification",local:"transformers.Gemma2ForTokenClassification",headingTag:"h2"}}),ue=new j({props:{name:"class transformers.Gemma2ForTokenClassification",anchor:"transformers.Gemma2ForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Gemma2ForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28250/en/model_doc/gemma2#transformers.Gemma2Config">Gemma2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/modeling_gemma2.py#L1290"}}),fe=new j({props:{name:"forward",anchor:"transformers.Gemma2ForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Gemma2ForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Gemma2ForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_28250/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Gemma2ForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Gemma2ForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Gemma2ForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Gemma2ForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Gemma2ForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Gemma2ForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Gemma2ForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28250/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Gemma2ForTokenClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Gemma2ForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/gemma2/modeling_gemma2.py#L1320"}}),V=new Ne({props:{$$slots:{default:[uo]},$$scope:{ctx:w}}}),ge=new ro({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/gemma2.md"}}),{c(){t=l("meta"),p=s(),a=l("p"),v=s(),h(G.$$.fragment),y=s(),h(x.$$.fragment),Be=s(),X=l("p"),X.innerHTML=Lt,Je=s(),Y=l("p"),Y.textContent=qt,Oe=s(),Q=l("p"),Q.innerHTML=Ft,je=s(),K=l("p"),K.textContent=Pt,Ue=s(),ee=l("ul"),ee.innerHTML=Wt,Ze=s(),h(U.$$.fragment),Ae=s(),te=l("p"),te.innerHTML=Ht,Ee=s(),h(oe.$$.fragment),De=s(),I=l("div"),h(ne.$$.fragment),st=s(),ye=l("p"),ye.innerHTML=St,rt=s(),h(Z.$$.fragment),Re=s(),h(ae.$$.fragment),Ve=s(),$=l("div"),h(se.$$.fragment),it=s(),Te=l("p"),Te.innerHTML=Nt,dt=s(),ke=l("p"),ke.innerHTML=Bt,lt=s(),we=l("p"),we.innerHTML=Jt,ct=s(),P=l("div"),h(re.$$.fragment),mt=s(),$e=l("p"),$e.innerHTML=Ot,pt=s(),h(A.$$.fragment),Xe=s(),h(ie.$$.fragment),Ye=s(),N=l("div"),h(de.$$.fragment),ht=s(),z=l("div"),h(le.$$.fragment),ut=s(),Me=l("p"),Me.innerHTML=jt,ft=s(),h(E.$$.fragment),gt=s(),h(D.$$.fragment),Qe=s(),h(ce.$$.fragment),Ke=s(),T=l("div"),h(me.$$.fragment),_t=s(),Ce=l("p"),Ce.textContent=Ut,bt=s(),Ge=l("p"),Ge.innerHTML=Zt,vt=s(),ze=l("p"),ze.innerHTML=At,yt=s(),xe=l("p"),xe.innerHTML=Et,Tt=s(),Ie=l("p"),Ie.innerHTML=Dt,kt=s(),W=l("div"),h(pe.$$.fragment),wt=s(),Le=l("p"),Le.innerHTML=Rt,$t=s(),h(R.$$.fragment),et=s(),h(he.$$.fragment),tt=s(),M=l("div"),h(ue.$$.fragment),Mt=s(),qe=l("p"),qe.textContent=Vt,Ct=s(),Fe=l("p"),Fe.innerHTML=Xt,Gt=s(),Pe=l("p"),Pe.innerHTML=Yt,zt=s(),H=l("div"),h(fe.$$.fragment),xt=s(),We=l("p"),We.innerHTML=Qt,It=s(),h(V.$$.fragment),ot=s(),h(ge.$$.fragment),nt=s(),Se=l("p"),this.h()},l(e){const o=so("svelte-u9bgzb",document.head);t=c(o,"META",{name:!0,content:!0}),o.forEach(n),p=r(e),a=c(e,"P",{}),q(a).forEach(n),v=r(e),u(G.$$.fragment,e),y=r(e),u(x.$$.fragment,e),Be=r(e),X=c(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-qvin01"&&(X.innerHTML=Lt),Je=r(e),Y=c(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1b31asq"&&(Y.textContent=qt),Oe=r(e),Q=c(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-rpvfx1"&&(Q.innerHTML=Ft),je=r(e),K=c(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-axv494"&&(K.textContent=Pt),Ue=r(e),ee=c(e,"UL",{"data-svelte-h":!0}),m(ee)!=="svelte-1khublo"&&(ee.innerHTML=Wt),Ze=r(e),u(U.$$.fragment,e),Ae=r(e),te=c(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1ogb02t"&&(te.innerHTML=Ht),Ee=r(e),u(oe.$$.fragment,e),De=r(e),I=c(e,"DIV",{class:!0});var B=q(I);u(ne.$$.fragment,B),st=r(B),ye=c(B,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-yl0uhb"&&(ye.innerHTML=St),rt=r(B),u(Z.$$.fragment,B),B.forEach(n),Re=r(e),u(ae.$$.fragment,e),Ve=r(e),$=c(e,"DIV",{class:!0});var C=q($);u(se.$$.fragment,C),it=r(C),Te=c(C,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-b43v4w"&&(Te.innerHTML=Nt),dt=r(C),ke=c(C,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-hswkmf"&&(ke.innerHTML=Bt),lt=r(C),we=c(C,"P",{"data-svelte-h":!0}),m(we)!=="svelte-vk10ns"&&(we.innerHTML=Jt),ct=r(C),P=c(C,"DIV",{class:!0});var J=q(P);u(re.$$.fragment,J),mt=r(J),$e=c(J,"P",{"data-svelte-h":!0}),m($e)!=="svelte-x80d8r"&&($e.innerHTML=Ot),pt=r(J),u(A.$$.fragment,J),J.forEach(n),C.forEach(n),Xe=r(e),u(ie.$$.fragment,e),Ye=r(e),N=c(e,"DIV",{class:!0});var _e=q(N);u(de.$$.fragment,_e),ht=r(_e),z=c(_e,"DIV",{class:!0});var L=q(z);u(le.$$.fragment,L),ut=r(L),Me=c(L,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1or8cl7"&&(Me.innerHTML=jt),ft=r(L),u(E.$$.fragment,L),gt=r(L),u(D.$$.fragment,L),L.forEach(n),_e.forEach(n),Qe=r(e),u(ce.$$.fragment,e),Ke=r(e),T=c(e,"DIV",{class:!0});var k=q(T);u(me.$$.fragment,k),_t=r(k),Ce=c(k,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-m8ld61"&&(Ce.textContent=Ut),bt=r(k),Ge=c(k,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-a33any"&&(Ge.innerHTML=Zt),vt=r(k),ze=c(k,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-10ugs3m"&&(ze.innerHTML=At),yt=r(k),xe=c(k,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-d6e17d"&&(xe.innerHTML=Et),Tt=r(k),Ie=c(k,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-hswkmf"&&(Ie.innerHTML=Dt),kt=r(k),W=c(k,"DIV",{class:!0});var O=q(W);u(pe.$$.fragment,O),wt=r(O),Le=c(O,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-1j7w88n"&&(Le.innerHTML=Rt),$t=r(O),u(R.$$.fragment,O),O.forEach(n),k.forEach(n),et=r(e),u(he.$$.fragment,e),tt=r(e),M=c(e,"DIV",{class:!0});var S=q(M);u(ue.$$.fragment,S),Mt=r(S),qe=c(S,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1f58hu4"&&(qe.textContent=Vt),Ct=r(S),Fe=c(S,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-d6e17d"&&(Fe.innerHTML=Xt),Gt=r(S),Pe=c(S,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-hswkmf"&&(Pe.innerHTML=Yt),zt=r(S),H=c(S,"DIV",{class:!0});var He=q(H);u(fe.$$.fragment,He),xt=r(He),We=c(He,"P",{"data-svelte-h":!0}),m(We)!=="svelte-ethpph"&&(We.innerHTML=Qt),It=r(He),u(V.$$.fragment,He),He.forEach(n),S.forEach(n),ot=r(e),u(ge.$$.fragment,e),nt=r(e),Se=c(e,"P",{}),q(Se).forEach(n),this.h()},h(){F(t,"name","hf:doc:metadata"),F(t,"content",go),F(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,t),d(e,p,o),d(e,a,o),d(e,v,o),f(G,e,o),d(e,y,o),f(x,e,o),d(e,Be,o),d(e,X,o),d(e,Je,o),d(e,Y,o),d(e,Oe,o),d(e,Q,o),d(e,je,o),d(e,K,o),d(e,Ue,o),d(e,ee,o),d(e,Ze,o),f(U,e,o),d(e,Ae,o),d(e,te,o),d(e,Ee,o),f(oe,e,o),d(e,De,o),d(e,I,o),f(ne,I,null),i(I,st),i(I,ye),i(I,rt),f(Z,I,null),d(e,Re,o),f(ae,e,o),d(e,Ve,o),d(e,$,o),f(se,$,null),i($,it),i($,Te),i($,dt),i($,ke),i($,lt),i($,we),i($,ct),i($,P),f(re,P,null),i(P,mt),i(P,$e),i(P,pt),f(A,P,null),d(e,Xe,o),f(ie,e,o),d(e,Ye,o),d(e,N,o),f(de,N,null),i(N,ht),i(N,z),f(le,z,null),i(z,ut),i(z,Me),i(z,ft),f(E,z,null),i(z,gt),f(D,z,null),d(e,Qe,o),f(ce,e,o),d(e,Ke,o),d(e,T,o),f(me,T,null),i(T,_t),i(T,Ce),i(T,bt),i(T,Ge),i(T,vt),i(T,ze),i(T,yt),i(T,xe),i(T,Tt),i(T,Ie),i(T,kt),i(T,W),f(pe,W,null),i(W,wt),i(W,Le),i(W,$t),f(R,W,null),d(e,et,o),f(he,e,o),d(e,tt,o),d(e,M,o),f(ue,M,null),i(M,Mt),i(M,qe),i(M,Ct),i(M,Fe),i(M,Gt),i(M,Pe),i(M,zt),i(M,H),f(fe,H,null),i(H,xt),i(H,We),i(H,It),f(V,H,null),d(e,ot,o),f(ge,e,o),d(e,nt,o),d(e,Se,o),at=!0},p(e,[o]){const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),U.$set(B);const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),Z.$set(C);const J={};o&2&&(J.$$scope={dirty:o,ctx:e}),A.$set(J);const _e={};o&2&&(_e.$$scope={dirty:o,ctx:e}),E.$set(_e);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),D.$set(L);const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),R.$set(k);const O={};o&2&&(O.$$scope={dirty:o,ctx:e}),V.$set(O)},i(e){at||(g(G.$$.fragment,e),g(x.$$.fragment,e),g(U.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(Z.$$.fragment,e),g(ae.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(A.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(le.$$.fragment,e),g(E.$$.fragment,e),g(D.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(R.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(V.$$.fragment,e),g(ge.$$.fragment,e),at=!0)},o(e){_(G.$$.fragment,e),_(x.$$.fragment,e),_(U.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(Z.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(A.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(le.$$.fragment,e),_(E.$$.fragment,e),_(D.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(R.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(V.$$.fragment,e),_(ge.$$.fragment,e),at=!1},d(e){e&&(n(p),n(a),n(v),n(y),n(Be),n(X),n(Je),n(Y),n(Oe),n(Q),n(je),n(K),n(Ue),n(ee),n(Ze),n(Ae),n(te),n(Ee),n(De),n(I),n(Re),n(Ve),n($),n(Xe),n(Ye),n(N),n(Qe),n(Ke),n(T),n(et),n(tt),n(M),n(ot),n(nt),n(Se)),n(t),b(G,e),b(x,e),b(U,e),b(oe,e),b(ne),b(Z),b(ae,e),b(se),b(re),b(A),b(ie,e),b(de),b(le),b(E),b(D),b(ce,e),b(me),b(pe),b(R),b(he,e),b(ue),b(fe),b(V),b(ge,e)}}}const go='{"title":"Gemma2","local":"gemma2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Gemma2Config","local":"transformers.Gemma2Config","sections":[],"depth":2},{"title":"Gemma2Model","local":"transformers.Gemma2Model","sections":[],"depth":2},{"title":"Gemma2ForCausalLM","local":"transformers.Gemma2ForCausalLM","sections":[],"depth":2},{"title":"Gemma2ForSequenceClassification","local":"transformers.Gemma2ForSequenceClassification","sections":[],"depth":2},{"title":"Gemma2ForTokenClassification","local":"transformers.Gemma2ForTokenClassification","sections":[],"depth":2}],"depth":1}';function _o(w){return oo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mo extends no{constructor(t){super(),ao(this,t,_o,fo,to,{})}}export{Mo as component};
